-- Copyright (C) 2005 - Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-------------------------------------------------------------------------------
--                                                                           --
-- Containing Verilog Model for the Atoms:                                   --
--                                                                           --
--                         stratixiigx_hssi_receiver                         --
--                         stratixiigx_hssi_transmitter                      --
--                         stratixiigx_hssi_central_management_unit          --
--                         stratixiigx_hssi_cmu_pll                          --
--                         stratixiigx_hssi_cmu_clock_divider                --
--                         stratixiigx_hssi_refclk_divider                   --
--                         stratixiigx_hssi_calibration_block                --
--                                                                           --
-------------------------------------------------------------------------------




LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;


ENTITY stratixiigx_hssi_aux_clock_div IS
    GENERIC (
        clk_divide_by : INTEGER := 1;
        extra_latency : INTEGER := 0
    );
    PORT (
        clk                     : IN STD_LOGIC;   
        reset                   : IN STD_LOGIC := '0';  
        powerdown               : IN STD_LOGIC := '0'; 
        enable_d                : IN STD_LOGIC := '0';
        d                       : IN STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000001";
        clkout                  : OUT STD_LOGIC
    );   
END stratixiigx_hssi_aux_clock_div;

ARCHITECTURE clock_div_arch OF stratixiigx_hssi_aux_clock_div IS  
    SIGNAL clk_edges                :  INTEGER := -1;     
    SIGNAL div_n_register           :  STD_LOGIC_VECTOR(2 * extra_latency DOWNTO 0)
                                                    := (OTHERS => '0');     
    SIGNAL d_factor : INTEGER := 1;
    FUNCTION to_int(arg : IN STD_LOGIC_VECTOR) RETURN INTEGER IS
    VARIABLE result : INTEGER;
    BEGIN
    result := 0;
    FOR i IN arg'RANGE LOOP
        IF arg(i) = '1' THEN
            result := result + 2**i;
        END IF;
    END LOOP;
    RETURN result;
    END to_int;

BEGIN

    d_factor <= to_int(d) WHEN (enable_d = '1') ELSE clk_divide_by;

    PROCESS(clk,reset,d_factor,powerdown)
    VARIABLE div_n : STD_LOGIC_VECTOR(2 * extra_latency DOWNTO 0) := (OTHERS => '0');
    VARIABLE m : INTEGER := 0;
    VARIABLE running_clk_edge : INTEGER := -1;
    BEGIN
        running_clk_edge := clk_edges;
        IF (powerdown = '1') THEN
            clk_edges <= -1;
            m := 0;    
            div_n := (OTHERS => '0'); 
        ELSIF (d_factor'EVENT) THEN
            clk_edges <= -1;
            m := 0;    
            div_n := (OTHERS => '0'); 
        ELSIF (reset = '1') THEN
            clk_edges <= -1;
            m := 0;    
            div_n := (OTHERS => '0');  
        ELSIF (clk'EVENT AND (clk = '1' OR clk = '0')) THEN
            IF (running_clk_edge = -1) THEN
                m := 0;
                div_n(0) := clk;
                IF (clk = '1') THEN running_clk_edge := 0; END IF;
            ELSIF (running_clk_edge mod d_factor = 0) THEN
                div_n(0) := NOT div_n(0);
            END IF;
            IF (running_clk_edge >= 0 OR clk = '1') THEN 
                clk_edges <= (running_clk_edge + 1) mod (2 * d_factor);
            END IF;
        END IF;
        
        m := 0;
        div_n_register(m) <= div_n(m); 
        WHILE (m < 2 * extra_latency) LOOP
            div_n_register(m+1) <=  div_n_register(m);  
            m := m + 1;
        END LOOP;
        
    END PROCESS;
    clkout <= div_n_register(2 * extra_latency);

END clock_div_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

ENTITY stratixiigx_hssi_aux_clock_mult IS
    GENERIC (
        clk_multiply_by : INTEGER := 1
    );
    PORT (
        clk                     : IN STD_LOGIC;   
        adjust                  : IN STD_LOGIC := '0';   
        adjust_without_lol      : IN STD_LOGIC := '0';   
        reset                   : IN STD_LOGIC := '0';   
        enable_m                : IN STD_LOGIC := '0';
        m                       : IN STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000001";
        clkout                  : OUT STD_LOGIC;   
        busy                    : OUT CMU_MULT_STATE_TYPE);   
END stratixiigx_hssi_aux_clock_mult;

ARCHITECTURE clock_mult_arch OF stratixiigx_hssi_aux_clock_mult IS

    SIGNAL busy_m,busy_n : CMU_MULT_STATE_TYPE;
    SIGNAL mult_n                   :  STD_LOGIC := '0'; 
    SIGNAL m_factor : INTEGER := 1;  
    SIGNAL m_change : BOOLEAN := FALSE;
    
    FUNCTION to_int(arg : IN STD_LOGIC_VECTOR) RETURN INTEGER IS
    VARIABLE result : INTEGER;
    BEGIN
    result := 0;
    FOR i IN arg'RANGE LOOP
        IF arg(i) = '1' THEN
            result := result + 2**i;
        END IF;
    END LOOP;
    RETURN result;
    END to_int;
BEGIN

    m_factor <= to_int(m) WHEN (enable_m = '1') ELSE clk_multiply_by;

    PROCESS (adjust, busy_m, m_factor)
    BEGIN
        IF (m_factor'EVENT) THEN
            busy_n <= INITIAL;
            m_change <= TRUE, FALSE AFTER 1 ps;
        END IF;
        IF (adjust'EVENT AND adjust = '1') THEN
            busy_n <= INITIAL;
        END IF;
        IF (busy_m'EVENT) THEN
            busy_n <= busy_m;
        END IF;
    END PROCESS;
    
    
    PROCESS
    VARIABLE clk_period :  TIME;   
    VARIABLE clk_fast_period :  TIME; 
    VARIABLE last_rising_edge  :  TIME := 0 ps;     
    VARIABLE n :  INTEGER := 0;
    VARIABLE clk_adjust_settled : BOOLEAN := FALSE;   
    VARIABLE clk_sync_period :  TIME; 
    VARIABLE clk_adjust : TIME := 0 ps;
    VARIABLE clk_adjust_running : TIME := 0 ps;
    VARIABLE clk_adjust_interval : INTEGER := 0;
    VARIABLE current_mult_val : STD_LOGIC;
    
    BEGIN
        WAIT UNTIL (clk'EVENT OR reset'EVENT OR adjust'EVENT OR m_change'EVENT);
        IF (m_change'EVENT AND m_change = FALSE) THEN
            mult_n <= '0';
        END IF;
        IF (reset = '1') THEN
            mult_n <= '0';   
            busy_m <= INITIAL; 
        ELSIF (adjust'EVENT AND adjust = '1') THEN
            busy_m <= INITIAL;
        ELSIF (clk'EVENT AND clk = '1') THEN
            IF (busy_n = INITIAL and adjust_without_lol = '0') THEN -- first rising edge            
                mult_n <= '0';    
                last_rising_edge := NOW;    
                busy_m <= ACTIVE;    
            ELSE
                IF (busy_n = INITIAL and adjust_without_lol = '1') THEN -- first rising edge            
                    mult_n <= '0';
                    last_rising_edge := NOW;
                    busy_m <= ACTIVE;    
                END IF;
                IF (busy_n = ACTIVE) THEN -- second rising edge                
                    clk_period := NOW - last_rising_edge;    
                    clk_fast_period := clk_period / m_factor;    
                    clk_adjust := clk_period - (clk_fast_period * m_factor);    
                    busy_m <= INACTIVE;    
                END IF;
                current_mult_val := mult_n;
                mult_n <= NOT mult_n;    
                IF (clk_adjust > 0 ps) THEN
                    clk_adjust_running := clk_adjust + 1 ps;    
                END IF;
                clk_adjust_settled := (clk_adjust = 0 ps);    --  if no adjustment necessary
                n := m_factor;
                WHILE (n >= 1) LOOP
                    IF (clk_adjust_settled = FALSE) THEN
                        clk_adjust_running := clk_adjust_running - 1 ps;    
                        clk_adjust_interval := (n * 1 ps)/ clk_adjust_running;    
                        IF ((n * 1 ps) - (clk_adjust_interval * clk_adjust_running) = 0 ps) THEN
                            clk_adjust_settled := TRUE;    
                        END IF;
                        clk_sync_period := clk_fast_period + 1 ps;    
                    ELSE
                        IF (clk_adjust = 0 ps) THEN
                            clk_sync_period := clk_fast_period;    
                        ELSE
                            IF (n mod clk_adjust_interval = 0) THEN
                                clk_sync_period := clk_fast_period + 1 ps;    
                            ELSE
                                clk_sync_period := clk_fast_period;    
                            END IF;
                        END IF;
                    END IF;
                    IF (reset = '1') THEN
                        mult_n <= '0';    
                    ELSE
                        WAIT FOR (clk_sync_period/2);
                        mult_n <= NOT mult_n;  
                        IF (n > 1) THEN
                            WAIT FOR (clk_sync_period - clk_sync_period/2);
                            mult_n <= NOT mult_n;    
                        END IF;
                    END IF;
                    n := n - 1;
                END LOOP;
            END IF;
        END IF;
    END PROCESS;
    clkout <= mult_n ;
    busy <= busy_n;

END clock_mult_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_aux_clock_phaseshift IS
    GENERIC (
        clk_phase_shift_by : TIME := 0 ps
        );
    PORT    (
        clk                     : IN STD_LOGIC;   
        clkout                  : OUT STD_LOGIC
        );   
END stratixiigx_hssi_aux_clock_phaseshift;

ARCHITECTURE clock_ps_arch OF stratixiigx_hssi_aux_clock_phaseshift IS
    SIGNAL pclk : STD_LOGIC;   
BEGIN
    PROCESS(clk)
    BEGIN
        pclk <= TRANSPORT clk AFTER clk_phase_shift_by;    
    END PROCESS;
    
    clkout <= pclk ;
END clock_ps_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.VITAL_Timing.ALL;
USE IEEE.VITAL_Primitives.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

USE work.stratixiigx_hssi_aux_clock_div;

ENTITY stratixiigx_hssi_refclk_divider IS
    GENERIC (
        enable_divider : STRING := "true";
        divider_number : INTEGER := 0;  -- 0 or 1 for logical numbering
        refclk_coupling_termination : STRING := "dc_coupling_external_termination"; -- new in 5.1 SP1
        dprio_config_mode              :  INTEGER := 0;                 -- 6.1
        MsgOnChecks: Boolean := DefMsgOnChecks;
        XOnChecks: Boolean := DefXOnChecks;
        tipd_inclk        : VitalDelayType01 := DefPropDelay01;
        tipd_dprioin      : VitalDelayType01 := DefPropDelay01;
        tipd_dpriodisable : VitalDelayType01 := DefPropDelay01;
        tpd_inclk_clkout  : VitalDelayType01 := DefPropDelay01
    );
    PORT (
        inclk                   : IN STD_LOGIC;   
        dprioin                 : IN STD_LOGIC := '0';   
        dpriodisable            : IN STD_LOGIC := '1';   
        clkout                  : OUT STD_LOGIC;   
        dprioout                : OUT STD_LOGIC);   
END stratixiigx_hssi_refclk_divider;

ARCHITECTURE refclk_div_arch OF stratixiigx_hssi_refclk_divider IS

    COMPONENT stratixiigx_hssi_aux_clock_div
        GENERIC (
            clk_divide_by : INTEGER := 1;
            extra_latency : INTEGER := 0);
        PORT (
            clk                     : IN  STD_LOGIC;
            reset                   : IN  STD_LOGIC := '0';
	    powerdown               : IN  STD_LOGIC := '0';
            enable_d                : IN STD_LOGIC := '0';
            d                       : IN STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000001";
            clkout                  : OUT STD_LOGIC);
    END COMPONENT;

    SIGNAL divide_by_2_out          :  STD_LOGIC; 
    SIGNAL inclk_ipd                :  STD_LOGIC;
    SIGNAL dprioin_ipd              :  STD_LOGIC;
    SIGNAL dpriodisable_ipd         :  STD_LOGIC;

    SIGNAL tmp_clkout : STD_LOGIC;

BEGIN

    WireDelay : BLOCK
    BEGIN
        VitalWireDelay (inclk_ipd, inclk, tipd_inclk);
        VitalWireDelay (dprioin_ipd, dprioin, tipd_dprioin);
        VitalWireDelay (dpriodisable_ipd, dpriodisable, tipd_dpriodisable);
    END BLOCK;

    VITALTIMING : process(inclk_ipd,divide_by_2_out)
    VARIABLE clkout_VitalGlitchData : VitalGlitchDataType;
    VARIABLE tmp_clkout : STD_LOGIC;
    BEGIN
    
        IF (enable_divider = "true") THEN 
            tmp_clkout := divide_by_2_out;
        ELSE 
            tmp_clkout := inclk_ipd;
        END IF;
        
        VitalPathDelay01 
        (
            OutSignal => clkout,
            OutSignalName => "CLKOUT",
            OutTemp => tmp_clkout,
            Paths => (
                        0 => (inclk_ipd'last_event, tpd_inclk_clkout, TRUE)
                     ),
            GlitchData => clkout_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOnChecks,
            MsgOn => MsgOnChecks
        );
    
    END process;
    
    divide_by_2 : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 2,
            extra_latency => 0)
        PORT MAP (
            clk => inclk_ipd, 
            clkout => divide_by_2_out);   
    
    
    dprioout <= '0' WHEN (dpriodisable_ipd = '1') ELSE dprioin_ipd;

END refclk_div_arch;


LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_tx_channel_clk_div IS
    GENERIC (
        clkin0_select         :  string := "true";    
        clk_divide_by_n       :  integer := 1;    
        clk_divide_by_m       :  integer := 4;    
        clk_divide_by_2_select:  string := "true";    
	    allow_vco_bypass        :  string := "false";
        lclkout_latency       :  integer := 0;    
        fclkout_latency       :  integer := 0;    
        lclkout_phase_shift   :  TIME := 0 ps;    
        fclkout_phase_shift   :  TIME := 0 ps    
    );
    PORT (
        dpriodisable            : IN std_logic := '1';
        dprioin                 : IN std_logic_vector (9 DOWNTO 0);
        clkin0                  : IN std_logic;   
        clkin1                  : IN std_logic;   
        reset                   : IN std_logic := '0';
        vcobypassin             : IN std_logic := '0';
        lclkout                 : OUT std_logic;   
        fclkout                 : OUT std_logic
    );   
END stratixiigx_hssi_tx_channel_clk_div;

ARCHITECTURE local_div_arch OF stratixiigx_hssi_tx_channel_clk_div IS

    COMPONENT stratixiigx_hssi_aux_clock_div
        GENERIC (
            clk_divide_by : INTEGER := 1;
            extra_latency : INTEGER := 0
        );
        PORT (
            clk                     : IN STD_LOGIC;
            reset                   : IN STD_LOGIC := '0';
	    powerdown               : IN STD_LOGIC := '0';
            enable_d                : IN STD_LOGIC := '0';
            d                       : IN STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000001";
            clkout                  : OUT STD_LOGIC
        );
    END COMPONENT;

    COMPONENT stratixiigx_hssi_aux_clock_phaseshift
        GENERIC (
            clk_phase_shift_by : TIME := 0 ps
        );
        PORT    (
            clk                     : IN STD_LOGIC;
            clkout                  : OUT STD_LOGIC
        );
    END COMPONENT;
    
    SIGNAL divide_by_n_in           :  std_logic := '0';
    -- N divider   
    SIGNAL divide_by_n_out          :  std_logic := '0';
    -- 4,5 divider   
    SIGNAL divide_by_m_out          :  std_logic := '0';   
    -- 2 divider
    SIGNAL divide_by_2_out          :  std_logic := '0'; 
    -- Low speed clock latency,phase shift  
    SIGNAL lclkout_undelayed        :  std_logic; 
    SIGNAL lclkout_pre_latency        :  std_logic;  
    -- High speed clock latency,phase shift 
    SIGNAL hclkout_undelayed      :  std_logic;   
    SIGNAL hclkout_pre_latency      :  std_logic;   

    --  begin dprio
    -- clkin0 selection
    SIGNAL cram_rtx_cmu_sel :  std_logic := '0';
    SIGNAL dprio_divide_by_n_in :  std_logic;

    --  by n
    SIGNAL cram_m_sel               :  std_logic_vector (1 DOWNTO 0);
    SIGNAL cram_rpma_doublewidth_tx :  std_logic;
    SIGNAL cram_rpmadwidth_tx       :  std_logic;

    SIGNAL nondprio_divide_by_n_out  :  std_logic;
    SIGNAL dprio_divide_by_n_out     :  std_logic;
    SIGNAL dprio_divide_by_n_out_by1 :  std_logic;
    SIGNAL dprio_divide_by_n_out_by2 :  std_logic;
    SIGNAL dprio_divide_by_n_out_by4 :  std_logic;

    --  by m
    SIGNAL nondprio_divide_by_m_out  :  std_logic;
    SIGNAL dprio_divide_by_m_out     :  std_logic;
    SIGNAL dprio_divide_by_m_out_by4 :  std_logic;
    SIGNAL dprio_divide_by_m_out_by5 :  std_logic;
    --  end dprio

BEGIN
    -- begin dprio   
    cram_rtx_cmu_sel <= dprioin(4);
    cram_m_sel <= dprioin(1 DOWNTO 0);
    cram_rpmadwidth_tx <= dprioin(3);
    cram_rpma_doublewidth_tx <= dprioin(2);
    -- by n
    dprio_divide_by_n_out <=  dprio_divide_by_n_out_by4 WHEN (cram_m_sel = "10") ELSE
                              dprio_divide_by_n_out_by2 WHEN (cram_m_sel = "01") ELSE
                              dprio_divide_by_n_out_by1;                            
    divide_by_n_out <= nondprio_divide_by_n_out WHEN (dpriodisable /= '0') ELSE dprio_divide_by_n_out;
    -- by m
    dprio_divide_by_m_out <= dprio_divide_by_m_out_by5 WHEN (cram_rpmadwidth_tx = '1') ELSE dprio_divide_by_m_out_by4;
    divide_by_m_out <= nondprio_divide_by_m_out WHEN (dpriodisable /= '0') ELSE dprio_divide_by_m_out;
    -- end dprio
    
    -- by n
    
    -- refclk selection
    dprio_divide_by_n_in <= clkin0 WHEN (cram_rtx_cmu_sel = '0') ELSE clkin1;    
    divide_by_n_in <= vcobypassin          WHEN (allow_vco_bypass = "true") ELSE
                      dprio_divide_by_n_in WHEN (dpriodisable = '0')        ELSE                    
                      clkin0               WHEN (clkin0_select = "true")    ELSE 
                      clkin1;

    divide_by_n : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => clk_divide_by_n,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_in,
	        reset => reset,
            clkout => nondprio_divide_by_n_out);   

    divide_by_n_by1 : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 1,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_in,
	        reset => reset,
            clkout => dprio_divide_by_n_out_by1);   

    divide_by_n_by2 : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 2,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_in,
	        reset => reset,
            clkout => dprio_divide_by_n_out_by2);   

    divide_by_n_by4 : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 4,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_in,
	        reset => reset,
            clkout => dprio_divide_by_n_out_by4);   

    -- by m    
    divide_by_m : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => clk_divide_by_m,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_out,
	         reset => reset,
            clkout => nondprio_divide_by_m_out);   
    
    divide_by_m_by4 : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 4,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_out,
	         reset => reset,
            clkout => dprio_divide_by_m_out_by4);   

    divide_by_m_by5 : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 5,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_out,
	         reset => reset,
            clkout => dprio_divide_by_m_out_by5);   

    -- moved to SERDES
    divide_by_2 : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 2,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_m_out,
	    reset => reset,
            clkout => divide_by_2_out);   
    
    
    lclkout_undelayed <= divide_by_2_out WHEN (clk_divide_by_2_select = "true") ELSE divide_by_m_out;
    hclkout_undelayed <= divide_by_n_out ;
    
    lclk_phase_shift : stratixiigx_hssi_aux_clock_phaseshift 
        GENERIC MAP (
            clk_phase_shift_by => lclkout_phase_shift)
        PORT MAP (
            clk => lclkout_undelayed,
            clkout => lclkout_pre_latency);   
    
    hclk_phase_shift : stratixiigx_hssi_aux_clock_phaseshift 
        GENERIC MAP (
            clk_phase_shift_by => fclkout_phase_shift)
        PORT MAP (
            clk => hclkout_undelayed,
            clkout => hclkout_pre_latency);   
    
    lclk_latency : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 1,
            extra_latency => lclkout_latency)
        PORT MAP (
            clk => lclkout_pre_latency,
	    reset => reset,
            clkout => lclkout);   
    
    hclk_latency : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 1,
            extra_latency => fclkout_latency)
        PORT MAP (
            clk => hclkout_pre_latency,
	    reset => reset,
            clkout => fclkout);   
    
END local_div_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.VITAL_Timing.ALL;
USE IEEE.VITAL_Primitives.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

USE work.stratixiigx_hssi_aux_clock_div;
USE work.stratixiigx_hssi_aux_clock_phaseshift;

ENTITY stratixiigx_hssi_cmu_clock_divider IS
    GENERIC (
      inclk_select          :  integer := 0;    
      use_vco_bypass        :  string := "false";    
      use_digital_refclk_post_divider :  string := "false";    
      use_coreclk_out_post_divider    :  string := "false";    
      divide_by             :  integer := 4;    
      enable_refclk_out     :  string := "true";    
      enable_pclk_x8_out    :  string := "false";    
      select_neighbor_pclk  :  string := "false";    
      coreclk_out_gated_by_quad_reset:  string := "false";    
      select_refclk_dig     :  string := "false";
      dprio_config_mode              :  INTEGER := 0;                 -- 6.1
      -- Interconnect delays
      tipd_clk           : VitalDelayArrayType01(2 DOWNTO 0) := (OTHERS => DefPropDelay01);
      tipd_pclkin        : VitalDelayType01 := DefPropDelay01;
      tipd_dprioin       : VitalDelayArrayType01(29 DOWNTO 0) := (OTHERS => DefPropDelay01);
      tipd_dpriodisable  : VitalDelayType01 := DefPropDelay01;
      tipd_powerdn       : VitalDelayType01 := DefPropDelay01;
      tipd_quadreset     : VitalDelayType01 := DefPropDelay01;
      tipd_refclkdig     : VitalDelayType01 := DefPropDelay01;
      tipd_scanclk       : VitalDelayType01 := DefPropDelay01;
      tipd_scanin        : VitalDelayArrayType01(22 DOWNTO 0) := (OTHERS => DefPropDelay01);
      tipd_scanshift     : VitalDelayType01 := DefPropDelay01;
      tipd_scanmode      : VitalDelayType01 := DefPropDelay01;
      -- Path delays
      MsgOnChecks: Boolean := DefMsgOnChecks;
      XOnChecks: Boolean := DefXOnChecks;
      tpd_clk_coreclkout  : VitalDelayType01 := DefPropDelay01;
      tpd_clk_pclkx8out   : VitalDelayType01 := DefPropDelay01;
      tpd_pclkin_coreclkout : VitalDelayType01 := DefPropDelay01;
      -- Simulation only
      sim_analogrefclkout_phase_shift : INTEGER := 0;     
      sim_analogfastrefclkout_phase_shift : INTEGER := 0;     
      sim_digitalrefclkout_phase_shift  : INTEGER := 0;     
      sim_pclkx8out_phase_shift  : INTEGER := 0;     
      sim_coreclkout_phase_shift  : INTEGER := 0 
    );
    PORT (
        clk                     : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (OTHERS => '0');   
        pclkin                  : IN STD_LOGIC := '0';   
        dprioin                 : IN STD_LOGIC_VECTOR(29 DOWNTO 0) := (OTHERS => '0');   
        dpriodisable            : IN STD_LOGIC := '1';   
        powerdn                 : IN STD_LOGIC := '0';   
        quadreset               : IN STD_LOGIC := '0';   
        refclkdig               : IN STD_LOGIC := '0';   
        scanclk                 : IN STD_LOGIC := '0';   
        scanin                  : IN STD_LOGIC_VECTOR(22 DOWNTO 0) := (OTHERS => '0');   
        scanshift               : IN STD_LOGIC := '0';   
        scanmode                : IN STD_LOGIC := '0';
        vcobypassin             : IN STD_LOGIC := '0';   
        analogrefclkout         : OUT STD_LOGIC;   
        analogfastrefclkout     : OUT STD_LOGIC;   
        digitalrefclkout        : OUT STD_LOGIC;   
        pclkx8out               : OUT STD_LOGIC;   
        coreclkout              : OUT STD_LOGIC;   
        dprioout                : OUT STD_LOGIC_VECTOR(29 DOWNTO 0);   
        scanout                 : OUT STD_LOGIC_VECTOR(22 DOWNTO 0));   
END stratixiigx_hssi_cmu_clock_divider;

ARCHITECTURE cmu_div_arch OF stratixiigx_hssi_cmu_clock_divider IS

    COMPONENT stratixiigx_hssi_aux_clock_div 
    GENERIC (
        clk_divide_by : INTEGER := 1;
        extra_latency : INTEGER := 0
    );
    PORT (
        clk                     : IN STD_LOGIC;
        reset                   : IN STD_LOGIC := '0';
	powerdown               : IN STD_LOGIC := '0';
        enable_d                : IN STD_LOGIC := '0';
        d                       : IN STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000001";
        clkout                  : OUT STD_LOGIC
    );
    END COMPONENT;
    
    COMPONENT stratixiigx_hssi_aux_clock_phaseshift
    GENERIC (
        clk_phase_shift_by : TIME := 0 ps
        );
    PORT    (
        clk                     : IN STD_LOGIC;
        clkout                  : OUT STD_LOGIC
        );
    END COMPONENT;
     
    SIGNAL divide_by_n_out          :  STD_LOGIC;   
    SIGNAL divide_by_m_out          :  STD_LOGIC;   
    SIGNAL divide_by_2_dig_out      :  STD_LOGIC;   
    SIGNAL divide_by_2_core_out     :  STD_LOGIC;   
    SIGNAL mux_pclk                 :  STD_LOGIC;   
    SIGNAL mux_digrefclk            :  STD_LOGIC;   
    SIGNAL mux_coreclk              :  STD_LOGIC;   
    SIGNAL reset_divs               :  STD_LOGIC;   
    SIGNAL reset_coreclk_only       :  STD_LOGIC;  
    SIGNAL vco_bypass_mux           :  STD_LOGIC; 
    
    SIGNAL analogrefclkout_undelayed,analogfastrefclkout_undelayed, digitalrefclkout_undelayed,
           pclkx8out_undelayed, coreclkout_undelayed : STD_LOGIC;   
           
    SIGNAL clk_ipd : STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL scanin_ipd : STD_LOGIC_VECTOR(22 DOWNTO 0);
    SIGNAL pclkin_ipd : STD_LOGIC;
    SIGNAL dprioin_ipd : STD_LOGIC_VECTOR(29 DOWNTO 0);
    SIGNAL dpriodisable_ipd : STD_LOGIC;
    SIGNAL powerdn_ipd : STD_LOGIC;
    SIGNAL quadreset_ipd : STD_LOGIC;
    SIGNAL refclkdig_ipd : STD_LOGIC;
    SIGNAL scanclk_ipd : STD_LOGIC;
    SIGNAL scanshift_ipd : STD_LOGIC;
    SIGNAL scanmode_ipd : STD_LOGIC;

    SIGNAL tmp_coreclkout, tmp_pclkx8out : STD_LOGIC;
       
BEGIN
    WireDelay : BLOCK
    BEGIN
        loopbits_clk : FOR i in clk'RANGE GENERATE
            VitalWireDelay (clk_ipd(i), clk(i), tipd_clk(i));
        END GENERATE;
        loopbits_scanin : FOR i in scanin'RANGE GENERATE
            VitalWireDelay (scanin_ipd(i), scanin(i), tipd_scanin(i));
        END GENERATE;
        
        VitalWireDelay (pclkin_ipd, pclkin, tipd_pclkin);

	loopbits_dprioin : FOR i in dprioin'RANGE GENERATE
            VitalWireDelay (dprioin_ipd(i), dprioin(i), tipd_dprioin(i));
	END GENERATE;

        VitalWireDelay (dpriodisable_ipd, dpriodisable, tipd_dpriodisable);
        VitalWireDelay (powerdn_ipd, powerdn, tipd_powerdn);
        VitalWireDelay (quadreset_ipd, quadreset, tipd_quadreset);
        VitalWireDelay (refclkdig_ipd, refclkdig, tipd_refclkdig);
        VitalWireDelay (scanclk_ipd, scanclk, tipd_scanclk);
        VitalWireDelay (scanshift_ipd, scanshift, tipd_scanshift);
        VitalWireDelay (scanmode_ipd, scanmode, tipd_scanmode);
        
    END BLOCK;
    VITALTIMING : process(clk_ipd , pclkin_ipd, tmp_coreclkout, tmp_pclkx8out)
    VARIABLE coreclkout_clk_VitalGlitchData : VitalGlitchDataType;
    VARIABLE coreclkout_pclk_VitalGlitchData : VitalGlitchDataType;
    VARIABLE pclkx8out_VitalGlitchData : VitalGlitchDataType;
    BEGIN
        VitalPathDelay01 
        (
            OutSignal => coreclkout,
            OutSignalName => "CORECLKOUT",
            OutTemp => tmp_coreclkout,
            Paths => (
                        0 => (clk_ipd'last_event, tpd_clk_coreclkout, TRUE)
                     ),
            GlitchData => coreclkout_clk_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOnChecks,
            MsgOn => MsgOnChecks
        );
        
        VitalPathDelay01 
        (
            OutSignal => pclkx8out,
            OutSignalName => "PCLKX8OUT",
            OutTemp => tmp_pclkx8out,
            Paths => (
                        0 => (clk_ipd'last_event, tpd_clk_pclkx8out, TRUE)
                     ),
            GlitchData => pclkx8out_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOnChecks,
            MsgOn => MsgOnChecks
        );
        
        VitalPathDelay01 
        (
            OutSignal => coreclkout,
            OutSignalName => "CORECLKOUT",
            OutTemp => tmp_coreclkout,
            Paths => (
                        0 => (pclkin_ipd'last_event, tpd_pclkin_coreclkout, TRUE)
                     ),
            GlitchData => coreclkout_pclk_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOnChecks,
            MsgOn => MsgOnChecks
        );
    
    END process;

    reset_divs <= powerdn_ipd OR quadreset_ipd ;
    reset_coreclk_only <= '0' WHEN (coreclk_out_gated_by_quad_reset = "false") ELSE quadreset_ipd ;
    -- /N=1 divider
    divide_by_n : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 1,
            extra_latency => 0)
        PORT MAP (
            clk => clk_ipd(inclk_select),
            reset => reset_divs,
            clkout => divide_by_n_out);        
    -- /M divider
    divide_by_m : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => divide_by,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_out,
            reset => reset_divs,
            clkout => divide_by_m_out);   
    
    
    vco_bypass_mux <= vcobypassin WHEN (use_vco_bypass = "true") ELSE divide_by_m_out;
    
    -- /2 divider
    divide_by_2_dig : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 2,
            extra_latency => 0)
        PORT MAP (
            clk => vco_bypass_mux,
            reset => reset_divs,
            clkout => divide_by_2_dig_out);   
    -- /2 coreclk divider
    divide_by_2_core : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 2,
            extra_latency => 0)
        PORT MAP (
            clk => mux_digrefclk,
            reset => reset_coreclk_only,
            clkout => divide_by_2_core_out);   
            
    analogrefclkout_undelayed <= 'Z' WHEN (enable_refclk_out = "false") ELSE divide_by_m_out;
    analogfastrefclkout_undelayed <= divide_by_n_out;
    digitalrefclkout_undelayed <= refclkdig_ipd WHEN (select_refclk_dig = "true") ELSE mux_digrefclk;
    coreclkout_undelayed <= mux_coreclk;
    pclkx8out_undelayed <= 'Z' WHEN (enable_pclk_x8_out = "false") ELSE mux_pclk;
    
    mux_pclk <= divide_by_2_dig_out WHEN (use_digital_refclk_post_divider = "true") ELSE vco_bypass_mux;
    mux_digrefclk <= pclkin_ipd WHEN (select_neighbor_pclk = "true") ELSE mux_pclk;
    
    mux_coreclk <= mux_digrefclk WHEN (use_coreclk_out_post_divider = "false") ELSE divide_by_2_core_out;

    -- Extra phase shift on output clocks
    
    extra_ps_arc : stratixiigx_hssi_aux_clock_phaseshift
    GENERIC MAP (
        clk_phase_shift_by => sim_analogrefclkout_phase_shift * 1 ps
    )
    PORT MAP (
        clk => analogrefclkout_undelayed,
        clkout => analogrefclkout
    );

    extra_ps_afrc : stratixiigx_hssi_aux_clock_phaseshift
    GENERIC MAP (
        clk_phase_shift_by => sim_analogfastrefclkout_phase_shift * 1 ps
    )
    PORT MAP (
        clk => analogfastrefclkout_undelayed,
        clkout => analogfastrefclkout
    );

    extra_ps_drc : stratixiigx_hssi_aux_clock_phaseshift
    GENERIC MAP (
        clk_phase_shift_by => sim_digitalrefclkout_phase_shift * 1 ps
    )
    PORT MAP (
        clk => digitalrefclkout_undelayed,
        clkout => digitalrefclkout
    );

    extra_ps_p8c : stratixiigx_hssi_aux_clock_phaseshift
    GENERIC MAP (
        clk_phase_shift_by => sim_pclkx8out_phase_shift * 1 ps
    )
    PORT MAP (
        clk => pclkx8out_undelayed,
        clkout => tmp_pclkx8out
    );
    
    extra_ps_cc : stratixiigx_hssi_aux_clock_phaseshift
    GENERIC MAP (
        clk_phase_shift_by => sim_coreclkout_phase_shift * 1 ps
    )
    PORT MAP (
        clk => coreclkout_undelayed,
        clkout => tmp_coreclkout
    );
        
END cmu_div_arch;
--
-- 
-- no digital behavior to simulate
--

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

ENTITY stratixiigx_hssi_calibration_block IS
    GENERIC (
        use_continuous_calibration_mode:  string  := "false";    
        rx_calibration_write_test_value:  integer := 0;    
        tx_calibration_write_test_value:  integer := 0;    
        enable_rx_calibration_test_write: string  := "false";    
        enable_tx_calibration_test_write: string  := "false";    
        send_rx_calibration_status     :  string  := "true");    
    PORT (
        clk                     : IN std_logic := '0';   
        powerdn                 : IN std_logic := '0';   
        enabletestbus           : IN std_logic := '0';   
        calibrationstatus       : OUT std_logic_vector(4 DOWNTO 0));   
END stratixiigx_hssi_calibration_block;

ARCHITECTURE calib_arch OF stratixiigx_hssi_calibration_block IS


    SIGNAL calibrationstatus_xhdl1  :  std_logic_vector(4 DOWNTO 0);   

BEGIN
    calibrationstatus <= calibrationstatus_xhdl1;

END calib_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.std_logic_arith.ALL;
USE IEEE.std_logic_unsigned.ALL;
USE IEEE.VITAL_Timing.ALL;
USE IEEE.VITAL_Primitives.ALL;

LIBRARY STD;
USE STD.textio.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

USE WORK.stratixiigx_hssi_aux_clock_div;
USE WORK.stratixiigx_hssi_aux_clock_mult;
USE WORK.stratixiigx_hssi_aux_clock_phaseshift;

ENTITY stratixiigx_hssi_cmu_pll IS
    GENERIC (
        inclk0_period : INTEGER := 0;  -- time period in ps
        inclk1_period : INTEGER := 0;
        inclk2_period : INTEGER := 0;
        inclk3_period : INTEGER := 0;
        inclk4_period : INTEGER := 0;
        inclk5_period : INTEGER := 0;
        inclk6_period : INTEGER := 0;
        inclk7_period : INTEGER := 0;
        pfd_clk_select : INTEGER := 0;
        multiply_by : INTEGER := 1;
        divide_by : INTEGER := 1;
        low_speed_test_sel : INTEGER := 0;
        pll_type : STRING := "normal"; -- normal,fast,auto
        charge_pump_current_test_enable : INTEGER := 0;
        vco_range : STRING := "low";
        loop_filter_resistor_control : INTEGER := 0;
        loop_filter_ripple_capacitor_control : INTEGER := 0;
        use_default_charge_pump_current_selection : STRING := "false";
        use_default_charge_pump_supply_vccm_vod_control : STRING := "false";
        pll_number : INTEGER := 0;     -- PLL 0-2
        charge_pump_current_control : INTEGER := 0;
        up_down_control_percent : INTEGER := 0;
        charge_pump_tristate_enable : STRING := "false";
        enable_pll_cascade : STRING := "false";           -- 6.1
        dprio_config_mode : INTEGER := 0;                 -- 6.1
        protocol_hint : STRING := "basic";                -- 6.1
        remapped_to_new_loop_filter_charge_pump_settings : STRING := "false";
        -- Interconnect delays
        tipd_clk           : VitalDelayArrayType01(7 DOWNTO 0)  := (OTHERS => DefPropDelay01);
        tipd_dprioin       : VitalDelayArrayType01(39 DOWNTO 0) := (OTHERS => DefPropDelay01);
        tipd_dpriodisable  : VitalDelayType01 := DefPropDelay01;
        tipd_pllreset      : VitalDelayType01 := DefPropDelay01;
        tipd_pllpowerdn    : VitalDelayType01 := DefPropDelay01;
        -- Path delays
        MsgOnChecks: Boolean := DefMsgOnChecks;
        XOnChecks: Boolean := DefXOnChecks;
        tpd_clk_clkout  : VitalDelayType01 := DefPropDelay01;
        -- Simulation only
        sim_clkout_phase_shift : INTEGER := 0; 
        sim_clkout_latency : INTEGER := 0
    );
    PORT (
        clk                     : IN std_logic_vector(7 DOWNTO 0);   
        dprioin                 : IN std_logic_vector(39 DOWNTO 0) := (OTHERS => '0');   
        dpriodisable            : IN std_logic := '1';   
        pllreset                : IN std_logic := '0';   
        pllpowerdn              : IN std_logic := '0';   
        clkout                  : OUT std_logic;   
        locked                  : OUT std_logic;   
        dprioout                : OUT std_logic_vector(39 DOWNTO 0);
        fbclkout                : OUT std_logic;
        vcobypassout            : OUT std_logic);   
END stratixiigx_hssi_cmu_pll;

ARCHITECTURE cmu_pll_arch OF stratixiigx_hssi_cmu_pll IS

    COMPONENT stratixiigx_hssi_aux_clock_div
        GENERIC (
            clk_divide_by : INTEGER := 1;
            extra_latency : INTEGER := 0
        );
        PORT (
            clk                     : IN  std_logic;
            reset                   : IN  std_logic := '0';
            powerdown               : IN  std_logic := '0';
            enable_d                : IN  STD_LOGIC := '0';
            d                       : IN  STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000001";
            clkout                  : OUT std_logic);
    END COMPONENT;

    COMPONENT stratixiigx_hssi_aux_clock_mult
        GENERIC (
            clk_multiply_by : INTEGER := 1
        );
        PORT (
            clk                     : IN  std_logic;
            adjust                  : IN  std_logic := '0';
            adjust_without_lol      : IN  std_logic := '0';
            reset                   : IN  std_logic := '0';
            enable_m                : IN STD_LOGIC := '0';
            m                       : IN STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000001";
            clkout                  : OUT std_logic;
            busy                    : OUT CMU_MULT_STATE_TYPE);
    END COMPONENT;
    
    COMPONENT stratixiigx_hssi_aux_clock_phaseshift 
    GENERIC (
        clk_phase_shift_by : TIME := 0 ps
        );
    PORT    (
        clk                     : IN STD_LOGIC;
        clkout                  : OUT STD_LOGIC
        );
    END COMPONENT;


    SIGNAL pll_clkin,pll_clkin_pre_latency :  std_logic;   
    SIGNAL clk_pll                  :  std_logic;   
    SIGNAL clk_div                  :  std_logic;
    SIGNAL clk_div_delayed          :  std_logic := '0';   
    SIGNAL clk_vco                  :  std_logic;   
    SIGNAL charge_pump              :  std_logic := '1';             --  re-adjust VCO frequency
    SIGNAL adjust_without_lol       :  std_logic := '0';
    SIGNAL charge_pump_delayed      :  std_logic := '1';
    SIGNAL busy                     :  CMU_MULT_STATE_TYPE;   --  VCO state
    SIGNAL detected_fb_clk_edge     :  BOOLEAN := FALSE;   
    SIGNAL last_fb_clk_edge         :  TIME := 0 ps;      
    SIGNAL expected_clk_period      :  TIME := 0 ps;   
    SIGNAL clk_tolerance            :  TIME := 0 ps;   
    SIGNAL real_clk_period          :  TIME := 0 ps;   
    SIGNAL last_pll_clkin_edge      :  TIME;   
    SIGNAL first_pll_clkin_edge_detect     :  std_logic := '0';   
    SIGNAL display_msgs             :  BIT := '1'; 
    SIGNAL freq_viol_msg_sem        :  BIT := '1';  
    SIGNAL reset                    :  std_logic;  
    SIGNAL pd_div                   :  STD_LOGIC := '0';
    SIGNAL locked_tmp               :  STD_LOGIC := '0';

    SIGNAL clk_ipd : STD_LOGIC_VECTOR(7 DOWNTO 0);
    SIGNAL dprioin_ipd : STD_LOGIC_VECTOR(39 DOWNTO 0);
    SIGNAL dpriodisable_ipd : STD_LOGIC;
    SIGNAL dprioenable, dprioen_reg : STD_LOGIC;
    SIGNAL m, cru_m_chn, cru_l_chn : STD_LOGIC_VECTOR(7 DOWNTO 0);
    SIGNAL pllreset_ipd : STD_LOGIC;
    SIGNAL pllpowerdn_ipd : STD_LOGIC;

    SIGNAL dprio_reset : STD_LOGIC := '0'; -- reset through DPRIO CRAM in 7.1
    SIGNAL tmp_dprio_pfd_clk_select : STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL dprio_pfd_clk_select : INTEGER;
    
    SIGNAL tmp_clkout : STD_LOGIC;

    SIGNAL change_in_clk_freq : BOOLEAN := FALSE;
    SIGNAL minor_clk_freq_change : BOOLEAN := FALSE;

BEGIN

WireDelay : BLOCK
    BEGIN
        loopbits_clk : FOR i in clk'RANGE GENERATE
            VitalWireDelay (clk_ipd(i), clk(i), tipd_clk(i));
        END GENERATE;
        loopbits_dprioin : FOR i in dprioin'RANGE GENERATE
            VitalWireDelay (dprioin_ipd(i), dprioin(i), tipd_dprioin(i));
        END GENERATE;
        VitalWireDelay (dpriodisable_ipd, dpriodisable, tipd_dpriodisable);
        VitalWireDelay (pllreset_ipd, pllreset, tipd_pllreset);
        VitalWireDelay (pllpowerdn_ipd, pllpowerdn, tipd_pllpowerdn);
        
    END BLOCK;
    
    VITALTIMING : process(clk_ipd,tmp_clkout)
    VARIABLE clkout_VitalGlitchData : VitalGlitchDataType;

    BEGIN
        VitalPathDelay01 
        (
            OutSignal => clkout,
            OutSignalName => "CLKOUT",
            OutTemp => tmp_clkout,
            Paths => (
                        0 => (clk_ipd'last_event, tpd_clk_clkout, TRUE)
                     ),
            GlitchData => clkout_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOnChecks,
            MsgOn => MsgOnChecks
        );
    
    END PROCESS;
        
    PROCESS
        FUNCTION select_clock_period (
            clk_select              : IN integer) RETURN TIME IS
            VARIABLE period_int             :  INTEGER;  
            VARIABLE txt : LINE; 
        BEGIN
            CASE clk_select IS
                WHEN 0 =>
                            period_int := inclk0_period;    
                WHEN 1 =>
                            period_int := inclk1_period;    
                WHEN 2 =>
                            period_int := inclk2_period;    
                WHEN 3 =>
                            period_int := inclk3_period;    
                WHEN 4 =>
                            period_int := inclk4_period;    
                WHEN 5 =>
                            period_int := inclk5_period;    
                WHEN 6 =>
                            period_int := inclk6_period;    
                WHEN 7 =>
                            period_int := inclk7_period;    
                WHEN OTHERS  =>
                            period_int := inclk0_period; 
                
            END CASE;
            RETURN((period_int * (1 ps)));
        END select_clock_period;
        VARIABLE clk_per : TIME := select_clock_period(pfd_clk_select);  
    BEGIN      
        expected_clk_period <= clk_per;
        clk_tolerance <= 0.1 * clk_per;    --  same as Stratix   
        WAIT;
    END PROCESS;
    pll_clkin_pre_latency <= clk_ipd(dprio_pfd_clk_select) WHEN (dprioenable = '1') ELSE clk_ipd(pfd_clk_select) ;
    reset <= pllreset_ipd OR pllpowerdn_ipd OR dprio_reset;

    -- Clock latency
    
    clock_latency : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 1,
            extra_latency => sim_clkout_latency )
        PORT MAP (
            clk => pll_clkin_pre_latency,
            clkout => pll_clkin);   
            
    -- Input frequency checks
    
    PROCESS
    VARIABLE txt:LINE;
    VARIABLE realt : TIME := 0 ps;
    BEGIN
        WAIT UNTIL (pll_clkin'EVENT AND pll_clkin = '1');
        IF (first_pll_clkin_edge_detect = '0') THEN
            first_pll_clkin_edge_detect <= '1';    
        ELSE
            realt := NOW - last_pll_clkin_edge;    
            IF ((realt < expected_clk_period - clk_tolerance) OR (realt > expected_clk_period + clk_tolerance)) THEN
                IF (freq_viol_msg_sem = '1') THEN
                    assert FALSE report "CMU PLL input frequency mismatch between parameter-specified period and real clock period" severity WARNING;  
                    WRITE(txt,string'("Time :"));
                    WRITE(txt,NOW);
                    WRITELINE(output,txt);
                    WRITE(txt,string'("Clock period specified in parameter is "));
                    WRITE(txt,expected_clk_period); 
                    WRITE(txt,string'(" but real clock period is "));
                    WRITE(txt,realt);
                    WRITELINE(output,txt);
                    freq_viol_msg_sem <= '0';
                END IF;  
            END IF;
        END IF;
        IF (realt /= real_clk_period AND real_clk_period > 0 ps) THEN
            change_in_clk_freq <= TRUE;
            IF ( (abs(realt - real_clk_period)) <= 2 ps) THEN
                minor_clk_freq_change <= TRUE;
            END IF;
        ELSE
            change_in_clk_freq <= FALSE;
            minor_clk_freq_change <= FALSE;
        END IF;
        real_clk_period <= realt;
        last_pll_clkin_edge <= NOW;    
    END PROCESS;

    -- DPRIO
    dprioenable <= NOT dpriodisable_ipd WHEN ((CONV_STD_LOGIC_VECTOR(dprio_config_mode, 6) AND "010000") = "010000") ELSE '0';
    cru_m_chn <= dprioin_ipd( 7 DOWNTO 0);
    cru_l_chn <= dprioin_ipd(15 DOWNTO 8);
    m <= cru_m_chn WHEN (dprioenable = '1') ELSE conv_std_logic_vector(multiply_by, 8);
    
    dprio_reset <= '1' WHEN ((dprioenable = '1') AND (dprioin_ipd(16) = '1' OR dprioin_ipd(17) = '1')) ELSE '0';
    tmp_dprio_pfd_clk_select <= dprioin_ipd(20 DOWNTO 18);
    dprio_pfd_clk_select <= CONV_INTEGER(tmp_dprio_pfd_clk_select);

    dprioout(7 DOWNTO 0)   <= CONV_STD_LOGIC_VECTOR(multiply_by, 8);
    dprioout(15 DOWNTO 8)  <= CONV_STD_LOGIC_VECTOR(divide_by, 8);
    dprioout(20 DOWNTO 18) <= CONV_STD_LOGIC_VECTOR(pfd_clk_select,3);
    
    PROCESS(pll_clkin)
    BEGIN
       IF (pll_clkin'EVENT AND pll_clkin = '1') THEN
           dprioen_reg <= dprioenable;
       END IF;
    END PROCESS;
    
           
    -- PFD

    PROCESS (clk_pll)
    BEGIN
        IF (clk_pll'EVENT AND clk_pll = '1' AND NOW > 0 ps) THEN
            last_fb_clk_edge <= NOW;    
        END IF;
    END PROCESS;
    
    PROCESS (pll_clkin,reset,busy,change_in_clk_freq)
    BEGIN
        IF (reset'EVENT AND reset /= '1') THEN
            charge_pump <= '1';     
            adjust_without_lol <= '0';
        ELSIF (busy'EVENT AND busy = INACTIVE) THEN -- VCO
            charge_pump <= '0';    
            adjust_without_lol <= '0';
        ELSIF (change_in_clk_freq = TRUE) THEN
            charge_pump <= '1';  
            if (minor_clk_freq_change = TRUE) then
                adjust_without_lol <= '1';
            end if;
        ELSIF (pll_clkin'EVENT AND (busy /= ACTIVE) AND (busy /= INITIAL) AND pll_clkin = '0' AND NOW > 0 ps) THEN
                IF (last_fb_clk_edge /= last_pll_clkin_edge) THEN
                    charge_pump <= '1';
                    if (locked_tmp = '1') then
                        adjust_without_lol <= '1';
                    end if;
                END IF;
        END IF;
    END PROCESS;
    
    PROCESS
    VARIABLE txt : LINE;
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1');
        IF (reset = '1') THEN
            ASSERT FALSE REPORT "CMU PLL is reset" SEVERITY NOTE;   
            write (txt, string'("Time: "));
            write (txt, NOW);
            writeline (output,txt);  
        END IF;
    END PROCESS;

    PROCESS(charge_pump,reset)
    VARIABLE txt : LINE;
    BEGIN
        IF (reset'EVENT AND reset = '1') THEN 
            display_msgs <= '0';
        ELSIF (charge_pump'EVENT) THEN
            IF (charge_pump = '1' and adjust_without_lol = '0') THEN
                IF (display_msgs = '0') THEN
                    assert false report "CMU PLL lost lock due to reset or change in frequency of input clock" severity NOTE;  
                    write (txt,string'("Time: "));
                    write (txt,NOW);
                    writeline(output,txt);
                    display_msgs <= '1';    
                END IF;
            ELSE
                IF (display_msgs = '1') THEN
                    assert false report "CMU PLL locked to incoming clock" severity NOTE;  
                    write (txt,string'("Time: "));
                    write (txt,NOW);
                    writeline(output,txt);
                    display_msgs <= '0';    
                END IF;
            END IF;
        END IF;
    END PROCESS;
    
    -- VCO output
    vco : stratixiigx_hssi_aux_clock_mult 
        GENERIC MAP (
            clk_multiply_by => multiply_by
            )
        PORT MAP (
            clk => pll_clkin,
            adjust => charge_pump,
            adjust_without_lol => adjust_without_lol,
            reset => reset,
            enable_m => dprioenable,
            m => m,
            clkout => clk_vco,
            busy => busy);     
    
    pd_div <= '1' WHEN (busy = INITIAL and adjust_without_lol = '0') ELSE '0';
    
    -- Feedback
    divide_by_M : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => multiply_by,
            extra_latency => 0)
        PORT MAP (
            clk => clk_vco,
            reset => reset,
            powerdown => pd_div,
            enable_d => dprioen_reg,
            d => m,
            clkout => clk_pll);   
            
    -- Extra phase shift on output
    
    extra_ps_clkout : stratixiigx_hssi_aux_clock_phaseshift
        GENERIC MAP (
            clk_phase_shift_by => sim_clkout_phase_shift * 1 ps
        )
        PORT MAP (
            clk  => clk_vco,
            clkout  => clk_div_delayed
        );
        
    -- Extra phase shift on lock
    
    extra_ps_lock : stratixiigx_hssi_aux_clock_phaseshift
        GENERIC MAP (
            clk_phase_shift_by => sim_clkout_phase_shift * 1 ps
        )
        PORT MAP (
            clk  => charge_pump,
            clkout  => charge_pump_delayed
        );
    
--    tmp_clkout <= clk_div_delayed AND (NOT charge_pump_delayed);
    tmp_clkout <= clk_div_delayed AND (locked_tmp);
    locked_tmp <= '0' WHEN (reset = '1') ELSE
              '1' WHEN (busy = INACTIVE or adjust_without_lol = '1') ELSE '0';
    locked <= locked_tmp;
    fbclkout <= clk_pll;
    vcobypassout <= pll_clkin;

END cmu_pll_arch;
--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 46 mux21 24 oper_mux 5 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_dskw_sm IS 
	 PORT 
	 ( 
		 align_det_sync	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 align_status	:	OUT  STD_LOGIC;
		 clk_1	:	IN  STD_LOGIC;
		 curr_state	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 enable_deskew	:	OUT  STD_LOGIC;
		 fifo_reset_rd	:	OUT  STD_LOGIC;
		 octal_mode	:	IN  STD_LOGIC;
		 rd_align	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 soft_reset	:	IN  STD_LOGIC;
		 sync_status	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0)
	 ); 
 END stratixiigx_hssi_dskw_sm;

 ARCHITECTURE RTL OF stratixiigx_hssi_dskw_sm IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nl0ll35	:	STD_LOGIC := '0';
	 SIGNAL	 nl0ll36	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl0ll36_w_lg_w_lg_q268w269w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0ll36_w_lg_q268w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0lO33	:	STD_LOGIC := '0';
	 SIGNAL	 nl0lO34	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl0lO34_w_lg_w_lg_q232w233w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0lO34_w_lg_q232w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0Oi31	:	STD_LOGIC := '0';
	 SIGNAL	 nl0Oi32	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl0Oi32_w_lg_w_lg_q227w228w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0Oi32_w_lg_q227w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0Ol29	:	STD_LOGIC := '0';
	 SIGNAL	 nl0Ol30	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl0Ol30_w_lg_w_lg_q198w199w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0Ol30_w_lg_q198w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0OO27	:	STD_LOGIC := '0';
	 SIGNAL	 nl0OO28	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl0OO28_w_lg_w_lg_q195w196w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OO28_w_lg_q195w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli0i19	:	STD_LOGIC := '0';
	 SIGNAL	 nli0i20	:	STD_LOGIC := '0';
	 SIGNAL  wire_nli0i20_w_lg_w_lg_q121w122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i20_w_lg_q121w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli0l17	:	STD_LOGIC := '0';
	 SIGNAL	 nli0l18	:	STD_LOGIC := '0';
	 SIGNAL  wire_nli0l18_w_lg_w_lg_q89w90w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0l18_w_lg_q89w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli1i25	:	STD_LOGIC := '0';
	 SIGNAL	 nli1i26	:	STD_LOGIC := '0';
	 SIGNAL  wire_nli1i26_w_lg_w_lg_q165w166w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1i26_w_lg_q165w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli1l23	:	STD_LOGIC := '0';
	 SIGNAL	 nli1l24	:	STD_LOGIC := '0';
	 SIGNAL  wire_nli1l24_w_lg_w_lg_q132w133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1l24_w_lg_q132w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli1O21	:	STD_LOGIC := '0';
	 SIGNAL	 nli1O22	:	STD_LOGIC := '0';
	 SIGNAL  wire_nli1O22_w_lg_w_lg_q128w129w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1O22_w_lg_q128w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliii15	:	STD_LOGIC := '0';
	 SIGNAL	 nliii16	:	STD_LOGIC := '0';
	 SIGNAL	 nliOi13	:	STD_LOGIC := '0';
	 SIGNAL	 nliOi14	:	STD_LOGIC := '0';
	 SIGNAL	 nll0i10	:	STD_LOGIC := '0';
	 SIGNAL	 nll0i9	:	STD_LOGIC := '0';
	 SIGNAL	 nll0O7	:	STD_LOGIC := '0';
	 SIGNAL	 nll0O8	:	STD_LOGIC := '0';
	 SIGNAL	 nll1i11	:	STD_LOGIC := '0';
	 SIGNAL	 nll1i12	:	STD_LOGIC := '0';
	 SIGNAL	 nlliO5	:	STD_LOGIC := '0';
	 SIGNAL	 nlliO6	:	STD_LOGIC := '0';
	 SIGNAL	 nllll3	:	STD_LOGIC := '0';
	 SIGNAL	 nllll4	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1i1	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1i2	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	nii	:	STD_LOGIC := '0';
	 SIGNAL	nil	:	STD_LOGIC := '0';
	 SIGNAL	nli	:	STD_LOGIC := '0';
	 SIGNAL	nllO	:	STD_LOGIC := '0';
	 SIGNAL	nlOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOl	:	STD_LOGIC := '0';
	 SIGNAL	wire_niO_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_niO_w_lg_nil83w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_nil83w84w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n00O	:	STD_LOGIC := '0';
	 SIGNAL	n0ii	:	STD_LOGIC := '0';
	 SIGNAL	nO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nl_w_lg_n00O271w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nO80w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0i_w_lg_dataout58w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1i_w_lg_dataout59w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0li_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0li_o	:	STD_LOGIC;
	 SIGNAL  wire_n0li_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0ll_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0ll_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ll_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0lO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0lO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0Oi_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_n0Oi_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0Ol_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_n0Ol_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0O126w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliiO158w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlili82w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nll1O57w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nli0O :	STD_LOGIC;
	 SIGNAL  nliiO :	STD_LOGIC;
	 SIGNAL  nlili :	STD_LOGIC;
	 SIGNAL  nlill :	STD_LOGIC;
	 SIGNAL  nlilO :	STD_LOGIC;
	 SIGNAL  nliOO :	STD_LOGIC;
	 SIGNAL  nll1O :	STD_LOGIC;
	 SIGNAL  nllil :	STD_LOGIC;
	 SIGNAL  nllli :	STD_LOGIC;
	 SIGNAL  nllOl :	STD_LOGIC;
 BEGIN

	wire_w_lg_nli0O126w(0) <= NOT nli0O;
	wire_w_lg_nliiO158w(0) <= NOT nliiO;
	wire_w_lg_nlili82w(0) <= NOT nlili;
	wire_w_lg_nll1O57w(0) <= NOT nll1O;
	wire_w_lg_soft_reset2w(0) <= NOT soft_reset;
	align_status <= nlOl;
	curr_state <= ( "0" & nlOi & nllO & n0il);
	enable_deskew <= n0ii;
	fifo_reset_rd <= (n0ii AND wire_nl_w_lg_n00O271w(0));
	nli0O <= wire_niO_w_lg_w_lg_nil83w84w(0);
	nliiO <= (wire_niO_w_lg_w_lg_nil83w84w(0) OR (NOT (nliii16 XOR nliii15)));
	nlili <= (wire_nl_w_lg_nO80w(0) AND wire_n0i_dataout);
	nlill <= (nil AND wire_nliO_dataout);
	nlilO <= ((((((((align_det_sync(0) AND align_det_sync(1)) AND align_det_sync(2)) AND align_det_sync(3)) AND align_det_sync(4)) AND align_det_sync(5)) AND align_det_sync(6)) AND align_det_sync(7)) AND (nliOi14 XOR nliOi13));
	nliOO <= (wire_n0i_w_lg_dataout58w(0) AND wire_n1i_w_lg_dataout59w(0));
	nll1O <= ((((((((rd_align(0) OR rd_align(1)) OR rd_align(2)) OR rd_align(3)) OR rd_align(4)) OR rd_align(5)) OR rd_align(6)) OR rd_align(7)) OR (NOT (nll0i10 XOR nll0i9)));
	nllil <= (((((((rd_align(0) AND rd_align(1)) AND rd_align(2)) AND rd_align(3)) AND rd_align(4)) AND rd_align(5)) AND rd_align(6)) AND rd_align(7));
	nllli <= ((((((((sync_status(0) AND sync_status(1)) AND sync_status(2)) AND sync_status(3)) AND sync_status(4)) AND sync_status(5)) AND sync_status(6)) AND sync_status(7)) AND (nllll4 XOR nllll3));
	nllOl <= '1';
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0ll35 <= nl0ll36;
		END IF;
		if (now = 0 ns) then
			nl0ll35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0ll36 <= nl0ll35;
		END IF;
	END PROCESS;
	wire_nl0ll36_w_lg_w_lg_q268w269w(0) <= wire_nl0ll36_w_lg_q268w(0) AND wire_n0OO_dataout;
	wire_nl0ll36_w_lg_q268w(0) <= nl0ll36 XOR nl0ll35;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0lO33 <= nl0lO34;
		END IF;
		if (now = 0 ns) then
			nl0lO33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0lO34 <= nl0lO33;
		END IF;
	END PROCESS;
	wire_nl0lO34_w_lg_w_lg_q232w233w(0) <= wire_nl0lO34_w_lg_q232w(0) AND wire_ni0l_dataout;
	wire_nl0lO34_w_lg_q232w(0) <= nl0lO34 XOR nl0lO33;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0Oi31 <= nl0Oi32;
		END IF;
		if (now = 0 ns) then
			nl0Oi31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0Oi32 <= nl0Oi31;
		END IF;
	END PROCESS;
	wire_nl0Oi32_w_lg_w_lg_q227w228w(0) <= wire_nl0Oi32_w_lg_q227w(0) AND nii;
	wire_nl0Oi32_w_lg_q227w(0) <= nl0Oi32 XOR nl0Oi31;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0Ol29 <= nl0Ol30;
		END IF;
		if (now = 0 ns) then
			nl0Ol29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0Ol30 <= nl0Ol29;
		END IF;
	END PROCESS;
	wire_nl0Ol30_w_lg_w_lg_q198w199w(0) <= wire_nl0Ol30_w_lg_q198w(0) AND wire_nili_dataout;
	wire_nl0Ol30_w_lg_q198w(0) <= nl0Ol30 XOR nl0Ol29;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0OO27 <= nl0OO28;
		END IF;
		if (now = 0 ns) then
			nl0OO27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0OO28 <= nl0OO27;
		END IF;
	END PROCESS;
	wire_nl0OO28_w_lg_w_lg_q195w196w(0) <= wire_nl0OO28_w_lg_q195w(0) AND wire_nill_dataout;
	wire_nl0OO28_w_lg_q195w(0) <= nl0OO28 XOR nl0OO27;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli0i19 <= nli0i20;
		END IF;
		if (now = 0 ns) then
			nli0i19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli0i20 <= nli0i19;
		END IF;
	END PROCESS;
	wire_nli0i20_w_lg_w_lg_q121w122w(0) <= wire_nli0i20_w_lg_q121w(0) AND nil;
	wire_nli0i20_w_lg_q121w(0) <= nli0i20 XOR nli0i19;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli0l17 <= nli0l18;
		END IF;
		if (now = 0 ns) then
			nli0l17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli0l18 <= nli0l17;
		END IF;
	END PROCESS;
	wire_nli0l18_w_lg_w_lg_q89w90w(0) <= wire_nli0l18_w_lg_q89w(0) AND n0il;
	wire_nli0l18_w_lg_q89w(0) <= nli0l18 XOR nli0l17;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1i25 <= nli1i26;
		END IF;
		if (now = 0 ns) then
			nli1i25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1i26 <= nli1i25;
		END IF;
	END PROCESS;
	wire_nli1i26_w_lg_w_lg_q165w166w(0) <= wire_nli1i26_w_lg_q165w(0) AND wire_w_lg_nli0O126w(0);
	wire_nli1i26_w_lg_q165w(0) <= nli1i26 XOR nli1i25;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1l23 <= nli1l24;
		END IF;
		if (now = 0 ns) then
			nli1l23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1l24 <= nli1l23;
		END IF;
	END PROCESS;
	wire_nli1l24_w_lg_w_lg_q132w133w(0) <= wire_nli1l24_w_lg_q132w(0) AND nllO;
	wire_nli1l24_w_lg_q132w(0) <= nli1l24 XOR nli1l23;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1O21 <= nli1O22;
		END IF;
		if (now = 0 ns) then
			nli1O21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1O22 <= nli1O21;
		END IF;
	END PROCESS;
	wire_nli1O22_w_lg_w_lg_q128w129w(0) <= wire_nli1O22_w_lg_q128w(0) AND n0il;
	wire_nli1O22_w_lg_q128w(0) <= nli1O22 XOR nli1O21;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nliii15 <= nliii16;
		END IF;
		if (now = 0 ns) then
			nliii15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nliii16 <= nliii15;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nliOi13 <= nliOi14;
		END IF;
		if (now = 0 ns) then
			nliOi13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nliOi14 <= nliOi13;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll0i10 <= nll0i9;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll0i9 <= nll0i10;
		END IF;
		if (now = 0 ns) then
			nll0i9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll0O7 <= nll0O8;
		END IF;
		if (now = 0 ns) then
			nll0O7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll0O8 <= nll0O7;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll1i11 <= nll1i12;
		END IF;
		if (now = 0 ns) then
			nll1i11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll1i12 <= nll1i11;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nlliO5 <= nlliO6;
		END IF;
		if (now = 0 ns) then
			nlliO5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nlliO6 <= nlliO5;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nllll3 <= nllll4;
		END IF;
		if (now = 0 ns) then
			nllll3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nllll4 <= nllll3;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nlO1i1 <= nlO1i2;
		END IF;
		if (now = 0 ns) then
			nlO1i1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nlO1i2 <= nlO1i1;
		END IF;
	END PROCESS;
	PROCESS (clk_1, wire_niO_CLRN)
	BEGIN
		IF (wire_niO_CLRN = '0') THEN
				n0il <= '0';
				nii <= '0';
				nil <= '0';
				nli <= '0';
				nllO <= '0';
				nlOi <= '0';
				nlOl <= '0';
		ELSIF (clk_1 = '1' AND clk_1'event) THEN
				n0il <= wire_n0lO_o;
				nii <= wire_n0ll_o;
				nil <= nli;
				nli <= wire_nll_dataout;
				nllO <= wire_n0Oi_o;
				nlOi <= wire_n0Ol_o;
				nlOl <= nii;
		END IF;
	END PROCESS;
	wire_niO_CLRN <= ((nlliO6 XOR nlliO5) AND wire_w_lg_soft_reset2w(0));
	wire_niO_w_lg_nil83w(0) <= NOT nil;
	wire_niO_w_lg_w_lg_nil83w84w(0) <= wire_niO_w_lg_nil83w(0) OR nliOO;
	PROCESS (clk_1, soft_reset, wire_nl_CLRN)
	BEGIN
		IF (soft_reset = '1') THEN
				n00O <= '1';
				n0ii <= '1';
				nO <= '1';
		ELSIF (wire_nl_CLRN = '0') THEN
				n00O <= '0';
				n0ii <= '0';
				nO <= '0';
		ELSIF (clk_1 = '1' AND clk_1'event) THEN
				n00O <= n0ii;
				n0ii <= wire_n0li_o;
				nO <= n00O;
		END IF;
	END PROCESS;
	wire_nl_CLRN <= (nlO1i2 XOR nlO1i1);
	wire_nl_w_lg_n00O271w(0) <= NOT n00O;
	wire_nl_w_lg_nO80w(0) <= NOT nO;
	wire_n0i_dataout <= nllil WHEN octal_mode = '1'  ELSE ((((rd_align(0) AND rd_align(1)) AND rd_align(2)) AND rd_align(3)) AND (nll0O8 XOR nll0O7));
	wire_n0i_w_lg_dataout58w(0) <= NOT wire_n0i_dataout;
	wire_n0OO_dataout <= n0ii OR nli0O;
	wire_n1i_dataout <= wire_w_lg_nll1O57w(0) WHEN octal_mode = '1'  ELSE (NOT ((((rd_align(0) OR rd_align(1)) OR rd_align(2)) OR rd_align(3)) OR (NOT (nll1i12 XOR nll1i11))));
	wire_n1i_w_lg_dataout59w(0) <= NOT wire_n1i_dataout;
	wire_ni0i_dataout <= n0ii OR wire_niO_w_lg_nil83w(0);
	wire_ni0l_dataout <= nii AND NOT(wire_niO_w_lg_nil83w(0));
	wire_ni0O_dataout <= wire_niil_dataout AND NOT(wire_niO_w_lg_nil83w(0));
	wire_ni1i_dataout <= nii AND NOT(nli0O);
	wire_ni1l_dataout <= wire_n0i_w_lg_dataout58w(0) AND NOT(nli0O);
	wire_niii_dataout <= wire_niiO_dataout AND NOT(wire_niO_w_lg_nil83w(0));
	wire_niil_dataout <= wire_n0i_dataout OR nliOO;
	wire_niiO_dataout <= wire_n0i_w_lg_dataout58w(0) OR nliOO;
	wire_nili_dataout <= wire_nilO_dataout AND NOT(wire_niO_w_lg_nil83w(0));
	wire_nill_dataout <= nliOO AND NOT(wire_niO_w_lg_nil83w(0));
	wire_nilO_dataout <= wire_n0i_w_lg_dataout58w(0) AND NOT(nliOO);
	wire_niOi_dataout <= nii WHEN nliiO = '1'  ELSE wire_nl1l_dataout;
	wire_niOl_dataout <= n0ii OR nliiO;
	wire_niOO_dataout <= wire_n0i_w_lg_dataout58w(0) AND NOT(nliiO);
	wire_nl0i_dataout <= wire_w_lg_nlili82w(0) AND NOT(nliiO);
	wire_nl0l_dataout <= nlili AND NOT(nliiO);
	wire_nl1i_dataout <= wire_n0i_dataout AND NOT(nliiO);
	wire_nl1l_dataout <= nii OR wire_n0i_dataout;
	wire_nlii_dataout <= n0ii AND NOT(nlill);
	wire_nliO_dataout <= nlilO WHEN octal_mode = '1'  ELSE (((align_det_sync(0) AND align_det_sync(1)) AND align_det_sync(2)) AND align_det_sync(3));
	wire_nll_dataout <= nllli WHEN octal_mode = '1'  ELSE (((sync_status(0) AND sync_status(1)) AND sync_status(2)) AND sync_status(3));
	wire_n0li_data <= ( wire_nl0ll36_w_lg_w_lg_q268w269w & wire_ni0i_dataout & wire_ni0i_dataout & wire_ni0i_dataout & wire_niOl_dataout & wire_niOl_dataout & wire_niOl_dataout & wire_nlii_dataout & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0");
	wire_n0li_sel <= ( "1" & nlOi & nllO & n0il);
	n0li :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0li_data,
		o => wire_n0li_o,
		sel => wire_n0li_sel
	  );
	wire_n0ll_data <= ( wire_ni1i_dataout & wire_ni0l_dataout & wire_ni0l_dataout & wire_nl0lO34_w_lg_w_lg_q232w233w & wire_niOi_dataout & nii & wire_nl0Oi32_w_lg_w_lg_q227w228w & nii & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0");
	wire_n0ll_sel <= ( "1" & nlOi & nllO & n0il);
	n0ll :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0ll_data,
		o => wire_n0ll_o,
		sel => wire_n0ll_sel
	  );
	wire_n0lO_data <= ( wire_ni1l_dataout & wire_ni0O_dataout & wire_nl0Ol30_w_lg_w_lg_q198w199w & wire_nl0OO28_w_lg_w_lg_q195w196w & wire_niOO_dataout & wire_nl1i_dataout & wire_nl0i_dataout & nlill & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0");
	wire_n0lO_sel <= ( "1" & nlOi & nllO & n0il);
	n0lO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0lO_data,
		o => wire_n0lO_o,
		sel => wire_n0lO_sel
	  );
	wire_n0Oi_data <= ( wire_nli1i26_w_lg_w_lg_q165w166w & wire_niii_dataout & wire_nill_dataout & "0" & wire_niOO_dataout & wire_w_lg_nliiO158w & wire_nl0l_dataout & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0");
	wire_n0Oi_sel <= ( "1" & nlOi & wire_nli1l24_w_lg_w_lg_q132w133w & wire_nli1O22_w_lg_w_lg_q128w129w);
	n0Oi :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0Oi_data,
		o => wire_n0Oi_o,
		sel => wire_n0Oi_sel
	  );
	wire_n0Ol_data <= ( wire_w_lg_nli0O126w & nil & nil & wire_nli0i20_w_lg_w_lg_q121w122w & wire_nl1i_dataout & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0");
	wire_n0Ol_sel <= ( "1" & nlOi & nllO & wire_nli0l18_w_lg_w_lg_q89w90w);
	n0Ol :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0Ol_data,
		o => wire_n0Ol_o,
		sel => wire_n0Ol_sel
	  );

 END RTL; --stratixiigx_hssi_dskw_sm
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 143 mux21 336 oper_add 1 oper_decoder 1 oper_less_than 1 oper_mux 39 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_tx_sm IS 
	 PORT 
	 ( 
		 curr_state	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 indv	:	IN  STD_LOGIC;
		 rd_enable_sync	:	IN  STD_LOGIC;
		 sm_ctl	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 sm_data	:	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 soft_reset	:	IN  STD_LOGIC;
		 tx_clk	:	IN  STD_LOGIC;
		 tx_ctl	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 tx_data	:	IN  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 tx_local_fault	:	OUT  STD_LOGIC;
		 tx_local_fault_clr	:	IN  STD_LOGIC;
		 tx_local_fault_det	:	OUT  STD_LOGIC
	 ); 
 END stratixiigx_hssi_tx_sm;

 ARCHITECTURE RTL OF stratixiigx_hssi_tx_sm IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 niOi0O49	:	STD_LOGIC := '0';
	 SIGNAL	 niOi0O50	:	STD_LOGIC := '0';
	 SIGNAL	 niOiii47	:	STD_LOGIC := '0';
	 SIGNAL	 niOiii48	:	STD_LOGIC := '0';
	 SIGNAL	 niOl0l45	:	STD_LOGIC := '0';
	 SIGNAL	 niOl0l46	:	STD_LOGIC := '0';
	 SIGNAL	 niOl0O43	:	STD_LOGIC := '0';
	 SIGNAL	 niOl0O44	:	STD_LOGIC := '0';
	 SIGNAL	 niOlil41	:	STD_LOGIC := '0';
	 SIGNAL	 niOlil42	:	STD_LOGIC := '0';
	 SIGNAL	 niOlOl39	:	STD_LOGIC := '0';
	 SIGNAL	 niOlOl40	:	STD_LOGIC := '0';
	 SIGNAL	 niOO0i37	:	STD_LOGIC := '0';
	 SIGNAL	 niOO0i38	:	STD_LOGIC := '0';
	 SIGNAL	 niOOiO35	:	STD_LOGIC := '0';
	 SIGNAL	 niOOiO36	:	STD_LOGIC := '0';
	 SIGNAL	 niOOOi33	:	STD_LOGIC := '0';
	 SIGNAL	 niOOOi34	:	STD_LOGIC := '0';
	 SIGNAL	 nl100O21	:	STD_LOGIC := '0';
	 SIGNAL	 nl100O22	:	STD_LOGIC := '0';
	 SIGNAL	 nl101O23	:	STD_LOGIC := '0';
	 SIGNAL	 nl101O24	:	STD_LOGIC := '0';
	 SIGNAL	 nl10lO19	:	STD_LOGIC := '0';
	 SIGNAL	 nl10lO20	:	STD_LOGIC := '0';
	 SIGNAL	 nl10OO17	:	STD_LOGIC := '0';
	 SIGNAL	 nl10OO18	:	STD_LOGIC := '0';
	 SIGNAL	 nl110l29	:	STD_LOGIC := '0';
	 SIGNAL	 nl110l30	:	STD_LOGIC := '0';
	 SIGNAL	 nl111l31	:	STD_LOGIC := '0';
	 SIGNAL	 nl111l32	:	STD_LOGIC := '0';
	 SIGNAL	 nl11il27	:	STD_LOGIC := '0';
	 SIGNAL	 nl11il28	:	STD_LOGIC := '0';
	 SIGNAL	 nl11lO25	:	STD_LOGIC := '0';
	 SIGNAL	 nl11lO26	:	STD_LOGIC := '0';
	 SIGNAL	 nl1i0O15	:	STD_LOGIC := '0';
	 SIGNAL	 nl1i0O16	:	STD_LOGIC := '0';
	 SIGNAL	 nl1ilO13	:	STD_LOGIC := '0';
	 SIGNAL	 nl1ilO14	:	STD_LOGIC := '0';
	 SIGNAL	 nl1l0l10	:	STD_LOGIC := '0';
	 SIGNAL	 nl1l0l9	:	STD_LOGIC := '0';
	 SIGNAL	 nl1l1i11	:	STD_LOGIC := '0';
	 SIGNAL	 nl1l1i12	:	STD_LOGIC := '0';
	 SIGNAL	 nl1lil7	:	STD_LOGIC := '0';
	 SIGNAL	 nl1lil8	:	STD_LOGIC := '0';
	 SIGNAL	 nl1lOi5	:	STD_LOGIC := '0';
	 SIGNAL	 nl1lOi6	:	STD_LOGIC := '0';
	 SIGNAL	 nl1O0O1	:	STD_LOGIC := '0';
	 SIGNAL	 nl1O0O2	:	STD_LOGIC := '0';
	 SIGNAL	 nl1O1l3	:	STD_LOGIC := '0';
	 SIGNAL	 nl1O1l4	:	STD_LOGIC := '0';
	 SIGNAL	n000i	:	STD_LOGIC := '0';
	 SIGNAL	n000l	:	STD_LOGIC := '0';
	 SIGNAL	n001l	:	STD_LOGIC := '0';
	 SIGNAL	n001O	:	STD_LOGIC := '0';
	 SIGNAL	n00ii	:	STD_LOGIC := '0';
	 SIGNAL	n00il	:	STD_LOGIC := '0';
	 SIGNAL	n0lO	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n110l	:	STD_LOGIC := '0';
	 SIGNAL	n110O	:	STD_LOGIC := '0';
	 SIGNAL	n111i	:	STD_LOGIC := '0';
	 SIGNAL	n111l	:	STD_LOGIC := '0';
	 SIGNAL	n111O	:	STD_LOGIC := '0';
	 SIGNAL	nii0i	:	STD_LOGIC := '0';
	 SIGNAL	nii0l	:	STD_LOGIC := '0';
	 SIGNAL	nii0O	:	STD_LOGIC := '0';
	 SIGNAL	niiii	:	STD_LOGIC := '0';
	 SIGNAL	niiiO	:	STD_LOGIC := '0';
	 SIGNAL	nliO1i	:	STD_LOGIC := '0';
	 SIGNAL	nliO1l	:	STD_LOGIC := '0';
	 SIGNAL	nll0O	:	STD_LOGIC := '0';
	 SIGNAL	nll10l	:	STD_LOGIC := '0';
	 SIGNAL	nll10O	:	STD_LOGIC := '0';
	 SIGNAL	nll1ii	:	STD_LOGIC := '0';
	 SIGNAL	nll1il	:	STD_LOGIC := '0';
	 SIGNAL	nll1iO	:	STD_LOGIC := '0';
	 SIGNAL	nll1li	:	STD_LOGIC := '0';
	 SIGNAL	nlll1l	:	STD_LOGIC := '0';
	 SIGNAL	nlllii	:	STD_LOGIC := '0';
	 SIGNAL	nlllil	:	STD_LOGIC := '0';
	 SIGNAL	nllliO	:	STD_LOGIC := '0';
	 SIGNAL	nlllli	:	STD_LOGIC := '0';
	 SIGNAL	nllllO	:	STD_LOGIC := '0';
	 SIGNAL	nlllOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOO	:	STD_LOGIC := '0';
	 SIGNAL	wire_n0Oi_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi_PRN	:	STD_LOGIC;
	 SIGNAL  wire_n0Oi_w_lg_w_lg_w_lg_nll0O287w288w289w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0Oi_w_lg_n0lO296w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0Oi_w_lg_n0Ol1433w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0Oi_w_lg_nliO1l166w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0Oi_w_lg_nll0O287w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0Oi_w_lg_w_lg_nll0O287w288w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n000O	:	STD_LOGIC := '0';
	 SIGNAL	n001i	:	STD_LOGIC := '0';
	 SIGNAL	n01OO	:	STD_LOGIC := '0';
	 SIGNAL	n0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	n110i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	nii1l	:	STD_LOGIC := '0';
	 SIGNAL	nii1O	:	STD_LOGIC := '0';
	 SIGNAL	niiil	:	STD_LOGIC := '0';
	 SIGNAL	niili	:	STD_LOGIC := '0';
	 SIGNAL	nliiO	:	STD_LOGIC := '0';
	 SIGNAL	nlili	:	STD_LOGIC := '0';
	 SIGNAL	nlilOi	:	STD_LOGIC := '0';
	 SIGNAL	nlilOl	:	STD_LOGIC := '0';
	 SIGNAL	nlilOO	:	STD_LOGIC := '0';
	 SIGNAL	nliOOi	:	STD_LOGIC := '0';
	 SIGNAL	nll0i	:	STD_LOGIC := '0';
	 SIGNAL	nll0l	:	STD_LOGIC := '0';
	 SIGNAL	nlliO	:	STD_LOGIC := '0';
	 SIGNAL	nlll0l	:	STD_LOGIC := '0';
	 SIGNAL	nlll0O	:	STD_LOGIC := '0';
	 SIGNAL	nlll1i	:	STD_LOGIC := '0';
	 SIGNAL	nlllll	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOl	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni1i_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_lg_w_lg_ni1l292w298w1434w1435w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_lg_w_lg_ni1l292w298w299w300w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_lg_ni1l292w294w295w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_lg_ni1l292w298w1434w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_lg_ni1l292w298w299w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_ni1l292w294w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_ni1l292w298w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_n0OO293w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_ni1l292w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_niili305w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_nliiO304w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_nlll1i164w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nll00i	:	STD_LOGIC := '0';
	 SIGNAL	nll01i	:	STD_LOGIC := '0';
	 SIGNAL	nll1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nll1OO	:	STD_LOGIC := '0';
	 SIGNAL	nlliil	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlliii_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nlliii_w_lg_nlliil1788w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nll00l	:	STD_LOGIC := '0';
	 SIGNAL	nll00O	:	STD_LOGIC := '0';
	 SIGNAL	nll01l	:	STD_LOGIC := '0';
	 SIGNAL	nll01O	:	STD_LOGIC := '0';
	 SIGNAL	nll0ii	:	STD_LOGIC := '0';
	 SIGNAL	nll0il	:	STD_LOGIC := '0';
	 SIGNAL	nll0iO	:	STD_LOGIC := '0';
	 SIGNAL	nll0li	:	STD_LOGIC := '0';
	 SIGNAL	nll0ll	:	STD_LOGIC := '0';
	 SIGNAL	nll0lO	:	STD_LOGIC := '0';
	 SIGNAL	nll0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nll0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nll0OO	:	STD_LOGIC := '0';
	 SIGNAL	nll1ll	:	STD_LOGIC := '0';
	 SIGNAL	nll1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlli0i	:	STD_LOGIC := '0';
	 SIGNAL	nlli0l	:	STD_LOGIC := '0';
	 SIGNAL	nlli0O	:	STD_LOGIC := '0';
	 SIGNAL	nlli1i	:	STD_LOGIC := '0';
	 SIGNAL	nlli1l	:	STD_LOGIC := '0';
	 SIGNAL	nlli1O	:	STD_LOGIC := '0';
	 SIGNAL	nlliiO	:	STD_LOGIC := '0';
	 SIGNAL	nllili	:	STD_LOGIC := '0';
	 SIGNAL	nllill	:	STD_LOGIC := '0';
	 SIGNAL	nllilO	:	STD_LOGIC := '0';
	 SIGNAL	nlliOi	:	STD_LOGIC := '0';
	 SIGNAL	nlliOO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlliOl_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nlliOl_w_lg_w_lg_w_lg_w1785w1787w1789w1790w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_w_lg_w1785w1787w1789w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_w1785w1787w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w1785w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_w_lg_w_lg_w_lg_nlliOO1777w1779w1781w1783w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_w_lg_w_lg_nlliOO1777w1779w1781w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_w_lg_nlliOO1777w1779w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll00l1821w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll00O1819w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll0ii1817w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll0il1815w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll0iO1813w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll0li1811w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll0ll1809w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll0lO1807w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll0Oi1805w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll0Ol1803w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nll0OO1801w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nlli0i1793w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nlli0l1791w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nlli1i1799w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nlli1l1797w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nlli1O1795w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nlliiO1786w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nllili1784w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nllill1782w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nllilO1780w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nlliOi1778w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOl_w_lg_nlliOO1777w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliOOl_a	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nliOOl_b	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_nliOOl_o	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nlOlO_i	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlOlO_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nlO0O_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO0O_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO0O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0i_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0i0i_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0i0l_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0i0l_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0i0O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0i0O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0i1O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0i1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i1O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0iii_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0iii_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iii_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0iil_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0iil_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iil_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0iiO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0iiO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iiO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0ili_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0ili_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ili_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0ill_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n0ill_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ill_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n100i_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n100i_o	:	STD_LOGIC;
	 SIGNAL  wire_n100i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n100l_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n100l_o	:	STD_LOGIC;
	 SIGNAL  wire_n100l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n100O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n100O_o	:	STD_LOGIC;
	 SIGNAL  wire_n100O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n101i_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n101i_o	:	STD_LOGIC;
	 SIGNAL  wire_n101i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n101l_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n101l_o	:	STD_LOGIC;
	 SIGNAL  wire_n101l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n101O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n101O_o	:	STD_LOGIC;
	 SIGNAL  wire_n101O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n10ii_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n10ii_o	:	STD_LOGIC;
	 SIGNAL  wire_n10ii_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n10il_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n10il_o	:	STD_LOGIC;
	 SIGNAL  wire_n10il_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n10iO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n10iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n10iO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil0l_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nil0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil0O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nil0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilii_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilii_o	:	STD_LOGIC;
	 SIGNAL  wire_nilii_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilil_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilil_o	:	STD_LOGIC;
	 SIGNAL  wire_nilil_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niliO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_niliO_o	:	STD_LOGIC;
	 SIGNAL  wire_niliO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilli_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilli_o	:	STD_LOGIC;
	 SIGNAL  wire_nilli_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilll_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilll_o	:	STD_LOGIC;
	 SIGNAL  wire_nilll_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nillO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nillO_o	:	STD_LOGIC;
	 SIGNAL  wire_nillO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOi_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOi_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOil_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nllOil_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOil_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOiO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nllOiO_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOiO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOli_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nllOli_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOli_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOll_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nllOll_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOll_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOlO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nllOlO_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOlO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOOi_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nllOOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOOi_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOOl_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nllOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOOl_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOOO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nllOOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOOO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO11i_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nlO11i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO11i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlOil_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nlOil_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOil_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlOiO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nlOiO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOiO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlOli_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nlOli_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOli_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_tx_ctl_range35w139w140w141w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rd_enable_sync284w285w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_tx_ctl_range35w139w140w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rd_enable_sync162w282w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOl1i1431w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rd_enable_sync284w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range1w3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range1w149w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range35w37w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range35w139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range63w65w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range94w96w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range316w1534w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range872w1634w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range1156w1765w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range594w1587w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOl0i161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOl1l165w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOl1O163w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOliO1145w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOO0O1144w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOOll126w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOOlO124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOOOO119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl100l85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl101i92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl101l90w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10il80w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10iO78w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10li76w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10ll74w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10Ol69w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl110i112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl111i117w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11ii107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11li102w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11ll100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11Ol95w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1i0i61w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1i0l59w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1i1l64w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1iil54w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1iiO52w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1ili50w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1ill48w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1iOl43w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1iOO41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1l1O36w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1lii30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1lli25w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1lll23w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1llO21w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1lOO16w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1O0i9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1O0l7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1O1i14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1Oli2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rd_enable_sync162w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range35w148w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range871w1619w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range315w1533w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range1155w1666w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range593w1572w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_rd_enable_sync162w282w283w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  niOi0l :	STD_LOGIC;
	 SIGNAL  niOiil :	STD_LOGIC;
	 SIGNAL  niOiiO :	STD_LOGIC;
	 SIGNAL  niOili :	STD_LOGIC;
	 SIGNAL  niOill :	STD_LOGIC;
	 SIGNAL  niOilO :	STD_LOGIC;
	 SIGNAL  niOiOi :	STD_LOGIC;
	 SIGNAL  niOiOl :	STD_LOGIC;
	 SIGNAL  niOiOO :	STD_LOGIC;
	 SIGNAL  niOl0i :	STD_LOGIC;
	 SIGNAL  niOl1i :	STD_LOGIC;
	 SIGNAL  niOl1l :	STD_LOGIC;
	 SIGNAL  niOl1O :	STD_LOGIC;
	 SIGNAL  niOlii :	STD_LOGIC;
	 SIGNAL  niOliO :	STD_LOGIC;
	 SIGNAL  niOlli :	STD_LOGIC;
	 SIGNAL  niOlll :	STD_LOGIC;
	 SIGNAL  niOllO :	STD_LOGIC;
	 SIGNAL  niOlOi :	STD_LOGIC;
	 SIGNAL  niOO0O :	STD_LOGIC;
	 SIGNAL  niOO1i :	STD_LOGIC;
	 SIGNAL  niOO1l :	STD_LOGIC;
	 SIGNAL  niOO1O :	STD_LOGIC;
	 SIGNAL  niOOii :	STD_LOGIC;
	 SIGNAL  niOOil :	STD_LOGIC;
	 SIGNAL  niOOll :	STD_LOGIC;
	 SIGNAL  niOOlO :	STD_LOGIC;
	 SIGNAL  niOOOO :	STD_LOGIC;
	 SIGNAL  nl100l :	STD_LOGIC;
	 SIGNAL  nl101i :	STD_LOGIC;
	 SIGNAL  nl101l :	STD_LOGIC;
	 SIGNAL  nl10il :	STD_LOGIC;
	 SIGNAL  nl10iO :	STD_LOGIC;
	 SIGNAL  nl10li :	STD_LOGIC;
	 SIGNAL  nl10ll :	STD_LOGIC;
	 SIGNAL  nl10Ol :	STD_LOGIC;
	 SIGNAL  nl110i :	STD_LOGIC;
	 SIGNAL  nl111i :	STD_LOGIC;
	 SIGNAL  nl11ii :	STD_LOGIC;
	 SIGNAL  nl11li :	STD_LOGIC;
	 SIGNAL  nl11ll :	STD_LOGIC;
	 SIGNAL  nl11Ol :	STD_LOGIC;
	 SIGNAL  nl11OO :	STD_LOGIC;
	 SIGNAL  nl1i0i :	STD_LOGIC;
	 SIGNAL  nl1i0l :	STD_LOGIC;
	 SIGNAL  nl1i1l :	STD_LOGIC;
	 SIGNAL  nl1i1O :	STD_LOGIC;
	 SIGNAL  nl1iil :	STD_LOGIC;
	 SIGNAL  nl1iiO :	STD_LOGIC;
	 SIGNAL  nl1ili :	STD_LOGIC;
	 SIGNAL  nl1ill :	STD_LOGIC;
	 SIGNAL  nl1iOl :	STD_LOGIC;
	 SIGNAL  nl1iOO :	STD_LOGIC;
	 SIGNAL  nl1l0i :	STD_LOGIC;
	 SIGNAL  nl1l1O :	STD_LOGIC;
	 SIGNAL  nl1lii :	STD_LOGIC;
	 SIGNAL  nl1lli :	STD_LOGIC;
	 SIGNAL  nl1lll :	STD_LOGIC;
	 SIGNAL  nl1llO :	STD_LOGIC;
	 SIGNAL  nl1lOO :	STD_LOGIC;
	 SIGNAL  nl1O0i :	STD_LOGIC;
	 SIGNAL  nl1O0l :	STD_LOGIC;
	 SIGNAL  nl1O1i :	STD_LOGIC;
	 SIGNAL  nl1Oli :	STD_LOGIC;
	 SIGNAL  wire_w_tx_ctl_range1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_ctl_range35w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_ctl_range63w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_ctl_range94w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range316w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range872w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range871w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range315w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range1156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range1155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range594w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range593w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_w_lg_w_lg_w_tx_ctl_range35w139w140w141w(0) <= wire_w_lg_w_lg_w_tx_ctl_range35w139w140w(0) AND niOO1i;
	wire_w_lg_w_lg_rd_enable_sync284w285w(0) <= wire_w_lg_rd_enable_sync284w(0) AND niOl1i;
	wire_w_lg_w_lg_w_tx_ctl_range35w139w140w(0) <= wire_w_lg_w_tx_ctl_range35w139w(0) AND wire_w_tx_ctl_range94w(0);
	wire_w_lg_w_lg_rd_enable_sync162w282w(0) <= wire_w_lg_rd_enable_sync162w(0) AND niOiOi;
	wire_w_lg_niOl1i1431w(0) <= niOl1i AND wire_w_lg_niOl1l165w(0);
	wire_w_lg_rd_enable_sync284w(0) <= rd_enable_sync AND niOiOi;
	wire_w_lg_w_tx_ctl_range1w3w(0) <= wire_w_tx_ctl_range1w(0) AND wire_w_lg_nl1Oli2w(0);
	wire_w_lg_w_tx_ctl_range1w149w(0) <= wire_w_tx_ctl_range1w(0) AND wire_w_lg_w_tx_ctl_range35w148w(0);
	wire_w_lg_w_tx_ctl_range35w37w(0) <= wire_w_tx_ctl_range35w(0) AND wire_w_lg_nl1l1O36w(0);
	wire_w_lg_w_tx_ctl_range35w139w(0) <= wire_w_tx_ctl_range35w(0) AND wire_w_tx_ctl_range63w(0);
	wire_w_lg_w_tx_ctl_range63w65w(0) <= wire_w_tx_ctl_range63w(0) AND wire_w_lg_nl1i1l64w(0);
	wire_w_lg_w_tx_ctl_range94w96w(0) <= wire_w_tx_ctl_range94w(0) AND wire_w_lg_nl11Ol95w(0);
	wire_w_lg_w_tx_data_range316w1534w(0) <= wire_w_tx_data_range316w(0) AND wire_w_lg_w_tx_data_range315w1533w(0);
	wire_w_lg_w_tx_data_range872w1634w(0) <= wire_w_tx_data_range872w(0) AND wire_w_lg_w_tx_data_range871w1619w(0);
	wire_w_lg_w_tx_data_range1156w1765w(0) <= wire_w_tx_data_range1156w(0) AND wire_w_lg_w_tx_data_range1155w1666w(0);
	wire_w_lg_w_tx_data_range594w1587w(0) <= wire_w_tx_data_range594w(0) AND wire_w_lg_w_tx_data_range593w1572w(0);
	wire_w_lg_niOl0i161w(0) <= NOT niOl0i;
	wire_w_lg_niOl1l165w(0) <= NOT niOl1l;
	wire_w_lg_niOl1O163w(0) <= NOT niOl1O;
	wire_w_lg_niOliO1145w(0) <= NOT niOliO;
	wire_w_lg_niOO0O1144w(0) <= NOT niOO0O;
	wire_w_lg_niOOll126w(0) <= NOT niOOll;
	wire_w_lg_niOOlO124w(0) <= NOT niOOlO;
	wire_w_lg_niOOOO119w(0) <= NOT niOOOO;
	wire_w_lg_nl100l85w(0) <= NOT nl100l;
	wire_w_lg_nl101i92w(0) <= NOT nl101i;
	wire_w_lg_nl101l90w(0) <= NOT nl101l;
	wire_w_lg_nl10il80w(0) <= NOT nl10il;
	wire_w_lg_nl10iO78w(0) <= NOT nl10iO;
	wire_w_lg_nl10li76w(0) <= NOT nl10li;
	wire_w_lg_nl10ll74w(0) <= NOT nl10ll;
	wire_w_lg_nl10Ol69w(0) <= NOT nl10Ol;
	wire_w_lg_nl110i112w(0) <= NOT nl110i;
	wire_w_lg_nl111i117w(0) <= NOT nl111i;
	wire_w_lg_nl11ii107w(0) <= NOT nl11ii;
	wire_w_lg_nl11li102w(0) <= NOT nl11li;
	wire_w_lg_nl11ll100w(0) <= NOT nl11ll;
	wire_w_lg_nl11Ol95w(0) <= NOT nl11Ol;
	wire_w_lg_nl1i0i61w(0) <= NOT nl1i0i;
	wire_w_lg_nl1i0l59w(0) <= NOT nl1i0l;
	wire_w_lg_nl1i1l64w(0) <= NOT nl1i1l;
	wire_w_lg_nl1iil54w(0) <= NOT nl1iil;
	wire_w_lg_nl1iiO52w(0) <= NOT nl1iiO;
	wire_w_lg_nl1ili50w(0) <= NOT nl1ili;
	wire_w_lg_nl1ill48w(0) <= NOT nl1ill;
	wire_w_lg_nl1iOl43w(0) <= NOT nl1iOl;
	wire_w_lg_nl1iOO41w(0) <= NOT nl1iOO;
	wire_w_lg_nl1l1O36w(0) <= NOT nl1l1O;
	wire_w_lg_nl1lii30w(0) <= NOT nl1lii;
	wire_w_lg_nl1lli25w(0) <= NOT nl1lli;
	wire_w_lg_nl1lll23w(0) <= NOT nl1lll;
	wire_w_lg_nl1llO21w(0) <= NOT nl1llO;
	wire_w_lg_nl1lOO16w(0) <= NOT nl1lOO;
	wire_w_lg_nl1O0i9w(0) <= NOT nl1O0i;
	wire_w_lg_nl1O0l7w(0) <= NOT nl1O0l;
	wire_w_lg_nl1O1i14w(0) <= NOT nl1O1i;
	wire_w_lg_nl1Oli2w(0) <= NOT nl1Oli;
	wire_w_lg_rd_enable_sync162w(0) <= NOT rd_enable_sync;
	wire_w_lg_soft_reset156w(0) <= NOT soft_reset;
	wire_w_lg_w_tx_ctl_range35w148w(0) <= NOT wire_w_tx_ctl_range35w(0);
	wire_w_lg_w_tx_data_range871w1619w(0) <= NOT wire_w_tx_data_range871w(0);
	wire_w_lg_w_tx_data_range315w1533w(0) <= NOT wire_w_tx_data_range315w(0);
	wire_w_lg_w_tx_data_range1155w1666w(0) <= NOT wire_w_tx_data_range1155w(0);
	wire_w_lg_w_tx_data_range593w1572w(0) <= NOT wire_w_tx_data_range593w(0);
	wire_w_lg_w_lg_w_lg_rd_enable_sync162w282w283w(0) <= wire_w_lg_w_lg_rd_enable_sync162w282w(0) OR wire_nlO0O_o;
	curr_state <= ( ni1l & n0OO & n0Ol & n0lO);
	niOi0l <= (wire_w_lg_niOl1i1431w(0) AND (((wire_ni1i_w_lg_w_lg_w_lg_ni1l292w298w299w(0) AND wire_n0Oi_w_lg_n0lO296w(0)) OR wire_ni1i_w_lg_w_lg_w_lg_w_lg_ni1l292w298w1434w1435w(0)) OR (nll0O AND niOiOO)));
	niOiil <= (niOlll OR niOiiO);
	niOiiO <= (niOO1l OR niOlOi);
	niOili <= (niOill AND (wire_ni1i_w_lg_nliiO304w(0) AND wire_ni1i_w_lg_niili305w(0)));
	niOill <= ((((((((((((((((wire_nlliOl_w_lg_w_lg_w_lg_w1785w1787w1789w1790w(0) AND wire_nlliOl_w_lg_nlli0l1791w(0)) AND wire_nlliOl_w_lg_nlli0i1793w(0)) AND wire_nlliOl_w_lg_nlli1O1795w(0)) AND wire_nlliOl_w_lg_nlli1l1797w(0)) AND wire_nlliOl_w_lg_nlli1i1799w(0)) AND wire_nlliOl_w_lg_nll0OO1801w(0)) AND wire_nlliOl_w_lg_nll0Ol1803w(0)) AND wire_nlliOl_w_lg_nll0Oi1805w(0)) AND wire_nlliOl_w_lg_nll0lO1807w(0)) AND wire_nlliOl_w_lg_nll0ll1809w(0)) AND wire_nlliOl_w_lg_nll0li1811w(0)) AND wire_nlliOl_w_lg_nll0iO1813w(0)) AND wire_nlliOl_w_lg_nll0il1815w(0)) AND wire_nlliOl_w_lg_nll0ii1817w(0)) AND wire_nlliOl_w_lg_nll00O1819w(0)) AND wire_nlliOl_w_lg_nll00l1821w(0));
	niOilO <= ((((wire_ni1i_w_lg_w_lg_w_lg_ni1l292w294w295w(0) AND wire_n0Oi_w_lg_n0lO296w(0)) OR wire_ni1i_w_lg_w_lg_w_lg_w_lg_ni1l292w298w299w300w(0)) AND niOl1i) AND nlll1i);
	niOiOi <= (wire_ni1i_w_lg_w_lg_w_lg_ni1l292w294w295w(0) AND n0lO);
	niOiOl <= (niOl1i AND niOiOO);
	niOiOO <= ((wire_ni1i_w_lg_w_lg_ni1l292w294w(0) AND wire_n0Oi_w_lg_n0Ol1433w(0)) AND n0lO);
	niOl0i <= (wire_w_lg_niOO0O1144w(0) AND wire_w_lg_niOliO1145w(0));
	niOl1i <= (niOO0O OR niOliO);
	niOl1l <= ((((nliOOi OR nliO1i) OR nlilOO) OR nlilOl) OR nlilOi);
	niOl1O <= (nll0O AND wire_w_lg_niOl1l165w(0));
	niOlii <= '1';
	niOliO <= (((wire_w_lg_w_tx_ctl_range1w149w(0) AND (NOT tx_ctl(2))) AND (NOT tx_ctl(3))) AND nl1O0l);
	niOlli <= (tx_ctl(3) AND nl11ii);
	niOlll <= ((tx_ctl(2) AND tx_ctl(3)) AND niOllO);
	niOllO <= ((((((((((((((wire_w_lg_w_tx_data_range872w1634w(0) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND tx_data(21)) AND tx_data(22)) AND tx_data(23)) AND tx_data(24)) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND (NOT tx_data(28))) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	niOlOi <= (wire_w_lg_w_lg_w_lg_w_tx_ctl_range35w139w140w141w(0) AND (niOlOl40 XOR niOlOl39));
	niOO0O <= ((((tx_ctl(0) AND tx_ctl(1)) AND tx_ctl(2)) AND tx_ctl(3)) AND niOOii);
	niOO1i <= ((((((((((((((((((((((wire_w_lg_w_tx_data_range594w1587w(0) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND tx_data(13)) AND tx_data(14)) AND tx_data(15)) AND tx_data(16)) AND tx_data(17)) AND tx_data(18)) AND (NOT tx_data(19))) AND (NOT tx_data(20))) AND (NOT tx_data(21))) AND (NOT tx_data(22))) AND (NOT tx_data(23))) AND tx_data(24)) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND (NOT tx_data(28))) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	niOO1l <= (((((tx_ctl(0) AND tx_ctl(1)) AND tx_ctl(2)) AND tx_ctl(3)) AND (niOO0i38 XOR niOO0i37)) AND niOO1O);
	niOO1O <= ((((((((((((((((((((((((((((((wire_w_lg_w_tx_data_range316w1534w(0) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND tx_data(5)) AND tx_data(6)) AND tx_data(7)) AND tx_data(8)) AND tx_data(9)) AND tx_data(10)) AND (NOT tx_data(11))) AND (NOT tx_data(12))) AND (NOT tx_data(13))) AND (NOT tx_data(14))) AND (NOT tx_data(15))) AND tx_data(16)) AND tx_data(17)) AND tx_data(18)) AND (NOT tx_data(19))) AND (NOT tx_data(20))) AND (NOT tx_data(21))) AND (NOT tx_data(22))) AND (NOT tx_data(23))) AND tx_data(24)) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND (NOT tx_data(28))) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	niOOii <= (((((((((((((((((((((((((((((((tx_data(0) AND tx_data(1)) AND tx_data(2)) AND (NOT tx_data(3))) AND (NOT tx_data(4))) AND (NOT tx_data(5))) AND (NOT tx_data(6))) AND (NOT tx_data(7))) AND tx_data(8)) AND tx_data(9)) AND tx_data(10)) AND (NOT tx_data(11))) AND (NOT tx_data(12))) AND (NOT tx_data(13))) AND (NOT tx_data(14))) AND (NOT tx_data(15))) AND tx_data(16)) AND tx_data(17)) AND tx_data(18)) AND (NOT tx_data(19))) AND (NOT tx_data(20))) AND (NOT tx_data(21))) AND (NOT tx_data(22))) AND (NOT tx_data(23))) AND tx_data(24)) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND (NOT tx_data(28))) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	niOOil <= ((((((((((((((wire_w_lg_w_tx_ctl_range94w96w(0) AND (nl11lO26 XOR nl11lO25)) AND wire_w_lg_nl11ll100w(0)) AND wire_w_lg_nl11li102w(0)) AND (nl11il28 XOR nl11il27)) AND wire_w_lg_nl11ii107w(0)) AND (nl110l30 XOR nl110l29)) AND wire_w_lg_nl110i112w(0)) AND (nl111l32 XOR nl111l31)) AND wire_w_lg_nl111i117w(0)) AND wire_w_lg_niOOOO119w(0)) AND (niOOOi34 XOR niOOOi33)) AND wire_w_lg_niOOlO124w(0)) AND wire_w_lg_niOOll126w(0)) AND (niOOiO36 XOR niOOiO35));
	niOOll <= (((((((tx_data(24) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND tx_data(28)) AND tx_data(29)) AND tx_data(30)) AND tx_data(31));
	niOOlO <= ((((((((NOT tx_data(24)) AND wire_w_lg_w_tx_data_range1155w1666w(0)) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND tx_data(29)) AND tx_data(30)) AND tx_data(31));
	niOOOO <= ((((((((NOT tx_data(24)) AND wire_w_lg_w_tx_data_range1155w1666w(0)) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND (NOT tx_data(29))) AND tx_data(30)) AND tx_data(31));
	nl100l <= ((((((((NOT tx_data(16)) AND wire_w_lg_w_tx_data_range871w1619w(0)) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND (NOT tx_data(21))) AND tx_data(22)) AND tx_data(23));
	nl101i <= (((((((tx_data(16) AND tx_data(17)) AND tx_data(18)) AND (NOT tx_data(19))) AND tx_data(20)) AND tx_data(21)) AND tx_data(22)) AND tx_data(23));
	nl101l <= ((((((((NOT tx_data(16)) AND wire_w_lg_w_tx_data_range871w1619w(0)) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND tx_data(21)) AND tx_data(22)) AND tx_data(23));
	nl10il <= ((((((((NOT tx_data(16)) AND wire_w_lg_w_tx_data_range871w1619w(0)) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND (NOT tx_data(21))) AND tx_data(22)) AND (NOT tx_data(23)));
	nl10iO <= ((((((((NOT tx_data(16)) AND wire_w_lg_w_tx_data_range871w1619w(0)) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND tx_data(21)) AND (NOT tx_data(22))) AND (NOT tx_data(23)));
	nl10li <= ((((((wire_w_lg_w_tx_data_range872w1634w(0) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND tx_data(21)) AND tx_data(22)) AND tx_data(23));
	nl10ll <= (((((((tx_data(16) AND tx_data(17)) AND (NOT tx_data(18))) AND tx_data(19)) AND tx_data(20)) AND tx_data(21)) AND tx_data(22)) AND tx_data(23));
	nl10Ol <= ((((((((NOT tx_data(16)) AND wire_w_lg_w_tx_data_range871w1619w(0)) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND (NOT tx_data(21))) AND (NOT tx_data(22))) AND tx_data(23));
	nl110i <= ((((((((NOT tx_data(24)) AND wire_w_lg_w_tx_data_range1155w1666w(0)) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND tx_data(29)) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	nl111i <= ((((((((NOT tx_data(24)) AND wire_w_lg_w_tx_data_range1155w1666w(0)) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND (NOT tx_data(29))) AND tx_data(30)) AND (NOT tx_data(31)));
	nl11ii <= ((((((wire_w_lg_w_tx_data_range1156w1765w(0) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND tx_data(29)) AND tx_data(30)) AND tx_data(31));
	nl11li <= (((((((tx_data(24) AND tx_data(25)) AND (NOT tx_data(26))) AND tx_data(27)) AND tx_data(28)) AND tx_data(29)) AND tx_data(30)) AND tx_data(31));
	nl11ll <= ((((((((NOT tx_data(24)) AND wire_w_lg_w_tx_data_range1155w1666w(0)) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND tx_data(31));
	nl11Ol <= (((((((tx_data(24) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND (NOT tx_data(28))) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	nl11OO <= ((((((((((((wire_w_lg_w_tx_ctl_range63w65w(0) AND (nl10OO18 XOR nl10OO17)) AND wire_w_lg_nl10Ol69w(0)) AND (nl10lO20 XOR nl10lO19)) AND wire_w_lg_nl10ll74w(0)) AND wire_w_lg_nl10li76w(0)) AND wire_w_lg_nl10iO78w(0)) AND wire_w_lg_nl10il80w(0)) AND (nl100O22 XOR nl100O21)) AND wire_w_lg_nl100l85w(0)) AND (nl101O24 XOR nl101O23)) AND wire_w_lg_nl101l90w(0)) AND wire_w_lg_nl101i92w(0));
	nl1i0i <= (((((((tx_data(8) AND tx_data(9)) AND tx_data(10)) AND (NOT tx_data(11))) AND tx_data(12)) AND tx_data(13)) AND tx_data(14)) AND tx_data(15));
	nl1i0l <= ((((((((NOT tx_data(8)) AND wire_w_lg_w_tx_data_range593w1572w(0)) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND tx_data(13)) AND tx_data(14)) AND tx_data(15));
	nl1i1l <= (((((((tx_data(16) AND tx_data(17)) AND tx_data(18)) AND (NOT tx_data(19))) AND (NOT tx_data(20))) AND (NOT tx_data(21))) AND (NOT tx_data(22))) AND (NOT tx_data(23)));
	nl1i1O <= (((((((((((wire_w_lg_w_tx_ctl_range35w37w(0) AND (nl1l1i12 XOR nl1l1i11)) AND wire_w_lg_nl1iOO41w(0)) AND wire_w_lg_nl1iOl43w(0)) AND (nl1ilO14 XOR nl1ilO13)) AND wire_w_lg_nl1ill48w(0)) AND wire_w_lg_nl1ili50w(0)) AND wire_w_lg_nl1iiO52w(0)) AND wire_w_lg_nl1iil54w(0)) AND (nl1i0O16 XOR nl1i0O15)) AND wire_w_lg_nl1i0l59w(0)) AND wire_w_lg_nl1i0i61w(0));
	nl1iil <= ((((((((NOT tx_data(8)) AND wire_w_lg_w_tx_data_range593w1572w(0)) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND (NOT tx_data(13))) AND tx_data(14)) AND tx_data(15));
	nl1iiO <= ((((((((NOT tx_data(8)) AND wire_w_lg_w_tx_data_range593w1572w(0)) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND (NOT tx_data(13))) AND tx_data(14)) AND (NOT tx_data(15)));
	nl1ili <= ((((((((NOT tx_data(8)) AND wire_w_lg_w_tx_data_range593w1572w(0)) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND tx_data(13)) AND (NOT tx_data(14))) AND (NOT tx_data(15)));
	nl1ill <= ((((((wire_w_lg_w_tx_data_range594w1587w(0) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND tx_data(13)) AND tx_data(14)) AND tx_data(15));
	nl1iOl <= (((((((tx_data(8) AND tx_data(9)) AND (NOT tx_data(10))) AND tx_data(11)) AND tx_data(12)) AND tx_data(13)) AND tx_data(14)) AND tx_data(15));
	nl1iOO <= ((((((((NOT tx_data(8)) AND wire_w_lg_w_tx_data_range593w1572w(0)) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND (NOT tx_data(13))) AND (NOT tx_data(14))) AND tx_data(15));
	nl1l0i <= (((((((((((((wire_w_lg_w_tx_ctl_range1w3w(0) AND (nl1O0O2 XOR nl1O0O1)) AND wire_w_lg_nl1O0l7w(0)) AND wire_w_lg_nl1O0i9w(0)) AND (nl1O1l4 XOR nl1O1l3)) AND wire_w_lg_nl1O1i14w(0)) AND wire_w_lg_nl1lOO16w(0)) AND (nl1lOi6 XOR nl1lOi5)) AND wire_w_lg_nl1llO21w(0)) AND wire_w_lg_nl1lll23w(0)) AND wire_w_lg_nl1lli25w(0)) AND (nl1lil8 XOR nl1lil7)) AND wire_w_lg_nl1lii30w(0)) AND (nl1l0l10 XOR nl1l0l9));
	nl1l1O <= (((((((tx_data(8) AND tx_data(9)) AND tx_data(10)) AND (NOT tx_data(11))) AND (NOT tx_data(12))) AND (NOT tx_data(13))) AND (NOT tx_data(14))) AND (NOT tx_data(15)));
	nl1lii <= (((((((tx_data(0) AND tx_data(1)) AND tx_data(2)) AND (NOT tx_data(3))) AND tx_data(4)) AND tx_data(5)) AND tx_data(6)) AND tx_data(7));
	nl1lli <= ((((((((NOT tx_data(0)) AND wire_w_lg_w_tx_data_range315w1533w(0)) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND tx_data(5)) AND tx_data(6)) AND tx_data(7));
	nl1lll <= ((((((((NOT tx_data(0)) AND wire_w_lg_w_tx_data_range315w1533w(0)) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND (NOT tx_data(5))) AND tx_data(6)) AND tx_data(7));
	nl1llO <= ((((((((NOT tx_data(0)) AND wire_w_lg_w_tx_data_range315w1533w(0)) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND (NOT tx_data(5))) AND tx_data(6)) AND (NOT tx_data(7)));
	nl1lOO <= ((((((((NOT tx_data(0)) AND wire_w_lg_w_tx_data_range315w1533w(0)) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND tx_data(5)) AND (NOT tx_data(6))) AND (NOT tx_data(7)));
	nl1O0i <= (((((((tx_data(0) AND tx_data(1)) AND (NOT tx_data(2))) AND tx_data(3)) AND tx_data(4)) AND tx_data(5)) AND tx_data(6)) AND tx_data(7));
	nl1O0l <= ((((((((NOT tx_data(0)) AND wire_w_lg_w_tx_data_range315w1533w(0)) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND (NOT tx_data(5))) AND (NOT tx_data(6))) AND tx_data(7));
	nl1O1i <= ((((((wire_w_lg_w_tx_data_range316w1534w(0) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND tx_data(5)) AND tx_data(6)) AND tx_data(7));
	nl1Oli <= (((((((tx_data(0) AND tx_data(1)) AND tx_data(2)) AND (NOT tx_data(3))) AND (NOT tx_data(4))) AND (NOT tx_data(5))) AND (NOT tx_data(6))) AND (NOT tx_data(7)));
	sm_ctl <= ( nlll1l & nlllOi & n110O & n00il);
	sm_data <= ( nllllO & nlllll & nlllli & nllliO & nlllil & nlllii & nlll0O & nlll0l & n110l & n110i & n111O & n111l & n111i & nlOOOO & nlOOOl & nlOOOi & n00ii & n000O & n000l & n000i & n001O & n001l & n001i & n01OO & niiiO & niiil & niiii & nii0O & nii0l & nii0i & nii1O & nii1l);
	tx_local_fault <= nll0l;
	tx_local_fault_det <= niili;
	wire_w_tx_ctl_range1w(0) <= tx_ctl(0);
	wire_w_tx_ctl_range35w(0) <= tx_ctl(1);
	wire_w_tx_ctl_range63w(0) <= tx_ctl(2);
	wire_w_tx_ctl_range94w(0) <= tx_ctl(3);
	wire_w_tx_data_range316w(0) <= tx_data(0);
	wire_w_tx_data_range872w(0) <= tx_data(16);
	wire_w_tx_data_range871w(0) <= tx_data(17);
	wire_w_tx_data_range315w(0) <= tx_data(1);
	wire_w_tx_data_range1156w(0) <= tx_data(24);
	wire_w_tx_data_range1155w(0) <= tx_data(25);
	wire_w_tx_data_range594w(0) <= tx_data(8);
	wire_w_tx_data_range593w(0) <= tx_data(9);
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOi0O49 <= niOi0O50;
		END IF;
		if (now = 0 ns) then
			niOi0O49 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOi0O50 <= niOi0O49;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOiii47 <= niOiii48;
		END IF;
		if (now = 0 ns) then
			niOiii47 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOiii48 <= niOiii47;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOl0l45 <= niOl0l46;
		END IF;
		if (now = 0 ns) then
			niOl0l45 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOl0l46 <= niOl0l45;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOl0O43 <= niOl0O44;
		END IF;
		if (now = 0 ns) then
			niOl0O43 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOl0O44 <= niOl0O43;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOlil41 <= niOlil42;
		END IF;
		if (now = 0 ns) then
			niOlil41 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOlil42 <= niOlil41;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOlOl39 <= niOlOl40;
		END IF;
		if (now = 0 ns) then
			niOlOl39 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOlOl40 <= niOlOl39;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOO0i37 <= niOO0i38;
		END IF;
		if (now = 0 ns) then
			niOO0i37 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOO0i38 <= niOO0i37;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOiO35 <= niOOiO36;
		END IF;
		if (now = 0 ns) then
			niOOiO35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOiO36 <= niOOiO35;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOOi33 <= niOOOi34;
		END IF;
		if (now = 0 ns) then
			niOOOi33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOOi34 <= niOOOi33;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl100O21 <= nl100O22;
		END IF;
		if (now = 0 ns) then
			nl100O21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl100O22 <= nl100O21;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl101O23 <= nl101O24;
		END IF;
		if (now = 0 ns) then
			nl101O23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl101O24 <= nl101O23;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl10lO19 <= nl10lO20;
		END IF;
		if (now = 0 ns) then
			nl10lO19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl10lO20 <= nl10lO19;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl10OO17 <= nl10OO18;
		END IF;
		if (now = 0 ns) then
			nl10OO17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl10OO18 <= nl10OO17;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl110l29 <= nl110l30;
		END IF;
		if (now = 0 ns) then
			nl110l29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl110l30 <= nl110l29;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl111l31 <= nl111l32;
		END IF;
		if (now = 0 ns) then
			nl111l31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl111l32 <= nl111l31;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl11il27 <= nl11il28;
		END IF;
		if (now = 0 ns) then
			nl11il27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl11il28 <= nl11il27;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl11lO25 <= nl11lO26;
		END IF;
		if (now = 0 ns) then
			nl11lO25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl11lO26 <= nl11lO25;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1i0O15 <= nl1i0O16;
		END IF;
		if (now = 0 ns) then
			nl1i0O15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1i0O16 <= nl1i0O15;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1ilO13 <= nl1ilO14;
		END IF;
		if (now = 0 ns) then
			nl1ilO13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1ilO14 <= nl1ilO13;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1l0l10 <= nl1l0l9;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1l0l9 <= nl1l0l10;
		END IF;
		if (now = 0 ns) then
			nl1l0l9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1l1i11 <= nl1l1i12;
		END IF;
		if (now = 0 ns) then
			nl1l1i11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1l1i12 <= nl1l1i11;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lil7 <= nl1lil8;
		END IF;
		if (now = 0 ns) then
			nl1lil7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lil8 <= nl1lil7;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lOi5 <= nl1lOi6;
		END IF;
		if (now = 0 ns) then
			nl1lOi5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lOi6 <= nl1lOi5;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1O0O1 <= nl1O0O2;
		END IF;
		if (now = 0 ns) then
			nl1O0O1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1O0O2 <= nl1O0O1;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1O1l3 <= nl1O1l4;
		END IF;
		if (now = 0 ns) then
			nl1O1l3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1O1l4 <= nl1O1l3;
		END IF;
	END PROCESS;
	PROCESS (tx_clk, wire_n0Oi_PRN, wire_n0Oi_CLRN)
	BEGIN
		IF (wire_n0Oi_PRN = '0') THEN
				n000i <= '1';
				n000l <= '1';
				n001l <= '1';
				n001O <= '1';
				n00ii <= '1';
				n00il <= '1';
				n0lO <= '1';
				n0Ol <= '1';
				n110l <= '1';
				n110O <= '1';
				n111i <= '1';
				n111l <= '1';
				n111O <= '1';
				nii0i <= '1';
				nii0l <= '1';
				nii0O <= '1';
				niiii <= '1';
				niiiO <= '1';
				nliO1i <= '1';
				nliO1l <= '1';
				nll0O <= '1';
				nll10l <= '1';
				nll10O <= '1';
				nll1ii <= '1';
				nll1il <= '1';
				nll1iO <= '1';
				nll1li <= '1';
				nlll1l <= '1';
				nlllii <= '1';
				nlllil <= '1';
				nllliO <= '1';
				nlllli <= '1';
				nllllO <= '1';
				nlllOi <= '1';
				nlOOOO <= '1';
		ELSIF (wire_n0Oi_CLRN = '0') THEN
				n000i <= '0';
				n000l <= '0';
				n001l <= '0';
				n001O <= '0';
				n00ii <= '0';
				n00il <= '0';
				n0lO <= '0';
				n0Ol <= '0';
				n110l <= '0';
				n110O <= '0';
				n111i <= '0';
				n111l <= '0';
				n111O <= '0';
				nii0i <= '0';
				nii0l <= '0';
				nii0O <= '0';
				niiii <= '0';
				niiiO <= '0';
				nliO1i <= '0';
				nliO1l <= '0';
				nll0O <= '0';
				nll10l <= '0';
				nll10O <= '0';
				nll1ii <= '0';
				nll1il <= '0';
				nll1iO <= '0';
				nll1li <= '0';
				nlll1l <= '0';
				nlllii <= '0';
				nlllil <= '0';
				nllliO <= '0';
				nlllli <= '0';
				nllllO <= '0';
				nlllOi <= '0';
				nlOOOO <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
				n000i <= wire_n00Ol_dataout;
				n000l <= wire_n00OO_dataout;
				n001l <= wire_n00lO_dataout;
				n001O <= wire_n00Oi_dataout;
				n00ii <= wire_n0i1l_dataout;
				n00il <= wire_niill_dataout;
				n0lO <= wire_nlOil_o;
				n0Ol <= wire_nlOiO_o;
				n110l <= wire_n11OO_dataout;
				n110O <= wire_n00iO_dataout;
				n111i <= wire_n11ll_dataout;
				n111l <= wire_n11lO_dataout;
				n111O <= wire_n11Oi_dataout;
				nii0i <= wire_niiOl_dataout;
				nii0l <= wire_niiOO_dataout;
				nii0O <= wire_nil1i_dataout;
				niiii <= wire_nil1l_dataout;
				niiiO <= wire_nil0i_dataout;
				nliO1i <= wire_nliOii_dataout;
				nliO1l <= (nll1li XOR nll1iO);
				nll0O <= wire_nllli_dataout;
				nll10l <= nliO1l;
				nll10O <= nll10l;
				nll1ii <= nll10O;
				nll1il <= nll1ii;
				nll1iO <= nll1il;
				nll1li <= nll1iO;
				nlll1l <= wire_nlllOl_dataout;
				nlllii <= wire_nllO1l_dataout;
				nlllil <= wire_nllO1O_dataout;
				nllliO <= wire_nllO0i_dataout;
				nlllli <= wire_nllO0l_dataout;
				nllllO <= wire_nllOii_dataout;
				nlllOi <= wire_n11ii_dataout;
				nlOOOO <= wire_n11li_dataout;
		END IF;
	END PROCESS;
	wire_n0Oi_CLRN <= (niOl0O44 XOR niOl0O43);
	wire_n0Oi_PRN <= ((niOl0l46 XOR niOl0l45) AND wire_w_lg_soft_reset156w(0));
	wire_n0Oi_w_lg_w_lg_w_lg_nll0O287w288w289w(0) <= wire_n0Oi_w_lg_w_lg_nll0O287w288w(0) AND niOiOl;
	wire_n0Oi_w_lg_n0lO296w(0) <= NOT n0lO;
	wire_n0Oi_w_lg_n0Ol1433w(0) <= NOT n0Ol;
	wire_n0Oi_w_lg_nliO1l166w(0) <= NOT nliO1l;
	wire_n0Oi_w_lg_nll0O287w(0) <= NOT nll0O;
	wire_n0Oi_w_lg_w_lg_nll0O287w288w(0) <= wire_n0Oi_w_lg_nll0O287w(0) OR niOl1l;
	PROCESS (tx_clk, wire_ni1i_CLRN)
	BEGIN
		IF (wire_ni1i_CLRN = '0') THEN
				n000O <= '0';
				n001i <= '0';
				n01OO <= '0';
				n0ll <= '0';
				n0OO <= '0';
				n110i <= '0';
				ni1l <= '0';
				nii1l <= '0';
				nii1O <= '0';
				niiil <= '0';
				niili <= '0';
				nliiO <= '0';
				nlili <= '0';
				nlilOi <= '0';
				nlilOl <= '0';
				nlilOO <= '0';
				nliOOi <= '0';
				nll0i <= '0';
				nll0l <= '0';
				nlliO <= '0';
				nlll0l <= '0';
				nlll0O <= '0';
				nlll1i <= '0';
				nlllll <= '0';
				nlOOOi <= '0';
				nlOOOl <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
				n000O <= wire_n0i1i_dataout;
				n001i <= wire_n00ll_dataout;
				n01OO <= wire_n00li_dataout;
				n0ll <= indv;
				n0OO <= wire_nlOli_o;
				n110i <= wire_n11Ol_dataout;
				ni1l <= wire_nlOll_dataout;
				nii1l <= wire_niilO_dataout;
				nii1O <= wire_niiOi_dataout;
				niiil <= wire_nil1O_dataout;
				niili <= wire_nlill_dataout;
				nliiO <= wire_nlilO_dataout;
				nlili <= nll0i;
				nlilOi <= wire_nliO0i_dataout;
				nlilOl <= wire_nliO0l_dataout;
				nlilOO <= wire_nliO0O_dataout;
				nliOOi <= wire_nliO1O_dataout;
				nll0i <= tx_local_fault_clr;
				nll0l <= wire_nllii_dataout;
				nlliO <= n0ll;
				nlll0l <= wire_nlllOO_dataout;
				nlll0O <= wire_nllO1i_dataout;
				nlll1i <= wire_nlll1O_dataout;
				nlllll <= wire_nllO0O_dataout;
				nlOOOi <= wire_n11il_dataout;
				nlOOOl <= wire_n11iO_dataout;
		END IF;
	END PROCESS;
	wire_ni1i_CLRN <= ((niOlil42 XOR niOlil41) AND wire_w_lg_soft_reset156w(0));
	wire_ni1i_w_lg_w_lg_w_lg_w_lg_ni1l292w298w1434w1435w(0) <= wire_ni1i_w_lg_w_lg_w_lg_ni1l292w298w1434w(0) AND n0lO;
	wire_ni1i_w_lg_w_lg_w_lg_w_lg_ni1l292w298w299w300w(0) <= wire_ni1i_w_lg_w_lg_w_lg_ni1l292w298w299w(0) AND n0lO;
	wire_ni1i_w_lg_w_lg_w_lg_ni1l292w294w295w(0) <= wire_ni1i_w_lg_w_lg_ni1l292w294w(0) AND n0Ol;
	wire_ni1i_w_lg_w_lg_w_lg_ni1l292w298w1434w(0) <= wire_ni1i_w_lg_w_lg_ni1l292w298w(0) AND wire_n0Oi_w_lg_n0Ol1433w(0);
	wire_ni1i_w_lg_w_lg_w_lg_ni1l292w298w299w(0) <= wire_ni1i_w_lg_w_lg_ni1l292w298w(0) AND n0Ol;
	wire_ni1i_w_lg_w_lg_ni1l292w294w(0) <= wire_ni1i_w_lg_ni1l292w(0) AND wire_ni1i_w_lg_n0OO293w(0);
	wire_ni1i_w_lg_w_lg_ni1l292w298w(0) <= wire_ni1i_w_lg_ni1l292w(0) AND n0OO;
	wire_ni1i_w_lg_n0OO293w(0) <= NOT n0OO;
	wire_ni1i_w_lg_ni1l292w(0) <= NOT ni1l;
	wire_ni1i_w_lg_niili305w(0) <= NOT niili;
	wire_ni1i_w_lg_nliiO304w(0) <= NOT nliiO;
	wire_ni1i_w_lg_nlll1i164w(0) <= NOT nlll1i;
	PROCESS (tx_clk, wire_nlliii_PRN)
	BEGIN
		IF (wire_nlliii_PRN = '0') THEN
				nll00i <= '1';
				nll01i <= '1';
				nll1Ol <= '1';
				nll1OO <= '1';
				nlliil <= '1';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (niOliO = '1') THEN
				nll00i <= tx_data(7);
				nll01i <= tx_data(4);
				nll1Ol <= tx_data(2);
				nll1OO <= tx_data(3);
				nlliil <= tx_data(25);
			END IF;
		END IF;
	END PROCESS;
	wire_nlliii_PRN <= ((niOi0O50 XOR niOi0O49) AND wire_w_lg_soft_reset156w(0));
	wire_nlliii_w_lg_nlliil1788w(0) <= NOT nlliil;
	PROCESS (tx_clk, wire_nlliOl_CLRN)
	BEGIN
		IF (wire_nlliOl_CLRN = '0') THEN
				nll00l <= '0';
				nll00O <= '0';
				nll01l <= '0';
				nll01O <= '0';
				nll0ii <= '0';
				nll0il <= '0';
				nll0iO <= '0';
				nll0li <= '0';
				nll0ll <= '0';
				nll0lO <= '0';
				nll0Oi <= '0';
				nll0Ol <= '0';
				nll0OO <= '0';
				nll1ll <= '0';
				nll1Oi <= '0';
				nlli0i <= '0';
				nlli0l <= '0';
				nlli0O <= '0';
				nlli1i <= '0';
				nlli1l <= '0';
				nlli1O <= '0';
				nlliiO <= '0';
				nllili <= '0';
				nllill <= '0';
				nllilO <= '0';
				nlliOi <= '0';
				nlliOO <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (niOliO = '1') THEN
				nll00l <= tx_data(8);
				nll00O <= tx_data(9);
				nll01l <= tx_data(5);
				nll01O <= tx_data(6);
				nll0ii <= tx_data(10);
				nll0il <= tx_data(11);
				nll0iO <= tx_data(12);
				nll0li <= tx_data(13);
				nll0ll <= tx_data(14);
				nll0lO <= tx_data(15);
				nll0Oi <= tx_data(16);
				nll0Ol <= tx_data(17);
				nll0OO <= tx_data(18);
				nll1ll <= tx_data(0);
				nll1Oi <= tx_data(1);
				nlli0i <= tx_data(22);
				nlli0l <= tx_data(23);
				nlli0O <= tx_data(24);
				nlli1i <= tx_data(19);
				nlli1l <= tx_data(20);
				nlli1O <= tx_data(21);
				nlliiO <= tx_data(26);
				nllili <= tx_data(27);
				nllill <= tx_data(28);
				nllilO <= tx_data(29);
				nlliOi <= tx_data(30);
				nlliOO <= tx_data(31);
			END IF;
		END IF;
	END PROCESS;
	wire_nlliOl_CLRN <= ((niOiii48 XOR niOiii47) AND wire_w_lg_soft_reset156w(0));
	wire_nlliOl_w_lg_w_lg_w_lg_w1785w1787w1789w1790w(0) <= wire_nlliOl_w_lg_w_lg_w1785w1787w1789w(0) AND nlli0O;
	wire_nlliOl_w_lg_w_lg_w1785w1787w1789w(0) <= wire_nlliOl_w_lg_w1785w1787w(0) AND wire_nlliii_w_lg_nlliil1788w(0);
	wire_nlliOl_w_lg_w1785w1787w(0) <= wire_nlliOl_w1785w(0) AND wire_nlliOl_w_lg_nlliiO1786w(0);
	wire_nlliOl_w1785w(0) <= wire_nlliOl_w_lg_w_lg_w_lg_w_lg_nlliOO1777w1779w1781w1783w(0) AND wire_nlliOl_w_lg_nllili1784w(0);
	wire_nlliOl_w_lg_w_lg_w_lg_w_lg_nlliOO1777w1779w1781w1783w(0) <= wire_nlliOl_w_lg_w_lg_w_lg_nlliOO1777w1779w1781w(0) AND wire_nlliOl_w_lg_nllill1782w(0);
	wire_nlliOl_w_lg_w_lg_w_lg_nlliOO1777w1779w1781w(0) <= wire_nlliOl_w_lg_w_lg_nlliOO1777w1779w(0) AND wire_nlliOl_w_lg_nllilO1780w(0);
	wire_nlliOl_w_lg_w_lg_nlliOO1777w1779w(0) <= wire_nlliOl_w_lg_nlliOO1777w(0) AND wire_nlliOl_w_lg_nlliOi1778w(0);
	wire_nlliOl_w_lg_nll00l1821w(0) <= NOT nll00l;
	wire_nlliOl_w_lg_nll00O1819w(0) <= NOT nll00O;
	wire_nlliOl_w_lg_nll0ii1817w(0) <= NOT nll0ii;
	wire_nlliOl_w_lg_nll0il1815w(0) <= NOT nll0il;
	wire_nlliOl_w_lg_nll0iO1813w(0) <= NOT nll0iO;
	wire_nlliOl_w_lg_nll0li1811w(0) <= NOT nll0li;
	wire_nlliOl_w_lg_nll0ll1809w(0) <= NOT nll0ll;
	wire_nlliOl_w_lg_nll0lO1807w(0) <= NOT nll0lO;
	wire_nlliOl_w_lg_nll0Oi1805w(0) <= NOT nll0Oi;
	wire_nlliOl_w_lg_nll0Ol1803w(0) <= NOT nll0Ol;
	wire_nlliOl_w_lg_nll0OO1801w(0) <= NOT nll0OO;
	wire_nlliOl_w_lg_nlli0i1793w(0) <= NOT nlli0i;
	wire_nlliOl_w_lg_nlli0l1791w(0) <= NOT nlli0l;
	wire_nlliOl_w_lg_nlli1i1799w(0) <= NOT nlli1i;
	wire_nlliOl_w_lg_nlli1l1797w(0) <= NOT nlli1l;
	wire_nlliOl_w_lg_nlli1O1795w(0) <= NOT nlli1O;
	wire_nlliOl_w_lg_nlliiO1786w(0) <= NOT nlliiO;
	wire_nlliOl_w_lg_nllili1784w(0) <= NOT nllili;
	wire_nlliOl_w_lg_nllill1782w(0) <= NOT nllill;
	wire_nlliOl_w_lg_nllilO1780w(0) <= NOT nllilO;
	wire_nlliOl_w_lg_nlliOi1778w(0) <= NOT nlliOi;
	wire_nlliOl_w_lg_nlliOO1777w(0) <= NOT nlliOO;
	wire_n00i_dataout <= wire_ni1i_w_lg_nlll1i164w(0) OR niOl0i;
	wire_n00iO_dataout <= wire_n0i1O_o OR nl1i1O;
	wire_n00l_dataout <= wire_n0ii_dataout OR nlliO;
	wire_n00li_dataout <= wire_n0i0i_o AND NOT(nl1i1O);
	wire_n00ll_dataout <= wire_n0i0l_o OR nl1i1O;
	wire_n00lO_dataout <= wire_n0i0O_o OR nl1i1O;
	wire_n00O_dataout <= wire_w_lg_niOl0i161w(0) OR nlliO;
	wire_n00Oi_dataout <= wire_n0iii_o OR nl1i1O;
	wire_n00Ol_dataout <= wire_n0iil_o OR nl1i1O;
	wire_n00OO_dataout <= wire_n0iiO_o OR nl1i1O;
	wire_n010i_dataout <= wire_n1ill_dataout WHEN niOl0i = '1'  ELSE niOl1O;
	wire_n010l_dataout <= wire_n1ilO_dataout WHEN niOl0i = '1'  ELSE wire_w_lg_niOl1O163w(0);
	wire_n010O_dataout <= wire_n10li_dataout OR NOT(rd_enable_sync);
	wire_n011i_dataout <= nlli1O AND nlll1i;
	wire_n011l_dataout <= nlli0l AND nlll1i;
	wire_n011O_dataout <= wire_n1ili_dataout OR NOT(niOl0i);
	wire_n01i_dataout <= wire_nlOlii_dataout AND NOT(niOl0i);
	wire_n01ii_dataout <= wire_n10ll_dataout AND rd_enable_sync;
	wire_n01il_dataout <= wire_n10lO_dataout AND rd_enable_sync;
	wire_n01iO_dataout <= wire_n10Oi_dataout OR NOT(rd_enable_sync);
	wire_n01l_dataout <= nliO1l OR wire_w_lg_niOl1l165w(0);
	wire_n01li_dataout <= wire_n10Ol_dataout OR NOT(rd_enable_sync);
	wire_n01ll_dataout <= wire_n10OO_dataout OR NOT(rd_enable_sync);
	wire_n01lO_dataout <= wire_n1OlO_dataout OR NOT(rd_enable_sync);
	wire_n01O_dataout <= wire_n00i_dataout OR nlliO;
	wire_n01Oi_dataout <= wire_n1i1l_dataout AND rd_enable_sync;
	wire_n01Ol_dataout <= wire_n1OOi_dataout OR NOT(rd_enable_sync);
	wire_n0i1i_dataout <= wire_n0ili_o OR nl1i1O;
	wire_n0i1l_dataout <= wire_n0ill_o OR nl1i1O;
	wire_n0ii_dataout <= wire_w_lg_niOl1O163w(0) OR niOl0i;
	wire_n0il_dataout <= wire_w_lg_rd_enable_sync162w(0) OR nlliO;
	wire_n0ilO_dataout <= wire_n0l0O_dataout OR NOT(niOl0i);
	wire_n0iO_dataout <= wire_n0li_dataout AND NOT(nlliO);
	wire_n0iOi_dataout <= wire_n0lii_dataout AND niOl0i;
	wire_n0iOl_dataout <= wire_n0lil_dataout AND niOl0i;
	wire_n0iOO_dataout <= wire_n0liO_dataout OR NOT(niOl0i);
	wire_n0l0i_dataout <= wire_n0lOi_dataout AND niOl0i;
	wire_n0l0l_dataout <= wire_n0lOl_dataout WHEN niOl0i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_n0l0O_dataout <= wire_n0lOO_dataout OR niOO1l;
	wire_n0l1i_dataout <= wire_n0lli_dataout OR NOT(niOl0i);
	wire_n0l1l_dataout <= wire_n0lll_dataout OR NOT(niOl0i);
	wire_n0l1O_dataout <= wire_n0llO_dataout WHEN niOl0i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_n0li_dataout <= wire_w_lg_niOl0i161w(0) AND rd_enable_sync;
	wire_n0lii_dataout <= wire_n0O1i_dataout AND NOT(niOO1l);
	wire_n0lil_dataout <= wire_n0O1l_dataout AND NOT(niOO1l);
	wire_n0liO_dataout <= wire_n0O1O_dataout OR niOO1l;
	wire_n0lli_dataout <= wire_n0O0i_dataout OR niOO1l;
	wire_n0lll_dataout <= wire_n0O0l_dataout OR niOO1l;
	wire_n0llO_dataout <= wire_n0O0O_dataout OR niOO1l;
	wire_n0lOi_dataout <= wire_n0Oii_dataout AND NOT(niOO1l);
	wire_n0lOl_dataout <= wire_n0Oil_dataout OR niOO1l;
	wire_n0lOO_dataout <= tx_ctl(1) OR niOlOi;
	wire_n0O0i_dataout <= tx_data(11) OR niOlOi;
	wire_n0O0l_dataout <= tx_data(12) OR niOlOi;
	wire_n0O0O_dataout <= tx_data(13) OR niOlOi;
	wire_n0O1i_dataout <= tx_data(8) OR niOlOi;
	wire_n0O1l_dataout <= tx_data(9) AND NOT(niOlOi);
	wire_n0O1O_dataout <= tx_data(10) OR niOlOi;
	wire_n0Oii_dataout <= tx_data(14) OR niOlOi;
	wire_n0Oil_dataout <= tx_data(15) OR niOlOi;
	wire_n0OiO_dataout <= wire_n0l0O_dataout WHEN niOl0i = '1'  ELSE wire_ni1i_w_lg_nlll1i164w(0);
	wire_n0Oli_dataout <= wire_n0lii_dataout WHEN niOl0i = '1'  ELSE wire_ni11O_dataout;
	wire_n0Oll_dataout <= wire_n0lil_dataout WHEN niOl0i = '1'  ELSE wire_ni10i_dataout;
	wire_n0OlO_dataout <= wire_n0liO_dataout WHEN niOl0i = '1'  ELSE wire_ni10l_dataout;
	wire_n0OOi_dataout <= wire_n0lli_dataout WHEN niOl0i = '1'  ELSE wire_ni10O_dataout;
	wire_n0OOl_dataout <= wire_n0lll_dataout WHEN niOl0i = '1'  ELSE wire_ni1ii_dataout;
	wire_n0OOO_dataout <= wire_n0llO_dataout WHEN niOl0i = '1'  ELSE wire_ni1il_dataout;
	wire_n10i_dataout <= wire_n1il_dataout OR nlliO;
	wire_n10l_dataout <= wire_n1iO_dataout AND NOT(nlliO);
	wire_n10li_dataout <= wire_n1i0i_dataout OR NOT(niOl0i);
	wire_n10ll_dataout <= wire_n1i0l_dataout AND niOl0i;
	wire_n10lO_dataout <= wire_n1i0O_dataout AND niOl0i;
	wire_n10O_dataout <= wire_n1li_dataout AND NOT(nlliO);
	wire_n10Oi_dataout <= wire_n1iii_dataout OR NOT(niOl0i);
	wire_n10Ol_dataout <= wire_n1iil_dataout OR NOT(niOl0i);
	wire_n10OO_dataout <= wire_n1iiO_dataout OR NOT(niOl0i);
	wire_n11i_dataout <= nliO1l OR niOl0i;
	wire_n11ii_dataout <= wire_n101i_o OR nl11OO;
	wire_n11il_dataout <= wire_n101l_o AND NOT(nl11OO);
	wire_n11iO_dataout <= wire_n101O_o OR nl11OO;
	wire_n11l_dataout <= wire_n0Oi_w_lg_nliO1l166w(0) AND NOT(niOl0i);
	wire_n11li_dataout <= wire_n100i_o OR nl11OO;
	wire_n11ll_dataout <= wire_n100l_o OR nl11OO;
	wire_n11lO_dataout <= wire_n100O_o OR nl11OO;
	wire_n11O_dataout <= wire_n1ii_dataout OR nlliO;
	wire_n11Oi_dataout <= wire_n10ii_o OR nl11OO;
	wire_n11Ol_dataout <= wire_n10il_o OR nl11OO;
	wire_n11OO_dataout <= wire_n10iO_o OR nl11OO;
	wire_n1i0i_dataout <= wire_n1iOi_dataout OR niOiiO;
	wire_n1i0l_dataout <= wire_n1iOl_dataout AND NOT(niOiiO);
	wire_n1i0O_dataout <= wire_n1iOO_dataout AND NOT(niOiiO);
	wire_n1i1i_dataout <= wire_n1ili_dataout WHEN niOl0i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_n1i1l_dataout <= wire_n1ill_dataout AND niOl0i;
	wire_n1i1O_dataout <= wire_n1ilO_dataout WHEN niOl0i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_n1ii_dataout <= wire_n1ll_dataout OR niOl0i;
	wire_n1iii_dataout <= wire_n1l1i_dataout OR niOiiO;
	wire_n1iil_dataout <= wire_n1l1l_dataout OR niOiiO;
	wire_n1iiO_dataout <= wire_n1l1O_dataout OR niOiiO;
	wire_n1il_dataout <= wire_n1lO_dataout AND NOT(niOl0i);
	wire_n1ili_dataout <= wire_n1l0i_dataout OR niOiiO;
	wire_n1ill_dataout <= wire_n1l0l_dataout AND NOT(niOiiO);
	wire_n1ilO_dataout <= wire_n1l0O_dataout OR niOiiO;
	wire_n1iO_dataout <= wire_ni1i_w_lg_nlll1i164w(0) AND NOT(niOl0i);
	wire_n1iOi_dataout <= tx_ctl(2) OR niOlll;
	wire_n1iOl_dataout <= tx_data(16) OR niOlll;
	wire_n1iOO_dataout <= tx_data(17) AND NOT(niOlll);
	wire_n1l0i_dataout <= tx_data(21) OR niOlll;
	wire_n1l0l_dataout <= tx_data(22) OR niOlll;
	wire_n1l0O_dataout <= tx_data(23) OR niOlll;
	wire_n1l1i_dataout <= tx_data(18) OR niOlll;
	wire_n1l1l_dataout <= tx_data(19) OR niOlll;
	wire_n1l1O_dataout <= tx_data(20) OR niOlll;
	wire_n1li_dataout <= nlll1i AND NOT(niOl0i);
	wire_n1lii_dataout <= wire_n1i0i_dataout WHEN niOl0i = '1'  ELSE wire_ni1i_w_lg_nlll1i164w(0);
	wire_n1lil_dataout <= wire_n1i0l_dataout WHEN niOl0i = '1'  ELSE wire_n1O1i_dataout;
	wire_n1liO_dataout <= wire_n1i0O_dataout WHEN niOl0i = '1'  ELSE wire_n1O1l_dataout;
	wire_n1ll_dataout <= nliO1l AND NOT(nlll1i);
	wire_n1lli_dataout <= wire_n1iii_dataout WHEN niOl0i = '1'  ELSE wire_n1O1O_dataout;
	wire_n1lll_dataout <= wire_n1iil_dataout WHEN niOl0i = '1'  ELSE wire_n1O0i_dataout;
	wire_n1llO_dataout <= wire_n1iiO_dataout WHEN niOl0i = '1'  ELSE wire_n1O0l_dataout;
	wire_n1lO_dataout <= wire_n0Oi_w_lg_nliO1l166w(0) AND NOT(nlll1i);
	wire_n1lOi_dataout <= wire_n1ili_dataout WHEN niOl0i = '1'  ELSE wire_n1O0O_dataout;
	wire_n1lOl_dataout <= wire_n1ill_dataout WHEN niOl0i = '1'  ELSE wire_n1Oii_dataout;
	wire_n1lOO_dataout <= wire_n1ilO_dataout WHEN niOl0i = '1'  ELSE wire_n1Oil_dataout;
	wire_n1O0i_dataout <= nlli1i OR NOT(nlll1i);
	wire_n1O0l_dataout <= nlli1l OR NOT(nlll1i);
	wire_n1O0O_dataout <= nlli1O WHEN nlll1i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_n1O1i_dataout <= nll0Oi AND nlll1i;
	wire_n1O1l_dataout <= nll0Ol AND nlll1i;
	wire_n1O1O_dataout <= nll0OO OR NOT(nlll1i);
	wire_n1Oi_dataout <= wire_n1OO_dataout OR nlliO;
	wire_n1Oii_dataout <= nlli0i AND nlll1i;
	wire_n1Oil_dataout <= nlli0l WHEN nlll1i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_n1OiO_dataout <= wire_n1ili_dataout WHEN niOl0i = '1'  ELSE wire_nlOlii_dataout;
	wire_n1Ol_dataout <= wire_n01i_dataout OR nlliO;
	wire_n1Oli_dataout <= wire_n1ill_dataout WHEN niOl0i = '1'  ELSE wire_w_lg_niOl1l165w(0);
	wire_n1Oll_dataout <= wire_n1ilO_dataout WHEN niOl0i = '1'  ELSE wire_nlOlil_dataout;
	wire_n1OlO_dataout <= wire_n1ili_dataout AND niOl0i;
	wire_n1OO_dataout <= wire_n01l_dataout OR niOl0i;
	wire_n1OOi_dataout <= wire_n1ilO_dataout AND niOl0i;
	wire_n1OOl_dataout <= wire_n1ili_dataout WHEN niOl0i = '1'  ELSE wire_n011i_dataout;
	wire_n1OOO_dataout <= wire_n1ilO_dataout WHEN niOl0i = '1'  ELSE wire_n011l_dataout;
	wire_ni00i_dataout <= nll0lO AND nlll1i;
	wire_ni00l_dataout <= wire_n0llO_dataout OR NOT(niOl0i);
	wire_ni00O_dataout <= wire_n0lOi_dataout WHEN niOl0i = '1'  ELSE niOl1O;
	wire_ni01i_dataout <= wire_n0llO_dataout WHEN niOl0i = '1'  ELSE wire_ni01O_dataout;
	wire_ni01l_dataout <= wire_n0lOl_dataout WHEN niOl0i = '1'  ELSE wire_ni00i_dataout;
	wire_ni01O_dataout <= nll0li AND nlll1i;
	wire_ni0ii_dataout <= wire_n0lOl_dataout WHEN niOl0i = '1'  ELSE wire_w_lg_niOl1O163w(0);
	wire_ni0il_dataout <= wire_n0ilO_dataout OR NOT(rd_enable_sync);
	wire_ni0iO_dataout <= wire_n0iOi_dataout AND rd_enable_sync;
	wire_ni0li_dataout <= wire_n0iOl_dataout AND rd_enable_sync;
	wire_ni0ll_dataout <= wire_n0iOO_dataout OR NOT(rd_enable_sync);
	wire_ni0lO_dataout <= wire_n0l1i_dataout OR NOT(rd_enable_sync);
	wire_ni0Oi_dataout <= wire_n0l1l_dataout OR NOT(rd_enable_sync);
	wire_ni0Ol_dataout <= wire_ni1Ol_dataout OR NOT(rd_enable_sync);
	wire_ni0OO_dataout <= wire_n0l0i_dataout AND rd_enable_sync;
	wire_ni10i_dataout <= nll00O AND nlll1i;
	wire_ni10l_dataout <= nll0ii OR NOT(nlll1i);
	wire_ni10O_dataout <= nll0il OR NOT(nlll1i);
	wire_ni11i_dataout <= wire_n0lOi_dataout WHEN niOl0i = '1'  ELSE wire_ni1iO_dataout;
	wire_ni11l_dataout <= wire_n0lOl_dataout WHEN niOl0i = '1'  ELSE wire_ni1li_dataout;
	wire_ni11O_dataout <= nll00l AND nlll1i;
	wire_ni1ii_dataout <= nll0iO OR NOT(nlll1i);
	wire_ni1il_dataout <= nll0li WHEN nlll1i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_ni1iO_dataout <= nll0ll AND nlll1i;
	wire_ni1li_dataout <= nll0lO WHEN nlll1i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_ni1ll_dataout <= wire_n0llO_dataout WHEN niOl0i = '1'  ELSE wire_nlOlii_dataout;
	wire_ni1lO_dataout <= wire_n0lOi_dataout WHEN niOl0i = '1'  ELSE wire_w_lg_niOl1l165w(0);
	wire_ni1Oi_dataout <= wire_n0lOl_dataout WHEN niOl0i = '1'  ELSE wire_nlOlil_dataout;
	wire_ni1Ol_dataout <= wire_n0llO_dataout AND niOl0i;
	wire_ni1OO_dataout <= wire_n0lOl_dataout AND niOl0i;
	wire_nii1i_dataout <= wire_ni1OO_dataout OR NOT(rd_enable_sync);
	wire_niill_dataout <= wire_nil0l_o OR nl1l0i;
	wire_niilO_dataout <= wire_nil0O_o AND NOT(nl1l0i);
	wire_niiOi_dataout <= wire_nilii_o OR nl1l0i;
	wire_niiOl_dataout <= wire_nilil_o OR nl1l0i;
	wire_niiOO_dataout <= wire_niliO_o OR nl1l0i;
	wire_nil0i_dataout <= wire_nilOi_o OR nl1l0i;
	wire_nil1i_dataout <= wire_nilli_o OR nl1l0i;
	wire_nil1l_dataout <= wire_nilll_o OR nl1l0i;
	wire_nil1O_dataout <= wire_nillO_o OR nl1l0i;
	wire_nilOl_dataout <= wire_niOil_dataout OR NOT(niOl0i);
	wire_nilOO_dataout <= wire_niOiO_dataout AND niOl0i;
	wire_niO0i_dataout <= wire_niOOi_dataout OR NOT(niOl0i);
	wire_niO0l_dataout <= wire_niOOl_dataout WHEN niOl0i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_niO0O_dataout <= wire_niOOO_dataout AND niOl0i;
	wire_niO1i_dataout <= wire_niOli_dataout AND niOl0i;
	wire_niO1l_dataout <= wire_niOll_dataout OR NOT(niOl0i);
	wire_niO1O_dataout <= wire_niOlO_dataout OR NOT(niOl0i);
	wire_niOii_dataout <= wire_nl11i_dataout WHEN niOl0i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_niOil_dataout <= tx_ctl(0) OR niOO1l;
	wire_niOiO_dataout <= tx_data(0) OR niOO1l;
	wire_niOli_dataout <= tx_data(1) AND NOT(niOO1l);
	wire_niOll_dataout <= tx_data(2) OR niOO1l;
	wire_niOlO_dataout <= tx_data(3) OR niOO1l;
	wire_niOOi_dataout <= tx_data(4) OR niOO1l;
	wire_niOOl_dataout <= tx_data(5) OR niOO1l;
	wire_niOOO_dataout <= tx_data(6) OR niOO1l;
	wire_nl00i_dataout <= wire_niOOO_dataout WHEN niOl0i = '1'  ELSE wire_w_lg_niOl1l165w(0);
	wire_nl00l_dataout <= wire_nl11i_dataout WHEN niOl0i = '1'  ELSE wire_nlOlil_dataout;
	wire_nl00O_dataout <= wire_niOOl_dataout AND niOl0i;
	wire_nl01i_dataout <= nll01O AND nlll1i;
	wire_nl01l_dataout <= nll00i WHEN nlll1i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_nl01O_dataout <= wire_niOOl_dataout WHEN niOl0i = '1'  ELSE wire_nlOlii_dataout;
	wire_nl0ii_dataout <= wire_nl11i_dataout AND niOl0i;
	wire_nl0il_dataout <= wire_niOOl_dataout WHEN niOl0i = '1'  ELSE wire_nl0li_dataout;
	wire_nl0iO_dataout <= wire_nl11i_dataout WHEN niOl0i = '1'  ELSE wire_nl0ll_dataout;
	wire_nl0li_dataout <= nll01l AND nlll1i;
	wire_nl0ll_dataout <= nll00i AND nlll1i;
	wire_nl0lO_dataout <= wire_niOOl_dataout OR NOT(niOl0i);
	wire_nl0Oi_dataout <= wire_niOOO_dataout WHEN niOl0i = '1'  ELSE niOl1O;
	wire_nl0Ol_dataout <= wire_nl11i_dataout WHEN niOl0i = '1'  ELSE wire_w_lg_niOl1O163w(0);
	wire_nl0OO_dataout <= wire_nilOl_dataout OR NOT(rd_enable_sync);
	wire_nl10i_dataout <= wire_niOll_dataout WHEN niOl0i = '1'  ELSE wire_nl1lO_dataout;
	wire_nl10l_dataout <= wire_niOlO_dataout WHEN niOl0i = '1'  ELSE wire_nl1Oi_dataout;
	wire_nl10O_dataout <= wire_niOOi_dataout WHEN niOl0i = '1'  ELSE wire_nl1Ol_dataout;
	wire_nl11i_dataout <= tx_data(7) OR niOO1l;
	wire_nl11l_dataout <= wire_niOiO_dataout WHEN niOl0i = '1'  ELSE wire_nl1li_dataout;
	wire_nl11O_dataout <= wire_niOli_dataout WHEN niOl0i = '1'  ELSE wire_nl1ll_dataout;
	wire_nl1ii_dataout <= wire_niOOl_dataout WHEN niOl0i = '1'  ELSE wire_nl1OO_dataout;
	wire_nl1il_dataout <= wire_niOOO_dataout WHEN niOl0i = '1'  ELSE wire_nl01i_dataout;
	wire_nl1iO_dataout <= wire_nl11i_dataout WHEN niOl0i = '1'  ELSE wire_nl01l_dataout;
	wire_nl1li_dataout <= nll1ll AND nlll1i;
	wire_nl1ll_dataout <= nll1Oi AND nlll1i;
	wire_nl1lO_dataout <= nll1Ol OR NOT(nlll1i);
	wire_nl1Oi_dataout <= nll1OO OR NOT(nlll1i);
	wire_nl1Ol_dataout <= nll01i OR NOT(nlll1i);
	wire_nl1OO_dataout <= nll01l WHEN nlll1i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_nli0i_dataout <= wire_niO1O_dataout OR NOT(rd_enable_sync);
	wire_nli0l_dataout <= wire_niO0i_dataout OR NOT(rd_enable_sync);
	wire_nli0O_dataout <= wire_nl00O_dataout OR NOT(rd_enable_sync);
	wire_nli1i_dataout <= wire_nilOO_dataout AND rd_enable_sync;
	wire_nli1l_dataout <= wire_niO1i_dataout AND rd_enable_sync;
	wire_nli1O_dataout <= wire_niO1l_dataout OR NOT(rd_enable_sync);
	wire_nliii_dataout <= wire_niO0O_dataout AND rd_enable_sync;
	wire_nliil_dataout <= wire_nl0ii_dataout OR NOT(rd_enable_sync);
	wire_nlill_dataout <= wire_nliOi_dataout AND niOilO;
	wire_nlilO_dataout <= niOili AND niOilO;
	wire_nliO0i_dataout <= nll10l WHEN niOi0l = '1'  ELSE wire_nliOiO_dataout;
	wire_nliO0l_dataout <= nll10O WHEN niOi0l = '1'  ELSE wire_nliOli_dataout;
	wire_nliO0O_dataout <= nll1ii WHEN niOi0l = '1'  ELSE wire_nliOll_dataout;
	wire_nliO1O_dataout <= nliO1l WHEN niOi0l = '1'  ELSE wire_nliOil_dataout;
	wire_nliOi_dataout <= (nliiO AND niili) OR niOili;
	wire_nliOii_dataout <= wire_nliOlO_dataout OR niOi0l;
	wire_nliOil_dataout <= wire_nliOOl_o(1) WHEN niOl1l = '1'  ELSE nliOOi;
	wire_nliOiO_dataout <= wire_nliOOl_o(2) WHEN niOl1l = '1'  ELSE nlilOi;
	wire_nliOli_dataout <= wire_nliOOl_o(3) WHEN niOl1l = '1'  ELSE nlilOl;
	wire_nliOll_dataout <= wire_nliOOl_o(4) WHEN niOl1l = '1'  ELSE nlilOO;
	wire_nliOlO_dataout <= wire_nliOOl_o(5) WHEN niOl1l = '1'  ELSE nliO1i;
	wire_nllii_dataout <= wire_nllil_dataout AND NOT(nlili);
	wire_nllil_dataout <= nll0l OR nliiO;
	wire_nlll0i_dataout <= nlll1i AND NOT(niOilO);
	wire_nlll1O_dataout <= wire_nlll0i_dataout OR niOliO;
	wire_nllli_dataout <= wire_nllll_dataout OR ((wire_w_lg_w_lg_w_lg_rd_enable_sync162w282w283w(0) OR wire_w_lg_w_lg_rd_enable_sync284w285w(0)) OR wire_n0Oi_w_lg_w_lg_w_lg_nll0O287w288w289w(0));
	wire_nllll_dataout <= nll0O AND NOT((niOiOl AND niOl1O));
	wire_nlllOl_dataout <= wire_nllOil_o OR niOOil;
	wire_nlllOO_dataout <= wire_nllOiO_o AND NOT(niOOil);
	wire_nllO0i_dataout <= wire_nllOOi_o OR niOOil;
	wire_nllO0l_dataout <= wire_nllOOl_o OR niOOil;
	wire_nllO0O_dataout <= wire_nllOOO_o OR niOOil;
	wire_nllO1i_dataout <= wire_nllOli_o OR niOOil;
	wire_nllO1l_dataout <= wire_nllOll_o OR niOOil;
	wire_nllO1O_dataout <= wire_nllOlO_o OR niOOil;
	wire_nllOii_dataout <= wire_nlO11i_o OR niOOil;
	wire_nlO00i_dataout <= wire_nlO0Oi_dataout OR niOiil;
	wire_nlO00l_dataout <= tx_ctl(3) OR niOlli;
	wire_nlO00O_dataout <= tx_data(24) OR niOlli;
	wire_nlO01i_dataout <= wire_nlO0li_dataout OR niOiil;
	wire_nlO01l_dataout <= wire_nlO0ll_dataout OR niOiil;
	wire_nlO01O_dataout <= wire_nlO0lO_dataout AND NOT(niOiil);
	wire_nlO0ii_dataout <= tx_data(25) AND NOT(niOlli);
	wire_nlO0il_dataout <= tx_data(26) OR niOlli;
	wire_nlO0iO_dataout <= tx_data(27) OR niOlli;
	wire_nlO0li_dataout <= tx_data(28) OR niOlli;
	wire_nlO0ll_dataout <= tx_data(29) OR niOlli;
	wire_nlO0lO_dataout <= tx_data(30) OR niOlli;
	wire_nlO0Oi_dataout <= tx_data(31) OR niOlli;
	wire_nlO10i_dataout <= wire_nlO1Oi_dataout AND niOl0i;
	wire_nlO10l_dataout <= wire_nlO1Ol_dataout OR NOT(niOl0i);
	wire_nlO10O_dataout <= wire_nlO1OO_dataout OR NOT(niOl0i);
	wire_nlO11l_dataout <= wire_nlO1ll_dataout OR NOT(niOl0i);
	wire_nlO11O_dataout <= wire_nlO1lO_dataout AND niOl0i;
	wire_nlO1ii_dataout <= wire_nlO01i_dataout OR NOT(niOl0i);
	wire_nlO1il_dataout <= wire_nlO01l_dataout WHEN niOl0i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_nlO1iO_dataout <= wire_nlO01O_dataout AND niOl0i;
	wire_nlO1li_dataout <= wire_nlO00i_dataout WHEN niOl0i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_nlO1ll_dataout <= wire_nlO00l_dataout OR niOiil;
	wire_nlO1lO_dataout <= wire_nlO00O_dataout AND NOT(niOiil);
	wire_nlO1Oi_dataout <= wire_nlO0ii_dataout AND NOT(niOiil);
	wire_nlO1Ol_dataout <= wire_nlO0il_dataout OR niOiil;
	wire_nlO1OO_dataout <= wire_nlO0iO_dataout OR niOiil;
	wire_nlOi0i_dataout <= wire_nlO1Oi_dataout WHEN niOl0i = '1'  ELSE wire_nlOilO_dataout;
	wire_nlOi0l_dataout <= wire_nlO1Ol_dataout WHEN niOl0i = '1'  ELSE wire_nlOiOi_dataout;
	wire_nlOi0O_dataout <= wire_nlO1OO_dataout WHEN niOl0i = '1'  ELSE wire_nlOiOl_dataout;
	wire_nlOi1l_dataout <= wire_nlO1ll_dataout WHEN niOl0i = '1'  ELSE wire_ni1i_w_lg_nlll1i164w(0);
	wire_nlOi1O_dataout <= wire_nlO1lO_dataout WHEN niOl0i = '1'  ELSE wire_nlOill_dataout;
	wire_nlOiii_dataout <= wire_nlO01i_dataout WHEN niOl0i = '1'  ELSE wire_nlOiOO_dataout;
	wire_nlOiil_dataout <= wire_nlO01l_dataout WHEN niOl0i = '1'  ELSE wire_nlOl1i_dataout;
	wire_nlOiiO_dataout <= wire_nlO01O_dataout WHEN niOl0i = '1'  ELSE wire_nlOl1l_dataout;
	wire_nlOili_dataout <= wire_nlO00i_dataout WHEN niOl0i = '1'  ELSE wire_nlOl1O_dataout;
	wire_nlOill_dataout <= nlli0O AND nlll1i;
	wire_nlOilO_dataout <= nlliil AND nlll1i;
	wire_nlOiOi_dataout <= nlliiO OR NOT(nlll1i);
	wire_nlOiOl_dataout <= nllili OR NOT(nlll1i);
	wire_nlOiOO_dataout <= nllill OR NOT(nlll1i);
	wire_nlOl0i_dataout <= wire_nlO01l_dataout WHEN niOl0i = '1'  ELSE wire_nlOlii_dataout;
	wire_nlOl0l_dataout <= wire_nlO01O_dataout WHEN niOl0i = '1'  ELSE wire_w_lg_niOl1l165w(0);
	wire_nlOl0O_dataout <= wire_nlO00i_dataout WHEN niOl0i = '1'  ELSE wire_nlOlil_dataout;
	wire_nlOl1i_dataout <= nllilO WHEN nlll1i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_nlOl1l_dataout <= nlliOi AND nlll1i;
	wire_nlOl1O_dataout <= nlliOO WHEN nlll1i = '1'  ELSE wire_n0Oi_w_lg_nliO1l166w(0);
	wire_nlOlii_dataout <= wire_n0Oi_w_lg_nliO1l166w(0) OR wire_w_lg_niOl1l165w(0);
	wire_nlOlil_dataout <= wire_n0Oi_w_lg_nliO1l166w(0) AND NOT(wire_w_lg_niOl1l165w(0));
	wire_nlOliO_dataout <= wire_nlO01l_dataout AND niOl0i;
	wire_nlOll_dataout <= wire_n10O_dataout AND wire_nlOlO_o(7);
	wire_nlOlli_dataout <= wire_nlO00i_dataout AND niOl0i;
	wire_nlOlll_dataout <= wire_nlO01l_dataout WHEN niOl0i = '1'  ELSE wire_nlOlOi_dataout;
	wire_nlOllO_dataout <= wire_nlO00i_dataout WHEN niOl0i = '1'  ELSE wire_nlOlOl_dataout;
	wire_nlOlOi_dataout <= nllilO AND nlll1i;
	wire_nlOlOl_dataout <= nlliOO AND nlll1i;
	wire_nlOlOO_dataout <= wire_nlO01l_dataout OR NOT(niOl0i);
	wire_nlOO0i_dataout <= wire_nlO11l_dataout OR NOT(rd_enable_sync);
	wire_nlOO0l_dataout <= wire_nlO11O_dataout AND rd_enable_sync;
	wire_nlOO0O_dataout <= wire_nlO10i_dataout AND rd_enable_sync;
	wire_nlOO1i_dataout <= wire_nlO01O_dataout WHEN niOl0i = '1'  ELSE niOl1O;
	wire_nlOO1l_dataout <= wire_nlO00i_dataout WHEN niOl0i = '1'  ELSE wire_w_lg_niOl1O163w(0);
	wire_nlOOi_dataout <= wire_n11i_dataout OR nlliO;
	wire_nlOOii_dataout <= wire_nlO10l_dataout OR NOT(rd_enable_sync);
	wire_nlOOil_dataout <= wire_nlO10O_dataout OR NOT(rd_enable_sync);
	wire_nlOOiO_dataout <= wire_nlO1ii_dataout OR NOT(rd_enable_sync);
	wire_nlOOl_dataout <= wire_n11l_dataout OR nlliO;
	wire_nlOOli_dataout <= wire_nlOliO_dataout OR NOT(rd_enable_sync);
	wire_nlOOll_dataout <= wire_nlO1iO_dataout AND rd_enable_sync;
	wire_nlOOlO_dataout <= wire_nlOlli_dataout OR NOT(rd_enable_sync);
	wire_nlOOO_dataout <= wire_w_lg_niOl0i161w(0) AND NOT(nlliO);
	wire_nliOOl_a <= ( nliO1i & nlilOO & nlilOl & nlilOi & nliOOi & "1");
	wire_nliOOl_b <= ( "1" & "1" & "1" & "1" & "0" & "1");
	nliOOl :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 6,
		width_b => 6,
		width_o => 6
	  )
	  PORT MAP ( 
		a => wire_nliOOl_a,
		b => wire_nliOOl_b,
		cin => wire_gnd,
		o => wire_nliOOl_o
	  );
	wire_nlOlO_i <= ( ni1l & n0OO & n0Ol & n0lO);
	nlOlO :  oper_decoder
	  GENERIC MAP (
		width_i => 4,
		width_o => 16
	  )
	  PORT MAP ( 
		i => wire_nlOlO_i,
		o => wire_nlOlO_o
	  );
	wire_nlO0O_a <= ( "1" & "0" & "0" & "0");
	wire_nlO0O_b <= ( ni1l & n0OO & n0Ol & n0lO);
	nlO0O :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nlO0O_a,
		b => wire_nlO0O_b,
		cin => wire_gnd,
		o => wire_nlO0O_o
	  );
	wire_n0i0i_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_n0iOi_dataout & wire_n0Oli_dataout & wire_n0iOi_dataout & wire_n0iOi_dataout & wire_n0iOi_dataout & wire_ni0iO_dataout & wire_n0Oli_dataout & wire_n0iOi_dataout & "0");
	wire_n0i0i_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n0i0i :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0i0i_data,
		o => wire_n0i0i_o,
		sel => wire_n0i0i_sel
	  );
	wire_n0i0l_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_n0iOl_dataout & wire_n0Oll_dataout & wire_n0iOl_dataout & wire_n0iOl_dataout & wire_n0iOl_dataout & wire_ni0li_dataout & wire_n0Oll_dataout & wire_n0iOl_dataout & "0");
	wire_n0i0l_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n0i0l :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0i0l_data,
		o => wire_n0i0l_o,
		sel => wire_n0i0l_sel
	  );
	wire_n0i0O_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n0iOO_dataout & wire_n0OlO_dataout & wire_n0iOO_dataout & wire_n0iOO_dataout & wire_n0iOO_dataout & wire_ni0ll_dataout & wire_n0OlO_dataout & wire_n0iOO_dataout & "1");
	wire_n0i0O_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n0i0O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0i0O_data,
		o => wire_n0i0O_o,
		sel => wire_n0i0O_sel
	  );
	wire_n0i1O_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n0ilO_dataout & wire_n0OiO_dataout & wire_n0ilO_dataout & wire_n0ilO_dataout & wire_n0ilO_dataout & wire_ni0il_dataout & wire_n0OiO_dataout & wire_n0ilO_dataout & "1");
	wire_n0i1O_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n0i1O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0i1O_data,
		o => wire_n0i1O_o,
		sel => wire_n0i1O_sel
	  );
	wire_n0iii_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n0l1i_dataout & wire_n0OOi_dataout & wire_n0l1i_dataout & wire_n0l1i_dataout & wire_n0l1i_dataout & wire_ni0lO_dataout & wire_n0OOi_dataout & wire_n0l1i_dataout & "1");
	wire_n0iii_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n0iii :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0iii_data,
		o => wire_n0iii_o,
		sel => wire_n0iii_sel
	  );
	wire_n0iil_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n0l1l_dataout & wire_n0OOl_dataout & wire_n0l1l_dataout & wire_n0l1l_dataout & wire_n0l1l_dataout & wire_ni0Oi_dataout & wire_n0OOl_dataout & wire_n0l1l_dataout & "1");
	wire_n0iil_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n0iil :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0iil_data,
		o => wire_n0iil_o,
		sel => wire_n0iil_sel
	  );
	wire_n0iiO_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n0l1O_dataout & wire_n0OOO_dataout & wire_ni1ll_dataout & wire_ni1ll_dataout & wire_ni1Ol_dataout & wire_ni0Ol_dataout & wire_ni01i_dataout & wire_ni00l_dataout & "1");
	wire_n0iiO_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n0iiO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0iiO_data,
		o => wire_n0iiO_o,
		sel => wire_n0iiO_sel
	  );
	wire_n0ili_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_n0l0i_dataout & wire_ni11i_dataout & wire_ni1lO_dataout & wire_ni1lO_dataout & wire_n0l0i_dataout & wire_ni0OO_dataout & wire_ni11i_dataout & wire_ni00O_dataout & "0");
	wire_n0ili_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n0ili :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0ili_data,
		o => wire_n0ili_o,
		sel => wire_n0ili_sel
	  );
	wire_n0ill_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n0l0l_dataout & wire_ni11l_dataout & wire_ni1Oi_dataout & wire_ni1Oi_dataout & wire_ni1OO_dataout & wire_nii1i_dataout & wire_ni01l_dataout & wire_ni0ii_dataout & "1");
	wire_n0ill_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n0ill :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0ill_data,
		o => wire_n0ill_o,
		sel => wire_n0ill_sel
	  );
	wire_n100i_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n10Oi_dataout & wire_n1lli_dataout & wire_n10Oi_dataout & wire_n10Oi_dataout & wire_n10Oi_dataout & wire_n01iO_dataout & wire_n1lli_dataout & wire_n10Oi_dataout & "1");
	wire_n100i_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n100i :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n100i_data,
		o => wire_n100i_o,
		sel => wire_n100i_sel
	  );
	wire_n100l_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n10Ol_dataout & wire_n1lll_dataout & wire_n10Ol_dataout & wire_n10Ol_dataout & wire_n10Ol_dataout & wire_n01li_dataout & wire_n1lll_dataout & wire_n10Ol_dataout & "1");
	wire_n100l_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n100l :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n100l_data,
		o => wire_n100l_o,
		sel => wire_n100l_sel
	  );
	wire_n100O_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n10OO_dataout & wire_n1llO_dataout & wire_n10OO_dataout & wire_n10OO_dataout & wire_n10OO_dataout & wire_n01ll_dataout & wire_n1llO_dataout & wire_n10OO_dataout & "1");
	wire_n100O_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n100O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n100O_data,
		o => wire_n100O_o,
		sel => wire_n100O_sel
	  );
	wire_n101i_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n10li_dataout & wire_n1lii_dataout & wire_n10li_dataout & wire_n10li_dataout & wire_n10li_dataout & wire_n010O_dataout & wire_n1lii_dataout & wire_n10li_dataout & "1");
	wire_n101i_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n101i :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n101i_data,
		o => wire_n101i_o,
		sel => wire_n101i_sel
	  );
	wire_n101l_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_n10ll_dataout & wire_n1lil_dataout & wire_n10ll_dataout & wire_n10ll_dataout & wire_n10ll_dataout & wire_n01ii_dataout & wire_n1lil_dataout & wire_n10ll_dataout & "0");
	wire_n101l_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n101l :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n101l_data,
		o => wire_n101l_o,
		sel => wire_n101l_sel
	  );
	wire_n101O_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_n10lO_dataout & wire_n1liO_dataout & wire_n10lO_dataout & wire_n10lO_dataout & wire_n10lO_dataout & wire_n01il_dataout & wire_n1liO_dataout & wire_n10lO_dataout & "0");
	wire_n101O_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n101O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n101O_data,
		o => wire_n101O_o,
		sel => wire_n101O_sel
	  );
	wire_n10ii_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n1i1i_dataout & wire_n1lOi_dataout & wire_n1OiO_dataout & wire_n1OiO_dataout & wire_n1OlO_dataout & wire_n01lO_dataout & wire_n1OOl_dataout & wire_n011O_dataout & "1");
	wire_n10ii_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n10ii :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n10ii_data,
		o => wire_n10ii_o,
		sel => wire_n10ii_sel
	  );
	wire_n10il_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_n1i1l_dataout & wire_n1lOl_dataout & wire_n1Oli_dataout & wire_n1Oli_dataout & wire_n1i1l_dataout & wire_n01Oi_dataout & wire_n1lOl_dataout & wire_n010i_dataout & "0");
	wire_n10il_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n10il :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n10il_data,
		o => wire_n10il_o,
		sel => wire_n10il_sel
	  );
	wire_n10iO_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_n1i1O_dataout & wire_n1lOO_dataout & wire_n1Oll_dataout & wire_n1Oll_dataout & wire_n1OOi_dataout & wire_n01Ol_dataout & wire_n1OOO_dataout & wire_n010l_dataout & "1");
	wire_n10iO_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	n10iO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n10iO_data,
		o => wire_n10iO_o,
		sel => wire_n10iO_sel
	  );
	wire_nil0l_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_nilOl_dataout & wire_nilOl_dataout & wire_nilOl_dataout & wire_nilOl_dataout & wire_nilOl_dataout & wire_nl0OO_dataout & wire_nilOl_dataout & wire_nilOl_dataout & "1");
	wire_nil0l_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nil0l :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nil0l_data,
		o => wire_nil0l_o,
		sel => wire_nil0l_sel
	  );
	wire_nil0O_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_nilOO_dataout & wire_nl11l_dataout & wire_nilOO_dataout & wire_nilOO_dataout & wire_nilOO_dataout & wire_nli1i_dataout & wire_nl11l_dataout & wire_nilOO_dataout & "0");
	wire_nil0O_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nil0O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nil0O_data,
		o => wire_nil0O_o,
		sel => wire_nil0O_sel
	  );
	wire_nilii_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_niO1i_dataout & wire_nl11O_dataout & wire_niO1i_dataout & wire_niO1i_dataout & wire_niO1i_dataout & wire_nli1l_dataout & wire_nl11O_dataout & wire_niO1i_dataout & "0");
	wire_nilii_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nilii :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilii_data,
		o => wire_nilii_o,
		sel => wire_nilii_sel
	  );
	wire_nilil_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_niO1l_dataout & wire_nl10i_dataout & wire_niO1l_dataout & wire_niO1l_dataout & wire_niO1l_dataout & wire_nli1O_dataout & wire_nl10i_dataout & wire_niO1l_dataout & "1");
	wire_nilil_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nilil :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilil_data,
		o => wire_nilil_o,
		sel => wire_nilil_sel
	  );
	wire_niliO_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_niO1O_dataout & wire_nl10l_dataout & wire_niO1O_dataout & wire_niO1O_dataout & wire_niO1O_dataout & wire_nli0i_dataout & wire_nl10l_dataout & wire_niO1O_dataout & "1");
	wire_niliO_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	niliO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_niliO_data,
		o => wire_niliO_o,
		sel => wire_niliO_sel
	  );
	wire_nilli_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_niO0i_dataout & wire_nl10O_dataout & wire_niO0i_dataout & wire_niO0i_dataout & wire_niO0i_dataout & wire_nli0l_dataout & wire_nl10O_dataout & wire_niO0i_dataout & "1");
	wire_nilli_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nilli :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilli_data,
		o => wire_nilli_o,
		sel => wire_nilli_sel
	  );
	wire_nilll_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_niO0l_dataout & wire_nl1ii_dataout & wire_nl01O_dataout & wire_nl01O_dataout & wire_nl00O_dataout & wire_nli0O_dataout & wire_nl0il_dataout & wire_nl0lO_dataout & "1");
	wire_nilll_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nilll :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilll_data,
		o => wire_nilll_o,
		sel => wire_nilll_sel
	  );
	wire_nillO_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_niO0O_dataout & wire_nl1il_dataout & wire_nl00i_dataout & wire_nl00i_dataout & wire_niO0O_dataout & wire_nliii_dataout & wire_nl1il_dataout & wire_nl0Oi_dataout & "0");
	wire_nillO_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nillO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nillO_data,
		o => wire_nillO_o,
		sel => wire_nillO_sel
	  );
	wire_nilOi_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_niOii_dataout & wire_nl1iO_dataout & wire_nl00l_dataout & wire_nl00l_dataout & wire_nl0ii_dataout & wire_nliil_dataout & wire_nl0iO_dataout & wire_nl0Ol_dataout & "1");
	wire_nilOi_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nilOi :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilOi_data,
		o => wire_nilOi_o,
		sel => wire_nilOi_sel
	  );
	wire_nllOil_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_nlO11l_dataout & wire_nlOi1l_dataout & wire_nlO11l_dataout & wire_nlO11l_dataout & wire_nlO11l_dataout & wire_nlOO0i_dataout & wire_nlOi1l_dataout & wire_nlO11l_dataout & "1");
	wire_nllOil_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nllOil :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nllOil_data,
		o => wire_nllOil_o,
		sel => wire_nllOil_sel
	  );
	wire_nllOiO_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_nlO11O_dataout & wire_nlOi1O_dataout & wire_nlO11O_dataout & wire_nlO11O_dataout & wire_nlO11O_dataout & wire_nlOO0l_dataout & wire_nlOi1O_dataout & wire_nlO11O_dataout & "0");
	wire_nllOiO_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nllOiO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nllOiO_data,
		o => wire_nllOiO_o,
		sel => wire_nllOiO_sel
	  );
	wire_nllOli_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_nlO10i_dataout & wire_nlOi0i_dataout & wire_nlO10i_dataout & wire_nlO10i_dataout & wire_nlO10i_dataout & wire_nlOO0O_dataout & wire_nlOi0i_dataout & wire_nlO10i_dataout & "0");
	wire_nllOli_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nllOli :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nllOli_data,
		o => wire_nllOli_o,
		sel => wire_nllOli_sel
	  );
	wire_nllOll_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_nlO10l_dataout & wire_nlOi0l_dataout & wire_nlO10l_dataout & wire_nlO10l_dataout & wire_nlO10l_dataout & wire_nlOOii_dataout & wire_nlOi0l_dataout & wire_nlO10l_dataout & "1");
	wire_nllOll_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nllOll :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nllOll_data,
		o => wire_nllOll_o,
		sel => wire_nllOll_sel
	  );
	wire_nllOlO_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_nlO10O_dataout & wire_nlOi0O_dataout & wire_nlO10O_dataout & wire_nlO10O_dataout & wire_nlO10O_dataout & wire_nlOOil_dataout & wire_nlOi0O_dataout & wire_nlO10O_dataout & "1");
	wire_nllOlO_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nllOlO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nllOlO_data,
		o => wire_nllOlO_o,
		sel => wire_nllOlO_sel
	  );
	wire_nllOOi_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_nlO1ii_dataout & wire_nlOiii_dataout & wire_nlO1ii_dataout & wire_nlO1ii_dataout & wire_nlO1ii_dataout & wire_nlOOiO_dataout & wire_nlOiii_dataout & wire_nlO1ii_dataout & "1");
	wire_nllOOi_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nllOOi :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nllOOi_data,
		o => wire_nllOOi_o,
		sel => wire_nllOOi_sel
	  );
	wire_nllOOl_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_nlO1il_dataout & wire_nlOiil_dataout & wire_nlOl0i_dataout & wire_nlOl0i_dataout & wire_nlOliO_dataout & wire_nlOOli_dataout & wire_nlOlll_dataout & wire_nlOlOO_dataout & "1");
	wire_nllOOl_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nllOOl :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nllOOl_data,
		o => wire_nllOOl_o,
		sel => wire_nllOOl_sel
	  );
	wire_nllOOO_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_nlO1iO_dataout & wire_nlOiiO_dataout & wire_nlOl0l_dataout & wire_nlOl0l_dataout & wire_nlO1iO_dataout & wire_nlOOll_dataout & wire_nlOiiO_dataout & wire_nlOO1i_dataout & "0");
	wire_nllOOO_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nllOOO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nllOOO_data,
		o => wire_nllOOO_o,
		sel => wire_nllOOO_sel
	  );
	wire_nlO11i_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_nlO1li_dataout & wire_nlOili_dataout & wire_nlOl0O_dataout & wire_nlOl0O_dataout & wire_nlOlli_dataout & wire_nlOOlO_dataout & wire_nlOllO_dataout & wire_nlOO1l_dataout & "1");
	wire_nlO11i_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nlO11i :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nlO11i_data,
		o => wire_nlO11i_o,
		sel => wire_nlO11i_sel
	  );
	wire_nlOil_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_nlOOi_dataout & wire_n11O_dataout & wire_n1Oi_dataout & wire_n1Oi_dataout & "1" & "1" & wire_n01O_dataout & wire_n00l_dataout & "1");
	wire_nlOil_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nlOil :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nlOil_data,
		o => wire_nlOil_o,
		sel => wire_nlOil_sel
	  );
	wire_nlOiO_data <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & wire_nlOOl_dataout & wire_n10i_dataout & wire_n1Ol_dataout & wire_n1Ol_dataout & nlliO & wire_n0il_dataout & nlliO & wire_n00O_dataout & "1");
	wire_nlOiO_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nlOiO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nlOiO_data,
		o => wire_nlOiO_o,
		sel => wire_nlOiO_sel
	  );
	wire_nlOli_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & wire_nlOOO_dataout & wire_n10l_dataout & wire_nlOOO_dataout & wire_nlOOO_dataout & wire_nlOOO_dataout & wire_n0iO_dataout & wire_nlOOO_dataout & "0" & "0");
	wire_nlOli_sel <= ( ni1l & n0OO & n0Ol & n0lO);
	nlOli :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nlOli_data,
		o => wire_nlOli_o,
		sel => wire_nlOli_sel
	  );

 END RTL; --stratixiigx_hssi_tx_sm
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 131 mux21 352 oper_mux 3 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_rcv_sm IS 
	 PORT 
	 ( 
		 clk_2	:	IN  STD_LOGIC;
		 curr_state	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 dec_ctl	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 dec_data	:	IN  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 dec_data_valid	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 indv	:	IN  STD_LOGIC;
		 running_disp	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rx_ctl_rs	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rx_data_rs	:	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 rx_local_fault	:	OUT  STD_LOGIC;
		 rx_local_fault_clr	:	IN  STD_LOGIC;
		 soft_reset	:	IN  STD_LOGIC;
		 tx_local_fault_det	:	IN  STD_LOGIC;
		 xs_link_status	:	OUT  STD_LOGIC;
		 xs_link_status_set	:	IN  STD_LOGIC
	 ); 
 END stratixiigx_hssi_rcv_sm;

 ARCHITECTURE RTL OF stratixiigx_hssi_rcv_sm IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nl000i31	:	STD_LOGIC := '0';
	 SIGNAL	 nl000i32	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl000i32_w_lg_w_lg_q141w142w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl000i32_w_lg_q141w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl000l29	:	STD_LOGIC := '0';
	 SIGNAL	 nl000l30	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl000l30_w_lg_w_lg_q124w125w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl000l30_w_lg_q124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl001O33	:	STD_LOGIC := '0';
	 SIGNAL	 nl001O34	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl001O34_w_lg_w_lg_q144w145w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl001O34_w_lg_q144w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl00ii27	:	STD_LOGIC := '0';
	 SIGNAL	 nl00ii28	:	STD_LOGIC := '0';
	 SIGNAL	 nl00iO25	:	STD_LOGIC := '0';
	 SIGNAL	 nl00iO26	:	STD_LOGIC := '0';
	 SIGNAL	 nl00ll23	:	STD_LOGIC := '0';
	 SIGNAL	 nl00ll24	:	STD_LOGIC := '0';
	 SIGNAL	 nl00Oi21	:	STD_LOGIC := '0';
	 SIGNAL	 nl00Oi22	:	STD_LOGIC := '0';
	 SIGNAL	 nl010l41	:	STD_LOGIC := '0';
	 SIGNAL	 nl010l42	:	STD_LOGIC := '0';
	 SIGNAL	 nl011i43	:	STD_LOGIC := '0';
	 SIGNAL	 nl011i44	:	STD_LOGIC := '0';
	 SIGNAL	 nl01il39	:	STD_LOGIC := '0';
	 SIGNAL	 nl01il40	:	STD_LOGIC := '0';
	 SIGNAL	 nl01li37	:	STD_LOGIC := '0';
	 SIGNAL	 nl01li38	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl01li38_w_lg_q170w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl01Ol35	:	STD_LOGIC := '0';
	 SIGNAL	 nl01Ol36	:	STD_LOGIC := '0';
	 SIGNAL	 nl0i0l17	:	STD_LOGIC := '0';
	 SIGNAL	 nl0i0l18	:	STD_LOGIC := '0';
	 SIGNAL	 nl0i1l19	:	STD_LOGIC := '0';
	 SIGNAL	 nl0i1l20	:	STD_LOGIC := '0';
	 SIGNAL	 nl0iiO15	:	STD_LOGIC := '0';
	 SIGNAL	 nl0iiO16	:	STD_LOGIC := '0';
	 SIGNAL	 nl0iOO13	:	STD_LOGIC := '0';
	 SIGNAL	 nl0iOO14	:	STD_LOGIC := '0';
	 SIGNAL	 nl0l0O11	:	STD_LOGIC := '0';
	 SIGNAL	 nl0l0O12	:	STD_LOGIC := '0';
	 SIGNAL	 nl0lli10	:	STD_LOGIC := '0';
	 SIGNAL	 nl0lli9	:	STD_LOGIC := '0';
	 SIGNAL	 nl0lOl7	:	STD_LOGIC := '0';
	 SIGNAL	 nl0lOl8	:	STD_LOGIC := '0';
	 SIGNAL	 nl0O0l5	:	STD_LOGIC := '0';
	 SIGNAL	 nl0O0l6	:	STD_LOGIC := '0';
	 SIGNAL	 nl0OiO3	:	STD_LOGIC := '0';
	 SIGNAL	 nl0OiO4	:	STD_LOGIC := '0';
	 SIGNAL	 nl0OOi1	:	STD_LOGIC := '0';
	 SIGNAL	 nl0OOi2	:	STD_LOGIC := '0';
	 SIGNAL	n001i	:	STD_LOGIC := '0';
	 SIGNAL	n01il	:	STD_LOGIC := '0';
	 SIGNAL	n01lO	:	STD_LOGIC := '0';
	 SIGNAL	n01Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0l0i	:	STD_LOGIC := '0';
	 SIGNAL	n0l0l	:	STD_LOGIC := '0';
	 SIGNAL	n0l0O	:	STD_LOGIC := '0';
	 SIGNAL	n0l1O	:	STD_LOGIC := '0';
	 SIGNAL	n0lii	:	STD_LOGIC := '0';
	 SIGNAL	n0lil	:	STD_LOGIC := '0';
	 SIGNAL	n0liO	:	STD_LOGIC := '0';
	 SIGNAL	n0lli	:	STD_LOGIC := '0';
	 SIGNAL	n0lll	:	STD_LOGIC := '0';
	 SIGNAL	n0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	n100i	:	STD_LOGIC := '0';
	 SIGNAL	n100l	:	STD_LOGIC := '0';
	 SIGNAL	n100O	:	STD_LOGIC := '0';
	 SIGNAL	n101i	:	STD_LOGIC := '0';
	 SIGNAL	n101l	:	STD_LOGIC := '0';
	 SIGNAL	n101O	:	STD_LOGIC := '0';
	 SIGNAL	n10ii	:	STD_LOGIC := '0';
	 SIGNAL	n10il	:	STD_LOGIC := '0';
	 SIGNAL	n10iO	:	STD_LOGIC := '0';
	 SIGNAL	n10li	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0l	:	STD_LOGIC := '0';
	 SIGNAL	ni0O	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	ni1O	:	STD_LOGIC := '0';
	 SIGNAL	nii0i	:	STD_LOGIC := '0';
	 SIGNAL	nii0l	:	STD_LOGIC := '0';
	 SIGNAL	nii0O	:	STD_LOGIC := '0';
	 SIGNAL	nii1i	:	STD_LOGIC := '0';
	 SIGNAL	nii1l	:	STD_LOGIC := '0';
	 SIGNAL	nii1O	:	STD_LOGIC := '0';
	 SIGNAL	niiii	:	STD_LOGIC := '0';
	 SIGNAL	niiil	:	STD_LOGIC := '0';
	 SIGNAL	nill	:	STD_LOGIC := '0';
	 SIGNAL	nl00i	:	STD_LOGIC := '0';
	 SIGNAL	nl00l	:	STD_LOGIC := '0';
	 SIGNAL	nl01i	:	STD_LOGIC := '0';
	 SIGNAL	nl01l	:	STD_LOGIC := '0';
	 SIGNAL	nl01O	:	STD_LOGIC := '0';
	 SIGNAL	nl1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1OO	:	STD_LOGIC := '0';
	 SIGNAL	nllii	:	STD_LOGIC := '0';
	 SIGNAL	nlliii	:	STD_LOGIC := '0';
	 SIGNAL	nlliil	:	STD_LOGIC := '0';
	 SIGNAL	nlliiO	:	STD_LOGIC := '0';
	 SIGNAL	nllil	:	STD_LOGIC := '0';
	 SIGNAL	nllili	:	STD_LOGIC := '0';
	 SIGNAL	nllill	:	STD_LOGIC := '0';
	 SIGNAL	nllilO	:	STD_LOGIC := '0';
	 SIGNAL	nlliOi	:	STD_LOGIC := '0';
	 SIGNAL	nlliOl	:	STD_LOGIC := '0';
	 SIGNAL	nlliOO	:	STD_LOGIC := '0';
	 SIGNAL	nlll1i	:	STD_LOGIC := '0';
	 SIGNAL	nlll1l	:	STD_LOGIC := '0';
	 SIGNAL	nlll1O	:	STD_LOGIC := '0';
	 SIGNAL	nlllO	:	STD_LOGIC := '0';
	 SIGNAL	nllOi	:	STD_LOGIC := '0';
	 SIGNAL	nllOO	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1O	:	STD_LOGIC := '0';
	 SIGNAL	wire_nili_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nili_w_lg_n0Ol265w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_n0OO264w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n01iO	:	STD_LOGIC := '0';
	 SIGNAL	n01li	:	STD_LOGIC := '0';
	 SIGNAL	n01ll	:	STD_LOGIC := '0';
	 SIGNAL	n01Ol	:	STD_LOGIC := '0';
	 SIGNAL	n01OO	:	STD_LOGIC := '0';
	 SIGNAL	niiiO	:	STD_LOGIC := '0';
	 SIGNAL	niOi	:	STD_LOGIC := '0';
	 SIGNAL	nl00O	:	STD_LOGIC := '0';
	 SIGNAL	nlliO	:	STD_LOGIC := '0';
	 SIGNAL	nllli	:	STD_LOGIC := '0';
	 SIGNAL	nllll	:	STD_LOGIC := '0';
	 SIGNAL	nllOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0O	:	STD_LOGIC := '0';
	 SIGNAL	wire_nilO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_n000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni_w_lg_dataout12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni_w_lg_dataout184w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl_w_lg_dataout19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_dataout172w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO_w_lg_dataout5w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nO_w_lg_dataout220w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0ii_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ii_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0il_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0il_o	:	STD_LOGIC;
	 SIGNAL  wire_n0il_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0iO_w_lg_o112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0iO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl0liO168w171w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0liO168w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0lOi183w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_ctl_range6w7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_ctl_range13w14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_ctl_range20w21w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_ctl_range43w221w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range159w268w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range211w284w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range203w292w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range219w276w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl00lO110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl00OO118w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0i0i85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0i1i92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0iii78w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0iil76w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0ill63w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0iOi59w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0l0i51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0l1l53w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0lil45w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0llO37w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0O1i30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0O1O27w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range210w283w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range158w267w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range202w291w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range218w275w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl00lO110w113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nl0O1l67w68w69w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl0l1O61w62w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl0O1l67w68w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0l1O61w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0O1l67w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nl000O :	STD_LOGIC;
	 SIGNAL  nl001i :	STD_LOGIC;
	 SIGNAL  nl001l :	STD_LOGIC;
	 SIGNAL  nl00li :	STD_LOGIC;
	 SIGNAL  nl00lO :	STD_LOGIC;
	 SIGNAL  nl00OO :	STD_LOGIC;
	 SIGNAL  nl010i :	STD_LOGIC;
	 SIGNAL  nl011O :	STD_LOGIC;
	 SIGNAL  nl01ii :	STD_LOGIC;
	 SIGNAL  nl01lO :	STD_LOGIC;
	 SIGNAL  nl01Oi :	STD_LOGIC;
	 SIGNAL  nl0i0i :	STD_LOGIC;
	 SIGNAL  nl0i1i :	STD_LOGIC;
	 SIGNAL  nl0iii :	STD_LOGIC;
	 SIGNAL  nl0iil :	STD_LOGIC;
	 SIGNAL  nl0ill :	STD_LOGIC;
	 SIGNAL  nl0ilO :	STD_LOGIC;
	 SIGNAL  nl0iOi :	STD_LOGIC;
	 SIGNAL  nl0iOl :	STD_LOGIC;
	 SIGNAL  nl0l0i :	STD_LOGIC;
	 SIGNAL  nl0l0l :	STD_LOGIC;
	 SIGNAL  nl0l1l :	STD_LOGIC;
	 SIGNAL  nl0l1O :	STD_LOGIC;
	 SIGNAL  nl0lil :	STD_LOGIC;
	 SIGNAL  nl0liO :	STD_LOGIC;
	 SIGNAL  nl0llO :	STD_LOGIC;
	 SIGNAL  nl0lOi :	STD_LOGIC;
	 SIGNAL  nl0O0i :	STD_LOGIC;
	 SIGNAL  nl0O1i :	STD_LOGIC;
	 SIGNAL  nl0O1l :	STD_LOGIC;
	 SIGNAL  nl0O1O :	STD_LOGIC;
	 SIGNAL  nl0Oii :	STD_LOGIC;
	 SIGNAL  nl0Oil :	STD_LOGIC;
	 SIGNAL  nl0Oll :	STD_LOGIC;
	 SIGNAL  nl0OlO :	STD_LOGIC;
	 SIGNAL  nl0OOO :	STD_LOGIC;
	 SIGNAL  nl1Oil :	STD_LOGIC;
	 SIGNAL  nl1OiO :	STD_LOGIC;
	 SIGNAL  nl1Oli :	STD_LOGIC;
	 SIGNAL  nl1Oll :	STD_LOGIC;
	 SIGNAL  nl1OlO :	STD_LOGIC;
	 SIGNAL  nl1OOi :	STD_LOGIC;
	 SIGNAL  nl1OOl :	STD_LOGIC;
	 SIGNAL  nl1OOO :	STD_LOGIC;
	 SIGNAL  nli11i :	STD_LOGIC;
	 SIGNAL  wire_w_dec_ctl_range6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_ctl_range13w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_ctl_range20w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_ctl_range43w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range159w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range211w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range210w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range158w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range203w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range202w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range219w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range218w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w_lg_nl0liO168w171w(0) <= wire_w_lg_nl0liO168w(0) AND wire_nl01li38_w_lg_q170w(0);
	wire_w_lg_nl0liO168w(0) <= nl0liO AND nl0ilO;
	wire_w_lg_nl0lOi183w(0) <= nl0lOi AND nl0iOl;
	wire_w_lg_w_dec_ctl_range6w7w(0) <= wire_w_dec_ctl_range6w(0) AND nl0OOO;
	wire_w_lg_w_dec_ctl_range13w14w(0) <= wire_w_dec_ctl_range13w(0) AND nl0Oll;
	wire_w_lg_w_dec_ctl_range20w21w(0) <= wire_w_dec_ctl_range20w(0) AND nl0Oii;
	wire_w_lg_w_dec_ctl_range43w221w(0) <= wire_w_dec_ctl_range43w(0) AND nl1Oil;
	wire_w_lg_w_dec_data_range159w268w(0) <= wire_w_dec_data_range159w(0) AND wire_w_lg_w_dec_data_range158w267w(0);
	wire_w_lg_w_dec_data_range211w284w(0) <= wire_w_dec_data_range211w(0) AND wire_w_lg_w_dec_data_range210w283w(0);
	wire_w_lg_w_dec_data_range203w292w(0) <= wire_w_dec_data_range203w(0) AND wire_w_lg_w_dec_data_range202w291w(0);
	wire_w_lg_w_dec_data_range219w276w(0) <= wire_w_dec_data_range219w(0) AND wire_w_lg_w_dec_data_range218w275w(0);
	wire_w_lg_nl00lO110w(0) <= NOT nl00lO;
	wire_w_lg_nl00OO118w(0) <= NOT nl00OO;
	wire_w_lg_nl0i0i85w(0) <= NOT nl0i0i;
	wire_w_lg_nl0i1i92w(0) <= NOT nl0i1i;
	wire_w_lg_nl0iii78w(0) <= NOT nl0iii;
	wire_w_lg_nl0iil76w(0) <= NOT nl0iil;
	wire_w_lg_nl0ill63w(0) <= NOT nl0ill;
	wire_w_lg_nl0iOi59w(0) <= NOT nl0iOi;
	wire_w_lg_nl0l0i51w(0) <= NOT nl0l0i;
	wire_w_lg_nl0l1l53w(0) <= NOT nl0l1l;
	wire_w_lg_nl0lil45w(0) <= NOT nl0lil;
	wire_w_lg_nl0llO37w(0) <= NOT nl0llO;
	wire_w_lg_nl0O1i30w(0) <= NOT nl0O1i;
	wire_w_lg_nl0O1O27w(0) <= NOT nl0O1O;
	wire_w_lg_soft_reset108w(0) <= NOT soft_reset;
	wire_w_lg_w_dec_data_range210w283w(0) <= NOT wire_w_dec_data_range210w(0);
	wire_w_lg_w_dec_data_range158w267w(0) <= NOT wire_w_dec_data_range158w(0);
	wire_w_lg_w_dec_data_range202w291w(0) <= NOT wire_w_dec_data_range202w(0);
	wire_w_lg_w_dec_data_range218w275w(0) <= NOT wire_w_dec_data_range218w(0);
	wire_w_lg_w_lg_nl00lO110w113w(0) <= wire_w_lg_nl00lO110w(0) OR nllOO;
	wire_w_lg_w_lg_w_lg_nl0O1l67w68w69w(0) <= wire_w_lg_w_lg_nl0O1l67w68w(0) OR nl0l0l;
	wire_w_lg_w_lg_nl0l1O61w62w(0) <= wire_w_lg_nl0l1O61w(0) OR nl0ilO;
	wire_w_lg_w_lg_nl0O1l67w68w(0) <= wire_w_lg_nl0O1l67w(0) OR nl0liO;
	wire_w_lg_nl0l1O61w(0) <= nl0l1O OR nl0iOl;
	wire_w_lg_nl0O1l67w(0) <= nl0O1l OR nl0lOi;
	curr_state <= ( n0OO & n0Ol);
	nl000O <= (wire_w_lg_w_lg_nl00lO110w113w(0) OR (NOT (nl00ii28 XOR nl00ii27)));
	nl001i <= (nl0O0i OR nl001l);
	nl001l <= (nl0OlO OR nl0Oil);
	nl00li <= '1';
	nl00lO <= ((((dec_data_valid(0) AND dec_data_valid(1)) AND dec_data_valid(2)) AND dec_data_valid(3)) AND (nl00Oi22 XOR nl00Oi21));
	nl00OO <= (((NOT (wire_w_lg_w_lg_nl0l1O61w62w(0) OR ((NOT dec_ctl(3)) OR wire_w_lg_nl0ill63w(0)))) OR (NOT (wire_w_lg_w_lg_w_lg_nl0O1l67w68w69w(0) OR (NOT (nl0iiO16 XOR nl0iiO15))))) OR (NOT (((((NOT dec_ctl(0)) OR wire_w_lg_nl0iil76w(0)) OR (((NOT dec_ctl(1)) OR wire_w_lg_nl0iii78w(0)) OR (NOT (nl0i0l18 XOR nl0i0l17)))) OR (((NOT dec_ctl(2)) OR wire_w_lg_nl0i0i85w(0)) OR (NOT (nl0i1l20 XOR nl0i1l19)))) OR ((NOT dec_ctl(3)) OR wire_w_lg_nl0i1i92w(0)))));
	nl010i <= ((wire_ni_dataout OR nl0lOi) OR (NOT (nl010l42 XOR nl010l41)));
	nl011O <= (n101i OR nlliil);
	nl01ii <= (wire_nl_w_lg_dataout172w(0) OR (NOT (nl01il40 XOR nl01il39)));
	nl01lO <= (wire_nl_dataout OR nl0liO);
	nl01Oi <= ((wire_nO_dataout OR nl0l0l) OR (NOT (nl01Ol36 XOR nl01Ol35)));
	nl0i0i <= ((((((((NOT dec_data(16)) AND wire_w_lg_w_dec_data_range210w283w(0)) AND dec_data(18)) AND dec_data(19)) AND dec_data(20)) AND (NOT dec_data(21))) AND (NOT dec_data(22))) AND (NOT dec_data(23)));
	nl0i1i <= ((((((((NOT dec_data(24)) AND wire_w_lg_w_dec_data_range202w291w(0)) AND dec_data(26)) AND dec_data(27)) AND dec_data(28)) AND (NOT dec_data(29))) AND (NOT dec_data(30))) AND (NOT dec_data(31)));
	nl0iii <= ((((((((NOT dec_data(8)) AND wire_w_lg_w_dec_data_range218w275w(0)) AND dec_data(10)) AND dec_data(11)) AND dec_data(12)) AND (NOT dec_data(13))) AND (NOT dec_data(14))) AND (NOT dec_data(15)));
	nl0iil <= ((((((((NOT dec_data(0)) AND wire_w_lg_w_dec_data_range158w267w(0)) AND dec_data(2)) AND dec_data(3)) AND dec_data(4)) AND (NOT dec_data(5))) AND (NOT dec_data(6))) AND (NOT dec_data(7)));
	nl0ill <= ((((((((NOT dec_data(24)) AND wire_w_lg_w_dec_data_range202w291w(0)) AND dec_data(26)) AND dec_data(27)) AND dec_data(28)) AND dec_data(29)) AND dec_data(30)) AND (NOT dec_data(31)));
	nl0ilO <= ((NOT dec_ctl(2)) OR wire_w_lg_nl0iOi59w(0));
	nl0iOi <= ((((((((NOT dec_data(16)) AND wire_w_lg_w_dec_data_range210w283w(0)) AND dec_data(18)) AND dec_data(19)) AND dec_data(20)) AND dec_data(21)) AND dec_data(22)) AND (NOT dec_data(23)));
	nl0iOl <= (((NOT dec_ctl(1)) OR wire_w_lg_nl0l1l53w(0)) OR (NOT (nl0iOO14 XOR nl0iOO13)));
	nl0l0i <= ((((((((NOT dec_data(0)) AND wire_w_lg_w_dec_data_range158w267w(0)) AND dec_data(2)) AND dec_data(3)) AND dec_data(4)) AND dec_data(5)) AND dec_data(6)) AND (NOT dec_data(7)));
	nl0l0l <= (((NOT dec_ctl(3)) OR wire_w_lg_nl0lil45w(0)) OR (NOT (nl0l0O12 XOR nl0l0O11)));
	nl0l1l <= ((((((((NOT dec_data(8)) AND wire_w_lg_w_dec_data_range218w275w(0)) AND dec_data(10)) AND dec_data(11)) AND dec_data(12)) AND dec_data(13)) AND dec_data(14)) AND (NOT dec_data(15)));
	nl0l1O <= ((NOT dec_ctl(0)) OR wire_w_lg_nl0l0i51w(0));
	nl0lil <= ((((((((NOT dec_data(24)) AND wire_w_lg_w_dec_data_range202w291w(0)) AND dec_data(26)) AND dec_data(27)) AND dec_data(28)) AND dec_data(29)) AND (NOT dec_data(30))) AND dec_data(31));
	nl0liO <= (((NOT dec_ctl(2)) OR wire_w_lg_nl0llO37w(0)) OR (NOT (nl0lli10 XOR nl0lli9)));
	nl0llO <= ((((((((NOT dec_data(16)) AND wire_w_lg_w_dec_data_range210w283w(0)) AND dec_data(18)) AND dec_data(19)) AND dec_data(20)) AND dec_data(21)) AND (NOT dec_data(22))) AND dec_data(23));
	nl0lOi <= (((NOT dec_ctl(1)) OR wire_w_lg_nl0O1i30w(0)) OR (NOT (nl0lOl8 XOR nl0lOl7)));
	nl0O0i <= (wire_nl_w_lg_dataout19w(0) AND (wire_w_lg_w_dec_ctl_range20w21w(0) AND (nl0O0l6 XOR nl0O0l5)));
	nl0O1i <= ((((((((NOT dec_data(8)) AND wire_w_lg_w_dec_data_range218w275w(0)) AND dec_data(10)) AND dec_data(11)) AND dec_data(12)) AND dec_data(13)) AND (NOT dec_data(14))) AND dec_data(15));
	nl0O1l <= ((NOT dec_ctl(0)) OR wire_w_lg_nl0O1O27w(0));
	nl0O1O <= ((((((((NOT dec_data(0)) AND wire_w_lg_w_dec_data_range158w267w(0)) AND dec_data(2)) AND dec_data(3)) AND dec_data(4)) AND dec_data(5)) AND (NOT dec_data(6))) AND dec_data(7));
	nl0Oii <= ((((((wire_w_lg_w_dec_data_range211w284w(0) AND dec_data(18)) AND dec_data(19)) AND dec_data(20)) AND dec_data(21)) AND dec_data(22)) AND dec_data(23));
	nl0Oil <= (wire_ni_w_lg_dataout12w(0) AND (wire_w_lg_w_dec_ctl_range13w14w(0) AND (nl0OiO4 XOR nl0OiO3)));
	nl0Oll <= ((((((wire_w_lg_w_dec_data_range219w276w(0) AND dec_data(10)) AND dec_data(11)) AND dec_data(12)) AND dec_data(13)) AND dec_data(14)) AND dec_data(15));
	nl0OlO <= (wire_nlO_w_lg_dataout5w(0) AND (wire_w_lg_w_dec_ctl_range6w7w(0) AND (nl0OOi2 XOR nl0OOi1)));
	nl0OOO <= ((((((wire_w_lg_w_dec_data_range159w268w(0) AND dec_data(2)) AND dec_data(3)) AND dec_data(4)) AND dec_data(5)) AND dec_data(6)) AND dec_data(7));
	nl1Oil <= ((((((wire_w_lg_w_dec_data_range203w292w(0) AND dec_data(26)) AND dec_data(27)) AND dec_data(28)) AND dec_data(29)) AND dec_data(30)) AND dec_data(31));
	nl1OiO <= (n0OO AND n0Ol);
	nl1Oli <= (nl0O0i OR nl1Oll);
	nl1Oll <= (nl0Oil OR nl1OlO);
	nl1OlO <= (nl0OlO OR nl00OO);
	nl1OOi <= (wire_nlO_dataout OR (nl0O1l AND nl0l1O));
	nl1OOl <= ((n101i OR nlliii) OR nlliil);
	nl1OOO <= (wire_ni_w_lg_dataout184w(0) OR (NOT (nl011i44 XOR nl011i43)));
	nli11i <= (wire_nili_w_lg_n0OO264w(0) AND wire_nili_w_lg_n0Ol265w(0));
	rx_ctl_rs <= ( nl00l & niiil & n0lli & n01OO);
	rx_data_rs <= ( nl00i & nl01O & nl01l & nl01i & nl1OO & nl1Ol & nl1Oi & niiiO & niiii & nii0O & nii0l & nii0i & nii1O & nii1l & nii1i & n0lll & n0liO & n0lil & n0lii & n0l0O & n0l0l & n0l0i & n0l1O & n001i & n01Ol & n01Oi & n01lO & n01ll & n01li & n01iO & n01il & n10li);
	rx_local_fault <= niOi;
	xs_link_status <= ni0l;
	wire_w_dec_ctl_range6w(0) <= dec_ctl(0);
	wire_w_dec_ctl_range13w(0) <= dec_ctl(1);
	wire_w_dec_ctl_range20w(0) <= dec_ctl(2);
	wire_w_dec_ctl_range43w(0) <= dec_ctl(3);
	wire_w_dec_data_range159w(0) <= dec_data(0);
	wire_w_dec_data_range211w(0) <= dec_data(16);
	wire_w_dec_data_range210w(0) <= dec_data(17);
	wire_w_dec_data_range158w(0) <= dec_data(1);
	wire_w_dec_data_range203w(0) <= dec_data(24);
	wire_w_dec_data_range202w(0) <= dec_data(25);
	wire_w_dec_data_range219w(0) <= dec_data(8);
	wire_w_dec_data_range218w(0) <= dec_data(9);
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl000i31 <= nl000i32;
		END IF;
		if (now = 0 ns) then
			nl000i31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl000i32 <= nl000i31;
		END IF;
	END PROCESS;
	wire_nl000i32_w_lg_w_lg_q141w142w(0) <= wire_nl000i32_w_lg_q141w(0) AND n0OO;
	wire_nl000i32_w_lg_q141w(0) <= nl000i32 XOR nl000i31;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl000l29 <= nl000l30;
		END IF;
		if (now = 0 ns) then
			nl000l29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl000l30 <= nl000l29;
		END IF;
	END PROCESS;
	wire_nl000l30_w_lg_w_lg_q124w125w(0) <= wire_nl000l30_w_lg_q124w(0) AND nl000O;
	wire_nl000l30_w_lg_q124w(0) <= nl000l30 XOR nl000l29;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl001O33 <= nl001O34;
		END IF;
		if (now = 0 ns) then
			nl001O33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl001O34 <= nl001O33;
		END IF;
	END PROCESS;
	wire_nl001O34_w_lg_w_lg_q144w145w(0) <= wire_nl001O34_w_lg_q144w(0) AND wire_n0li_dataout;
	wire_nl001O34_w_lg_q144w(0) <= nl001O34 XOR nl001O33;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00ii27 <= nl00ii28;
		END IF;
		if (now = 0 ns) then
			nl00ii27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00ii28 <= nl00ii27;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00iO25 <= nl00iO26;
		END IF;
		if (now = 0 ns) then
			nl00iO25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00iO26 <= nl00iO25;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00ll23 <= nl00ll24;
		END IF;
		if (now = 0 ns) then
			nl00ll23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00ll24 <= nl00ll23;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00Oi21 <= nl00Oi22;
		END IF;
		if (now = 0 ns) then
			nl00Oi21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00Oi22 <= nl00Oi21;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl010l41 <= nl010l42;
		END IF;
		if (now = 0 ns) then
			nl010l41 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl010l42 <= nl010l41;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl011i43 <= nl011i44;
		END IF;
		if (now = 0 ns) then
			nl011i43 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl011i44 <= nl011i43;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01il39 <= nl01il40;
		END IF;
		if (now = 0 ns) then
			nl01il39 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01il40 <= nl01il39;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01li37 <= nl01li38;
		END IF;
		if (now = 0 ns) then
			nl01li37 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01li38 <= nl01li37;
		END IF;
	END PROCESS;
	wire_nl01li38_w_lg_q170w(0) <= nl01li38 XOR nl01li37;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01Ol35 <= nl01Ol36;
		END IF;
		if (now = 0 ns) then
			nl01Ol35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01Ol36 <= nl01Ol35;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0i0l17 <= nl0i0l18;
		END IF;
		if (now = 0 ns) then
			nl0i0l17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0i0l18 <= nl0i0l17;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0i1l19 <= nl0i1l20;
		END IF;
		if (now = 0 ns) then
			nl0i1l19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0i1l20 <= nl0i1l19;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0iiO15 <= nl0iiO16;
		END IF;
		if (now = 0 ns) then
			nl0iiO15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0iiO16 <= nl0iiO15;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0iOO13 <= nl0iOO14;
		END IF;
		if (now = 0 ns) then
			nl0iOO13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0iOO14 <= nl0iOO13;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0l0O11 <= nl0l0O12;
		END IF;
		if (now = 0 ns) then
			nl0l0O11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0l0O12 <= nl0l0O11;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0lli10 <= nl0lli9;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0lli9 <= nl0lli10;
		END IF;
		if (now = 0 ns) then
			nl0lli9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0lOl7 <= nl0lOl8;
		END IF;
		if (now = 0 ns) then
			nl0lOl7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0lOl8 <= nl0lOl7;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0O0l5 <= nl0O0l6;
		END IF;
		if (now = 0 ns) then
			nl0O0l5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0O0l6 <= nl0O0l5;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0OiO3 <= nl0OiO4;
		END IF;
		if (now = 0 ns) then
			nl0OiO3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0OiO4 <= nl0OiO3;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0OOi1 <= nl0OOi2;
		END IF;
		if (now = 0 ns) then
			nl0OOi1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0OOi2 <= nl0OOi1;
		END IF;
	END PROCESS;
	PROCESS (clk_2, wire_nili_PRN, soft_reset)
	BEGIN
		IF (wire_nili_PRN = '0') THEN
				n001i <= '1';
				n01il <= '1';
				n01lO <= '1';
				n01Oi <= '1';
				n0l0i <= '1';
				n0l0l <= '1';
				n0l0O <= '1';
				n0l1O <= '1';
				n0lii <= '1';
				n0lil <= '1';
				n0liO <= '1';
				n0lli <= '1';
				n0lll <= '1';
				n0Oi <= '1';
				n0Ol <= '1';
				n0OO <= '1';
				n100i <= '1';
				n100l <= '1';
				n100O <= '1';
				n101i <= '1';
				n101l <= '1';
				n101O <= '1';
				n10ii <= '1';
				n10il <= '1';
				n10iO <= '1';
				n10li <= '1';
				ni0i <= '1';
				ni0l <= '1';
				ni0O <= '1';
				ni1i <= '1';
				ni1l <= '1';
				ni1O <= '1';
				nii0i <= '1';
				nii0l <= '1';
				nii0O <= '1';
				nii1i <= '1';
				nii1l <= '1';
				nii1O <= '1';
				niiii <= '1';
				niiil <= '1';
				nill <= '1';
				nl00i <= '1';
				nl00l <= '1';
				nl01i <= '1';
				nl01l <= '1';
				nl01O <= '1';
				nl1Oi <= '1';
				nl1Ol <= '1';
				nl1OO <= '1';
				nllii <= '1';
				nlliii <= '1';
				nlliil <= '1';
				nlliiO <= '1';
				nllil <= '1';
				nllili <= '1';
				nllill <= '1';
				nllilO <= '1';
				nlliOi <= '1';
				nlliOl <= '1';
				nlliOO <= '1';
				nlll1i <= '1';
				nlll1l <= '1';
				nlll1O <= '1';
				nlllO <= '1';
				nllOi <= '1';
				nllOO <= '1';
				nlO0Oi <= '1';
				nlO0Ol <= '1';
				nlO0OO <= '1';
				nlOi0i <= '1';
				nlOi0l <= '1';
				nlOi1i <= '1';
				nlOi1l <= '1';
				nlOi1O <= '1';
		ELSIF (soft_reset = '1') THEN
				n001i <= '0';
				n01il <= '0';
				n01lO <= '0';
				n01Oi <= '0';
				n0l0i <= '0';
				n0l0l <= '0';
				n0l0O <= '0';
				n0l1O <= '0';
				n0lii <= '0';
				n0lil <= '0';
				n0liO <= '0';
				n0lli <= '0';
				n0lll <= '0';
				n0Oi <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				n100i <= '0';
				n100l <= '0';
				n100O <= '0';
				n101i <= '0';
				n101l <= '0';
				n101O <= '0';
				n10ii <= '0';
				n10il <= '0';
				n10iO <= '0';
				n10li <= '0';
				ni0i <= '0';
				ni0l <= '0';
				ni0O <= '0';
				ni1i <= '0';
				ni1l <= '0';
				ni1O <= '0';
				nii0i <= '0';
				nii0l <= '0';
				nii0O <= '0';
				nii1i <= '0';
				nii1l <= '0';
				nii1O <= '0';
				niiii <= '0';
				niiil <= '0';
				nill <= '0';
				nl00i <= '0';
				nl00l <= '0';
				nl01i <= '0';
				nl01l <= '0';
				nl01O <= '0';
				nl1Oi <= '0';
				nl1Ol <= '0';
				nl1OO <= '0';
				nllii <= '0';
				nlliii <= '0';
				nlliil <= '0';
				nlliiO <= '0';
				nllil <= '0';
				nllili <= '0';
				nllill <= '0';
				nllilO <= '0';
				nlliOi <= '0';
				nlliOl <= '0';
				nlliOO <= '0';
				nlll1i <= '0';
				nlll1l <= '0';
				nlll1O <= '0';
				nlllO <= '0';
				nllOi <= '0';
				nllOO <= '0';
				nlO0Oi <= '0';
				nlO0Ol <= '0';
				nlO0OO <= '0';
				nlOi0i <= '0';
				nlOi0l <= '0';
				nlOi1i <= '0';
				nlOi1l <= '0';
				nlOi1O <= '0';
		ELSIF (clk_2 = '1' AND clk_2'event) THEN
				n001i <= wire_n0llO_dataout;
				n01il <= wire_n001O_dataout;
				n01lO <= wire_n00ii_dataout;
				n01Oi <= wire_n00il_dataout;
				n0l0i <= wire_n0lOl_dataout;
				n0l0l <= wire_n0lOO_dataout;
				n0l0O <= wire_n0O1i_dataout;
				n0l1O <= wire_n0lOi_dataout;
				n0lii <= wire_n0O1l_dataout;
				n0lil <= wire_n0O1O_dataout;
				n0liO <= wire_n0O0i_dataout;
				n0lli <= wire_n0O0l_dataout;
				n0lll <= wire_niili_dataout;
				n0Oi <= indv;
				n0Ol <= wire_n0iO_w_lg_o112w(0);
				n0OO <= wire_n0ii_o;
				n100i <= wire_n10Ol_dataout;
				n100l <= wire_n10OO_dataout;
				n100O <= wire_n1i1i_dataout;
				n101i <= nl0O0i;
				n101l <= wire_n10lO_dataout;
				n101O <= wire_n10Oi_dataout;
				n10ii <= wire_n1i1l_dataout;
				n10il <= wire_n1i1O_dataout;
				n10iO <= wire_n1i0i_dataout;
				n10li <= wire_n001l_dataout;
				ni0i <= xs_link_status_set;
				ni0l <= wire_niii_dataout;
				ni0O <= nill;
				ni1i <= ni1l;
				ni1l <= tx_local_fault_det;
				ni1O <= ni0i;
				nii0i <= wire_niiOl_dataout;
				nii0l <= wire_niiOO_dataout;
				nii0O <= wire_nil1i_dataout;
				nii1i <= wire_niill_dataout;
				nii1l <= wire_niilO_dataout;
				nii1O <= wire_niiOi_dataout;
				niiii <= wire_nil1l_dataout;
				niiil <= wire_nil1O_dataout;
				nill <= rx_local_fault_clr;
				nl00i <= wire_nl0Ol_dataout;
				nl00l <= wire_nl0OO_dataout;
				nl01i <= wire_nl0ll_dataout;
				nl01l <= wire_nl0lO_dataout;
				nl01O <= wire_nl0Oi_dataout;
				nl1Oi <= wire_nl0il_dataout;
				nl1Ol <= wire_nl0iO_dataout;
				nl1OO <= wire_nl0li_dataout;
				nllii <= wire_nlO1l_dataout;
				nlliii <= nl0Oil;
				nlliil <= (wire_nO_w_lg_dataout220w(0) AND wire_w_lg_w_dec_ctl_range43w221w(0));
				nlliiO <= wire_nlll0i_dataout;
				nllil <= wire_nlO1O_dataout;
				nllili <= wire_nlll0l_dataout;
				nllill <= wire_nlll0O_dataout;
				nllilO <= wire_nlllii_dataout;
				nlliOi <= wire_nlllil_dataout;
				nlliOl <= wire_nllliO_dataout;
				nlliOO <= wire_nlllli_dataout;
				nlll1i <= wire_nlllll_dataout;
				nlll1l <= wire_nllllO_dataout;
				nlll1O <= wire_nlOiii_dataout;
				nlllO <= wire_nlOii_dataout;
				nllOi <= wire_nlOil_dataout;
				nllOO <= n0Oi;
				nlO0Oi <= wire_nlOiil_dataout;
				nlO0Ol <= wire_nlOiiO_dataout;
				nlO0OO <= wire_nlOili_dataout;
				nlOi0i <= wire_nlOiOl_dataout;
				nlOi0l <= wire_nlOiOO_dataout;
				nlOi1i <= wire_nlOill_dataout;
				nlOi1l <= wire_nlOilO_dataout;
				nlOi1O <= wire_nlOiOi_dataout;
		END IF;
	END PROCESS;
	wire_nili_PRN <= (nl00iO26 XOR nl00iO25);
	wire_nili_w_lg_n0Ol265w(0) <= NOT n0Ol;
	wire_nili_w_lg_n0OO264w(0) <= NOT n0OO;
	PROCESS (clk_2, soft_reset, wire_nilO_CLRN)
	BEGIN
		IF (soft_reset = '1') THEN
				n01iO <= '1';
				n01li <= '1';
				n01ll <= '1';
				n01Ol <= '1';
				n01OO <= '1';
				niiiO <= '1';
				niOi <= '1';
				nl00O <= '1';
				nlliO <= '1';
				nllli <= '1';
				nllll <= '1';
				nllOl <= '1';
				nlOi0O <= '1';
		ELSIF (wire_nilO_CLRN = '0') THEN
				n01iO <= '0';
				n01li <= '0';
				n01ll <= '0';
				n01Ol <= '0';
				n01OO <= '0';
				niiiO <= '0';
				niOi <= '0';
				nl00O <= '0';
				nlliO <= '0';
				nllli <= '0';
				nllll <= '0';
				nllOl <= '0';
				nlOi0O <= '0';
		ELSIF (clk_2 = '1' AND clk_2'event) THEN
				n01iO <= wire_n000i_dataout;
				n01li <= wire_n000l_dataout;
				n01ll <= wire_n000O_dataout;
				n01Ol <= wire_n00iO_dataout;
				n01OO <= wire_n00li_dataout;
				niiiO <= wire_nl0ii_dataout;
				niOi <= wire_niOl_dataout;
				nl00O <= wire_nlO1i_dataout;
				nlliO <= wire_nlO0i_dataout;
				nllli <= wire_nlO0l_dataout;
				nllll <= wire_nlO0O_dataout;
				nllOl <= wire_nlOiO_dataout;
				nlOi0O <= wire_n10ll_dataout;
		END IF;
	END PROCESS;
	wire_nilO_CLRN <= (nl00ll24 XOR nl00ll23);
	wire_n000i_dataout <= wire_n00Oi_dataout OR nli11i;
	wire_n000l_dataout <= wire_n00Ol_dataout OR nli11i;
	wire_n000O_dataout <= wire_n00OO_dataout OR nli11i;
	wire_n001l_dataout <= wire_n00ll_dataout AND NOT(nli11i);
	wire_n001O_dataout <= wire_n00lO_dataout AND NOT(nli11i);
	wire_n00i_dataout <= dec_data(6) OR wire_nlO_dataout;
	wire_n00ii_dataout <= wire_n0i1i_dataout AND NOT(nli11i);
	wire_n00il_dataout <= wire_n0i1l_dataout AND NOT(nli11i);
	wire_n00iO_dataout <= wire_n0i1O_dataout OR nli11i;
	wire_n00l_dataout <= dec_data(7) OR wire_nlO_dataout;
	wire_n00li_dataout <= wire_n0i0i_dataout OR nli11i;
	wire_n00ll_dataout <= wire_n0i0l_dataout WHEN nl1OOl = '1'  ELSE nllii;
	wire_n00lO_dataout <= wire_n0i0O_dataout WHEN nl1OOl = '1'  ELSE nllil;
	wire_n00O_dataout <= dec_ctl(0) OR wire_nlO_dataout;
	wire_n00Oi_dataout <= wire_n0iii_dataout WHEN nl1OOl = '1'  ELSE nlliO;
	wire_n00Ol_dataout <= wire_n0iil_dataout WHEN nl1OOl = '1'  ELSE nllli;
	wire_n00OO_dataout <= wire_n0iiO_dataout WHEN nl1OOl = '1'  ELSE nllll;
	wire_n010i_dataout <= wire_n1O1i_dataout OR nl1Oli;
	wire_n011i_dataout <= wire_n1lOi_dataout AND NOT(nl1Oli);
	wire_n011l_dataout <= wire_n1lOl_dataout AND NOT(nl1Oli);
	wire_n011O_dataout <= wire_n1lOO_dataout AND NOT(nl1Oli);
	wire_n01i_dataout <= dec_data(3) OR wire_nlO_dataout;
	wire_n01l_dataout <= dec_data(4) OR wire_nlO_dataout;
	wire_n01O_dataout <= dec_data(5) OR wire_nlO_dataout;
	wire_n0i0i_dataout <= wire_n0iOi_dataout WHEN nl1OOl = '1'  ELSE nl00O;
	wire_n0i0l_dataout <= nllii AND NOT(nl1OOi);
	wire_n0i0O_dataout <= nllil OR nl1OOi;
	wire_n0i1i_dataout <= wire_n0ili_dataout WHEN nl1OOl = '1'  ELSE nlllO;
	wire_n0i1l_dataout <= wire_n0ill_dataout WHEN nl1OOl = '1'  ELSE nllOi;
	wire_n0i1O_dataout <= wire_n0ilO_dataout WHEN nl1OOl = '1'  ELSE nllOl;
	wire_n0iii_dataout <= nlliO OR nl1OOi;
	wire_n0iil_dataout <= nllli OR nl1OOi;
	wire_n0iiO_dataout <= nllll OR nl1OOi;
	wire_n0ili_dataout <= nlllO OR nl1OOi;
	wire_n0ill_dataout <= nllOi OR nl1OOi;
	wire_n0ilO_dataout <= nllOl OR nl1OOi;
	wire_n0iOi_dataout <= nl00O OR nl1OOi;
	wire_n0li_dataout <= wire_w_lg_nl00OO118w(0) AND NOT(nl000O);
	wire_n0ll_dataout <= nl00OO AND NOT(nl000O);
	wire_n0llO_dataout <= wire_n0O0O_dataout AND NOT(nli11i);
	wire_n0lOi_dataout <= wire_n0Oii_dataout AND NOT(nli11i);
	wire_n0lOl_dataout <= wire_n0Oil_dataout AND NOT(nli11i);
	wire_n0lOO_dataout <= wire_n0OiO_dataout AND NOT(nli11i);
	wire_n0O0i_dataout <= wire_n0OOi_dataout AND NOT(nli11i);
	wire_n0O0l_dataout <= wire_n0OOl_dataout AND NOT(nli11i);
	wire_n0O0O_dataout <= wire_ni00O_dataout WHEN nl0OlO = '1'  ELSE wire_n0OOO_dataout;
	wire_n0O1i_dataout <= wire_n0Oli_dataout AND NOT(nli11i);
	wire_n0O1l_dataout <= wire_n0Oll_dataout AND NOT(nli11i);
	wire_n0O1O_dataout <= wire_n0OlO_dataout AND NOT(nli11i);
	wire_n0Oii_dataout <= wire_ni0ii_dataout WHEN nl0OlO = '1'  ELSE wire_ni11i_dataout;
	wire_n0Oil_dataout <= wire_ni0il_dataout WHEN nl0OlO = '1'  ELSE wire_ni11l_dataout;
	wire_n0OiO_dataout <= wire_ni0iO_dataout WHEN nl0OlO = '1'  ELSE wire_ni11O_dataout;
	wire_n0Oli_dataout <= wire_ni0li_dataout WHEN nl0OlO = '1'  ELSE wire_ni10i_dataout;
	wire_n0Oll_dataout <= wire_ni0ll_dataout WHEN nl0OlO = '1'  ELSE wire_ni10l_dataout;
	wire_n0OlO_dataout <= wire_ni0lO_dataout WHEN nl0OlO = '1'  ELSE wire_ni10O_dataout;
	wire_n0OOi_dataout <= wire_ni0Oi_dataout WHEN nl0OlO = '1'  ELSE wire_ni1ii_dataout;
	wire_n0OOl_dataout <= wire_ni0Ol_dataout WHEN nl0OlO = '1'  ELSE wire_ni1il_dataout;
	wire_n0OOO_dataout <= wire_ni1iO_dataout WHEN nl011O = '1'  ELSE nlliiO;
	wire_n10i_dataout <= dec_ctl(0) WHEN nl0OlO = '1'  ELSE wire_n00O_dataout;
	wire_n10l_dataout <= dec_data(0) WHEN nl0OlO = '1'  ELSE wire_n1Oi_dataout;
	wire_n10ll_dataout <= wire_n1O1l_dataout WHEN nl1OiO = '1'  ELSE wire_n1i0l_dataout;
	wire_n10lO_dataout <= wire_n1O1O_dataout WHEN nl1OiO = '1'  ELSE wire_n1i0O_dataout;
	wire_n10O_dataout <= dec_data(1) WHEN nl0OlO = '1'  ELSE wire_n1Ol_dataout;
	wire_n10Oi_dataout <= wire_n1O0i_dataout WHEN nl1OiO = '1'  ELSE wire_n1iii_dataout;
	wire_n10Ol_dataout <= wire_n1O0l_dataout WHEN nl1OiO = '1'  ELSE wire_n1iil_dataout;
	wire_n10OO_dataout <= wire_n1O0O_dataout WHEN nl1OiO = '1'  ELSE wire_n1iiO_dataout;
	wire_n110i_dataout <= wire_n11Oi_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n110l_dataout <= wire_n11Ol_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n110O_dataout <= wire_n11OO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n111i_dataout <= wire_n11li_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n111l_dataout <= wire_n11ll_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n111O_dataout <= wire_n11lO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n11i_dataout <= wire_n1li_dataout AND NOT(wire_n0il_o);
	wire_n11ii_dataout <= wire_nlOO0i_dataout OR nl1Oll;
	wire_n11il_dataout <= wire_nlOO0l_dataout OR nl1Oll;
	wire_n11iO_dataout <= wire_nlOO0O_dataout OR nl1Oll;
	wire_n11l_dataout <= wire_n1ll_dataout AND NOT(wire_n0il_o);
	wire_n11li_dataout <= wire_nlOOii_dataout AND NOT(nl1Oll);
	wire_n11ll_dataout <= wire_nlOOil_dataout AND NOT(nl1Oll);
	wire_n11lO_dataout <= wire_nlOOiO_dataout AND NOT(nl1Oll);
	wire_n11O_dataout <= wire_n1lO_dataout AND NOT(wire_n0il_o);
	wire_n11Oi_dataout <= wire_nlOOli_dataout AND NOT(nl1Oll);
	wire_n11Ol_dataout <= wire_nlOOll_dataout AND NOT(nl1Oll);
	wire_n11OO_dataout <= wire_nlOOlO_dataout OR nl1Oll;
	wire_n1i0i_dataout <= wire_n1Oli_dataout WHEN nl1OiO = '1'  ELSE wire_n1iOi_dataout;
	wire_n1i0l_dataout <= wire_n1iOl_dataout OR wire_w_lg_nl00lO110w(0);
	wire_n1i0O_dataout <= wire_n1iOO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1i1i_dataout <= wire_n1Oii_dataout WHEN nl1OiO = '1'  ELSE wire_n1ili_dataout;
	wire_n1i1l_dataout <= wire_n1Oil_dataout WHEN nl1OiO = '1'  ELSE wire_n1ill_dataout;
	wire_n1i1O_dataout <= wire_n1OiO_dataout WHEN nl1OiO = '1'  ELSE wire_n1ilO_dataout;
	wire_n1ii_dataout <= dec_data(2) WHEN nl0OlO = '1'  ELSE wire_n1OO_dataout;
	wire_n1iii_dataout <= wire_n1l1i_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1iil_dataout <= wire_n1l1l_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1iiO_dataout <= wire_n1l1O_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1il_dataout <= dec_data(3) WHEN nl0OlO = '1'  ELSE wire_n01i_dataout;
	wire_n1ili_dataout <= wire_n1l0i_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1ill_dataout <= wire_n1l0l_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1ilO_dataout <= wire_n1l0O_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1iO_dataout <= dec_data(4) WHEN nl0OlO = '1'  ELSE wire_n01l_dataout;
	wire_n1iOi_dataout <= wire_n1lii_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1iOl_dataout <= wire_n1lil_dataout OR nl00OO;
	wire_n1iOO_dataout <= wire_n1liO_dataout OR nl00OO;
	wire_n1l0i_dataout <= wire_n1lOi_dataout AND NOT(nl00OO);
	wire_n1l0l_dataout <= wire_n1lOl_dataout AND NOT(nl00OO);
	wire_n1l0O_dataout <= wire_n1lOO_dataout AND NOT(nl00OO);
	wire_n1l1i_dataout <= wire_n1lli_dataout OR nl00OO;
	wire_n1l1l_dataout <= wire_n1lll_dataout AND NOT(nl00OO);
	wire_n1l1O_dataout <= wire_n1llO_dataout AND NOT(nl00OO);
	wire_n1li_dataout <= dec_data(5) WHEN nl0OlO = '1'  ELSE wire_n01O_dataout;
	wire_n1lii_dataout <= wire_n1O1i_dataout OR nl00OO;
	wire_n1lil_dataout <= dec_data(24) AND NOT(wire_nO_dataout);
	wire_n1liO_dataout <= dec_data(25) OR wire_nO_dataout;
	wire_n1ll_dataout <= dec_data(6) WHEN nl0OlO = '1'  ELSE wire_n00i_dataout;
	wire_n1lli_dataout <= dec_data(26) OR wire_nO_dataout;
	wire_n1lll_dataout <= dec_data(27) OR wire_nO_dataout;
	wire_n1llO_dataout <= dec_data(28) OR wire_nO_dataout;
	wire_n1lO_dataout <= dec_data(7) WHEN nl0OlO = '1'  ELSE wire_n00l_dataout;
	wire_n1lOi_dataout <= dec_data(29) OR wire_nO_dataout;
	wire_n1lOl_dataout <= dec_data(30) OR wire_nO_dataout;
	wire_n1lOO_dataout <= dec_data(31) OR wire_nO_dataout;
	wire_n1O0i_dataout <= wire_n1OOi_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1O0l_dataout <= wire_n1OOl_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1O0O_dataout <= wire_n1OOO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1O1i_dataout <= dec_ctl(3) OR wire_nO_dataout;
	wire_n1O1l_dataout <= wire_n1Oll_dataout OR wire_w_lg_nl00lO110w(0);
	wire_n1O1O_dataout <= wire_n1OlO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1Oi_dataout <= dec_data(0) AND NOT(wire_nlO_dataout);
	wire_n1Oii_dataout <= wire_n011i_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1Oil_dataout <= wire_n011l_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1OiO_dataout <= wire_n011O_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1Ol_dataout <= dec_data(1) OR wire_nlO_dataout;
	wire_n1Oli_dataout <= wire_n010i_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_n1Oll_dataout <= wire_n1lil_dataout OR nl1Oli;
	wire_n1OlO_dataout <= wire_n1liO_dataout OR nl1Oli;
	wire_n1OO_dataout <= dec_data(2) OR wire_nlO_dataout;
	wire_n1OOi_dataout <= wire_n1lli_dataout OR nl1Oli;
	wire_n1OOl_dataout <= wire_n1lll_dataout AND NOT(nl1Oli);
	wire_n1OOO_dataout <= wire_n1llO_dataout AND NOT(nl1Oli);
	wire_ni_dataout <= running_disp(1) AND NOT(nli11i);
	wire_ni_w_lg_dataout12w(0) <= NOT wire_ni_dataout;
	wire_ni_w_lg_dataout184w(0) <= wire_ni_dataout OR wire_w_lg_nl0lOi183w(0);
	wire_ni00O_dataout <= nlliiO AND NOT(nl010i);
	wire_ni01i_dataout <= nlll1i OR nl1OOO;
	wire_ni01l_dataout <= nlll1l OR nl1OOO;
	wire_ni0ii_dataout <= nllili OR nl010i;
	wire_ni0il_dataout <= nllill OR nl010i;
	wire_ni0iO_dataout <= nllilO OR nl010i;
	wire_ni0li_dataout <= nlliOi OR nl010i;
	wire_ni0ll_dataout <= nlliOl OR nl010i;
	wire_ni0lO_dataout <= nlliOO OR nl010i;
	wire_ni0Oi_dataout <= nlll1i OR nl010i;
	wire_ni0Ol_dataout <= nlll1l OR nl010i;
	wire_ni10i_dataout <= wire_ni1Oi_dataout WHEN nl011O = '1'  ELSE nlliOi;
	wire_ni10l_dataout <= wire_ni1Ol_dataout WHEN nl011O = '1'  ELSE nlliOl;
	wire_ni10O_dataout <= wire_ni1OO_dataout WHEN nl011O = '1'  ELSE nlliOO;
	wire_ni11i_dataout <= wire_ni1li_dataout WHEN nl011O = '1'  ELSE nllili;
	wire_ni11l_dataout <= wire_ni1ll_dataout WHEN nl011O = '1'  ELSE nllill;
	wire_ni11O_dataout <= wire_ni1lO_dataout WHEN nl011O = '1'  ELSE nllilO;
	wire_ni1ii_dataout <= wire_ni01i_dataout WHEN nl011O = '1'  ELSE nlll1i;
	wire_ni1il_dataout <= wire_ni01l_dataout WHEN nl011O = '1'  ELSE nlll1l;
	wire_ni1iO_dataout <= nlliiO AND NOT(nl1OOO);
	wire_ni1li_dataout <= nllili OR nl1OOO;
	wire_ni1ll_dataout <= nllill OR nl1OOO;
	wire_ni1lO_dataout <= nllilO OR nl1OOO;
	wire_ni1Oi_dataout <= nlliOi OR nl1OOO;
	wire_ni1Ol_dataout <= nlliOl OR nl1OOO;
	wire_ni1OO_dataout <= nlliOO OR nl1OOO;
	wire_niii_dataout <= wire_niil_dataout OR ni1O;
	wire_niil_dataout <= ni0l AND NOT((wire_w_lg_nl00lO110w(0) OR ni1i));
	wire_niili_dataout <= wire_nil0i_dataout AND NOT(nli11i);
	wire_niill_dataout <= wire_nil0l_dataout AND NOT(nli11i);
	wire_niilO_dataout <= wire_nil0O_dataout AND NOT(nli11i);
	wire_niiOi_dataout <= wire_nilii_dataout AND NOT(nli11i);
	wire_niiOl_dataout <= wire_nilil_dataout AND NOT(nli11i);
	wire_niiOO_dataout <= wire_niliO_dataout AND NOT(nli11i);
	wire_nil0i_dataout <= wire_nl11O_dataout WHEN nl001l = '1'  ELSE wire_nilOi_dataout;
	wire_nil0l_dataout <= wire_nl10i_dataout WHEN nl001l = '1'  ELSE wire_nilOl_dataout;
	wire_nil0O_dataout <= wire_nl10l_dataout WHEN nl001l = '1'  ELSE wire_nilOO_dataout;
	wire_nil1i_dataout <= wire_nilli_dataout AND NOT(nli11i);
	wire_nil1l_dataout <= wire_nilll_dataout AND NOT(nli11i);
	wire_nil1O_dataout <= wire_nillO_dataout AND NOT(nli11i);
	wire_nilii_dataout <= wire_nl10O_dataout WHEN nl001l = '1'  ELSE wire_niO1i_dataout;
	wire_nilil_dataout <= wire_nl1ii_dataout WHEN nl001l = '1'  ELSE wire_niO1l_dataout;
	wire_niliO_dataout <= wire_nl1il_dataout WHEN nl001l = '1'  ELSE wire_niO1O_dataout;
	wire_nilli_dataout <= wire_nl1iO_dataout WHEN nl001l = '1'  ELSE wire_niO0i_dataout;
	wire_nilll_dataout <= wire_nl1li_dataout WHEN nl001l = '1'  ELSE wire_niO0l_dataout;
	wire_nillO_dataout <= wire_nl1ll_dataout WHEN nl001l = '1'  ELSE wire_niO0O_dataout;
	wire_nilOi_dataout <= wire_niOii_dataout WHEN nlliil = '1'  ELSE nlll1O;
	wire_nilOl_dataout <= wire_niOil_dataout WHEN nlliil = '1'  ELSE nlO0Oi;
	wire_nilOO_dataout <= wire_niOiO_dataout WHEN nlliil = '1'  ELSE nlO0Ol;
	wire_niO0i_dataout <= wire_niOOi_dataout WHEN nlliil = '1'  ELSE nlOi1O;
	wire_niO0l_dataout <= wire_niOOl_dataout WHEN nlliil = '1'  ELSE nlOi0i;
	wire_niO0O_dataout <= wire_niOOO_dataout WHEN nlliil = '1'  ELSE nlOi0l;
	wire_niO1i_dataout <= wire_niOli_dataout WHEN nlliil = '1'  ELSE nlO0OO;
	wire_niO1l_dataout <= wire_niOll_dataout WHEN nlliil = '1'  ELSE nlOi1i;
	wire_niO1O_dataout <= wire_niOlO_dataout WHEN nlliil = '1'  ELSE nlOi1l;
	wire_niOii_dataout <= nlll1O AND NOT(nl01ii);
	wire_niOil_dataout <= nlO0Oi OR nl01ii;
	wire_niOiO_dataout <= nlO0Ol OR nl01ii;
	wire_niOl_dataout <= wire_niOO_dataout AND NOT(ni0O);
	wire_niOli_dataout <= nlO0OO OR nl01ii;
	wire_niOll_dataout <= nlOi1i OR nl01ii;
	wire_niOlO_dataout <= nlOi1l OR nl01ii;
	wire_niOO_dataout <= niOi OR NOT(nl00lO);
	wire_niOOi_dataout <= nlOi1O OR nl01ii;
	wire_niOOl_dataout <= nlOi0i OR nl01ii;
	wire_niOOO_dataout <= nlOi0l OR nl01ii;
	wire_nl_dataout <= running_disp(2) AND NOT(nli11i);
	wire_nl_w_lg_dataout19w(0) <= NOT wire_nl_dataout;
	wire_nl_w_lg_dataout172w(0) <= wire_nl_dataout OR wire_w_lg_w_lg_nl0liO168w171w(0);
	wire_nl0ii_dataout <= wire_nli1i_dataout OR nli11i;
	wire_nl0il_dataout <= wire_nli1l_dataout AND NOT(nli11i);
	wire_nl0iO_dataout <= wire_nli1O_dataout AND NOT(nli11i);
	wire_nl0li_dataout <= wire_nli0i_dataout AND NOT(nli11i);
	wire_nl0ll_dataout <= wire_nli0l_dataout AND NOT(nli11i);
	wire_nl0lO_dataout <= wire_nli0O_dataout AND NOT(nli11i);
	wire_nl0Oi_dataout <= wire_nliii_dataout AND NOT(nli11i);
	wire_nl0Ol_dataout <= wire_nliil_dataout AND NOT(nli11i);
	wire_nl0OO_dataout <= wire_nliiO_dataout AND NOT(nli11i);
	wire_nl10i_dataout <= nlO0Oi OR nl01lO;
	wire_nl10l_dataout <= nlO0Ol OR nl01lO;
	wire_nl10O_dataout <= nlO0OO OR nl01lO;
	wire_nl11O_dataout <= nlll1O AND NOT(nl01lO);
	wire_nl1ii_dataout <= nlOi1i OR nl01lO;
	wire_nl1il_dataout <= nlOi1l OR nl01lO;
	wire_nl1iO_dataout <= nlOi1O OR nl01lO;
	wire_nl1li_dataout <= nlOi0i OR nl01lO;
	wire_nl1ll_dataout <= nlOi0l OR nl01lO;
	wire_nli0i_dataout <= wire_nliOi_dataout WHEN nl001i = '1'  ELSE n100i;
	wire_nli0l_dataout <= wire_nliOl_dataout WHEN nl001i = '1'  ELSE n100l;
	wire_nli0O_dataout <= wire_nliOO_dataout WHEN nl001i = '1'  ELSE n100O;
	wire_nli1i_dataout <= wire_nlili_dataout WHEN nl001i = '1'  ELSE nlOi0O;
	wire_nli1l_dataout <= wire_nlill_dataout WHEN nl001i = '1'  ELSE n101l;
	wire_nli1O_dataout <= wire_nlilO_dataout WHEN nl001i = '1'  ELSE n101O;
	wire_nliii_dataout <= wire_nll1i_dataout WHEN nl001i = '1'  ELSE n10ii;
	wire_nliil_dataout <= wire_nll1l_dataout WHEN nl001i = '1'  ELSE n10il;
	wire_nliiO_dataout <= wire_nll1O_dataout WHEN nl001i = '1'  ELSE n10iO;
	wire_nlili_dataout <= nlOi0O AND NOT(nl01Oi);
	wire_nlill_dataout <= n101l OR nl01Oi;
	wire_nlilO_dataout <= n101O OR nl01Oi;
	wire_nliOi_dataout <= n100i OR nl01Oi;
	wire_nliOl_dataout <= n100l OR nl01Oi;
	wire_nliOO_dataout <= n100O OR nl01Oi;
	wire_nll1i_dataout <= n10ii OR nl01Oi;
	wire_nll1l_dataout <= n10il OR nl01Oi;
	wire_nll1O_dataout <= n10iO OR nl01Oi;
	wire_nlll0i_dataout <= wire_nlO1li_dataout WHEN nl1OiO = '1'  ELSE wire_nlllOi_dataout;
	wire_nlll0l_dataout <= wire_nlO1ll_dataout WHEN nl1OiO = '1'  ELSE wire_nlllOl_dataout;
	wire_nlll0O_dataout <= wire_nlO1lO_dataout WHEN nl1OiO = '1'  ELSE wire_nlllOO_dataout;
	wire_nlllii_dataout <= wire_nlO1Oi_dataout WHEN nl1OiO = '1'  ELSE wire_nllO1i_dataout;
	wire_nlllil_dataout <= wire_nlO1Ol_dataout WHEN nl1OiO = '1'  ELSE wire_nllO1l_dataout;
	wire_nllliO_dataout <= wire_nlO1OO_dataout WHEN nl1OiO = '1'  ELSE wire_nllO1O_dataout;
	wire_nlllli_dataout <= wire_nlO01i_dataout WHEN nl1OiO = '1'  ELSE wire_nllO0i_dataout;
	wire_nlllll_dataout <= wire_nlO01l_dataout WHEN nl1OiO = '1'  ELSE wire_nllO0l_dataout;
	wire_nllllO_dataout <= wire_nlO01O_dataout WHEN nl1OiO = '1'  ELSE wire_nllO0O_dataout;
	wire_nlllOi_dataout <= wire_nllOii_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlllOl_dataout <= wire_nllOil_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlllOO_dataout <= wire_nllOiO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nllO0i_dataout <= wire_nllOOi_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nllO0l_dataout <= wire_nllOOl_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nllO0O_dataout <= wire_nllOOO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nllO1i_dataout <= wire_nllOli_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nllO1l_dataout <= wire_nllOll_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nllO1O_dataout <= wire_nllOlO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nllOii_dataout <= wire_nlO11i_dataout OR nl00OO;
	wire_nllOil_dataout <= wire_nlO11l_dataout OR nl00OO;
	wire_nllOiO_dataout <= wire_nlO11O_dataout OR nl00OO;
	wire_nllOli_dataout <= wire_nlO10i_dataout AND NOT(nl00OO);
	wire_nllOll_dataout <= wire_nlO10l_dataout AND NOT(nl00OO);
	wire_nllOlO_dataout <= wire_nlO10O_dataout AND NOT(nl00OO);
	wire_nllOOi_dataout <= wire_nlO1ii_dataout AND NOT(nl00OO);
	wire_nllOOl_dataout <= wire_nlO1il_dataout AND NOT(nl00OO);
	wire_nllOOO_dataout <= wire_nlO1iO_dataout OR nl00OO;
	wire_nlO_dataout <= running_disp(0) AND NOT(nli11i);
	wire_nlO_w_lg_dataout5w(0) <= NOT wire_nlO_dataout;
	wire_nlO00i_dataout <= wire_nlO11i_dataout OR nl1OlO;
	wire_nlO00l_dataout <= wire_nlO11l_dataout OR nl1OlO;
	wire_nlO00O_dataout <= wire_nlO11O_dataout OR nl1OlO;
	wire_nlO01i_dataout <= wire_nlO0li_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlO01l_dataout <= wire_nlO0ll_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlO01O_dataout <= wire_nlO0lO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlO0i_dataout <= wire_nlOOi_dataout OR wire_n0iO_o;
	wire_nlO0ii_dataout <= wire_nlO10i_dataout AND NOT(nl1OlO);
	wire_nlO0il_dataout <= wire_nlO10l_dataout AND NOT(nl1OlO);
	wire_nlO0iO_dataout <= wire_nlO10O_dataout AND NOT(nl1OlO);
	wire_nlO0l_dataout <= wire_nlOOl_dataout OR wire_n0iO_o;
	wire_nlO0li_dataout <= wire_nlO1ii_dataout AND NOT(nl1OlO);
	wire_nlO0ll_dataout <= wire_nlO1il_dataout AND NOT(nl1OlO);
	wire_nlO0lO_dataout <= wire_nlO1iO_dataout OR nl1OlO;
	wire_nlO0O_dataout <= wire_nlOOO_dataout OR wire_n0iO_o;
	wire_nlO10i_dataout <= dec_data(11) OR wire_ni_dataout;
	wire_nlO10l_dataout <= dec_data(12) OR wire_ni_dataout;
	wire_nlO10O_dataout <= dec_data(13) OR wire_ni_dataout;
	wire_nlO11i_dataout <= dec_data(8) AND NOT(wire_ni_dataout);
	wire_nlO11l_dataout <= dec_data(9) OR wire_ni_dataout;
	wire_nlO11O_dataout <= dec_data(10) OR wire_ni_dataout;
	wire_nlO1i_dataout <= wire_nlOli_dataout OR wire_n0iO_o;
	wire_nlO1ii_dataout <= dec_data(14) OR wire_ni_dataout;
	wire_nlO1il_dataout <= dec_data(15) OR wire_ni_dataout;
	wire_nlO1iO_dataout <= dec_ctl(1) OR wire_ni_dataout;
	wire_nlO1l_dataout <= wire_nlOll_dataout AND NOT(wire_n0iO_o);
	wire_nlO1li_dataout <= wire_nlO00i_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlO1ll_dataout <= wire_nlO00l_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlO1lO_dataout <= wire_nlO00O_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlO1O_dataout <= wire_nlOlO_dataout AND NOT(wire_n0iO_o);
	wire_nlO1Oi_dataout <= wire_nlO0ii_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlO1Ol_dataout <= wire_nlO0il_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlO1OO_dataout <= wire_nlO0iO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOii_dataout <= wire_n11i_dataout AND NOT(wire_n0iO_o);
	wire_nlOiii_dataout <= wire_nlOOOi_dataout WHEN nl1OiO = '1'  ELSE wire_nlOl1i_dataout;
	wire_nlOiil_dataout <= wire_nlOOOl_dataout WHEN nl1OiO = '1'  ELSE wire_nlOl1l_dataout;
	wire_nlOiiO_dataout <= wire_nlOOOO_dataout WHEN nl1OiO = '1'  ELSE wire_nlOl1O_dataout;
	wire_nlOil_dataout <= wire_n11l_dataout AND NOT(wire_n0iO_o);
	wire_nlOili_dataout <= wire_n111i_dataout WHEN nl1OiO = '1'  ELSE wire_nlOl0i_dataout;
	wire_nlOill_dataout <= wire_n111l_dataout WHEN nl1OiO = '1'  ELSE wire_nlOl0l_dataout;
	wire_nlOilO_dataout <= wire_n111O_dataout WHEN nl1OiO = '1'  ELSE wire_nlOl0O_dataout;
	wire_nlOiO_dataout <= wire_n11O_dataout OR wire_n0iO_o;
	wire_nlOiOi_dataout <= wire_n110i_dataout WHEN nl1OiO = '1'  ELSE wire_nlOlii_dataout;
	wire_nlOiOl_dataout <= wire_n110l_dataout WHEN nl1OiO = '1'  ELSE wire_nlOlil_dataout;
	wire_nlOiOO_dataout <= wire_n110O_dataout WHEN nl1OiO = '1'  ELSE wire_nlOliO_dataout;
	wire_nlOl0i_dataout <= wire_nlOlOi_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOl0l_dataout <= wire_nlOlOl_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOl0O_dataout <= wire_nlOlOO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOl1i_dataout <= wire_nlOlli_dataout OR wire_w_lg_nl00lO110w(0);
	wire_nlOl1l_dataout <= wire_nlOlll_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOl1O_dataout <= wire_nlOllO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOli_dataout <= wire_n10i_dataout OR wire_n0il_o;
	wire_nlOlii_dataout <= wire_nlOO1i_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOlil_dataout <= wire_nlOO1l_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOliO_dataout <= wire_nlOO1O_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOll_dataout <= wire_n10l_dataout OR wire_n0il_o;
	wire_nlOlli_dataout <= wire_nlOO0i_dataout OR nl00OO;
	wire_nlOlll_dataout <= wire_nlOO0l_dataout OR nl00OO;
	wire_nlOllO_dataout <= wire_nlOO0O_dataout OR nl00OO;
	wire_nlOlO_dataout <= wire_n10O_dataout OR wire_n0il_o;
	wire_nlOlOi_dataout <= wire_nlOOii_dataout AND NOT(nl00OO);
	wire_nlOlOl_dataout <= wire_nlOOil_dataout AND NOT(nl00OO);
	wire_nlOlOO_dataout <= wire_nlOOiO_dataout AND NOT(nl00OO);
	wire_nlOO0i_dataout <= dec_data(16) AND NOT(wire_nl_dataout);
	wire_nlOO0l_dataout <= dec_data(17) OR wire_nl_dataout;
	wire_nlOO0O_dataout <= dec_data(18) OR wire_nl_dataout;
	wire_nlOO1i_dataout <= wire_nlOOli_dataout AND NOT(nl00OO);
	wire_nlOO1l_dataout <= wire_nlOOll_dataout AND NOT(nl00OO);
	wire_nlOO1O_dataout <= wire_nlOOlO_dataout OR nl00OO;
	wire_nlOOi_dataout <= wire_n1ii_dataout OR wire_n0il_o;
	wire_nlOOii_dataout <= dec_data(19) OR wire_nl_dataout;
	wire_nlOOil_dataout <= dec_data(20) OR wire_nl_dataout;
	wire_nlOOiO_dataout <= dec_data(21) OR wire_nl_dataout;
	wire_nlOOl_dataout <= wire_n1il_dataout AND NOT(wire_n0il_o);
	wire_nlOOli_dataout <= dec_data(22) OR wire_nl_dataout;
	wire_nlOOll_dataout <= dec_data(23) OR wire_nl_dataout;
	wire_nlOOlO_dataout <= dec_ctl(2) OR wire_nl_dataout;
	wire_nlOOO_dataout <= wire_n1iO_dataout AND NOT(wire_n0il_o);
	wire_nlOOOi_dataout <= wire_n11ii_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOOOl_dataout <= wire_n11il_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nlOOOO_dataout <= wire_n11iO_dataout AND NOT(wire_w_lg_nl00lO110w(0));
	wire_nO_dataout <= running_disp(3) AND NOT(nli11i);
	wire_nO_w_lg_dataout220w(0) <= NOT wire_nO_dataout;
	wire_n0ii_data <= ( wire_n0li_dataout & "0" & wire_n0li_dataout & wire_nl001O34_w_lg_w_lg_q144w145w);
	wire_n0ii_sel <= ( wire_nl000i32_w_lg_w_lg_q141w142w & n0Ol);
	n0ii :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n0ii_data,
		o => wire_n0ii_o,
		sel => wire_n0ii_sel
	  );
	wire_n0il_data <= ( wire_n0ll_dataout & "0" & wire_n0ll_dataout & wire_n0ll_dataout);
	wire_n0il_sel <= ( n0OO & n0Ol);
	n0il :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n0il_data,
		o => wire_n0il_o,
		sel => wire_n0il_sel
	  );
	wire_n0iO_w_lg_o112w(0) <= NOT wire_n0iO_o;
	wire_n0iO_data <= ( nl000O & "1" & wire_nl000l30_w_lg_w_lg_q124w125w & nl000O);
	wire_n0iO_sel <= ( n0OO & n0Ol);
	n0iO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n0iO_data,
		o => wire_n0iO_o,
		sel => wire_n0iO_sel
	  );

 END RTL; --stratixiigx_hssi_rcv_sm
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 33 mux21 32 oper_add 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_mdio_addr IS 
	 PORT 
	 ( 
		 incr_addr	:	IN  STD_LOGIC;
		 mdc	:	IN  STD_LOGIC;
		 mdio_in	:	IN  STD_LOGIC;
		 reg_addr	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 reset	:	IN  STD_LOGIC;
		 shift_addr	:	IN  STD_LOGIC
	 ); 
 END stratixiigx_hssi_mdio_addr;

 ARCHITECTURE RTL OF stratixiigx_hssi_mdio_addr IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nlO0i15	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0i16	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0l13	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0l14	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0O11	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0O12	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlO0O12_w_lg_w_lg_q45w46w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0O12_w_lg_q45w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOii10	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlOii10_w_lg_w_lg_q37w38w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOii10_w_lg_q37w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOii9	:	STD_LOGIC := '0';
	 SIGNAL	 nlOil7	:	STD_LOGIC := '0';
	 SIGNAL	 nlOil8	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlOil8_w_lg_w_lg_q33w34w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOil8_w_lg_q33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOiO5	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiO6	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlOiO6_w_lg_w_lg_q30w31w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOiO6_w_lg_q30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOli3	:	STD_LOGIC := '0';
	 SIGNAL	 nlOli4	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlOli4_w_lg_w_lg_q25w26w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOli4_w_lg_q25w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOOi1	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOi2	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0li	:	STD_LOGIC := '0';
	 SIGNAL	n0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0lO	:	STD_LOGIC := '0';
	 SIGNAL	n0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0l	:	STD_LOGIC := '0';
	 SIGNAL	ni0O	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	ni1O	:	STD_LOGIC := '0';
	 SIGNAL	niii	:	STD_LOGIC := '0';
	 SIGNAL	niil	:	STD_LOGIC := '0';
	 SIGNAL	nili	:	STD_LOGIC := '0';
	 SIGNAL	wire_niiO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_niiO_PRN	:	STD_LOGIC;
	 SIGNAL  wire_niiO_w_lg_w14w15w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w13w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w7w8w9w10w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w7w8w9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w7w8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_w_lg_niil1w2w3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_niil1w2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_niil1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni_a	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_ni_b	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_ni_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOlO19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset98w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nlO1O :	STD_LOGIC;
	 SIGNAL  nlOll :	STD_LOGIC;
	 SIGNAL  nlOlO :	STD_LOGIC;
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_nlOlO19w(0) <= NOT nlOlO;
	wire_w_lg_reset98w(0) <= NOT reset;
	nlO1O <= '1';
	nlOll <= (wire_w_lg_nlOlO19w(0) AND incr_addr);
	nlOlO <= (wire_niiO_w_lg_w14w15w(0) AND (nlOOi2 XOR nlOOi1));
	reg_addr <= ( niil & niii & ni0O & ni0l & ni0i & ni1O & ni1l & ni1i & n0OO & n0Ol & n0Oi & n0lO & n0ll & n0li & n0iO & n0il);
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0i15 <= nlO0i16;
		END IF;
		if (now = 0 ns) then
			nlO0i15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0i16 <= nlO0i15;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0l13 <= nlO0l14;
		END IF;
		if (now = 0 ns) then
			nlO0l13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0l14 <= nlO0l13;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0O11 <= nlO0O12;
		END IF;
		if (now = 0 ns) then
			nlO0O11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0O12 <= nlO0O11;
		END IF;
	END PROCESS;
	wire_nlO0O12_w_lg_w_lg_q45w46w(0) <= wire_nlO0O12_w_lg_q45w(0) AND niil;
	wire_nlO0O12_w_lg_q45w(0) <= nlO0O12 XOR nlO0O11;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOii10 <= nlOii9;
		END IF;
	END PROCESS;
	wire_nlOii10_w_lg_w_lg_q37w38w(0) <= wire_nlOii10_w_lg_q37w(0) AND ni1l;
	wire_nlOii10_w_lg_q37w(0) <= nlOii10 XOR nlOii9;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOii9 <= nlOii10;
		END IF;
		if (now = 0 ns) then
			nlOii9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOil7 <= nlOil8;
		END IF;
		if (now = 0 ns) then
			nlOil7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOil8 <= nlOil7;
		END IF;
	END PROCESS;
	wire_nlOil8_w_lg_w_lg_q33w34w(0) <= wire_nlOil8_w_lg_q33w(0) AND n0OO;
	wire_nlOil8_w_lg_q33w(0) <= nlOil8 XOR nlOil7;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOiO5 <= nlOiO6;
		END IF;
		if (now = 0 ns) then
			nlOiO5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOiO6 <= nlOiO5;
		END IF;
	END PROCESS;
	wire_nlOiO6_w_lg_w_lg_q30w31w(0) <= wire_nlOiO6_w_lg_q30w(0) AND n0Ol;
	wire_nlOiO6_w_lg_q30w(0) <= nlOiO6 XOR nlOiO5;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOli3 <= nlOli4;
		END IF;
		if (now = 0 ns) then
			nlOli3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOli4 <= nlOli3;
		END IF;
	END PROCESS;
	wire_nlOli4_w_lg_w_lg_q25w26w(0) <= wire_nlOli4_w_lg_q25w(0) AND n0ll;
	wire_nlOli4_w_lg_q25w(0) <= nlOli4 XOR nlOli3;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOOi1 <= nlOOi2;
		END IF;
		if (now = 0 ns) then
			nlOOi1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOOi2 <= nlOOi1;
		END IF;
	END PROCESS;
	PROCESS (mdc, wire_niiO_PRN, wire_niiO_CLRN)
	BEGIN
		IF (wire_niiO_PRN = '0') THEN
				n0il <= '1';
				n0iO <= '1';
				n0li <= '1';
				n0ll <= '1';
				n0lO <= '1';
				n0Oi <= '1';
				n0Ol <= '1';
				n0OO <= '1';
				ni0i <= '1';
				ni0l <= '1';
				ni0O <= '1';
				ni1i <= '1';
				ni1l <= '1';
				ni1O <= '1';
				niii <= '1';
				niil <= '1';
				nili <= '1';
		ELSIF (wire_niiO_CLRN = '0') THEN
				n0il <= '0';
				n0iO <= '0';
				n0li <= '0';
				n0ll <= '0';
				n0lO <= '0';
				n0Oi <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				ni0i <= '0';
				ni0l <= '0';
				ni0O <= '0';
				ni1i <= '0';
				ni1l <= '0';
				ni1O <= '0';
				niii <= '0';
				niil <= '0';
				nili <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
				n0il <= wire_nill_dataout;
				n0iO <= wire_nilO_dataout;
				n0li <= wire_niOi_dataout;
				n0ll <= wire_niOl_dataout;
				n0lO <= wire_niOO_dataout;
				n0Oi <= wire_nl1i_dataout;
				n0Ol <= wire_nl1l_dataout;
				n0OO <= wire_nl1O_dataout;
				ni0i <= wire_nlii_dataout;
				ni0l <= wire_nlil_dataout;
				ni0O <= wire_nliO_dataout;
				ni1i <= wire_nl0i_dataout;
				ni1l <= wire_nl0l_dataout;
				ni1O <= wire_nl0O_dataout;
				niii <= wire_nlli_dataout;
				niil <= wire_nlll_dataout;
				nili <= mdio_in;
		END IF;
	END PROCESS;
	wire_niiO_CLRN <= ((nlO0l14 XOR nlO0l13) AND wire_w_lg_reset98w(0));
	wire_niiO_PRN <= (nlO0i16 XOR nlO0i15);
	wire_niiO_w_lg_w14w15w(0) <= wire_niiO_w14w(0) AND n0il;
	wire_niiO_w14w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w13w(0) AND n0iO;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w13w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w(0) AND n0li;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w12w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w(0) AND n0ll;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_w7w8w9w10w11w(0) <= wire_niiO_w_lg_w_lg_w_lg_w7w8w9w10w(0) AND n0lO;
	wire_niiO_w_lg_w_lg_w_lg_w7w8w9w10w(0) <= wire_niiO_w_lg_w_lg_w7w8w9w(0) AND n0Oi;
	wire_niiO_w_lg_w_lg_w7w8w9w(0) <= wire_niiO_w_lg_w7w8w(0) AND n0Ol;
	wire_niiO_w_lg_w7w8w(0) <= wire_niiO_w7w(0) AND n0OO;
	wire_niiO_w7w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w6w(0) AND ni1i;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w6w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w(0) AND ni1l;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w5w(0) <= wire_niiO_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w(0) AND ni1O;
	wire_niiO_w_lg_w_lg_w_lg_w_lg_niil1w2w3w4w(0) <= wire_niiO_w_lg_w_lg_w_lg_niil1w2w3w(0) AND ni0i;
	wire_niiO_w_lg_w_lg_w_lg_niil1w2w3w(0) <= wire_niiO_w_lg_w_lg_niil1w2w(0) AND ni0l;
	wire_niiO_w_lg_w_lg_niil1w2w(0) <= wire_niiO_w_lg_niil1w(0) AND ni0O;
	wire_niiO_w_lg_niil1w(0) <= niil AND niii;
	wire_n0i_dataout <= wire_ni_o(7) WHEN nlOll = '1'  ELSE n0OO;
	wire_n0l_dataout <= wire_ni_o(8) WHEN nlOll = '1'  ELSE ni1i;
	wire_n0O_dataout <= wire_ni_o(9) WHEN nlOll = '1'  ELSE ni1l;
	wire_n1i_dataout <= wire_ni_o(4) WHEN nlOll = '1'  ELSE n0lO;
	wire_n1l_dataout <= wire_ni_o(5) WHEN nlOll = '1'  ELSE n0Oi;
	wire_n1O_dataout <= wire_ni_o(6) WHEN nlOll = '1'  ELSE n0Ol;
	wire_nii_dataout <= wire_ni_o(10) WHEN nlOll = '1'  ELSE ni1O;
	wire_nil_dataout <= wire_ni_o(11) WHEN nlOll = '1'  ELSE ni0i;
	wire_nill_dataout <= nili WHEN shift_addr = '1'  ELSE wire_nllO_dataout;
	wire_nilO_dataout <= n0il WHEN shift_addr = '1'  ELSE wire_nlOi_dataout;
	wire_niO_dataout <= wire_ni_o(12) WHEN nlOll = '1'  ELSE ni0l;
	wire_niOi_dataout <= n0iO WHEN shift_addr = '1'  ELSE wire_nlOl_dataout;
	wire_niOl_dataout <= n0li WHEN shift_addr = '1'  ELSE wire_nlOO_dataout;
	wire_niOO_dataout <= n0ll WHEN shift_addr = '1'  ELSE wire_n1i_dataout;
	wire_nl0i_dataout <= n0OO WHEN shift_addr = '1'  ELSE wire_n0l_dataout;
	wire_nl0l_dataout <= ni1i WHEN shift_addr = '1'  ELSE wire_n0O_dataout;
	wire_nl0O_dataout <= ni1l WHEN shift_addr = '1'  ELSE wire_nii_dataout;
	wire_nl1i_dataout <= n0lO WHEN shift_addr = '1'  ELSE wire_n1l_dataout;
	wire_nl1l_dataout <= n0Oi WHEN shift_addr = '1'  ELSE wire_n1O_dataout;
	wire_nl1O_dataout <= n0Ol WHEN shift_addr = '1'  ELSE wire_n0i_dataout;
	wire_nli_dataout <= wire_ni_o(13) WHEN nlOll = '1'  ELSE ni0O;
	wire_nlii_dataout <= ni1O WHEN shift_addr = '1'  ELSE wire_nil_dataout;
	wire_nlil_dataout <= ni0i WHEN shift_addr = '1'  ELSE wire_niO_dataout;
	wire_nliO_dataout <= ni0l WHEN shift_addr = '1'  ELSE wire_nli_dataout;
	wire_nll_dataout <= wire_ni_o(14) WHEN nlOll = '1'  ELSE niii;
	wire_nlli_dataout <= ni0O WHEN shift_addr = '1'  ELSE wire_nll_dataout;
	wire_nlll_dataout <= niii WHEN shift_addr = '1'  ELSE wire_nlO_dataout;
	wire_nllO_dataout <= wire_ni_o(0) WHEN nlOll = '1'  ELSE n0il;
	wire_nlO_dataout <= wire_ni_o(15) WHEN nlOll = '1'  ELSE niil;
	wire_nlOi_dataout <= wire_ni_o(1) WHEN nlOll = '1'  ELSE n0iO;
	wire_nlOl_dataout <= wire_ni_o(2) WHEN nlOll = '1'  ELSE n0li;
	wire_nlOO_dataout <= wire_ni_o(3) WHEN nlOll = '1'  ELSE n0ll;
	wire_ni_a <= ( wire_nlO0O12_w_lg_w_lg_q45w46w & niii & ni0O & ni0l & ni0i & ni1O & wire_nlOii10_w_lg_w_lg_q37w38w & ni1i & wire_nlOil8_w_lg_w_lg_q33w34w & wire_nlOiO6_w_lg_w_lg_q30w31w & n0Oi & n0lO & wire_nlOli4_w_lg_w_lg_q25w26w & n0li & n0iO & n0il);
	wire_ni_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	ni :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 16,
		width_b => 16,
		width_o => 16
	  )
	  PORT MAP ( 
		a => wire_ni_a,
		b => wire_ni_b,
		cin => wire_gnd,
		o => wire_ni_o
	  );

 END RTL; --stratixiigx_hssi_mdio_addr
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 17 mux21 10 oper_add 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_mdio_cnt IS 
	 PORT 
	 ( 
		 cnt_eq_0	:	OUT  STD_LOGIC;
		 cnt_val	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 ld_cnt	:	IN  STD_LOGIC;
		 mdc	:	IN  STD_LOGIC;
		 reset	:	IN  STD_LOGIC
	 ); 
 END stratixiigx_hssi_mdio_cnt;

 ARCHITECTURE RTL OF stratixiigx_hssi_mdio_cnt IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 ni0O10	:	STD_LOGIC := '0';
	 SIGNAL	 ni0O9	:	STD_LOGIC := '0';
	 SIGNAL	 ni1O11	:	STD_LOGIC := '0';
	 SIGNAL	 ni1O12	:	STD_LOGIC := '0';
	 SIGNAL	 niiO7	:	STD_LOGIC := '0';
	 SIGNAL	 niiO8	:	STD_LOGIC := '0';
	 SIGNAL	 nili5	:	STD_LOGIC := '0';
	 SIGNAL	 nili6	:	STD_LOGIC := '0';
	 SIGNAL	 nill3	:	STD_LOGIC := '0';
	 SIGNAL	 nill4	:	STD_LOGIC := '0';
	 SIGNAL  wire_nill4_w_lg_w_lg_q16w17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nill4_w_lg_q16w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niOi1	:	STD_LOGIC := '0';
	 SIGNAL	 niOi2	:	STD_LOGIC := '0';
	 SIGNAL	n1i	:	STD_LOGIC := '0';
	 SIGNAL	ni	:	STD_LOGIC := '0';
	 SIGNAL	nlOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nlO_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nlO_w_lg_w_lg_w_lg_w_lg_ni1w2w3w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO_w_lg_w_lg_w_lg_ni1w2w3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO_w_lg_w_lg_ni1w2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO_w_lg_ni1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl_a	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nl_b	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_nl_o	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_w_lg_ld_cnt51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l50w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  ni0l :	STD_LOGIC;
	 SIGNAL  niil :	STD_LOGIC;
	 SIGNAL  nilO :	STD_LOGIC;
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_ld_cnt51w(0) <= NOT ld_cnt;
	wire_w_lg_ni0l50w(0) <= NOT ni0l;
	wire_w_lg_reset33w(0) <= NOT reset;
	cnt_eq_0 <= ((wire_w_lg_ni0l50w(0) AND wire_w_lg_ld_cnt51w(0)) AND (ni1O12 XOR ni1O11));
	ni0l <= (wire_nlO_w_lg_w_lg_w_lg_w_lg_ni1w2w3w4w(0) OR (NOT (ni0O10 XOR ni0O9)));
	niil <= '1';
	nilO <= (wire_nlO_w_lg_w_lg_w_lg_w_lg_ni1w2w3w4w(0) OR (NOT (niOi2 XOR niOi1)));
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN ni0O10 <= ni0O9;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN ni0O9 <= ni0O10;
		END IF;
		if (now = 0 ns) then
			ni0O9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN ni1O11 <= ni1O12;
		END IF;
		if (now = 0 ns) then
			ni1O11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN ni1O12 <= ni1O11;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niiO7 <= niiO8;
		END IF;
		if (now = 0 ns) then
			niiO7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niiO8 <= niiO7;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nili5 <= nili6;
		END IF;
		if (now = 0 ns) then
			nili5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nili6 <= nili5;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nill3 <= nill4;
		END IF;
		if (now = 0 ns) then
			nill3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nill4 <= nill3;
		END IF;
	END PROCESS;
	wire_nill4_w_lg_w_lg_q16w17w(0) <= wire_nill4_w_lg_q16w(0) AND n1i;
	wire_nill4_w_lg_q16w(0) <= nill4 XOR nill3;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOi1 <= niOi2;
		END IF;
		if (now = 0 ns) then
			niOi1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOi2 <= niOi1;
		END IF;
	END PROCESS;
	PROCESS (mdc, wire_nlO_PRN, wire_nlO_CLRN)
	BEGIN
		IF (wire_nlO_PRN = '0') THEN
				n1i <= '1';
				ni <= '1';
				nlOi <= '1';
				nlOl <= '1';
				nlOO <= '1';
		ELSIF (wire_nlO_CLRN = '0') THEN
				n1i <= '0';
				ni <= '0';
				nlOi <= '0';
				nlOl <= '0';
				nlOO <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
				n1i <= wire_n0O_dataout;
				ni <= wire_n1l_dataout;
				nlOi <= wire_n1O_dataout;
				nlOl <= wire_n0i_dataout;
				nlOO <= wire_n0l_dataout;
		END IF;
	END PROCESS;
	wire_nlO_CLRN <= ((nili6 XOR nili5) AND wire_w_lg_reset33w(0));
	wire_nlO_PRN <= (niiO8 XOR niiO7);
	wire_nlO_w_lg_w_lg_w_lg_w_lg_ni1w2w3w4w(0) <= wire_nlO_w_lg_w_lg_w_lg_ni1w2w3w(0) OR nlOi;
	wire_nlO_w_lg_w_lg_w_lg_ni1w2w3w(0) <= wire_nlO_w_lg_w_lg_ni1w2w(0) OR nlOl;
	wire_nlO_w_lg_w_lg_ni1w2w(0) <= wire_nlO_w_lg_ni1w(0) OR nlOO;
	wire_nlO_w_lg_ni1w(0) <= ni OR n1i;
	wire_n0i_dataout <= cnt_val(2) WHEN ld_cnt = '1'  ELSE wire_niO_dataout;
	wire_n0l_dataout <= cnt_val(3) WHEN ld_cnt = '1'  ELSE wire_nli_dataout;
	wire_n0O_dataout <= cnt_val(4) WHEN ld_cnt = '1'  ELSE wire_nll_dataout;
	wire_n1l_dataout <= cnt_val(0) WHEN ld_cnt = '1'  ELSE wire_nii_dataout;
	wire_n1O_dataout <= cnt_val(1) WHEN ld_cnt = '1'  ELSE wire_nil_dataout;
	wire_nii_dataout <= wire_nl_o(1) WHEN nilO = '1'  ELSE ni;
	wire_nil_dataout <= wire_nl_o(2) WHEN nilO = '1'  ELSE nlOi;
	wire_niO_dataout <= wire_nl_o(3) WHEN nilO = '1'  ELSE nlOl;
	wire_nli_dataout <= wire_nl_o(4) WHEN nilO = '1'  ELSE nlOO;
	wire_nll_dataout <= wire_nl_o(5) WHEN nilO = '1'  ELSE n1i;
	wire_nl_a <= ( wire_nill4_w_lg_w_lg_q16w17w & nlOO & nlOl & nlOi & ni & "1");
	wire_nl_b <= ( "1" & "1" & "1" & "1" & "0" & "1");
	nl :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 6,
		width_b => 6,
		width_o => 6
	  )
	  PORT MAP ( 
		a => wire_nl_a,
		b => wire_nl_b,
		cin => wire_gnd,
		o => wire_nl_o
	  );

 END RTL; --stratixiigx_hssi_mdio_cnt
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

--synthesis_resources = lut 47 mux21 36 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_mdio_ctl_data IS 
	 PORT 
	 ( 
		 data_enable_n	:	OUT  STD_LOGIC;
		 dev_addr	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 latch_ctl	:	IN  STD_LOGIC;
		 ld_data	:	IN  STD_LOGIC;
		 mbus_in	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 mbus_out	:	IN  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 mdc	:	IN  STD_LOGIC;
		 mdio_in	:	IN  STD_LOGIC;
		 mdio_out	:	OUT  STD_LOGIC;
		 opcode	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 port_addr	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 reset	:	IN  STD_LOGIC;
		 shift_in	:	IN  STD_LOGIC;
		 shift_out	:	IN  STD_LOGIC;
		 valid_addr	:	OUT  STD_LOGIC;
		 valid_addr_lt	:	IN  STD_LOGIC
	 ); 
 END stratixiigx_hssi_mdio_ctl_data;

 ARCHITECTURE RTL OF stratixiigx_hssi_mdio_ctl_data IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nilll25	:	STD_LOGIC := '0';
	 SIGNAL	 nilll26	:	STD_LOGIC := '0';
	 SIGNAL	 nilOi23	:	STD_LOGIC := '0';
	 SIGNAL	 nilOi24	:	STD_LOGIC := '0';
	 SIGNAL	 nilOO21	:	STD_LOGIC := '0';
	 SIGNAL	 nilOO22	:	STD_LOGIC := '0';
	 SIGNAL	 niO0i17	:	STD_LOGIC := '0';
	 SIGNAL	 niO0i18	:	STD_LOGIC := '0';
	 SIGNAL	 niO0O15	:	STD_LOGIC := '0';
	 SIGNAL	 niO0O16	:	STD_LOGIC := '0';
	 SIGNAL	 niO1l19	:	STD_LOGIC := '0';
	 SIGNAL	 niO1l20	:	STD_LOGIC := '0';
	 SIGNAL	 niOil13	:	STD_LOGIC := '0';
	 SIGNAL	 niOil14	:	STD_LOGIC := '0';
	 SIGNAL	 niOiO11	:	STD_LOGIC := '0';
	 SIGNAL	 niOiO12	:	STD_LOGIC := '0';
	 SIGNAL	 niOlO10	:	STD_LOGIC := '0';
	 SIGNAL	 niOlO9	:	STD_LOGIC := '0';
	 SIGNAL	 niOOl7	:	STD_LOGIC := '0';
	 SIGNAL	 niOOl8	:	STD_LOGIC := '0';
	 SIGNAL	 nl10l3	:	STD_LOGIC := '0';
	 SIGNAL	 nl10l4	:	STD_LOGIC := '0';
	 SIGNAL	 nl11l5	:	STD_LOGIC := '0';
	 SIGNAL	 nl11l6	:	STD_LOGIC := '0';
	 SIGNAL	 nl1iO1	:	STD_LOGIC := '0';
	 SIGNAL	 nl1iO2	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl1iO2_w_lg_q6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n1li	:	STD_LOGIC := '0';
	 SIGNAL	n1lO	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1ll_PRN	:	STD_LOGIC;
	 SIGNAL	n00i	:	STD_LOGIC := '0';
	 SIGNAL	n00l	:	STD_LOGIC := '0';
	 SIGNAL	n00O	:	STD_LOGIC := '0';
	 SIGNAL	n01l	:	STD_LOGIC := '0';
	 SIGNAL	n01O	:	STD_LOGIC := '0';
	 SIGNAL	n0ii	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0li	:	STD_LOGIC := '0';
	 SIGNAL	n0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0lO	:	STD_LOGIC := '0';
	 SIGNAL	n0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	n1iO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni1O_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_ni1O_w_lg_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_w_lg_w_lg_ni1i2w4w7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_w_lg_ni1i2w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0Oi34w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0lO33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0OO3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_ni1i2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n00i107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n00l115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0li84w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0ll92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_reset30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_shift_out48w49w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_shift_out48w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  niOll :	STD_LOGIC;
	 SIGNAL  nl10i :	STD_LOGIC;
	 SIGNAL  nl11i :	STD_LOGIC;
	 SIGNAL  nl11O :	STD_LOGIC;
	 SIGNAL  nl1ii :	STD_LOGIC;
	 SIGNAL  nl1il :	STD_LOGIC;
	 SIGNAL  wire_w_dev_addr_range106w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dev_addr_range114w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_port_addr_range83w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_port_addr_range91w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_reset30w(0) <= NOT reset;
	wire_w_lg_w_lg_shift_out48w49w(0) <= wire_w_lg_shift_out48w(0) OR n01l;
	wire_w_lg_shift_out48w(0) <= shift_out OR ld_data;
	data_enable_n <= (NOT ((wire_w_lg_w_lg_shift_out48w49w(0) AND (nl10i OR valid_addr_lt)) AND (niO0O16 XOR niO0O15)));
	mbus_in <= ( ni0i & ni1l & ni1i & n0OO & n0Ol & n0Oi & n0lO & n0ll & n0li & n0iO & n0il & n0ii & n00O & n00l & n00i & n01O);
	mdio_out <= wire_nl_dataout;
	niOll <= (((n0Oi AND n0lO) OR (wire_ni1O_w_lg_n0Oi34w(0) AND (niOOl8 XOR niOOl7))) OR (NOT (niOlO10 XOR niOlO9)));
	nl10i <= (wire_ni1O_w_lg_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w9w(0) AND (nl10l4 XOR nl10l3));
	nl11i <= '1';
	nl11O <= (shift_in OR shift_out);
	nl1ii <= ((((((NOT (n01O XOR dev_addr(0))) AND (NOT (wire_ni1O_w_lg_n00i107w(0) XOR (NOT (nilOO22 XOR nilOO21))))) AND (NOT (wire_ni1O_w_lg_n00l115w(0) XOR (NOT (nilOi24 XOR nilOi23))))) AND (NOT (n00O XOR dev_addr(3)))) AND (NOT (n0ii XOR dev_addr(4)))) AND (nilll26 XOR nilll25));
	nl1il <= (((((NOT (n0il XOR port_addr(0))) AND (NOT (n0iO XOR port_addr(1)))) AND (NOT (wire_ni1O_w_lg_n0li84w(0) XOR (NOT (niO0i18 XOR niO0i17))))) AND (NOT (wire_ni1O_w_lg_n0ll92w(0) XOR (NOT (niO1l20 XOR niO1l19))))) AND (NOT (n0lO XOR port_addr(4))));
	opcode <= ( n1lO & n1li);
	valid_addr <= nl10i;
	wire_w_dev_addr_range106w(0) <= dev_addr(1);
	wire_w_dev_addr_range114w(0) <= dev_addr(2);
	wire_w_port_addr_range83w(0) <= port_addr(2);
	wire_w_port_addr_range91w(0) <= port_addr(3);
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilll25 <= nilll26;
		END IF;
		if (now = 0 ns) then
			nilll25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilll26 <= nilll25;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOi23 <= nilOi24;
		END IF;
		if (now = 0 ns) then
			nilOi23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOi24 <= nilOi23;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOO21 <= nilOO22;
		END IF;
		if (now = 0 ns) then
			nilOO21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOO22 <= nilOO21;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0i17 <= niO0i18;
		END IF;
		if (now = 0 ns) then
			niO0i17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0i18 <= niO0i17;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0O15 <= niO0O16;
		END IF;
		if (now = 0 ns) then
			niO0O15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0O16 <= niO0O15;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO1l19 <= niO1l20;
		END IF;
		if (now = 0 ns) then
			niO1l19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO1l20 <= niO1l19;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOil13 <= niOil14;
		END IF;
		if (now = 0 ns) then
			niOil13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOil14 <= niOil13;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOiO11 <= niOiO12;
		END IF;
		if (now = 0 ns) then
			niOiO11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOiO12 <= niOiO11;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOlO10 <= niOlO9;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOlO9 <= niOlO10;
		END IF;
		if (now = 0 ns) then
			niOlO9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOOl7 <= niOOl8;
		END IF;
		if (now = 0 ns) then
			niOOl7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOOl8 <= niOOl7;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl10l3 <= nl10l4;
		END IF;
		if (now = 0 ns) then
			nl10l3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl10l4 <= nl10l3;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl11l5 <= nl11l6;
		END IF;
		if (now = 0 ns) then
			nl11l5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl11l6 <= nl11l5;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl1iO1 <= nl1iO2;
		END IF;
		if (now = 0 ns) then
			nl1iO1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl1iO2 <= nl1iO1;
		END IF;
	END PROCESS;
	wire_nl1iO2_w_lg_q6w(0) <= nl1iO2 XOR nl1iO1;
	PROCESS (mdc, wire_n1ll_PRN, reset)
	BEGIN
		IF (wire_n1ll_PRN = '0') THEN
				n1li <= '1';
				n1lO <= '1';
		ELSIF (reset = '1') THEN
				n1li <= '0';
				n1lO <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
			IF (latch_ctl = '1') THEN
				n1li <= n0lO;
				n1lO <= n0Oi;
			END IF;
		END IF;
	END PROCESS;
	wire_n1ll_PRN <= (niOil14 XOR niOil13);
	PROCESS (mdc, wire_ni1O_CLRN)
	BEGIN
		IF (wire_ni1O_CLRN = '0') THEN
				n00i <= '0';
				n00l <= '0';
				n00O <= '0';
				n01l <= '0';
				n01O <= '0';
				n0ii <= '0';
				n0il <= '0';
				n0iO <= '0';
				n0li <= '0';
				n0ll <= '0';
				n0lO <= '0';
				n0Oi <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				n1iO <= '0';
				n1Oi <= '0';
				ni0i <= '0';
				ni1i <= '0';
				ni1l <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
				n00i <= wire_ni0O_dataout;
				n00l <= wire_niii_dataout;
				n00O <= wire_niil_dataout;
				n01l <= wire_n1Ol_dataout;
				n01O <= wire_ni0l_dataout;
				n0ii <= wire_niiO_dataout;
				n0il <= wire_nili_dataout;
				n0iO <= wire_nill_dataout;
				n0li <= wire_nilO_dataout;
				n0ll <= wire_niOi_dataout;
				n0lO <= wire_niOl_dataout;
				n0Oi <= wire_niOO_dataout;
				n0Ol <= wire_nl1i_dataout;
				n0OO <= wire_nl1l_dataout;
				n1iO <= wire_n1OO_dataout;
				n1Oi <= mdio_in;
				ni0i <= wire_nl0l_dataout;
				ni1i <= wire_nl1O_dataout;
				ni1l <= wire_nl0i_dataout;
		END IF;
	END PROCESS;
	wire_ni1O_CLRN <= ((nl11l6 XOR nl11l5) AND wire_w_lg_reset30w(0));
	wire_ni1O_w_lg_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w9w(0) <= wire_ni1O_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w(0) AND nl1ii;
	wire_ni1O_w_lg_w_lg_w_lg_w_lg_ni1i2w4w7w8w(0) <= wire_ni1O_w_lg_w_lg_w_lg_ni1i2w4w7w(0) AND nl1il;
	wire_ni1O_w_lg_w_lg_w_lg_ni1i2w4w7w(0) <= wire_ni1O_w_lg_w_lg_ni1i2w4w(0) AND wire_nl1iO2_w_lg_q6w(0);
	wire_ni1O_w_lg_w_lg_ni1i2w4w(0) <= wire_ni1O_w_lg_ni1i2w(0) AND wire_ni1O_w_lg_n0OO3w(0);
	wire_ni1O_w_lg_n0Oi34w(0) <= n0Oi AND wire_ni1O_w_lg_n0lO33w(0);
	wire_ni1O_w_lg_n0lO33w(0) <= NOT n0lO;
	wire_ni1O_w_lg_n0OO3w(0) <= NOT n0OO;
	wire_ni1O_w_lg_ni1i2w(0) <= NOT ni1i;
	wire_ni1O_w_lg_n00i107w(0) <= n00i XOR wire_w_dev_addr_range106w(0);
	wire_ni1O_w_lg_n00l115w(0) <= n00l XOR wire_w_dev_addr_range114w(0);
	wire_ni1O_w_lg_n0li84w(0) <= n0li XOR wire_w_port_addr_range83w(0);
	wire_ni1O_w_lg_n0ll92w(0) <= n0ll XOR wire_w_port_addr_range91w(0);
	wire_n0i_dataout <= n0OO WHEN nl11O = '1'  ELSE ni1i;
	wire_n0l_dataout <= ni1i WHEN nl11O = '1'  ELSE ni1l;
	wire_n0O_dataout <= ni1l WHEN nl11O = '1'  ELSE ni0i;
	wire_n1i_dataout <= n0lO WHEN nl11O = '1'  ELSE n0Oi;
	wire_n1l_dataout <= n0Oi WHEN nl11O = '1'  ELSE n0Ol;
	wire_n1O_dataout <= n0Ol WHEN nl11O = '1'  ELSE n0OO;
	wire_n1Ol_dataout <= niOll WHEN latch_ctl = '1'  ELSE ((n01l AND n1iO) AND (niOiO12 XOR niOiO11));
	wire_n1OO_dataout <= niOll AND latch_ctl;
	wire_ni0l_dataout <= mbus_out(15) WHEN ld_data = '1'  ELSE wire_nl0O_dataout;
	wire_ni0O_dataout <= mbus_out(0) WHEN ld_data = '1'  ELSE wire_nlii_dataout;
	wire_niii_dataout <= mbus_out(1) WHEN ld_data = '1'  ELSE wire_nlil_dataout;
	wire_niil_dataout <= mbus_out(2) WHEN ld_data = '1'  ELSE wire_nliO_dataout;
	wire_niiO_dataout <= mbus_out(3) WHEN ld_data = '1'  ELSE wire_nlli_dataout;
	wire_nili_dataout <= mbus_out(4) WHEN ld_data = '1'  ELSE wire_nlll_dataout;
	wire_nill_dataout <= mbus_out(5) WHEN ld_data = '1'  ELSE wire_nllO_dataout;
	wire_nilO_dataout <= mbus_out(6) WHEN ld_data = '1'  ELSE wire_nlOi_dataout;
	wire_niOi_dataout <= mbus_out(7) WHEN ld_data = '1'  ELSE wire_nlOl_dataout;
	wire_niOl_dataout <= mbus_out(8) WHEN ld_data = '1'  ELSE wire_nlOO_dataout;
	wire_niOO_dataout <= mbus_out(9) WHEN ld_data = '1'  ELSE wire_n1i_dataout;
	wire_nl_dataout <= mbus_out(15) WHEN ld_data = '1'  ELSE wire_nO_dataout;
	wire_nl0i_dataout <= mbus_out(13) WHEN ld_data = '1'  ELSE wire_n0l_dataout;
	wire_nl0l_dataout <= mbus_out(14) WHEN ld_data = '1'  ELSE wire_n0O_dataout;
	wire_nl0O_dataout <= n1Oi WHEN nl11O = '1'  ELSE n01O;
	wire_nl1i_dataout <= mbus_out(10) WHEN ld_data = '1'  ELSE wire_n1l_dataout;
	wire_nl1l_dataout <= mbus_out(11) WHEN ld_data = '1'  ELSE wire_n1O_dataout;
	wire_nl1O_dataout <= mbus_out(12) WHEN ld_data = '1'  ELSE wire_n0i_dataout;
	wire_nlii_dataout <= n01O WHEN nl11O = '1'  ELSE n00i;
	wire_nlil_dataout <= n00i WHEN nl11O = '1'  ELSE n00l;
	wire_nliO_dataout <= n00l WHEN nl11O = '1'  ELSE n00O;
	wire_nlli_dataout <= n00O WHEN nl11O = '1'  ELSE n0ii;
	wire_nlll_dataout <= n0ii WHEN nl11O = '1'  ELSE n0il;
	wire_nllO_dataout <= n0il WHEN nl11O = '1'  ELSE n0iO;
	wire_nlOi_dataout <= n0iO WHEN nl11O = '1'  ELSE n0li;
	wire_nlOl_dataout <= n0li WHEN nl11O = '1'  ELSE n0ll;
	wire_nlOO_dataout <= n0ll WHEN nl11O = '1'  ELSE n0lO;
	wire_nO_dataout <= ni0i AND shift_out;

 END RTL; --stratixiigx_hssi_mdio_ctl_data
--synopsys translate_on
--VALID FILE

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_mdio_pcs_bus_out_mux IS
    PORT (
        pcs_ctrl_in1            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in2            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in3            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in4            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in5            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in6            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in7            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in8            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in9            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in10           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in11           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in12           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in13           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in14           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in15           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in16           : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in1     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in2     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in3     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in4     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in5     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in6     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in7     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in8     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in9     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in10    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in11    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in12    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in13    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in14    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in15    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in16    : IN std_logic_vector(15 DOWNTO 0);   
        reg_addr                : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_out            : OUT std_logic_vector(15 DOWNTO 0));   
END stratixiigx_hssi_mdio_pcs_bus_out_mux;

ARCHITECTURE mdio_pcs_bus_out_mux_arch OF stratixiigx_hssi_mdio_pcs_bus_out_mux IS


    SIGNAL temp_xhdl2               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl3               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl4               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl5               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl6               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl7               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl8               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl9               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl10              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl11              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl12              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl13              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl14              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl15              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl16              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl17              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL pcs_ctrl_out_xhdl1       :  std_logic_vector(15 DOWNTO 0);   

BEGIN
    pcs_ctrl_out <= pcs_ctrl_out_xhdl1;
    temp_xhdl2 <= pcs_ctrl_in16 WHEN (reg_addr = hw_address_ctrl_in16) ELSE "0000000000000000";
    temp_xhdl3 <= pcs_ctrl_in15 WHEN (reg_addr = hw_address_ctrl_in15) ELSE temp_xhdl2;
    temp_xhdl4 <= pcs_ctrl_in14 WHEN (reg_addr = hw_address_ctrl_in14) ELSE temp_xhdl3;
    temp_xhdl5 <= pcs_ctrl_in13 WHEN (reg_addr = hw_address_ctrl_in13) ELSE temp_xhdl4;
    temp_xhdl6 <= pcs_ctrl_in12 WHEN (reg_addr = hw_address_ctrl_in12) ELSE temp_xhdl5;
    temp_xhdl7 <= pcs_ctrl_in11 WHEN (reg_addr = hw_address_ctrl_in11) ELSE temp_xhdl6;
    temp_xhdl8 <= pcs_ctrl_in10 WHEN (reg_addr = hw_address_ctrl_in10) ELSE temp_xhdl7;
    temp_xhdl9 <= pcs_ctrl_in9 WHEN (reg_addr = hw_address_ctrl_in9) ELSE temp_xhdl8;
    temp_xhdl10 <= pcs_ctrl_in8 WHEN (reg_addr = hw_address_ctrl_in8) ELSE temp_xhdl9;
    temp_xhdl11 <= pcs_ctrl_in7 WHEN (reg_addr = hw_address_ctrl_in7) ELSE temp_xhdl10;
    temp_xhdl12 <= pcs_ctrl_in6 WHEN (reg_addr = hw_address_ctrl_in6) ELSE temp_xhdl11;
    temp_xhdl13 <= pcs_ctrl_in5 WHEN (reg_addr = hw_address_ctrl_in5) ELSE temp_xhdl12;
    temp_xhdl14 <= pcs_ctrl_in4 WHEN (reg_addr = hw_address_ctrl_in4) ELSE temp_xhdl13;
    temp_xhdl15 <= pcs_ctrl_in3 WHEN (reg_addr = hw_address_ctrl_in3) ELSE temp_xhdl14;
    temp_xhdl16 <= pcs_ctrl_in2 WHEN (reg_addr = hw_address_ctrl_in2) ELSE temp_xhdl15;
    temp_xhdl17 <= pcs_ctrl_in1 WHEN (reg_addr = hw_address_ctrl_in1) ELSE temp_xhdl16;
    pcs_ctrl_out_xhdl1 <= temp_xhdl17 ;

END mdio_pcs_bus_out_mux_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_mdio_sm IS
    PORT (
        mdc                     : IN std_logic;   --  Clock for MDIO interface
        mdio_in                 : IN std_logic;   --  Signal bit data
        reset                   : IN std_logic;   --  Active high Hard Reset
        opcode                  : IN std_logic_vector(1 DOWNTO 0);   --  2 bit opcode from mdio_ctl_data module
                                                                     -- 00 - Address
                                                                     -- 01 - Write
                                                                     -- 10 - Read with no post Increment
                                                                     -- 11 - Read with post increment

        valid_addr              : IN std_logic;   --  When set the Port and Dev Address
                                                  -- corresponds to this module

        cnt_eq_0                : IN std_logic;   --  From mdio_cnt module, down counter is 0
        shift_in                : OUT std_logic;   --  Shift in enable for either data or control
        shift_out               : OUT std_logic;   --  Shift out enable for mdio_ctl_data
        latch_ctl               : OUT std_logic;   --  Latch the Opcode, to mdio_ctl_data
        incr_addr               : OUT std_logic;   --  Increment signal for mdio_addr
        mdio_wr                 : OUT std_logic;   --  This is used for writing the mdio registers
        mdio_rd                 : OUT std_logic;   --  This is used for clearing the mdio status registers
        shift_addr              : OUT std_logic;   --  Shift in Enable for mdio_addr
        ld_data                 : OUT std_logic;   --  When set, the shift register is mdio_ctl_data is parallely
                                                   -- loaded with the data from mdio_reg module

        ld_cnt                  : OUT std_logic;   --  Load Down counter
        cnt_val                 : OUT std_logic_vector(4 DOWNTO 0);   --  Value to load the down counter
        valid_addr_lt           : OUT std_logic;   
        curr_state              : OUT std_logic_vector(2 DOWNTO 0));   
END stratixiigx_hssi_mdio_sm;

ARCHITECTURE mdio_sm_arch OF stratixiigx_hssi_mdio_sm IS


    -- Allowed states for curr_state and next_state
    --wire      ld_data_d;
    CONSTANT  IDLE                  :  std_logic_vector(2 DOWNTO 0) := "000";    
    CONSTANT  PREAMBLE              :  std_logic_vector(2 DOWNTO 0) := "001";    
    CONSTANT  CONTROL               :  std_logic_vector(2 DOWNTO 0) := "010";    
    CONSTANT  TURN_ARND_0           :  std_logic_vector(2 DOWNTO 0) := "011";    
    CONSTANT  TURN_ARND_1           :  std_logic_vector(2 DOWNTO 0) := "100";    
    CONSTANT  ADDR_DATA             :  std_logic_vector(2 DOWNTO 0) := "101";    
    -- Decode for opcode
    CONSTANT  ADDR_OP               :  std_logic_vector(1 DOWNTO 0) := "00";    
    CONSTANT  WR_OP                 :  std_logic_vector(1 DOWNTO 0) := "01";    
    CONSTANT  RD_INC_OP             :  std_logic_vector(1 DOWNTO 0) := "10";    
    CONSTANT  RD_OP                 :  std_logic_vector(1 DOWNTO 0) := "11";    
    SIGNAL next_state               :  std_logic_vector(2 DOWNTO 0);   
    SIGNAL shift_in_xhdl1           :  std_logic;   
    SIGNAL shift_out_xhdl2          :  std_logic;   
    SIGNAL latch_ctl_xhdl3          :  std_logic;   
    SIGNAL incr_addr_xhdl4          :  std_logic;   
    SIGNAL mdio_wr_xhdl5            :  std_logic;   
    SIGNAL mdio_rd_xhdl6            :  std_logic;   
    SIGNAL shift_addr_xhdl7         :  std_logic;   
    SIGNAL ld_data_xhdl8            :  std_logic;   
    SIGNAL ld_cnt_xhdl9             :  std_logic;   
    SIGNAL cnt_val_xhdl10           :  std_logic_vector(4 DOWNTO 0);   
    SIGNAL valid_addr_lt_xhdl11     :  std_logic;   
    SIGNAL curr_state_xhdl12        :  std_logic_vector(2 DOWNTO 0);   

BEGIN
    shift_in <= shift_in_xhdl1;
    shift_out <= shift_out_xhdl2;
    latch_ctl <= latch_ctl_xhdl3;
    incr_addr <= incr_addr_xhdl4;
    mdio_wr <= mdio_wr_xhdl5;
    mdio_rd <= mdio_rd_xhdl6;
    shift_addr <= shift_addr_xhdl7;
    ld_data <= ld_data_xhdl8;
    ld_cnt <= ld_cnt_xhdl9;
    cnt_val <= cnt_val_xhdl10;
    valid_addr_lt <= valid_addr_lt_xhdl11;
    curr_state <= curr_state_xhdl12;

    -- Latch Curr State
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            curr_state_xhdl12 <= IDLE;    
        ELSE
            curr_state_xhdl12 <= next_state;    
        END IF;
    END PROCESS;

    -- Next State loic for mdio_sm
    
    PROCESS
    BEGIN
        WAIT UNTIL curr_state_xhdl12'EVENT OR mdio_in'EVENT OR cnt_eq_0'EVENT OR valid_addr'EVENT OR opcode'EVENT;
        CASE curr_state_xhdl12 IS
            WHEN IDLE =>
                        IF (mdio_in = '1') THEN
                            next_state <= PREAMBLE;    
                        ELSE
                            next_state <= IDLE;    
                        END IF;
            WHEN PREAMBLE =>
                        IF (mdio_in /= '1' AND cnt_eq_0 /= '1') THEN
                            next_state <= IDLE;    
                        ELSE
                            IF (mdio_in /= '1' AND cnt_eq_0 = '1') THEN
                                next_state <= CONTROL;    
                            ELSE
                                next_state <= PREAMBLE;    
                            END IF;
                        END IF;
            WHEN CONTROL =>
                        IF (cnt_eq_0 = '1') THEN
                            IF (mdio_in = '0') THEN
                                next_state <= IDLE;    
                            ELSE
                                next_state <= TURN_ARND_0;    
                            END IF;
                        ELSE
                            next_state <= CONTROL;    
                        END IF;
            WHEN TURN_ARND_0 =>
                        IF (mdio_in = '1' OR valid_addr = '0') THEN
                            next_state <= IDLE;    
                        ELSE
                            IF (opcode = WR_OP OR opcode = ADDR_OP) THEN
                                next_state <= TURN_ARND_1;    
                            ELSE
                                next_state <= ADDR_DATA;    
                            END IF;
                        END IF;
            WHEN TURN_ARND_1 =>                        
                        next_state <= ADDR_DATA;    
            WHEN ADDR_DATA =>
                        IF ((cnt_eq_0 = '1' AND mdio_in = '1') AND (opcode = WR_OP OR opcode = ADDR_OP)) THEN
                            next_state <= PREAMBLE;    
                        ELSE
                            IF (cnt_eq_0 = '1') THEN
                                next_state <= IDLE;    
                            ELSE
                                next_state <= ADDR_DATA;    
                            END IF;
                        END IF;
            WHEN OTHERS  =>
                        next_state <= IDLE;    
            
        END CASE;
    END PROCESS;

    -- Valid_addr_lt is used to enable mdio_out
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            valid_addr_lt_xhdl11 <= '0';    
        ELSE
            IF (valid_addr = '1' AND curr_state_xhdl12 = TURN_ARND_0) THEN
                valid_addr_lt_xhdl11 <= '1';    
            ELSE
                IF (curr_state_xhdl12 = ADDR_DATA AND cnt_eq_0 = '1') THEN
                    valid_addr_lt_xhdl11 <= '0';    
                END IF;
            END IF;
        END IF;
    END PROCESS;

    -- Logic for shift_in, This signal is used for shifting in
    -- control logic, during all commands, and data during
    -- Write command
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            shift_in_xhdl1 <= '0';    
        ELSE
            IF ((curr_state_xhdl12 = PREAMBLE AND next_state = CONTROL) OR (next_state = CONTROL) OR (next_state = ADDR_DATA AND opcode = WR_OP)) THEN
                shift_in_xhdl1 <= '1';    
            ELSE
                shift_in_xhdl1 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Shift_out logic, shift_out is set when d ata is shifted out on
    -- a RD_OP or RD_INC_OP command
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            shift_out_xhdl2 <= '0';    
        ELSE
            IF ((curr_state_xhdl12 = TURN_ARND_0 AND next_state = ADDR_DATA) OR 
                ((curr_state_xhdl12 = ADDR_DATA) AND 
                 (opcode = RD_OP OR opcode = RD_INC_OP) AND 
                 (cnt_eq_0 = '0'))) THEN
                shift_out_xhdl2 <= '1';    
            ELSE
                shift_out_xhdl2 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Logic for latch_ctl, this signal is used for latching the opcode
    -- This signal is set when in Control state and moving to TURN_ARND_0
    -- state
    --
    -- always @(posedge reset or posedge mdc)
    -- begin
    --    if (reset)
    --        latch_ctl <= 1'b0;
    --    else
    --       if (curr_state == CONTROL && next_state == TURN_ARND_0)
    --          latch_ctl <= 1'b1;
    --       else
    --          latch_ctl <= 1'b0;
    -- end
    -- 
    
    PROCESS
    BEGIN
        WAIT UNTIL cnt_eq_0'EVENT OR curr_state_xhdl12'EVENT;
        IF (cnt_eq_0 = '1' AND curr_state_xhdl12 = CONTROL) THEN    
             latch_ctl_xhdl3 <= '1';
        ELSE
             latch_ctl_xhdl3 <= '0';
        END IF;
    END PROCESS;

    -- Logic for incr_addr, incr_addr is set for opcode RD_INC_OP and
    -- after completely shifting out the read data for the current command
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            incr_addr_xhdl4 <= '0';    
        ELSE
            IF (curr_state_xhdl12 = ADDR_DATA AND cnt_eq_0 = '1' AND opcode = RD_INC_OP) THEN
                incr_addr_xhdl4 <= '1';    
            ELSE
                incr_addr_xhdl4 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Logic for shift addr, this bit is set when moving to ADDR_DATA 
    -- state and when in ADDR_DATA state for ADDR_OP command
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            shift_addr_xhdl7 <= '0';    
        ELSE
            IF (next_state = ADDR_DATA AND opcode = ADDR_OP) THEN
                shift_addr_xhdl7 <= '1';    
            ELSE
                shift_addr_xhdl7 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Logic for mdio_wr, this bit is set when moving from ADDR_DATA to the
    -- IDLE for a WR_OP command
    -- Logic for mdio_rd, this bit is set when moving from ADDR_DATA to the
    -- IDLE for a RD_OP/RD_INC_OP command
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            mdio_wr_xhdl5 <= '0';    
            mdio_rd_xhdl6 <= '0';    
        ELSE
            IF (curr_state_xhdl12 = ADDR_DATA AND cnt_eq_0 = '1') THEN
                IF (opcode = WR_OP) THEN
                    mdio_wr_xhdl5 <= '1';    
                ELSE
                    mdio_wr_xhdl5 <= '0';    
                END IF;
                IF (opcode = RD_OP OR opcode = RD_INC_OP) THEN
                    mdio_rd_xhdl6 <= '1';    
                ELSE
                    mdio_rd_xhdl6 <= '0';    
                END IF;
            ELSE
                mdio_wr_xhdl5 <= '0';    
                mdio_rd_xhdl6 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Logic for ld_data, this signal is used for parallely loading the
    -- shift register in mdio_ctl_data module with the data from mdio_reg
    -- module. This set is set for RD_OP and RD_INC_OP commands when the
    -- SM transitions from TURN_ARND_0 to ADDR_DATA state
    -- assign ld_data_d = (curr_state == TURN_ARND_0 && (opcode == RD_OP | opcode == RD_INC_OP));
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            ld_data_xhdl8 <= '0';    
        ELSE
            IF (curr_state_xhdl12 = TURN_ARND_0 AND next_state = ADDR_DATA) THEN   
                ld_data_xhdl8 <= '1';
            ELSE
                ld_data_xhdl8 <= '0';            
            END IF;    
        END IF;
    END PROCESS;

    -- Logic for ld_cnt, this signal is used for loading the down counter
    -- with cnt_val signal. This signal is set when going to
    -- CONTROL state or ADDR_DATA state or PREAMBLE states
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            ld_cnt_xhdl9 <= '0';    
        ELSE
            IF ((curr_state_xhdl12 = IDLE AND next_state = PREAMBLE) OR (curr_state_xhdl12 = ADDR_DATA AND next_state = PREAMBLE) OR (curr_state_xhdl12 = PREAMBLE AND next_state = CONTROL) OR (curr_state_xhdl12 = TURN_ARND_0 AND next_state = ADDR_DATA) OR (curr_state_xhdl12 = TURN_ARND_1 AND next_state = ADDR_DATA)) THEN
                ld_cnt_xhdl9 <= '1';    
            ELSE
                ld_cnt_xhdl9 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Logic for cnt_val, this counter value is used for sown counting
    -- the mdio_cnt, when the counter reaches zero, the cnt_eq_0 is
    -- set. The counter is loading with 31 for PREAMBLE, 13 for 
    -- CONTROL, and 15 for ADDR_DATA
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            cnt_val_xhdl10 <= "00000";    
        ELSE
            IF ((curr_state_xhdl12 = IDLE OR curr_state_xhdl12 = ADDR_DATA) AND next_state = PREAMBLE) THEN
                cnt_val_xhdl10 <= "11110";    
            ELSE
                IF (curr_state_xhdl12 = PREAMBLE AND next_state = CONTROL) THEN
                    cnt_val_xhdl10 <= "01100";    
                ELSE
                    IF (curr_state_xhdl12 = TURN_ARND_0 AND next_state = ADDR_DATA) THEN
                        cnt_val_xhdl10 <= "01110";    
                    ELSE
                        IF (curr_state_xhdl12 = TURN_ARND_1 AND next_state = ADDR_DATA) THEN
                            cnt_val_xhdl10 <= "01110";    
                        ELSE
                            cnt_val_xhdl10 <= cnt_val_xhdl10;    
                        END IF;
                    END IF;
                END IF;
            END IF;
        END IF;
    END PROCESS;

END mdio_sm_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_bsc_in_r IS
    PORT (
        -- synthesis ALTERA_ATTRIBUTE="{-to so} POWER_UP_LEVEL=LOW" 
        reset                   : IN std_logic;   --  reset
        clk                     : IN std_logic;   --  clock
        sig_in                  : IN std_logic;   --  signal input
        ext_in                  : IN std_logic;   --  external input port
        jtag_mode               : IN std_logic;   
        si                      : IN std_logic;   --  scan input
        shift                   : IN std_logic;   --  1'b1=shift in data from si into scan flop
        -- 1'b0=load data from sig_in into scan flop

        mdio_dis                : IN std_logic;   --  1'b1=choose ext_in to the sig_out mux
        -- 1'b0=choose so to the sign_out mux

        sig_out                 : OUT std_logic;   --  signal output
        so                      : OUT std_logic);   --  scan output
END stratixiigx_hssi_bsc_in_r;

ARCHITECTURE bsc_in_r_arch OF stratixiigx_hssi_bsc_in_r IS


    SIGNAL cram_int                 :  std_logic;   
    SIGNAL set_int                  :  std_logic;   
    -- select signal output
    SIGNAL temp_xhdl3               :  std_logic;   
    SIGNAL temp_xhdl4               :  std_logic;   
    -- Set signal for the flop
    SIGNAL temp_xhdl5               :  std_logic;   
    SIGNAL sig_out_xhdl1            :  std_logic;   
    SIGNAL so_xhdl2                 :  std_logic;   

BEGIN
    sig_out <= sig_out_xhdl1;
    so <= so_xhdl2;
    temp_xhdl3 <= (so_xhdl2 AND NOT shift) WHEN (jtag_mode) = '1' ELSE (cram_int);
    sig_out_xhdl1 <= temp_xhdl3 ;
    temp_xhdl4 <= (ext_in) WHEN (mdio_dis) = '1' ELSE (so_xhdl2);
    cram_int <= temp_xhdl4 ;
    temp_xhdl5 <= '0' WHEN (shift) = '1' ELSE ext_in;
    set_int <= temp_xhdl5 ;

    -- scan flop
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (set_int'EVENT AND set_int = '1') OR (clk'EVENT AND clk = '1');
        IF (reset = '1') THEN
            so_xhdl2 <= '0';    
        ELSE
            IF (set_int = '1') THEN
                so_xhdl2 <= '1';    
            ELSE
                IF ((shift AND jtag_mode) = '1') THEN
                    so_xhdl2 <= si;    
                ELSE
                    so_xhdl2 <= sig_in;    
                END IF;
            END IF;
        END IF;
    END PROCESS;

END bsc_in_r_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.stratixiigx_hssi_bsc_in_r;
ENTITY stratixiigx_hssi_ctrl_reg IS
    PORT (
        reset                   : IN std_logic;   --  reset
        mdio_wr                 : IN std_logic;   
        reg_addr                : IN std_logic_vector(15 DOWNTO 0);   
        target_addr             : IN std_logic_vector(15 DOWNTO 0);   
        clk                     : IN std_logic;   --  clock
        sig_in                  : IN std_logic_vector(15 DOWNTO 0);   --  signal input
        ext_in                  : IN std_logic_vector(15 DOWNTO 0);   --  external port input
        jtag_mode               : IN std_logic;   
        si                      : IN std_logic;   --  scan input
        shift                   : IN std_logic;   --  1'b1=shift in data from si into scan flop
        -- 1'b0=load data from sig_in into scan flop

        mdio_dis                : IN std_logic;   
        -- 1'b1=output CRAM
-- 1'b0=output MDIO control register

        sig_out                 : OUT std_logic_vector(15 DOWNTO 0);   --  signal output
        so                      : OUT std_logic);   --  scan output
END stratixiigx_hssi_ctrl_reg;

ARCHITECTURE ctrl_reg_arch OF stratixiigx_hssi_ctrl_reg IS

    COMPONENT stratixiigx_hssi_bsc_in_r
        PORT (
            reset                   : IN  std_logic;
            clk                     : IN  std_logic;
            sig_in                  : IN  std_logic;
            ext_in                  : IN  std_logic;
            jtag_mode               : IN  std_logic;
            si                      : IN  std_logic;
            shift                   : IN  std_logic;
            mdio_dis                : IN  std_logic;
            sig_out                 : OUT std_logic;
            so                      : OUT std_logic);
    END COMPONENT;


    SIGNAL signal_in_int            :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL chain                    :  std_logic_vector(14 DOWNTO 0);   
    SIGNAL temp_xhdl3               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL port_xhdl14              :  std_logic;   
    SIGNAL port_xhdl15              :  std_logic;   
    SIGNAL port_xhdl16              :  std_logic;   
    SIGNAL port_xhdl17              :  std_logic;   
    SIGNAL port_xhdl28              :  std_logic;   
    SIGNAL port_xhdl29              :  std_logic;   
    SIGNAL port_xhdl30              :  std_logic;   
    SIGNAL port_xhdl31              :  std_logic;   
    SIGNAL port_xhdl32              :  std_logic;   
    SIGNAL port_xhdl43              :  std_logic;   
    SIGNAL port_xhdl44              :  std_logic;   
    SIGNAL port_xhdl45              :  std_logic;   
    SIGNAL port_xhdl46              :  std_logic;   
    SIGNAL port_xhdl47              :  std_logic;   
    SIGNAL port_xhdl58              :  std_logic;   
    SIGNAL port_xhdl59              :  std_logic;   
    SIGNAL port_xhdl60              :  std_logic;   
    SIGNAL port_xhdl61              :  std_logic;   
    SIGNAL port_xhdl62              :  std_logic;   
    SIGNAL port_xhdl73              :  std_logic;   
    SIGNAL port_xhdl74              :  std_logic;   
    SIGNAL port_xhdl75              :  std_logic;   
    SIGNAL port_xhdl76              :  std_logic;   
    SIGNAL port_xhdl77              :  std_logic;   
    SIGNAL port_xhdl88              :  std_logic;   
    SIGNAL port_xhdl89              :  std_logic;   
    SIGNAL port_xhdl90              :  std_logic;   
    SIGNAL port_xhdl91              :  std_logic;   
    SIGNAL port_xhdl92              :  std_logic;   
    SIGNAL port_xhdl103             :  std_logic;   
    SIGNAL port_xhdl104             :  std_logic;   
    SIGNAL port_xhdl105             :  std_logic;   
    SIGNAL port_xhdl106             :  std_logic;   
    SIGNAL port_xhdl107             :  std_logic;   
    SIGNAL port_xhdl118             :  std_logic;   
    SIGNAL port_xhdl119             :  std_logic;   
    SIGNAL port_xhdl120             :  std_logic;   
    SIGNAL port_xhdl121             :  std_logic;   
    SIGNAL port_xhdl122             :  std_logic;   
    SIGNAL port_xhdl133             :  std_logic;   
    SIGNAL port_xhdl134             :  std_logic;   
    SIGNAL port_xhdl135             :  std_logic;   
    SIGNAL port_xhdl136             :  std_logic;   
    SIGNAL port_xhdl137             :  std_logic;   
    SIGNAL port_xhdl148             :  std_logic;   
    SIGNAL port_xhdl149             :  std_logic;   
    SIGNAL port_xhdl150             :  std_logic;   
    SIGNAL port_xhdl151             :  std_logic;   
    SIGNAL port_xhdl152             :  std_logic;   
    SIGNAL port_xhdl163             :  std_logic;   
    SIGNAL port_xhdl164             :  std_logic;   
    SIGNAL port_xhdl165             :  std_logic;   
    SIGNAL port_xhdl166             :  std_logic;   
    SIGNAL port_xhdl167             :  std_logic;   
    SIGNAL port_xhdl178             :  std_logic;   
    SIGNAL port_xhdl179             :  std_logic;   
    SIGNAL port_xhdl180             :  std_logic;   
    SIGNAL port_xhdl181             :  std_logic;   
    SIGNAL port_xhdl182             :  std_logic;   
    SIGNAL port_xhdl193             :  std_logic;   
    SIGNAL port_xhdl194             :  std_logic;   
    SIGNAL port_xhdl195             :  std_logic;   
    SIGNAL port_xhdl196             :  std_logic;   
    SIGNAL port_xhdl197             :  std_logic;   
    SIGNAL port_xhdl208             :  std_logic;   
    SIGNAL port_xhdl209             :  std_logic;   
    SIGNAL port_xhdl210             :  std_logic;   
    SIGNAL port_xhdl211             :  std_logic;   
    SIGNAL port_xhdl212             :  std_logic;   
    SIGNAL port_xhdl223             :  std_logic;   
    SIGNAL port_xhdl224             :  std_logic;   
    SIGNAL port_xhdl225             :  std_logic;   
    SIGNAL port_xhdl226             :  std_logic;   
    SIGNAL port_xhdl227             :  std_logic;   
    SIGNAL port_xhdl238             :  std_logic;   
    SIGNAL port_xhdl239             :  std_logic;   
    SIGNAL port_xhdl240             :  std_logic;   
    SIGNAL port_xhdl241             :  std_logic;   
    SIGNAL sig_out_xhdl1            :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL so_xhdl2                 :  std_logic;   

BEGIN
    sig_out <= sig_out_xhdl1;
    so <= so_xhdl2;
    temp_xhdl3 <= sig_in WHEN (mdio_wr = '1' AND reg_addr = target_addr) ELSE (so_xhdl2 & chain);
    signal_in_int <= temp_xhdl3 ;
    port_xhdl14 <= signal_in_int(0);
    port_xhdl15 <= ext_in(0);
    sig_out_xhdl1(0) <= port_xhdl16;
    chain(0) <= port_xhdl17;
    bsc_in_r_0 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl14,
            ext_in => port_xhdl15,
            jtag_mode => jtag_mode,
            si => si,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl16,
            so => port_xhdl17);   
    
    port_xhdl28 <= signal_in_int(1);
    port_xhdl29 <= ext_in(1);
    port_xhdl30 <= chain(0);
    sig_out_xhdl1(1) <= port_xhdl31;
    chain(1) <= port_xhdl32;
    bsc_in_r_1 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl28,
            ext_in => port_xhdl29,
            jtag_mode => jtag_mode,
            si => port_xhdl30,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl31,
            so => port_xhdl32);   
    
    port_xhdl43 <= signal_in_int(2);
    port_xhdl44 <= ext_in(2);
    port_xhdl45 <= chain(1);
    sig_out_xhdl1(2) <= port_xhdl46;
    chain(2) <= port_xhdl47;
    bsc_in_r_2 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl43,
            ext_in => port_xhdl44,
            jtag_mode => jtag_mode,
            si => port_xhdl45,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl46,
            so => port_xhdl47);   
    
    port_xhdl58 <= signal_in_int(3);
    port_xhdl59 <= ext_in(3);
    port_xhdl60 <= chain(2);
    sig_out_xhdl1(3) <= port_xhdl61;
    chain(3) <= port_xhdl62;
    bsc_in_r_3 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl58,
            ext_in => port_xhdl59,
            jtag_mode => jtag_mode,
            si => port_xhdl60,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl61,
            so => port_xhdl62);   
    
    port_xhdl73 <= signal_in_int(4);
    port_xhdl74 <= ext_in(4);
    port_xhdl75 <= chain(3);
    sig_out_xhdl1(4) <= port_xhdl76;
    chain(4) <= port_xhdl77;
    bsc_in_r_4 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl73,
            ext_in => port_xhdl74,
            jtag_mode => jtag_mode,
            si => port_xhdl75,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl76,
            so => port_xhdl77);   
    
    port_xhdl88 <= signal_in_int(5);
    port_xhdl89 <= ext_in(5);
    port_xhdl90 <= chain(4);
    sig_out_xhdl1(5) <= port_xhdl91;
    chain(5) <= port_xhdl92;
    bsc_in_r_5 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl88,
            ext_in => port_xhdl89,
            jtag_mode => jtag_mode,
            si => port_xhdl90,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl91,
            so => port_xhdl92);   
    
    port_xhdl103 <= signal_in_int(6);
    port_xhdl104 <= ext_in(6);
    port_xhdl105 <= chain(5);
    sig_out_xhdl1(6) <= port_xhdl106;
    chain(6) <= port_xhdl107;
    bsc_in_r_6 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl103,
            ext_in => port_xhdl104,
            jtag_mode => jtag_mode,
            si => port_xhdl105,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl106,
            so => port_xhdl107);   
    
    port_xhdl118 <= signal_in_int(7);
    port_xhdl119 <= ext_in(7);
    port_xhdl120 <= chain(6);
    sig_out_xhdl1(7) <= port_xhdl121;
    chain(7) <= port_xhdl122;
    bsc_in_r_7 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl118,
            ext_in => port_xhdl119,
            jtag_mode => jtag_mode,
            si => port_xhdl120,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl121,
            so => port_xhdl122);   
    
    port_xhdl133 <= signal_in_int(8);
    port_xhdl134 <= ext_in(8);
    port_xhdl135 <= chain(7);
    sig_out_xhdl1(8) <= port_xhdl136;
    chain(8) <= port_xhdl137;
    bsc_in_r_8 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl133,
            ext_in => port_xhdl134,
            jtag_mode => jtag_mode,
            si => port_xhdl135,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl136,
            so => port_xhdl137);   
    
    port_xhdl148 <= signal_in_int(9);
    port_xhdl149 <= ext_in(9);
    port_xhdl150 <= chain(8);
    sig_out_xhdl1(9) <= port_xhdl151;
    chain(9) <= port_xhdl152;
    bsc_in_r_9 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl148,
            ext_in => port_xhdl149,
            jtag_mode => jtag_mode,
            si => port_xhdl150,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl151,
            so => port_xhdl152);   
    
    port_xhdl163 <= signal_in_int(10);
    port_xhdl164 <= ext_in(10);
    port_xhdl165 <= chain(9);
    sig_out_xhdl1(10) <= port_xhdl166;
    chain(10) <= port_xhdl167;
    bsc_in_r_10 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl163,
            ext_in => port_xhdl164,
            jtag_mode => jtag_mode,
            si => port_xhdl165,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl166,
            so => port_xhdl167);   
    
    port_xhdl178 <= signal_in_int(11);
    port_xhdl179 <= ext_in(11);
    port_xhdl180 <= chain(10);
    sig_out_xhdl1(11) <= port_xhdl181;
    chain(11) <= port_xhdl182;
    bsc_in_r_11 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl178,
            ext_in => port_xhdl179,
            jtag_mode => jtag_mode,
            si => port_xhdl180,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl181,
            so => port_xhdl182);   
    
    port_xhdl193 <= signal_in_int(12);
    port_xhdl194 <= ext_in(12);
    port_xhdl195 <= chain(11);
    sig_out_xhdl1(12) <= port_xhdl196;
    chain(12) <= port_xhdl197;
    bsc_in_r_12 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl193,
            ext_in => port_xhdl194,
            jtag_mode => jtag_mode,
            si => port_xhdl195,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl196,
            so => port_xhdl197);   
    
    port_xhdl208 <= signal_in_int(13);
    port_xhdl209 <= ext_in(13);
    port_xhdl210 <= chain(12);
    sig_out_xhdl1(13) <= port_xhdl211;
    chain(13) <= port_xhdl212;
    bsc_in_r_13 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl208,
            ext_in => port_xhdl209,
            jtag_mode => jtag_mode,
            si => port_xhdl210,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl211,
            so => port_xhdl212);   
    
    port_xhdl223 <= signal_in_int(14);
    port_xhdl224 <= ext_in(14);
    port_xhdl225 <= chain(13);
    sig_out_xhdl1(14) <= port_xhdl226;
    chain(14) <= port_xhdl227;
    bsc_in_r_14 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl223,
            ext_in => port_xhdl224,
            jtag_mode => jtag_mode,
            si => port_xhdl225,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl226,
            so => port_xhdl227);   
    
    port_xhdl238 <= signal_in_int(15);
    port_xhdl239 <= ext_in(15);
    port_xhdl240 <= chain(14);
    sig_out_xhdl1(15) <= port_xhdl241;
    bsc_in_r_15 : stratixiigx_hssi_bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl238,
            ext_in => port_xhdl239,
            jtag_mode => jtag_mode,
            si => port_xhdl240,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl241,
            so => so_xhdl2);   
    

END ctrl_reg_arch;
--IP Functional Simulation Model
--VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END


-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

--synthesis_resources = lut 3 mux21 2 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_bsc_out IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 jtag_mode	:	IN  STD_LOGIC;
		 reset	:	IN  STD_LOGIC;
		 shift_load	:	IN  STD_LOGIC;
		 si	:	IN  STD_LOGIC;
		 sig_in	:	IN  STD_LOGIC;
		 sig_out	:	OUT  STD_LOGIC;
		 so	:	OUT  STD_LOGIC
	 ); 
 END stratixiigx_hssi_bsc_out;

 ARCHITECTURE RTL OF stratixiigx_hssi_bsc_out IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 n1i1	:	STD_LOGIC := '0';
	 SIGNAL	 n1i2	:	STD_LOGIC := '0';
	 SIGNAL	ni	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_reset2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nlOO :	STD_LOGIC;
 BEGIN

	wire_w_lg_reset2w(0) <= NOT reset;
	nlOO <= '1';
	sig_out <= wire_nO_dataout;
	so <= ni;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n1i1 <= n1i2;
		END IF;
		if (now = 0 ns) then
			n1i1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n1i2 <= n1i1;
		END IF;
	END PROCESS;
	PROCESS (clk, wire_nlO_CLRN)
	BEGIN
		IF (wire_nlO_CLRN = '0') THEN
				ni <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				ni <= wire_nl_dataout;
		END IF;
	END PROCESS;
	wire_nlO_CLRN <= ((n1i2 XOR n1i1) AND wire_w_lg_reset2w(0));
	wire_nl_dataout <= si WHEN shift_load = '1'  ELSE sig_in;
	wire_nO_dataout <= ni WHEN jtag_mode = '1'  ELSE sig_in;

 END RTL; --stratixiigx_hssi_bsc_out
--synopsys translate_on
--VALID FILE

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.std_logic_arith.ALL;

LIBRARY STD;
USE STD.textio.ALL;

USE WORK.stratixiigx_hssi_mdio_pcs_bus_out_mux;
USE WORK.stratixiigx_hssi_bsc_out;
USE WORK.stratixiigx_hssi_bsc_in_r;
USE WORK.stratixiigx_hssi_ctrl_reg;

ENTITY stratixiigx_hssi_cmu_dprio_reg IS
  GENERIC (
    rx0_phy : INTEGER := 0;
    rx1_phy : INTEGER := 1;
    rx2_phy : INTEGER := 2;
    rx3_phy : INTEGER := 3;
    tx0_phy : INTEGER := 0;
    tx1_phy : INTEGER := 1;
    tx2_phy : INTEGER := 2;
    tx3_phy : INTEGER := 3;
    
    rx_dprio_width                 :  INTEGER := 800;               -- 6.1
    tx_dprio_width                 :  INTEGER := 400;               -- 6.1        
    
    rx0_cru_clock0_physical_mapping:  string := "refclk0";    
    rx0_cru_clock1_physical_mapping:  string := "refclk1";    
    rx0_cru_clock2_physical_mapping:  string := "iq0";    
    rx0_cru_clock3_physical_mapping:  string := "iq1";    
    rx0_cru_clock4_physical_mapping:  string := "iq2";    
    rx0_cru_clock5_physical_mapping:  string := "iq3";    
    rx0_cru_clock6_physical_mapping:  string := "iq4";    
    rx0_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
    rx0_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
    rx1_cru_clock0_physical_mapping:  string := "refclk0";    
    rx1_cru_clock1_physical_mapping:  string := "refclk1";    
    rx1_cru_clock2_physical_mapping:  string := "iq0";    
    rx1_cru_clock3_physical_mapping:  string := "iq1";    
    rx1_cru_clock4_physical_mapping:  string := "iq2";    
    rx1_cru_clock5_physical_mapping:  string := "iq3";    
    rx1_cru_clock6_physical_mapping:  string := "iq4";    
    rx1_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
    rx1_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
    rx2_cru_clock0_physical_mapping:  string := "refclk0";    
    rx2_cru_clock1_physical_mapping:  string := "refclk1";    
    rx2_cru_clock2_physical_mapping:  string := "iq0";    
    rx2_cru_clock3_physical_mapping:  string := "iq1";    
    rx2_cru_clock4_physical_mapping:  string := "iq2";    
    rx2_cru_clock5_physical_mapping:  string := "iq3";    
    rx2_cru_clock6_physical_mapping:  string := "iq4";    
    rx2_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
    rx2_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
    rx3_cru_clock0_physical_mapping:  string := "refclk0";    
    rx3_cru_clock1_physical_mapping:  string := "refclk1";    
    rx3_cru_clock2_physical_mapping:  string := "iq0";    
    rx3_cru_clock3_physical_mapping:  string := "iq1";    
    rx3_cru_clock4_physical_mapping:  string := "iq2";    
    rx3_cru_clock5_physical_mapping:  string := "iq3";    
    rx3_cru_clock6_physical_mapping:  string := "iq4";    
    rx3_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
    rx3_cru_clock8_physical_mapping:  string := "cmu_div_clk";  
          
    pll0_phy: integer := 0;    
    pll1_phy: integer := 1;    
    pll2_phy: integer := 2;   
    
    pll0_inclk0_logical_to_physical_mapping: string := "iq0";
    pll0_inclk1_logical_to_physical_mapping: string := "iq1";
    pll0_inclk2_logical_to_physical_mapping: string := "iq2";
    pll0_inclk3_logical_to_physical_mapping: string := "iq3";
    pll0_inclk4_logical_to_physical_mapping: string := "iq4";
    pll0_inclk5_logical_to_physical_mapping: string := "pld_clk";
    pll0_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
    pll0_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
    pll1_inclk0_logical_to_physical_mapping: string := "iq0";
    pll1_inclk1_logical_to_physical_mapping: string := "iq1";
    pll1_inclk2_logical_to_physical_mapping: string := "iq2";
    pll1_inclk3_logical_to_physical_mapping: string := "iq3";
    pll1_inclk4_logical_to_physical_mapping: string := "iq4";
    pll1_inclk5_logical_to_physical_mapping: string := "pld_clk";
    pll1_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
    pll1_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
    pll2_inclk0_logical_to_physical_mapping: string := "iq0";
    pll2_inclk1_logical_to_physical_mapping: string := "iq1";
    pll2_inclk2_logical_to_physical_mapping: string := "iq2";
    pll2_inclk3_logical_to_physical_mapping: string := "iq3";
    pll2_inclk4_logical_to_physical_mapping: string := "iq4";
    pll2_inclk5_logical_to_physical_mapping: string := "pld_clk";
    pll2_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
    pll2_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
       
    tx0_pll_fast_clk0_physical_mapping: string := "pll0";    
    tx0_pll_fast_clk1_physical_mapping: string := "pll1";    
    tx1_pll_fast_clk0_physical_mapping: string := "pll0";    
    tx1_pll_fast_clk1_physical_mapping: string := "pll1";    
    tx2_pll_fast_clk0_physical_mapping: string := "pll0";    
    tx2_pll_fast_clk1_physical_mapping: string := "pll1";    
    tx3_pll_fast_clk0_physical_mapping: string := "pll0";    
    tx3_pll_fast_clk1_physical_mapping: string := "pll1";
    
    -- DEBUG dump
    sim_dump_dprio_internal_reg_at_time : integer   := 0;
    sim_dump_filename                   : string := "sim_dprio_dump.txt"
         
  );
  PORT (
    mdc          : IN std_logic := '0';       
    mdio_rst     : IN std_logic := '0';
    mdio_dis     : IN std_logic := '1';
    dprioload    : IN std_logic := '0';
    align_status : IN std_logic := '0';
    sync_status  : IN std_logic_vector (3 DOWNTO 0) := (OTHERS => '0');
    reg_addr     : IN std_logic_vector (15 DOWNTO 0) := (OTHERS => '0');
    mdio_wr      : IN std_logic := '0';      
    mdio_rd      : IN std_logic := '0';
    dev_addr_0   : IN std_logic := '0';
    mbus_in      : IN std_logic_vector (15 DOWNTO 0) := (OTHERS => '0');
                        
    cmudividerdprioin : IN std_logic_vector (29 DOWNTO 0)   := (OTHERS => '0');
    cmuplldprioin     : IN std_logic_vector (119 DOWNTO 0)  := (OTHERS => '0');
    cmudprioin        : IN std_logic_vector (29 DOWNTO 0)   := (OTHERS => '0');
    refclkdividerdprioin : IN std_logic_vector (1 DOWNTO 0) := (OTHERS => '0');
    rxdprioin         : IN std_logic_vector (rx_dprio_width - 1 DOWNTO 0)  := (OTHERS => '0');
    txdprioin         : IN std_logic_vector (tx_dprio_width - 1 DOWNTO 0)  := (OTHERS => '0');
--    rxdprioin         : IN std_logic_vector (1199 DOWNTO 0)  := (OTHERS => '0');
--    txdprioin         : IN std_logic_vector (599 DOWNTO 0)  := (OTHERS => '0');
           
    cmudividerdprioout : OUT std_logic_vector (29 DOWNTO 0);
    cmuplldprioout     : OUT std_logic_vector (119 DOWNTO 0);
    cmudprioout        : OUT std_logic_vector (29 DOWNTO 0);
    refclkdividerdprioout : OUT std_logic_vector (1 DOWNTO 0);
    rxdprioout         : OUT std_logic_vector (rx_dprio_width - 1 DOWNTO 0);
    txdprioout         : OUT std_logic_vector (tx_dprio_width - 1 DOWNTO 0);
--    rxdprioout         : OUT std_logic_vector (1199 DOWNTO 0);
--    txdprioout         : OUT std_logic_vector (599 DOWNTO 0);
            		            
    mbus_out           : OUT std_logic_vector (15 DOWNTO 0));
END stratixiigx_hssi_cmu_dprio_reg;           

ARCHITECTURE dprio_reg_arch OF stratixiigx_hssi_cmu_dprio_reg IS
-- types ---------------------------------------------------------------
type DPRIO_REG_ARRAY_OF_INT is array (natural range <>) of integer;
type DPRIO_REG_ARRAY_OF_VEC is array (natural range <>) of std_logic_vector(5 downto 0);

-- COMPONENTS begin  ---------------------------------------------------
COMPONENT stratixiigx_hssi_mdio_pcs_bus_out_mux
    PORT (
        pcs_ctrl_in1            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in2            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in3            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in4            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in5            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in6            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in7            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in8            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in9            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in10           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in11           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in12           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in13           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in14           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in15           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in16           : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in1     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in2     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in3     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in4     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in5     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in6     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in7     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in8     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in9     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in10    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in11    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in12    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in13    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in14    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in15    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in16    : IN std_logic_vector(15 DOWNTO 0);   
        reg_addr                : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_out            : OUT std_logic_vector(15 DOWNTO 0));   
END COMPONENT;

COMPONENT  stratixiigx_hssi_bsc_out
	 PORT 
	 ( 
		 clk	    :	IN  STD_LOGIC;
		 jtag_mode	:	IN  STD_LOGIC;
		 reset	    :	IN  STD_LOGIC;
		 shift_load	:	IN  STD_LOGIC;
		 si	        :	IN  STD_LOGIC;
		 sig_in	    :	IN  STD_LOGIC;
		 sig_out	:	OUT  STD_LOGIC;
		 so	        :	OUT  STD_LOGIC
	 ); 
END COMPONENT;

COMPONENT stratixiigx_hssi_bsc_in_r
    PORT (
        -- synthesis ALTERA_ATTRIBUTE="{-to so} POWER_UP_LEVEL=LOW" 
        reset                   : IN std_logic;   --  reset
        clk                     : IN std_logic;   --  clock
        sig_in                  : IN std_logic;   --  signal input
        ext_in                  : IN std_logic;   --  external input port
        jtag_mode               : IN std_logic;   
        si                      : IN std_logic;   --  scan input
        shift                   : IN std_logic;   --  1'b1=shift in data from si into scan flop
                                                  -- '0'=load data from sig_in into scan flop

        mdio_dis                : IN std_logic;   --  1'b1=choose ext_in to the sig_out mux
                                                  -- '0'=choose so to the sign_out mux

        sig_out                 : OUT std_logic;   --  signal output
        so                      : OUT std_logic);  --  scan output
END COMPONENT;

COMPONENT stratixiigx_hssi_ctrl_reg
    PORT (
        reset                   : IN std_logic;   --  reset
        mdio_wr                 : IN std_logic;   
        reg_addr                : IN std_logic_vector(15 DOWNTO 0);   
        target_addr             : IN std_logic_vector(15 DOWNTO 0);   
        clk                     : IN std_logic;   --  clock
        sig_in                  : IN std_logic_vector(15 DOWNTO 0);   --  signal input
        ext_in                  : IN std_logic_vector(15 DOWNTO 0);   --  external port input
        jtag_mode               : IN std_logic;   
        si                      : IN std_logic;   --  scan input
        shift                   : IN std_logic;   --  1'b1=shift in data from si into scan flop
                                                  --  '0'=load data from sig_in into scan flop

        mdio_dis                : IN std_logic;   
                                                 -- 1'b1=output CRAM
                                                 -- '0'=output MDIO control register

        sig_out                 : OUT std_logic_vector(15 DOWNTO 0);   --  signal output
        so                      : OUT std_logic);   --  scan output
END COMPONENT;

-- COMPONENTS end  ---------------------------------------------------

SIGNAL my_gnd                   : std_logic := '0';
SIGNAL my_vcc                   : std_logic := '1';

-------------------------------------------------------------------------------
-- DPRIO INDEX TABLE ----------------------------------------------------------
-------------------------------------------------------------------------------

-- make sure indices with _DP_ in the middle to distiguish from rx/tx

-- page 8 - as POF used rclk_2 long ago
-- both rx and tx
--assign  pcs_ctrl8_ch0_ext = {rfreerun_tx[0], rtxwrclksel[0], rtxrdclksel[0],
--801d-8020                  rfreerun_rx[0], rrcvd_clk_sel_ch0, 
--                           rclk_1_sel_ch0, rclk_2_sel_ch0, rrx_rd_clk_sel[0], 
--                           renumber_ch0, renpolinv_rx[0], rclkcmpinsertpad[0]};

constant rfreerun_rx_DP_RX_IDX     : integer :=  0;  
constant rrx_rd_clk_sel_DP_RX_IDX  : integer :=  1;   
constant renumber_DP_RX_IDX_0      : integer :=  2;    
constant renumber_DP_RX_IDX_1      : integer :=  3;    
constant renumber_DP_RX_IDX_2      : integer :=  4;    
constant renpolinv_rx_DP_RX_IDX    : integer :=  5;    
constant rclkcmpinsertpad_DP_RX_IDX: integer :=  6;  
  
constant rclk_1_sel_DP_RX_IDX_0    : integer :=  7;
constant rclk_1_sel_DP_RX_IDX_1    : integer :=  8;
constant rclk_2_sel_DP_RX_IDX_0    : integer :=  9;
constant rclk_2_sel_DP_RX_IDX_1    : integer := 10;
constant rrcvd_clk_sel_DP_RX_IDX_0 : integer := 11;
constant rrcvd_clk_sel_DP_RX_IDX_1 : integer := 12;

-- pma_ctrl6_ch0_ext = {rrefclk_sel_ch0, rbwctral_rx_ch0, rrx_cru_m_sel_ch0, 
-- 8074h                rrx_cru_div2[0], rrx_cru_ctl_ch0, rltr[0], rltd[0]};
constant rrx_cru_m_sel_DP_RX_IDX_0 : integer := 13;
constant rrx_cru_m_sel_DP_RX_IDX_1 : integer := 14;
constant rrx_cru_div2_DP_RX_IDX    : integer := 15;
constant rltr_DP_RX_IDX            : integer := 16;
constant rltd_DP_RX_IDX            : integer := 17;

-- pma_ctrl7_ch0_ext = {risel_rx_ch0, riupsel_rx_ch0, ridnsel_rx_ch0,
-- 8078h               rtesten_cp_rx[0], rtristate_cp_rx[0], rtestupen_cp_rx[0],
--                     rtestdnen_cp_rx[0], rrx_cru_m_ch0, rrx_cru_l_ch0};
-- last two from pma_ctrl4 documented in tx side
-- pma_ctrl7_ch0_ext = {risel_rx_ch0, riupsel_rx_ch0, ridnsel_rx_ch0,
-- 8078h               rtesten_cp_rx[0], rtristate_cp_rx[0], rtestupen_cp_rx[0],
--                     rtestdnen_cp_rx[0], rrx_cru_m_ch0, rrx_cru_l_ch0};
-- last two from pma_ctrl4 documented in tx side
constant rrx_cru_m_DP_RX_IDX_0    : integer :=  18;
constant rrx_cru_m_DP_RX_IDX_1    : integer :=  19;
constant rrx_cru_m_DP_RX_IDX_2    : integer :=  20;
constant rrx_cru_m_DP_RX_IDX_3    : integer :=  21;
constant rrx_cru_l_DP_RX_IDX_0    : integer :=  22;
constant rrx_cru_l_DP_RX_IDX_1    : integer :=  23;
constant rpmadwidth_rx_DP_RX_IDX  : integer :=  24;
constant rpma_doublewidth_rx_DP_RX_IDX : integer :=25;

-- next 32 indices are used for RX_PMA prior to 6.1 for backward compatibility
-- RX_PMA_ST =                     26
-- RX_PMA_ED =                     58

-- PMA_2
--assign  pma_ctrl2_ch0_ext = {rtx_term_ch0, r_tx_det_rx_ch0, rrx_term_ch0, rforce_sigdet[0],
--                             rrx_dc_couple[0], rrx_eq_dc_ch0, rrx_vtt_ch0, rrx_sloslv_ch0};
constant rtx_term_DP_RX_IDX_0    : integer :=   26;
constant rtx_term_DP_RX_IDX_1    : integer :=   27;
constant r_tx_det_rx_DP_RX_IDX_0 : integer :=   28;
constant r_tx_det_rx_DP_RX_IDX_1 : integer :=   29;
constant rrx_term_DP_RX_IDX_0    : integer :=   30;
constant rrx_term_DP_RX_IDX_1    : integer :=   31;
constant rforce_sigdet_DP_RX_IDX : integer :=   32;
constant rrx_dc_couple_DP_RX_IDX : integer :=   33;
constant rrx_eq_dc_DP_RX_IDX_0   : integer :=   34;
constant rrx_eq_dc_DP_RX_IDX_1   : integer :=   35;
constant rrx_vtt_DP_RX_IDX_0     : integer :=   36;
constant rrx_vtt_DP_RX_IDX_2     : integer :=   38;
constant rrx_sloslv_DP_RX_IDX_0  : integer :=   39;
constant rrx_sloslv_DP_RX_IDX_2  : integer :=   41;

-- PMA_3                             
--assign  pma_ctrl3_ch0_ext = {reqa_ct_ch0, reqb_ct_ch0, reqc_ct_ch0, reqd_ct_ch0, req_ctv_ch0, 1'b0};
constant reqa_ct_DP_RX_IDX_0  : integer :=      42;
constant reqa_ct_DP_RX_IDX_2  : integer :=      44;
constant reqb_ct_DP_RX_IDX_0  : integer :=      45;
constant reqb_ct_DP_RX_IDX_2  : integer :=      47;
constant reqc_ct_DP_RX_IDX_0  : integer :=      48;
constant reqc_ct_DP_RX_IDX_2  : integer :=      50;
constant reqd_ct_DP_RX_IDX_0  : integer :=      51;
constant reqd_ct_DP_RX_IDX_2  : integer :=      53;
constant req_ctv_DP_RX_IDX_0  : integer :=      54;
constant req_ctv_DP_RX_IDX_2  : integer :=      56;


-- rx - 4
--assign  trunking_mode_ext = {1'b0, rphfifo_master_sel_tx, rphfifo_master_sel_rx, 
-- 8000h same for all ch       rendec_data_sel_tx, rendec_data_sel_rx, rnenbpin, rpllurst, 
--                             rreset, rrsvd_cmu, rdeskewen, rindv_tx, rindv_rx};
constant rphfifo_master_sel_rx_DP_RX_IDX: integer :=    59;
constant rendec_data_sel_rx_DP_RX_IDX   : integer :=    60;
constant rdeskewen_DP_RX_IDX            : integer :=    61;
constant rindv_rx_DP_RX_IDX             : integer :=    62;

-- page divided into both rx and tx
-- pcs_ctrl1_ch0_ext = {rtx_pipe_enable[0], rrx_pipe_enable[0], rpowdnr[0], rpowdnt[0],
-- 8001-8004            rendec_tx[0], rendec_rx[0], r8b10b_enc_ibm_en[0], rmatchen[0],
--                      r8b10b_dec_ibm_en_ch0, rforce_kchar[0], rforce_echar[0],
--                      rlp20ben[0], rgenericfifo[0], rcascaded_8b10b_en_tx[0],
--                      rcascaded_8b10b_en_rx[0]};
constant rrx_pipe_enable_DP_RX_IDX      : integer :=    63;
constant rpowdnr_DP_RX_IDX              : integer :=    64;
constant rendec_rx_DP_RX_IDX            : integer :=    65;
constant rmatchen_DP_RX_IDX             : integer :=    66;
constant r8b10b_dec_ibm_en_DP_RX_IDX_0  : integer :=    67;
constant r8b10b_dec_ibm_en_DP_RX_IDX_1  : integer :=    68;
constant rlp20ben_DP_RX_IDX             : integer :=    69;
constant rgenericfifo_DP_RX_IDX         : integer :=    70;
constant rcascaded_8b10b_en_rx_DP_RX_IDX: integer :=    71;

-- all rx - 14
--assign  pcs_ctrl2_ch0_ext = {resync_badcg_en_ch0, rencdt_rising[0], rdis_rx_disp[0],
-- 8005-8008                   rcomp_pat_porn[0], rcomp_size_ch0, rcomp_pat_ch0[39:32]};
constant rencdt_rising_DP_RX_IDX        : integer :=    72;
constant rdis_rx_disp_DP_RX_IDX         : integer :=    73;
constant rcomp_pat_porn_DP_RX_IDX       : integer :=    74;
constant rcomp_size_DP_RX_IDX_0         : integer :=    75;
constant rcomp_size_DP_RX_IDX_2         : integer :=    77;

-- page 3 + 4 - all rx - 32
--assign  pcs_ctrl3_ch0_ext = {rcomp_pat_ch0[31:16]};
-- 8009-800c
--assign  pcs_ctrl4_ch0_ext = {rcomp_pat_ch0[15:0]};
-- 800d-8010
constant rcomp_pat_DP_RX_IDX_0          : integer :=    78;
constant rcomp_pat_DP_RX_IDX_39         : integer :=   117;

-- rx - 12
--assign  pcs_ctrl5_ch0_ext = {rrxfifo_dis[0], rtxfifo_dis[0], rib_force_disp[0],
--8011-8014                  rrundisp_ch0, rtxfifo_lowlatency_en[0], rrlv_en[0], rautobtalg_dis[0],
--                           rsync_sm_dis[0], rib_inv_cd_ch0, rrxfifo_lowlatency_en[0]};
constant rrxfifo_dis_DP_RX_IDX          : integer :=   118;
constant rrundisp_DP_RX_IDX_0           : integer :=   119;
constant rrundisp_DP_RX_IDX_5           : integer :=   124;
constant rrlv_en_DP_RX_IDX              : integer :=   125;
constant rautobtalg_dis_DP_RX_IDX       : integer :=   126;
constant rsync_sm_dis_DP_RX_IDX         : integer :=   127;
constant rib_inv_cd_DP_RX_IDX_0         : integer :=   128;
constant rib_inv_cd_DP_RX_IDX_1         : integer :=   129;
constant rrxfifo_lowlatency_en_DP_RX_IDX: integer :=   130;

-- rx - 8
--assign  pcs_ctrl6_ch0_ext = {rdwidth_tx[0], rdwidth_rx[0], rge_xaui_tx[0],
-- 8015 - 8018                 rrx_detect_bypass[0], rtxurstpcs[0], rrxurstpcs[0],
--                             rrsvd_tx_ch0, rskpsetbased[0], rtruebac2bac[0],rrsvd_rx_ch0};
--
constant rdwidth_rx_DP_RX_IDX           : integer :=   133;         
constant rrx_detect_bypass_DP_RX_IDX    : integer :=   134;       
constant rrxurstpcs_DP_RX_IDX           : integer :=   135;        
constant rskpsetbased_DP_RX_IDX         : integer :=   136;       
constant rtruebac2bac_DP_RX_IDX         : integer :=   137;        
constant rrsvd_rx_DP_RX_IDX_0           : integer :=   138;       
constant rrsvd_rx_DP_RX_IDX_1           : integer :=   139;        
constant rrsvd_rx_DP_RX_IDX_2           : integer :=   140;       

-- all rx   - 16                          
--assign  pcs_ctrl7_ch0_ext = {rgnumber_ch0, rknumber_ch0};
-- 8018 - 801c
constant rgnumber_DP_RX_IDX_0           : integer :=   141;
constant rgnumber_DP_RX_IDX_7           : integer :=   148;
constant rknumber_DP_RX_IDX_0           : integer :=   149;
constant rknumber_DP_RX_IDX_7           : integer :=   156;

-- page 8 of rx moved to first as POF used rclk_2 long ago
--assign  pcs_ctrl8_ch0_ext = {rfreerun_tx[0], rtxwrclksel[0], rtxrdclksel[0],
--801d-8020                  rfreerun_rx[0], rrcvd_clk_sel_ch0, 
--                           rclk_1_sel_ch0, rclk_2_sel_ch0, rrx_rd_clk_sel[0], 
--                           renumber_ch0, renpolinv_rx[0], rclkcmpinsertpad[0]};

-- all rx   - 26
--assign  pcs_ctrl9_ch0_ext = {rppm_cnt_reset[0], rphfifourstrx[0], rcmpfifourst[0], 
-- 8025 - 8028                 rtx_idle_delay_ch0, rclkcmpsqmd[0], rclkcmpsq1p_ch0[9:0]};
constant rppm_cnt_reset_DP_RX_IDX       : integer :=   157;
constant rphfifourstrx_DP_RX_IDX        : integer :=   158;
constant rcmpfifourst_DP_RX_IDX         : integer :=   159;
constant rtx_idle_delay_DP_RX_IDX_0     : integer :=   160;
constant rtx_idle_delay_DP_RX_IDX_1     : integer :=   161;
constant rclkcmpsqmd_DP_RX_IDX          : integer :=   162;
constant rclkcmpsq1p_DP_RX_IDX_0        : integer :=   163;
constant rclkcmpsq1p_DP_RX_IDX_19       : integer :=   182;

-- all rx - pages 10 and 11 - 21
-- 8029 - 802C
--assign  pcs_ctrl10_ch0_ext = {rclkcmpsq1n_ch0[19:15], rclkcmppos[0], rclkcmpsq1p_ch0[19:10]};
-- 802D - 8030
--assign  pcs_ctrl11_ch0_ext = {rclkcmpsq1n_ch0[14:10], 1'b0, rclkcmpsq1n_ch0[9:0]};
constant rclkcmpsq1n_DP_RX_IDX_0       : integer :=   183;
constant rclkcmpsq1n_DP_RX_IDX_19      : integer :=   202;
constant rclkcmppos_DP_RX_IDX          : integer :=   203;

-- page 12 - rx: 12
--assign  pcs_ctrl12_ch0_ext = {rrev_loopbk[0], ralempty_ch0, ralfull_ch0, rforce_disp[0], 
--                              rkchar[0], rosbased[0], rensymswap_tx[0], 1'b0, rosnumber_ch0};
constant ralempty_DP_RX_IDX_0          : integer :=   204;
constant ralempty_DP_RX_IDX_3          : integer :=   207;
constant ralfull_DP_RX_IDX_0           : integer :=   208;
constant ralfull_DP_RX_IDX_3           : integer :=   211;
constant rkchar_DP_RX_IDX              : integer :=   212;
constant rosbased_DP_RX_IDX            : integer :=   213;
constant rosnumber_DP_RX_IDX_0         : integer :=   214;
constant rosnumber_DP_RX_IDX_1         : integer :=   215;

-- page 13 - rx: 12
--assign  pcs_ctrl13_ch0_ext = {rwa_6g_en[0], renpolinv_tx[0], rbitslip_size_ch0, rbytord_2sym_en[0],
--                              rbysync_polinv_en[0], rbitloc_rev_en[0], rbyte_rev_en[0], renbitrev_tx[0],
--                              rbyteorden_ch0, rbytordplden[0], rphfifopldentx[0], rphfifoursttx[0],
--                              rphfifopldenrx[0], rautoinsdis[0]};
constant rwa_6g_en_DP_RX_IDX           : integer :=   216;
constant rbitslip_size_DP_RX_IDX_0     : integer :=   217;
constant rbitslip_size_DP_RX_IDX_1     : integer :=   218;
constant rbytord_2sym_en_DP_RX_IDX     : integer :=   219;
constant rbysync_polinv_en_DP_RX_IDX   : integer :=   220;
constant rbitloc_rev_en_DP_RX_IDX      : integer :=   221;
constant rbyte_rev_en_DP_RX_IDX        : integer :=   222;
constant rbyteorden_DP_RX_IDX_0        : integer :=   223;
constant rbyteorden_DP_RX_IDX_1        : integer :=   224;
constant rbytordplden_DP_RX_IDX        : integer :=   225;
constant rphfifopldenrx_DP_RX_IDX      : integer :=   226;
constant rautoinsdis_DP_RX_IDX         : integer :=   227;


-- page 14 - all rx
--assign  pcs_ctrl14_ch0_ext = {rppmsel_ch0, rbytordpat_ch0};
constant rppmsel_DP_RX_IDX_0           : integer :=   228;
constant rppmsel_DP_RX_IDX_5           : integer :=   233;
constant rbytordpat_DP_RX_IDX_0        : integer :=   234;
constant rbytordpat_DP_RX_IDX_9        : integer :=   243;

-- page 15
--assign  pcs_ctrl15_ch0_ext = {rtest_bus_sel_ch0, rforce_sig_det_pcs[0], rforce0_freqdet[0], 
--                              rforce1_freqdet[0], rbytordpad_ch0};
constant test_bus_sel_DP_RX_IDX_0      : integer :=   244;
constant test_bus_sel_DP_RX_IDX_2      : integer :=   246;
constant rforce_sig_det_pcs_DP_RX_IDX  : integer :=   247;
constant rforce0_freqdet_DP_RX_IDX     : integer :=   248;
constant rforce1_freqdet_DP_RX_IDX     : integer :=   249;
constant rbytordpad_DP_RX_IDX_0        : integer :=   250;
constant rbytordpad_DP_RX_IDX_9        : integer :=   259;

-- pma_ctrl8: 4.807c-807h - RX portion
--assign  pma_ctrl8_ch0_ext = {rs_lpbk[0], r_rlpbk[0], rs_rdlpbk[0], rrx_revlb_sw[0],
--                             rurx_pdb[0], rtx_cgb_pdb[0], rtx_ob_pdb[0], rrx_cru_pdb[0],
--                             rrx_cru_rst[0], rrx_ib_pdb[0], rrxurstpma[0], radce_adapt[0],
--                             radce_pdb[0], radce_rst[0], rsig_inv_2tap[0], rsig_inv_pre[0]};
constant rs_lpbk_DP_RX_IDX             : integer :=   260;
constant rrx_revlb_sw_DP_RX_IDX        : integer :=   261;

-- cru_clock_select index - SW twisted
constant cru_clock_select_DP_RX_IDX_0  : integer :=   262;
constant cru_clock_select_DP_RX_IDX_1  : integer :=   263;
constant cru_clock_select_DP_RX_IDX_2  : integer :=   264;
constant cru_clock_select_DP_RX_IDX_3  : integer :=   265;

-- passing reconfig_clk to RX ADCE
constant reconfig_clk_DP_RX_IDX        : integer :=   299;

-- MAX = 299

-- The address covers both rx(pma and dpma widths defined in RX) and tx
-- pma_ctrl4_ch0_ext = {rpmadwidth_tx[0], rpma_doublewidth_tx[0], rtx_cmu_sel[0],
-- 806Ch                rtx_m_sel_ch0, rtxvcobypass[0], rtx_cgb_1x_en[0], rtx_cgb_4x_en[0],
--                      rtx_4x_sw[0], rpmadwidth_rx[0], rpma_doublewidth_rx[0],
--                      rrxvcobypass[0],rrect_adj_ch0, rrx_piso_bypass_ch0};
constant rtx_cmu_sel_DP_TX_IDX   : integer :=            9;
constant rpmadwidth_tx_DP_TX_IDX : integer :=            10;
constant rpma_doublewidth_tx_DP_TX_IDX  : integer :=     11;
constant rtx_m_sel_DP_TX_IDX_0   : integer :=            12;
constant rtx_m_sel_DP_TX_IDX_1   : integer :=            13;
constant rtx_cgb_1x_en_DP_TX_IDX : integer :=            14;
constant rtx_cgb_4x_en_DP_TX_IDX : integer :=            15;
constant rtx_4x_sw_DP_TX_IDX     : integer :=            16;


-- tx - 3
--assign  trunking_mode_ext = {1'b0, rphfifo_master_sel_tx, rphfifo_master_sel_rx, 
-- 8000h same for all ch       rendec_data_sel_tx, rendec_data_sel_rx, rnenbpin, rpllurst, 
--                             rreset, rrsvd_cmu, rdeskewen, rindv_tx, rindv_rx};
constant rphfifo_master_sel_tx_DP_TX_IDX : integer :=    20;
constant rendec_data_sel_tx_DP_TX_IDX    : integer :=    21;
constant rindv_tx_DP_TX_IDX              : integer :=    22;

-- page divided into both rx and tx
-- pcs_ctrl1_ch0_ext = {rtx_pipe_enable[0], rrx_pipe_enable[0], rpowdnr[0], rpowdnt[0],
-- 8001-8004            rendec_tx[0], rendec_rx[0], r8b10b_enc_ibm_en[0], rmatchen[0],
--                      r8b10b_dec_ibm_en_ch0, rforce_kchar[0], rforce_echar[0],
--                      rlp20ben[0], rgenericfifo[0], rcascaded_8b10b_en_tx[0],
--                      rcascaded_8b10b_en_rx[0]};
constant rtx_pipe_enable_DP_TX_IDX   : integer     :=   25;
constant rpowdnt_DP_TX_IDX           : integer     :=   26;
constant rendec_tx_DP_TX_IDX         : integer     :=   27;
constant r8b10b_enc_ibm_en_DP_TX_IDX : integer     :=   28;
constant rforce_kchar_DP_TX_IDX      : integer     :=   29;
constant rforce_echar_DP_TX_IDX      : integer     :=   30;
constant rcascaded_8b10b_en_tx_DP_TX_IDX : integer :=   31;

-- tx - 3
--assign  pcs_ctrl5_ch0_ext = {rrxfifo_dis[0], rtxfifo_dis[0], rib_force_disp[0],
--8011-8014                  rrundisp_ch0, rtxfifo_lowlatency_en[0], rrlv_en[0], rautobtalg_dis[0],
--                           rsync_sm_dis[0], rib_inv_cd_ch0, rrxfifo_lowlatency_en[0]};
constant rtxfifo_dis_DP_TX_IDX            : integer :=  34;
constant rib_force_disp_DP_TX_IDX         : integer :=  35;
constant rtxfifo_lowlatency_en_DP_TX_IDX  : integer :=  36;

--assign  pcs_ctrl6_ch0_ext = {rdwidth_tx[0], rdwidth_rx[0], rge_xaui_tx[0],
-- 8015 - 8018                 rrx_detect_bypass[0], rtxurstpcs[0], rrxurstpcs[0],
--                             rrsvd_tx_ch0, rskpsetbased[0], rtruebac2bac[0],rrsvd_rx_ch0};
--
constant rdwidth_tx_DP_TX_IDX   : integer :=           37;
constant rge_xaui_tx_DP_TX_IDX  : integer :=           38;
constant rtxurstpcs_DP_TX_IDX   : integer :=           39;
constant rrsvd_tx_DP_TX_IDX_0   : integer :=           40;
constant rrsvd_tx_DP_TX_IDX_4   : integer :=           44;

-- page 7 PCS - all rx

-- page 8 of rx moved to first as POF used rclk_2 long ago
--assign  pcs_ctrl8_ch0_ext = {rfreerun_tx[0], rtxwrclksel[0], rtxrdclksel[0],
--801d-8020                  rfreerun_rx[0], rrcvd_clk_sel_ch0, 
--                           rclk_1_sel_ch0, rclk_2_sel_ch0, rrx_rd_clk_sel[0], 
--                           renumber_ch0, renpolinv_rx[0], rclkcmpinsertpad[0]};
constant rfreerun_tx_DP_TX_IDX  : integer :=           47;
constant rtxwrclksel_DP_TX_IDX  : integer :=           48;
constant rtxrdclksel_DP_TX_IDX  : integer :=           49;

-- page 12 - tx: 3
--assign  pcs_ctrl12_ch0_ext = {rrev_loopbk[0], ralempty_ch0, ralfull_ch0, rforce_disp[0], 
--                              rkchar[0], rosbased[0], rensymswap_tx[0], 1'b0, rosnumber_ch0};
constant rrev_loopbk_DP_TX_IDX    : integer :=         50;
constant rforce_disp_DP_TX_IDX    : integer :=         51;
constant rensymswap_tx_DP_TX_IDX  : integer :=         52;

-- page 13 - tx: 4
--assign  pcs_ctrl13_ch0_ext = {rwa_6g_en[0], renpolinv_tx[0], rbitslip_size_ch0, rbytord_2sym_en[0],
--                              rbysync_polinv_en[0], rbitloc_rev_en[0], rbyte_rev_en[0], renbitrev_tx[0],
--                              rbyteorden_ch0, rbytordplden[0], rphfifopldentx[0], rphfifoursttx[0],
--                              rphfifopldenrx[0], rautoinsdis[0]};
constant renpolinv_tx_DP_TX_IDX   : integer :=         54;
constant renbitrev_tx_DP_TX_IDX   : integer :=         55;
constant rphfifopldentx_DP_TX_IDX : integer :=         56;
constant rphfifoursttx_DP_TX_IDX  : integer :=         57;

-- pma 1 - tx
--assign  pma_ctrl1_ch0_ext = {rtx_vod_sel_ch0, rtx_slewrate[0], rpmphs_2tap_ch0,
--                             rpmphs_1tap_ch0, rtx_vtt_ch0, rpmphs_ptap_ch0};
constant rtx_vod_sel_DP_TX_IDX_0 : integer :=          60;
constant rtx_vod_sel_DP_TX_IDX_2 : integer :=          62;
constant rtx_slewrate_DP_TX_IDX  : integer :=          63;
constant rpmphs_2tap_DP_TX_IDX_0 : integer :=          64;
constant rpmphs_2tap_DP_TX_IDX_2 : integer :=          66;
constant rpmphs_1tap_DP_TX_IDX_0 : integer :=          67;
constant rpmphs_1tap_DP_TX_IDX_3 : integer :=          70;
constant rtx_vtt_DP_TX_IDX_0     : integer :=          71;
constant rtx_vtt_DP_TX_IDX_1     : integer :=          72;
constant rpmphs_ptap_DP_TX_IDX_0 : integer :=          73;
constant rpmphs_ptap_DP_TX_IDX_2 : integer :=          75;

-- pma_ctrl8: 4.807c-807h - TX portion
--assign  pma_ctrl8_ch0_ext = {rs_lpbk[0], r_rlpbk[0], rs_rdlpbk[0], rrx_revlb_sw[0],
--                             rurx_pdb[0], rtx_cgb_pdb[0], rtx_ob_pdb[0], rrx_cru_pdb[0],
--                             rrx_cru_rst[0], rrx_ib_pdb[0], rrxurstpma[0], radce_adapt[0],
--                             radce_pdb[0], radce_rst[0], rsig_inv_2tap[0], rsig_inv_pre[0]};
constant r_rlpbk_DP_TX_IDX       : integer :=          76;
constant rs_rdlpbk_DP_TX_IDX     : integer :=          77;
constant rsig_inv_2tap_DP_TX_IDX : integer :=          78;
constant rsig_inv_pre_DP_TX_IDX  : integer :=          79;

-- tx_max = 149 ------------------------------------------------------------------------

-- Global Trunk 
-- PMA_GLOBAL_CTRL_4
-- assign  pma_global_ctrl4_ext = {rcmu0_m, rcmu1_m, rcmu0_l, rcmu1_l, rcmu0_pdb, rcmu1_pdb,
--                                rcmu0_txpll_rst, rcmu1_txpll_rst};

constant rcmu_m_DP_CMUPLL_IDX_0            : integer :=     0;
constant rcmu_m_DP_CMUPLL_IDX_7            : integer :=     7;
constant rcmu_l_DP_CMUPLL_IDX_0            : integer :=     8;
constant rcmu_l_DP_CMUPLL_IDX_7            : integer :=     15;
constant rcmu_pdb_DP_CMUPLL_IDX            : integer :=     16;
constant rcmu_txpll_rst_DP_CMUPLL_IDX      : integer :=     17;
constant refclk_select_DP_CMUPLL_IDX_0     : integer :=     18;
constant refclk_select_DP_CMUPLL_IDX_1     : integer :=     19;
constant refclk_select_DP_CMUPLL_IDX_2     : integer :=     20;
constant refclk_select_DP_CMUPLL_IDX_3     : integer :=     21;

-- index to the PHYSICAL lines of CRU_CLOCK_SELECT ----------------------------------------
constant CRU_CLOCK_SELECT_NONE         : integer :=     0;
constant CRU_CLOCK_SELECT_REFCLK0      : integer :=     1;
constant CRU_CLOCK_SELECT_REFCLK1      : integer :=     2;
constant CRU_CLOCK_SELECT_IQ0          : integer :=     3;
constant CRU_CLOCK_SELECT_IQ1          : integer :=     4;
constant CRU_CLOCK_SELECT_IQ2          : integer :=     5;
constant CRU_CLOCK_SELECT_IQ3          : integer :=     6;
constant CRU_CLOCK_SELECT_IQ4          : integer :=     7;
constant CRU_CLOCK_SELECT_PLD_CRU_CLK  : integer :=     8;
constant CRU_CLOCK_SELECT_CMU_DIV_CLK  : integer :=     9;

-- index to the PHYSICAL lines of CMUPLL refclk select ------------------------------------
constant CMUPLL_CLOCK_SELECT_IQ0            : integer :=     0;
constant CMUPLL_CLOCK_SELECT_IQ1            : integer :=     1;
constant CMUPLL_CLOCK_SELECT_IQ2            : integer :=     2;
constant CMUPLL_CLOCK_SELECT_IQ3            : integer :=     3;
constant CMUPLL_CLOCK_SELECT_IQ4            : integer :=     4;
constant CMUPLL_CLOCK_SELECT_PLD_CLK        : integer :=     5;
constant CMUPLL_CLOCK_SELECT_REFCLK0        : integer :=     6;
constant CMUPLL_CLOCK_SELECT_REFCLK1        : integer :=     7;
constant CMUPLL_CLOCK_SELECT_ERR            : integer :=     8;

-- begin of CMUPLL
FUNCTION convert_cmupll_m_in_to_cram (
             tmp_cmupll_m : IN STD_LOGIC_VECTOR(7 DOWNTO 0)) 
             RETURN STD_LOGIC_VECTOR IS
             VARIABLE res : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";
BEGIN
    res := "0000";
    IF    (tmp_cmupll_m = "00011001") THEN -- 8'd25
        res := "1000";
    ELSIF (tmp_cmupll_m = "00010100") THEN -- 20
        res := "0111";
    ELSIF (tmp_cmupll_m = "00010000") THEN -- 16
        res := "0110";
    ELSIF (tmp_cmupll_m = "00001010") THEN -- 10
        res := "0101";
    ELSIF (tmp_cmupll_m = "00001000") THEN  -- 8
        res := "0100";
    ELSIF (tmp_cmupll_m = "00000101") THEN  -- 5
        res := "0011";
    ELSIF (tmp_cmupll_m = "00000100") THEN  -- 4
        res := "0010";
    ELSIF (tmp_cmupll_m = "00000001") THEN  -- 1
        res := "0000";
    ELSE
        res := "1111";  -- illegal value on purpose
    END IF;
                     
    RETURN res;
END convert_cmupll_m_in_to_cram;

FUNCTION convert_cmupll_l_in_to_cram (
             tmp_cmupll_l : IN STD_LOGIC_VECTOR(7 DOWNTO 0)) 
             RETURN STD_LOGIC_VECTOR IS
             VARIABLE res : STD_LOGIC_VECTOR(1 DOWNTO 0) := "00";
BEGIN
    res := "00";
    IF    (tmp_cmupll_l = "00000001") THEN  -- 1
        res := "00";
    ELSIF (tmp_cmupll_l = "00000010") THEN  -- 2
        res := "01";
    ELSIF (tmp_cmupll_l = "00000100") THEN  -- 4 
        res := "10";
    ELSE
        res := "11";  -- illegal value on purpose
    END IF;
                     
    RETURN res;
END convert_cmupll_l_in_to_cram;

FUNCTION convert_cram_to_cmupll_m_out(
             tmp_cmupll_m : IN STD_LOGIC_VECTOR(3 DOWNTO 0)) 
             RETURN STD_LOGIC_VECTOR IS
             VARIABLE res : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000";
BEGIN
    res := "00000000";
    IF    (tmp_cmupll_m = "1000") THEN
        res := "00011001";  -- 25
    ELSIF (tmp_cmupll_m = "0111") THEN 
        res := "00010100";  -- 20
    ELSIF (tmp_cmupll_m = "0110") THEN 
        res := "00010000";  -- 16
    ELSIF (tmp_cmupll_m = "0101") THEN 
        res := "00001010";  -- 10
    ELSIF (tmp_cmupll_m = "0100") THEN  
        res := "00001000";   -- 8
    ELSIF (tmp_cmupll_m = "0011") THEN  
        res := "00000101";   -- 5
    ELSIF (tmp_cmupll_m = "0010") THEN  
        res := "00000100";   -- 4
    ELSIF (tmp_cmupll_m = "0000") THEN  
        res := "00000001";   -- 1
    ELSE
        res := "00000001";   -- 1
    END IF;
                     
    RETURN res;
END convert_cram_to_cmupll_m_out;

FUNCTION convert_cram_to_cmupll_l_out(
             tmp_cmupll_l : IN STD_LOGIC_VECTOR(1 DOWNTO 0)) 
             RETURN STD_LOGIC_VECTOR IS
             VARIABLE res : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000";
BEGIN
    res := "00000000";
    IF    (tmp_cmupll_l = "00") THEN
        res := "00000001";
    ELSIF (tmp_cmupll_l = "01") THEN 
        res := "00000010";
    ELSIF (tmp_cmupll_l = "10") THEN 
        res := "00000100";
    ELSE
        res := "00000001";
    END IF;
                     
    RETURN res;
END convert_cram_to_cmupll_l_out;

-- slight difference of refclk on pll0 and pll1
FUNCTION convert_cmupll0_clock_cram_to_phyport (
             rrefclk_sel : IN STD_LOGIC_VECTOR(1 DOWNTO 0); 
             pldiq       : IN STD_LOGIC_VECTOR(2 DOWNTO 0)) 
             RETURN INTEGER IS
             VARIABLE res : INTEGER := CMUPLL_CLOCK_SELECT_ERR;
BEGIN
    res := CMUPLL_CLOCK_SELECT_ERR;
    IF    (rrefclk_sel = "00") THEN
        res := CMUPLL_CLOCK_SELECT_REFCLK0;
    ELSIF (rrefclk_sel = "01") THEN
        res := CMUPLL_CLOCK_SELECT_REFCLK1;
    ELSIF (pldiq = "000") THEN
        res := CMUPLL_CLOCK_SELECT_IQ0;
    ELSIF (pldiq = "001") THEN
        res := CMUPLL_CLOCK_SELECT_IQ1;
    ELSIF (pldiq = "010") THEN
        res := CMUPLL_CLOCK_SELECT_IQ2;
    ELSIF (pldiq = "011") THEN
        res := CMUPLL_CLOCK_SELECT_IQ3;
    ELSIF (pldiq = "100") THEN
        res := CMUPLL_CLOCK_SELECT_IQ4;
    ELSIF (pldiq = "101") THEN
        res := CMUPLL_CLOCK_SELECT_PLD_CLK;
    ELSE
        res := CMUPLL_CLOCK_SELECT_ERR;    
    END IF;
                     
    RETURN res;
END convert_cmupll0_clock_cram_to_phyport;

FUNCTION convert_cmupll1_clock_cram_to_phyport (
             rrefclk_sel : IN STD_LOGIC_VECTOR(1 DOWNTO 0); 
             pldiq       : IN STD_LOGIC_VECTOR(2 DOWNTO 0)) 
             RETURN INTEGER IS
             VARIABLE res : INTEGER := CMUPLL_CLOCK_SELECT_ERR;
BEGIN
    res := CMUPLL_CLOCK_SELECT_ERR;
    IF    (rrefclk_sel = "00") THEN
        res := CMUPLL_CLOCK_SELECT_REFCLK1;
    ELSIF (rrefclk_sel = "01") THEN
        res := CMUPLL_CLOCK_SELECT_REFCLK0;
    ELSIF (pldiq = "000") THEN
        res := CMUPLL_CLOCK_SELECT_IQ0;
    ELSIF (pldiq = "001") THEN
        res := CMUPLL_CLOCK_SELECT_IQ1;
    ELSIF (pldiq = "010") THEN
        res := CMUPLL_CLOCK_SELECT_IQ2;
    ELSIF (pldiq = "011") THEN
        res := CMUPLL_CLOCK_SELECT_IQ3;
    ELSIF (pldiq = "100") THEN
        res := CMUPLL_CLOCK_SELECT_IQ4;
    ELSIF (pldiq = "101") THEN
        res := CMUPLL_CLOCK_SELECT_PLD_CLK;
    ELSE
        res := CMUPLL_CLOCK_SELECT_ERR;    
    END IF;
                     
    RETURN res;
END convert_cmupll1_clock_cram_to_phyport;

-- input is at most 15 char
FUNCTION convert_cmupll_phyport_str_to_phyport_enum(
             phyport_str : IN STRING) 
             RETURN INTEGER IS
             VARIABLE res : INTEGER := 0;
BEGIN
    res := CMUPLL_CLOCK_SELECT_ERR;
    IF (phyport_str = "iq0") THEN
        res := CMUPLL_CLOCK_SELECT_IQ0;
    ELSIF (phyport_str = "iq1") THEN
        res := CMUPLL_CLOCK_SELECT_IQ1;
    ELSIF (phyport_str = "iq2") THEN
        res := CMUPLL_CLOCK_SELECT_IQ2;
    ELSIF (phyport_str = "iq3") THEN
        res := CMUPLL_CLOCK_SELECT_IQ3;
    ELSIF (phyport_str = "iq4") THEN
        res := CMUPLL_CLOCK_SELECT_IQ4;
    ELSIF (phyport_str = "refclk0" OR phyport_str = "clkrefclk0") THEN
        res := CMUPLL_CLOCK_SELECT_REFCLK0;
    ELSIF (phyport_str = "refclk1" OR phyport_str = "clkrefclk1") THEN
        res := CMUPLL_CLOCK_SELECT_REFCLK1;
    ELSIF (phyport_str = "pld_clk") THEN
        res := CMUPLL_CLOCK_SELECT_PLD_CLK;
    ELSE 
        res := CMUPLL_CLOCK_SELECT_ERR;
    END IF;
         
    RETURN res;
END convert_cmupll_phyport_str_to_phyport_enum;
-- END of CMUPLL

FUNCTION dprio_reg_to_int(arg : IN STD_LOGIC_VECTOR) RETURN INTEGER IS
    VARIABLE result : INTEGER;
BEGIN
    result := 0;
    FOR i IN arg'RANGE LOOP
       IF arg(i) = '1' THEN
           result := result + 2**i;
       END IF;
    END LOOP;
    RETURN result;
END dprio_reg_to_int;

FUNCTION convert_cru_clock_cram_to_phyport (
            rrefclk_sel  : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
            ser_bypass   : IN STD_LOGIC_VECTOR(1 DOWNTO 0)) RETURN INTEGER IS
                    
            VARIABLE res : INTEGER := 0;   
            -- VARIABLE txt : LINE;
BEGIN
    res := 0;
    IF (ser_bypass = "00") THEN
                         res := CRU_CLOCK_SELECT_REFCLK0;
    ELSIF (ser_bypass = "01") THEN
                         res := CRU_CLOCK_SELECT_REFCLK1;
    ELSIF (ser_bypass = "10") THEN
                         res := CRU_CLOCK_SELECT_CMU_DIV_CLK;
    ELSIF (rrefclk_sel = "000") THEN
                         res := CRU_CLOCK_SELECT_IQ0;
    ELSIF (rrefclk_sel = "001") THEN
                         res := CRU_CLOCK_SELECT_IQ1;
    ELSIF (rrefclk_sel = "010") THEN
                         res := CRU_CLOCK_SELECT_IQ2;
    ELSIF (rrefclk_sel = "011") THEN
                         res := CRU_CLOCK_SELECT_IQ3;
    ELSIF (rrefclk_sel = "100") THEN
                         res := CRU_CLOCK_SELECT_IQ4;
    ELSIF (rrefclk_sel = "101") THEN
                         res := CRU_CLOCK_SELECT_PLD_CRU_CLK;
    ELSE
                 res := CRU_CLOCK_SELECT_REFCLK0;
                 --WRITE(TXT,STRING'("Invalid CRAM from DPRIO ser_bypass and rrefclk_sel")); 
                 --WRITELINE(OUTPUT,TXT);         
    END IF;
    RETURN res;    
END convert_cru_clock_cram_to_phyport;

-- CMU PLL reconfiguration ---------------------------------------------------

-- M/L and powerdown - read from dprioin
SIGNAL tmp_cmupll_m0 : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL tmp_cmupll_l0 : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL tmp_cmupll_m1 : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL tmp_cmupll_l1 : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL tmp_cmupll_m2 : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL tmp_cmupll_l2 : STD_LOGIC_VECTOR(7 DOWNTO 0);
-- then converted into rcmu0_m and rcmu0_l

-- M/L and powerdown - write to dprioout
-- converted from rcmu0_int into counter settings
SIGNAL tmp_cmupll_m0_int : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL tmp_cmupll_l0_int : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL tmp_cmupll_m1_int : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL tmp_cmupll_l1_int : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL tmp_cmupll_m2_int : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL tmp_cmupll_l2_int : STD_LOGIC_VECTOR(7 DOWNTO 0);
-- then send to dprioout

--- refclk selection -----------------------------------------------
--rcmu0_ref_sel_int, rcmu1_ref_sel_int
--rcmu_txpll0_iqclkin_sel_int,rcmu_txpll1_iqclkin_sel_int

-- local table - refclk_clock_physical_port <--> rcmu0_ref_sel[1:0] and 
--                    rcmu_txpll0_iqclkin_sel[2:0]
--   right hand side of table: 
--                             [5:4] = rcmu0_ref_sel
--                             [2:0] = rcmu_txpll0_iqclkin_sel 
-- *** pll number in this table is physical number ***
SIGNAL cmupll0_clock_phyport_to_cram : DPRIO_REG_ARRAY_OF_VEC (8 DOWNTO 0) := (OTHERS => "000000");
SIGNAL cmupll1_clock_phyport_to_cram : DPRIO_REG_ARRAY_OF_VEC (8 DOWNTO 0) := (OTHERS => "000000");

--  cru_clock_select_physical_mapping strings --> ENUM table
SIGNAL cmupll0_clock_index_to_phyport : DPRIO_REG_ARRAY_OF_INT (7 DOWNTO 0) := (OTHERS => 0);
SIGNAL cmupll1_clock_index_to_phyport : DPRIO_REG_ARRAY_OF_INT (7 DOWNTO 0) := (OTHERS => 0);


-- for cmupll_clock_select input

SIGNAL tmp_cmupll0_clock_select_vec : STD_LOGIC_VECTOR (2 DOWNTO 0) := (OTHERS => '0'); 
SIGNAL cmupll0_clock_select  : INTEGER := 0;
SIGNAL cmupll0_clock_phyport : INTEGER := 0;
SIGNAL cmupll0_clock_phyport_phy : INTEGER := 0; -- phyport on physical pll0
SIGNAL cmupll0_clock_cram_phy : STD_LOGIC_VECTOR(5 DOWNTO 0);

SIGNAL tmp_cmupll1_clock_select_vec : STD_LOGIC_VECTOR (2 DOWNTO 0) := (OTHERS => '0'); 
SIGNAL cmupll1_clock_select  : INTEGER := 0;
SIGNAL cmupll1_clock_phyport : INTEGER := 0;
SIGNAL cmupll1_clock_phyport_phy : INTEGER := 0; -- phyport on physical pll1
SIGNAL cmupll1_clock_cram_phy : STD_LOGIC_VECTOR(5 DOWNTO 0);
  
-- for cmupll_clock_select output

SIGNAL cmupll0_clock_phyport_out : INTEGER; 
SIGNAL cmupll0_clock_select_out  : STD_LOGIC_VECTOR(3 DOWNTO 0);
SIGNAL cmupll1_clock_phyport_out : INTEGER; 
SIGNAL cmupll1_clock_select_out  : STD_LOGIC_VECTOR(3 DOWNTO 0);

SIGNAL cmupll0_clock_phyport_out_logic  : INTEGER; 
SIGNAL cmupll0_clock_select_out_logic   : STD_LOGIC_VECTOR(3 DOWNTO 0);
SIGNAL cmupll1_clock_phyport_out_logic  : INTEGER; 
SIGNAL cmupll1_clock_select_out_logic   : STD_LOGIC_VECTOR(3 DOWNTO 0);

-- cru_clock_select -------------------------------------------
SIGNAL cru_clock_phyport_to_cram      : DPRIO_REG_ARRAY_OF_VEC (9 DOWNTO 0) := (OTHERS => "000000");
SIGNAL rx0_cru_clock_index_to_phyport : DPRIO_REG_ARRAY_OF_INT (9 DOWNTO 0) := (OTHERS => 0);
SIGNAL rx1_cru_clock_index_to_phyport : DPRIO_REG_ARRAY_OF_INT (9 DOWNTO 0) := (OTHERS => 0);
SIGNAL rx2_cru_clock_index_to_phyport : DPRIO_REG_ARRAY_OF_INT (9 DOWNTO 0) := (OTHERS => 0);
SIGNAL rx3_cru_clock_index_to_phyport : DPRIO_REG_ARRAY_OF_INT (9 DOWNTO 0) := (OTHERS => 0);

SIGNAL tmp_rx0_cru_clock_select_vec : STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0'); 
SIGNAL rx0_cru_clock_select  : INTEGER := 0;
SIGNAL rx0_cru_clock_phyport : INTEGER := 0;
SIGNAL rx0_cru_clock_cram_logic : STD_LOGIC_VECTOR(5 DOWNTO 0);
SIGNAL rx0_cru_clock_cram_phy   : STD_LOGIC_VECTOR(5 DOWNTO 0);

SIGNAL tmp_rx1_cru_clock_select_vec : STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0'); 
SIGNAL rx1_cru_clock_select  : INTEGER := 0;
SIGNAL rx1_cru_clock_phyport : INTEGER := 0;
SIGNAL rx1_cru_clock_cram_logic : STD_LOGIC_VECTOR(5 DOWNTO 0);
SIGNAL rx1_cru_clock_cram_phy   : STD_LOGIC_VECTOR(5 DOWNTO 0);

SIGNAL tmp_rx2_cru_clock_select_vec : STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0'); 
SIGNAL rx2_cru_clock_select  : INTEGER := 0;
SIGNAL rx2_cru_clock_phyport : INTEGER := 0;
SIGNAL rx2_cru_clock_cram_logic : STD_LOGIC_VECTOR(5 DOWNTO 0);
SIGNAL rx2_cru_clock_cram_phy   : STD_LOGIC_VECTOR(5 DOWNTO 0);

SIGNAL tmp_rx3_cru_clock_select_vec : STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0'); 
SIGNAL rx3_cru_clock_select  : INTEGER := 0;
SIGNAL rx3_cru_clock_phyport : INTEGER := 0;
SIGNAL rx3_cru_clock_cram_logic : STD_LOGIC_VECTOR(5 DOWNTO 0);
SIGNAL rx3_cru_clock_cram_phy   : STD_LOGIC_VECTOR(5 DOWNTO 0);

-- for output
SIGNAL rx0_cru_clock_phyport_out : INTEGER := 0;
SIGNAL rx0_cru_clock_select_out  : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";
SIGNAL rx1_cru_clock_phyport_out : INTEGER := 0;
SIGNAL rx1_cru_clock_select_out  : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";
SIGNAL rx2_cru_clock_phyport_out : INTEGER := 0;
SIGNAL rx2_cru_clock_select_out  : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";
SIGNAL rx3_cru_clock_phyport_out : INTEGER := 0;
SIGNAL rx3_cru_clock_select_out  : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";

SIGNAL rx0_cru_clock_phyport_out_logic : INTEGER := 0;
SIGNAL rx0_cru_clock_select_out_logic  : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";
SIGNAL rx1_cru_clock_phyport_out_logic : INTEGER := 0;
SIGNAL rx1_cru_clock_select_out_logic  : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";
SIGNAL rx2_cru_clock_phyport_out_logic : INTEGER := 0;
SIGNAL rx2_cru_clock_select_out_logic  : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";
SIGNAL rx3_cru_clock_phyport_out_logic : INTEGER := 0;
SIGNAL rx3_cru_clock_select_out_logic  : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";

-- rtx_cmu_sel - tx_clock_divider_refclk_selection
SIGNAL rtx_cmu_sel_logic     : STD_LOGIC_VECTOR(3 DOWNTO 0); -- phy pll index on logic tx channel
SIGNAL rtx_cmu_sel_int_logic : STD_LOGIC_VECTOR(3 DOWNTO 0); -- phy pll index on logic tx channel
SIGNAL tx_refclk_select_out  : STD_LOGIC_VECTOR(3 DOWNTO 0);  -- logic pll index
SIGNAL tx_refclk_select_out_phy  : STD_LOGIC_VECTOR(3 DOWNTO 0);  -- physical channel's refclk

-- name twists between WYSIWYG and RTL ----------------------------------------
SIGNAL jtag_shift_load : std_logic;      -- in

-- un-supported ports - turning into wires ------------------------------------
-- inputs get initialized appropriately

-- JTAG inputs/outputs
SIGNAL          jtag_mode : std_logic := '0';            -- in
SIGNAL          jtag_si : std_logic := 'X';              -- in
     
SIGNAL         jtag_so : std_logic;               -- out

-- input - status signals generated by PCS
SIGNAL          tx_local_fault : std_logic := '0';        -- from tx_sm
SIGNAL          rx_local_fault : std_logic := '0';        -- from rcv_sm
SIGNAL          xs_link_status : std_logic := '0';        -- from rcv_sm

-- ouptut
SIGNAL         local_fault_ext : std_logic;       -- Status signal wire
SIGNAL         xs_link_status_ext : std_logic;    -- Status signal wire
SIGNAL         rx_local_fault_ext : std_logic;    -- Status signal wire
SIGNAL         tx_local_fault_ext : std_logic;    -- Status signal wire

-- Unused CRAMs
SIGNAL          rxs_link_status_set : std_logic;        -- in
SIGNAL          rtx_rx_local_fault_clr : std_logic;     -- in

SIGNAL         rxs_link_status_set_int : std_logic;     -- out
SIGNAL         rtx_rx_local_fault_clr_int : std_logic;  -- out

------------------------------------------------------------------------------------------------------
--              Beginning of named CRAMs                                                            --
------------------------------------------------------------------------------------------------------

-- TX PCS CRAMs wire from CSR ----------------------------------------------------------------------
SIGNAL   rpowdnt :  std_logic_vector (3 DOWNTO 0);               -- TX channel power down CRAM
SIGNAL   rtxurstpcs :  std_logic_vector (3 DOWNTO 0);            -- Gated CRAM for TXURSTPCS
SIGNAL   rbisten_tx :  std_logic_vector (3 DOWNTO 0);               -- ENBIST CRAM
SIGNAL   rrev_loopbk  :  std_logic_vector (3 DOWNTO 0);	      -- CRAM - Enable dynamic Reverse, PIPE mode
SIGNAL   rforce_disp    :  std_logic_vector (3 DOWNTO 0);	      -- Acting with TXD[9, 19] forces current disparity to 1 or 0
SIGNAL   rib_force_disp :  std_logic_vector (3 DOWNTO 0);        -- Disparity force CRAM in IB mode
SIGNAL   rforce_echar :  std_logic_vector (3 DOWNTO 0);          -- Force /E/ char CRAM
SIGNAL   rforce_kchar :  std_logic_vector (3 DOWNTO 0);          -- Force /K/ char CRAM
SIGNAL   rendec_tx :  std_logic_vector (3 DOWNTO 0);             -- Enable 8B/10B encoder CRAM
SIGNAL   rge_xaui_tx :  std_logic_vector (3 DOWNTO 0);           -- GIGE Idle test enable CRAM
SIGNAL   rdwidth_tx :  std_logic_vector (3 DOWNTO 0);            -- TX parallel interface data width CRAM
SIGNAL   rtxfifo_dis :  std_logic_vector (3 DOWNTO 0);           -- TX FIFO disable CRAM
SIGNAL   rcascaded_8b10b_en_tx :  std_logic_vector (3 DOWNTO 0); -- Caascaded 8b/10b encoder enable CRAM
SIGNAL   rprbsen_tx :  std_logic_vector (3 DOWNTO 0);            -- PRBS generator enable CRAM
SIGNAL   rprbs_sel_ch0 :  std_logic_vector (2 DOWNTO 0);         -- PRBS selection CRAM
SIGNAL   rprbs_sel_ch1 :  std_logic_vector (2 DOWNTO 0);         -- PRBS selection CRAM
SIGNAL   rprbs_sel_ch2 :  std_logic_vector (2 DOWNTO 0);         -- PRBS selection CRAM
SIGNAL   rprbs_sel_ch3 :  std_logic_vector (2 DOWNTO 0);         -- PRBS selection CRAM
SIGNAL   rbist_sel_ch0 :  std_logic_vector (1 DOWNTO 0);         -- BIST selection CRAM
SIGNAL   rbist_sel_ch1 :  std_logic_vector (1 DOWNTO 0);         -- BIST selection CRAM
SIGNAL   rbist_sel_ch2 :  std_logic_vector (1 DOWNTO 0);         -- BIST selection CRAM
SIGNAL   rbist_sel_ch3 :  std_logic_vector (1 DOWNTO 0);         -- BIST selection CRAM
SIGNAL   rcxpat_chnl_en_ch0 :  std_logic_vector (1 DOWNTO 0);    -- CRPAT or CJPAT selection CRAM
SIGNAL   rcxpat_chnl_en_ch1 :  std_logic_vector (1 DOWNTO 0);    -- CRPAT or CJPAT selection CRAM
SIGNAL   rcxpat_chnl_en_ch2 :  std_logic_vector (1 DOWNTO 0);    -- CRPAT or CJPAT selection CRAM
SIGNAL   rcxpat_chnl_en_ch3 :  std_logic_vector (1 DOWNTO 0);    -- CRPAT or CJPAT selection CRAM
SIGNAL   renpolinv_tx :  std_logic_vector (3 DOWNTO 0);          -- TX Polarity inversion enable CRAM
SIGNAL   rphfifopldentx :  std_logic_vector (3 DOWNTO 0);        -- TX phase comp. FIFO PLD read/write enable CRAM
SIGNAL   rphfifoursttx :  std_logic_vector (3 DOWNTO 0);         -- TX phase comp. FIFO user reset enable CRAM
SIGNAL   rfreerun_tx :  std_logic_vector (3 DOWNTO 0);           -- TX_CLK out free running during TX PCS reset enable CRAM
SIGNAL   rtxwrclksel :  std_logic_vector (3 DOWNTO 0);           -- TX FIFO write clock selection CRAM
SIGNAL   rtxrdclksel :  std_logic_vector (3 DOWNTO 0);           -- TX FIFO read clock selection CRAM
SIGNAL   rtx_pipe_enable :  std_logic_vector (3 DOWNTO 0);       -- TX PIPE interface enable CRAM
SIGNAL   renbitrev_tx :  std_logic_vector (3 DOWNTO 0);          -- TX bit reversal enable CRAM
SIGNAL   rensymswap_tx :  std_logic_vector (3 DOWNTO 0);         -- TX symbol swap enable CRAM
SIGNAL   r8b10b_enc_ibm_en :  std_logic_vector (3 DOWNTO 0);     -- 8B10B Encoder fix enable CRAM
SIGNAL   rtxfifo_lowlatency_en :  std_logic_vector (3 DOWNTO 0); -- TX FIFO low latency enable CRAM
SIGNAL   rtx_idle_delay_ch0 :  std_logic_vector (1 DOWNTO 0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL   rtx_idle_delay_ch1 :  std_logic_vector (1 DOWNTO 0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL   rtx_idle_delay_ch2 :  std_logic_vector (1 DOWNTO 0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL   rtx_idle_delay_ch3 :  std_logic_vector (1 DOWNTO 0);    -- PIPE TxElecIdle delay value CRAM

-- TX PCS CRAMs outputs to TX PCS : ending with _int --------------------------------------------------------------

-- TX PMA CRAMs --------------------------------------------------------------------------------
SIGNAL    rpmadwidth_tx :  std_logic_vector (3 DOWNTO 0);         -- TX PCS to TX PMA data width selection CRAM
SIGNAL    rpma_doublewidth_tx :  std_logic_vector (3 DOWNTO 0);   -- PCS/PMA double width (16/20) selection CRAM
SIGNAL    rtx_term_ch0 :  std_logic_vector (1 DOWNTO 0);          -- TX output buffer termination select CRAMs
SIGNAL    rtx_term_ch1 :  std_logic_vector (1 DOWNTO 0);          -- TX output buffer termination select CRAMs
SIGNAL    rtx_term_ch2 :  std_logic_vector (1 DOWNTO 0);          -- TX output buffer termination select CRAMs
SIGNAL    rtx_term_ch3 :  std_logic_vector (1 DOWNTO 0);          -- TX output buffer termination select CRAMs
SIGNAL    rtx_vod_sel_ch0 :  std_logic_vector (2 DOWNTO 0);       -- TX output buffer Vod switching control CRAMs
SIGNAL    rtx_vod_sel_ch1 :  std_logic_vector (2 DOWNTO 0);       -- TX output buffer Vod switching control CRAMs
SIGNAL    rtx_vod_sel_ch2 :  std_logic_vector (2 DOWNTO 0);       -- TX output buffer Vod switching control CRAMs
SIGNAL    rtx_vod_sel_ch3 :  std_logic_vector (2 DOWNTO 0);       -- TX output buffer Vod switching control CRAMs
SIGNAL    rpmphs_1tap_ch0 :  std_logic_vector (3 DOWNTO 0);       -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL    rpmphs_1tap_ch1 :  std_logic_vector (3 DOWNTO 0);       -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL    rpmphs_1tap_ch2 :  std_logic_vector (3 DOWNTO 0);       -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL    rpmphs_1tap_ch3 :  std_logic_vector (3 DOWNTO 0);       -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL    rtx_slewrate :  std_logic_vector (3 DOWNTO 0);          -- Slew rate control CRAM
SIGNAL    rlst_tx_ch0 :  std_logic_vector (3 DOWNTO 0);           -- Low speed Test selection CRAMs
SIGNAL    rlst_tx_ch1 :  std_logic_vector (3 DOWNTO 0);           -- Low speed Test selection CRAMs
SIGNAL    rlst_tx_ch2 :  std_logic_vector (3 DOWNTO 0);           -- Low speed Test selection CRAMs
SIGNAL    rlst_tx_ch3 :  std_logic_vector (3 DOWNTO 0);           -- Low speed Test selection CRAMs
SIGNAL    rtx_cmu_sel :  std_logic_vector (3 DOWNTO 0);           -- CMU selection CRAM
SIGNAL    rtx_m_sel_ch0 :  std_logic_vector (1 DOWNTO 0);         -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL    rtx_m_sel_ch1 :  std_logic_vector (1 DOWNTO 0);         -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL    rtx_m_sel_ch2 :  std_logic_vector (1 DOWNTO 0);         -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL    rtx_m_sel_ch3 :  std_logic_vector (1 DOWNTO 0);         -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL    rtxvcobypass :  std_logic_vector (3 DOWNTO 0);          -- TX VCO bypass CRAM
SIGNAL    rtx_cgb_1x_en :  std_logic_vector (3 DOWNTO 0);         -- Single CLKGENBUF mode enable CRAM
SIGNAL    rtx_cgb_4x_en :  std_logic_vector (3 DOWNTO 0);         -- Quad CLKGENBUF mode enable CRAM
SIGNAL    rtx_4x_sw :  std_logic_vector (3 DOWNTO 0);   	      -- Xaui mode (CPULSE aligned across 4 channels) selection CRAM
SIGNAL    rsig_inv_2tap :  std_logic_vector (3 DOWNTO 0);         -- Pre-emphasis FIR-tap selection CRAM
SIGNAL    rpmphs_ptap_ch0 :  std_logic_vector (2 DOWNTO 0);       -- Control CRAM
SIGNAL    rpmphs_ptap_ch1 :  std_logic_vector (2 DOWNTO 0);       -- Control CRAM
SIGNAL    rpmphs_ptap_ch2 :  std_logic_vector (2 DOWNTO 0);       -- Control CRAM
SIGNAL    rpmphs_ptap_ch3 :  std_logic_vector (2 DOWNTO 0);       -- Control CRAM
SIGNAL    rtx_cgb_pdb :  std_logic_vector (3 DOWNTO 0);           -- Power down (bar) CRAM for CLKGENBUF6G
SIGNAL    rtx_ob_pdb :  std_logic_vector (3 DOWNTO 0);            -- Power down (bar) CRAM for output buffer
SIGNAL    r_tx_det_rx_ch0 :  std_logic_vector (1 DOWNTO 0);       -- RX Detect block CRAMs
SIGNAL    r_tx_det_rx_ch1 :  std_logic_vector (1 DOWNTO 0);       -- RX Detect block CRAMs
SIGNAL    r_tx_det_rx_ch2 :  std_logic_vector (1 DOWNTO 0);       -- RX Detect block CRAMs
SIGNAL    r_tx_det_rx_ch3 :  std_logic_vector (1 DOWNTO 0);       -- RX Detect block CRAMs
SIGNAL    rpmphs_2tap_ch0 :  std_logic_vector (2 DOWNTO 0);       -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL    rpmphs_2tap_ch1 :  std_logic_vector (2 DOWNTO 0);       -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL    rpmphs_2tap_ch2 :  std_logic_vector (2 DOWNTO 0);       -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL    rpmphs_2tap_ch3 :  std_logic_vector (2 DOWNTO 0);       -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL    rtx_vtt_ch0 :  std_logic_vector (1 DOWNTO 0);           -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL    rtx_vtt_ch1 :  std_logic_vector (1 DOWNTO 0);           -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL    rtx_vtt_ch2 :  std_logic_vector (1 DOWNTO 0);           -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL    rtx_vtt_ch3 :  std_logic_vector (1 DOWNTO 0);           -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL    rsig_inv_pre :  std_logic_vector (3 DOWNTO 0);          -- Enable CRAM for SIG_INV_PRE dynamic control signal
SIGNAL    rrsvd_tx_ch0 :  std_logic_vector (4 DOWNTO 0);          -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL    rrsvd_tx_ch1 :  std_logic_vector (4 DOWNTO 0);          -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL    rrsvd_tx_ch2 :  std_logic_vector (4 DOWNTO 0);          -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL    rrsvd_tx_ch3 :  std_logic_vector (4 DOWNTO 0);          -- Rerserved CRAMs for both TX PCS and TX PMA

-- TX PMA CRAMs outputs to TX PMAs ending with _int  ------------------------------------------------------

-- RX PCS CRAMs -------------------------------------------------------------------------------------------------------
SIGNAL    rskpsetbased :  std_logic_vector (3 DOWNTO 0);          -- Enable rate matching for PCI-E/PIPE, other standards based on COMMA DEL DEL..
SIGNAL    rtruebac2bac :  std_logic_vector (3 DOWNTO 0);          -- Enabled (high) for all standards except PIPE. Back to back rate match enable.
SIGNAL    ralfull_ch0 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost full goes high	
SIGNAL    ralempty_ch0 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost empty goes high
SIGNAL    ralfull_ch1 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost full goes high	
SIGNAL    ralempty_ch1 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost empty goes high
SIGNAL    ralfull_ch2 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost full goes high	
SIGNAL    ralempty_ch2 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost empty goes high
SIGNAL    ralfull_ch3 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost full goes high	
SIGNAL    ralempty_ch3 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost empty goes high
SIGNAL    rcmpfifourst :  std_logic_vector (3 DOWNTO 0);          -- Enable cmpfifourst
SIGNAL    rphfifourstrx :  std_logic_vector (3 DOWNTO 0);         -- Enable phfifourst_rx
SIGNAL    rpowdnr :  std_logic_vector (3 DOWNTO 0);               -- RX channel power down CRAM
SIGNAL    rrxurstpcs :  std_logic_vector (3 DOWNTO 0);            -- Gated CRAM for RXURSTPCS
SIGNAL    rcomp_size_ch0 :  std_logic_vector (2 DOWNTO 0);        -- Pattern comparision length CRAMs
SIGNAL    rcomp_size_ch1 :  std_logic_vector (2 DOWNTO 0);        -- Pattern comparision length CRAMs
SIGNAL    rcomp_size_ch2 :  std_logic_vector (2 DOWNTO 0);        -- Pattern comparision length CRAMs
SIGNAL    rcomp_size_ch3 :  std_logic_vector (2 DOWNTO 0);        -- Pattern comparision length CRAMs
SIGNAL    rcomp_pat_ch0 :  std_logic_vector (39 DOWNTO 0);         -- Sync pattern CRAMs
SIGNAL    rcomp_pat_ch1 :  std_logic_vector (39 DOWNTO 0);         -- Sync pattern CRAMs
SIGNAL    rcomp_pat_ch2 :  std_logic_vector (39 DOWNTO 0);         -- Sync pattern CRAMs
SIGNAL    rcomp_pat_ch3 :  std_logic_vector (39 DOWNTO 0);         -- Sync pattern CRAMs
SIGNAL    rrundisp_ch0 :  std_logic_vector (5 DOWNTO 0);          -- Run lengh violation setting CRAMs
SIGNAL    rrundisp_ch1 :  std_logic_vector (5 DOWNTO 0);          -- Run lengh violation setting CRAMs
SIGNAL    rrundisp_ch2 :  std_logic_vector (5 DOWNTO 0);          -- Run lengh violation setting CRAMs
SIGNAL    rrundisp_ch3 :  std_logic_vector (5 DOWNTO 0);          -- Run lengh violation setting CRAMs
SIGNAL    rib_inv_cd_ch0 :  std_logic_vector (1 DOWNTO 0);        -- Invalid code setting CRAMs for IB
SIGNAL    rib_inv_cd_ch1 :  std_logic_vector (1 DOWNTO 0);        -- Invalid code setting CRAMs for IB
SIGNAL    rib_inv_cd_ch2 :  std_logic_vector (1 DOWNTO 0);        -- Invalid code setting CRAMs for IB
SIGNAL    rib_inv_cd_ch3 :  std_logic_vector (1 DOWNTO 0);        -- Invalid code setting CRAMs for IB
SIGNAL    rrlv_en :  std_logic_vector (3 DOWNTO 0);               -- RLV enable CRAM
SIGNAL    rsync_sm_dis :  std_logic_vector (3 DOWNTO 0);          -- GIGE/XAUI Sync SM disable CRAM
SIGNAL    rautobtalg_dis :  std_logic_vector (3 DOWNTO 0);        -- BITSLIP mode enable CRAM
SIGNAL    rdis_rx_disp :  std_logic_vector (3 DOWNTO 0);          -- Receive running disparity calculation disable CRAM
SIGNAL    rmatchen :  std_logic_vector (3 DOWNTO 0);              -- Clock compensation enable CRAM
SIGNAL    rgenericfifo :  std_logic_vector (3 DOWNTO 0);          -- GenericFIFO mode enable CRAM
SIGNAL    rendec_rx :  std_logic_vector (3 DOWNTO 0);             -- 10B/8B decoder enable CRAM
SIGNAL    rdwidth_rx :  std_logic_vector (3 DOWNTO 0);            -- RX parallel interface data width selection CRAM
SIGNAL    rlp20ben :  std_logic_vector (3 DOWNTO 0);              -- 20-b loopback enable CRAM
SIGNAL    rrxfifo_dis :  std_logic_vector (3 DOWNTO 0);           -- RX FIFO bypassing CRAM
SIGNAL    renumber_ch0 :  std_logic_vector (2 DOWNTO 0);          -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL    renumber_ch1 :  std_logic_vector (2 DOWNTO 0);          -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL    renumber_ch2 :  std_logic_vector (2 DOWNTO 0);          -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL    renumber_ch3 :  std_logic_vector (2 DOWNTO 0);          -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL    rknumber_ch0 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL    rknumber_ch1 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL    rknumber_ch2 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL    rknumber_ch3 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL    renpolinv_rx :  std_logic_vector (3 DOWNTO 0);          -- Allow polarity inversion
SIGNAL    rgnumber_ch0 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL    rgnumber_ch1 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL    rgnumber_ch2 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL    rgnumber_ch3 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL    rclkcmpsqmd :  std_logic_vector (3 DOWNTO 0);           -- How many characters to match
SIGNAL    rclkcmpsq1p_ch0 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL    rclkcmpsq1p_ch1 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL    rclkcmpsq1p_ch2 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL    rclkcmpsq1p_ch3 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL    rclkcmpsq1n_ch0 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL    rclkcmpsq1n_ch1 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL    rclkcmpsq1n_ch2 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL    rclkcmpsq1n_ch3 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL    rclkcmppos :  std_logic_vector (3 DOWNTO 0);            -- Match only the pos disp. sequence 
SIGNAL    rosnumber_ch0 :  std_logic_vector (1 DOWNTO 0);         -- Length of the ordered set
SIGNAL    rosnumber_ch1 :  std_logic_vector (1 DOWNTO 0);         -- Length of the ordered set
SIGNAL    rosnumber_ch2 :  std_logic_vector (1 DOWNTO 0);         -- Length of the ordered set
SIGNAL    rosnumber_ch3 :  std_logic_vector (1 DOWNTO 0);         -- Length of the ordered set
SIGNAL    rosbased :  std_logic_vector (3 DOWNTO 0);              -- Enable ordered-set based algorithm
SIGNAL    rkchar :  std_logic_vector (3 DOWNTO 0);                -- use kchar at cg_bad logic calculation
SIGNAL    rcascaded_8b10b_en_rx :  std_logic_vector (3 DOWNTO 0); -- Cascaded 8B/10B decoder enable CRAM
SIGNAL    resync_badcg_en_ch0 :  std_logic_vector (1 DOWNTO 0);   --
SIGNAL    resync_badcg_en_ch1 :  std_logic_vector (1 DOWNTO 0);   --
SIGNAL    resync_badcg_en_ch2 :  std_logic_vector (1 DOWNTO 0);   --
SIGNAL    resync_badcg_en_ch3 :  std_logic_vector (1 DOWNTO 0);   --
SIGNAL    rencdt_rising :  std_logic_vector (3 DOWNTO 0);         -- encdt on rising edge enable CRAM
SIGNAL    rcomp_pat_porn :  std_logic_vector (3 DOWNTO 0);        -- Positive and negative match enable CRAM
SIGNAL    rprbsen_rx :  std_logic_vector (3 DOWNTO 0);            -- PRBS Verifier enable CRAM
SIGNAL    rprbs_clr_rslt_rx :  std_logic_vector (3 DOWNTO 0);     -- PRBS pass/fail flag clear CRAM
SIGNAL    rbisten_rx :  std_logic_vector (3 DOWNTO 0);            -- BIST Verifier enable CRAM
SIGNAL    rbist_clr_rx :  std_logic_vector (3 DOWNTO 0);          -- BIST pass/fail flag clear CRAM
SIGNAL    rwa_6g_en :  std_logic_vector (3 DOWNTO 0);             -- 6G word alignment enable CRAM
SIGNAL    rbitslip_size_ch0 :  std_logic_vector (1 DOWNTO 0);     -- BITSLIP size selection CRAM
SIGNAL    rbitslip_size_ch1 :  std_logic_vector (1 DOWNTO 0);     -- BITSLIP size selection CRAM
SIGNAL    rbitslip_size_ch2 :  std_logic_vector (1 DOWNTO 0);     -- BITSLIP size selection CRAM
SIGNAL    rbitslip_size_ch3 :  std_logic_vector (1 DOWNTO 0);     -- BITSLIP size selection CRAM
SIGNAL    rbytord_2sym_en :  std_logic_vector (3 DOWNTO 0);       -- Enable 2 symbols byte orderring CRAM
SIGNAL    rbysync_polinv_en :  std_logic_vector (3 DOWNTO 0);     -- Word alignment polarity inversion enable CRAM
SIGNAL    rbitloc_rev_en :  std_logic_vector (3 DOWNTO 0);        -- Bit reversal enable CRAM
SIGNAL    rbyte_rev_en :  std_logic_vector (3 DOWNTO 0);          -- Byte swap enable CRAM
SIGNAL    rbyteorden_ch0 :  std_logic_vector (1 DOWNTO 0);        -- Byte ordering enable CRAM
SIGNAL    rbyteorden_ch1 :  std_logic_vector (1 DOWNTO 0);        -- Byte ordering enable CRAM
SIGNAL    rbyteorden_ch2 :  std_logic_vector (1 DOWNTO 0);        -- Byte ordering enable CRAM
SIGNAL    rbyteorden_ch3 :  std_logic_vector (1 DOWNTO 0);        -- Byte ordering enable CRAM
SIGNAL    rbytordplden :  std_logic_vector (3 DOWNTO 0);          -- PLD control signal BYTEORDPLD enable CRAM
SIGNAL    rphfifopldenrx :  std_logic_vector (3 DOWNTO 0);        -- RX phase comp. FIFO read/write enable CRAM
SIGNAL    rautoinsdis :  std_logic_vector (3 DOWNTO 0);           -- Disable CRAM for auto insertion of 8'h9C
SIGNAL    rppmsel_ch0 :  std_logic_vector (5 DOWNTO 0);           -- Programmable PPM ajustment CRAM
SIGNAL    rppmsel_ch1 :  std_logic_vector (5 DOWNTO 0);           -- Programmable PPM ajustment CRAM
SIGNAL    rppmsel_ch2 :  std_logic_vector (5 DOWNTO 0);           -- Programmable PPM ajustment CRAM
SIGNAL    rppmsel_ch3 :  std_logic_vector (5 DOWNTO 0);           -- Programmable PPM ajustment CRAM
SIGNAL    rforce0_freqdet :  std_logic_vector (3 DOWNTO 0);       -- Forcing FREQDET signal to low CRAM
SIGNAL    rforce1_freqdet :  std_logic_vector (3 DOWNTO 0);       -- Forcing FREQDET signal to high CRAM
SIGNAL    rbytordpat_ch0 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pattern CRAM
SIGNAL    rbytordpat_ch1 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pattern CRAM
SIGNAL    rbytordpat_ch2 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pattern CRAM
SIGNAL    rbytordpat_ch3 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pattern CRAM
SIGNAL    rbytordpad_ch0 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pad pattern CRAM
SIGNAL    rbytordpad_ch1 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pad pattern CRAM
SIGNAL    rbytordpad_ch2 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pad pattern CRAM
SIGNAL    rbytordpad_ch3 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pad pattern CRAM
SIGNAL    rforce_sig_det_pcs :  std_logic_vector (3 DOWNTO 0);    -- Forcing sigdet to high in PCS CRAM
SIGNAL    rfreerun_rx :  std_logic_vector (3 DOWNTO 0);           -- RX_CLK out free running during RX PCS reset enable CRAM
SIGNAL    rrcvd_clk_sel_ch0 :  std_logic_vector (1 DOWNTO 0);     -- RCVD_CLK domain selection CRAM
SIGNAL    rrcvd_clk_sel_ch1 :  std_logic_vector (1 DOWNTO 0);     -- RCVD_CLK domain selection CRAM
SIGNAL    rrcvd_clk_sel_ch2 :  std_logic_vector (1 DOWNTO 0);     -- RCVD_CLK domain selection CRAM
SIGNAL    rrcvd_clk_sel_ch3 :  std_logic_vector (1 DOWNTO 0);     -- RCVD_CLK domain selection CRAM
SIGNAL    rclk_1_sel_ch0 :  std_logic_vector (1 DOWNTO 0);        -- CLK_1 domain selection CRAM
SIGNAL    rclk_1_sel_ch1 :  std_logic_vector (1 DOWNTO 0);        -- CLK_1 domain selection CRAM
SIGNAL    rclk_1_sel_ch2 :  std_logic_vector (1 DOWNTO 0);        -- CLK_1 domain selection CRAM
SIGNAL    rclk_1_sel_ch3 :  std_logic_vector (1 DOWNTO 0);        -- CLK_1 domain selection CRAM
SIGNAL    rclk_2_sel_ch0 :  std_logic_vector (1 DOWNTO 0);        -- CLK_2 domain selection CRAM
SIGNAL    rclk_2_sel_ch1 :  std_logic_vector (1 DOWNTO 0);        -- CLK_2 domain selection CRAM
SIGNAL    rclk_2_sel_ch2 :  std_logic_vector (1 DOWNTO 0);        -- CLK_2 domain selection CRAM
SIGNAL    rclk_2_sel_ch3 :  std_logic_vector (1 DOWNTO 0);        -- CLK_2 domain selection CRAM
SIGNAL    rrx_rd_clk_sel :  std_logic_vector (3 DOWNTO 0);        -- RX FIFO read clock selection CRAM
SIGNAL    rrx_pipe_enable :  std_logic_vector (3 DOWNTO 0);       -- RX PIPE interface enable CRAM
SIGNAL    rall_one_dect_only :  std_logic_vector (3 DOWNTO 0);    -- PRBS Verifier detect all one only enable CRAM
SIGNAL    rtest_bus_sel_ch0 :  std_logic_vector (2 DOWNTO 0);     -- Per channel test bus selection CRAMs
SIGNAL    rtest_bus_sel_ch1 :  std_logic_vector (2 DOWNTO 0);     -- Per channel test bus selection CRAMs
SIGNAL    rtest_bus_sel_ch2 :  std_logic_vector (2 DOWNTO 0);     -- Per channel test bus selection CRAMs
SIGNAL    rtest_bus_sel_ch3 :  std_logic_vector (2 DOWNTO 0);     -- Per channel test bus selection CRAMs
SIGNAL    r8b10b_dec_ibm_en_ch0 :  std_logic_vector (1 DOWNTO 0); -- 8B10B Decoder fix enable CRAM
SIGNAL    r8b10b_dec_ibm_en_ch1 :  std_logic_vector (1 DOWNTO 0); -- 8B10B Decoder fix enable CRAM
SIGNAL    r8b10b_dec_ibm_en_ch2 :  std_logic_vector (1 DOWNTO 0); -- 8B10B Decoder fix enable CRAM
SIGNAL    r8b10b_dec_ibm_en_ch3 :  std_logic_vector (1 DOWNTO 0); -- 8B10B Decoder fix enable CRAM
SIGNAL    rrxfifo_lowlatency_en :  std_logic_vector (3 DOWNTO 0); -- RX FIFO low latency enable CRAM
SIGNAL    rppm_cnt_reset :  std_logic_vector (3 DOWNTO 0);        -- PPM counter reset CRAM (latched version on Test bus)
SIGNAL    rrx_detect_bypass :  std_logic_vector (3 DOWNTO 0);     -- PMA RX detection bypass enable CRAM
SIGNAL    rclkcmpinsertpad :  std_logic_vector (3 DOWNTO 0);      -- Rate matching pad insertion enable CRAM

-- RX PCS CRAMs outputs to RX PCS -------------------------------------------------------------------------------------

-- RX PMA CRAMs ----------------------------------------------------------------------------------
SIGNAL rpmadwidth_rx        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- RX PMA to RX PCS data width sel CRAMs
SIGNAL rpma_doublewidth_rx  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- RX PMA/PCS double width (16/20) sel CRAM
SIGNAL rrx_sloslv_ch0       : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch1       : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch2       : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch3       : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Signal loss threshold select CRAMs
SIGNAL rrx_term_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RX input buffer termination select CRAMs
SIGNAL rrxvcobypass         : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- RX VCO bypass CRAM
SIGNAL rbwctral_rx_ch0      : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch1      : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch2      : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch3      : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RX PLL loop filter bandwidth control CRAMs
SIGNAL rforce_sigdet        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- SIGDET forcing CRAM
SIGNAL rrefclk_sel_ch0      : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch1      : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch2      : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch3      : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- RXPLL alternative clock source selection CRAMs
SIGNAL rs_lpbk              : STD_LOGIC_VECTOR(3   DOWNTO   0);		      -- Serial loopback CRAM
SIGNAL r_rlpbk              : STD_LOGIC_VECTOR(3   DOWNTO   0);	              -- Reverse serial loopback CRAM for RX channel
SIGNAL rs_rdlpbk            : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Serial reversed diagnostic loopback CRAM
SIGNAL rrx_revlb_sw         : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Reverse loopback switch CRAM
SIGNAL risel_rx_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RXPLL charge pump current control CRAM
SIGNAL riupsel_rx_ch0       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch1       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch2       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch3       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL ridnsel_rx_ch0       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch1       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch2       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch3       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL rtesten_cp_rx        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Charge pump test mode control CRAM in RXPLL
SIGNAL rtristate_cp_rx      : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Charge pump tristate control CRAM in RXPLL
SIGNAL rtestupen_cp_rx      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Charge pump current test control CRAM in RXPLL
SIGNAL rtestdnen_cp_rx      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Charge pump current test control CRAM in RXPLL
SIGNAL rrx_vtt_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Programmable termination voltage setting CRAM
SIGNAL rlst_rx_ch0          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rx_ch1          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rx_ch2          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rx_ch3          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch0       : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch1       : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch2       : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch3       : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rltr                 : STD_LOGIC_VECTOR(3   DOWNTO   0);		      -- Lock to reference clock enable CRAM
SIGNAL rltd                 : STD_LOGIC_VECTOR(3   DOWNTO   0);		      -- Lock to received data enable CRAM
SIGNAL rrx_cru_m_ch0        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M control CRAM
SIGNAL rrx_cru_m_ch1        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M control CRAM
SIGNAL rrx_cru_m_ch2        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M control CRAM
SIGNAL rrx_cru_m_ch3        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M control CRAM
SIGNAL rrx_cru_l_ch0        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch1        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch2        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch3        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L contrl CRAM
SIGNAL rrx_ignore_phslck    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Ignore phase lock CRAM
SIGNAL rrx_cru_ctl_ch0      : STD_LOGIC_VECTOR(5   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch1      : STD_LOGIC_VECTOR(5   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch2      : STD_LOGIC_VECTOR(5   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch3      : STD_LOGIC_VECTOR(5   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rreg_cp_rx           : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- RX PLL charge pump regulator enable CRAM
SIGNAL rrx_piso_bypass_ch0  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch1  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch2  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch3  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Reference bypass around PISO CRAM
SIGNAL rrx_cru_m_sel_ch0    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch1    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch2    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch3    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_div2         : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Reference clock divided by 2 enable CRAM
SIGNAL rrx_osc_en           : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- CGB RX OSC enable CRAM
SIGNAL rrx_cru_pdb          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Power down (bar) CRAM for CRU
SIGNAL rrx_cru_rst          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Reset CRAM for PLL in CRU
SIGNAL rrx_ib_pdb           : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Power down (bar) for input buffer
SIGNAL rurx_pdb             : STD_LOGIC_VECTOR(3   DOWNTO   0);              -- Enable CRAM for URX_PDB dynamic signal
SIGNAL radce_pdb            : STD_LOGIC_VECTOR(3   DOWNTO   0);             -- Power down for adaptive equalization
SIGNAL radce_rst            : STD_LOGIC_VECTOR(3   DOWNTO   0);             -- Reset CRAM for counters in adaptive engine
SIGNAL rrxurstpma           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Enable CRAM for RXURSTPMA dynamic signal
SIGNAL rrx_dc_couple        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Programmable DC couple CRAM for RX input buffer
SIGNAL rrx_eq_dc_ch0        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch1        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch2        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch3        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- CRAMs for Equalizer block
SIGNAL radce_adapt          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Continuous adaptation enable CRAM
SIGNAL rseq_sel_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Sequence of adaptation selection CRAMs
SIGNAL rrgen_set_ch0        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- D2A control CRAMs
SIGNAL rrgen_set_ch1        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- D2A control CRAMs
SIGNAL rrgen_set_ch2        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- D2A control CRAMs
SIGNAL rrgen_set_ch3        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- D2A control CRAMs
SIGNAL rclkdiv_ch0          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch1          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch2          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch3          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Division ration selection CRAMs for adaptation engine
SIGNAL rf_lpf_ch0           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch1           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch2           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch3           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- LPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch0           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch1           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch2           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch3           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- HPF corner frequency setting CRAMs
SIGNAL rrgen_bw_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RGEN corner frequency setting CRAMs
SIGNAL rhyst_ch0            : STD_LOGIC_VECTOR(2   DOWNTO   0);             -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch1            : STD_LOGIC_VECTOR(2   DOWNTO   0);             -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch2            : STD_LOGIC_VECTOR(2   DOWNTO   0);             -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch3            : STD_LOGIC_VECTOR(2   DOWNTO   0);             -- Programmable digital filtering setting CRAMs
SIGNAL rrect_adj_ch0        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch1        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch2        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch3        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- Rectifier leaker current setting CRAMs
SIGNAL rd2a_res_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- D2A resolution settting CRAMs
SIGNAL rrgen_vod_ch0        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch1        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch2        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch3        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- RGEN amplitude setting CRAMs
SIGNAL rlf_os_ch0           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch1           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch2           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch3           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch0           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch1           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch2           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch3           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- High freq. loop offset cancelling setting CRAMs
SIGNAL reqa_ct_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL rdc_freq_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- ADCE CRAM
SIGNAL rdc_freq_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- ADCE CRAM
SIGNAL rdc_freq_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- ADCE CRAM
SIGNAL rdc_freq_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- ADCE CRAM
SIGNAL r_iqclk_ch0          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- IQCLK selection CRAM
SIGNAL r_iqclk_ch1          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- IQCLK selection CRAM
SIGNAL r_iqclk_ch2          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- IQCLK selection CRAM
SIGNAL r_iqclk_ch3          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- IQCLK selection CRAM
SIGNAL r_dfe_ch0            : STD_LOGIC_VECTOR(5   DOWNTO   0);             -- DFE CRAM
SIGNAL r_dfe_ch1            : STD_LOGIC_VECTOR(5   DOWNTO   0);             -- DFE CRAM
SIGNAL r_dfe_ch2            : STD_LOGIC_VECTOR(5   DOWNTO   0);             -- DFE CRAM
SIGNAL r_dfe_ch3            : STD_LOGIC_VECTOR(5   DOWNTO   0);             -- DFE CRAM
SIGNAL r_cp_mode            : STD_LOGIC_VECTOR(3   DOWNTO   0);             -- CP mode CRAM
SIGNAL r_impctrl_ch0        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- IMPCTRL CRAM
SIGNAL r_impctrl_ch1        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- IMPCTRL CRAM
SIGNAL r_impctrl_ch2        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- IMPCTRL CRAM
SIGNAL r_impctrl_ch3        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- IMPCTRL CRAM
SIGNAL rpd_ien              : STD_LOGIC_VECTOR(3   DOWNTO   0);               -- PD current setting CRAM
SIGNAL rrsvd_rx_ch0         : STD_LOGIC_VECTOR(2   DOWNTO   0);          -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch1         : STD_LOGIC_VECTOR(2   DOWNTO   0);          -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch2         : STD_LOGIC_VECTOR(2   DOWNTO   0);          -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch3         : STD_LOGIC_VECTOR(2   DOWNTO   0);          -- Rerserved CRAMs for both RX PCS and RX PMA

-- RX PMA CRAM outputs to RX PMAs ----------------------------------------------------------------------

-- CMU PCS CRAMs wire  ----------------------------------------------------------------------
SIGNAL rs_lpbk_all          : STD_LOGIC;           -- Global serial loopback enable CRAM
SIGNAL rindv_tx             : STD_LOGIC;              -- TX SM bypassing CRAM
SIGNAL rindv_rx             : STD_LOGIC;              -- RX SM bypassing CRAM
SIGNAL rdeskewen            : STD_LOGIC;             -- Deskew function enable CRAM
SIGNAL ralgnect             : STD_LOGIC_VECTOR(1   DOWNTO   0);              -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL ralgnact             : STD_LOGIC_VECTOR(2   DOWNTO   0);              -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL ralgngct             : STD_LOGIC_VECTOR(1   DOWNTO   0);              -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL rdskposdisp          : STD_LOGIC;           -- Match the programmed de-skew pattern only
SIGNAL rdskchrp             : STD_LOGIC_VECTOR(9   DOWNTO   0);              -- Programmable Deskew Char. Pos. Disp.
SIGNAL ralgnopt             : STD_LOGIC;              -- De-skew SM Hysteresis Option
SIGNAL rfreerun_centrl      : STD_LOGIC;       -- REFCLK_OUT free running enable CRAM
SIGNAL rcentrl_clk_sel      : STD_LOGIC;       -- REFCLK_PMA global clock selection CRAM
SIGNAL rrefclk_out_div2     : STD_LOGIC;      -- REFCLK_OUT divide by 2 enable CRAM
SIGNAL rtest_bus_centrl_sel : STD_LOGIC_VECTOR(2   DOWNTO   0);  -- Central Test bus selection CRAMs
SIGNAL rendec_data_sel_tx   : STD_LOGIC;    -- TX 8B10B encoder data in selection CRAM
SIGNAL rendec_data_sel_rx   : STD_LOGIC;    -- RX 8B10B decoder data out selection CRAM
SIGNAL rphfifo_master_sel_tx : STD_LOGIC; -- TX Phase comp. FIFO pointers selection CRAM
SIGNAL rphfifo_master_sel_rx : STD_LOGIC; -- TX Phase comp. FIFO pointers selection CRAM

-- CMU PCS CRAMs outputs to CMU
SIGNAL rs_lpbk_all_md       : STD_LOGIC;        -- Output CRAM of RS_LPBK_ALL
                                      
-- RESET, CMU PMA, and CLKREF CRAMs wire  ----------------------------------------------------------------------
SIGNAL rpowerdown           : STD_LOGIC;            -- Quad power down CRAM
SIGNAL rnenbpin             : STD_LOGIC;              -- Gated CRAM for ENPLL pin
SIGNAL rpllurst             : STD_LOGIC;              -- Gated CRAM for PLLURST
SIGNAL rreset               : STD_LOGIC;                -- Quad reset CRAM
SIGNAL rbgbypass            : STD_LOGIC;	      -- Bandgap bypass CRAM
SIGNAL rlst_bg              : STD_LOGIC_VECTOR(3   DOWNTO   0);	              -- Programmable test bus setting CRAM
SIGNAL rcmu_rst             : STD_LOGIC;	      -- Reset CRAM for divider in CMU feedback loop
SIGNAL rcmu_iqclkout_sel    : STD_LOGIC;     -- REFClock select for going to IQ lines CRAM
SIGNAL rcmu0_isel           : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu1_isel           : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu0_iupsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu1_iupsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu0_idnsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu1_idnsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu0_testen_cp      : STD_LOGIC;       -- Charge pump test mode control CRAM in TXPLL0
SIGNAL rcmu1_testen_cp      : STD_LOGIC;       -- Charge pump test mode control CRAM in TXPLL1
SIGNAL rcmu0_tristate_cp    : STD_LOGIC;     -- Charge pump tristate control CRAM in TXPLL0
SIGNAL rcmu1_tristate_cp    : STD_LOGIC;     -- Charge pump tristate control CRAM in TXPLL1
SIGNAL rcmu0_testupen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM in TXPLL0
SIGNAL rcmu1_testupen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM in TXPLL1
SIGNAL rcmu0_lst            : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu1_lst            : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu0_ctl            : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu1_ctl            : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu0_div2           : STD_LOGIC;	      -- Reference clock divided by 2 enable CRAM
SIGNAL rcmu1_div2           : STD_LOGIC;	      -- Reference clock divided by 2 enable CRAM
SIGNAL rcmu0_ref_sel        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Reference selection control CRAM
SIGNAL rcmu1_ref_sel        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Reference selection control CRAM
SIGNAL rcmu0_m              : STD_LOGIC_VECTOR(3   DOWNTO   0);	              -- Programmable M selection CRAM
SIGNAL rcmu1_m              : STD_LOGIC_VECTOR(3   DOWNTO   0);	              -- Programmable M selection CRAM
SIGNAL rcmu0_l              : STD_LOGIC_VECTOR(1   DOWNTO   0);	              -- Programmable L selection CRAM
SIGNAL rcmu1_l              : STD_LOGIC_VECTOR(1   DOWNTO   0);	              -- Programmable L selection CRAM
SIGNAL rcmu0_pdb            : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu1_pdb            : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu0_txpll_rst      : STD_LOGIC;       -- TXPLL0 reset CRAM
SIGNAL rcmu1_txpll_rst      : STD_LOGIC;       -- TXPLL0 reset CRAM
SIGNAL rcmu0_testdnen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM
SIGNAL rcmu1_testdnen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM
SIGNAL rcmu_peclrx0_cm      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Common mode control CRAM
SIGNAL rcmu_peclrx1_cm      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Common mode control CRAM
SIGNAL rcmu_peclrx0_lst     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Analog test bus setting CRAM
SIGNAL rcmu_peclrx1_lst     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Analog test bus setting CRAM
SIGNAL rcmu_txpll0_1x_en    : STD_LOGIC;     -- 1X enable CRAM in central CGB
SIGNAL rcmu_txpll1_1x_en    : STD_LOGIC;     -- 1X enable CRAM in central CGB
SIGNAL rcmu_txpll0_iqclkin_sel : STD_LOGIC_VECTOR(2   DOWNTO   0);-- IQ clock selection CRAMs
SIGNAL rcmu_txpll1_iqclkin_sel : STD_LOGIC_VECTOR(2   DOWNTO   0);-- IQ clock selection CRAMs
SIGNAL rcmu_cgb_cmusel      : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Central CGB CMU selection CRAM
SIGNAL rcmu_cgb_ndiv        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- N-divider selection CRAM for wire  clock in central CGB
SIGNAL rcmu_cgb_div5        : STD_LOGIC;         -- TX PCS to TX PMA data width selection CRAM
SIGNAL rcmu_cgb_div2        : STD_LOGIC;         -- TX PCS to TX PMA double data width selection CRAM
SIGNAL rcmu_cgb_vcobypass   : STD_LOGIC;    -- CMU VCO bypass CRAM in central CGB
SIGNAL rcmu_cgb_4x_en       : STD_LOGIC;        -- Quad channel mode clock driver enable CRAM
SIGNAL rcmu_cgb_8x_en       : STD_LOGIC;        -- Eight channel mode clock driver enable CRAM
SIGNAL rcmu_cgb_pclksel     : STD_LOGIC;      -- Central CGB PCLK select CRAM
SIGNAL rcmu2_isel           : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu2_iupsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu2_idnsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu2_testen_cp      : STD_LOGIC;       -- Charge pump test mode control CRAM in TXPLL2
SIGNAL rcmu2_tristate_cp    : STD_LOGIC;     -- Charge pump tristate control CRAM in TXPLL2
SIGNAL rcmu2_testupen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM in TXPLL2
SIGNAL rcmu2_testdnen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM in TXPLL2
SIGNAL rcmu2_lst            : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu2_ctl            : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu2_refsel         : STD_LOGIC;          -- Reference select CRAM for CMU2
SIGNAL rcmu2_m              : STD_LOGIC_VECTOR(3   DOWNTO   0);	              -- Programmable M selection CRAM
SIGNAL rcmu2_l              : STD_LOGIC_VECTOR(1   DOWNTO   0);	              -- Programmable L selection CRAM
SIGNAL rcmu2_pdb            : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu2_txpll_rst      : STD_LOGIC;       -- TXPLL2 reset CRAM
SIGNAL rcmu0_rcp_mode       : STD_LOGIC;        -- CMU0 charge pump mode select CRAM
SIGNAL rcmu1_rcp_mode       : STD_LOGIC;        -- CMU1 charge pump mode select CRAM
SIGNAL rpma_testbus_sel     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- PMA testbus selection
SIGNAL rrsvd_cmu            : STD_LOGIC_VECTOR(4   DOWNTO   0);             -- Reserved CRAMs for both PMA CMU and PCS CMU

-- CMU PMA, and CLKREF CRAMs outputs ----------------------------------------------------------------------

-- Output CRAM for Quad reset ----------------------------------------------------------------------
SIGNAL rnenbpin_md          : STD_LOGIC;           -- Output CRAM of RNENBPIN
SIGNAL rpllurst_md          : STD_LOGIC;           -- Output CRAM of RPLLURST
SIGNAL rreset_md            : STD_LOGIC;             -- Output CRAM of RRESET
SIGNAL rpowerdown_md        : STD_LOGIC;         -- Output CRAM of RPOWERDOWN
SIGNAL rrxurstpcs_md        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Output CRAM of RRXURSTPCS
SIGNAL rpowdnr_md           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Output CRAM of RPOWDNR
SIGNAL rtxurstpcs_md        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Output CRAM of RTXURSTPCS
SIGNAL rpowdnt_md           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Output CRAM of RPOWDNT
SIGNAL rrxurstpma_md        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Output CRAM of RRXURSTPMA

------------------------------------------------------------------------------------------------------
--              end of named CRAMs                                                                  --
------------------------------------------------------------------------------------------------------

-- MDIO related wires
SIGNAL chain                : STD_LOGIC_VECTOR(127 DOWNTO   0);
SIGNAL local_fault          : STD_LOGIC;
SIGNAL xs_link_status_rd    : STD_LOGIC;
SIGNAL tx_rx_local_fault_status_rd : STD_LOGIC;
SIGNAL xs_tx_local_fault    : STD_LOGIC;
SIGNAL xs_rx_local_fault    : STD_LOGIC;

-- Control and Status register outputs
SIGNAL xgxs_ctrl_reg        : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL trunking_mode_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch0_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch1_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch2_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch3_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl0_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl1_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl2_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);

SIGNAL pma_ctrl1_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl0_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl1_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl2_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl3_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl4_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl5_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl6_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl7_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl8_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl9_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);

SIGNAL xgxs_stat1_reg       : STD_LOGIC_VECTOR(15  DOWNTO   0);    
SIGNAL xgxs_stat2_reg       : STD_LOGIC_VECTOR(15  DOWNTO   0);    
SIGNAL xgxs_lane_stat_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);

-- External inputs for control registers
SIGNAL xgxs_ctrl_ext        : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL trunking_mode_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch0_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch1_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch2_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch3_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl0_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl1_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl2_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);

SIGNAL pma_ctrl1_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl0_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl1_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl2_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl3_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl4_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl5_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl6_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl7_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl8_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl9_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);

-- TX PCS CRAMs wires to TX PCS
SIGNAL rbisten_tx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- ENBIST CRAM
SIGNAL rrev_loopbk_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- CRAM - Enable dynamic Reverse, PIPE mode
SIGNAL rforce_disp_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Acting with TXD[9, 19] forces current disparity to 1 or 0
SIGNAL rib_force_disp_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);    -- Disparity force CRAM in IB mode
SIGNAL rforce_echar_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Force /E/ char CRAM
SIGNAL rforce_kchar_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Force /K/ char CRAM
SIGNAL rendec_tx_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Enable 8B/10B encoder CRAM
SIGNAL rge_xaui_tx_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- GIGE Idle test enable CRAM
SIGNAL rdwidth_tx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- TX parallel interface data width CRAM
SIGNAL rtxfifo_dis_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- TX FIFO disable CRAM
SIGNAL rcascaded_8b10b_en_tx_int : STD_LOGIC_VECTOR(3   DOWNTO   0); -- Caascaded 8b/10b encoder enable CRAM
SIGNAL rprbsen_tx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- PRBS generator enable CRAM
SIGNAL rprbs_sel_ch0_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- PRBS selection CRAM
SIGNAL rprbs_sel_ch1_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- PRBS selection CRAM
SIGNAL rprbs_sel_ch2_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- PRBS selection CRAM
SIGNAL rprbs_sel_ch3_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- PRBS selection CRAM
SIGNAL rbist_sel_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- BIST selection CRAM
SIGNAL rbist_sel_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- BIST selection CRAM
SIGNAL rbist_sel_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- BIST selection CRAM
SIGNAL rbist_sel_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- BIST selection CRAM
SIGNAL rcxpat_chnl_en_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- CRPAT or CJPAT selection CRAM
SIGNAL rcxpat_chnl_en_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- CRPAT or CJPAT selection CRAM
SIGNAL rcxpat_chnl_en_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- CRPAT or CJPAT selection CRAM
SIGNAL rcxpat_chnl_en_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- CRPAT or CJPAT selection CRAM
SIGNAL renpolinv_tx_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- TX Polarity inversion enable CRAM
SIGNAL rphfifopldentx_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- TX phase comp. FIFO PLD read/write enable CRAM
SIGNAL rphfifoursttx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- TX phase comp. FIFO user reset enable CRAM
SIGNAL rfreerun_tx_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- TX_CLK out free running during TX PCS reset enable CRAM
SIGNAL rtxwrclksel_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- TX FIFO write clock selection CRAM
SIGNAL rtxrdclksel_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- TX FIFO read clock selection CRAM
SIGNAL rtx_pipe_enable_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- TX PIPE interface enable CRAM
SIGNAL renbitrev_tx_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- TX bit reversal enable CRAM
SIGNAL rensymswap_tx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- TX symbol swap enable CRAM
SIGNAL r8b10b_enc_ibm_en_int : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- 8B10B Encoder fix enable CRAM
SIGNAL rtxfifo_lowlatency_en_int : STD_LOGIC_VECTOR(3   DOWNTO   0); -- TX FIFO low latency enable CRAM
SIGNAL rtx_idle_delay_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL rtx_idle_delay_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL rtx_idle_delay_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL rtx_idle_delay_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- PIPE TxElecIdle delay value CRAM

-- TX PMA CRAMs wires to TX PMAs
SIGNAL rpmadwidth_tx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- TX PCS to TX PMA data width selection CRAM
SIGNAL rpma_doublewidth_tx_int : STD_LOGIC_VECTOR(3   DOWNTO   0);-- PCS/PMA double width (16/20) selection CRAM
SIGNAL rtx_term_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- TX output buffer termination select CRAMs
SIGNAL rtx_term_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- TX output buffer termination select CRAMs
SIGNAL rtx_term_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- TX output buffer termination select CRAMs
SIGNAL rtx_term_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- TX output buffer termination select CRAMs
SIGNAL rtx_vod_sel_ch0_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- TX output buffer Vod switching control CRAMs
SIGNAL rtx_vod_sel_ch1_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- TX output buffer Vod switching control CRAMs
SIGNAL rtx_vod_sel_ch2_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- TX output buffer Vod switching control CRAMs
SIGNAL rtx_vod_sel_ch3_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- TX output buffer Vod switching control CRAMs
SIGNAL rpmphs_1tap_ch0_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL rpmphs_1tap_ch1_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL rpmphs_1tap_ch2_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL rpmphs_1tap_ch3_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL rtx_slewrate_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Slew rate control CRAM
SIGNAL rlst_tx_ch0_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Low speed Test selection CRAMs
SIGNAL rlst_tx_ch1_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Low speed Test selection CRAMs
SIGNAL rlst_tx_ch2_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Low speed Test selection CRAMs
SIGNAL rlst_tx_ch3_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Low speed Test selection CRAMs
SIGNAL rtx_cmu_sel_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- CMU selection CRAM
SIGNAL rtx_m_sel_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL rtx_m_sel_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL rtx_m_sel_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL rtx_m_sel_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL rtxvcobypass_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- TX VCO bypass CRAM
SIGNAL rtx_cgb_1x_en_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Single CLKGENBUF mode enable CRAM
SIGNAL rtx_cgb_4x_en_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Quad CLKGENBUF mode enable CRAM
SIGNAL rtx_4x_sw_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Xaui mode (CPULSE aligned across 4 channels) selection CRAM
SIGNAL rsig_inv_2tap_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Pre-emphasis FIR-tap selection CRAM
SIGNAL rpmphs_ptap_ch0_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Control CRAM
SIGNAL rpmphs_ptap_ch1_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Control CRAM
SIGNAL rpmphs_ptap_ch2_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Control CRAM
SIGNAL rpmphs_ptap_ch3_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Control CRAM
SIGNAL rtx_cgb_pdb_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Power down (bar) CRAM for CLKGENBUF6G
--wire    [3:0]  rtx_piso_pdb_int;      -- Power down (bar) CRAM for PISO
SIGNAL rtx_ob_pdb_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- Power down (bar) CRAM for output buffer
SIGNAL r_tx_det_rx_ch0_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- RX Detect block CRAMs
SIGNAL r_tx_det_rx_ch1_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- RX Detect block CRAMs
SIGNAL r_tx_det_rx_ch2_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- RX Detect block CRAMs
SIGNAL r_tx_det_rx_ch3_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- RX Detect block CRAMs
SIGNAL rpmphs_2tap_ch0_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL rpmphs_2tap_ch1_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL rpmphs_2tap_ch2_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL rpmphs_2tap_ch3_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL rtx_vtt_ch0_int      : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL rtx_vtt_ch1_int      : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL rtx_vtt_ch2_int      : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL rtx_vtt_ch3_int      : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL rsig_inv_pre_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Enable CRAM for SIG_INV_PRE dynamic control signal
SIGNAL rrsvd_tx_ch0_int     : STD_LOGIC_VECTOR(4   DOWNTO   0);      -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL rrsvd_tx_ch1_int     : STD_LOGIC_VECTOR(4   DOWNTO   0);      -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL rrsvd_tx_ch2_int     : STD_LOGIC_VECTOR(4   DOWNTO   0);      -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL rrsvd_tx_ch3_int     : STD_LOGIC_VECTOR(4   DOWNTO   0);      -- Rerserved CRAMs for both TX PCS and TX PMA

-- RX PCS CRAMs wires to RX PCS
SIGNAL rskpsetbased_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Enable rate matching for PCI-E/PIPE, other standards based on COMMA DEL DEL..
SIGNAL rtruebac2bac_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Enabled (high) for all standards except PIPE. Back to back rate match enable.
SIGNAL ralfull_ch0_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Program when almost full goes high	
SIGNAL ralempty_ch0_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Program when almost empty goes high
SIGNAL ralfull_ch1_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Program when almost full goes high	
SIGNAL ralempty_ch1_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Program when almost empty goes high
SIGNAL ralfull_ch2_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Program when almost full goes high	
SIGNAL ralempty_ch2_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Program when almost empty goes high
SIGNAL ralfull_ch3_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Program when almost full goes high	
SIGNAL ralempty_ch3_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Program when almost empty goes high
SIGNAL rcmpfifourst_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Enable cmpfifourst
SIGNAL rphfifourstrx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Enable phfifourst_rx
SIGNAL rcomp_size_ch0_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);    -- Pattern comparision length CRAMs
SIGNAL rcomp_size_ch1_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);    -- Pattern comparision length CRAMs
SIGNAL rcomp_size_ch2_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);    -- Pattern comparision length CRAMs
SIGNAL rcomp_size_ch3_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);    -- Pattern comparision length CRAMs
SIGNAL rcomp_pat_ch0_int    : STD_LOGIC_VECTOR(39  DOWNTO   0);     -- Sync pattern CRAMs
SIGNAL rcomp_pat_ch1_int    : STD_LOGIC_VECTOR(39  DOWNTO   0);     -- Sync pattern CRAMs
SIGNAL rcomp_pat_ch2_int    : STD_LOGIC_VECTOR(39  DOWNTO   0);     -- Sync pattern CRAMs
SIGNAL rcomp_pat_ch3_int    : STD_LOGIC_VECTOR(39  DOWNTO   0);     -- Sync pattern CRAMs
SIGNAL rrundisp_ch0_int     : STD_LOGIC_VECTOR(5   DOWNTO   0);      -- Run lengh violation setting CRAMs
SIGNAL rrundisp_ch1_int     : STD_LOGIC_VECTOR(5   DOWNTO   0);      -- Run lengh violation setting CRAMs
SIGNAL rrundisp_ch2_int     : STD_LOGIC_VECTOR(5   DOWNTO   0);      -- Run lengh violation setting CRAMs
SIGNAL rrundisp_ch3_int     : STD_LOGIC_VECTOR(5   DOWNTO   0);      -- Run lengh violation setting CRAMs
SIGNAL rib_inv_cd_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- Invalid code setting CRAMs for IB
SIGNAL rib_inv_cd_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- Invalid code setting CRAMs for IB
SIGNAL rib_inv_cd_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- Invalid code setting CRAMs for IB
SIGNAL rib_inv_cd_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- Invalid code setting CRAMs for IB
SIGNAL rrlv_en_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- RLV enable CRAM
SIGNAL rsync_sm_dis_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- GIGE/XAUI Sync SM disable CRAM
SIGNAL rautobtalg_dis_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);    -- BITSLIP mode enable CRAM
SIGNAL rdis_rx_disp_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Receive running disparity calculation disable CRAM
SIGNAL rmatchen_int         : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Clock compensation enable CRAM
SIGNAL rgenericfifo_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- GenericFIFO mode enable CRAM
SIGNAL rendec_rx_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- 10B/8B decoder enable CRAM
SIGNAL rdwidth_rx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- RX parallel interface data width selection CRAM
SIGNAL rlp20ben_int         : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- 20-b loopback enable CRAM
SIGNAL rrxfifo_dis_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- RX FIFO bypassing CRAM
SIGNAL renumber_ch0_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);      -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL renumber_ch1_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);      -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL renumber_ch2_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);      -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL renumber_ch3_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);      -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL rknumber_ch0_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL rknumber_ch1_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL rknumber_ch2_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL rknumber_ch3_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL renpolinv_rx_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Allow polarity inversion
SIGNAL rgnumber_ch0_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL rgnumber_ch1_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL rgnumber_ch2_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL rgnumber_ch3_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL rclkcmpsqmd_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- How many characters to match
SIGNAL rclkcmpsq1p_ch0_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL rclkcmpsq1p_ch1_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL rclkcmpsq1p_ch2_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL rclkcmpsq1p_ch3_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL rclkcmpsq1n_ch0_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL rclkcmpsq1n_ch1_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL rclkcmpsq1n_ch2_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL rclkcmpsq1n_ch3_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL rclkcmppos_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- Match only the pos disp. sequence 
SIGNAL rosnumber_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Length of the ordered set
SIGNAL rosnumber_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Length of the ordered set
SIGNAL rosnumber_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Length of the ordered set
SIGNAL rosnumber_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Length of the ordered set
SIGNAL rosbased_int         : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Enable ordered-set based algorithm
SIGNAL rkchar_int           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- use kchar at cg_bad logic calculation
SIGNAL rcascaded_8b10b_en_rx_int : STD_LOGIC_VECTOR(3   DOWNTO   0); -- Cascaded 8B/10B decoder enable CRAM
SIGNAL resync_badcg_en_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   --
SIGNAL resync_badcg_en_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   --
SIGNAL resync_badcg_en_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   --
SIGNAL resync_badcg_en_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   --
SIGNAL rencdt_rising_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- encdt on rising edge enable CRAM
SIGNAL rcomp_pat_porn_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- Positive and negative match enable CRAM
SIGNAL rprbsen_rx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- PRBS Verifier enable CRAM
SIGNAL rprbs_clr_rslt_rx_int : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- PRBS pass/fail flag clear CRAM
SIGNAL rbisten_rx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- BIST Verifier enable CRAM
SIGNAL rbist_clr_rx_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- BIST pass/fail flag clear CRAM
SIGNAL rwa_6g_en_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);             -- 6G word alignment enable CRAM
SIGNAL rbitslip_size_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- BITSLIP size selection CRAM
SIGNAL rbitslip_size_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- BITSLIP size selection CRAM
SIGNAL rbitslip_size_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- BITSLIP size selection CRAM
SIGNAL rbitslip_size_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- BITSLIP size selection CRAM
SIGNAL rbytord_2sym_en_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Enable 2 symbols byte orderring CRAM
SIGNAL rbysync_polinv_en_int : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Word alignment polarity inversion enable CRAM
SIGNAL rbitloc_rev_en_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- Bit reversal enable CRAM
SIGNAL rbyte_rev_en_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Byte swap enable CRAM
SIGNAL rbyteorden_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Byte ordering enable CRAM
SIGNAL rbyteorden_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Byte ordering enable CRAM
SIGNAL rbyteorden_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Byte ordering enable CRAM
SIGNAL rbyteorden_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Byte ordering enable CRAM
SIGNAL rbytordplden_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- PLD control signal BYTEORDPLD enable CRAM
SIGNAL rphfifopldenrx_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- RX phase comp. FIFO read/write enable CRAM
SIGNAL rautoinsdis_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Disable CRAM for auto insertion of 8'h9C
SIGNAL rppmsel_ch0_int      : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- Programmable PPM ajustment CRAM
SIGNAL rppmsel_ch1_int      : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- Programmable PPM ajustment CRAM
SIGNAL rppmsel_ch2_int      : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- Programmable PPM ajustment CRAM
SIGNAL rppmsel_ch3_int      : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- Programmable PPM ajustment CRAM
SIGNAL rforce0_freqdet_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Forcing FREQDET signal to low CRAM
SIGNAL rforce1_freqdet_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Forcing FREQDET signal to high CRAM
SIGNAL rbytordpat_ch0_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pattern CRAM
SIGNAL rbytordpat_ch1_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pattern CRAM
SIGNAL rbytordpat_ch2_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pattern CRAM
SIGNAL rbytordpat_ch3_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pattern CRAM
SIGNAL rbytordpad_ch0_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pad pattern CRAM
SIGNAL rbytordpad_ch1_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pad pattern CRAM
SIGNAL rbytordpad_ch2_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pad pattern CRAM
SIGNAL rbytordpad_ch3_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pad pattern CRAM
SIGNAL rforce_sig_det_pcs_int : STD_LOGIC_VECTOR(3   DOWNTO   0);    -- Forcing sigdet to high in PCS CRAM
SIGNAL rfreerun_rx_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- RX_CLK out free running during RX PCS reset enable CRAM
SIGNAL rrcvd_clk_sel_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- RCVD_CLK domain selection CRAM
SIGNAL rrcvd_clk_sel_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- RCVD_CLK domain selection CRAM
SIGNAL rrcvd_clk_sel_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- RCVD_CLK domain selection CRAM
SIGNAL rrcvd_clk_sel_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- RCVD_CLK domain selection CRAM
SIGNAL rclk_1_sel_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_1 domain selection CRAM
SIGNAL rclk_1_sel_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_1 domain selection CRAM
SIGNAL rclk_1_sel_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_1 domain selection CRAM
SIGNAL rclk_1_sel_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_1 domain selection CRAM
SIGNAL rclk_2_sel_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_2 domain selection CRAM
SIGNAL rclk_2_sel_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_2 domain selection CRAM
SIGNAL rclk_2_sel_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_2 domain selection CRAM
SIGNAL rclk_2_sel_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_2 domain selection CRAM
SIGNAL rrx_rd_clk_sel_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- RX FIFO read clock selection CRAM
SIGNAL rrx_pipe_enable_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- RX PIPE interface enable CRAM
SIGNAL rall_one_dect_only_int : STD_LOGIC_VECTOR(3   DOWNTO   0);    -- PRBS Verifier detect all one only enable CRAM
SIGNAL rtest_bus_sel_ch0_int : STD_LOGIC_VECTOR(2   DOWNTO   0);     -- Per channel test bus selection CRAMs
SIGNAL rtest_bus_sel_ch1_int : STD_LOGIC_VECTOR(2   DOWNTO   0);     -- Per channel test bus selection CRAMs
SIGNAL rtest_bus_sel_ch2_int : STD_LOGIC_VECTOR(2   DOWNTO   0);     -- Per channel test bus selection CRAMs
SIGNAL rtest_bus_sel_ch3_int : STD_LOGIC_VECTOR(2   DOWNTO   0);     -- Per channel test bus selection CRAMs
SIGNAL r8b10b_dec_ibm_en_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- 8B10B Decoder fix enable CRAM
SIGNAL r8b10b_dec_ibm_en_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- 8B10B Decoder fix enable CRAM
SIGNAL r8b10b_dec_ibm_en_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- 8B10B Decoder fix enable CRAM
SIGNAL r8b10b_dec_ibm_en_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- 8B10B Decoder fix enable CRAM
SIGNAL rrxfifo_lowlatency_en_int : STD_LOGIC_VECTOR(3   DOWNTO   0); -- RX FIFO low latency enable CRAM
SIGNAL rppm_cnt_reset_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- PPM counter reset CRAM (latched version on Test bus)
SIGNAL rrx_detect_bypass_int : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- PMA RX detection bypass enable CRAM
SIGNAL rclkcmpinsertpad_int : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Rate matching pad insertion enable CRAM

-- RX PMA CRAM wires to RX PMAs
SIGNAL rpmadwidth_rx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- RX PMA to RX PCS data width sel CRAMs
SIGNAL rpma_doublewidth_rx_int : STD_LOGIC_VECTOR(3   DOWNTO   0); -- RX PMA/PCS double width (16/20) sel CRAM
SIGNAL rrx_sloslv_ch0_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch1_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch2_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch3_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- Signal loss threshold select CRAMs
SIGNAL rrx_term_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RX input buffer termination select CRAMs
SIGNAL rrxvcobypass_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- RX VCO bypass CRAM
SIGNAL rbwctral_rx_ch0_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch1_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch2_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch3_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RX PLL loop filter bandwidth control CRAMs
SIGNAL rforce_sigdet_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- SIGDET forcing CRAM
SIGNAL rrefclk_sel_ch0_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch1_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch2_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch3_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- RXPLL alternative clock source selection CRAMs
SIGNAL rs_lpbk_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);		-- Serial loopback CRAM
SIGNAL r_rlpbk_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Reverse serial loopback CRAM for RX channel
SIGNAL rs_rdlpbk_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Serial reversed diagnostic loopback CRAM
SIGNAL rrx_revlb_sw_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Reverse loopback switch CRAM
SIGNAL risel_rx_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RXPLL charge pump current control CRAM
SIGNAL riupsel_rx_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL ridnsel_rx_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL rtesten_cp_rx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Charge pump test mode control CRAM in RXPLL
SIGNAL rtristate_cp_rx_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Charge pump tristate control CRAM in RXPLL
SIGNAL rtestupen_cp_rx_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Charge pump current test control CRAM in RXPLL
SIGNAL rtestdnen_cp_rx_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Charge pump current test control CRAM in RXPLL
SIGNAL rrx_vtt_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);	        -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);	        -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);	        -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);	        -- Programmable termination voltage setting CRAM
SIGNAL rlst_rx_ch0_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Low speed test selection CRAM
SIGNAL rlst_rx_ch1_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Low speed test selection CRAM
SIGNAL rlst_rx_ch2_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Low speed test selection CRAM
SIGNAL rlst_rx_ch3_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch0_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch1_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch2_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch3_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Low speed test selection CRAM
SIGNAL rltr_int             : STD_LOGIC_VECTOR(3   DOWNTO   0);		-- Lock to reference clock enable CRAM
SIGNAL rltd_int             : STD_LOGIC_VECTOR(3   DOWNTO   0);		-- Lock to received data enable CRAM
SIGNAL rrx_cru_m_ch0_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Programmable M control CRAM
SIGNAL rrx_cru_m_ch1_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Programmable M control CRAM
SIGNAL rrx_cru_m_ch2_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Programmable M control CRAM
SIGNAL rrx_cru_m_ch3_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Programmable M control CRAM
SIGNAL rrx_cru_l_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Programmable L contrl CRAM
SIGNAL rrx_ignore_phslck_int : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- Ignore phase lock CRAM
SIGNAL rrx_cru_ctl_ch0_int  : STD_LOGIC_VECTOR(5   DOWNTO   0);	-- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch1_int  : STD_LOGIC_VECTOR(5   DOWNTO   0);	-- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch2_int  : STD_LOGIC_VECTOR(5   DOWNTO   0);	-- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch3_int  : STD_LOGIC_VECTOR(5   DOWNTO   0);	-- Programmable control CRAM
SIGNAL rreg_cp_rx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- RX PLL charge pump regulator enable CRAM
SIGNAL rrx_piso_bypass_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- Reference bypass around PISO CRAM
SIGNAL rrx_cru_m_sel_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_div2_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Reference clock divided by 2 enable CRAM
SIGNAL rrx_osc_en_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- CGB RX OSC enable CRAM
SIGNAL rrx_cru_pdb_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Power down (bar) CRAM for CRU
SIGNAL rrx_cru_rst_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Reset CRAM for PLL in CRU
SIGNAL rrx_ib_pdb_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Power down (bar) for input buffer
--wire    [3:0]  rrx_sipo_pdb_int;	-- Power down (bar) for SIPO
SIGNAL rurx_pdb_int         : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Enable CRAM for URX_PDB dynamic signal
SIGNAL radce_pdb_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Power down for adaptive equalization
SIGNAL radce_rst_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Reset CRAM for counters in adaptive engine
SIGNAL rrx_dc_couple_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Programmable DC couple CRAM for RX wire  buffer
SIGNAL rrx_eq_dc_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- CRAMs for Equalizer block
SIGNAL radce_adapt_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Continuous adaptation enable CRAM
SIGNAL rseq_sel_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Sequence of adaptation selection CRAMs
SIGNAL rrgen_set_ch0_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- D2A control CRAMs
SIGNAL rrgen_set_ch1_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- D2A control CRAMs
SIGNAL rrgen_set_ch2_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- D2A control CRAMs
SIGNAL rrgen_set_ch3_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- D2A control CRAMs
SIGNAL rclkdiv_ch0_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch1_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch2_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch3_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Division ration selection CRAMs for adaptation engine
SIGNAL rf_lpf_ch0_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch1_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch2_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch3_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- LPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch0_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch1_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch2_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch3_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- HPF corner frequency setting CRAMs
SIGNAL rrgen_bw_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RGEN corner frequency setting CRAMs
SIGNAL rhyst_ch0_int        : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch1_int        : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch2_int        : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch3_int        : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Programmable digital filtering setting CRAMs
SIGNAL rrect_adj_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Rectifier leaker current setting CRAMs
SIGNAL rd2a_res_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- D2A resolution settting CRAMs
SIGNAL rrgen_vod_ch0_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch1_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch2_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch3_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- RGEN amplitude setting CRAMs
SIGNAL rlf_os_ch0_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch1_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch2_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch3_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch0_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch1_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch2_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch3_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- High freq. loop offset cancelling setting CRAMs
SIGNAL reqa_ct_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL rdc_freq_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- ADCE CRAM
SIGNAL rdc_freq_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- ADCE CRAM
SIGNAL rdc_freq_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- ADCE CRAM
SIGNAL rdc_freq_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- ADCE CRAM
SIGNAL r_iqclk_ch0_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- IQCLK selection CRAM
SIGNAL r_iqclk_ch1_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- IQCLK selection CRAM
SIGNAL r_iqclk_ch2_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- IQCLK selection CRAM
SIGNAL r_iqclk_ch3_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- IQCLK selection CRAM
SIGNAL r_dfe_ch0_int        : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- DFE CRAM
SIGNAL r_dfe_ch1_int        : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- DFE CRAM
SIGNAL r_dfe_ch2_int        : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- DFE CRAM
SIGNAL r_dfe_ch3_int        : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- DFE CRAM
SIGNAL r_cp_mode_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- CP mode CRAM
SIGNAL r_impctrl_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- IMPCTRL CRAM
SIGNAL r_impctrl_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- IMPCTRL CRAM
SIGNAL r_impctrl_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- IMPCTRL CRAM
SIGNAL r_impctrl_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- IMPCTRL CRAM
SIGNAL rpd_ien_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);             -- PD current setting CRAM
SIGNAL rrsvd_rx_ch0_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);        -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch1_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);        -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch2_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);        -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch3_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);        -- Rerserved CRAMs for both RX PCS and RX PMA

-- CMU PCS CRAMs wires to CMU
SIGNAL rindv_tx_int         : STD_LOGIC;          -- TX SM bypassing CRAM
SIGNAL rindv_rx_int         : STD_LOGIC;          -- RX SM bypassing CRAM
SIGNAL rdeskewen_int        : STD_LOGIC;         -- Deskew function enable CRAM
SIGNAL ralgnect_int         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL ralgnact_int         : STD_LOGIC_VECTOR(2   DOWNTO   0);          -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL ralgngct_int         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL rdskposdisp_int      : STD_LOGIC;       -- Match the programmed de-skew pattern only
SIGNAL rdskchrp_int         : STD_LOGIC_VECTOR(9   DOWNTO   0);          -- Programmable Deskew Char. Pos. Disp.
SIGNAL ralgnopt_int         : STD_LOGIC;          -- De-skew SM Hysteresis Option
SIGNAL rfreerun_centrl_int  : STD_LOGIC;   -- REFCLK_OUT free running enable CRAM
SIGNAL rcentrl_clk_sel_int  : STD_LOGIC;   -- REFCLK_PMA global clock selection CRAM
SIGNAL rrefclk_out_div2_int : STD_LOGIC;  -- REFCLK_OUT divide by 2 enable CRAM
SIGNAL rtest_bus_centrl_sel_int : STD_LOGIC_VECTOR(2   DOWNTO   0);  -- Central Test bus selection CRAMs
SIGNAL rendec_data_sel_tx_int : STD_LOGIC;-- TX 8B10B encoder data in selection CRAM
SIGNAL rendec_data_sel_rx_int : STD_LOGIC;-- RX 8B10B decoder data out selection CRAM
SIGNAL rphfifo_master_sel_tx_int : STD_LOGIC; -- TX Phase comp. FIFO pointers selection CRAM
SIGNAL rphfifo_master_sel_rx_int : STD_LOGIC; -- TX Phase comp. FIFO pointers selection CRAM

-- CMU PMA, and CLKREF CRAMs wires
SIGNAL rbgbypass_int        : STD_LOGIC;	      -- Bandgap bypass CRAM
--wire           ratb_en_int;	      -- Analog test bus enable CRAM
SIGNAL rlst_bg_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable test bus setting CRAM
SIGNAL rcmu_rst_int         : STD_LOGIC;	      -- Reset CRAM for divider in CMU feedback loop
SIGNAL rcmu_iqclkout_sel_int : STD_LOGIC; -- REFClock select for going to IQ lines CRAM
SIGNAL rcmu0_isel_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu1_isel_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu0_iupsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu1_iupsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu0_idnsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu1_idnsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu0_testen_cp_int  : STD_LOGIC;   -- Charge pump test mode control CRAM in TXPLL0
SIGNAL rcmu1_testen_cp_int  : STD_LOGIC;   -- Charge pump test mode control CRAM in TXPLL1
SIGNAL rcmu0_tristate_cp_int : STD_LOGIC; -- Charge pump tristate control CRAM in TXPLL0
SIGNAL rcmu1_tristate_cp_int : STD_LOGIC; -- Charge pump tristate control CRAM in TXPLL1
SIGNAL rcmu0_testupen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM in TXPLL0
SIGNAL rcmu1_testupen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM in TXPLL1
SIGNAL rcmu0_lst_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu1_lst_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu0_ctl_int        : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu1_ctl_int        : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu0_div2_int       : STD_LOGIC;	      -- Reference clock divided by 2 enable CRAM
SIGNAL rcmu1_div2_int       : STD_LOGIC;	      -- Reference clock divided by 2 enable CRAM
SIGNAL rcmu0_ref_sel_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Reference selection control CRAM
SIGNAL rcmu1_ref_sel_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Reference selection control CRAM
SIGNAL rcmu0_m_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M selection CRAM
SIGNAL rcmu1_m_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M selection CRAM
SIGNAL rcmu0_l_int          : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L selection CRAM
SIGNAL rcmu1_l_int          : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L selection CRAM
SIGNAL rcmu0_pdb_int        : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu1_pdb_int        : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu0_txpll_rst_int  : STD_LOGIC;   -- TXPLL0 reset CRAM
SIGNAL rcmu1_txpll_rst_int  : STD_LOGIC;   -- TXPLL0 reset CRAM
SIGNAL rcmu0_testdnen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM
SIGNAL rcmu1_testdnen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM
SIGNAL rcmu_peclrx0_cm_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- Common mode control CRAM
SIGNAL rcmu_peclrx1_cm_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- Common mode control CRAM
SIGNAL rcmu_peclrx0_lst_int : STD_LOGIC_VECTOR(3   DOWNTO   0);  -- Analog test bus setting CRAM
SIGNAL rcmu_peclrx1_lst_int : STD_LOGIC_VECTOR(3   DOWNTO   0);  -- Analog test bus setting CRAM
SIGNAL rcmu_txpll0_1x_en_int : STD_LOGIC; -- 1X enable CRAM in central CGB
SIGNAL rcmu_txpll1_1x_en_int : STD_LOGIC; -- 1X enable CRAM in central CGB
SIGNAL rcmu_txpll0_iqclkin_sel_int : STD_LOGIC_VECTOR(2   DOWNTO   0);-- IQ clock selection CRAMs
SIGNAL rcmu_txpll1_iqclkin_sel_int : STD_LOGIC_VECTOR(2   DOWNTO   0);-- IQ clock selection CRAMs
SIGNAL rcmu_cgb_cmusel_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Central CGB CMU selection CRAM
SIGNAL rcmu_cgb_ndiv_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- N-divider selection CRAM for wire  clock in central CGB
SIGNAL rcmu_cgb_div5_int    : STD_LOGIC;     -- TX PCS to TX PMA data width selection CRAM
SIGNAL rcmu_cgb_div2_int    : STD_LOGIC;     -- TX PCS to TX PMA double data width selection CRAM
SIGNAL rcmu_cgb_vcobypass_int : STD_LOGIC;-- CMU VCO bypass CRAM in central CGB
SIGNAL rcmu_cgb_4x_en_int   : STD_LOGIC;    -- Quad channel mode clock driver enable CRAM
SIGNAL rcmu_cgb_8x_en_int   : STD_LOGIC;    -- Eight channel mode clock driver enable CRAM
SIGNAL rcmu_cgb_pclksel_int : STD_LOGIC;  -- Central CGB PCLK select CRAM
SIGNAL rcmu2_isel_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu2_iupsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu2_idnsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu2_testen_cp_int  : STD_LOGIC;   -- Charge pump test mode control CRAM in TXPLL2
SIGNAL rcmu2_tristate_cp_int : STD_LOGIC; -- Charge pump tristate control CRAM in TXPLL2
SIGNAL rcmu2_testupen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM in TXPLL2
SIGNAL rcmu2_testdnen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM in TXPLL2
SIGNAL rcmu2_lst_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu2_ctl_int        : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu2_refsel_int     : STD_LOGIC;      -- Reference select CRAM for CMU2
SIGNAL rcmu2_m_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M selection CRAM
SIGNAL rcmu2_l_int          : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L selection CRAM
SIGNAL rcmu2_pdb_int        : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu2_txpll_rst_int  : STD_LOGIC;   -- TXPLL2 reset CRAM
SIGNAL rcmu0_rcp_mode_int   : STD_LOGIC;    -- CMU0 charge pump mode select CRAM
SIGNAL rcmu1_rcp_mode_int   : STD_LOGIC;    -- CMU1 charge pump mode select CRAM
SIGNAL rpma_testbus_sel_int : STD_LOGIC_VECTOR(3   DOWNTO   0);  -- PMA testbus selection
SIGNAL rrsvd_cmu_int        : STD_LOGIC_VECTOR(4   DOWNTO   0);         -- Reserved CRAMs for both PMA CMU and PCS CMU

SIGNAL pcs_ctrl_out_ch0     : STD_LOGIC_VECTOR(15  DOWNTO   0);      -- PCS MDIO out for channel0
SIGNAL pcs_ctrl_out_ch1     : STD_LOGIC_VECTOR(15  DOWNTO   0);      -- PCS MDIO out for channel1
SIGNAL pcs_ctrl_out_ch2     : STD_LOGIC_VECTOR(15  DOWNTO   0);      -- PCS MDIO out for channel2
SIGNAL pcs_ctrl_out_ch3     : STD_LOGIC_VECTOR(15  DOWNTO   0);      -- PCS MDIO out for channel3

-- Control register address parameters
signal XGXS_CTRL          : std_logic_vector(15 DOWNTO 0) :=  "0000000000000000";  -- 0000
signal XGXS_STATUS1       : std_logic_vector(15 DOWNTO 0) :=  "0000000000000001";  -- 0001
signal XGXS_STATUS2       : std_logic_vector(15 DOWNTO 0) :=  "0000000000001000";  -- 0008
signal XGXS_LANE_STATUS   : std_logic_vector(15 DOWNTO 0) :=  "0000000000011000";  -- 0018
signal TRUNKING_MODE      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000000";  -- 8000
signal PCS_CTRL1_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000001";  -- 8001
signal PCS_CTRL1_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000010";  -- 8002
signal PCS_CTRL1_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000011";  -- 8003
signal PCS_CTRL1_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000100";  -- 8004
signal PCS_CTRL2_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000101";  -- 8005
signal PCS_CTRL2_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000110";  -- 8006
signal PCS_CTRL2_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000111";  -- 8007
signal PCS_CTRL2_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001000";  -- 8008
signal PCS_CTRL3_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001001";  -- 8009
signal PCS_CTRL3_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001010";  -- 800a
signal PCS_CTRL3_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001011";  -- 800b
signal PCS_CTRL3_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001100";  -- 800c
signal PCS_CTRL4_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001101";  -- 800d
signal PCS_CTRL4_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001110";  -- 800e
signal PCS_CTRL4_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001111";  -- 800f
signal PCS_CTRL4_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010000";  -- 8010
signal PCS_CTRL5_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010001";  -- 8011
signal PCS_CTRL5_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010010";  -- 8012
signal PCS_CTRL5_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010011";  -- 8013
signal PCS_CTRL5_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010100";  -- 8014
signal PCS_CTRL6_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010101";  -- 8015
signal PCS_CTRL6_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010110";  -- 8016
signal PCS_CTRL6_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010111";  -- 8017
signal PCS_CTRL6_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011000";  -- 8018
signal PCS_CTRL7_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011001";  -- 8019
signal PCS_CTRL7_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011010";  -- 801a
signal PCS_CTRL7_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011011";  -- 801b
signal PCS_CTRL7_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011100";  -- 801c
signal PCS_CTRL8_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011101";  -- 801d
signal PCS_CTRL8_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011110";  -- 801e
signal PCS_CTRL8_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011111";  -- 801f
signal PCS_CTRL8_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000100000";  -- 8020
signal PRBS_BIST_CTRL_CH0 : std_logic_vector(15 DOWNTO 0) :=  "1000000000100001";  -- 8021
signal PRBS_BIST_CTRL_CH1 : std_logic_vector(15 DOWNTO 0) :=  "1000000000100010";  -- 8022
signal PRBS_BIST_CTRL_CH2 : std_logic_vector(15 DOWNTO 0) :=  "1000000000100011";  -- 8023
signal PRBS_BIST_CTRL_CH3 : std_logic_vector(15 DOWNTO 0) :=  "1000000000100100";  -- 8024
signal PCS_CTRL9_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000100101";  -- 8025
signal PCS_CTRL9_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000100110";  -- 8026
signal PCS_CTRL9_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000100111";  -- 8027
signal PCS_CTRL9_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000101000";  -- 8028
signal PCS_CTRL10_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101001";  -- 8029
signal PCS_CTRL10_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101010";  -- 802a
signal PCS_CTRL10_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101011";  -- 802b
signal PCS_CTRL10_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101100";  -- 802c
signal PCS_CTRL11_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101101";  -- 802d
signal PCS_CTRL11_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101110";  -- 802e
signal PCS_CTRL11_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101111";  -- 802f
signal PCS_CTRL11_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110000";  -- 8030
signal PCS_CTRL12_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110001";  -- 8031
signal PCS_CTRL12_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110010";  -- 8032
signal PCS_CTRL12_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110011";  -- 8033
signal PCS_CTRL12_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110100";  -- 8034
signal PCS_CTRL13_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110101";  -- 8035
signal PCS_CTRL13_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110110";  -- 8036
signal PCS_CTRL13_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110111";  -- 8037
signal PCS_CTRL13_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111000";  -- 8038
signal PCS_CTRL14_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111001";  -- 8039
signal PCS_CTRL14_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111010";  -- 803a
signal PCS_CTRL14_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111011";  -- 803b
signal PCS_CTRL14_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111100";  -- 803c
signal PCS_CTRL15_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111101";  -- 803d
signal PCS_CTRL15_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111110";  -- 803e
signal PCS_CTRL15_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111111";  -- 803f
signal PCS_CTRL15_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000001000000";  -- 8040
signal PCS_GLOBAL_CTRL0   : std_logic_vector(15 DOWNTO 0) :=  "1000000001010000";  -- 8050
signal PCS_GLOBAL_CTRL1   : std_logic_vector(15 DOWNTO 0) :=  "1000000001010001";  -- 8051
signal PCS_GLOBAL_CTRL2   : std_logic_vector(15 DOWNTO 0) :=  "1000000001010010";  -- 8052
signal PMA_CTRL1_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100000";  -- 8060
signal PMA_CTRL1_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100001";  -- 8061
signal PMA_CTRL1_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100010";  -- 8062
signal PMA_CTRL1_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100011";  -- 8063
signal PMA_CTRL2_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100100";  -- 8064
signal PMA_CTRL2_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100101";  -- 8065
signal PMA_CTRL2_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100110";  -- 8066
signal PMA_CTRL2_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100111";  -- 8067
signal PMA_CTRL3_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101000";  -- 8068
signal PMA_CTRL3_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101001";  -- 8069
signal PMA_CTRL3_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101010";  -- 806a
signal PMA_CTRL3_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101011";  -- 806b
signal PMA_CTRL4_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101100";  -- 806c
signal PMA_CTRL4_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101101";  -- 806d
signal PMA_CTRL4_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101110";  -- 806e
signal PMA_CTRL4_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101111";  -- 806f
signal PMA_CTRL5_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110000";  -- 8070
signal PMA_CTRL5_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110001";  -- 8071
signal PMA_CTRL5_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110010";  -- 8072
signal PMA_CTRL5_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110011";  -- 8073
signal PMA_CTRL6_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110100";  -- 8074
signal PMA_CTRL6_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110101";  -- 8075
signal PMA_CTRL6_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110110";  -- 8076
signal PMA_CTRL6_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110111";  -- 8077
signal PMA_CTRL7_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111000";  -- 8078
signal PMA_CTRL7_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111001";  -- 8079
signal PMA_CTRL7_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111010";  -- 807a
signal PMA_CTRL7_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111011";  -- 807b
signal PMA_CTRL8_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111100";  -- 807c
signal PMA_CTRL8_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111101";  -- 807d
signal PMA_CTRL8_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111110";  -- 807e
signal PMA_CTRL8_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111111";  -- 807f
signal PMA_CTRL9_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000010000000";  -- 8080
signal PMA_CTRL9_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000010000001";  -- 8081
signal PMA_CTRL9_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000010000010";  -- 8082
signal PMA_CTRL9_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000010000011";  -- 8083
signal PMA_CTRL10_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000010000100";  -- 8084
signal PMA_CTRL10_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000010000101";  -- 8085
signal PMA_CTRL10_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000010000110";  -- 8086
signal PMA_CTRL10_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000010000111";  -- 8087
signal PMA_CTRL11_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000010001000";  -- 8088
signal PMA_CTRL11_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000010001001";  -- 8089
signal PMA_CTRL11_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000010001010";  -- 808a
signal PMA_CTRL11_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000010001011";  -- 808b
signal PMA_GLOBAL_CTRL0   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010000";  -- 8090
signal PMA_GLOBAL_CTRL1   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010001";  -- 8091
signal PMA_GLOBAL_CTRL2   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010010";  -- 8092
signal PMA_GLOBAL_CTRL3   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010011";  -- 8093
signal PMA_GLOBAL_CTRL4   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010100";  -- 8094
signal PMA_GLOBAL_CTRL5   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010101";  -- 8095
signal PMA_GLOBAL_CTRL6   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010110";  -- 8096
signal PMA_GLOBAL_CTRL7   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010111";  -- 8097
signal PMA_GLOBAL_CTRL8   : std_logic_vector(15 DOWNTO 0) :=  "1000000010011000";  -- 8098
signal PMA_GLOBAL_CTRL9   : std_logic_vector(15 DOWNTO 0) :=  "1000000010011001";  -- 8099

--------------------------------------------------------------------------------
-- mqmap begin                                                                --
--------------------------------------------------------------------------------
CONSTANT TX_PMA_ST : INTEGER := 68;
CONSTANT RX_PMA_ST : INTEGER := 220; -- expanded from 154. Now 80 for PMA used 32

--logic - in and out: interface to upper level
SIGNAL rxdprioin_logic_ch0 : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioin_logic_ch1 : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioin_logic_ch2 : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioin_logic_ch3 : STD_LOGIC_VECTOR(299 DOWNTO   0);

SIGNAL txdprioin_logic_ch0 : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioin_logic_ch1 : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioin_logic_ch2 : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioin_logic_ch3 : STD_LOGIC_VECTOR(149  DOWNTO   0);

SIGNAL cmuplldprioin_logic_0 : STD_LOGIC_VECTOR(39  DOWNTO   0);
SIGNAL cmuplldprioin_logic_1 : STD_LOGIC_VECTOR(39  DOWNTO   0);
SIGNAL cmuplldprioin_logic_2 : STD_LOGIC_VECTOR(39  DOWNTO   0);

SIGNAL rxdprioout_logic_ch0 : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioout_logic_ch1 : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioout_logic_ch2 : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioout_logic_ch3 : STD_LOGIC_VECTOR(299 DOWNTO   0);


SIGNAL txdprioout_logic_ch0 : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioout_logic_ch1 : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioout_logic_ch2 : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioout_logic_ch3 : STD_LOGIC_VECTOR(149  DOWNTO   0);

SIGNAL cmuplldprioout_logic_0 : STD_LOGIC_VECTOR(39  DOWNTO   0);
SIGNAL cmuplldprioout_logic_1 : STD_LOGIC_VECTOR(39  DOWNTO   0);
SIGNAL cmuplldprioout_logic_2 : STD_LOGIC_VECTOR(39  DOWNTO   0);

-- phy - in and out: interface to lower level
SIGNAL rxdprioin_phy_ch0   : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioin_phy_ch1   : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioin_phy_ch2   : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioin_phy_ch3   : STD_LOGIC_VECTOR(299 DOWNTO   0);

SIGNAL txdprioin_phy_ch0   : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioin_phy_ch1   : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioin_phy_ch2   : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioin_phy_ch3   : STD_LOGIC_VECTOR(149  DOWNTO   0);

SIGNAL cmuplldprioin_phy_0 : STD_LOGIC_VECTOR(39  DOWNTO   0);
SIGNAL cmuplldprioin_phy_1 : STD_LOGIC_VECTOR(39  DOWNTO   0);
SIGNAL cmuplldprioin_phy_2 : STD_LOGIC_VECTOR(39  DOWNTO   0);

SIGNAL rxdprioout_phy_ch0  : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioout_phy_ch1  : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioout_phy_ch2  : STD_LOGIC_VECTOR(299 DOWNTO   0);
SIGNAL rxdprioout_phy_ch3  : STD_LOGIC_VECTOR(299 DOWNTO   0);

SIGNAL txdprioout_phy_ch0  : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioout_phy_ch1  : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioout_phy_ch2  : STD_LOGIC_VECTOR(149  DOWNTO   0);
SIGNAL txdprioout_phy_ch3  : STD_LOGIC_VECTOR(149  DOWNTO   0);

SIGNAL cmuplldprioout_phy_0 : STD_LOGIC_VECTOR(39  DOWNTO   0);
SIGNAL cmuplldprioout_phy_1 : STD_LOGIC_VECTOR(39  DOWNTO   0);
SIGNAL cmuplldprioout_phy_2 : STD_LOGIC_VECTOR(39  DOWNTO   0);

BEGIN  -- logic

jtag_shift_load <= dprioload;

-- rxdprioin_logic_ch0 <= rxdprioin(899  DOWNTO 800 ) & rxdprioin(199 DOWNTO 0);
-- rxdprioin_logic_ch1 <= rxdprioin(999  DOWNTO 900 ) & rxdprioin(399 DOWNTO 200);
-- rxdprioin_logic_ch2 <= rxdprioin(1099 DOWNTO 1000) & rxdprioin(599 DOWNTO 400);
-- rxdprioin_logic_ch3 <= rxdprioin(1199 DOWNTO 1100) & rxdprioin(799 DOWNTO 600);

cmuplldprioin_logic_0 <= cmuplldprioin(39 DOWNTO 0);
cmuplldprioin_logic_1 <= cmuplldprioin(79 DOWNTO 40);
cmuplldprioin_logic_2 <= cmuplldprioin(119 DOWNTO 80);

    PROCESS(rxdprioin)
    VARIABLE i : integer := 0;
    BEGIN
        i := 0;
        WHILE (i < rx_dprio_width) LOOP
            if (i<200) THEN
                                     rxdprioin_logic_ch0(i) <= rxdprioin(i);
            ELSIF (i<400 AND i>=200) THEN
                                     rxdprioin_logic_ch1(i-200) <= rxdprioin(i);
            ELSIF (i<600 AND i>=400) THEN
                                     rxdprioin_logic_ch2(i-400) <= rxdprioin(i);
            ELSIF (i<800 AND i>=600) THEN
                                     rxdprioin_logic_ch3(i-600) <= rxdprioin(i);
            ELSIF (i<900 AND i>=800) THEN    
                                     rxdprioin_logic_ch0(i-800 + 200) <= rxdprioin(i);
            ELSIF (i<1000 AND i>=900) THEN    
                                     rxdprioin_logic_ch1(i-900 + 200) <= rxdprioin(i);
            ELSIF (i<1100 AND i>=1000) THEN    
                                     rxdprioin_logic_ch2(i-1000 + 200) <= rxdprioin(i);        
            ELSIF (i<1200 AND i>=1100) THEN    
                                     rxdprioin_logic_ch3(i-1100 + 200) <= rxdprioin(i);
            END IF;        
             
            i := i + 1;
        END LOOP;
    END PROCESS;


--rxdprioout(199 DOWNTO 0)   <= rxdprioout_logic_ch0(199 DOWNTO 0);
--rxdprioout(399 DOWNTO 200) <= rxdprioout_logic_ch1(199 DOWNTO 0);
--rxdprioout(599 DOWNTO 400) <= rxdprioout_logic_ch2(199 DOWNTO 0);
--rxdprioout(799 DOWNTO 600) <= rxdprioout_logic_ch3(199 DOWNTO 0);
-- expanded in 6.1
--rxdprioout(899  DOWNTO 800 ) <= rxdprioout_logic_ch0(299 DOWNTO 200);
--rxdprioout(999  DOWNTO 900 ) <= rxdprioout_logic_ch1(299 DOWNTO 200);
--rxdprioout(1099 DOWNTO 1000) <= rxdprioout_logic_ch2(299 DOWNTO 200);
--rxdprioout(1199 DOWNTO 1100) <= rxdprioout_logic_ch3(299 DOWNTO 200);

cmuplldprioout <= cmuplldprioout_logic_2 & cmuplldprioout_logic_1 & cmuplldprioout_logic_0;

PROCESS(rxdprioout_logic_ch0, rxdprioout_logic_ch1, rxdprioout_logic_ch2, rxdprioout_logic_ch3)
    VARIABLE i : integer := 0;
    BEGIN
        i := 0;
        WHILE (i < rx_dprio_width) LOOP
            IF (i<200) THEN
                                        rxdprioout(i) <= rxdprioout_logic_ch0(i);
            ELSIF (i<400 AND i>=200) THEN
                                        rxdprioout(i) <= rxdprioout_logic_ch1(i-200);
            ELSIF (i<600 AND i>=400) THEN
                                        rxdprioout(i) <= rxdprioout_logic_ch2(i-400);
            ELSIF (i<800 AND i>=600) THEN
                                        rxdprioout(i) <= rxdprioout_logic_ch3(i-600);
            ELSIF (i<900 AND i>=800) THEN    
                                        rxdprioout(i) <= rxdprioout_logic_ch0(i-800 + 200);
            ELSIF (i<1000 AND i>=900) THEN    
                                        rxdprioout(i) <= rxdprioout_logic_ch1(i-900 + 200);
            ELSIF (i<1100 AND i>=1000) THEN    
                                        rxdprioout(i) <= rxdprioout_logic_ch2(i-1000 + 200);        
            ELSIF (i<1200 AND i>=1100) THEN    
                                        rxdprioout(i) <= rxdprioout_logic_ch3(i-1100 + 200);        
            END IF;        
             
            i := i + 1;
        END LOOP;
    END PROCESS;

--txdprioin_logic_ch0 <= txdprioin(449 DOWNTO 400) & txdprioin(99 DOWNTO 0);
--txdprioin_logic_ch1 <= txdprioin(499 DOWNTO 450) & txdprioin(199 DOWNTO 100);
--txdprioin_logic_ch2 <= txdprioin(549 DOWNTO 500) & txdprioin(299 DOWNTO 200);
--txdprioin_logic_ch3 <= txdprioin(599 DOWNTO 550) & txdprioin(399 DOWNTO 300);
    PROCESS (txdprioin)
    VARIABLE i : integer := 0;
    BEGIN
        i := 0;
        WHILE (i < tx_dprio_width) LOOP
            IF (i<100) THEN
                                      txdprioin_logic_ch0(i) <= txdprioin(i);
            ELSIF (i<200 AND i>=100) THEN
                                      txdprioin_logic_ch1(i-100) <= txdprioin(i);
            ELSIF (i<300 AND i>=200) THEN
                                      txdprioin_logic_ch2(i-200) <= txdprioin(i);
            ELSIF (i<400 AND i>=300) THEN
                                      txdprioin_logic_ch3(i-300) <= txdprioin(i);
            ELSIF (i<450 AND i>=400) THEN    
                                      txdprioin_logic_ch0(i-400 + 100) <= txdprioin(i);
            ELSIF (i<500 AND i>=450) THEN    
                                      txdprioin_logic_ch1(i-450 + 100) <= txdprioin(i);
            ELSIF (i<550 AND i>=500) THEN   
                                      txdprioin_logic_ch2(i-500 + 100) <= txdprioin(i);        
            ELSIF (i<600 AND i>=550) THEN    
                                      txdprioin_logic_ch3(i-550 + 100) <= txdprioin(i);        
            END IF;        
             
            i := i + 1;
        END LOOP;
    END PROCESS;

--txdprioout(99 DOWNTO 0)    <= txdprioout_logic_ch0(99 DOWNTO 0);
--txdprioout(199 DOWNTO 100) <= txdprioout_logic_ch1(99 DOWNTO 0);
--txdprioout(299 DOWNTO 200) <= txdprioout_logic_ch2(99 DOWNTO 0);
--txdprioout(399 DOWNTO 300) <= txdprioout_logic_ch3(99 DOWNTO 0);
-- expanded width in 6.1
--txdprioout(449 DOWNTO 400) <= txdprioout_logic_ch0(149 DOWNTO 100);
--txdprioout(499 DOWNTO 450) <= txdprioout_logic_ch1(149 DOWNTO 100);
--txdprioout(549 DOWNTO 500) <= txdprioout_logic_ch2(149 DOWNTO 100);
--txdprioout(599 DOWNTO 550) <= txdprioout_logic_ch3(149 DOWNTO 100);
    PROCESS (txdprioout_logic_ch0, txdprioout_logic_ch1, txdprioout_logic_ch2, txdprioout_logic_ch3)
    VARIABLE i : integer := 0;
    BEGIN
        i := 0;
        WHILE (i < tx_dprio_width) LOOP
            IF (i<100) THEN
                                        txdprioout(i) <= txdprioout_logic_ch0(i);
            ELSIF (i<200 AND i>=100) THEN
                                        txdprioout(i) <= txdprioout_logic_ch1(i-100);
            ELSIF (i<300 AND i>=200) THEN
                                        txdprioout(i) <= txdprioout_logic_ch2(i-200);
            ELSIF (i<400 AND i>=300) THEN
                                        txdprioout(i) <= txdprioout_logic_ch3(i-300);
            ELSIF (i<450 AND i>=400) THEN    
                                        txdprioout(i) <= txdprioout_logic_ch0(i-400 + 100);
            ELSIF (i<500 AND i>=450) THEN    
                                        txdprioout(i) <= txdprioout_logic_ch1(i-450 + 100);
            ELSIF (i<550 AND i>=500) THEN    
                                        txdprioout(i) <= txdprioout_logic_ch2(i-500 + 100);        
            ELSIF (i<600 AND i>=550) THEN    
                                        txdprioout(i) <= txdprioout_logic_ch3(i-550 + 100);        
            END IF;        
             
            i := i + 1;
        END LOOP;
    END PROCESS;

-- phy map: input is logic --> phy
rxdprioin_phy_ch0 <=  rxdprioin_logic_ch0 WHEN (rx0_phy = 0) ELSE rxdprioin_logic_ch1 WHEN (rx1_phy = 0) ELSE rxdprioin_logic_ch2 WHEN (rx2_phy = 0) ELSE rxdprioin_logic_ch3;
rxdprioin_phy_ch1 <=  rxdprioin_logic_ch0 WHEN (rx0_phy = 1) ELSE rxdprioin_logic_ch1 WHEN (rx1_phy = 1) ELSE rxdprioin_logic_ch2 WHEN (rx2_phy = 1) ELSE rxdprioin_logic_ch3;
rxdprioin_phy_ch2 <=  rxdprioin_logic_ch0 WHEN (rx0_phy = 2) ELSE rxdprioin_logic_ch1 WHEN (rx1_phy = 2) ELSE rxdprioin_logic_ch2 WHEN (rx2_phy = 2) ELSE rxdprioin_logic_ch3;
rxdprioin_phy_ch3 <=  rxdprioin_logic_ch0 WHEN (rx0_phy = 3) ELSE rxdprioin_logic_ch1 WHEN (rx1_phy = 3) ELSE rxdprioin_logic_ch2 WHEN (rx2_phy = 3) ELSE rxdprioin_logic_ch3;

txdprioin_phy_ch0 <=  txdprioin_logic_ch0 WHEN (tx0_phy = 0) ELSE txdprioin_logic_ch1 WHEN (tx1_phy = 0) ELSE txdprioin_logic_ch2 WHEN (tx2_phy = 0) ELSE txdprioin_logic_ch3;
txdprioin_phy_ch1 <=  txdprioin_logic_ch0 WHEN (tx0_phy = 1) ELSE txdprioin_logic_ch1 WHEN (tx1_phy = 1) ELSE txdprioin_logic_ch2 WHEN (tx2_phy = 1) ELSE txdprioin_logic_ch3;
txdprioin_phy_ch2 <=  txdprioin_logic_ch0 WHEN (tx0_phy = 2) ELSE txdprioin_logic_ch1 WHEN (tx1_phy = 2) ELSE txdprioin_logic_ch2 WHEN (tx2_phy = 2) ELSE txdprioin_logic_ch3;
txdprioin_phy_ch3 <=  txdprioin_logic_ch0 WHEN (tx0_phy = 3) ELSE txdprioin_logic_ch1 WHEN (tx1_phy = 3) ELSE txdprioin_logic_ch2 WHEN (tx2_phy = 3) ELSE txdprioin_logic_ch3;

cmuplldprioin_phy_0 <= cmuplldprioin_logic_0 WHEN (pll0_phy = 0) ELSE cmuplldprioin_logic_1 WHEN (pll1_phy = 0) ELSE cmuplldprioin_logic_2;
cmuplldprioin_phy_1 <= cmuplldprioin_logic_0 WHEN (pll0_phy = 1) ELSE cmuplldprioin_logic_1 WHEN (pll1_phy = 1) ELSE cmuplldprioin_logic_2;
cmuplldprioin_phy_2 <= cmuplldprioin_logic_0 WHEN (pll0_phy = 2) ELSE cmuplldprioin_logic_1 WHEN (pll1_phy = 2) ELSE cmuplldprioin_logic_2;

-- phy map: output is phy --> logic
rxdprioout_logic_ch0 <=  rxdprioout_phy_ch0 WHEN (rx0_phy = 0) ELSE rxdprioout_phy_ch1 WHEN (rx0_phy = 1) ELSE rxdprioout_phy_ch2 WHEN (rx0_phy = 2) ELSE rxdprioout_phy_ch3;
rxdprioout_logic_ch1 <=  rxdprioout_phy_ch0 WHEN (rx1_phy = 0) ELSE rxdprioout_phy_ch1 WHEN (rx1_phy = 1) ELSE rxdprioout_phy_ch2 WHEN (rx1_phy = 2) ELSE rxdprioout_phy_ch3;
rxdprioout_logic_ch2 <=  rxdprioout_phy_ch0 WHEN (rx2_phy = 0) ELSE rxdprioout_phy_ch1 WHEN (rx2_phy = 1) ELSE rxdprioout_phy_ch2 WHEN (rx2_phy = 2) ELSE rxdprioout_phy_ch3;
rxdprioout_logic_ch3 <=  rxdprioout_phy_ch0 WHEN (rx3_phy = 0) ELSE rxdprioout_phy_ch1 WHEN (rx3_phy = 1) ELSE rxdprioout_phy_ch2 WHEN (rx3_phy = 2) ELSE rxdprioout_phy_ch3;

txdprioout_logic_ch0 <=  txdprioout_phy_ch0 WHEN (tx0_phy = 0) ELSE txdprioout_phy_ch1 WHEN (tx0_phy = 1) ELSE txdprioout_phy_ch2 WHEN (tx0_phy = 2) ELSE txdprioout_phy_ch3;
txdprioout_logic_ch1 <=  txdprioout_phy_ch0 WHEN (tx1_phy = 0) ELSE txdprioout_phy_ch1 WHEN (tx1_phy = 1) ELSE txdprioout_phy_ch2 WHEN (tx1_phy = 2) ELSE txdprioout_phy_ch3;
txdprioout_logic_ch2 <=  txdprioout_phy_ch0 WHEN (tx2_phy = 0) ELSE txdprioout_phy_ch1 WHEN (tx2_phy = 1) ELSE txdprioout_phy_ch2 WHEN (tx2_phy = 2) ELSE txdprioout_phy_ch3;
txdprioout_logic_ch3 <=  txdprioout_phy_ch0 WHEN (tx3_phy = 0) ELSE txdprioout_phy_ch1 WHEN (tx3_phy = 1) ELSE txdprioout_phy_ch2 WHEN (tx3_phy = 2) ELSE txdprioout_phy_ch3;

cmuplldprioout_logic_0 <= cmuplldprioout_phy_0 WHEN (pll0_phy = 0) ELSE cmuplldprioout_phy_1 WHEN (pll0_phy = 1) ELSE cmuplldprioout_phy_2;
cmuplldprioout_logic_1 <= cmuplldprioout_phy_0 WHEN (pll1_phy = 0) ELSE cmuplldprioout_phy_1 WHEN (pll1_phy = 1) ELSE cmuplldprioout_phy_2;
cmuplldprioout_logic_2 <= cmuplldprioout_phy_0 WHEN (pll2_phy = 0) ELSE cmuplldprioout_phy_1 WHEN (pll2_phy = 1) ELSE cmuplldprioout_phy_2;

-- CMUPLL REFCLK SELECT - input/output (parameter) -----------------------------------------
-- -------------------------------------------------------------------------------------
    PROCESS  -- initialize the TABLE
        VARIABLE init_table                : STD_LOGIC := '1';  
        VARIABLE tmp_int                   : INTEGER := 0; 
        
        BEGIN
        IF (init_table = '1') THEN
            cmupll0_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_IQ0)        <= "10U000";
            cmupll0_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_IQ1)        <= "10U001";
            cmupll0_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_IQ2)        <= "10U010";
            cmupll0_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_IQ3)        <= "10U011";
            cmupll0_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_IQ4)        <= "10U100";
            cmupll0_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_PLD_CLK)    <= "10U101";
            -- iqsel below is donot care so take default for preventing X values passing around
            -- notice the slight difference of below 2 between pll0 and pll1 
            cmupll0_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_REFCLK0)    <= "00U000"; 
            cmupll0_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_REFCLK1)    <= "01U000";
            cmupll0_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_ERR)        <= "11U111";
    
            cmupll1_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_IQ0)        <= "10U000";
            cmupll1_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_IQ1)        <= "10U001";
            cmupll1_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_IQ2)        <= "10U010";
            cmupll1_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_IQ3)        <= "10U011";
            cmupll1_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_IQ4)        <= "10U100";
            cmupll1_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_PLD_CLK)    <= "10U101";
            -- iqsel below is donot care so take default for preventing X values passing around
            cmupll1_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_REFCLK0)    <= "01U000"; 
            cmupll1_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_REFCLK1)    <= "00U000";
            cmupll1_clock_phyport_to_cram(CMUPLL_CLOCK_SELECT_ERR)        <= "11U111";
            
            -- pll0 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll0_inclk0_logical_to_physical_mapping);
            cmupll0_clock_index_to_phyport(0) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll0_inclk1_logical_to_physical_mapping);
            cmupll0_clock_index_to_phyport(1) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll0_inclk2_logical_to_physical_mapping);
            cmupll0_clock_index_to_phyport(2) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll0_inclk3_logical_to_physical_mapping);
            cmupll0_clock_index_to_phyport(3) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll0_inclk4_logical_to_physical_mapping);
            cmupll0_clock_index_to_phyport(4) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll0_inclk5_logical_to_physical_mapping);
            cmupll0_clock_index_to_phyport(5) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll0_inclk6_logical_to_physical_mapping);
            cmupll0_clock_index_to_phyport(6) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll0_inclk7_logical_to_physical_mapping);
            cmupll0_clock_index_to_phyport(7) <= tmp_int; 
            
            -- pll1 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll1_inclk0_logical_to_physical_mapping);
            cmupll1_clock_index_to_phyport(0) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll1_inclk1_logical_to_physical_mapping);
            cmupll1_clock_index_to_phyport(1) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll1_inclk2_logical_to_physical_mapping);
            cmupll1_clock_index_to_phyport(2) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll1_inclk3_logical_to_physical_mapping);
            cmupll1_clock_index_to_phyport(3) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll1_inclk4_logical_to_physical_mapping);
            cmupll1_clock_index_to_phyport(4) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll1_inclk5_logical_to_physical_mapping);
            cmupll1_clock_index_to_phyport(5) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll1_inclk6_logical_to_physical_mapping);
            cmupll1_clock_index_to_phyport(6) <= tmp_int; 
            tmp_int := convert_cmupll_phyport_str_to_phyport_enum(pll1_inclk7_logical_to_physical_mapping);
            cmupll1_clock_index_to_phyport(7) <= tmp_int; 
            
            init_table := '0';
        END IF;
    
        WAIT; 
    END PROCESS;  -- end of initializing tables

    -- pll0 - logic channel
    tmp_cmupll0_clock_select_vec <= cmuplldprioin_logic_0(refclk_select_DP_CMUPLL_IDX_2 DOWNTO refclk_select_DP_CMUPLL_IDX_0) WHEN
                               ((cmuplldprioin_logic_0(refclk_select_DP_CMUPLL_IDX_0) = '1' OR cmuplldprioin_logic_0(refclk_select_DP_CMUPLL_IDX_0) = '0') AND
                                (cmuplldprioin_logic_0(refclk_select_DP_CMUPLL_IDX_1) = '1' OR cmuplldprioin_logic_0(refclk_select_DP_CMUPLL_IDX_1) = '0') AND
                                (cmuplldprioin_logic_0(refclk_select_DP_CMUPLL_IDX_2) = '1' OR cmuplldprioin_logic_0(refclk_select_DP_CMUPLL_IDX_2) = '0')) ELSE 
                                "000"; -- tmp variable to prevent conversion function overflow due huge rxdprioin_logic vector
    cmupll0_clock_select <= dprio_reg_to_int(tmp_cmupll0_clock_select_vec);
    
    cmupll0_clock_phyport    <= cmupll0_clock_index_to_phyport(cmupll0_clock_select);
    -- switch to physical PLL number as the phyport_to_cram conversion based on NPP is on physical PLL channel
    cmupll0_clock_phyport_phy <= cmupll0_clock_phyport WHEN (pll0_phy = 0) ELSE  cmupll1_clock_phyport;
    cmupll0_clock_cram_phy <= cmupll0_clock_phyport_to_cram(cmupll0_clock_phyport_phy);
    rcmu0_ref_sel           <= cmupll0_clock_cram_phy(5 DOWNTO 4);
    rcmu_txpll0_iqclkin_sel <= cmupll0_clock_cram_phy(2 DOWNTO 0);

    -- pll1 - logic channel
    tmp_cmupll1_clock_select_vec <= cmuplldprioin_logic_1(refclk_select_DP_CMUPLL_IDX_2 DOWNTO refclk_select_DP_CMUPLL_IDX_0) WHEN
                               ((cmuplldprioin_logic_1(refclk_select_DP_CMUPLL_IDX_0) = '1' OR cmuplldprioin_logic_1(refclk_select_DP_CMUPLL_IDX_0) = '0') AND
                                (cmuplldprioin_logic_1(refclk_select_DP_CMUPLL_IDX_1) = '1' OR cmuplldprioin_logic_1(refclk_select_DP_CMUPLL_IDX_1) = '0') AND
                                (cmuplldprioin_logic_1(refclk_select_DP_CMUPLL_IDX_2) = '1' OR cmuplldprioin_logic_1(refclk_select_DP_CMUPLL_IDX_2) = '0')) ELSE 
                                "000"; -- tmp variable to prevent conversion function overflow due huge rxdprioin_logic vector
    cmupll1_clock_select <= dprio_reg_to_int(tmp_cmupll1_clock_select_vec);
    
    cmupll1_clock_phyport    <= cmupll1_clock_index_to_phyport(cmupll1_clock_select);
    -- switch to physical PLL number as the phyport_to_cram conversion based on NPP is on physical PLL channel
    cmupll1_clock_phyport_phy <= cmupll1_clock_phyport WHEN (pll1_phy = 1) ELSE  cmupll0_clock_phyport;
    cmupll1_clock_cram_phy <= cmupll1_clock_phyport_to_cram(cmupll1_clock_phyport_phy);
    rcmu1_ref_sel           <= cmupll1_clock_cram_phy(5 DOWNTO 4);
    rcmu_txpll1_iqclkin_sel <= cmupll1_clock_cram_phy(2 DOWNTO 0);
  
    -- CMUPLL - output (parameter) ------------------------------
    
    -- pll0 - CRMA on physical 
    cmupll0_clock_phyport_out <= convert_cmupll0_clock_cram_to_phyport(rcmu0_ref_sel_int, rcmu_txpll0_iqclkin_sel_int);
    -- but the map is on logic channel 
    cmupll0_clock_phyport_out_logic <= cmupll0_clock_phyport_out WHEN (pll0_phy = 0) ELSE cmupll1_clock_phyport_out;

    cmupll0_clock_select_out_logic <= "0000" WHEN (cmupll0_clock_index_to_phyport(0) = cmupll0_clock_phyport_out_logic) ELSE 
                                      "0001" WHEN (cmupll0_clock_index_to_phyport(1) = cmupll0_clock_phyport_out_logic) ELSE 
                                      "0010" WHEN (cmupll0_clock_index_to_phyport(2) = cmupll0_clock_phyport_out_logic) ELSE 
                                      "0011" WHEN (cmupll0_clock_index_to_phyport(3) = cmupll0_clock_phyport_out_logic) ELSE 
                                      "0100" WHEN (cmupll0_clock_index_to_phyport(4) = cmupll0_clock_phyport_out_logic) ELSE
                                      "0101" WHEN (cmupll0_clock_index_to_phyport(5) = cmupll0_clock_phyport_out_logic) ELSE 
                                      "0110" WHEN (cmupll0_clock_index_to_phyport(6) = cmupll0_clock_phyport_out_logic) ELSE
                                      "0111" WHEN (cmupll0_clock_index_to_phyport(7) = cmupll0_clock_phyport_out_logic) ELSE 
                                      "1000";  -- invalid cram values
    -- back to physical
    cmupll0_clock_select_out <= cmupll0_clock_select_out_logic WHEN (pll0_phy = 0) ELSE cmupll1_clock_select_out_logic;
                                                                          
    cmuplldprioout_phy_0(refclk_select_DP_CMUPLL_IDX_2 DOWNTO refclk_select_DP_CMUPLL_IDX_0) <= cmupll0_clock_select_out(2 DOWNTO 0);                            
        
    -- pll1 - CRMA on physical 
    cmupll1_clock_phyport_out <= convert_cmupll1_clock_cram_to_phyport(rcmu1_ref_sel_int, rcmu_txpll1_iqclkin_sel_int);
    -- but the map is on logic channel 
    cmupll1_clock_phyport_out_logic <= cmupll1_clock_phyport_out WHEN (pll1_phy = 1) ELSE cmupll0_clock_phyport_out;

    cmupll1_clock_select_out_logic <= "0000" WHEN (cmupll1_clock_index_to_phyport(0) = cmupll1_clock_phyport_out_logic) ELSE 
                                      "0001" WHEN (cmupll1_clock_index_to_phyport(1) = cmupll1_clock_phyport_out_logic) ELSE 
                                      "0010" WHEN (cmupll1_clock_index_to_phyport(2) = cmupll1_clock_phyport_out_logic) ELSE 
                                      "0011" WHEN (cmupll1_clock_index_to_phyport(3) = cmupll1_clock_phyport_out_logic) ELSE 
                                      "0100" WHEN (cmupll1_clock_index_to_phyport(4) = cmupll1_clock_phyport_out_logic) ELSE
                                      "0101" WHEN (cmupll1_clock_index_to_phyport(5) = cmupll1_clock_phyport_out_logic) ELSE 
                                      "0110" WHEN (cmupll1_clock_index_to_phyport(6) = cmupll1_clock_phyport_out_logic) ELSE
                                      "0111" WHEN (cmupll1_clock_index_to_phyport(7) = cmupll1_clock_phyport_out_logic) ELSE 
                                      "1000";  -- invalid cram values
    -- back to physical
    cmupll1_clock_select_out <= cmupll1_clock_select_out_logic WHEN (pll1_phy = 1) ELSE cmupll0_clock_select_out_logic;
                                                                          
    cmuplldprioout_phy_1(refclk_select_DP_CMUPLL_IDX_2 DOWNTO refclk_select_DP_CMUPLL_IDX_0) <= cmupll1_clock_select_out(2 DOWNTO 0);                            
-- end of CMU PLL refclk select

-- CRU_CLOCK_SElECT - input/output (parameter) -----------------------------------------
-- cram rrefclk_sel_ch0_int in PMA page 6
-- rrx_piso_bypass_ch0_int in PMA page 4
-- -------------------------------------------------------------------------------------
    PROCESS

        --///////////////////////////////////////////////////////////////////////////////
        -- Internal Functions  --------------------------------------------------------//
        --///////////////////////////////////////////////////////////////////////////////
        PROCEDURE convert_phyport_str_to_phyport_enum (
            phyport_str  : IN string;
            result       : OUT INTEGER)  IS
        
            VARIABLE res : INTEGER;   
            VARIABLE txt : LINE;
        BEGIN
            IF (phyport_str ="none") THEN
                                        res := CRU_CLOCK_SELECT_NONE;
            ELSIF (phyport_str = "iq0" ) THEN 
                                        res := CRU_CLOCK_SELECT_IQ0;
            ELSIF (phyport_str =  "iq1" ) THEN 
                                         res := CRU_CLOCK_SELECT_IQ1;
            ELSIF (phyport_str =  "iq2" ) THEN 
                                         res := CRU_CLOCK_SELECT_IQ2;
            ELSIF (phyport_str =  "iq3" ) THEN 
                                         res := CRU_CLOCK_SELECT_IQ3;
            ELSIF (phyport_str =  "iq4" ) THEN 
                                         res := CRU_CLOCK_SELECT_IQ4;
            ELSIF (phyport_str =  "pld_cru_clk" ) THEN 
                                         res := CRU_CLOCK_SELECT_PLD_CRU_CLK;
            ELSIF (phyport_str =  "refclk0" OR phyport_str =  "clkrefclk0") THEN 
                                         res := CRU_CLOCK_SELECT_REFCLK0;
            ELSIF (phyport_str =  "refclk1" OR phyport_str =  "clkrefclk1") THEN 
                                         res := CRU_CLOCK_SELECT_REFCLK1;
            ELSIF (phyport_str =  "cmu_div_clk" ) THEN 
                                         res := CRU_CLOCK_SELECT_CMU_DIV_CLK;             
            ELSE
                res := CRU_CLOCK_SELECT_NONE;
                WRITE(TXT,STRING'("Invalid Physical PORT of CRU_CLOCK_SELECT")); 
                WRITELINE(OUTPUT,TXT);         
            END IF;
            result := res;    
        END convert_phyport_str_to_phyport_enum;

        VARIABLE init_table                : STD_LOGIC := '1';  
        VARIABLE tmp_int                   : INTEGER := 0; 
        
        BEGIN
        IF (init_table = '1') THEN
            cru_clock_phyport_to_cram(CRU_CLOCK_SELECT_NONE)       <= "111U11";
            cru_clock_phyport_to_cram(CRU_CLOCK_SELECT_IQ0)        <= "000U11";
            cru_clock_phyport_to_cram(CRU_CLOCK_SELECT_IQ1)        <= "001U11";
            cru_clock_phyport_to_cram(CRU_CLOCK_SELECT_IQ2)        <= "010U11";
            cru_clock_phyport_to_cram(CRU_CLOCK_SELECT_IQ3)        <= "011U11";
            cru_clock_phyport_to_cram(CRU_CLOCK_SELECT_IQ4)        <= "100U11";
            cru_clock_phyport_to_cram(CRU_CLOCK_SELECT_PLD_CRU_CLK)<= "101U11";
            -- rrefclk_sel below is donot care so take default for preventing X values passing around
            cru_clock_phyport_to_cram(CRU_CLOCK_SELECT_REFCLK0)    <= "000U00"; 
            cru_clock_phyport_to_cram(CRU_CLOCK_SELECT_REFCLK1)    <= "000U01";
            cru_clock_phyport_to_cram(CRU_CLOCK_SELECT_CMU_DIV_CLK)<= "000U10";
            
            -- ch0
            convert_phyport_str_to_phyport_enum(rx0_cru_clock0_physical_mapping, tmp_int);
            rx0_cru_clock_index_to_phyport(0) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx0_cru_clock1_physical_mapping, tmp_int);
            rx0_cru_clock_index_to_phyport(1) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx0_cru_clock2_physical_mapping, tmp_int);
            rx0_cru_clock_index_to_phyport(2) <= tmp_int; 
            convert_phyport_str_to_phyport_enum(rx0_cru_clock3_physical_mapping, tmp_int);
            rx0_cru_clock_index_to_phyport(3) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx0_cru_clock4_physical_mapping, tmp_int);
            rx0_cru_clock_index_to_phyport(4) <= tmp_int; 
            convert_phyport_str_to_phyport_enum(rx0_cru_clock5_physical_mapping, tmp_int);
            rx0_cru_clock_index_to_phyport(5) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx0_cru_clock6_physical_mapping, tmp_int);
            rx0_cru_clock_index_to_phyport(6) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx0_cru_clock7_physical_mapping, tmp_int);
            rx0_cru_clock_index_to_phyport(7) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx0_cru_clock8_physical_mapping, tmp_int);
            rx0_cru_clock_index_to_phyport(8) <=  tmp_int;
            
            -- ch1
            convert_phyport_str_to_phyport_enum(rx1_cru_clock0_physical_mapping, tmp_int);
            rx1_cru_clock_index_to_phyport(0) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx1_cru_clock1_physical_mapping, tmp_int);
            rx1_cru_clock_index_to_phyport(1) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx1_cru_clock2_physical_mapping, tmp_int);
            rx1_cru_clock_index_to_phyport(2) <= tmp_int; 
            convert_phyport_str_to_phyport_enum(rx1_cru_clock3_physical_mapping, tmp_int);
            rx1_cru_clock_index_to_phyport(3) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx1_cru_clock4_physical_mapping, tmp_int);
            rx1_cru_clock_index_to_phyport(4) <= tmp_int; 
            convert_phyport_str_to_phyport_enum(rx1_cru_clock5_physical_mapping, tmp_int);
            rx1_cru_clock_index_to_phyport(5) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx1_cru_clock6_physical_mapping, tmp_int);
            rx1_cru_clock_index_to_phyport(6) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx1_cru_clock7_physical_mapping, tmp_int);
            rx1_cru_clock_index_to_phyport(7) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx1_cru_clock8_physical_mapping, tmp_int);
            rx1_cru_clock_index_to_phyport(8) <=  tmp_int;
            
            -- ch2
            convert_phyport_str_to_phyport_enum(rx2_cru_clock0_physical_mapping, tmp_int);
            rx2_cru_clock_index_to_phyport(0) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx2_cru_clock1_physical_mapping, tmp_int);
            rx2_cru_clock_index_to_phyport(1) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx2_cru_clock2_physical_mapping, tmp_int);
            rx2_cru_clock_index_to_phyport(2) <= tmp_int; 
            convert_phyport_str_to_phyport_enum(rx2_cru_clock3_physical_mapping, tmp_int);
            rx2_cru_clock_index_to_phyport(3) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx2_cru_clock4_physical_mapping, tmp_int);
            rx2_cru_clock_index_to_phyport(4) <= tmp_int; 
            convert_phyport_str_to_phyport_enum(rx2_cru_clock5_physical_mapping, tmp_int);
            rx2_cru_clock_index_to_phyport(5) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx2_cru_clock6_physical_mapping, tmp_int);
            rx2_cru_clock_index_to_phyport(6) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx2_cru_clock7_physical_mapping, tmp_int);
            rx2_cru_clock_index_to_phyport(7) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx2_cru_clock8_physical_mapping, tmp_int);
            rx2_cru_clock_index_to_phyport(8) <=  tmp_int;
            
            -- ch3
            convert_phyport_str_to_phyport_enum(rx3_cru_clock0_physical_mapping, tmp_int);
            rx3_cru_clock_index_to_phyport(0) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx3_cru_clock1_physical_mapping, tmp_int);
            rx3_cru_clock_index_to_phyport(1) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx3_cru_clock2_physical_mapping, tmp_int);
            rx3_cru_clock_index_to_phyport(2) <= tmp_int; 
            convert_phyport_str_to_phyport_enum(rx3_cru_clock3_physical_mapping, tmp_int);
            rx3_cru_clock_index_to_phyport(3) <= tmp_int;
            convert_phyport_str_to_phyport_enum(rx3_cru_clock4_physical_mapping, tmp_int);
            rx3_cru_clock_index_to_phyport(4) <= tmp_int; 
            convert_phyport_str_to_phyport_enum(rx3_cru_clock5_physical_mapping, tmp_int);
            rx3_cru_clock_index_to_phyport(5) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx3_cru_clock6_physical_mapping, tmp_int);
            rx3_cru_clock_index_to_phyport(6) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx3_cru_clock7_physical_mapping, tmp_int);
            rx3_cru_clock_index_to_phyport(7) <=  tmp_int;
            convert_phyport_str_to_phyport_enum(rx3_cru_clock8_physical_mapping, tmp_int);
            rx3_cru_clock_index_to_phyport(8) <=  tmp_int;
            
            init_table := '0';
        END IF;
    
        WAIT; 
    END PROCESS;  -- end of initializing tables

    -- logic channel
    tmp_rx0_cru_clock_select_vec <= rxdprioin_logic_ch0(cru_clock_select_DP_RX_IDX_3 DOWNTO cru_clock_select_DP_RX_IDX_0) WHEN
                               ((rxdprioin_logic_ch0(cru_clock_select_DP_RX_IDX_0) = '1' OR rxdprioin_logic_ch0(cru_clock_select_DP_RX_IDX_0) = '0') AND
                                (rxdprioin_logic_ch0(cru_clock_select_DP_RX_IDX_1) = '1' OR rxdprioin_logic_ch0(cru_clock_select_DP_RX_IDX_1) = '0') AND
                                (rxdprioin_logic_ch0(cru_clock_select_DP_RX_IDX_2) = '1' OR rxdprioin_logic_ch0(cru_clock_select_DP_RX_IDX_2) = '0') AND
                                (rxdprioin_logic_ch0(cru_clock_select_DP_RX_IDX_3) = '1' OR rxdprioin_logic_ch0(cru_clock_select_DP_RX_IDX_3) = '0')) ELSE 
                                "0000"; -- tmp variable to prevent conversion function overflow due huge rxdprioin_logic vector
    rx0_cru_clock_select <= dprio_reg_to_int(tmp_rx0_cru_clock_select_vec);
    
    -- physical
    rx0_cru_clock_phyport    <= rx0_cru_clock_index_to_phyport(rx0_cru_clock_select);
    rx0_cru_clock_cram_logic <= cru_clock_phyport_to_cram(rx0_cru_clock_phyport);
    rrefclk_sel_ch0          <= rx0_cru_clock_cram_phy(5 DOWNTO 3);
    rrx_piso_bypass_ch0      <= rx0_cru_clock_cram_phy(1 DOWNTO 0);
    -- logic to physical
    rx0_cru_clock_cram_phy <=  rx0_cru_clock_cram_logic WHEN (rx0_phy = 0) ELSE 
                               rx1_cru_clock_cram_logic WHEN (rx1_phy = 0) ELSE
                               rx2_cru_clock_cram_logic WHEN (rx2_phy = 0) ELSE 
                               rx3_cru_clock_cram_logic;                  
    -- ch1
    tmp_rx1_cru_clock_select_vec <= rxdprioin_logic_ch1(cru_clock_select_DP_RX_IDX_3 DOWNTO cru_clock_select_DP_RX_IDX_0) WHEN
                               ((rxdprioin_logic_ch1(cru_clock_select_DP_RX_IDX_0) = '1' OR rxdprioin_logic_ch1(cru_clock_select_DP_RX_IDX_0) = '0') AND
                                (rxdprioin_logic_ch1(cru_clock_select_DP_RX_IDX_1) = '1' OR rxdprioin_logic_ch1(cru_clock_select_DP_RX_IDX_1) = '0') AND
                                (rxdprioin_logic_ch1(cru_clock_select_DP_RX_IDX_2) = '1' OR rxdprioin_logic_ch1(cru_clock_select_DP_RX_IDX_2) = '0') AND
                                (rxdprioin_logic_ch1(cru_clock_select_DP_RX_IDX_3) = '1' OR rxdprioin_logic_ch1(cru_clock_select_DP_RX_IDX_3) = '0')) ELSE 
                                "0000"; -- tmp variable to prevent conversion function overflow due huge rxdprioin_logic vector
    rx1_cru_clock_select <= dprio_reg_to_int(tmp_rx1_cru_clock_select_vec);
    
    -- physical
    rx1_cru_clock_phyport    <= rx1_cru_clock_index_to_phyport(rx1_cru_clock_select);
    rx1_cru_clock_cram_logic <= cru_clock_phyport_to_cram(rx1_cru_clock_phyport);
    rrefclk_sel_ch1          <= rx1_cru_clock_cram_phy(5 DOWNTO 3);
    rrx_piso_bypass_ch1      <= rx1_cru_clock_cram_phy(1 DOWNTO 0);
    -- logic to physical
    rx1_cru_clock_cram_phy <=  rx0_cru_clock_cram_logic WHEN (rx0_phy = 1) ELSE 
                               rx1_cru_clock_cram_logic WHEN (rx1_phy = 1) ELSE
                               rx2_cru_clock_cram_logic WHEN (rx2_phy = 1) ELSE 
                               rx3_cru_clock_cram_logic;                  
    -- ch2    
    tmp_rx2_cru_clock_select_vec <= rxdprioin_logic_ch2(cru_clock_select_DP_RX_IDX_3 DOWNTO cru_clock_select_DP_RX_IDX_0) WHEN
                               ((rxdprioin_logic_ch2(cru_clock_select_DP_RX_IDX_0) = '1' OR rxdprioin_logic_ch2(cru_clock_select_DP_RX_IDX_0) = '0') AND
                                (rxdprioin_logic_ch2(cru_clock_select_DP_RX_IDX_1) = '1' OR rxdprioin_logic_ch2(cru_clock_select_DP_RX_IDX_1) = '0') AND
                                (rxdprioin_logic_ch2(cru_clock_select_DP_RX_IDX_2) = '1' OR rxdprioin_logic_ch2(cru_clock_select_DP_RX_IDX_2) = '0') AND
                                (rxdprioin_logic_ch2(cru_clock_select_DP_RX_IDX_3) = '1' OR rxdprioin_logic_ch2(cru_clock_select_DP_RX_IDX_3) = '0')) ELSE 
                                "0000"; -- tmp variable to prevent conversion function overflow due huge rxdprioin_logic vector
    rx2_cru_clock_select <= dprio_reg_to_int(tmp_rx2_cru_clock_select_vec);
    
    -- physical
    rx2_cru_clock_phyport    <= rx2_cru_clock_index_to_phyport(rx2_cru_clock_select);
    rx2_cru_clock_cram_logic <= cru_clock_phyport_to_cram(rx2_cru_clock_phyport);
    rrefclk_sel_ch2          <= rx2_cru_clock_cram_phy(5 DOWNTO 3);
    rrx_piso_bypass_ch2      <= rx2_cru_clock_cram_phy(1 DOWNTO 0);
    -- logic to physical
    rx2_cru_clock_cram_phy <=  rx0_cru_clock_cram_logic WHEN (rx0_phy = 2) ELSE 
                               rx1_cru_clock_cram_logic WHEN (rx1_phy = 2) ELSE
                               rx2_cru_clock_cram_logic WHEN (rx2_phy = 2) ELSE 
                               rx3_cru_clock_cram_logic;                  
    -- ch3
    tmp_rx3_cru_clock_select_vec <= rxdprioin_logic_ch3(cru_clock_select_DP_RX_IDX_3 DOWNTO cru_clock_select_DP_RX_IDX_0) WHEN
                               ((rxdprioin_logic_ch3(cru_clock_select_DP_RX_IDX_0) = '1' OR rxdprioin_logic_ch3(cru_clock_select_DP_RX_IDX_0) = '0') AND
                                (rxdprioin_logic_ch3(cru_clock_select_DP_RX_IDX_1) = '1' OR rxdprioin_logic_ch3(cru_clock_select_DP_RX_IDX_1) = '0') AND
                                (rxdprioin_logic_ch3(cru_clock_select_DP_RX_IDX_2) = '1' OR rxdprioin_logic_ch3(cru_clock_select_DP_RX_IDX_2) = '0') AND
                                (rxdprioin_logic_ch3(cru_clock_select_DP_RX_IDX_3) = '1' OR rxdprioin_logic_ch3(cru_clock_select_DP_RX_IDX_3) = '0')) ELSE 
                                "0000"; -- tmp variable to prevent conversion function overflow due huge rxdprioin_logic vector
    rx3_cru_clock_select <= dprio_reg_to_int(tmp_rx3_cru_clock_select_vec);
    
    -- physical
    rx3_cru_clock_phyport    <= rx3_cru_clock_index_to_phyport(rx3_cru_clock_select);
    rx3_cru_clock_cram_logic <= cru_clock_phyport_to_cram(rx3_cru_clock_phyport);
    rrefclk_sel_ch3          <= rx3_cru_clock_cram_phy(5 DOWNTO 3);
    rrx_piso_bypass_ch3      <= rx3_cru_clock_cram_phy(1 DOWNTO 0);
    -- logic to physical
    rx3_cru_clock_cram_phy <=  rx0_cru_clock_cram_logic WHEN (rx0_phy = 3) ELSE 
                               rx1_cru_clock_cram_logic WHEN (rx1_phy = 3) ELSE
                               rx2_cru_clock_cram_logic WHEN (rx2_phy = 3) ELSE 
                               rx3_cru_clock_cram_logic;                  
    
    -- CRU_CLOCK_SElECT - output (parameter) ------------------------------
    
    -- physical ch0
    rx0_cru_clock_phyport_out <= convert_cru_clock_cram_to_phyport(rrefclk_sel_ch0_int,rrx_piso_bypass_ch0_int);
    -- map is on logic channel
    rx0_cru_clock_phyport_out_logic <= rx0_cru_clock_phyport_out WHEN (rx0_phy = 0) ELSE
                                       rx1_cru_clock_phyport_out WHEN (rx0_phy = 1) ELSE
                                       rx2_cru_clock_phyport_out WHEN (rx0_phy = 2) ELSE
                                       rx3_cru_clock_phyport_out;
    
    rx0_cru_clock_select_out_logic  <= "0000" WHEN (rx0_cru_clock_index_to_phyport(0) = rx0_cru_clock_phyport_out_logic)   ELSE 
                                       "0001" WHEN (rx0_cru_clock_index_to_phyport(1) = rx0_cru_clock_phyport_out_logic)   ELSE 
                                       "0010" WHEN (rx0_cru_clock_index_to_phyport(2) = rx0_cru_clock_phyport_out_logic)   ELSE 
                                       "0011" WHEN (rx0_cru_clock_index_to_phyport(3) = rx0_cru_clock_phyport_out_logic)   ELSE 
                                       "0100" WHEN (rx0_cru_clock_index_to_phyport(4) = rx0_cru_clock_phyport_out_logic)   ELSE 
                                       "0101" WHEN (rx0_cru_clock_index_to_phyport(5) = rx0_cru_clock_phyport_out_logic)   ELSE 
                                       "0110" WHEN (rx0_cru_clock_index_to_phyport(6) = rx0_cru_clock_phyport_out_logic)   ELSE 
                                       "0111" WHEN (rx0_cru_clock_index_to_phyport(7) = rx0_cru_clock_phyport_out_logic)   ELSE 
                                       "1000" WHEN (rx0_cru_clock_index_to_phyport(8) = rx0_cru_clock_phyport_out_logic)   ELSE 
                                       "1111";  -- invalid cram values
                                       
    -- back to physical
    rx0_cru_clock_select_out <= rx0_cru_clock_select_out_logic WHEN (rx0_phy = 0) ELSE
                                rx1_cru_clock_select_out_logic WHEN (rx1_phy = 0) ELSE
                                rx2_cru_clock_select_out_logic WHEN (rx2_phy = 0) ELSE 
                                rx3_cru_clock_select_out_logic;
                                                                          
    rxdprioout_phy_ch0(cru_clock_select_DP_RX_IDX_3 DOWNTO  cru_clock_select_DP_RX_IDX_0) <= rx0_cru_clock_select_out;                            

    -- physical ch1
    rx1_cru_clock_phyport_out <= convert_cru_clock_cram_to_phyport(rrefclk_sel_ch1_int,rrx_piso_bypass_ch1_int);
    -- map is on logic channel
    rx1_cru_clock_phyport_out_logic <= rx0_cru_clock_phyport_out WHEN (rx1_phy = 0) ELSE
                                       rx1_cru_clock_phyport_out WHEN (rx1_phy = 1) ELSE
                                       rx2_cru_clock_phyport_out WHEN (rx1_phy = 2) ELSE
                                       rx3_cru_clock_phyport_out;
    
    rx1_cru_clock_select_out_logic  <= "0000" WHEN (rx1_cru_clock_index_to_phyport(0) = rx1_cru_clock_phyport_out_logic)   ELSE 
                                       "0001" WHEN (rx1_cru_clock_index_to_phyport(1) = rx1_cru_clock_phyport_out_logic)   ELSE 
                                       "0010" WHEN (rx1_cru_clock_index_to_phyport(2) = rx1_cru_clock_phyport_out_logic)   ELSE 
                                       "0011" WHEN (rx1_cru_clock_index_to_phyport(3) = rx1_cru_clock_phyport_out_logic)   ELSE 
                                       "0100" WHEN (rx1_cru_clock_index_to_phyport(4) = rx1_cru_clock_phyport_out_logic)   ELSE 
                                       "0101" WHEN (rx1_cru_clock_index_to_phyport(5) = rx1_cru_clock_phyport_out_logic)   ELSE 
                                       "0110" WHEN (rx1_cru_clock_index_to_phyport(6) = rx1_cru_clock_phyport_out_logic)   ELSE 
                                       "0111" WHEN (rx1_cru_clock_index_to_phyport(7) = rx1_cru_clock_phyport_out_logic)   ELSE 
                                       "1000" WHEN (rx1_cru_clock_index_to_phyport(8) = rx1_cru_clock_phyport_out_logic)   ELSE 
                                       "1111";  -- invalid cram values
                                       
    -- back to physical
    rx1_cru_clock_select_out <= rx0_cru_clock_select_out_logic WHEN (rx0_phy = 1) ELSE
                                rx1_cru_clock_select_out_logic WHEN (rx1_phy = 1) ELSE
                                rx2_cru_clock_select_out_logic WHEN (rx2_phy = 1) ELSE 
                                rx3_cru_clock_select_out_logic;
                                                                          
    rxdprioout_phy_ch1(cru_clock_select_DP_RX_IDX_3 DOWNTO  cru_clock_select_DP_RX_IDX_0) <= rx1_cru_clock_select_out;                            

    -- physical ch2
    rx2_cru_clock_phyport_out <= convert_cru_clock_cram_to_phyport(rrefclk_sel_ch2_int,rrx_piso_bypass_ch2_int);
    -- map is on logic channel
    rx2_cru_clock_phyport_out_logic <= rx0_cru_clock_phyport_out WHEN (rx2_phy = 0) ELSE
                                       rx1_cru_clock_phyport_out WHEN (rx2_phy = 1) ELSE
                                       rx2_cru_clock_phyport_out WHEN (rx2_phy = 2) ELSE
                                       rx3_cru_clock_phyport_out;
    
    rx2_cru_clock_select_out_logic  <= "0000" WHEN (rx2_cru_clock_index_to_phyport(0) = rx2_cru_clock_phyport_out_logic)   ELSE 
                                       "0001" WHEN (rx2_cru_clock_index_to_phyport(1) = rx2_cru_clock_phyport_out_logic)   ELSE 
                                       "0010" WHEN (rx2_cru_clock_index_to_phyport(2) = rx2_cru_clock_phyport_out_logic)   ELSE 
                                       "0011" WHEN (rx2_cru_clock_index_to_phyport(3) = rx2_cru_clock_phyport_out_logic)   ELSE 
                                       "0100" WHEN (rx2_cru_clock_index_to_phyport(4) = rx2_cru_clock_phyport_out_logic)   ELSE 
                                       "0101" WHEN (rx2_cru_clock_index_to_phyport(5) = rx2_cru_clock_phyport_out_logic)   ELSE 
                                       "0110" WHEN (rx2_cru_clock_index_to_phyport(6) = rx2_cru_clock_phyport_out_logic)   ELSE 
                                       "0111" WHEN (rx2_cru_clock_index_to_phyport(7) = rx2_cru_clock_phyport_out_logic)   ELSE 
                                       "1000" WHEN (rx2_cru_clock_index_to_phyport(8) = rx2_cru_clock_phyport_out_logic)   ELSE 
                                       "1111";  -- invalid cram values
                                       
    -- back to physical
    rx2_cru_clock_select_out <= rx0_cru_clock_select_out_logic WHEN (rx0_phy = 2) ELSE
                                rx1_cru_clock_select_out_logic WHEN (rx1_phy = 2) ELSE
                                rx2_cru_clock_select_out_logic WHEN (rx2_phy = 2) ELSE 
                                rx3_cru_clock_select_out_logic;
                                                                          
    rxdprioout_phy_ch2(cru_clock_select_DP_RX_IDX_3 DOWNTO  cru_clock_select_DP_RX_IDX_0) <= rx2_cru_clock_select_out;                            

    -- physical ch3
    rx3_cru_clock_phyport_out <= convert_cru_clock_cram_to_phyport(rrefclk_sel_ch3_int,rrx_piso_bypass_ch3_int);
    -- map is on logic channel
    rx3_cru_clock_phyport_out_logic <= rx0_cru_clock_phyport_out WHEN (rx3_phy = 0) ELSE
                                       rx1_cru_clock_phyport_out WHEN (rx3_phy = 1) ELSE
                                       rx2_cru_clock_phyport_out WHEN (rx3_phy = 2) ELSE
                                       rx3_cru_clock_phyport_out;
    
    rx3_cru_clock_select_out_logic  <= "0000" WHEN (rx3_cru_clock_index_to_phyport(0) = rx3_cru_clock_phyport_out_logic)   ELSE 
                                       "0001" WHEN (rx3_cru_clock_index_to_phyport(1) = rx3_cru_clock_phyport_out_logic)   ELSE 
                                       "0010" WHEN (rx3_cru_clock_index_to_phyport(2) = rx3_cru_clock_phyport_out_logic)   ELSE 
                                       "0011" WHEN (rx3_cru_clock_index_to_phyport(3) = rx3_cru_clock_phyport_out_logic)   ELSE 
                                       "0100" WHEN (rx3_cru_clock_index_to_phyport(4) = rx3_cru_clock_phyport_out_logic)   ELSE 
                                       "0101" WHEN (rx3_cru_clock_index_to_phyport(5) = rx3_cru_clock_phyport_out_logic)   ELSE 
                                       "0110" WHEN (rx3_cru_clock_index_to_phyport(6) = rx3_cru_clock_phyport_out_logic)   ELSE 
                                       "0111" WHEN (rx3_cru_clock_index_to_phyport(7) = rx3_cru_clock_phyport_out_logic)   ELSE 
                                       "1000" WHEN (rx3_cru_clock_index_to_phyport(8) = rx3_cru_clock_phyport_out_logic)   ELSE 
                                       "1111";  -- invalid cram values
                                       
    -- back to physical
    rx3_cru_clock_select_out <= rx0_cru_clock_select_out_logic WHEN (rx0_phy = 3) ELSE
                                rx1_cru_clock_select_out_logic WHEN (rx1_phy = 3) ELSE
                                rx2_cru_clock_select_out_logic WHEN (rx2_phy = 3) ELSE 
                                rx3_cru_clock_select_out_logic;
                                                                          
    rxdprioout_phy_ch3(cru_clock_select_DP_RX_IDX_3 DOWNTO  cru_clock_select_DP_RX_IDX_0) <= rx3_cru_clock_select_out;                            

-- Tx clock divider refclk selection ---------------------------------------------------------------------------------------- 
-- needs logic to physical mapping as logic pll0 can place into physical pll1
-- selection_pll0 CRAM means physical PLL0

-- Tx clock divider refclk selection input ---------------------------
rtx_cmu_sel_logic(0)  <= '0' WHEN (((txdprioin_logic_ch0(rtx_cmu_sel_DP_TX_IDX) = '0') AND (tx0_pll_fast_clk0_physical_mapping = "pll0")) OR
                                   ((txdprioin_logic_ch0(rtx_cmu_sel_DP_TX_IDX) = '1') AND (tx0_pll_fast_clk1_physical_mapping = "pll0"))) 
                             ELSE '1';  -- tx uses logic pll0 and pll0 maps to physical pll0 or tx uses pll1 and pll1 maps to phy pll0
-- phy channel tx                                
rtx_cmu_sel(0)        <= rtx_cmu_sel_logic(0) WHEN (tx0_phy = 0) ELSE 
                         rtx_cmu_sel_logic(1) WHEN (tx1_phy = 0) ELSE
                         rtx_cmu_sel_logic(2) WHEN (tx2_phy = 0) ELSE 
                         rtx_cmu_sel_logic(3);

rtx_cmu_sel_logic(1)  <= '0' WHEN (((txdprioin_logic_ch1(rtx_cmu_sel_DP_TX_IDX) = '0') AND (tx1_pll_fast_clk0_physical_mapping = "pll0")) OR
                                   ((txdprioin_logic_ch1(rtx_cmu_sel_DP_TX_IDX) = '1') AND (tx1_pll_fast_clk1_physical_mapping = "pll0"))) 
                             ELSE '1';  -- tx uses logic pll0 and pll0 maps to physical pll0 or tx uses pll1 and pll1 maps to phy pll0
-- phy channel tx                                
rtx_cmu_sel(1)        <= rtx_cmu_sel_logic(0) WHEN (tx0_phy = 1) ELSE 
                         rtx_cmu_sel_logic(1) WHEN (tx1_phy = 1) ELSE
                         rtx_cmu_sel_logic(2) WHEN (tx2_phy = 1) ELSE 
                         rtx_cmu_sel_logic(3);

rtx_cmu_sel_logic(2)  <= '0' WHEN (((txdprioin_logic_ch2(rtx_cmu_sel_DP_TX_IDX) = '0') AND (tx2_pll_fast_clk0_physical_mapping = "pll0")) OR
                                   ((txdprioin_logic_ch2(rtx_cmu_sel_DP_TX_IDX) = '1') AND (tx2_pll_fast_clk1_physical_mapping = "pll0"))) 
                             ELSE '1';  -- tx uses logic pll0 and pll0 maps to physical pll0 or tx uses pll1 and pll1 maps to phy pll0
-- phy channel tx                                
rtx_cmu_sel(2)        <= rtx_cmu_sel_logic(0) WHEN (tx0_phy = 2) ELSE 
                         rtx_cmu_sel_logic(1) WHEN (tx1_phy = 2) ELSE
                         rtx_cmu_sel_logic(2) WHEN (tx2_phy = 2) ELSE 
                         rtx_cmu_sel_logic(3);

rtx_cmu_sel_logic(3)  <= '0' WHEN (((txdprioin_logic_ch3(rtx_cmu_sel_DP_TX_IDX) = '0') AND (tx3_pll_fast_clk0_physical_mapping = "pll0")) OR
                                   ((txdprioin_logic_ch3(rtx_cmu_sel_DP_TX_IDX) = '1') AND (tx3_pll_fast_clk1_physical_mapping = "pll0"))) 
                             ELSE '1';  -- tx uses logic pll0 and pll0 maps to physical pll0 or tx uses pll1 and pll1 maps to phy pll0
-- phy channel tx                                
rtx_cmu_sel(3)        <= rtx_cmu_sel_logic(0) WHEN (tx0_phy = 3) ELSE 
                         rtx_cmu_sel_logic(1) WHEN (tx1_phy = 3) ELSE
                         rtx_cmu_sel_logic(2) WHEN (tx2_phy = 3) ELSE 
                         rtx_cmu_sel_logic(3);

                                                        
-- Tx clock divider refclk selection output --------------------------
-- resolve to logic refclk (pll0/1) selection

-- work on logic tx channel as the tx_pll_fast_clk_physical_mapping is defined on logic tx channel
-- The cram from dprio is on logic tx channel but refers to physical PLL
rtx_cmu_sel_int_logic(0) <= rtx_cmu_sel_int(0) WHEN (tx0_phy = 0) ELSE 
                            rtx_cmu_sel_int(1) WHEN (tx0_phy = 1) ELSE
                            rtx_cmu_sel_int(2) WHEN (tx0_phy = 2) ELSE
                            rtx_cmu_sel_int(3);
                            
-- physcial PLL to logic PLL map still on logic tx channel                                  
tx_refclk_select_out(0) <= '0' WHEN (((rtx_cmu_sel_int_logic(0) = '0') AND (tx0_pll_fast_clk0_physical_mapping = "pll0")) OR
                                     ((rtx_cmu_sel_int_logic(0) = '1') AND (tx0_pll_fast_clk0_physical_mapping = "pll1"))) 
                               ELSE '1';  -- logic tx uses phy pll0 and pll0 maps to physical pll0 or tx uses phy pll1 and pll0 maps to phy pll1
 
-- has to send out at phy_ch as last phy_ch to logic map for everyone
tx_refclk_select_out_phy(0) <= tx_refclk_select_out(0) WHEN (tx0_phy = 0) ELSE
                               tx_refclk_select_out(1) WHEN (tx1_phy = 0) ELSE
                               tx_refclk_select_out(2) WHEN (tx2_phy = 0) ELSE
                               tx_refclk_select_out(3);
txdprioout_phy_ch0(rtx_cmu_sel_DP_TX_IDX)   <= tx_refclk_select_out_phy(0);
   
-- ch1
rtx_cmu_sel_int_logic(1) <= rtx_cmu_sel_int(0) WHEN (tx1_phy = 0) ELSE 
                            rtx_cmu_sel_int(1) WHEN (tx1_phy = 1) ELSE
                            rtx_cmu_sel_int(2) WHEN (tx1_phy = 2) ELSE
                            rtx_cmu_sel_int(3);
                            
-- physcial PLL to logic PLL map still on logic tx channel                                  
tx_refclk_select_out(1) <= '0' WHEN (((rtx_cmu_sel_int_logic(1) = '0') AND (tx1_pll_fast_clk0_physical_mapping = "pll0")) OR
                                     ((rtx_cmu_sel_int_logic(1) = '1') AND (tx1_pll_fast_clk0_physical_mapping = "pll1"))) 
                               ELSE '1';  -- logic tx uses phy pll0 and pll0 maps to physical pll0 or tx uses phy pll1 and pll0 maps to phy pll1
 
-- has to send out at phy_ch as last phy_ch to logic map for everyone
tx_refclk_select_out_phy(1) <= tx_refclk_select_out(0) WHEN (tx0_phy = 1) ELSE
                               tx_refclk_select_out(1) WHEN (tx1_phy = 1) ELSE
                               tx_refclk_select_out(2) WHEN (tx2_phy = 1) ELSE
                               tx_refclk_select_out(3);
txdprioout_phy_ch1(rtx_cmu_sel_DP_TX_IDX)   <= tx_refclk_select_out_phy(1);   

-- ch2
rtx_cmu_sel_int_logic(2) <= rtx_cmu_sel_int(0) WHEN (tx2_phy = 0) ELSE 
                            rtx_cmu_sel_int(1) WHEN (tx2_phy = 1) ELSE
                            rtx_cmu_sel_int(2) WHEN (tx2_phy = 2) ELSE
                            rtx_cmu_sel_int(3);
                           
-- physcial PLL to logic PLL map still on logic tx channel                                  
tx_refclk_select_out(2) <= '0' WHEN (((rtx_cmu_sel_int_logic(2) = '0') AND (tx2_pll_fast_clk0_physical_mapping = "pll0")) OR
                                     ((rtx_cmu_sel_int_logic(2) = '1') AND (tx2_pll_fast_clk0_physical_mapping = "pll1"))) 
                               ELSE '1';  -- logic tx uses phy pll0 and pll0 maps to physical pll0 or tx uses phy pll1 and pll0 maps to phy pll1
 
-- has to send out at phy_ch as last phy_ch to logic map for everyone
tx_refclk_select_out_phy(2) <= tx_refclk_select_out(0) WHEN (tx0_phy = 2) ELSE
                               tx_refclk_select_out(1) WHEN (tx1_phy = 2) ELSE
                               tx_refclk_select_out(2) WHEN (tx2_phy = 2) ELSE
                               tx_refclk_select_out(3);
txdprioout_phy_ch2(rtx_cmu_sel_DP_TX_IDX)   <= tx_refclk_select_out_phy(2);   

-- ch3
rtx_cmu_sel_int_logic(3) <= rtx_cmu_sel_int(0) WHEN (tx3_phy = 0) ELSE 
                            rtx_cmu_sel_int(1) WHEN (tx3_phy = 1) ELSE
                            rtx_cmu_sel_int(2) WHEN (tx3_phy = 2) ELSE
                            rtx_cmu_sel_int(3);
                           
-- physcial PLL to logic PLL map still on logic tx channel                                  
tx_refclk_select_out(3) <= '0' WHEN (((rtx_cmu_sel_int_logic(3) = '0') AND (tx3_pll_fast_clk0_physical_mapping = "pll0")) OR
                                     ((rtx_cmu_sel_int_logic(3) = '1') AND (tx3_pll_fast_clk0_physical_mapping = "pll1"))) 
                               ELSE '1';  -- logic tx uses phy pll0 and pll0 maps to physical pll0 or tx uses phy pll1 and pll0 maps to phy pll1
 
-- has to send out at phy_ch as last phy_ch to logic map for everyone
tx_refclk_select_out_phy(3) <= tx_refclk_select_out(0) WHEN (tx0_phy = 3) ELSE
                               tx_refclk_select_out(1) WHEN (tx1_phy = 3) ELSE
                               tx_refclk_select_out(2) WHEN (tx2_phy = 3) ELSE
                               tx_refclk_select_out(3);
txdprioout_phy_ch3(rtx_cmu_sel_DP_TX_IDX)   <= tx_refclk_select_out_phy(3);   

                              
-- TX PMA CRAM - input (parameter) ----------------------------------------------------

-- pma_ctrl1: 4.8060-4.8063 (tx)
rtx_vod_sel_ch0  <= txdprioin_phy_ch0(rtx_vod_sel_DP_TX_IDX_2 DOWNTO rtx_vod_sel_DP_TX_IDX_0);  -- 3-bits
rtx_slewrate(0)  <= txdprioin_phy_ch0(rtx_slewrate_DP_TX_IDX);                              -- 1-bit
rpmphs_2tap_ch0  <= txdprioin_phy_ch0(rpmphs_2tap_DP_TX_IDX_2 DOWNTO rpmphs_2tap_DP_TX_IDX_0);  -- 3
rpmphs_1tap_ch0  <= txdprioin_phy_ch0(rpmphs_1tap_DP_TX_IDX_3 DOWNTO rpmphs_1tap_DP_TX_IDX_0);  -- 4 
rtx_vtt_ch0      <= txdprioin_phy_ch0(rtx_vtt_DP_TX_IDX_1 DOWNTO rtx_vtt_DP_TX_IDX_0);          -- 2 - to add in wys
rpmphs_ptap_ch0  <= txdprioin_phy_ch0(rpmphs_ptap_DP_TX_IDX_2 DOWNTO rpmphs_ptap_DP_TX_IDX_0);  -- 3

rtx_vod_sel_ch1  <= txdprioin_phy_ch1(rtx_vod_sel_DP_TX_IDX_2 DOWNTO rtx_vod_sel_DP_TX_IDX_0);  -- 3-bits
rtx_slewrate(1)  <= txdprioin_phy_ch1(rtx_slewrate_DP_TX_IDX);                              -- 1-bit
rpmphs_2tap_ch1  <= txdprioin_phy_ch1(rpmphs_2tap_DP_TX_IDX_2 DOWNTO rpmphs_2tap_DP_TX_IDX_0);  -- 3
rpmphs_1tap_ch1  <= txdprioin_phy_ch1(rpmphs_1tap_DP_TX_IDX_3 DOWNTO rpmphs_1tap_DP_TX_IDX_0);  -- 4 
rtx_vtt_ch1      <= txdprioin_phy_ch1(rtx_vtt_DP_TX_IDX_1 DOWNTO rtx_vtt_DP_TX_IDX_0);          -- 2 - to add in wys
rpmphs_ptap_ch1  <= txdprioin_phy_ch1(rpmphs_ptap_DP_TX_IDX_2 DOWNTO rpmphs_ptap_DP_TX_IDX_0);  -- 3

rtx_vod_sel_ch2  <= txdprioin_phy_ch2(rtx_vod_sel_DP_TX_IDX_2 DOWNTO rtx_vod_sel_DP_TX_IDX_0);  -- 3-bits
rtx_slewrate(2)  <= txdprioin_phy_ch2(rtx_slewrate_DP_TX_IDX);                              -- 1-bit
rpmphs_2tap_ch2  <= txdprioin_phy_ch2(rpmphs_2tap_DP_TX_IDX_2 DOWNTO rpmphs_2tap_DP_TX_IDX_0);  -- 3
rpmphs_1tap_ch2  <= txdprioin_phy_ch2(rpmphs_1tap_DP_TX_IDX_3 DOWNTO rpmphs_1tap_DP_TX_IDX_0);  -- 4 
rtx_vtt_ch2      <= txdprioin_phy_ch2(rtx_vtt_DP_TX_IDX_1 DOWNTO rtx_vtt_DP_TX_IDX_0);          -- 2 - to add in wys
rpmphs_ptap_ch2  <= txdprioin_phy_ch2(rpmphs_ptap_DP_TX_IDX_2 DOWNTO rpmphs_ptap_DP_TX_IDX_0);  -- 3

rtx_vod_sel_ch3  <= txdprioin_phy_ch3(rtx_vod_sel_DP_TX_IDX_2 DOWNTO rtx_vod_sel_DP_TX_IDX_0);  -- 3-bits
rtx_slewrate(3)  <= txdprioin_phy_ch3(rtx_slewrate_DP_TX_IDX);                              -- 1-bit
rpmphs_2tap_ch3  <= txdprioin_phy_ch3(rpmphs_2tap_DP_TX_IDX_2 DOWNTO rpmphs_2tap_DP_TX_IDX_0);  -- 3
rpmphs_1tap_ch3  <= txdprioin_phy_ch3(rpmphs_1tap_DP_TX_IDX_3 DOWNTO rpmphs_1tap_DP_TX_IDX_0);  -- 4 
rtx_vtt_ch3      <= txdprioin_phy_ch3(rtx_vtt_DP_TX_IDX_1 DOWNTO rtx_vtt_DP_TX_IDX_0);          -- 2 - to add in wys
rpmphs_ptap_ch3  <= txdprioin_phy_ch3(rpmphs_ptap_DP_TX_IDX_2 DOWNTO rpmphs_ptap_DP_TX_IDX_0);  -- 3


-- pma_ctrl8 DOWNTO  4.807c-807h - TX portion
-- pma_ctrl8_ch0_ext <= {rs_lpbk(0), r_rlpbk(0), rs_rdlpbk(0), rrx_revlb_sw(0),
--                             rurx_pdb(0), rtx_cgb_pdb(0), rtx_ob_pdb(0), rrx_cru_pdb(0),
--                             rrx_cru_rst(0), rrx_ib_pdb(0), rrxurstpma(0), radce_adapt(0),
--                             radce_pdb(0), radce_rst(0), rsig_inv_2tap(0), rsig_inv_pre(0)};
r_rlpbk(0)       <= txdprioin_phy_ch0(r_rlpbk_DP_TX_IDX);             -- 14 - tx
rs_rdlpbk(0)     <= txdprioin_phy_ch0(rs_rdlpbk_DP_TX_IDX);           -- 13 - tx
rsig_inv_2tap(0) <= txdprioin_phy_ch0(rsig_inv_2tap_DP_TX_IDX);       -- 1 
rsig_inv_pre(0)  <= txdprioin_phy_ch0(rsig_inv_pre_DP_TX_IDX);        -- 1

r_rlpbk(1)       <= txdprioin_phy_ch1(r_rlpbk_DP_TX_IDX);             -- 14 - tx
rs_rdlpbk(1)     <= txdprioin_phy_ch1(rs_rdlpbk_DP_TX_IDX);           -- 13 - tx
rsig_inv_2tap(1) <= txdprioin_phy_ch1(rsig_inv_2tap_DP_TX_IDX);       -- 1 
rsig_inv_pre(1)  <= txdprioin_phy_ch1(rsig_inv_pre_DP_TX_IDX);        -- 1

r_rlpbk(2)       <= txdprioin_phy_ch2(r_rlpbk_DP_TX_IDX);             -- 14 - tx
rs_rdlpbk(2)     <= txdprioin_phy_ch2(rs_rdlpbk_DP_TX_IDX);           -- 13 - tx
rsig_inv_2tap(2) <= txdprioin_phy_ch2(rsig_inv_2tap_DP_TX_IDX);       -- 1 
rsig_inv_pre(2)  <= txdprioin_phy_ch2(rsig_inv_pre_DP_TX_IDX);        -- 1

r_rlpbk(3)       <= txdprioin_phy_ch3(r_rlpbk_DP_TX_IDX);             -- 14 - tx
rs_rdlpbk(3)     <= txdprioin_phy_ch3(rs_rdlpbk_DP_TX_IDX);           -- 13 - tx
rsig_inv_2tap(3) <= txdprioin_phy_ch3(rsig_inv_2tap_DP_TX_IDX);       -- 1 
rsig_inv_pre(3)  <= txdprioin_phy_ch3(rsig_inv_pre_DP_TX_IDX);        -- 1


-- The address covers both rx(pma and dpma widths defined in RX) and tx
-- pma_ctrl4_ch0_ext <= {rpmadwidth_tx(0), rpma_doublewidth_tx(0), rtx_cmu_sel(0),
-- 806Ch                rtx_m_sel_ch0, rtxvcobypass(0), rtx_cgb_1x_en(0), rtx_cgb_4x_en(0),
--                      rtx_4x_sw(0), rpmadwidth_rx(0), rpma_doublewidth_rx(0),
--                      rrxvcobypass(0),rrect_adj_ch0, rrx_piso_bypass_ch0};
rpmadwidth_tx(0)       <= txdprioin_phy_ch0(rpmadwidth_tx_DP_TX_IDX);                       -- 1 
rpma_doublewidth_tx(0) <= txdprioin_phy_ch0(rpma_doublewidth_tx_DP_TX_IDX);                 -- 1 
--rtx_cmu_sel(0)         <= txdprioin_phy_ch0(rtx_cmu_sel_DP_TX_IDX);                         -- 1 
rtx_m_sel_ch0          <= txdprioin_phy_ch0(rtx_m_sel_DP_TX_IDX_1  DOWNTO  rtx_m_sel_DP_TX_IDX_0); -- 2 
rtx_cgb_1x_en(0)       <= txdprioin_phy_ch0(rtx_cgb_1x_en_DP_TX_IDX);                       -- 1 
rtx_cgb_4x_en(0)       <= txdprioin_phy_ch0(rtx_cgb_4x_en_DP_TX_IDX);                       -- 1 
rtx_4x_sw(0)           <= txdprioin_phy_ch0(rtx_4x_sw_DP_TX_IDX);                           -- 1 

rpmadwidth_tx(1)       <= txdprioin_phy_ch1(rpmadwidth_tx_DP_TX_IDX);                       -- 1 
rpma_doublewidth_tx(1) <= txdprioin_phy_ch1(rpma_doublewidth_tx_DP_TX_IDX);                 -- 1 
--rtx_cmu_sel(1)         <= txdprioin_phy_ch1(rtx_cmu_sel_DP_TX_IDX);                         -- 1 
rtx_m_sel_ch1          <= txdprioin_phy_ch1(rtx_m_sel_DP_TX_IDX_1  DOWNTO  rtx_m_sel_DP_TX_IDX_0); -- 2 
rtx_cgb_1x_en(1)       <= txdprioin_phy_ch1(rtx_cgb_1x_en_DP_TX_IDX);                       -- 1 
rtx_cgb_4x_en(1)       <= txdprioin_phy_ch1(rtx_cgb_4x_en_DP_TX_IDX);                       -- 1 
rtx_4x_sw(1)           <= txdprioin_phy_ch1(rtx_4x_sw_DP_TX_IDX);                           -- 1 

rpmadwidth_tx(2)       <= txdprioin_phy_ch2(rpmadwidth_tx_DP_TX_IDX);                       -- 1 
rpma_doublewidth_tx(2) <= txdprioin_phy_ch2(rpma_doublewidth_tx_DP_TX_IDX);                 -- 1 
--rtx_cmu_sel(2)         <= txdprioin_phy_ch2(rtx_cmu_sel_DP_TX_IDX);                         -- 1 
rtx_m_sel_ch2          <= txdprioin_phy_ch2(rtx_m_sel_DP_TX_IDX_1  DOWNTO  rtx_m_sel_DP_TX_IDX_0); -- 2 
rtx_cgb_1x_en(2)       <= txdprioin_phy_ch2(rtx_cgb_1x_en_DP_TX_IDX);                       -- 1 
rtx_cgb_4x_en(2)       <= txdprioin_phy_ch2(rtx_cgb_4x_en_DP_TX_IDX);                       -- 1 
rtx_4x_sw(2)           <= txdprioin_phy_ch2(rtx_4x_sw_DP_TX_IDX);                           -- 1 

rpmadwidth_tx(3)       <= txdprioin_phy_ch3(rpmadwidth_tx_DP_TX_IDX);                       -- 1 
rpma_doublewidth_tx(3) <= txdprioin_phy_ch3(rpma_doublewidth_tx_DP_TX_IDX);                 -- 1 
--rtx_cmu_sel(3)         <= txdprioin_phy_ch3(rtx_cmu_sel_DP_TX_IDX);                         -- 1 
rtx_m_sel_ch3          <= txdprioin_phy_ch3(rtx_m_sel_DP_TX_IDX_1  DOWNTO  rtx_m_sel_DP_TX_IDX_0); -- 2 
rtx_cgb_1x_en(3)       <= txdprioin_phy_ch3(rtx_cgb_1x_en_DP_TX_IDX);                       -- 1 
rtx_cgb_4x_en(3)       <= txdprioin_phy_ch3(rtx_cgb_4x_en_DP_TX_IDX);                       -- 1 
rtx_4x_sw(3)           <= txdprioin_phy_ch3(rtx_4x_sw_DP_TX_IDX);                           -- 1 

-- txpma_ctrl_input_to_add  


-- TX PMA - output -----------------------------------------------------------------------------

-- pma_ctrl1 DOWNTO  4.8060-4.8063 (tx)
txdprioout_phy_ch0(rtx_vod_sel_DP_TX_IDX_2  DOWNTO  rtx_vod_sel_DP_TX_IDX_0) <= rtx_vod_sel_ch0_int;    -- 3-bits - qpmaused
txdprioout_phy_ch0(rtx_slewrate_DP_TX_IDX)                             <= rtx_slewrate_int(0);   -- 1-bit
txdprioout_phy_ch0(rpmphs_2tap_DP_TX_IDX_2  DOWNTO  rpmphs_2tap_DP_TX_IDX_0) <= rpmphs_2tap_ch0_int;    -- 3  - qpmaused
txdprioout_phy_ch0(rpmphs_1tap_DP_TX_IDX_3  DOWNTO  rpmphs_1tap_DP_TX_IDX_0) <= rpmphs_1tap_ch0_int;    -- 4  - qpmaused
txdprioout_phy_ch0(rtx_vtt_DP_TX_IDX_1      DOWNTO  rtx_vtt_DP_TX_IDX_0)     <= rtx_vtt_ch0_int;        -- 2 - to add in wys
txdprioout_phy_ch0(rpmphs_ptap_DP_TX_IDX_2  DOWNTO  rpmphs_ptap_DP_TX_IDX_0) <= rpmphs_ptap_ch0_int;    -- 3 - qpmaused

txdprioout_phy_ch1(rtx_vod_sel_DP_TX_IDX_2  DOWNTO  rtx_vod_sel_DP_TX_IDX_0) <= rtx_vod_sel_ch1_int;    -- 3-bits - qpmaused
txdprioout_phy_ch1(rtx_slewrate_DP_TX_IDX)                             <= rtx_slewrate_int(1);   -- 1-bit
txdprioout_phy_ch1(rpmphs_2tap_DP_TX_IDX_2  DOWNTO  rpmphs_2tap_DP_TX_IDX_0) <= rpmphs_2tap_ch1_int;    -- 3  - qpmaused
txdprioout_phy_ch1(rpmphs_1tap_DP_TX_IDX_3  DOWNTO  rpmphs_1tap_DP_TX_IDX_0) <= rpmphs_1tap_ch1_int;    -- 4  - qpmaused
txdprioout_phy_ch1(rtx_vtt_DP_TX_IDX_1      DOWNTO  rtx_vtt_DP_TX_IDX_0)     <= rtx_vtt_ch1_int;        -- 2 - to add in wys
txdprioout_phy_ch1(rpmphs_ptap_DP_TX_IDX_2  DOWNTO  rpmphs_ptap_DP_TX_IDX_0) <= rpmphs_ptap_ch1_int;    -- 3 - qpmaused

txdprioout_phy_ch2(rtx_vod_sel_DP_TX_IDX_2  DOWNTO  rtx_vod_sel_DP_TX_IDX_0) <= rtx_vod_sel_ch2_int;    -- 3-bits - qpmaused
txdprioout_phy_ch2(rtx_slewrate_DP_TX_IDX)                             <= rtx_slewrate_int(2);   -- 1-bit
txdprioout_phy_ch2(rpmphs_2tap_DP_TX_IDX_2  DOWNTO  rpmphs_2tap_DP_TX_IDX_0) <= rpmphs_2tap_ch2_int;    -- 3  - qpmaused
txdprioout_phy_ch2(rpmphs_1tap_DP_TX_IDX_3  DOWNTO  rpmphs_1tap_DP_TX_IDX_0) <= rpmphs_1tap_ch2_int;    -- 4  - qpmaused
txdprioout_phy_ch2(rtx_vtt_DP_TX_IDX_1      DOWNTO  rtx_vtt_DP_TX_IDX_0)     <= rtx_vtt_ch2_int;        -- 2 - to add in wys
txdprioout_phy_ch2(rpmphs_ptap_DP_TX_IDX_2  DOWNTO  rpmphs_ptap_DP_TX_IDX_0) <= rpmphs_ptap_ch2_int;    -- 3 - qpmaused

txdprioout_phy_ch3(rtx_vod_sel_DP_TX_IDX_2  DOWNTO  rtx_vod_sel_DP_TX_IDX_0) <= rtx_vod_sel_ch3_int;    -- 3-bits - qpmaused
txdprioout_phy_ch3(rtx_slewrate_DP_TX_IDX)                             <= rtx_slewrate_int(3);   -- 1-bit
txdprioout_phy_ch3(rpmphs_2tap_DP_TX_IDX_2  DOWNTO  rpmphs_2tap_DP_TX_IDX_0) <= rpmphs_2tap_ch3_int;    -- 3  - qpmaused
txdprioout_phy_ch3(rpmphs_1tap_DP_TX_IDX_3  DOWNTO  rpmphs_1tap_DP_TX_IDX_0) <= rpmphs_1tap_ch3_int;    -- 4  - qpmaused
txdprioout_phy_ch3(rtx_vtt_DP_TX_IDX_1      DOWNTO  rtx_vtt_DP_TX_IDX_0)     <= rtx_vtt_ch3_int;        -- 2 - to add in wys
txdprioout_phy_ch3(rpmphs_ptap_DP_TX_IDX_2  DOWNTO  rpmphs_ptap_DP_TX_IDX_0) <= rpmphs_ptap_ch3_int;    -- 3 - qpmaused


-- pma_ctrl8 DOWNTO  4.807c-807h - skipping other 14 bits (some are RX)
txdprioout_phy_ch0(r_rlpbk_DP_TX_IDX)       <= r_rlpbk_int(0);  -- 1 
txdprioout_phy_ch0(rs_rdlpbk_DP_TX_IDX)     <= rs_rdlpbk_int(0);   -- 1
txdprioout_phy_ch0(rsig_inv_2tap_DP_TX_IDX) <= rsig_inv_2tap_int(0);  -- 1 
txdprioout_phy_ch0(rsig_inv_pre_DP_TX_IDX)  <= rsig_inv_pre_int(0);   -- 1

txdprioout_phy_ch1(r_rlpbk_DP_TX_IDX)       <= r_rlpbk_int(1);  -- 1 
txdprioout_phy_ch1(rs_rdlpbk_DP_TX_IDX)     <= rs_rdlpbk_int(1);   -- 1
txdprioout_phy_ch1(rsig_inv_2tap_DP_TX_IDX) <= rsig_inv_2tap_int(1);  -- 1 
txdprioout_phy_ch1(rsig_inv_pre_DP_TX_IDX)  <= rsig_inv_pre_int(1);   -- 1

txdprioout_phy_ch2(r_rlpbk_DP_TX_IDX)       <= r_rlpbk_int(2);  -- 1 
txdprioout_phy_ch2(rs_rdlpbk_DP_TX_IDX)     <= rs_rdlpbk_int(2);   -- 1
txdprioout_phy_ch2(rsig_inv_2tap_DP_TX_IDX) <= rsig_inv_2tap_int(2);  -- 1 
txdprioout_phy_ch2(rsig_inv_pre_DP_TX_IDX)  <= rsig_inv_pre_int(2);   -- 1

txdprioout_phy_ch3(r_rlpbk_DP_TX_IDX)       <= r_rlpbk_int(3);  -- 1 
txdprioout_phy_ch3(rs_rdlpbk_DP_TX_IDX)     <= rs_rdlpbk_int(3);   -- 1
txdprioout_phy_ch3(rsig_inv_2tap_DP_TX_IDX) <= rsig_inv_2tap_int(3);  -- 1 
txdprioout_phy_ch3(rsig_inv_pre_DP_TX_IDX)  <= rsig_inv_pre_int(3);   -- 1


-- The address covers both rx(pma and dpma widths defined in RX) and tx
-- pma_ctrl4_ch0_ext <= {rpmadwidth_tx(0), rpma_doublewidth_tx(0), rtx_cmu_sel(0),
-- 806Ch                rtx_m_sel_ch0, rtxvcobypass(0), rtx_cgb_1x_en(0), rtx_cgb_4x_en(0),
--                      rtx_4x_sw(0), rpmadwidth_rx(0), rpma_doublewidth_rx(0),
--                      rrxvcobypass(0),rrect_adj_ch0, rrx_piso_bypass_ch0};
txdprioout_phy_ch0(rpmadwidth_tx_DP_TX_IDX)       <= rpmadwidth_tx_int(0);          -- 1 
txdprioout_phy_ch0(rpma_doublewidth_tx_DP_TX_IDX) <= rpma_doublewidth_tx_int(0);    -- 1 
--txdprioout_phy_ch0(rtx_cmu_sel_DP_TX_IDX)         <= rtx_cmu_sel_int(0);            -- 1 
txdprioout_phy_ch0(rtx_m_sel_DP_TX_IDX_1  DOWNTO  rtx_m_sel_DP_TX_IDX_0) <= rtx_m_sel_ch0_int; -- 2 
txdprioout_phy_ch0(rtx_cgb_1x_en_DP_TX_IDX)       <= rtx_cgb_1x_en_int(0);          -- 1 
txdprioout_phy_ch0(rtx_cgb_4x_en_DP_TX_IDX)       <= rtx_cgb_4x_en_int(0);          -- 1 
txdprioout_phy_ch0(rtx_4x_sw_DP_TX_IDX)           <= rtx_4x_sw_int(0);              -- 1 

txdprioout_phy_ch1(rpmadwidth_tx_DP_TX_IDX)       <= rpmadwidth_tx_int(1);          -- 1 
txdprioout_phy_ch1(rpma_doublewidth_tx_DP_TX_IDX) <= rpma_doublewidth_tx_int(1);    -- 1 
--txdprioout_phy_ch1(rtx_cmu_sel_DP_TX_IDX)         <= rtx_cmu_sel_int(1);            -- 1 
txdprioout_phy_ch1(rtx_m_sel_DP_TX_IDX_1  DOWNTO  rtx_m_sel_DP_TX_IDX_0) <= rtx_m_sel_ch1_int; -- 2 
txdprioout_phy_ch1(rtx_cgb_1x_en_DP_TX_IDX)       <= rtx_cgb_1x_en_int(1);          -- 1 
txdprioout_phy_ch1(rtx_cgb_4x_en_DP_TX_IDX)       <= rtx_cgb_4x_en_int(1);          -- 1 
txdprioout_phy_ch1(rtx_4x_sw_DP_TX_IDX)           <= rtx_4x_sw_int(1);              -- 1 

txdprioout_phy_ch2(rpmadwidth_tx_DP_TX_IDX)       <= rpmadwidth_tx_int(2);          -- 1 
txdprioout_phy_ch2(rpma_doublewidth_tx_DP_TX_IDX) <= rpma_doublewidth_tx_int(2);    -- 1 
--txdprioout_phy_ch2(rtx_cmu_sel_DP_TX_IDX)         <= rtx_cmu_sel_int(2);            -- 1 
txdprioout_phy_ch2(rtx_m_sel_DP_TX_IDX_1  DOWNTO  rtx_m_sel_DP_TX_IDX_0) <= rtx_m_sel_ch2_int; -- 2 
txdprioout_phy_ch2(rtx_cgb_1x_en_DP_TX_IDX)       <= rtx_cgb_1x_en_int(2);          -- 1 
txdprioout_phy_ch2(rtx_cgb_4x_en_DP_TX_IDX)       <= rtx_cgb_4x_en_int(2);          -- 1 
txdprioout_phy_ch2(rtx_4x_sw_DP_TX_IDX)           <= rtx_4x_sw_int(2);              -- 1 

txdprioout_phy_ch3(rpmadwidth_tx_DP_TX_IDX)       <= rpmadwidth_tx_int(3);          -- 1 
txdprioout_phy_ch3(rpma_doublewidth_tx_DP_TX_IDX) <= rpma_doublewidth_tx_int(3);    -- 1 
--txdprioout_phy_ch3(rtx_cmu_sel_DP_TX_IDX)         <= rtx_cmu_sel_int(3);            -- 1 
txdprioout_phy_ch3(rtx_m_sel_DP_TX_IDX_1  DOWNTO  rtx_m_sel_DP_TX_IDX_0) <= rtx_m_sel_ch3_int; -- 2 
txdprioout_phy_ch3(rtx_cgb_1x_en_DP_TX_IDX)       <= rtx_cgb_1x_en_int(3);          -- 1 
txdprioout_phy_ch3(rtx_cgb_4x_en_DP_TX_IDX)       <= rtx_cgb_4x_en_int(3);          -- 1 
txdprioout_phy_ch3(rtx_4x_sw_DP_TX_IDX)           <= rtx_4x_sw_int(3);              -- 1 

-- txpma_ctrl_output_to_add  - make sure _int is used


-- RX PMA - input-----------------------------------------------------------------------------

-- pma_ctrl2 DOWNTO  4.8064-4.8067 (rx)
rtx_term_ch0     <= rxdprioin_phy_ch0(rtx_term_DP_RX_IDX_1     DOWNTO  rtx_term_DP_RX_IDX_0);      -- 2-bits
r_tx_det_rx_ch0  <= rxdprioin_phy_ch0(r_tx_det_rx_DP_RX_IDX_1  DOWNTO  r_tx_det_rx_DP_RX_IDX_0);   -- 2-bit
rrx_term_ch0     <= rxdprioin_phy_ch0(rrx_term_DP_RX_IDX_1     DOWNTO  rrx_term_DP_RX_IDX_0);      -- 2
rforce_sigdet(0) <= rxdprioin_phy_ch0(rforce_sigdet_DP_RX_IDX);                      -- 1 
rrx_dc_couple(0) <= rxdprioin_phy_ch0(rrx_dc_couple_DP_RX_IDX);                      -- 1
rrx_eq_dc_ch0    <= rxdprioin_phy_ch0(rrx_eq_dc_DP_RX_IDX_1    DOWNTO  rrx_eq_dc_DP_RX_IDX_0);     -- 2 - qpmaused
rrx_vtt_ch0      <= rxdprioin_phy_ch0(rrx_vtt_DP_RX_IDX_2      DOWNTO  rrx_vtt_DP_RX_IDX_0);       -- 3
rrx_sloslv_ch0   <= rxdprioin_phy_ch0(rrx_sloslv_DP_RX_IDX_2   DOWNTO  rrx_sloslv_DP_RX_IDX_0);    -- 3

rtx_term_ch1     <= rxdprioin_phy_ch1(rtx_term_DP_RX_IDX_1     DOWNTO  rtx_term_DP_RX_IDX_0);      -- 2-bits
r_tx_det_rx_ch1  <= rxdprioin_phy_ch1(r_tx_det_rx_DP_RX_IDX_1  DOWNTO  r_tx_det_rx_DP_RX_IDX_0);   -- 2-bit
rrx_term_ch1     <= rxdprioin_phy_ch1(rrx_term_DP_RX_IDX_1     DOWNTO  rrx_term_DP_RX_IDX_0);      -- 2
rforce_sigdet(1) <= rxdprioin_phy_ch1(rforce_sigdet_DP_RX_IDX);                      -- 1 
rrx_dc_couple(1) <= rxdprioin_phy_ch1(rrx_dc_couple_DP_RX_IDX);                      -- 1
rrx_eq_dc_ch1    <= rxdprioin_phy_ch1(rrx_eq_dc_DP_RX_IDX_1    DOWNTO  rrx_eq_dc_DP_RX_IDX_0);     -- 2 - qpmaused
rrx_vtt_ch1      <= rxdprioin_phy_ch1(rrx_vtt_DP_RX_IDX_2      DOWNTO  rrx_vtt_DP_RX_IDX_0);       -- 3
rrx_sloslv_ch1   <= rxdprioin_phy_ch1(rrx_sloslv_DP_RX_IDX_2   DOWNTO  rrx_sloslv_DP_RX_IDX_0);    -- 3

rtx_term_ch2     <= rxdprioin_phy_ch2(rtx_term_DP_RX_IDX_1     DOWNTO  rtx_term_DP_RX_IDX_0);      -- 2-bits
r_tx_det_rx_ch2  <= rxdprioin_phy_ch2(r_tx_det_rx_DP_RX_IDX_1  DOWNTO  r_tx_det_rx_DP_RX_IDX_0);   -- 2-bit
rrx_term_ch2     <= rxdprioin_phy_ch2(rrx_term_DP_RX_IDX_1     DOWNTO  rrx_term_DP_RX_IDX_0);      -- 2
rforce_sigdet(2) <= rxdprioin_phy_ch2(rforce_sigdet_DP_RX_IDX);                      -- 1 
rrx_dc_couple(2) <= rxdprioin_phy_ch2(rrx_dc_couple_DP_RX_IDX);                      -- 1
rrx_eq_dc_ch2    <= rxdprioin_phy_ch2(rrx_eq_dc_DP_RX_IDX_1    DOWNTO  rrx_eq_dc_DP_RX_IDX_0);     -- 2 - qpmaused
rrx_vtt_ch2      <= rxdprioin_phy_ch2(rrx_vtt_DP_RX_IDX_2      DOWNTO  rrx_vtt_DP_RX_IDX_0);       -- 3
rrx_sloslv_ch2   <= rxdprioin_phy_ch2(rrx_sloslv_DP_RX_IDX_2   DOWNTO  rrx_sloslv_DP_RX_IDX_0);    -- 3

rtx_term_ch3     <= rxdprioin_phy_ch3(rtx_term_DP_RX_IDX_1     DOWNTO  rtx_term_DP_RX_IDX_0);      -- 2-bits
r_tx_det_rx_ch3  <= rxdprioin_phy_ch3(r_tx_det_rx_DP_RX_IDX_1  DOWNTO  r_tx_det_rx_DP_RX_IDX_0);   -- 2-bit
rrx_term_ch3     <= rxdprioin_phy_ch3(rrx_term_DP_RX_IDX_1     DOWNTO  rrx_term_DP_RX_IDX_0);      -- 2
rforce_sigdet(3) <= rxdprioin_phy_ch3(rforce_sigdet_DP_RX_IDX);                      -- 1 
rrx_dc_couple(3) <= rxdprioin_phy_ch3(rrx_dc_couple_DP_RX_IDX);                      -- 1
rrx_eq_dc_ch3    <= rxdprioin_phy_ch3(rrx_eq_dc_DP_RX_IDX_1    DOWNTO  rrx_eq_dc_DP_RX_IDX_0);     -- 2 - qpmaused
rrx_vtt_ch3      <= rxdprioin_phy_ch3(rrx_vtt_DP_RX_IDX_2      DOWNTO  rrx_vtt_DP_RX_IDX_0);       -- 3
rrx_sloslv_ch3   <= rxdprioin_phy_ch3(rrx_sloslv_DP_RX_IDX_2   DOWNTO  rrx_sloslv_DP_RX_IDX_0);    -- 3


-- pma_ctrl3 DOWNTO  4.8068-4.806b (rx)
reqa_ct_ch0     <= rxdprioin_phy_ch0(reqa_ct_DP_RX_IDX_2      DOWNTO  reqa_ct_DP_RX_IDX_0); -- 3-bits  - qpmaused
reqb_ct_ch0     <= rxdprioin_phy_ch0(reqb_ct_DP_RX_IDX_2      DOWNTO  reqb_ct_DP_RX_IDX_0); -- 3-bit - qpmaused
reqc_ct_ch0     <= rxdprioin_phy_ch0(reqc_ct_DP_RX_IDX_2      DOWNTO  reqc_ct_DP_RX_IDX_0);   -- 3 - qpmaused
reqd_ct_ch0     <= rxdprioin_phy_ch0(reqd_ct_DP_RX_IDX_2      DOWNTO  reqd_ct_DP_RX_IDX_0);   -- 3 - qpmaused 
req_ctv_ch0     <= rxdprioin_phy_ch0(req_ctv_DP_RX_IDX_2      DOWNTO  req_ctv_DP_RX_IDX_0);   -- 3 - qpmaused

reqa_ct_ch1     <= rxdprioin_phy_ch1(reqa_ct_DP_RX_IDX_2      DOWNTO  reqa_ct_DP_RX_IDX_0); -- 3-bits  - qpmaused
reqb_ct_ch1     <= rxdprioin_phy_ch1(reqb_ct_DP_RX_IDX_2      DOWNTO  reqb_ct_DP_RX_IDX_0); -- 3-bit - qpmaused
reqc_ct_ch1     <= rxdprioin_phy_ch1(reqc_ct_DP_RX_IDX_2      DOWNTO  reqc_ct_DP_RX_IDX_0);   -- 3 - qpmaused
reqd_ct_ch1     <= rxdprioin_phy_ch1(reqd_ct_DP_RX_IDX_2      DOWNTO  reqd_ct_DP_RX_IDX_0);   -- 3 - qpmaused 
req_ctv_ch1     <= rxdprioin_phy_ch1(req_ctv_DP_RX_IDX_2      DOWNTO  req_ctv_DP_RX_IDX_0);   -- 3 - qpmaused

reqa_ct_ch2     <= rxdprioin_phy_ch2(reqa_ct_DP_RX_IDX_2      DOWNTO  reqa_ct_DP_RX_IDX_0); -- 3-bits  - qpmaused
reqb_ct_ch2     <= rxdprioin_phy_ch2(reqb_ct_DP_RX_IDX_2      DOWNTO  reqb_ct_DP_RX_IDX_0); -- 3-bit - qpmaused
reqc_ct_ch2     <= rxdprioin_phy_ch2(reqc_ct_DP_RX_IDX_2      DOWNTO  reqc_ct_DP_RX_IDX_0);   -- 3 - qpmaused
reqd_ct_ch2     <= rxdprioin_phy_ch2(reqd_ct_DP_RX_IDX_2      DOWNTO  reqd_ct_DP_RX_IDX_0);   -- 3 - qpmaused 
req_ctv_ch2     <= rxdprioin_phy_ch2(req_ctv_DP_RX_IDX_2      DOWNTO  req_ctv_DP_RX_IDX_0);   -- 3 - qpmaused

reqa_ct_ch3     <= rxdprioin_phy_ch3(reqa_ct_DP_RX_IDX_2      DOWNTO  reqa_ct_DP_RX_IDX_0); -- 3-bits  - qpmaused
reqb_ct_ch3     <= rxdprioin_phy_ch3(reqb_ct_DP_RX_IDX_2      DOWNTO  reqb_ct_DP_RX_IDX_0); -- 3-bit - qpmaused
reqc_ct_ch3     <= rxdprioin_phy_ch3(reqc_ct_DP_RX_IDX_2      DOWNTO  reqc_ct_DP_RX_IDX_0);   -- 3 - qpmaused
reqd_ct_ch3     <= rxdprioin_phy_ch3(reqd_ct_DP_RX_IDX_2      DOWNTO  reqd_ct_DP_RX_IDX_0);   -- 3 - qpmaused 
req_ctv_ch3     <= rxdprioin_phy_ch3(req_ctv_DP_RX_IDX_2      DOWNTO  req_ctv_DP_RX_IDX_0);   -- 3 - qpmaused

-- part of pma_ctrl4 806Ch
-- <= {rpmadwidth_tx(0), rpma_doublewidth_tx(0), rtx_cmu_sel(0),
--    rtx_m_sel_ch0, rtxvcobypass(0), rtx_cgb_1x_en(0), rtx_cgb_4x_en(0),
--    rtx_4x_sw(0), rpmadwidth_rx(0), rpma_doublewidth_rx(0),
--    rrxvcobypass(0),rrect_adj_ch0, rrx_piso_bypass_ch0};
rpmadwidth_rx(0)        <= rxdprioin_phy_ch0(rpmadwidth_rx_DP_RX_IDX);
rpma_doublewidth_rx(0)  <= rxdprioin_phy_ch0(rpma_doublewidth_rx_DP_RX_IDX);
                                                                                                     
rpmadwidth_rx(1)        <= rxdprioin_phy_ch1(rpmadwidth_rx_DP_RX_IDX);
rpma_doublewidth_rx(1)  <= rxdprioin_phy_ch1(rpma_doublewidth_rx_DP_RX_IDX);

rpmadwidth_rx(2)        <= rxdprioin_phy_ch2(rpmadwidth_rx_DP_RX_IDX);
rpma_doublewidth_rx(2)  <= rxdprioin_phy_ch2(rpma_doublewidth_rx_DP_RX_IDX);

rpmadwidth_rx(3)        <= rxdprioin_phy_ch3(rpmadwidth_rx_DP_RX_IDX);
rpma_doublewidth_rx(3)  <= rxdprioin_phy_ch3(rpma_doublewidth_rx_DP_RX_IDX);

-- pma_ctrl6_ch0_ext <= {rrefclk_sel_ch0, rbwctral_rx_ch0, rrx_cru_m_sel_ch0, 
-- 8074h                rrx_cru_div2(0), rrx_cru_ctl_ch0, rltr(0), rltd(0)};
rrx_cru_m_sel_ch0 <= rxdprioin_phy_ch0(rrx_cru_m_sel_DP_RX_IDX_1  DOWNTO  rrx_cru_m_sel_DP_RX_IDX_0); -- 2-bits
rrx_cru_div2(0)   <= rxdprioin_phy_ch0(rrx_cru_div2_DP_RX_IDX);                                -- 1-bits
rltr(0)           <= rxdprioin_phy_ch0(rltr_DP_RX_IDX);                                        -- 1-bit
rltd(0)           <= rxdprioin_phy_ch0(rltd_DP_RX_IDX);                                        -- 1-bit
rrx_cru_m_sel_ch1 <= rxdprioin_phy_ch1(rrx_cru_m_sel_DP_RX_IDX_1  DOWNTO  rrx_cru_m_sel_DP_RX_IDX_0); -- 2-bits
rrx_cru_div2(1)   <= rxdprioin_phy_ch1(rrx_cru_div2_DP_RX_IDX);                                -- 1-bits
rltr(1)           <= rxdprioin_phy_ch1(rltr_DP_RX_IDX);                                        -- 1-bit
rltd(1)           <= rxdprioin_phy_ch1(rltd_DP_RX_IDX);                                        -- 1-bit
rrx_cru_m_sel_ch2 <= rxdprioin_phy_ch2(rrx_cru_m_sel_DP_RX_IDX_1  DOWNTO  rrx_cru_m_sel_DP_RX_IDX_0); -- 2-bits
rrx_cru_div2(2)   <= rxdprioin_phy_ch2(rrx_cru_div2_DP_RX_IDX);                                -- 1-bits
rltr(2)           <= rxdprioin_phy_ch2(rltr_DP_RX_IDX);                                        -- 1-bit
rltd(2)           <= rxdprioin_phy_ch2(rltd_DP_RX_IDX);                                        -- 1-bit
rrx_cru_m_sel_ch3 <= rxdprioin_phy_ch3(rrx_cru_m_sel_DP_RX_IDX_1  DOWNTO  rrx_cru_m_sel_DP_RX_IDX_0); -- 2-bits
rrx_cru_div2(3)   <= rxdprioin_phy_ch3(rrx_cru_div2_DP_RX_IDX);                                -- 1-bits
rltr(3)           <= rxdprioin_phy_ch3(rltr_DP_RX_IDX);                                        -- 1-bit
rltd(3)           <= rxdprioin_phy_ch3(rltd_DP_RX_IDX);                                        -- 1-bit

-- pma_ctrl7_ch0_ext <= {risel_rx_ch0, riupsel_rx_ch0, ridnsel_rx_ch0,
-- 8078h               rtesten_cp_rx(0), rtristate_cp_rx(0), rtestupen_cp_rx(0),
--                     rtestdnen_cp_rx(0), rrx_cru_m_ch0, rrx_cru_l_ch0};
rrx_cru_m_ch0     <= rxdprioin_phy_ch0(rrx_cru_m_DP_RX_IDX_3  DOWNTO  rrx_cru_m_DP_RX_IDX_0);         -- 4-bit
rrx_cru_l_ch0     <= rxdprioin_phy_ch0(rrx_cru_l_DP_RX_IDX_1  DOWNTO  rrx_cru_l_DP_RX_IDX_0);         -- 2-bit
rrx_cru_m_ch1     <= rxdprioin_phy_ch1(rrx_cru_m_DP_RX_IDX_3  DOWNTO  rrx_cru_m_DP_RX_IDX_0);         -- 4-bit
rrx_cru_l_ch1     <= rxdprioin_phy_ch1(rrx_cru_l_DP_RX_IDX_1  DOWNTO  rrx_cru_l_DP_RX_IDX_0);         -- 2-bit
rrx_cru_m_ch2     <= rxdprioin_phy_ch2(rrx_cru_m_DP_RX_IDX_3  DOWNTO  rrx_cru_m_DP_RX_IDX_0);         -- 4-bit
rrx_cru_l_ch2     <= rxdprioin_phy_ch2(rrx_cru_l_DP_RX_IDX_1  DOWNTO  rrx_cru_l_DP_RX_IDX_0);         -- 2-bit
rrx_cru_m_ch3     <= rxdprioin_phy_ch3(rrx_cru_m_DP_RX_IDX_3  DOWNTO  rrx_cru_m_DP_RX_IDX_0);         -- 4-bit
rrx_cru_l_ch3     <= rxdprioin_phy_ch3(rrx_cru_l_DP_RX_IDX_1  DOWNTO  rrx_cru_l_DP_RX_IDX_0);         -- 2-bit

-- pma_ctrl8 DOWNTO  4.807c-807h - RX portion
-- pma_ctrl8_ch0_ext <= {rs_lpbk(0), r_rlpbk(0), rs_rdlpbk(0), rrx_revlb_sw(0),
--                             rurx_pdb(0), rtx_cgb_pdb(0), rtx_ob_pdb(0), rrx_cru_pdb(0),
--                             rrx_cru_rst(0), rrx_ib_pdb(0), rrxurstpma(0), radce_adapt(0),
--                             radce_pdb(0), radce_rst(0), rsig_inv_2tap(0), rsig_inv_pre(0)};
rs_lpbk(0)        <= rxdprioin_phy_ch0(rs_lpbk_DP_RX_IDX); 
rrx_revlb_sw(0)   <= rxdprioin_phy_ch0(rrx_revlb_sw_DP_RX_IDX); 
rs_lpbk(1)        <= rxdprioin_phy_ch1(rs_lpbk_DP_RX_IDX); 
rrx_revlb_sw(1)   <= rxdprioin_phy_ch1(rrx_revlb_sw_DP_RX_IDX); 
rs_lpbk(2)        <= rxdprioin_phy_ch2(rs_lpbk_DP_RX_IDX); 
rrx_revlb_sw(2)   <= rxdprioin_phy_ch2(rrx_revlb_sw_DP_RX_IDX); 
rs_lpbk(3)        <= rxdprioin_phy_ch3(rs_lpbk_DP_RX_IDX); 
rrx_revlb_sw(3)   <= rxdprioin_phy_ch3(rrx_revlb_sw_DP_RX_IDX); 


--  <=<=<=<=<=<=<=<=<=<=<=<=<= rxpma_ctrl_input_to_add  <=<=<=<=<=<=<=<=<=<=<=<=<=<=<=<=<=<=<=



-- RX PMA - output -----------------------------------------------------------------------------

-- pma_ctrl2 DOWNTO  4.8064-4.8067 (rx)
rxdprioout_phy_ch0(rtx_term_DP_RX_IDX_1     DOWNTO  rtx_term_DP_RX_IDX_0)    <= rtx_term_ch0_int;      -- 2-bits
rxdprioout_phy_ch0(r_tx_det_rx_DP_RX_IDX_1  DOWNTO  r_tx_det_rx_DP_RX_IDX_0) <= r_tx_det_rx_ch0_int;   -- 2-bit
rxdprioout_phy_ch0(rrx_term_DP_RX_IDX_1     DOWNTO  rrx_term_DP_RX_IDX_0)    <= rrx_term_ch0_int;      -- 2
rxdprioout_phy_ch0(rforce_sigdet_DP_RX_IDX)                            <= rforce_sigdet_int(0);  -- 1 
rxdprioout_phy_ch0(rrx_dc_couple_DP_RX_IDX)                            <= rrx_dc_couple_int(0);  -- 1
rxdprioout_phy_ch0(rrx_eq_dc_DP_RX_IDX_1    DOWNTO  rrx_eq_dc_DP_RX_IDX_0)   <= rrx_eq_dc_ch0_int;     -- 2 - qpmaused
rxdprioout_phy_ch0(rrx_vtt_DP_RX_IDX_2      DOWNTO  rrx_vtt_DP_RX_IDX_0)     <= rrx_vtt_ch0_int;       -- 3
rxdprioout_phy_ch0(rrx_sloslv_DP_RX_IDX_2   DOWNTO  rrx_sloslv_DP_RX_IDX_0)  <= rrx_sloslv_ch0_int;    -- 3

rxdprioout_phy_ch1(rtx_term_DP_RX_IDX_1     DOWNTO  rtx_term_DP_RX_IDX_0)    <= rtx_term_ch1_int;      -- 2-bits
rxdprioout_phy_ch1(r_tx_det_rx_DP_RX_IDX_1  DOWNTO  r_tx_det_rx_DP_RX_IDX_0) <= r_tx_det_rx_ch1_int;   -- 2-bit
rxdprioout_phy_ch1(rrx_term_DP_RX_IDX_1     DOWNTO  rrx_term_DP_RX_IDX_0)    <= rrx_term_ch1_int;      -- 2
rxdprioout_phy_ch1(rforce_sigdet_DP_RX_IDX)                            <= rforce_sigdet_int(1);  -- 1 
rxdprioout_phy_ch1(rrx_dc_couple_DP_RX_IDX)                            <= rrx_dc_couple_int(1);  -- 1
rxdprioout_phy_ch1(rrx_eq_dc_DP_RX_IDX_1    DOWNTO  rrx_eq_dc_DP_RX_IDX_0)   <= rrx_eq_dc_ch1_int;     -- 2 - qpmaused
rxdprioout_phy_ch1(rrx_vtt_DP_RX_IDX_2      DOWNTO  rrx_vtt_DP_RX_IDX_0)     <= rrx_vtt_ch1_int;       -- 3
rxdprioout_phy_ch1(rrx_sloslv_DP_RX_IDX_2   DOWNTO  rrx_sloslv_DP_RX_IDX_0)  <= rrx_sloslv_ch1_int;    -- 3

rxdprioout_phy_ch2(rtx_term_DP_RX_IDX_1     DOWNTO  rtx_term_DP_RX_IDX_0)    <= rtx_term_ch2_int;      -- 2-bits
rxdprioout_phy_ch2(r_tx_det_rx_DP_RX_IDX_1  DOWNTO  r_tx_det_rx_DP_RX_IDX_0) <= r_tx_det_rx_ch2_int;   -- 2-bit
rxdprioout_phy_ch2(rrx_term_DP_RX_IDX_1     DOWNTO  rrx_term_DP_RX_IDX_0)    <= rrx_term_ch2_int;      -- 2
rxdprioout_phy_ch2(rforce_sigdet_DP_RX_IDX)                            <= rforce_sigdet_int(2);  -- 1 
rxdprioout_phy_ch2(rrx_dc_couple_DP_RX_IDX)                            <= rrx_dc_couple_int(2);  -- 1
rxdprioout_phy_ch2(rrx_eq_dc_DP_RX_IDX_1    DOWNTO  rrx_eq_dc_DP_RX_IDX_0)   <= rrx_eq_dc_ch2_int;     -- 2 - qpmaused
rxdprioout_phy_ch2(rrx_vtt_DP_RX_IDX_2      DOWNTO  rrx_vtt_DP_RX_IDX_0)     <= rrx_vtt_ch2_int;       -- 3
rxdprioout_phy_ch2(rrx_sloslv_DP_RX_IDX_2   DOWNTO  rrx_sloslv_DP_RX_IDX_0)  <= rrx_sloslv_ch2_int;    -- 3

rxdprioout_phy_ch3(rtx_term_DP_RX_IDX_1     DOWNTO  rtx_term_DP_RX_IDX_0)    <= rtx_term_ch3_int;      -- 2-bits
rxdprioout_phy_ch3(r_tx_det_rx_DP_RX_IDX_1  DOWNTO  r_tx_det_rx_DP_RX_IDX_0) <= r_tx_det_rx_ch3_int;   -- 2-bit
rxdprioout_phy_ch3(rrx_term_DP_RX_IDX_1     DOWNTO  rrx_term_DP_RX_IDX_0)    <= rrx_term_ch3_int;      -- 2
rxdprioout_phy_ch3(rforce_sigdet_DP_RX_IDX)                            <= rforce_sigdet_int(3);  -- 1 
rxdprioout_phy_ch3(rrx_dc_couple_DP_RX_IDX)                            <= rrx_dc_couple_int(3);  -- 1
rxdprioout_phy_ch3(rrx_eq_dc_DP_RX_IDX_1    DOWNTO  rrx_eq_dc_DP_RX_IDX_0)   <= rrx_eq_dc_ch3_int;     -- 2 - qpmaused
rxdprioout_phy_ch3(rrx_vtt_DP_RX_IDX_2      DOWNTO  rrx_vtt_DP_RX_IDX_0)     <= rrx_vtt_ch3_int;       -- 3
rxdprioout_phy_ch3(rrx_sloslv_DP_RX_IDX_2   DOWNTO  rrx_sloslv_DP_RX_IDX_0)  <= rrx_sloslv_ch3_int;    -- 3

-- pma_ctrl3 DOWNTO  4.8068-4.806b (rx)
rxdprioout_phy_ch0(reqa_ct_DP_RX_IDX_2  DOWNTO  reqa_ct_DP_RX_IDX_0) <= reqa_ct_ch0_int;    -- 3-bits  - qpmaused
rxdprioout_phy_ch0(reqb_ct_DP_RX_IDX_2  DOWNTO  reqb_ct_DP_RX_IDX_0) <= reqb_ct_ch0_int;    -- 3-bit - qpmaused
rxdprioout_phy_ch0(reqc_ct_DP_RX_IDX_2  DOWNTO  reqc_ct_DP_RX_IDX_0)  <= reqc_ct_ch0_int;    -- 3 - qpmaused
rxdprioout_phy_ch0(reqd_ct_DP_RX_IDX_2  DOWNTO  reqd_ct_DP_RX_IDX_0)  <= reqd_ct_ch0_int;    -- 3 - qpmaused 
rxdprioout_phy_ch0(req_ctv_DP_RX_IDX_2  DOWNTO  req_ctv_DP_RX_IDX_0)  <= req_ctv_ch0_int;    -- 3 - qpmaused

rxdprioout_phy_ch1(reqa_ct_DP_RX_IDX_2  DOWNTO  reqa_ct_DP_RX_IDX_0) <= reqa_ct_ch1_int;    -- 3-bits  - qpmaused
rxdprioout_phy_ch1(reqb_ct_DP_RX_IDX_2  DOWNTO  reqb_ct_DP_RX_IDX_0) <= reqb_ct_ch1_int;    -- 3-bit - qpmaused
rxdprioout_phy_ch1(reqc_ct_DP_RX_IDX_2  DOWNTO  reqc_ct_DP_RX_IDX_0)  <= reqc_ct_ch1_int;    -- 3 - qpmaused
rxdprioout_phy_ch1(reqd_ct_DP_RX_IDX_2  DOWNTO  reqd_ct_DP_RX_IDX_0)  <= reqd_ct_ch1_int;    -- 3 - qpmaused 
rxdprioout_phy_ch1(req_ctv_DP_RX_IDX_2  DOWNTO  req_ctv_DP_RX_IDX_0)  <= req_ctv_ch1_int;    -- 3 - qpmaused

rxdprioout_phy_ch2(reqa_ct_DP_RX_IDX_2  DOWNTO  reqa_ct_DP_RX_IDX_0) <= reqa_ct_ch2_int;    -- 3-bits  - qpmaused
rxdprioout_phy_ch2(reqb_ct_DP_RX_IDX_2  DOWNTO  reqb_ct_DP_RX_IDX_0) <= reqb_ct_ch2_int;    -- 3-bit - qpmaused
rxdprioout_phy_ch2(reqc_ct_DP_RX_IDX_2  DOWNTO  reqc_ct_DP_RX_IDX_0)  <= reqc_ct_ch2_int;    -- 3 - qpmaused
rxdprioout_phy_ch2(reqd_ct_DP_RX_IDX_2  DOWNTO  reqd_ct_DP_RX_IDX_0)  <= reqd_ct_ch2_int;    -- 3 - qpmaused 
rxdprioout_phy_ch2(req_ctv_DP_RX_IDX_2  DOWNTO  req_ctv_DP_RX_IDX_0)  <= req_ctv_ch2_int;    -- 3 - qpmaused

rxdprioout_phy_ch3(reqa_ct_DP_RX_IDX_2  DOWNTO  reqa_ct_DP_RX_IDX_0) <= reqa_ct_ch3_int;    -- 3-bits  - qpmaused
rxdprioout_phy_ch3(reqb_ct_DP_RX_IDX_2  DOWNTO  reqb_ct_DP_RX_IDX_0) <= reqb_ct_ch3_int;    -- 3-bit - qpmaused
rxdprioout_phy_ch3(reqc_ct_DP_RX_IDX_2  DOWNTO  reqc_ct_DP_RX_IDX_0)  <= reqc_ct_ch3_int;    -- 3 - qpmaused
rxdprioout_phy_ch3(reqd_ct_DP_RX_IDX_2  DOWNTO  reqd_ct_DP_RX_IDX_0)  <= reqd_ct_ch3_int;    -- 3 - qpmaused 
rxdprioout_phy_ch3(req_ctv_DP_RX_IDX_2  DOWNTO  req_ctv_DP_RX_IDX_0)  <= req_ctv_ch3_int;    -- 3 - qpmaused

-- part of pma_ctrl4 806Ch
rxdprioout_phy_ch0(rpmadwidth_rx_DP_RX_IDX)       <= rpmadwidth_rx_int(0);
rxdprioout_phy_ch0(rpma_doublewidth_rx_DP_RX_IDX) <= rpma_doublewidth_rx_int(0);
                                                                                                     
rxdprioout_phy_ch1(rpmadwidth_rx_DP_RX_IDX)       <= rpmadwidth_rx_int(1);
rxdprioout_phy_ch1(rpma_doublewidth_rx_DP_RX_IDX) <= rpma_doublewidth_rx_int(1);
                                                                                                     
rxdprioout_phy_ch2(rpmadwidth_rx_DP_RX_IDX)       <= rpmadwidth_rx_int(2);
rxdprioout_phy_ch2(rpma_doublewidth_rx_DP_RX_IDX) <= rpma_doublewidth_rx_int(2);
                                                                                                     
rxdprioout_phy_ch3(rpmadwidth_rx_DP_RX_IDX)       <= rpmadwidth_rx_int(3);
rxdprioout_phy_ch3(rpma_doublewidth_rx_DP_RX_IDX) <= rpma_doublewidth_rx_int(3);

-- pma_ctrl6 DOWNTO  8074-8077 (rx)
rxdprioout_phy_ch0(rrx_cru_m_sel_DP_RX_IDX_1  DOWNTO  rrx_cru_m_sel_DP_RX_IDX_0) <= rrx_cru_m_sel_ch0_int;
rxdprioout_phy_ch0(rrx_cru_div2_DP_RX_IDX)                                <= rrx_cru_div2_int(0);
rxdprioout_phy_ch0(rltr_DP_RX_IDX)                                        <= rltr_int(0);
rxdprioout_phy_ch0(rltd_DP_RX_IDX)                                        <= rltd_int(0);

rxdprioout_phy_ch1(rrx_cru_m_sel_DP_RX_IDX_1  DOWNTO  rrx_cru_m_sel_DP_RX_IDX_0) <= rrx_cru_m_sel_ch1_int;
rxdprioout_phy_ch1(rrx_cru_div2_DP_RX_IDX)                                <= rrx_cru_div2_int(1);
rxdprioout_phy_ch1(rltr_DP_RX_IDX)                                        <= rltr_int(1);
rxdprioout_phy_ch1(rltd_DP_RX_IDX)                                        <= rltd_int(1);

rxdprioout_phy_ch2(rrx_cru_m_sel_DP_RX_IDX_1  DOWNTO  rrx_cru_m_sel_DP_RX_IDX_0) <= rrx_cru_m_sel_ch2_int;
rxdprioout_phy_ch2(rrx_cru_div2_DP_RX_IDX)                                <= rrx_cru_div2_int(2);
rxdprioout_phy_ch2(rltr_DP_RX_IDX)                                        <= rltr_int(2);
rxdprioout_phy_ch2(rltd_DP_RX_IDX)                                        <= rltd_int(2);

rxdprioout_phy_ch3(rrx_cru_m_sel_DP_RX_IDX_1  DOWNTO  rrx_cru_m_sel_DP_RX_IDX_0) <= rrx_cru_m_sel_ch3_int;
rxdprioout_phy_ch3(rrx_cru_div2_DP_RX_IDX)                                <= rrx_cru_div2_int(3);
rxdprioout_phy_ch3(rltr_DP_RX_IDX)                                        <= rltr_int(3);
rxdprioout_phy_ch3(rltd_DP_RX_IDX)                                        <= rltd_int(3);

-- pma_ctrl7 DOWNTO  8078-807B
rxdprioout_phy_ch0(rrx_cru_m_DP_RX_IDX_3  DOWNTO  rrx_cru_m_DP_RX_IDX_0) <= rrx_cru_m_ch0_int;
rxdprioout_phy_ch0(rrx_cru_l_DP_RX_IDX_1  DOWNTO  rrx_cru_l_DP_RX_IDX_0) <= rrx_cru_l_ch0_int;

rxdprioout_phy_ch1(rrx_cru_m_DP_RX_IDX_3  DOWNTO  rrx_cru_m_DP_RX_IDX_0) <= rrx_cru_m_ch1_int;
rxdprioout_phy_ch1(rrx_cru_l_DP_RX_IDX_1  DOWNTO  rrx_cru_l_DP_RX_IDX_0) <= rrx_cru_l_ch1_int;

rxdprioout_phy_ch2(rrx_cru_m_DP_RX_IDX_3  DOWNTO  rrx_cru_m_DP_RX_IDX_0) <= rrx_cru_m_ch2_int;
rxdprioout_phy_ch2(rrx_cru_l_DP_RX_IDX_1  DOWNTO  rrx_cru_l_DP_RX_IDX_0) <= rrx_cru_l_ch2_int;

rxdprioout_phy_ch3(rrx_cru_m_DP_RX_IDX_3  DOWNTO  rrx_cru_m_DP_RX_IDX_0) <= rrx_cru_m_ch3_int;
rxdprioout_phy_ch3(rrx_cru_l_DP_RX_IDX_1  DOWNTO  rrx_cru_l_DP_RX_IDX_0) <= rrx_cru_l_ch3_int;
                                                                                                     
-- pma_ctrl8 DOWNTO  4.807c-807h - RX portion
rxdprioout_phy_ch0(rs_lpbk_DP_RX_IDX)              <= rs_lpbk_int(0); 
rxdprioout_phy_ch0(rrx_revlb_sw_DP_RX_IDX)         <= rrx_revlb_sw_int(0); 
rxdprioout_phy_ch1(rs_lpbk_DP_RX_IDX)              <= rs_lpbk_int(1); 
rxdprioout_phy_ch1(rrx_revlb_sw_DP_RX_IDX)         <= rrx_revlb_sw_int(1); 
rxdprioout_phy_ch2(rs_lpbk_DP_RX_IDX)              <= rs_lpbk_int(2); 
rxdprioout_phy_ch2(rrx_revlb_sw_DP_RX_IDX)         <= rrx_revlb_sw_int(2); 
rxdprioout_phy_ch3(rs_lpbk_DP_RX_IDX)              <= rs_lpbk_int(3); 
rxdprioout_phy_ch3(rrx_revlb_sw_DP_RX_IDX)         <= rrx_revlb_sw_int(3); 

-- <=<=<=<=<=<=<=<=<=<=<=<=<= rxpma_ctrl_output_to_add  - make sure _int is used <=<=<=<=<=<=<=<=<=<=<=<=<=

-- PMA_GLOBAL_CTRL_4
--  pma_global_ctrl4_ext <= {rcmu0_m, rcmu1_m, rcmu0_l, rcmu1_l, rcmu0_pdb, rcmu1_pdb,
--                                rcmu0_txpll_rst, rcmu1_txpll_rst};

tmp_cmupll_m0 <= cmuplldprioin_phy_0(rcmu_m_DP_CMUPLL_IDX_7 DOWNTO rcmu_m_DP_CMUPLL_IDX_0);
tmp_cmupll_l0 <= cmuplldprioin_phy_0(rcmu_l_DP_CMUPLL_IDX_7 DOWNTO rcmu_l_DP_CMUPLL_IDX_0);
tmp_cmupll_m1 <= cmuplldprioin_phy_1(rcmu_m_DP_CMUPLL_IDX_7 DOWNTO rcmu_m_DP_CMUPLL_IDX_0);
tmp_cmupll_l1 <= cmuplldprioin_phy_1(rcmu_l_DP_CMUPLL_IDX_7 DOWNTO rcmu_l_DP_CMUPLL_IDX_0);
tmp_cmupll_m2 <= cmuplldprioin_phy_2(rcmu_m_DP_CMUPLL_IDX_7 DOWNTO rcmu_m_DP_CMUPLL_IDX_0);
tmp_cmupll_l2 <= cmuplldprioin_phy_2(rcmu_l_DP_CMUPLL_IDX_7 DOWNTO rcmu_l_DP_CMUPLL_IDX_0);

rcmu0_m <= convert_cmupll_m_in_to_cram(tmp_cmupll_m0);
rcmu1_m <= convert_cmupll_m_in_to_cram(tmp_cmupll_m1);
rcmu2_m <= convert_cmupll_m_in_to_cram(tmp_cmupll_m2);
rcmu0_l <= convert_cmupll_l_in_to_cram(tmp_cmupll_l0);
rcmu1_l <= convert_cmupll_l_in_to_cram(tmp_cmupll_l1);
rcmu2_l <= convert_cmupll_l_in_to_cram(tmp_cmupll_l2);

rcmu0_pdb <= '1'; -- default by design cmuplldprioin_phy_0(rcmu_pdb_DP_CMUPLL_IDX);
rcmu1_pdb <= '1'; -- default by design cmuplldprioin_phy_1(rcmu_pdb_DP_CMUPLL_IDX);
rcmu2_pdb <= '1'; -- default by design cmuplldprioin_phy_2(rcmu_pdb_DP_CMUPLL_IDX);

rcmu0_txpll_rst <= '0'; -- default by design cmuplldprioin_phy_0(rcmu_txpll_rst_DP_CMUPLL_IDX);
rcmu1_txpll_rst <= '0'; -- default by design cmuplldprioin_phy_1(rcmu_txpll_rst_DP_CMUPLL_IDX);
rcmu2_txpll_rst <= '0'; -- default by design cmuplldprioin_phy_2(rcmu_txpll_rst_DP_CMUPLL_IDX);

                 
-- ============= cmupll_ctrl_input_to_add   =============

-- CMUPLL output ---------------------------------------------------------------------------
tmp_cmupll_m0_int <= convert_cram_to_cmupll_m_out(rcmu0_m_int);
tmp_cmupll_l0_int <= convert_cram_to_cmupll_l_out(rcmu0_l_int);
tmp_cmupll_m1_int <= convert_cram_to_cmupll_m_out(rcmu1_m_int);
tmp_cmupll_l1_int <= convert_cram_to_cmupll_l_out(rcmu1_l_int);
tmp_cmupll_m2_int <= convert_cram_to_cmupll_m_out(rcmu2_m_int);
tmp_cmupll_l2_int <= convert_cram_to_cmupll_l_out(rcmu2_l_int);

cmuplldprioout_phy_0(rcmu_m_DP_CMUPLL_IDX_7 DOWNTO rcmu_m_DP_CMUPLL_IDX_0) <= tmp_cmupll_m0_int;
cmuplldprioout_phy_0(rcmu_l_DP_CMUPLL_IDX_7 DOWNTO rcmu_l_DP_CMUPLL_IDX_0) <= tmp_cmupll_l0_int;
cmuplldprioout_phy_1(rcmu_m_DP_CMUPLL_IDX_7 DOWNTO rcmu_m_DP_CMUPLL_IDX_0) <= tmp_cmupll_m1_int;
cmuplldprioout_phy_1(rcmu_l_DP_CMUPLL_IDX_7 DOWNTO rcmu_l_DP_CMUPLL_IDX_0) <= tmp_cmupll_l1_int;
cmuplldprioout_phy_2(rcmu_m_DP_CMUPLL_IDX_7 DOWNTO rcmu_m_DP_CMUPLL_IDX_0) <= tmp_cmupll_m2_int;
cmuplldprioout_phy_2(rcmu_l_DP_CMUPLL_IDX_7 DOWNTO rcmu_l_DP_CMUPLL_IDX_0) <= tmp_cmupll_l2_int;

cmuplldprioout_phy_0(rcmu_pdb_DP_CMUPLL_IDX) <= '1' WHEN (rcmu0_pdb_int = '0') ELSE '0';
cmuplldprioout_phy_1(rcmu_pdb_DP_CMUPLL_IDX) <= '1' WHEN (rcmu1_pdb_int = '0') ELSE '0';
cmuplldprioout_phy_2(rcmu_pdb_DP_CMUPLL_IDX) <= '1' WHEN (rcmu2_pdb_int = '0') ELSE '0';

cmuplldprioout_phy_0(rcmu_txpll_rst_DP_CMUPLL_IDX) <= '1' WHEN (rcmu0_txpll_rst_int = '1') ELSE '0';
cmuplldprioout_phy_1(rcmu_txpll_rst_DP_CMUPLL_IDX) <= '1' WHEN (rcmu1_txpll_rst_int = '1') ELSE '0';
cmuplldprioout_phy_2(rcmu_txpll_rst_DP_CMUPLL_IDX) <= '1' WHEN (rcmu2_txpll_rst_int = '1') ELSE '0';

-- ============= cmupll_ctrl_output_to_add  - make sure _int is used =============




-- PCS  - rx and tx mixed together within the 16-bit register

-- PCS input -----------------------------------------------------------------------------

-- PCS Trunking 
-- rx <= 4, tx<=3
-- trunking_mode_ext <= {1'b0, rphfifo_master_sel_tx, rphfifo_master_sel_rx, 
-- 8000h same for all ch       rendec_data_sel_tx, rendec_data_sel_rx, rnenbpin, rpllurst, 
--                             rreset, rrsvd_cmu, rdeskewen, rindv_tx, rindv_rx};
-- every channel within the quad is the same in trunking.

rphfifo_master_sel_rx    <= rxdprioin_phy_ch0(rphfifo_master_sel_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch0(rphfifo_master_sel_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch0(rphfifo_master_sel_rx_DP_RX_IDX) = '1') ELSE
                            rxdprioin_phy_ch1(rphfifo_master_sel_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch1(rphfifo_master_sel_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch1(rphfifo_master_sel_rx_DP_RX_IDX) = '1') ELSE
                            rxdprioin_phy_ch2(rphfifo_master_sel_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch2(rphfifo_master_sel_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch2(rphfifo_master_sel_rx_DP_RX_IDX) = '1') ELSE
                            rxdprioin_phy_ch3(rphfifo_master_sel_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch3(rphfifo_master_sel_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch3(rphfifo_master_sel_rx_DP_RX_IDX) = '1') ELSE
                            '1';
rendec_data_sel_rx       <= rxdprioin_phy_ch0(rendec_data_sel_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch0(rendec_data_sel_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch0(rendec_data_sel_rx_DP_RX_IDX) = '1') ELSE
                            rxdprioin_phy_ch1(rendec_data_sel_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch1(rendec_data_sel_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch1(rendec_data_sel_rx_DP_RX_IDX) = '1') ELSE
                            rxdprioin_phy_ch2(rendec_data_sel_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch2(rendec_data_sel_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch2(rendec_data_sel_rx_DP_RX_IDX) = '1') ELSE
                            rxdprioin_phy_ch3(rendec_data_sel_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch3(rendec_data_sel_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch3(rendec_data_sel_rx_DP_RX_IDX) = '1') ELSE
                            '1'; -- 0 <= XAUI
                            
rindv_rx                 <= rxdprioin_phy_ch0(rindv_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch0(rindv_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch0(rindv_rx_DP_RX_IDX) = '1') ELSE
                            rxdprioin_phy_ch1(rindv_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch1(rindv_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch1(rindv_rx_DP_RX_IDX) = '1') ELSE
                            rxdprioin_phy_ch2(rindv_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch2(rindv_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch2(rindv_rx_DP_RX_IDX) = '1') ELSE
                            rxdprioin_phy_ch3(rindv_rx_DP_RX_IDX) WHEN (rxdprioin_phy_ch3(rindv_rx_DP_RX_IDX) = '0' OR rxdprioin_phy_ch3(rindv_rx_DP_RX_IDX) = '1') ELSE
                            '1';
--tx
rphfifo_master_sel_tx    <= txdprioin_phy_ch0(rphfifo_master_sel_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch0(rphfifo_master_sel_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch0(rphfifo_master_sel_tx_DP_TX_IDX) = '1') ELSE
                            txdprioin_phy_ch1(rphfifo_master_sel_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch1(rphfifo_master_sel_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch1(rphfifo_master_sel_tx_DP_TX_IDX) = '1') ELSE
                            txdprioin_phy_ch2(rphfifo_master_sel_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch2(rphfifo_master_sel_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch2(rphfifo_master_sel_tx_DP_TX_IDX) = '1') ELSE
                            txdprioin_phy_ch3(rphfifo_master_sel_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch3(rphfifo_master_sel_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch3(rphfifo_master_sel_tx_DP_TX_IDX) = '1') ELSE
                            '1';
                            
rendec_data_sel_tx       <= txdprioin_phy_ch0(rendec_data_sel_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch0(rendec_data_sel_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch0(rendec_data_sel_tx_DP_TX_IDX) = '1') ELSE
                            txdprioin_phy_ch1(rendec_data_sel_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch1(rendec_data_sel_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch1(rendec_data_sel_tx_DP_TX_IDX) = '1') ELSE
                            txdprioin_phy_ch2(rendec_data_sel_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch2(rendec_data_sel_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch2(rendec_data_sel_tx_DP_TX_IDX) = '1') ELSE
                            txdprioin_phy_ch3(rendec_data_sel_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch3(rendec_data_sel_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch3(rendec_data_sel_tx_DP_TX_IDX) = '1') ELSE
                            '1'; -- 0 <= XAUI
                            
rindv_tx                 <= txdprioin_phy_ch0(rindv_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch0(rindv_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch0(rindv_tx_DP_TX_IDX) = '1') ELSE
                            txdprioin_phy_ch0(rindv_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch1(rindv_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch1(rindv_tx_DP_TX_IDX) = '1') ELSE
                            txdprioin_phy_ch0(rindv_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch2(rindv_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch2(rindv_tx_DP_TX_IDX) = '1') ELSE
                            txdprioin_phy_ch0(rindv_tx_DP_TX_IDX) WHEN (txdprioin_phy_ch3(rindv_tx_DP_TX_IDX) = '0' OR txdprioin_phy_ch3(rindv_tx_DP_TX_IDX) = '1') ELSE
                            '1';



-- PCS_CTRL1 - mix of RX and TX
-- page divided into both rx and tx
-- pcs_ctrl1_ch0_ext <= {rtx_pipe_enable(0), rrx_pipe_enable(0), rpowdnr(0), rpowdnt(0),
-- 8001-8004            rendec_tx(0), rendec_rx(0), r8b10b_enc_ibm_en(0), rmatchen(0),
--                      r8b10b_dec_ibm_en_ch0, rforce_kchar(0), rforce_echar(0),
--                      rlp20ben(0), rgenericfifo(0), rcascaded_8b10b_en_tx(0),
--                      rcascaded_8b10b_en_rx(0)};
rtx_pipe_enable(0)       <= txdprioin_phy_ch0(rtx_pipe_enable_DP_TX_IDX);
rrx_pipe_enable(0)       <= rxdprioin_phy_ch0(rrx_pipe_enable_DP_RX_IDX);
rpowdnt(0)               <= txdprioin_phy_ch0(rpowdnt_DP_TX_IDX);
rpowdnr(0)               <= rxdprioin_phy_ch0(rpowdnr_DP_RX_IDX);
rendec_tx(0)             <= txdprioin_phy_ch0(rendec_tx_DP_TX_IDX);
rendec_rx(0)             <= rxdprioin_phy_ch0(rendec_rx_DP_RX_IDX);
r8b10b_enc_ibm_en(0)     <= txdprioin_phy_ch0(r8b10b_enc_ibm_en_DP_TX_IDX);
rmatchen(0)              <= rxdprioin_phy_ch0(rmatchen_DP_RX_IDX);
r8b10b_dec_ibm_en_ch0    <= rxdprioin_phy_ch0(r8b10b_dec_ibm_en_DP_RX_IDX_1  DOWNTO  r8b10b_dec_ibm_en_DP_RX_IDX_0);
rforce_kchar(0)          <= txdprioin_phy_ch0(rforce_kchar_DP_TX_IDX);
rforce_echar(0)          <= txdprioin_phy_ch0(rforce_echar_DP_TX_IDX);
rlp20ben(0)              <= rxdprioin_phy_ch0(rlp20ben_DP_RX_IDX);
rgenericfifo(0)          <= rxdprioin_phy_ch0(rgenericfifo_DP_RX_IDX);
rcascaded_8b10b_en_tx(0) <= txdprioin_phy_ch0(rcascaded_8b10b_en_tx_DP_TX_IDX);
rcascaded_8b10b_en_rx(0) <= rxdprioin_phy_ch0(rcascaded_8b10b_en_rx_DP_RX_IDX);

rtx_pipe_enable(1)       <= txdprioin_phy_ch1(rtx_pipe_enable_DP_TX_IDX);
rrx_pipe_enable(1)       <= rxdprioin_phy_ch1(rrx_pipe_enable_DP_RX_IDX);
rpowdnt(1)               <= txdprioin_phy_ch1(rpowdnt_DP_TX_IDX);
rpowdnr(1)               <= rxdprioin_phy_ch1(rpowdnr_DP_RX_IDX);
rendec_tx(1)             <= txdprioin_phy_ch1(rendec_tx_DP_TX_IDX);
rendec_rx(1)             <= rxdprioin_phy_ch1(rendec_rx_DP_RX_IDX);
r8b10b_enc_ibm_en(1)     <= txdprioin_phy_ch1(r8b10b_enc_ibm_en_DP_TX_IDX);
rmatchen(1)              <= rxdprioin_phy_ch1(rmatchen_DP_RX_IDX);
r8b10b_dec_ibm_en_ch1    <= rxdprioin_phy_ch1(r8b10b_dec_ibm_en_DP_RX_IDX_1  DOWNTO  r8b10b_dec_ibm_en_DP_RX_IDX_0);
rforce_kchar(1)          <= txdprioin_phy_ch1(rforce_kchar_DP_TX_IDX);
rforce_echar(1)          <= txdprioin_phy_ch1(rforce_echar_DP_TX_IDX);
rlp20ben(1)              <= rxdprioin_phy_ch1(rlp20ben_DP_RX_IDX);
rgenericfifo(1)          <= rxdprioin_phy_ch1(rgenericfifo_DP_RX_IDX);
rcascaded_8b10b_en_tx(1) <= txdprioin_phy_ch1(rcascaded_8b10b_en_tx_DP_TX_IDX);
rcascaded_8b10b_en_rx(1) <= rxdprioin_phy_ch1(rcascaded_8b10b_en_rx_DP_RX_IDX);

rtx_pipe_enable(2)       <= txdprioin_phy_ch2(rtx_pipe_enable_DP_TX_IDX);
rrx_pipe_enable(2)       <= rxdprioin_phy_ch2(rrx_pipe_enable_DP_RX_IDX);
rpowdnt(2)               <= txdprioin_phy_ch2(rpowdnt_DP_TX_IDX);
rpowdnr(2)               <= rxdprioin_phy_ch2(rpowdnr_DP_RX_IDX);
rendec_tx(2)             <= txdprioin_phy_ch2(rendec_tx_DP_TX_IDX);
rendec_rx(2)             <= rxdprioin_phy_ch2(rendec_rx_DP_RX_IDX);
r8b10b_enc_ibm_en(2)     <= txdprioin_phy_ch2(r8b10b_enc_ibm_en_DP_TX_IDX);
rmatchen(2)              <= rxdprioin_phy_ch2(rmatchen_DP_RX_IDX);
r8b10b_dec_ibm_en_ch2    <= rxdprioin_phy_ch2(r8b10b_dec_ibm_en_DP_RX_IDX_1  DOWNTO  r8b10b_dec_ibm_en_DP_RX_IDX_0);
rforce_kchar(2)          <= txdprioin_phy_ch2(rforce_kchar_DP_TX_IDX);
rforce_echar(2)          <= txdprioin_phy_ch2(rforce_echar_DP_TX_IDX);
rlp20ben(2)              <= rxdprioin_phy_ch2(rlp20ben_DP_RX_IDX);
rgenericfifo(2)          <= rxdprioin_phy_ch2(rgenericfifo_DP_RX_IDX);
rcascaded_8b10b_en_tx(2) <= txdprioin_phy_ch2(rcascaded_8b10b_en_tx_DP_TX_IDX);
rcascaded_8b10b_en_rx(2) <= rxdprioin_phy_ch2(rcascaded_8b10b_en_rx_DP_RX_IDX);

rtx_pipe_enable(3)       <= txdprioin_phy_ch3(rtx_pipe_enable_DP_TX_IDX);
rrx_pipe_enable(3)       <= rxdprioin_phy_ch3(rrx_pipe_enable_DP_RX_IDX);
rpowdnt(3)               <= txdprioin_phy_ch3(rpowdnt_DP_TX_IDX);
rpowdnr(3)               <= rxdprioin_phy_ch3(rpowdnr_DP_RX_IDX);
rendec_tx(3)             <= txdprioin_phy_ch3(rendec_tx_DP_TX_IDX);
rendec_rx(3)             <= rxdprioin_phy_ch3(rendec_rx_DP_RX_IDX);
r8b10b_enc_ibm_en(3)     <= txdprioin_phy_ch3(r8b10b_enc_ibm_en_DP_TX_IDX);
rmatchen(3)              <= rxdprioin_phy_ch3(rmatchen_DP_RX_IDX);
r8b10b_dec_ibm_en_ch3    <= rxdprioin_phy_ch3(r8b10b_dec_ibm_en_DP_RX_IDX_1  DOWNTO  r8b10b_dec_ibm_en_DP_RX_IDX_0);
rforce_kchar(3)          <= txdprioin_phy_ch3(rforce_kchar_DP_TX_IDX);
rforce_echar(3)          <= txdprioin_phy_ch3(rforce_echar_DP_TX_IDX);
rlp20ben(3)              <= rxdprioin_phy_ch3(rlp20ben_DP_RX_IDX);
rgenericfifo(3)          <= rxdprioin_phy_ch3(rgenericfifo_DP_RX_IDX);
rcascaded_8b10b_en_tx(3) <= txdprioin_phy_ch3(rcascaded_8b10b_en_tx_DP_TX_IDX);
rcascaded_8b10b_en_rx(3) <= rxdprioin_phy_ch3(rcascaded_8b10b_en_rx_DP_RX_IDX);

-- PCS_CTRL2 - all RX
-- pcs_ctrl2_ch0_ext <= {resync_badcg_en_ch0, rencdt_rising(0), rdis_rx_disp(0),
-- 8005-8008                   rcomp_pat_porn(0), rcomp_size_ch0, rcomp_pat_ch0(39 DOWNTO 32)};
resync_badcg_en_ch0 <= "00"; 
rencdt_rising(0)    <= rxdprioin_phy_ch0(rencdt_rising_DP_RX_IDX); 
rdis_rx_disp(0)     <= rxdprioin_phy_ch0(rdis_rx_disp_DP_RX_IDX);
rcomp_pat_porn(0)   <= rxdprioin_phy_ch0(rcomp_pat_porn_DP_RX_IDX); 
rcomp_size_ch0      <= rxdprioin_phy_ch0(rcomp_size_DP_RX_IDX_2  DOWNTO  rcomp_size_DP_RX_IDX_0); 

resync_badcg_en_ch1 <= "00"; 
rencdt_rising(1)    <= rxdprioin_phy_ch1(rencdt_rising_DP_RX_IDX); 
rdis_rx_disp(1)     <= rxdprioin_phy_ch1(rdis_rx_disp_DP_RX_IDX);
rcomp_pat_porn(1)   <= rxdprioin_phy_ch1(rcomp_pat_porn_DP_RX_IDX); 
rcomp_size_ch1      <= rxdprioin_phy_ch1(rcomp_size_DP_RX_IDX_2  DOWNTO  rcomp_size_DP_RX_IDX_0); 

resync_badcg_en_ch2 <= "00"; 
rencdt_rising(2)    <= rxdprioin_phy_ch2(rencdt_rising_DP_RX_IDX); 
rdis_rx_disp(2)     <= rxdprioin_phy_ch2(rdis_rx_disp_DP_RX_IDX);
rcomp_pat_porn(2)   <= rxdprioin_phy_ch2(rcomp_pat_porn_DP_RX_IDX); 
rcomp_size_ch2      <= rxdprioin_phy_ch2(rcomp_size_DP_RX_IDX_2  DOWNTO  rcomp_size_DP_RX_IDX_0); 

resync_badcg_en_ch3 <= "00"; 
rencdt_rising(3)    <= rxdprioin_phy_ch3(rencdt_rising_DP_RX_IDX); 
rdis_rx_disp(3)     <= rxdprioin_phy_ch3(rdis_rx_disp_DP_RX_IDX);
rcomp_pat_porn(3)   <= rxdprioin_phy_ch3(rcomp_pat_porn_DP_RX_IDX); 
rcomp_size_ch3      <= rxdprioin_phy_ch3(rcomp_size_DP_RX_IDX_2  DOWNTO  rcomp_size_DP_RX_IDX_0); 

-- PCS_CTRL3 and 4 - all RX
-- page 2 (part) + 3 + 4 - all rx - 32
-- pcs_ctrl3_ch0_ext <= {rcomp_pat_ch0(31 DOWNTO 16)};
-- 8009-800c
-- pcs_ctrl4_ch0_ext <= {rcomp_pat_ch0(15 DOWNTO 0)};
-- 800d-8010
rcomp_pat_ch0 <= rxdprioin_phy_ch0(rcomp_pat_DP_RX_IDX_39  DOWNTO  rcomp_pat_DP_RX_IDX_0); 
rcomp_pat_ch1 <= rxdprioin_phy_ch1(rcomp_pat_DP_RX_IDX_39  DOWNTO  rcomp_pat_DP_RX_IDX_0); 
rcomp_pat_ch2 <= rxdprioin_phy_ch2(rcomp_pat_DP_RX_IDX_39  DOWNTO  rcomp_pat_DP_RX_IDX_0); 
rcomp_pat_ch3 <= rxdprioin_phy_ch3(rcomp_pat_DP_RX_IDX_39  DOWNTO  rcomp_pat_DP_RX_IDX_0); 

-- PCS_CTRL5 - mix of RX and TX
-- rx - 12
-- pcs_ctrl5_ch0_ext <= {rrxfifo_dis(0), rtxfifo_dis(0), rib_force_disp(0),
--8011-8014                  rrundisp_ch0, rtxfifo_lowlatency_en(0), rrlv_en(0), rautobtalg_dis(0),
--                           rsync_sm_dis(0), rib_inv_cd_ch0, rrxfifo_lowlatency_en(0)};
rrxfifo_dis(0)           <= rxdprioin_phy_ch0(rrxfifo_dis_DP_RX_IDX); 
rrundisp_ch0             <= rxdprioin_phy_ch0(rrundisp_DP_RX_IDX_5  DOWNTO  rrundisp_DP_RX_IDX_0); 
rrlv_en(0)               <= rxdprioin_phy_ch0(rrlv_en_DP_RX_IDX); 
rautobtalg_dis(0)        <= rxdprioin_phy_ch0(rautobtalg_dis_DP_RX_IDX);
rsync_sm_dis(0)          <= rxdprioin_phy_ch0(rsync_sm_dis_DP_RX_IDX); 
rib_inv_cd_ch0           <= rxdprioin_phy_ch0(rib_inv_cd_DP_RX_IDX_1  DOWNTO  rib_inv_cd_DP_RX_IDX_0); 
rrxfifo_lowlatency_en(0) <= rxdprioin_phy_ch0(rrxfifo_lowlatency_en_DP_RX_IDX);
-- tx
rtxfifo_dis(0)           <= txdprioin_phy_ch0(rtxfifo_dis_DP_TX_IDX); 
rib_force_disp(0)        <= txdprioin_phy_ch0(rib_force_disp_DP_TX_IDX);                 
rtxfifo_lowlatency_en(0) <= txdprioin_phy_ch0(rtxfifo_lowlatency_en_DP_TX_IDX); 

rrxfifo_dis(1)           <= rxdprioin_phy_ch1(rrxfifo_dis_DP_RX_IDX); 
rrundisp_ch1             <= rxdprioin_phy_ch1(rrundisp_DP_RX_IDX_5  DOWNTO  rrundisp_DP_RX_IDX_0); 
rrlv_en(1)               <= rxdprioin_phy_ch1(rrlv_en_DP_RX_IDX); 
rautobtalg_dis(1)        <= rxdprioin_phy_ch1(rautobtalg_dis_DP_RX_IDX);
rsync_sm_dis(1)          <= rxdprioin_phy_ch1(rsync_sm_dis_DP_RX_IDX); 
rib_inv_cd_ch1           <= rxdprioin_phy_ch1(rib_inv_cd_DP_RX_IDX_1  DOWNTO  rib_inv_cd_DP_RX_IDX_0); 
rrxfifo_lowlatency_en(1) <= rxdprioin_phy_ch1(rrxfifo_lowlatency_en_DP_RX_IDX);
-- tx
rtxfifo_dis(1)           <= txdprioin_phy_ch1(rtxfifo_dis_DP_TX_IDX); 
rib_force_disp(1)        <= txdprioin_phy_ch1(rib_force_disp_DP_TX_IDX);                 
rtxfifo_lowlatency_en(1) <= txdprioin_phy_ch1(rtxfifo_lowlatency_en_DP_TX_IDX); 

rrxfifo_dis(2)           <= rxdprioin_phy_ch2(rrxfifo_dis_DP_RX_IDX); 
rrundisp_ch2             <= rxdprioin_phy_ch2(rrundisp_DP_RX_IDX_5  DOWNTO  rrundisp_DP_RX_IDX_0); 
rrlv_en(2)               <= rxdprioin_phy_ch2(rrlv_en_DP_RX_IDX); 
rautobtalg_dis(2)        <= rxdprioin_phy_ch2(rautobtalg_dis_DP_RX_IDX);
rsync_sm_dis(2)          <= rxdprioin_phy_ch2(rsync_sm_dis_DP_RX_IDX); 
rib_inv_cd_ch2           <= rxdprioin_phy_ch2(rib_inv_cd_DP_RX_IDX_1  DOWNTO  rib_inv_cd_DP_RX_IDX_0); 
rrxfifo_lowlatency_en(2) <= rxdprioin_phy_ch2(rrxfifo_lowlatency_en_DP_RX_IDX);
-- tx
rtxfifo_dis(2)           <= txdprioin_phy_ch2(rtxfifo_dis_DP_TX_IDX); 
rib_force_disp(2)        <= txdprioin_phy_ch2(rib_force_disp_DP_TX_IDX);                 
rtxfifo_lowlatency_en(2) <= txdprioin_phy_ch2(rtxfifo_lowlatency_en_DP_TX_IDX); 

rrxfifo_dis(3)           <= rxdprioin_phy_ch3(rrxfifo_dis_DP_RX_IDX); 
rrundisp_ch3             <= rxdprioin_phy_ch3(rrundisp_DP_RX_IDX_5  DOWNTO  rrundisp_DP_RX_IDX_0); 
rrlv_en(3)               <= rxdprioin_phy_ch3(rrlv_en_DP_RX_IDX); 
rautobtalg_dis(3)        <= rxdprioin_phy_ch3(rautobtalg_dis_DP_RX_IDX);
rsync_sm_dis(3)          <= rxdprioin_phy_ch3(rsync_sm_dis_DP_RX_IDX); 
rib_inv_cd_ch3           <= rxdprioin_phy_ch3(rib_inv_cd_DP_RX_IDX_1  DOWNTO  rib_inv_cd_DP_RX_IDX_0); 
rrxfifo_lowlatency_en(3) <= rxdprioin_phy_ch3(rrxfifo_lowlatency_en_DP_RX_IDX);
-- tx
rtxfifo_dis(3)           <= txdprioin_phy_ch3(rtxfifo_dis_DP_TX_IDX); 
rib_force_disp(3)        <= txdprioin_phy_ch3(rib_force_disp_DP_TX_IDX);                 
rtxfifo_lowlatency_en(3) <= txdprioin_phy_ch3(rtxfifo_lowlatency_en_DP_TX_IDX); 

-- PCS_CTRL6 - mix of RX and TX
-- rx - 8
-- pcs_ctrl6_ch0_ext <= {rdwidth_tx(0), rdwidth_rx(0), rge_xaui_tx(0),
-- 8015 - 8018                 rrx_detect_bypass(0), rtxurstpcs(0), rrxurstpcs(0),
--                             rrsvd_tx_ch0, rskpsetbased(0), rtruebac2bac(0),rrsvd_rx_ch0};
--
rdwidth_tx(0)         <= txdprioin_phy_ch0(rdwidth_tx_DP_TX_IDX);
rdwidth_rx(0)         <= rxdprioin_phy_ch0(rdwidth_rx_DP_RX_IDX);
rge_xaui_tx(0)        <= txdprioin_phy_ch0(rge_xaui_tx_DP_TX_IDX);
rrx_detect_bypass(0)  <= rxdprioin_phy_ch0(rrx_detect_bypass_DP_RX_IDX);
rtxurstpcs(0)         <= txdprioin_phy_ch0(rtxurstpcs_DP_TX_IDX);
rrxurstpcs(0)         <= rxdprioin_phy_ch0(rrxurstpcs_DP_RX_IDX);
rrsvd_tx_ch0          <= txdprioin_phy_ch0(rrsvd_tx_DP_TX_IDX_4  DOWNTO  rrsvd_tx_DP_TX_IDX_0); 
rskpsetbased(0)       <= rxdprioin_phy_ch0(rskpsetbased_DP_RX_IDX);
rtruebac2bac(0)       <= rxdprioin_phy_ch0(rtruebac2bac_DP_RX_IDX);
rrsvd_rx_ch0          <= rxdprioin_phy_ch0(rrsvd_rx_DP_RX_IDX_2  DOWNTO  rrsvd_rx_DP_RX_IDX_0); 

rdwidth_tx(1)         <= txdprioin_phy_ch1(rdwidth_tx_DP_TX_IDX);
rdwidth_rx(1)         <= rxdprioin_phy_ch1(rdwidth_rx_DP_RX_IDX);
rge_xaui_tx(1)        <= txdprioin_phy_ch1(rge_xaui_tx_DP_TX_IDX);
rrx_detect_bypass(1)  <= rxdprioin_phy_ch1(rrx_detect_bypass_DP_RX_IDX);
rtxurstpcs(1)         <= txdprioin_phy_ch1(rtxurstpcs_DP_TX_IDX);
rrxurstpcs(1)         <= rxdprioin_phy_ch1(rrxurstpcs_DP_RX_IDX);
rrsvd_tx_ch1          <= txdprioin_phy_ch1(rrsvd_tx_DP_TX_IDX_4  DOWNTO  rrsvd_tx_DP_TX_IDX_0); 
rskpsetbased(1)       <= rxdprioin_phy_ch1(rskpsetbased_DP_RX_IDX);
rtruebac2bac(1)       <= rxdprioin_phy_ch1(rtruebac2bac_DP_RX_IDX);
rrsvd_rx_ch1          <= rxdprioin_phy_ch1(rrsvd_rx_DP_RX_IDX_2  DOWNTO  rrsvd_rx_DP_RX_IDX_0); 

rdwidth_tx(2)         <= txdprioin_phy_ch2(rdwidth_tx_DP_TX_IDX);
rdwidth_rx(2)         <= rxdprioin_phy_ch2(rdwidth_rx_DP_RX_IDX);
rge_xaui_tx(2)        <= txdprioin_phy_ch2(rge_xaui_tx_DP_TX_IDX);
rrx_detect_bypass(2)  <= rxdprioin_phy_ch2(rrx_detect_bypass_DP_RX_IDX);
rtxurstpcs(2)         <= txdprioin_phy_ch2(rtxurstpcs_DP_TX_IDX);
rrxurstpcs(2)         <= rxdprioin_phy_ch2(rrxurstpcs_DP_RX_IDX);
rrsvd_tx_ch2          <= txdprioin_phy_ch2(rrsvd_tx_DP_TX_IDX_4  DOWNTO  rrsvd_tx_DP_TX_IDX_0); 
rskpsetbased(2)       <= rxdprioin_phy_ch2(rskpsetbased_DP_RX_IDX);
rtruebac2bac(2)       <= rxdprioin_phy_ch2(rtruebac2bac_DP_RX_IDX);
rrsvd_rx_ch2          <= rxdprioin_phy_ch2(rrsvd_rx_DP_RX_IDX_2  DOWNTO  rrsvd_rx_DP_RX_IDX_0); 

rdwidth_tx(3)         <= txdprioin_phy_ch3(rdwidth_tx_DP_TX_IDX);
rdwidth_rx(3)         <= rxdprioin_phy_ch3(rdwidth_rx_DP_RX_IDX);
rge_xaui_tx(3)        <= txdprioin_phy_ch3(rge_xaui_tx_DP_TX_IDX);
rrx_detect_bypass(3)  <= rxdprioin_phy_ch3(rrx_detect_bypass_DP_RX_IDX);
rtxurstpcs(3)         <= txdprioin_phy_ch3(rtxurstpcs_DP_TX_IDX);
rrxurstpcs(3)         <= rxdprioin_phy_ch3(rrxurstpcs_DP_RX_IDX);
rrsvd_tx_ch3          <= txdprioin_phy_ch3(rrsvd_tx_DP_TX_IDX_4  DOWNTO  rrsvd_tx_DP_TX_IDX_0); 
rskpsetbased(3)       <= rxdprioin_phy_ch3(rskpsetbased_DP_RX_IDX);
rtruebac2bac(3)       <= rxdprioin_phy_ch3(rtruebac2bac_DP_RX_IDX);
rrsvd_rx_ch3          <= rxdprioin_phy_ch3(rrsvd_rx_DP_RX_IDX_2  DOWNTO  rrsvd_rx_DP_RX_IDX_0); 

-- PCS_CTRL7
-- all rx   - 16                          
--  pcs_ctrl7_ch0_ext <= {rgnumber_ch0, rknumber_ch0};
rgnumber_ch0          <= rxdprioin_phy_ch0(rgnumber_DP_RX_IDX_7  DOWNTO  rgnumber_DP_RX_IDX_0); 
rknumber_ch0          <= rxdprioin_phy_ch0(rknumber_DP_RX_IDX_7  DOWNTO  rknumber_DP_RX_IDX_0); 
rgnumber_ch1          <= rxdprioin_phy_ch1(rgnumber_DP_RX_IDX_7  DOWNTO  rgnumber_DP_RX_IDX_0); 
rknumber_ch1          <= rxdprioin_phy_ch1(rknumber_DP_RX_IDX_7  DOWNTO  rknumber_DP_RX_IDX_0); 
rgnumber_ch2          <= rxdprioin_phy_ch2(rgnumber_DP_RX_IDX_7  DOWNTO  rgnumber_DP_RX_IDX_0); 
rknumber_ch2          <= rxdprioin_phy_ch2(rknumber_DP_RX_IDX_7  DOWNTO  rknumber_DP_RX_IDX_0); 
rgnumber_ch3          <= rxdprioin_phy_ch3(rgnumber_DP_RX_IDX_7  DOWNTO  rgnumber_DP_RX_IDX_0); 
rknumber_ch3          <= rxdprioin_phy_ch3(rknumber_DP_RX_IDX_7  DOWNTO  rknumber_DP_RX_IDX_0); 


-- PCS_CTRL8
rfreerun_rx(0)        <= rxdprioin_phy_ch0(rfreerun_rx_DP_RX_IDX);  -- 4'h0;  for POF
rrx_rd_clk_sel(0)     <= rxdprioin_phy_ch0(rrx_rd_clk_sel_DP_RX_IDX);
renumber_ch0          <= rxdprioin_phy_ch0(renumber_DP_RX_IDX_2  DOWNTO  renumber_DP_RX_IDX_0); 
renpolinv_rx(0)       <= rxdprioin_phy_ch0(renpolinv_rx_DP_RX_IDX); 
rclkcmpinsertpad(0)   <= rxdprioin_phy_ch0(rclkcmpinsertpad_DP_RX_IDX);
-- tx
rfreerun_tx(0)        <= txdprioin_phy_ch0(rfreerun_tx_DP_TX_IDX);  -- 4'h0;  for POF
rtxwrclksel(0)        <= txdprioin_phy_ch0(rtxwrclksel_DP_TX_IDX);
rtxrdclksel(0)        <= txdprioin_phy_ch0(rtxrdclksel_DP_TX_IDX); 
rclk_1_sel_ch0     <= rxdprioin_phy_ch0(rclk_1_sel_DP_RX_IDX_1     DOWNTO  rclk_1_sel_DP_RX_IDX_0);       -- dprio_enabled DOWNTO  bits 9-8 
rclk_2_sel_ch0     <= rxdprioin_phy_ch0(rclk_2_sel_DP_RX_IDX_1     DOWNTO  rclk_2_sel_DP_RX_IDX_0);       -- dprio_enabled DOWNTO  bits 7-6
rrcvd_clk_sel_ch0  <= rxdprioin_phy_ch0(rrcvd_clk_sel_DP_RX_IDX_1  DOWNTO  rrcvd_clk_sel_DP_RX_IDX_0);    -- dprio_enabled DOWNTO  bits 11-10 

rfreerun_rx(1)        <= rxdprioin_phy_ch1(rfreerun_rx_DP_RX_IDX);  -- 4'h0;  for POF
rrx_rd_clk_sel(1)     <= rxdprioin_phy_ch1(rrx_rd_clk_sel_DP_RX_IDX);
renumber_ch1          <= rxdprioin_phy_ch1(renumber_DP_RX_IDX_2  DOWNTO  renumber_DP_RX_IDX_0); 
renpolinv_rx(1)       <= rxdprioin_phy_ch1(renpolinv_rx_DP_RX_IDX); 
rclkcmpinsertpad(1)   <= rxdprioin_phy_ch1(rclkcmpinsertpad_DP_RX_IDX);
-- tx
rfreerun_tx(1)        <= txdprioin_phy_ch1(rfreerun_tx_DP_TX_IDX);  -- 4'h0;  for POF
rtxwrclksel(1)        <= txdprioin_phy_ch1(rtxwrclksel_DP_TX_IDX);
rtxrdclksel(1)        <= txdprioin_phy_ch1(rtxrdclksel_DP_TX_IDX); 
rclk_1_sel_ch1     <= rxdprioin_phy_ch1(rclk_1_sel_DP_RX_IDX_1     DOWNTO  rclk_1_sel_DP_RX_IDX_0);       -- dprio_enabled DOWNTO  bits 9-8 
rclk_2_sel_ch1     <= rxdprioin_phy_ch1(rclk_2_sel_DP_RX_IDX_1     DOWNTO  rclk_2_sel_DP_RX_IDX_0);       -- dprio_enabled DOWNTO  bits 7-6
rrcvd_clk_sel_ch1  <= rxdprioin_phy_ch1(rrcvd_clk_sel_DP_RX_IDX_1  DOWNTO  rrcvd_clk_sel_DP_RX_IDX_0);    -- dprio_enabled DOWNTO  bits 11-10 

rfreerun_rx(2)        <= rxdprioin_phy_ch2(rfreerun_rx_DP_RX_IDX);  -- 4'h0;  for POF
rrx_rd_clk_sel(2)     <= rxdprioin_phy_ch2(rrx_rd_clk_sel_DP_RX_IDX);
renumber_ch2          <= rxdprioin_phy_ch2(renumber_DP_RX_IDX_2  DOWNTO  renumber_DP_RX_IDX_0); 
renpolinv_rx(2)       <= rxdprioin_phy_ch2(renpolinv_rx_DP_RX_IDX); 
rclkcmpinsertpad(2)   <= rxdprioin_phy_ch2(rclkcmpinsertpad_DP_RX_IDX);
-- tx
rfreerun_tx(2)        <= txdprioin_phy_ch2(rfreerun_tx_DP_TX_IDX);  -- 4'h0;  for POF
rtxwrclksel(2)        <= txdprioin_phy_ch2(rtxwrclksel_DP_TX_IDX);
rtxrdclksel(2)        <= txdprioin_phy_ch2(rtxrdclksel_DP_TX_IDX); 
rclk_1_sel_ch2     <= rxdprioin_phy_ch2(rclk_1_sel_DP_RX_IDX_1     DOWNTO  rclk_1_sel_DP_RX_IDX_0);       -- dprio_enabled DOWNTO  bits 9-8 
rclk_2_sel_ch2     <= rxdprioin_phy_ch2(rclk_2_sel_DP_RX_IDX_1     DOWNTO  rclk_2_sel_DP_RX_IDX_0);       -- dprio_enabled DOWNTO  bits 7-6
rrcvd_clk_sel_ch2  <= rxdprioin_phy_ch2(rrcvd_clk_sel_DP_RX_IDX_1  DOWNTO  rrcvd_clk_sel_DP_RX_IDX_0);    -- dprio_enabled DOWNTO  bits 11-10 

rfreerun_rx(3)        <= rxdprioin_phy_ch3(rfreerun_rx_DP_RX_IDX);  -- 4'h0;  for POF
rrx_rd_clk_sel(3)     <= rxdprioin_phy_ch3(rrx_rd_clk_sel_DP_RX_IDX);
renumber_ch3          <= rxdprioin_phy_ch3(renumber_DP_RX_IDX_2  DOWNTO  renumber_DP_RX_IDX_0); 
renpolinv_rx(3)       <= rxdprioin_phy_ch3(renpolinv_rx_DP_RX_IDX); 
rclkcmpinsertpad(3)   <= rxdprioin_phy_ch3(rclkcmpinsertpad_DP_RX_IDX);
-- tx
rfreerun_tx(3)        <= txdprioin_phy_ch3(rfreerun_tx_DP_TX_IDX);  -- 4'h0;  for POF
rtxwrclksel(3)        <= txdprioin_phy_ch3(rtxwrclksel_DP_TX_IDX);
rtxrdclksel(3)        <= txdprioin_phy_ch3(rtxrdclksel_DP_TX_IDX); 
rclk_1_sel_ch3     <= rxdprioin_phy_ch3(rclk_1_sel_DP_RX_IDX_1     DOWNTO  rclk_1_sel_DP_RX_IDX_0);       -- dprio_enabled DOWNTO  bits 9-8 
rclk_2_sel_ch3     <= rxdprioin_phy_ch3(rclk_2_sel_DP_RX_IDX_1     DOWNTO  rclk_2_sel_DP_RX_IDX_0);       -- dprio_enabled DOWNTO  bits 7-6
rrcvd_clk_sel_ch3  <= rxdprioin_phy_ch3(rrcvd_clk_sel_DP_RX_IDX_1  DOWNTO  rrcvd_clk_sel_DP_RX_IDX_0);    -- dprio_enabled DOWNTO  bits 11-10 

-- PCS_CTRL_9
-- pcs_ctrl9_ch0_ext <= {rppm_cnt_reset(0), rphfifourstrx(0), rcmpfifourst(0), 
-- 8025 - 8028                 rtx_idle_delay_ch0, rclkcmpsqmd(0), rclkcmpsq1p_ch0(9 DOWNTO 0)};
rppm_cnt_reset(0)       <= rxdprioin_phy_ch0(rppm_cnt_reset_DP_RX_IDX);
rphfifourstrx(0)        <= rxdprioin_phy_ch0(rphfifourstrx_DP_RX_IDX);
rcmpfifourst(0)         <= rxdprioin_phy_ch0(rcmpfifourst_DP_RX_IDX);
rtx_idle_delay_ch0      <= rxdprioin_phy_ch0(rtx_idle_delay_DP_RX_IDX_1  DOWNTO  rtx_idle_delay_DP_RX_IDX_0);
rclkcmpsqmd(0)          <= rxdprioin_phy_ch0(rclkcmpsqmd_DP_RX_IDX);
rclkcmpsq1p_ch0(19 DOWNTO 0)   <= rxdprioin_phy_ch0(rclkcmpsq1p_DP_RX_IDX_19    DOWNTO  rclkcmpsq1p_DP_RX_IDX_0);

rppm_cnt_reset(1)       <= rxdprioin_phy_ch1(rppm_cnt_reset_DP_RX_IDX);
rphfifourstrx(1)        <= rxdprioin_phy_ch1(rphfifourstrx_DP_RX_IDX);
rcmpfifourst(1)         <= rxdprioin_phy_ch1(rcmpfifourst_DP_RX_IDX);
rtx_idle_delay_ch1      <= rxdprioin_phy_ch1(rtx_idle_delay_DP_RX_IDX_1  DOWNTO  rtx_idle_delay_DP_RX_IDX_0);
rclkcmpsqmd(1)          <= rxdprioin_phy_ch1(rclkcmpsqmd_DP_RX_IDX);
rclkcmpsq1p_ch1(19 DOWNTO 0)   <= rxdprioin_phy_ch1(rclkcmpsq1p_DP_RX_IDX_19    DOWNTO  rclkcmpsq1p_DP_RX_IDX_0);

rppm_cnt_reset(2)       <= rxdprioin_phy_ch2(rppm_cnt_reset_DP_RX_IDX);
rphfifourstrx(2)        <= rxdprioin_phy_ch2(rphfifourstrx_DP_RX_IDX);
rcmpfifourst(2)         <= rxdprioin_phy_ch2(rcmpfifourst_DP_RX_IDX);
rtx_idle_delay_ch2      <= rxdprioin_phy_ch2(rtx_idle_delay_DP_RX_IDX_1  DOWNTO  rtx_idle_delay_DP_RX_IDX_0);
rclkcmpsqmd(2)          <= rxdprioin_phy_ch2(rclkcmpsqmd_DP_RX_IDX);
rclkcmpsq1p_ch2(19 DOWNTO 0)   <= rxdprioin_phy_ch2(rclkcmpsq1p_DP_RX_IDX_19    DOWNTO  rclkcmpsq1p_DP_RX_IDX_0);

rppm_cnt_reset(3)       <= rxdprioin_phy_ch3(rppm_cnt_reset_DP_RX_IDX);
rphfifourstrx(3)        <= rxdprioin_phy_ch3(rphfifourstrx_DP_RX_IDX);
rcmpfifourst(3)         <= rxdprioin_phy_ch3(rcmpfifourst_DP_RX_IDX);
rtx_idle_delay_ch3      <= rxdprioin_phy_ch3(rtx_idle_delay_DP_RX_IDX_1  DOWNTO  rtx_idle_delay_DP_RX_IDX_0);
rclkcmpsqmd(3)          <= rxdprioin_phy_ch3(rclkcmpsqmd_DP_RX_IDX);
rclkcmpsq1p_ch3(19 DOWNTO 0)   <= rxdprioin_phy_ch3(rclkcmpsq1p_DP_RX_IDX_19  DOWNTO  rclkcmpsq1p_DP_RX_IDX_0);

-- PCS_CTRL_10, 11
-- all rx - pages 10 and 11 - 21
-- 8029 - 802C
-- pcs_ctrl10_ch0_ext <= {rclkcmpsq1n_ch0(19 DOWNTO 15), rclkcmppos(0), rclkcmpsq1p_ch0(19 DOWNTO 10)};
-- 802D - 8030
-- pcs_ctrl11_ch0_ext <= {rclkcmpsq1n_ch0(14 DOWNTO 10), 1'b0, rclkcmpsq1n_ch0(9 DOWNTO 0)};
rclkcmpsq1n_ch0      <= rxdprioin_phy_ch0(rclkcmpsq1n_DP_RX_IDX_19  DOWNTO  rclkcmpsq1n_DP_RX_IDX_0);
rclkcmppos(0)        <= rxdprioin_phy_ch0(rclkcmppos_DP_RX_IDX);

rclkcmpsq1n_ch1      <= rxdprioin_phy_ch1(rclkcmpsq1n_DP_RX_IDX_19  DOWNTO  rclkcmpsq1n_DP_RX_IDX_0);
rclkcmppos(1)        <= rxdprioin_phy_ch1(rclkcmppos_DP_RX_IDX);

rclkcmpsq1n_ch2      <= rxdprioin_phy_ch2(rclkcmpsq1n_DP_RX_IDX_19  DOWNTO  rclkcmpsq1n_DP_RX_IDX_0);
rclkcmppos(1)        <= rxdprioin_phy_ch2(rclkcmppos_DP_RX_IDX);

rclkcmpsq1n_ch3      <= rxdprioin_phy_ch3(rclkcmpsq1n_DP_RX_IDX_19  DOWNTO  rclkcmpsq1n_DP_RX_IDX_0);
rclkcmppos(3)        <= rxdprioin_phy_ch3(rclkcmppos_DP_RX_IDX);

-- PCS_CTRL_12 - rx and tx mixed
-- page 12 - rx DOWNTO  12
-- pcs_ctrl12_ch0_ext <= {rrev_loopbk(0), ralempty_ch0, ralfull_ch0, rforce_disp(0), 
--                              rkchar(0), rosbased(0), rensymswap_tx(0), 1'b0, rosnumber_ch0};
ralempty_ch0         <= rxdprioin_phy_ch0(ralempty_DP_RX_IDX_3  DOWNTO  ralempty_DP_RX_IDX_0);
ralfull_ch0          <= rxdprioin_phy_ch0(ralfull_DP_RX_IDX_3  DOWNTO  ralfull_DP_RX_IDX_0);
rkchar(0)            <= rxdprioin_phy_ch0(rkchar_DP_RX_IDX);
rosbased(0)          <= rxdprioin_phy_ch0(rosbased_DP_RX_IDX);
rosnumber_ch0        <= rxdprioin_phy_ch0(rosnumber_DP_RX_IDX_1  DOWNTO  rosnumber_DP_RX_IDX_0);
--tx
rrev_loopbk(0)       <= txdprioin_phy_ch0(rrev_loopbk_DP_TX_IDX);
rforce_disp(0)       <= txdprioin_phy_ch0(rforce_disp_DP_TX_IDX);
rensymswap_tx(0)     <= txdprioin_phy_ch0(rensymswap_tx_DP_TX_IDX);

ralempty_ch1         <= rxdprioin_phy_ch1(ralempty_DP_RX_IDX_3  DOWNTO  ralempty_DP_RX_IDX_0);
ralfull_ch1          <= rxdprioin_phy_ch1(ralfull_DP_RX_IDX_3  DOWNTO  ralfull_DP_RX_IDX_0);
rkchar(1)            <= rxdprioin_phy_ch1(rkchar_DP_RX_IDX);
rosbased(1)          <= rxdprioin_phy_ch1(rosbased_DP_RX_IDX);
rosnumber_ch1        <= rxdprioin_phy_ch1(rosnumber_DP_RX_IDX_1  DOWNTO  rosnumber_DP_RX_IDX_0);
--tx
rrev_loopbk(1)       <= txdprioin_phy_ch1(rrev_loopbk_DP_TX_IDX);
rforce_disp(1)       <= txdprioin_phy_ch1(rforce_disp_DP_TX_IDX);
rensymswap_tx(1)     <= txdprioin_phy_ch1(rensymswap_tx_DP_TX_IDX);

ralempty_ch2         <= rxdprioin_phy_ch2(ralempty_DP_RX_IDX_3  DOWNTO  ralempty_DP_RX_IDX_0);
ralfull_ch2          <= rxdprioin_phy_ch2(ralfull_DP_RX_IDX_3  DOWNTO  ralfull_DP_RX_IDX_0);
rkchar(2)            <= rxdprioin_phy_ch2(rkchar_DP_RX_IDX);
rosbased(2)          <= rxdprioin_phy_ch2(rosbased_DP_RX_IDX);
rosnumber_ch2        <= rxdprioin_phy_ch2(rosnumber_DP_RX_IDX_1  DOWNTO  rosnumber_DP_RX_IDX_0);
--tx
rrev_loopbk(2)       <= txdprioin_phy_ch2(rrev_loopbk_DP_TX_IDX);
rforce_disp(2)       <= txdprioin_phy_ch2(rforce_disp_DP_TX_IDX);
rensymswap_tx(2)     <= txdprioin_phy_ch2(rensymswap_tx_DP_TX_IDX);

ralempty_ch3         <= rxdprioin_phy_ch3(ralempty_DP_RX_IDX_3  DOWNTO  ralempty_DP_RX_IDX_0);
ralfull_ch3          <= rxdprioin_phy_ch3(ralfull_DP_RX_IDX_3  DOWNTO  ralfull_DP_RX_IDX_0);
rkchar(3)            <= rxdprioin_phy_ch3(rkchar_DP_RX_IDX);
rosbased(3)          <= rxdprioin_phy_ch3(rosbased_DP_RX_IDX);
rosnumber_ch3        <= rxdprioin_phy_ch3(rosnumber_DP_RX_IDX_1  DOWNTO  rosnumber_DP_RX_IDX_0);
--tx
rrev_loopbk(3)       <= txdprioin_phy_ch3(rrev_loopbk_DP_TX_IDX);
rforce_disp(3)       <= txdprioin_phy_ch3(rforce_disp_DP_TX_IDX);
rensymswap_tx(3)     <= txdprioin_phy_ch3(rensymswap_tx_DP_TX_IDX);

-- PCS_CTRL_13
-- rx DOWNTO 12
-- pcs_ctrl13_ch0_ext <= {rwa_6g_en(0), renpolinv_tx(0), rbitslip_size_ch0, rbytord_2sym_en(0),
--                              rbysync_polinv_en(0), rbitloc_rev_en(0), rbyte_rev_en(0), renbitrev_tx(0),
--                              rbyteorden_ch0, rbytordplden(0), rphfifopldentx(0), rphfifoursttx(0),
--                              rphfifopldenrx(0), rautoinsdis(0)};
rwa_6g_en(0)         <= rxdprioin_phy_ch0(rwa_6g_en_DP_RX_IDX);
rbitslip_size_ch0    <= rxdprioin_phy_ch0(rbitslip_size_DP_RX_IDX_1  DOWNTO  rbitslip_size_DP_RX_IDX_0);
rbytord_2sym_en(0)   <= rxdprioin_phy_ch0(rbytord_2sym_en_DP_RX_IDX);
rbysync_polinv_en(0) <= rxdprioin_phy_ch0(rbysync_polinv_en_DP_RX_IDX);
rbitloc_rev_en(0)    <= rxdprioin_phy_ch0(rbitloc_rev_en_DP_RX_IDX);
rbyte_rev_en(0)      <= rxdprioin_phy_ch0(rbyte_rev_en_DP_RX_IDX);
rbyteorden_ch0       <= rxdprioin_phy_ch0(rbyteorden_DP_RX_IDX_1  DOWNTO  rbyteorden_DP_RX_IDX_0);
rbytordplden(0)      <= rxdprioin_phy_ch0(rbytordplden_DP_RX_IDX);
rphfifopldenrx(0)    <= rxdprioin_phy_ch0(rphfifopldenrx_DP_RX_IDX);
rautoinsdis(0)       <= rxdprioin_phy_ch0(rautoinsdis_DP_RX_IDX);
--tx
renpolinv_tx(0)      <= txdprioin_phy_ch0(renpolinv_tx_DP_TX_IDX);
renbitrev_tx(0)      <= txdprioin_phy_ch0(renbitrev_tx_DP_TX_IDX);
rphfifopldentx(0)    <= txdprioin_phy_ch0(rphfifopldentx_DP_TX_IDX);
rphfifoursttx(0)     <= txdprioin_phy_ch0(rphfifoursttx_DP_TX_IDX);

rwa_6g_en(1)         <= rxdprioin_phy_ch1(rwa_6g_en_DP_RX_IDX);
rbitslip_size_ch1    <= rxdprioin_phy_ch1(rbitslip_size_DP_RX_IDX_1  DOWNTO  rbitslip_size_DP_RX_IDX_0);
rbytord_2sym_en(1)   <= rxdprioin_phy_ch1(rbytord_2sym_en_DP_RX_IDX);
rbysync_polinv_en(1) <= rxdprioin_phy_ch1(rbysync_polinv_en_DP_RX_IDX);
rbitloc_rev_en(1)    <= rxdprioin_phy_ch1(rbitloc_rev_en_DP_RX_IDX);
rbyte_rev_en(1)      <= rxdprioin_phy_ch1(rbyte_rev_en_DP_RX_IDX);
rbyteorden_ch1       <= rxdprioin_phy_ch1(rbyteorden_DP_RX_IDX_1  DOWNTO  rbyteorden_DP_RX_IDX_0);
rbytordplden(1)      <= rxdprioin_phy_ch1(rbytordplden_DP_RX_IDX);
rphfifopldenrx(1)    <= rxdprioin_phy_ch1(rphfifopldenrx_DP_RX_IDX);
rautoinsdis(1)       <= rxdprioin_phy_ch1(rautoinsdis_DP_RX_IDX);
--tx
renpolinv_tx(1)      <= txdprioin_phy_ch1(renpolinv_tx_DP_TX_IDX);
renbitrev_tx(1)      <= txdprioin_phy_ch1(renbitrev_tx_DP_TX_IDX);
rphfifopldentx(1)    <= txdprioin_phy_ch1(rphfifopldentx_DP_TX_IDX);
rphfifoursttx(1)     <= txdprioin_phy_ch1(rphfifoursttx_DP_TX_IDX);

rwa_6g_en(2)         <= rxdprioin_phy_ch2(rwa_6g_en_DP_RX_IDX);
rbitslip_size_ch2    <= rxdprioin_phy_ch2(rbitslip_size_DP_RX_IDX_1  DOWNTO  rbitslip_size_DP_RX_IDX_0);
rbytord_2sym_en(2)   <= rxdprioin_phy_ch2(rbytord_2sym_en_DP_RX_IDX);
rbysync_polinv_en(2) <= rxdprioin_phy_ch2(rbysync_polinv_en_DP_RX_IDX);
rbitloc_rev_en(2)    <= rxdprioin_phy_ch2(rbitloc_rev_en_DP_RX_IDX);
rbyte_rev_en(2)      <= rxdprioin_phy_ch2(rbyte_rev_en_DP_RX_IDX);
rbyteorden_ch2       <= rxdprioin_phy_ch2(rbyteorden_DP_RX_IDX_1  DOWNTO  rbyteorden_DP_RX_IDX_0);
rbytordplden(2)      <= rxdprioin_phy_ch2(rbytordplden_DP_RX_IDX);
rphfifopldenrx(2)    <= rxdprioin_phy_ch2(rphfifopldenrx_DP_RX_IDX);
rautoinsdis(2)       <= rxdprioin_phy_ch2(rautoinsdis_DP_RX_IDX);
--tx
renpolinv_tx(2)      <= txdprioin_phy_ch2(renpolinv_tx_DP_TX_IDX);
renbitrev_tx(2)      <= txdprioin_phy_ch2(renbitrev_tx_DP_TX_IDX);
rphfifopldentx(2)    <= txdprioin_phy_ch2(rphfifopldentx_DP_TX_IDX);
rphfifoursttx(2)     <= txdprioin_phy_ch2(rphfifoursttx_DP_TX_IDX);

rwa_6g_en(3)         <= rxdprioin_phy_ch3(rwa_6g_en_DP_RX_IDX);
rbitslip_size_ch3    <= rxdprioin_phy_ch3(rbitslip_size_DP_RX_IDX_1  DOWNTO  rbitslip_size_DP_RX_IDX_0);
rbytord_2sym_en(3)   <= rxdprioin_phy_ch3(rbytord_2sym_en_DP_RX_IDX);
rbysync_polinv_en(3) <= rxdprioin_phy_ch3(rbysync_polinv_en_DP_RX_IDX);
rbitloc_rev_en(3)    <= rxdprioin_phy_ch3(rbitloc_rev_en_DP_RX_IDX);
rbyte_rev_en(3)      <= rxdprioin_phy_ch3(rbyte_rev_en_DP_RX_IDX);
rbyteorden_ch3       <= rxdprioin_phy_ch3(rbyteorden_DP_RX_IDX_1  DOWNTO  rbyteorden_DP_RX_IDX_0);
rbytordplden(3)      <= rxdprioin_phy_ch3(rbytordplden_DP_RX_IDX);
rphfifopldenrx(3)    <= rxdprioin_phy_ch3(rphfifopldenrx_DP_RX_IDX);
rautoinsdis(3)       <= rxdprioin_phy_ch3(rautoinsdis_DP_RX_IDX);
--tx
renpolinv_tx(3)      <= txdprioin_phy_ch3(renpolinv_tx_DP_TX_IDX);
renbitrev_tx(3)      <= txdprioin_phy_ch3(renbitrev_tx_DP_TX_IDX);
rphfifopldentx(3)    <= txdprioin_phy_ch3(rphfifopldentx_DP_TX_IDX);
rphfifoursttx(3)     <= txdprioin_phy_ch3(rphfifoursttx_DP_TX_IDX);

-- PCS_CTRL_14
-- all rx
-- pcs_ctrl14_ch0_ext <= {rppmsel_ch0, rbytordpat_ch0};
rppmsel_ch0          <= rxdprioin_phy_ch0(rppmsel_DP_RX_IDX_5  DOWNTO  rppmsel_DP_RX_IDX_0);
rbytordpat_ch0       <= rxdprioin_phy_ch0(rbytordpat_DP_RX_IDX_9  DOWNTO  rbytordpat_DP_RX_IDX_0);
rppmsel_ch1          <= rxdprioin_phy_ch1(rppmsel_DP_RX_IDX_5  DOWNTO  rppmsel_DP_RX_IDX_0);
rbytordpat_ch1       <= rxdprioin_phy_ch1(rbytordpat_DP_RX_IDX_9  DOWNTO  rbytordpat_DP_RX_IDX_0);
rppmsel_ch2          <= rxdprioin_phy_ch2(rppmsel_DP_RX_IDX_5  DOWNTO  rppmsel_DP_RX_IDX_0);
rbytordpat_ch2       <= rxdprioin_phy_ch2(rbytordpat_DP_RX_IDX_9  DOWNTO  rbytordpat_DP_RX_IDX_0);
rppmsel_ch3          <= rxdprioin_phy_ch3(rppmsel_DP_RX_IDX_5  DOWNTO  rppmsel_DP_RX_IDX_0);
rbytordpat_ch3       <= rxdprioin_phy_ch3(rbytordpat_DP_RX_IDX_9  DOWNTO  rbytordpat_DP_RX_IDX_0);

-- PCS_CTRL_15
-- pcs_ctrl15_ch0_ext <= {rtest_bus_sel_ch0, rforce_sig_det_pcs(0), rforce0_freqdet(0), 
--                              rforce1_freqdet(0), rbytordpad_ch0};
rtest_bus_sel_ch0    <= "000";
rforce_sig_det_pcs(0)<= rxdprioin_phy_ch0(rforce_sig_det_pcs_DP_RX_IDX);
rforce0_freqdet(0)   <= rxdprioin_phy_ch0(rforce0_freqdet_DP_RX_IDX);
rforce1_freqdet(0)   <= rxdprioin_phy_ch0(rforce1_freqdet_DP_RX_IDX);
rbytordpad_ch0       <= rxdprioin_phy_ch0(rbytordpad_DP_RX_IDX_9  DOWNTO  rbytordpad_DP_RX_IDX_0);

rtest_bus_sel_ch1    <= "000";
rforce_sig_det_pcs(1)<= rxdprioin_phy_ch1(rforce_sig_det_pcs_DP_RX_IDX);
rforce0_freqdet(1)   <= rxdprioin_phy_ch1(rforce0_freqdet_DP_RX_IDX);
rforce1_freqdet(1)   <= rxdprioin_phy_ch1(rforce1_freqdet_DP_RX_IDX);
rbytordpad_ch1       <= rxdprioin_phy_ch1(rbytordpad_DP_RX_IDX_9  DOWNTO  rbytordpad_DP_RX_IDX_0);

rtest_bus_sel_ch2    <= "000";
rforce_sig_det_pcs(2)<= rxdprioin_phy_ch2(rforce_sig_det_pcs_DP_RX_IDX);
rforce0_freqdet(2)   <= rxdprioin_phy_ch2(rforce0_freqdet_DP_RX_IDX);
rforce1_freqdet(2)   <= rxdprioin_phy_ch2(rforce1_freqdet_DP_RX_IDX);
rbytordpad_ch2       <= rxdprioin_phy_ch2(rbytordpad_DP_RX_IDX_9  DOWNTO  rbytordpad_DP_RX_IDX_0);

rtest_bus_sel_ch3    <= "000";
rforce_sig_det_pcs(3)<= rxdprioin_phy_ch3(rforce_sig_det_pcs_DP_RX_IDX);
rforce0_freqdet(3)   <= rxdprioin_phy_ch3(rforce0_freqdet_DP_RX_IDX);
rforce1_freqdet(3)   <= rxdprioin_phy_ch3(rforce1_freqdet_DP_RX_IDX);
rbytordpad_ch3       <= rxdprioin_phy_ch3(rbytordpad_DP_RX_IDX_9  DOWNTO  rbytordpad_DP_RX_IDX_0);

-- pcs_ctrl in to add


-- PCS output -----------------------------------------------------------------------------

-- PCS Trunking 
rxdprioout_phy_ch0(rphfifo_master_sel_rx_DP_RX_IDX)   <= rphfifo_master_sel_rx_int;
rxdprioout_phy_ch1(rphfifo_master_sel_rx_DP_RX_IDX)   <= rphfifo_master_sel_rx_int;
rxdprioout_phy_ch2(rphfifo_master_sel_rx_DP_RX_IDX)   <= rphfifo_master_sel_rx_int;
rxdprioout_phy_ch3(rphfifo_master_sel_rx_DP_RX_IDX)   <= rphfifo_master_sel_rx_int;
rxdprioout_phy_ch0(rendec_data_sel_rx_DP_RX_IDX)      <= rendec_data_sel_rx_int;
rxdprioout_phy_ch1(rendec_data_sel_rx_DP_RX_IDX)      <= rendec_data_sel_rx_int;
rxdprioout_phy_ch2(rendec_data_sel_rx_DP_RX_IDX)      <= rendec_data_sel_rx_int;
rxdprioout_phy_ch3(rendec_data_sel_rx_DP_RX_IDX)      <= rendec_data_sel_rx_int;
rxdprioout_phy_ch0(rindv_rx_DP_RX_IDX)                <= rindv_rx_int;
rxdprioout_phy_ch1(rindv_rx_DP_RX_IDX)                <= rindv_rx_int;
rxdprioout_phy_ch2(rindv_rx_DP_RX_IDX)                <= rindv_rx_int;
rxdprioout_phy_ch3(rindv_rx_DP_RX_IDX)                <= rindv_rx_int;
--tx
txdprioout_phy_ch0(rphfifo_master_sel_tx_DP_TX_IDX)   <= rphfifo_master_sel_tx_int;
txdprioout_phy_ch1(rphfifo_master_sel_tx_DP_TX_IDX)   <= rphfifo_master_sel_tx_int;
txdprioout_phy_ch2(rphfifo_master_sel_tx_DP_TX_IDX)   <= rphfifo_master_sel_tx_int;
txdprioout_phy_ch3(rphfifo_master_sel_tx_DP_TX_IDX)   <= rphfifo_master_sel_tx_int;
txdprioout_phy_ch0(rendec_data_sel_tx_DP_TX_IDX)      <= rendec_data_sel_tx_int;
txdprioout_phy_ch1(rendec_data_sel_tx_DP_TX_IDX)      <= rendec_data_sel_tx_int;
txdprioout_phy_ch2(rendec_data_sel_tx_DP_TX_IDX)      <= rendec_data_sel_tx_int;
txdprioout_phy_ch3(rendec_data_sel_tx_DP_TX_IDX)      <= rendec_data_sel_tx_int;
txdprioout_phy_ch0(rindv_tx_DP_TX_IDX)                <= rindv_tx_int;
txdprioout_phy_ch1(rindv_tx_DP_TX_IDX)                <= rindv_tx_int;
txdprioout_phy_ch2(rindv_tx_DP_TX_IDX)                <= rindv_tx_int;
txdprioout_phy_ch3(rindv_tx_DP_TX_IDX)                <= rindv_tx_int;

-- PCS_CTRL1 - mix of RX and TX
txdprioout_phy_ch0(rtx_pipe_enable_DP_TX_IDX)   <= rtx_pipe_enable_int(0);
rxdprioout_phy_ch0(rrx_pipe_enable_DP_RX_IDX)   <= rrx_pipe_enable_int(0);
txdprioout_phy_ch0(rpowdnt_DP_TX_IDX)           <= rpowdnt_md(0);
rxdprioout_phy_ch0(rpowdnr_DP_RX_IDX)           <= rpowdnr_md(0);
txdprioout_phy_ch0(rendec_tx_DP_TX_IDX)         <= rendec_tx_int(0);
rxdprioout_phy_ch0(rendec_rx_DP_RX_IDX)         <= rendec_rx_int(0);
txdprioout_phy_ch0(r8b10b_enc_ibm_en_DP_TX_IDX) <= r8b10b_enc_ibm_en_int(0);
rxdprioout_phy_ch0(rmatchen_DP_RX_IDX)          <= rmatchen_int(0);
rxdprioout_phy_ch0(r8b10b_dec_ibm_en_DP_RX_IDX_1  DOWNTO  r8b10b_dec_ibm_en_DP_RX_IDX_0) <= r8b10b_dec_ibm_en_ch0_int;
txdprioout_phy_ch0(rforce_kchar_DP_TX_IDX)      <= rforce_kchar_int(0);
txdprioout_phy_ch0(rforce_echar_DP_TX_IDX)      <= rforce_echar_int(0);
rxdprioout_phy_ch0(rlp20ben_DP_RX_IDX)          <= rlp20ben_int(0);
rxdprioout_phy_ch0(rgenericfifo_DP_RX_IDX)      <= rgenericfifo_int(0);
txdprioout_phy_ch0(rcascaded_8b10b_en_tx_DP_TX_IDX) <= rcascaded_8b10b_en_tx_int(0);
rxdprioout_phy_ch0(rcascaded_8b10b_en_rx_DP_RX_IDX) <= rcascaded_8b10b_en_rx_int(0);

txdprioout_phy_ch1(rtx_pipe_enable_DP_TX_IDX)   <= rtx_pipe_enable_int(1);
rxdprioout_phy_ch1(rrx_pipe_enable_DP_RX_IDX)   <= rrx_pipe_enable_int(1);
txdprioout_phy_ch1(rpowdnt_DP_TX_IDX)           <= rpowdnt_md(1);
rxdprioout_phy_ch1(rpowdnr_DP_RX_IDX)           <= rpowdnr_md(1);
txdprioout_phy_ch1(rendec_tx_DP_TX_IDX)         <= rendec_tx_int(1);
rxdprioout_phy_ch1(rendec_rx_DP_RX_IDX)         <= rendec_rx_int(1);
txdprioout_phy_ch1(r8b10b_enc_ibm_en_DP_TX_IDX) <= r8b10b_enc_ibm_en_int(1);
rxdprioout_phy_ch1(rmatchen_DP_RX_IDX)          <= rmatchen_int(1);
rxdprioout_phy_ch1(r8b10b_dec_ibm_en_DP_RX_IDX_1  DOWNTO  r8b10b_dec_ibm_en_DP_RX_IDX_0) <= r8b10b_dec_ibm_en_ch1_int;
txdprioout_phy_ch1(rforce_kchar_DP_TX_IDX)      <= rforce_kchar_int(1);
txdprioout_phy_ch1(rforce_echar_DP_TX_IDX)      <= rforce_echar_int(1);
rxdprioout_phy_ch1(rlp20ben_DP_RX_IDX)          <= rlp20ben_int(1);
rxdprioout_phy_ch1(rgenericfifo_DP_RX_IDX)      <= rgenericfifo_int(1);
txdprioout_phy_ch1(rcascaded_8b10b_en_tx_DP_TX_IDX) <= rcascaded_8b10b_en_tx_int(1);
rxdprioout_phy_ch1(rcascaded_8b10b_en_rx_DP_RX_IDX) <= rcascaded_8b10b_en_rx_int(1);

txdprioout_phy_ch2(rtx_pipe_enable_DP_TX_IDX)   <= rtx_pipe_enable_int(2);
rxdprioout_phy_ch2(rrx_pipe_enable_DP_RX_IDX)   <= rrx_pipe_enable_int(2);
txdprioout_phy_ch2(rpowdnt_DP_TX_IDX)           <= rpowdnt_md(2);
rxdprioout_phy_ch2(rpowdnr_DP_RX_IDX)           <= rpowdnr_md(2);
txdprioout_phy_ch2(rendec_tx_DP_TX_IDX)         <= rendec_tx_int(2);
rxdprioout_phy_ch2(rendec_rx_DP_RX_IDX)         <= rendec_rx_int(2);
txdprioout_phy_ch2(r8b10b_enc_ibm_en_DP_TX_IDX) <= r8b10b_enc_ibm_en_int(2);
rxdprioout_phy_ch2(rmatchen_DP_RX_IDX)          <= rmatchen_int(2);
rxdprioout_phy_ch2(r8b10b_dec_ibm_en_DP_RX_IDX_1  DOWNTO  r8b10b_dec_ibm_en_DP_RX_IDX_0) <= r8b10b_dec_ibm_en_ch2_int;
txdprioout_phy_ch2(rforce_kchar_DP_TX_IDX)      <= rforce_kchar_int(2);
txdprioout_phy_ch2(rforce_echar_DP_TX_IDX)      <= rforce_echar_int(2);
rxdprioout_phy_ch2(rlp20ben_DP_RX_IDX)          <= rlp20ben_int(2);
rxdprioout_phy_ch2(rgenericfifo_DP_RX_IDX)      <= rgenericfifo_int(2);
txdprioout_phy_ch2(rcascaded_8b10b_en_tx_DP_TX_IDX) <= rcascaded_8b10b_en_tx_int(2);
rxdprioout_phy_ch2(rcascaded_8b10b_en_rx_DP_RX_IDX) <= rcascaded_8b10b_en_rx_int(2);

txdprioout_phy_ch3(rtx_pipe_enable_DP_TX_IDX)   <= rtx_pipe_enable_int(3);
rxdprioout_phy_ch3(rrx_pipe_enable_DP_RX_IDX)   <= rrx_pipe_enable_int(3);
txdprioout_phy_ch3(rpowdnt_DP_TX_IDX)           <= rpowdnt_md(3);
rxdprioout_phy_ch3(rpowdnr_DP_RX_IDX)           <= rpowdnr_md(3);
txdprioout_phy_ch3(rendec_tx_DP_TX_IDX)         <= rendec_tx_int(3);
rxdprioout_phy_ch3(rendec_rx_DP_RX_IDX)         <= rendec_rx_int(3);
txdprioout_phy_ch3(r8b10b_enc_ibm_en_DP_TX_IDX) <= r8b10b_enc_ibm_en_int(3);
rxdprioout_phy_ch3(rmatchen_DP_RX_IDX)          <= rmatchen_int(3);
rxdprioout_phy_ch3(r8b10b_dec_ibm_en_DP_RX_IDX_1  DOWNTO  r8b10b_dec_ibm_en_DP_RX_IDX_0) <= r8b10b_dec_ibm_en_ch3_int;
txdprioout_phy_ch3(rforce_kchar_DP_TX_IDX)      <= rforce_kchar_int(3);
txdprioout_phy_ch3(rforce_echar_DP_TX_IDX)      <= rforce_echar_int(3);
rxdprioout_phy_ch3(rlp20ben_DP_RX_IDX)          <= rlp20ben_int(3);
rxdprioout_phy_ch3(rgenericfifo_DP_RX_IDX)      <= rgenericfifo_int(3);
txdprioout_phy_ch3(rcascaded_8b10b_en_tx_DP_TX_IDX) <= rcascaded_8b10b_en_tx_int(3);
rxdprioout_phy_ch3(rcascaded_8b10b_en_rx_DP_RX_IDX) <= rcascaded_8b10b_en_rx_int(3);

-- PCS_CTRL2 (part) - all RX
rxdprioout_phy_ch0(rencdt_rising_DP_RX_IDX)     <=  rencdt_rising_int(0); 
rxdprioout_phy_ch0(rdis_rx_disp_DP_RX_IDX)      <=  rdis_rx_disp_int(0);
rxdprioout_phy_ch0(rcomp_pat_porn_DP_RX_IDX)    <=  rcomp_pat_porn_int(0); 
rxdprioout_phy_ch1(rencdt_rising_DP_RX_IDX)     <=  rencdt_rising_int(1); 
rxdprioout_phy_ch1(rdis_rx_disp_DP_RX_IDX)      <=  rdis_rx_disp_int(1);
rxdprioout_phy_ch1(rcomp_pat_porn_DP_RX_IDX)    <=  rcomp_pat_porn_int(1); 
rxdprioout_phy_ch2(rencdt_rising_DP_RX_IDX)     <=  rencdt_rising_int(2); 
rxdprioout_phy_ch2(rdis_rx_disp_DP_RX_IDX)      <=  rdis_rx_disp_int(2);
rxdprioout_phy_ch2(rcomp_pat_porn_DP_RX_IDX)    <=  rcomp_pat_porn_int(2); 
rxdprioout_phy_ch3(rencdt_rising_DP_RX_IDX)     <=  rencdt_rising_int(3); 
rxdprioout_phy_ch3(rdis_rx_disp_DP_RX_IDX)      <=  rdis_rx_disp_int(3);
rxdprioout_phy_ch3(rcomp_pat_porn_DP_RX_IDX)    <=  rcomp_pat_porn_int(3); 

-- PCS_CTRL2 (part), PCS_CTRL3, PCS_CTRL4
rxdprioout_phy_ch0(rcomp_size_DP_RX_IDX_2  DOWNTO  rcomp_size_DP_RX_IDX_0) <=  rcomp_size_ch0_int;
rxdprioout_phy_ch0(rcomp_pat_DP_RX_IDX_39  DOWNTO  rcomp_pat_DP_RX_IDX_0)  <=  rcomp_pat_ch0_int;
rxdprioout_phy_ch1(rcomp_size_DP_RX_IDX_2  DOWNTO  rcomp_size_DP_RX_IDX_0) <=  rcomp_size_ch1_int;
rxdprioout_phy_ch1(rcomp_pat_DP_RX_IDX_39  DOWNTO  rcomp_pat_DP_RX_IDX_0)  <=  rcomp_pat_ch1_int;
rxdprioout_phy_ch2(rcomp_size_DP_RX_IDX_2  DOWNTO  rcomp_size_DP_RX_IDX_0) <=  rcomp_size_ch2_int;
rxdprioout_phy_ch2(rcomp_pat_DP_RX_IDX_39  DOWNTO  rcomp_pat_DP_RX_IDX_0)  <=  rcomp_pat_ch2_int;
rxdprioout_phy_ch3(rcomp_size_DP_RX_IDX_2  DOWNTO  rcomp_size_DP_RX_IDX_0) <=  rcomp_size_ch3_int;
rxdprioout_phy_ch3(rcomp_pat_DP_RX_IDX_39  DOWNTO  rcomp_pat_DP_RX_IDX_0)  <=  rcomp_pat_ch3_int;

-- PCS_CTRL5 - mix of RX and TX
rxdprioout_phy_ch0(rrxfifo_dis_DP_RX_IDX)           <=  rrxfifo_dis_int(0); 
rxdprioout_phy_ch0(rrundisp_DP_RX_IDX_5  DOWNTO  rrundisp_DP_RX_IDX_0) <=  rrundisp_ch0_int; 
rxdprioout_phy_ch0(rrlv_en_DP_RX_IDX)               <=  rrlv_en_int(0); 
rxdprioout_phy_ch0(rautobtalg_dis_DP_RX_IDX)        <=  rautobtalg_dis_int(0);
rxdprioout_phy_ch0(rsync_sm_dis_DP_RX_IDX)          <=  rsync_sm_dis_int(0); 
rxdprioout_phy_ch0(rib_inv_cd_DP_RX_IDX_1  DOWNTO  rib_inv_cd_DP_RX_IDX_0) <=  rib_inv_cd_ch0_int; 
rxdprioout_phy_ch0(rrxfifo_lowlatency_en_DP_RX_IDX) <=  rrxfifo_lowlatency_en_int(0);
-- tx
txdprioout_phy_ch0(rtxfifo_dis_DP_TX_IDX)           <= rtxfifo_dis_int(0); 
txdprioout_phy_ch0(rib_force_disp_DP_TX_IDX)        <= rib_force_disp_int(0);                 
txdprioout_phy_ch0(rtxfifo_lowlatency_en_DP_TX_IDX) <= rtxfifo_lowlatency_en_int(0);

rxdprioout_phy_ch1(rrxfifo_dis_DP_RX_IDX)           <=  rrxfifo_dis_int(1); 
rxdprioout_phy_ch1(rrundisp_DP_RX_IDX_5  DOWNTO  rrundisp_DP_RX_IDX_0) <=  rrundisp_ch1_int; 
rxdprioout_phy_ch1(rrlv_en_DP_RX_IDX)               <=  rrlv_en_int(1); 
rxdprioout_phy_ch1(rautobtalg_dis_DP_RX_IDX)        <=  rautobtalg_dis_int(1);
rxdprioout_phy_ch1(rsync_sm_dis_DP_RX_IDX)          <=  rsync_sm_dis_int(1); 
rxdprioout_phy_ch1(rib_inv_cd_DP_RX_IDX_1  DOWNTO  rib_inv_cd_DP_RX_IDX_0) <=  rib_inv_cd_ch1_int; 
rxdprioout_phy_ch1(rrxfifo_lowlatency_en_DP_RX_IDX) <=  rrxfifo_lowlatency_en_int(1);
-- tx
txdprioout_phy_ch1(rtxfifo_dis_DP_TX_IDX)           <= rtxfifo_dis_int(1); 
txdprioout_phy_ch1(rib_force_disp_DP_TX_IDX)        <= rib_force_disp_int(1);                 
txdprioout_phy_ch1(rtxfifo_lowlatency_en_DP_TX_IDX) <= rtxfifo_lowlatency_en_int(1);

rxdprioout_phy_ch2(rrxfifo_dis_DP_RX_IDX)           <=  rrxfifo_dis_int(2); 
rxdprioout_phy_ch2(rrundisp_DP_RX_IDX_5  DOWNTO  rrundisp_DP_RX_IDX_0) <=  rrundisp_ch2_int; 
rxdprioout_phy_ch2(rrlv_en_DP_RX_IDX)               <=  rrlv_en_int(2); 
rxdprioout_phy_ch2(rautobtalg_dis_DP_RX_IDX)        <=  rautobtalg_dis_int(2);
rxdprioout_phy_ch2(rsync_sm_dis_DP_RX_IDX)          <=  rsync_sm_dis_int(2); 
rxdprioout_phy_ch2(rib_inv_cd_DP_RX_IDX_1  DOWNTO  rib_inv_cd_DP_RX_IDX_0) <=  rib_inv_cd_ch2_int; 
rxdprioout_phy_ch2(rrxfifo_lowlatency_en_DP_RX_IDX) <=  rrxfifo_lowlatency_en_int(2);
-- tx
txdprioout_phy_ch2(rtxfifo_dis_DP_TX_IDX)           <= rtxfifo_dis_int(2); 
txdprioout_phy_ch2(rib_force_disp_DP_TX_IDX)        <= rib_force_disp_int(2);                 
txdprioout_phy_ch2(rtxfifo_lowlatency_en_DP_TX_IDX) <= rtxfifo_lowlatency_en_int(2);

rxdprioout_phy_ch3(rrxfifo_dis_DP_RX_IDX)           <=  rrxfifo_dis_int(3); 
rxdprioout_phy_ch3(rrundisp_DP_RX_IDX_5  DOWNTO  rrundisp_DP_RX_IDX_0) <=  rrundisp_ch3_int; 
rxdprioout_phy_ch3(rrlv_en_DP_RX_IDX)               <=  rrlv_en_int(3); 
rxdprioout_phy_ch3(rautobtalg_dis_DP_RX_IDX)        <=  rautobtalg_dis_int(3);
rxdprioout_phy_ch3(rsync_sm_dis_DP_RX_IDX)          <=  rsync_sm_dis_int(3); 
rxdprioout_phy_ch3(rib_inv_cd_DP_RX_IDX_1  DOWNTO  rib_inv_cd_DP_RX_IDX_0) <=  rib_inv_cd_ch3_int; 
rxdprioout_phy_ch3(rrxfifo_lowlatency_en_DP_RX_IDX) <=  rrxfifo_lowlatency_en_int(3);
-- tx
txdprioout_phy_ch3(rtxfifo_dis_DP_TX_IDX)           <= rtxfifo_dis_int(3); 
txdprioout_phy_ch3(rib_force_disp_DP_TX_IDX)        <= rib_force_disp_int(3);                 
txdprioout_phy_ch3(rtxfifo_lowlatency_en_DP_TX_IDX) <= rtxfifo_lowlatency_en_int(3);

-- PCS_CTRL6 - mix of RX and TX
txdprioout_phy_ch0(rdwidth_tx_DP_TX_IDX)        <= rdwidth_tx_int(0);
rxdprioout_phy_ch0(rdwidth_rx_DP_RX_IDX)        <= rdwidth_rx_int(0);
txdprioout_phy_ch0(rge_xaui_tx_DP_TX_IDX)       <= rge_xaui_tx_int(0);
rxdprioout_phy_ch0(rrx_detect_bypass_DP_RX_IDX) <= rrx_detect_bypass_int(0);
txdprioout_phy_ch0(rtxurstpcs_DP_TX_IDX)        <= rtxurstpcs_md(0);
rxdprioout_phy_ch0(rrxurstpcs_DP_RX_IDX)        <= rrxurstpcs_md(0);
txdprioout_phy_ch0(rrsvd_tx_DP_TX_IDX_4  DOWNTO  rrsvd_tx_DP_TX_IDX_0) <= rrsvd_tx_ch0_int; 
rxdprioout_phy_ch0(rskpsetbased_DP_RX_IDX)      <= rskpsetbased_int(0);
rxdprioout_phy_ch0(rtruebac2bac_DP_RX_IDX)      <= rtruebac2bac_int(0);
rxdprioout_phy_ch0(rrsvd_rx_DP_RX_IDX_2  DOWNTO  rrsvd_rx_DP_RX_IDX_0) <= rrsvd_rx_ch0_int; 

txdprioout_phy_ch1(rdwidth_tx_DP_TX_IDX)        <= rdwidth_tx_int(1);
rxdprioout_phy_ch1(rdwidth_rx_DP_RX_IDX)        <= rdwidth_rx_int(1);
txdprioout_phy_ch1(rge_xaui_tx_DP_TX_IDX)       <= rge_xaui_tx_int(1);
rxdprioout_phy_ch1(rrx_detect_bypass_DP_RX_IDX) <= rrx_detect_bypass_int(1);
txdprioout_phy_ch1(rtxurstpcs_DP_TX_IDX)        <= rtxurstpcs_md(1);
rxdprioout_phy_ch1(rrxurstpcs_DP_RX_IDX)        <= rrxurstpcs_md(1);
txdprioout_phy_ch1(rrsvd_tx_DP_TX_IDX_4  DOWNTO  rrsvd_tx_DP_TX_IDX_0) <= rrsvd_tx_ch1_int; 
rxdprioout_phy_ch1(rskpsetbased_DP_RX_IDX)      <= rskpsetbased_int(1);
rxdprioout_phy_ch1(rtruebac2bac_DP_RX_IDX)      <= rtruebac2bac_int(1);
rxdprioout_phy_ch1(rrsvd_rx_DP_RX_IDX_2  DOWNTO  rrsvd_rx_DP_RX_IDX_0) <= rrsvd_rx_ch1_int; 

txdprioout_phy_ch2(rdwidth_tx_DP_TX_IDX)        <= rdwidth_tx_int(2);
rxdprioout_phy_ch2(rdwidth_rx_DP_RX_IDX)        <= rdwidth_rx_int(2);
txdprioout_phy_ch2(rge_xaui_tx_DP_TX_IDX)       <= rge_xaui_tx_int(2);
rxdprioout_phy_ch2(rrx_detect_bypass_DP_RX_IDX) <= rrx_detect_bypass_int(2);
txdprioout_phy_ch2(rtxurstpcs_DP_TX_IDX)        <= rtxurstpcs_md(2);
rxdprioout_phy_ch2(rrxurstpcs_DP_RX_IDX)        <= rrxurstpcs_md(2);
txdprioout_phy_ch2(rrsvd_tx_DP_TX_IDX_4  DOWNTO  rrsvd_tx_DP_TX_IDX_0) <= rrsvd_tx_ch2_int; 
rxdprioout_phy_ch2(rskpsetbased_DP_RX_IDX)      <= rskpsetbased_int(2);
rxdprioout_phy_ch2(rtruebac2bac_DP_RX_IDX)      <= rtruebac2bac_int(2);
rxdprioout_phy_ch2(rrsvd_rx_DP_RX_IDX_2  DOWNTO  rrsvd_rx_DP_RX_IDX_0) <= rrsvd_rx_ch2_int; 

txdprioout_phy_ch3(rdwidth_tx_DP_TX_IDX)        <= rdwidth_tx_int(3);
rxdprioout_phy_ch3(rdwidth_rx_DP_RX_IDX)        <= rdwidth_rx_int(3);
txdprioout_phy_ch3(rge_xaui_tx_DP_TX_IDX)       <= rge_xaui_tx_int(3);
rxdprioout_phy_ch3(rrx_detect_bypass_DP_RX_IDX) <= rrx_detect_bypass_int(3);
txdprioout_phy_ch3(rtxurstpcs_DP_TX_IDX)        <= rtxurstpcs_md(3);
rxdprioout_phy_ch3(rrxurstpcs_DP_RX_IDX)        <= rrxurstpcs_md(3);
txdprioout_phy_ch3(rrsvd_tx_DP_TX_IDX_4  DOWNTO  rrsvd_tx_DP_TX_IDX_0) <= rrsvd_tx_ch3_int; 
rxdprioout_phy_ch3(rskpsetbased_DP_RX_IDX)      <= rskpsetbased_int(3);
rxdprioout_phy_ch3(rtruebac2bac_DP_RX_IDX)      <= rtruebac2bac_int(3);
rxdprioout_phy_ch3(rrsvd_rx_DP_RX_IDX_2  DOWNTO  rrsvd_rx_DP_RX_IDX_0) <= rrsvd_rx_ch3_int; 

-- PCS_CTRL7 - all RX
rxdprioout_phy_ch0(rgnumber_DP_RX_IDX_7  DOWNTO  rgnumber_DP_RX_IDX_0) <= rgnumber_ch0_int; 
rxdprioout_phy_ch1(rgnumber_DP_RX_IDX_7  DOWNTO  rgnumber_DP_RX_IDX_0) <= rgnumber_ch1_int; 
rxdprioout_phy_ch2(rgnumber_DP_RX_IDX_7  DOWNTO  rgnumber_DP_RX_IDX_0) <= rgnumber_ch2_int; 
rxdprioout_phy_ch3(rgnumber_DP_RX_IDX_7  DOWNTO  rgnumber_DP_RX_IDX_0) <= rgnumber_ch3_int; 
rxdprioout_phy_ch0(rknumber_DP_RX_IDX_7  DOWNTO  rknumber_DP_RX_IDX_0) <= rknumber_ch0_int; 
rxdprioout_phy_ch1(rknumber_DP_RX_IDX_7  DOWNTO  rknumber_DP_RX_IDX_0) <= rknumber_ch1_int; 
rxdprioout_phy_ch2(rknumber_DP_RX_IDX_7  DOWNTO  rknumber_DP_RX_IDX_0) <= rknumber_ch2_int; 
rxdprioout_phy_ch3(rknumber_DP_RX_IDX_7  DOWNTO  rknumber_DP_RX_IDX_0) <= rknumber_ch3_int; 

-- PCS_CTRL8
rxdprioout_phy_ch0(rfreerun_rx_DP_RX_IDX)       <= rfreerun_rx_int(0);  -- 4'h0;  for POF
rxdprioout_phy_ch0(rrx_rd_clk_sel_DP_RX_IDX)    <= rrx_rd_clk_sel_int(0);
rxdprioout_phy_ch0(renumber_DP_RX_IDX_2  DOWNTO  renumber_DP_RX_IDX_0) <= renumber_ch0_int;
rxdprioout_phy_ch0(renpolinv_rx_DP_RX_IDX)      <= renpolinv_rx_int(0); 
rxdprioout_phy_ch0(rclkcmpinsertpad_DP_RX_IDX)  <= rclkcmpinsertpad_int(0);
-- tx
txdprioout_phy_ch0(rfreerun_tx_DP_TX_IDX)       <= rfreerun_tx_int(0);  -- 4'h0;  for POF
txdprioout_phy_ch0(rtxwrclksel_DP_TX_IDX)       <= rtxwrclksel_int(0);
txdprioout_phy_ch0(rtxrdclksel_DP_TX_IDX)       <= rtxrdclksel_int(0); 
rxdprioout_phy_ch0(rrcvd_clk_sel_DP_RX_IDX_1  DOWNTO  rrcvd_clk_sel_DP_RX_IDX_0) <= rrcvd_clk_sel_ch0_int ; -- dprio_enabled DOWNTO  bits 11-10 
rxdprioout_phy_ch0(rclk_1_sel_DP_RX_IDX_1     DOWNTO  rclk_1_sel_DP_RX_IDX_0)    <= rclk_1_sel_ch0_int;     -- dprio_enabled DOWNTO  bits 9-8 
rxdprioout_phy_ch0(rclk_2_sel_DP_RX_IDX_1     DOWNTO  rclk_2_sel_DP_RX_IDX_0)    <= rclk_2_sel_ch0_int;     -- dprio_enabled DOWNTO  bits 7-6

rxdprioout_phy_ch1(rfreerun_rx_DP_RX_IDX)       <= rfreerun_rx_int(1);  -- 4'h0;  for POF
rxdprioout_phy_ch1(rrx_rd_clk_sel_DP_RX_IDX)    <= rrx_rd_clk_sel_int(1);
rxdprioout_phy_ch1(renumber_DP_RX_IDX_2  DOWNTO  renumber_DP_RX_IDX_0) <= renumber_ch1_int;
rxdprioout_phy_ch1(renpolinv_rx_DP_RX_IDX)      <= renpolinv_rx_int(1); 
rxdprioout_phy_ch1(rclkcmpinsertpad_DP_RX_IDX)  <= rclkcmpinsertpad_int(1);
-- tx
txdprioout_phy_ch1(rfreerun_tx_DP_TX_IDX)       <= rfreerun_tx_int(1);  -- 4'h0;  for POF
txdprioout_phy_ch1(rtxwrclksel_DP_TX_IDX)       <= rtxwrclksel_int(1);
txdprioout_phy_ch1(rtxrdclksel_DP_TX_IDX)       <= rtxrdclksel_int(1); 
rxdprioout_phy_ch1(rrcvd_clk_sel_DP_RX_IDX_1  DOWNTO  rrcvd_clk_sel_DP_RX_IDX_0) <= rrcvd_clk_sel_ch1_int ; -- dprio_enabled DOWNTO  bits 11-10 
rxdprioout_phy_ch1(rclk_1_sel_DP_RX_IDX_1     DOWNTO  rclk_1_sel_DP_RX_IDX_0)    <= rclk_1_sel_ch1_int;     -- dprio_enabled DOWNTO  bits 9-8 
rxdprioout_phy_ch1(rclk_2_sel_DP_RX_IDX_1     DOWNTO  rclk_2_sel_DP_RX_IDX_0)    <= rclk_2_sel_ch1_int;     -- dprio_enabled DOWNTO  bits 7-6

rxdprioout_phy_ch2(rfreerun_rx_DP_RX_IDX)       <= rfreerun_rx_int(2);  -- 4'h0;  for POF
rxdprioout_phy_ch2(rrx_rd_clk_sel_DP_RX_IDX)    <= rrx_rd_clk_sel_int(2);
rxdprioout_phy_ch2(renumber_DP_RX_IDX_2  DOWNTO  renumber_DP_RX_IDX_0) <= renumber_ch2_int;
rxdprioout_phy_ch2(renpolinv_rx_DP_RX_IDX)      <= renpolinv_rx_int(2); 
rxdprioout_phy_ch2(rclkcmpinsertpad_DP_RX_IDX)  <= rclkcmpinsertpad_int(2);
-- tx
txdprioout_phy_ch2(rfreerun_tx_DP_TX_IDX)       <= rfreerun_tx_int(2);  -- 4'h0;  for POF
txdprioout_phy_ch2(rtxwrclksel_DP_TX_IDX)       <= rtxwrclksel_int(2);
txdprioout_phy_ch2(rtxrdclksel_DP_TX_IDX)       <= rtxrdclksel_int(2); 
rxdprioout_phy_ch2(rrcvd_clk_sel_DP_RX_IDX_1  DOWNTO  rrcvd_clk_sel_DP_RX_IDX_0) <= rrcvd_clk_sel_ch2_int ; -- dprio_enabled DOWNTO  bits 11-10 
rxdprioout_phy_ch2(rclk_1_sel_DP_RX_IDX_1     DOWNTO  rclk_1_sel_DP_RX_IDX_0)    <= rclk_1_sel_ch2_int;     -- dprio_enabled DOWNTO  bits 9-8 
rxdprioout_phy_ch2(rclk_2_sel_DP_RX_IDX_1     DOWNTO  rclk_2_sel_DP_RX_IDX_0)    <= rclk_2_sel_ch2_int;     -- dprio_enabled DOWNTO  bits 7-6

rxdprioout_phy_ch3(rfreerun_rx_DP_RX_IDX)       <= rfreerun_rx_int(3);  -- 4'h0;  for POF
rxdprioout_phy_ch3(rrx_rd_clk_sel_DP_RX_IDX)    <= rrx_rd_clk_sel_int(3);
rxdprioout_phy_ch3(renumber_DP_RX_IDX_2  DOWNTO  renumber_DP_RX_IDX_0) <= renumber_ch3_int;
rxdprioout_phy_ch3(renpolinv_rx_DP_RX_IDX)      <= renpolinv_rx_int(3); 
rxdprioout_phy_ch3(rclkcmpinsertpad_DP_RX_IDX)  <= rclkcmpinsertpad_int(3);
-- tx
txdprioout_phy_ch3(rfreerun_tx_DP_TX_IDX)       <= rfreerun_tx_int(3);  -- 4'h0;  for POF
txdprioout_phy_ch3(rtxwrclksel_DP_TX_IDX)       <= rtxwrclksel_int(3);
txdprioout_phy_ch3(rtxrdclksel_DP_TX_IDX)       <= rtxrdclksel_int(3); 
rxdprioout_phy_ch3(rrcvd_clk_sel_DP_RX_IDX_1  DOWNTO  rrcvd_clk_sel_DP_RX_IDX_0) <= rrcvd_clk_sel_ch3_int ; -- dprio_enabled DOWNTO  bits 11-10 
rxdprioout_phy_ch3(rclk_1_sel_DP_RX_IDX_1     DOWNTO  rclk_1_sel_DP_RX_IDX_0)    <= rclk_1_sel_ch3_int;     -- dprio_enabled DOWNTO  bits 9-8 
rxdprioout_phy_ch3(rclk_2_sel_DP_RX_IDX_1     DOWNTO  rclk_2_sel_DP_RX_IDX_0)    <= rclk_2_sel_ch3_int;     -- dprio_enabled DOWNTO  bits 7-6

-- PCS_CTRL_9
rxdprioout_phy_ch0(rppm_cnt_reset_DP_RX_IDX) <= rppm_cnt_reset_int(0);
rxdprioout_phy_ch0(rphfifourstrx_DP_RX_IDX)  <= rphfifourstrx_int(0);
rxdprioout_phy_ch0(rcmpfifourst_DP_RX_IDX)   <= rcmpfifourst_int(0);
rxdprioout_phy_ch0(rclkcmpsqmd_DP_RX_IDX)    <= rclkcmpsqmd_int(0);
rxdprioout_phy_ch0(rtx_idle_delay_DP_RX_IDX_1  DOWNTO  rtx_idle_delay_DP_RX_IDX_0) <= rtx_idle_delay_ch0_int;
rxdprioout_phy_ch0(rclkcmpsq1p_DP_RX_IDX_19   DOWNTO  rclkcmpsq1p_DP_RX_IDX_0)    <= rclkcmpsq1p_ch0_int(19 DOWNTO 0);

rxdprioout_phy_ch1(rppm_cnt_reset_DP_RX_IDX) <= rppm_cnt_reset_int(1);
rxdprioout_phy_ch1(rphfifourstrx_DP_RX_IDX)  <= rphfifourstrx_int(1);
rxdprioout_phy_ch1(rcmpfifourst_DP_RX_IDX)   <= rcmpfifourst_int(1);
rxdprioout_phy_ch1(rclkcmpsqmd_DP_RX_IDX)    <= rclkcmpsqmd_int(1);
rxdprioout_phy_ch1(rtx_idle_delay_DP_RX_IDX_1  DOWNTO  rtx_idle_delay_DP_RX_IDX_0) <= rtx_idle_delay_ch1_int;
rxdprioout_phy_ch1(rclkcmpsq1p_DP_RX_IDX_19    DOWNTO  rclkcmpsq1p_DP_RX_IDX_0)    <= rclkcmpsq1p_ch1_int(19 DOWNTO 0);

rxdprioout_phy_ch2(rppm_cnt_reset_DP_RX_IDX) <= rppm_cnt_reset_int(2);
rxdprioout_phy_ch2(rphfifourstrx_DP_RX_IDX)  <= rphfifourstrx_int(2);
rxdprioout_phy_ch2(rcmpfifourst_DP_RX_IDX)   <= rcmpfifourst_int(2);
rxdprioout_phy_ch2(rclkcmpsqmd_DP_RX_IDX)    <= rclkcmpsqmd_int(2);
rxdprioout_phy_ch2(rtx_idle_delay_DP_RX_IDX_1  DOWNTO  rtx_idle_delay_DP_RX_IDX_0) <= rtx_idle_delay_ch2_int;
rxdprioout_phy_ch2(rclkcmpsq1p_DP_RX_IDX_19    DOWNTO  rclkcmpsq1p_DP_RX_IDX_0)    <= rclkcmpsq1p_ch2_int(19 DOWNTO 0);

rxdprioout_phy_ch3(rppm_cnt_reset_DP_RX_IDX) <= rppm_cnt_reset_int(3);
rxdprioout_phy_ch3(rphfifourstrx_DP_RX_IDX)  <= rphfifourstrx_int(3);
rxdprioout_phy_ch3(rcmpfifourst_DP_RX_IDX)   <= rcmpfifourst_int(3);
rxdprioout_phy_ch3(rclkcmpsqmd_DP_RX_IDX)    <= rclkcmpsqmd_int(3);
rxdprioout_phy_ch3(rtx_idle_delay_DP_RX_IDX_1  DOWNTO  rtx_idle_delay_DP_RX_IDX_0) <= rtx_idle_delay_ch3_int;
rxdprioout_phy_ch3(rclkcmpsq1p_DP_RX_IDX_19    DOWNTO  rclkcmpsq1p_DP_RX_IDX_0)    <= rclkcmpsq1p_ch3_int(19 DOWNTO 0);

-- PCS_CTRL_10, 11
rxdprioout_phy_ch0(rclkcmpsq1n_DP_RX_IDX_19  DOWNTO  rclkcmpsq1n_DP_RX_IDX_0) <= rclkcmpsq1n_ch0_int;
rxdprioout_phy_ch0(rclkcmppos_DP_RX_IDX) <= rclkcmppos_int(0);

rxdprioout_phy_ch1(rclkcmpsq1n_DP_RX_IDX_19  DOWNTO  rclkcmpsq1n_DP_RX_IDX_0) <= rclkcmpsq1n_ch1_int;
rxdprioout_phy_ch1(rclkcmppos_DP_RX_IDX) <= rclkcmppos_int(1);

rxdprioout_phy_ch2(rclkcmpsq1n_DP_RX_IDX_19  DOWNTO  rclkcmpsq1n_DP_RX_IDX_0) <= rclkcmpsq1n_ch2_int;
rxdprioout_phy_ch2(rclkcmppos_DP_RX_IDX) <= rclkcmppos_int(2);

rxdprioout_phy_ch3(rclkcmpsq1n_DP_RX_IDX_19  DOWNTO  rclkcmpsq1n_DP_RX_IDX_0) <= rclkcmpsq1n_ch3_int;
rxdprioout_phy_ch3(rclkcmppos_DP_RX_IDX) <= rclkcmppos_int(3);

-- PCS_CTRL_12 - rx and tx mixed
rxdprioout_phy_ch0(ralempty_DP_RX_IDX_3  DOWNTO  ralempty_DP_RX_IDX_0)   <=  ralempty_ch0_int;
rxdprioout_phy_ch0(ralfull_DP_RX_IDX_3  DOWNTO  ralfull_DP_RX_IDX_0)     <=  ralfull_ch0_int;
rxdprioout_phy_ch0(rkchar_DP_RX_IDX)       <= rkchar_int(0);
rxdprioout_phy_ch0(rosbased_DP_RX_IDX)     <= rosbased_int(0);
rxdprioout_phy_ch0(rosnumber_DP_RX_IDX_1  DOWNTO  rosnumber_DP_RX_IDX_0) <= rosnumber_ch0_int;
--tx
txdprioout_phy_ch0(rrev_loopbk_DP_TX_IDX)  <= rrev_loopbk_int(0);
txdprioout_phy_ch0(rforce_disp_DP_TX_IDX)  <= rforce_disp_int(0);
txdprioout_phy_ch0(rensymswap_tx_DP_TX_IDX)<= rensymswap_tx_int(0);

rxdprioout_phy_ch1(ralempty_DP_RX_IDX_3  DOWNTO  ralempty_DP_RX_IDX_0)   <=  ralempty_ch1_int;
rxdprioout_phy_ch1(ralfull_DP_RX_IDX_3  DOWNTO  ralfull_DP_RX_IDX_0)     <=  ralfull_ch1_int;
rxdprioout_phy_ch1(rkchar_DP_RX_IDX)       <= rkchar_int(1);
rxdprioout_phy_ch1(rosbased_DP_RX_IDX)     <= rosbased_int(1);
rxdprioout_phy_ch1(rosnumber_DP_RX_IDX_1  DOWNTO  rosnumber_DP_RX_IDX_0) <= rosnumber_ch1_int;
--tx
txdprioout_phy_ch1(rrev_loopbk_DP_TX_IDX)  <= rrev_loopbk_int(1);
txdprioout_phy_ch1(rforce_disp_DP_TX_IDX)  <= rforce_disp_int(1);
txdprioout_phy_ch1(rensymswap_tx_DP_TX_IDX)<= rensymswap_tx_int(1);

rxdprioout_phy_ch2(ralempty_DP_RX_IDX_3  DOWNTO  ralempty_DP_RX_IDX_0)   <=  ralempty_ch2_int;
rxdprioout_phy_ch2(ralfull_DP_RX_IDX_3  DOWNTO  ralfull_DP_RX_IDX_0)     <=  ralfull_ch2_int;
rxdprioout_phy_ch2(rkchar_DP_RX_IDX)       <= rkchar_int(2);
rxdprioout_phy_ch2(rosbased_DP_RX_IDX)     <= rosbased_int(2);
rxdprioout_phy_ch2(rosnumber_DP_RX_IDX_1  DOWNTO  rosnumber_DP_RX_IDX_0) <= rosnumber_ch2_int;
--tx
txdprioout_phy_ch2(rrev_loopbk_DP_TX_IDX)  <= rrev_loopbk_int(2);
txdprioout_phy_ch2(rforce_disp_DP_TX_IDX)  <= rforce_disp_int(2);
txdprioout_phy_ch2(rensymswap_tx_DP_TX_IDX)<= rensymswap_tx_int(2);

rxdprioout_phy_ch3(ralempty_DP_RX_IDX_3  DOWNTO  ralempty_DP_RX_IDX_0)   <=  ralempty_ch3_int;
rxdprioout_phy_ch3(ralfull_DP_RX_IDX_3  DOWNTO  ralfull_DP_RX_IDX_0)     <=  ralfull_ch3_int;
rxdprioout_phy_ch3(rkchar_DP_RX_IDX)       <= rkchar_int(3);
rxdprioout_phy_ch3(rosbased_DP_RX_IDX)     <= rosbased_int(3);
rxdprioout_phy_ch3(rosnumber_DP_RX_IDX_1  DOWNTO  rosnumber_DP_RX_IDX_0) <= rosnumber_ch3_int;
--tx
txdprioout_phy_ch3(rrev_loopbk_DP_TX_IDX)  <= rrev_loopbk_int(3);
txdprioout_phy_ch3(rforce_disp_DP_TX_IDX)  <= rforce_disp_int(3);
txdprioout_phy_ch3(rensymswap_tx_DP_TX_IDX)<= rensymswap_tx_int(3);

-- PCS_CTRL_13
rxdprioout_phy_ch0(rwa_6g_en_DP_RX_IDX)    <= rwa_6g_en_int(0);
rxdprioout_phy_ch0(rbitslip_size_DP_RX_IDX_1  DOWNTO  rbitslip_size_DP_RX_IDX_0) <= rbitslip_size_ch0_int;
rxdprioout_phy_ch0(rbytord_2sym_en_DP_RX_IDX)   <= rbytord_2sym_en_int(0);
rxdprioout_phy_ch0(rbysync_polinv_en_DP_RX_IDX) <= rbysync_polinv_en_int(0);
rxdprioout_phy_ch0(rbitloc_rev_en_DP_RX_IDX)    <= rbitloc_rev_en_int(0);
rxdprioout_phy_ch0(rbyte_rev_en_DP_RX_IDX)      <= rbyte_rev_en_int(0);
rxdprioout_phy_ch0(rbyteorden_DP_RX_IDX_1  DOWNTO  rbyteorden_DP_RX_IDX_0)      <= rbyteorden_ch0_int;
rxdprioout_phy_ch0(rbytordplden_DP_RX_IDX)      <= rbytordplden_int(0);
rxdprioout_phy_ch0(rphfifopldenrx_DP_RX_IDX)    <= rphfifopldenrx_int(0);
rxdprioout_phy_ch0(rautoinsdis_DP_RX_IDX)       <= rautoinsdis_int(0);
--tx
txdprioout_phy_ch0(renpolinv_tx_DP_TX_IDX)      <= renpolinv_tx_int(0);
txdprioout_phy_ch0(renbitrev_tx_DP_TX_IDX)      <= renbitrev_tx_int(0);
txdprioout_phy_ch0(rphfifopldentx_DP_TX_IDX)    <= rphfifopldentx_int(0);
txdprioout_phy_ch0(rphfifoursttx_DP_TX_IDX)     <= rphfifoursttx_int(0);

rxdprioout_phy_ch1(rwa_6g_en_DP_RX_IDX)    <= rwa_6g_en_int(1);
rxdprioout_phy_ch1(rbitslip_size_DP_RX_IDX_1  DOWNTO  rbitslip_size_DP_RX_IDX_0) <= rbitslip_size_ch1_int;
rxdprioout_phy_ch1(rbytord_2sym_en_DP_RX_IDX)   <= rbytord_2sym_en_int(1);
rxdprioout_phy_ch1(rbysync_polinv_en_DP_RX_IDX) <= rbysync_polinv_en_int(1);
rxdprioout_phy_ch1(rbitloc_rev_en_DP_RX_IDX)    <= rbitloc_rev_en_int(1);
rxdprioout_phy_ch1(rbyte_rev_en_DP_RX_IDX)      <= rbyte_rev_en_int(1);
rxdprioout_phy_ch1(rbyteorden_DP_RX_IDX_1  DOWNTO  rbyteorden_DP_RX_IDX_0)      <= rbyteorden_ch1_int;
rxdprioout_phy_ch1(rbytordplden_DP_RX_IDX)      <= rbytordplden_int(1);
rxdprioout_phy_ch1(rphfifopldenrx_DP_RX_IDX)    <= rphfifopldenrx_int(1);
rxdprioout_phy_ch1(rautoinsdis_DP_RX_IDX)       <= rautoinsdis_int(1);
--tx
txdprioout_phy_ch1(renpolinv_tx_DP_TX_IDX)      <= renpolinv_tx_int(1);
txdprioout_phy_ch1(renbitrev_tx_DP_TX_IDX)      <= renbitrev_tx_int(1);
txdprioout_phy_ch1(rphfifopldentx_DP_TX_IDX)    <= rphfifopldentx_int(1);
txdprioout_phy_ch1(rphfifoursttx_DP_TX_IDX)     <= rphfifoursttx_int(1);

rxdprioout_phy_ch2(rwa_6g_en_DP_RX_IDX)    <= rwa_6g_en_int(2);
rxdprioout_phy_ch2(rbitslip_size_DP_RX_IDX_1  DOWNTO  rbitslip_size_DP_RX_IDX_0) <= rbitslip_size_ch2_int;
rxdprioout_phy_ch2(rbytord_2sym_en_DP_RX_IDX)   <= rbytord_2sym_en_int(2);
rxdprioout_phy_ch2(rbysync_polinv_en_DP_RX_IDX) <= rbysync_polinv_en_int(2);
rxdprioout_phy_ch2(rbitloc_rev_en_DP_RX_IDX)    <= rbitloc_rev_en_int(2);
rxdprioout_phy_ch2(rbyte_rev_en_DP_RX_IDX)      <= rbyte_rev_en_int(2);
rxdprioout_phy_ch2(rbyteorden_DP_RX_IDX_1  DOWNTO  rbyteorden_DP_RX_IDX_0)      <= rbyteorden_ch2_int;
rxdprioout_phy_ch2(rbytordplden_DP_RX_IDX)      <= rbytordplden_int(2);
rxdprioout_phy_ch2(rphfifopldenrx_DP_RX_IDX)    <= rphfifopldenrx_int(2);
rxdprioout_phy_ch2(rautoinsdis_DP_RX_IDX)       <= rautoinsdis_int(2);
--tx
txdprioout_phy_ch2(renpolinv_tx_DP_TX_IDX)      <= renpolinv_tx_int(2);
txdprioout_phy_ch2(renbitrev_tx_DP_TX_IDX)      <= renbitrev_tx_int(2);
txdprioout_phy_ch2(rphfifopldentx_DP_TX_IDX)    <= rphfifopldentx_int(2);
txdprioout_phy_ch2(rphfifoursttx_DP_TX_IDX)     <= rphfifoursttx_int(2);

rxdprioout_phy_ch3(rwa_6g_en_DP_RX_IDX)    <= rwa_6g_en_int(3);
rxdprioout_phy_ch3(rbitslip_size_DP_RX_IDX_1  DOWNTO  rbitslip_size_DP_RX_IDX_0) <= rbitslip_size_ch3_int;
rxdprioout_phy_ch3(rbytord_2sym_en_DP_RX_IDX)   <= rbytord_2sym_en_int(3);
rxdprioout_phy_ch3(rbysync_polinv_en_DP_RX_IDX) <= rbysync_polinv_en_int(3);
rxdprioout_phy_ch3(rbitloc_rev_en_DP_RX_IDX)    <= rbitloc_rev_en_int(3);
rxdprioout_phy_ch3(rbyte_rev_en_DP_RX_IDX)      <= rbyte_rev_en_int(3);
rxdprioout_phy_ch3(rbyteorden_DP_RX_IDX_1  DOWNTO  rbyteorden_DP_RX_IDX_0)      <= rbyteorden_ch3_int;
rxdprioout_phy_ch3(rbytordplden_DP_RX_IDX)      <= rbytordplden_int(3);
rxdprioout_phy_ch3(rphfifopldenrx_DP_RX_IDX)    <= rphfifopldenrx_int(3);
rxdprioout_phy_ch3(rautoinsdis_DP_RX_IDX)       <= rautoinsdis_int(3);
--tx
txdprioout_phy_ch3(renpolinv_tx_DP_TX_IDX)      <= renpolinv_tx_int(3);
txdprioout_phy_ch3(renbitrev_tx_DP_TX_IDX)      <= renbitrev_tx_int(3);
txdprioout_phy_ch3(rphfifopldentx_DP_TX_IDX)    <= rphfifopldentx_int(3);
txdprioout_phy_ch3(rphfifoursttx_DP_TX_IDX)     <= rphfifoursttx_int(3);

-- PCS_CTRL_14
rxdprioout_phy_ch0(rppmsel_DP_RX_IDX_5  DOWNTO  rppmsel_DP_RX_IDX_0)       <= rppmsel_ch0_int;
rxdprioout_phy_ch0(rbytordpat_DP_RX_IDX_9  DOWNTO  rbytordpat_DP_RX_IDX_0) <= rbytordpat_ch0_int;
rxdprioout_phy_ch1(rppmsel_DP_RX_IDX_5  DOWNTO  rppmsel_DP_RX_IDX_0)       <= rppmsel_ch1_int;
rxdprioout_phy_ch1(rbytordpat_DP_RX_IDX_9  DOWNTO  rbytordpat_DP_RX_IDX_0) <= rbytordpat_ch1_int;
rxdprioout_phy_ch2(rppmsel_DP_RX_IDX_5  DOWNTO  rppmsel_DP_RX_IDX_0)       <= rppmsel_ch2_int;
rxdprioout_phy_ch2(rbytordpat_DP_RX_IDX_9  DOWNTO  rbytordpat_DP_RX_IDX_0) <= rbytordpat_ch2_int;
rxdprioout_phy_ch3(rppmsel_DP_RX_IDX_5  DOWNTO  rppmsel_DP_RX_IDX_0)       <= rppmsel_ch3_int;
rxdprioout_phy_ch3(rbytordpat_DP_RX_IDX_9  DOWNTO  rbytordpat_DP_RX_IDX_0) <= rbytordpat_ch3_int;

-- PCS_CTRL_15
--testbus_ch0_int 
rxdprioout_phy_ch0(rforce_sig_det_pcs_DP_RX_IDX) <= rforce_sig_det_pcs_int(0);
rxdprioout_phy_ch0(rforce0_freqdet_DP_RX_IDX)    <= rforce0_freqdet_int(0);
rxdprioout_phy_ch0(rforce1_freqdet_DP_RX_IDX)    <= rforce1_freqdet_int(0);
rxdprioout_phy_ch0(rbytordpad_DP_RX_IDX_9  DOWNTO  rbytordpad_DP_RX_IDX_0) <= rbytordpad_ch0_int;

rxdprioout_phy_ch1(rforce_sig_det_pcs_DP_RX_IDX) <= rforce_sig_det_pcs_int(1);
rxdprioout_phy_ch1(rforce0_freqdet_DP_RX_IDX)    <= rforce0_freqdet_int(1);
rxdprioout_phy_ch1(rforce1_freqdet_DP_RX_IDX)    <= rforce1_freqdet_int(1);
rxdprioout_phy_ch1(rbytordpad_DP_RX_IDX_9  DOWNTO  rbytordpad_DP_RX_IDX_0) <= rbytordpad_ch1_int;

rxdprioout_phy_ch2(rforce_sig_det_pcs_DP_RX_IDX) <= rforce_sig_det_pcs_int(2);
rxdprioout_phy_ch2(rforce0_freqdet_DP_RX_IDX)    <= rforce0_freqdet_int(2);
rxdprioout_phy_ch2(rforce1_freqdet_DP_RX_IDX)    <= rforce1_freqdet_int(2);
rxdprioout_phy_ch2(rbytordpad_DP_RX_IDX_9  DOWNTO  rbytordpad_DP_RX_IDX_0) <= rbytordpad_ch2_int;

rxdprioout_phy_ch3(rforce_sig_det_pcs_DP_RX_IDX) <= rforce_sig_det_pcs_int(3);
rxdprioout_phy_ch3(rforce0_freqdet_DP_RX_IDX)    <= rforce0_freqdet_int(3);
rxdprioout_phy_ch3(rforce1_freqdet_DP_RX_IDX)    <= rforce1_freqdet_int(3);
rxdprioout_phy_ch3(rbytordpad_DP_RX_IDX_9  DOWNTO  rbytordpad_DP_RX_IDX_0) <= rbytordpad_ch3_int;

-- passing reconfig_clk to RX ADCE
rxdprioout_phy_ch0(reconfig_clk_DP_RX_IDX) <= mdc;
rxdprioout_phy_ch1(reconfig_clk_DP_RX_IDX) <= mdc;
rxdprioout_phy_ch2(reconfig_clk_DP_RX_IDX) <= mdc;
rxdprioout_phy_ch3(reconfig_clk_DP_RX_IDX) <= mdc;

-- pcs_ctrl out to add - make sure ended with _int

--------------------------------------------------------------------------------
-- mqmap end                                                                 --
--------------------------------------------------------------------------------

-- XGXS_STATUS1 and XGXS_STATUS2 status registers
xs_link_status_rd <= '1' WHEN (mdio_rd = '1' AND reg_addr=XGXS_STATUS1) ELSE '0'; 
tx_rx_local_fault_status_rd <= '1' WHEN (mdio_rd = '1' AND reg_addr=XGXS_STATUS2) ELSE '0'; 


-- Output data
-- PCS channel0 output
pcs_chnl_0 : stratixiigx_hssi_mdio_pcs_bus_out_mux
				PORT MAP (
			         pcs_ctrl_in1 => pcs_ctrl1_ch0_reg,
			         pcs_ctrl_in2 => pcs_ctrl2_ch0_reg,
			         pcs_ctrl_in3 => pcs_ctrl3_ch0_reg,
			         pcs_ctrl_in4 => pcs_ctrl4_ch0_reg,
			         pcs_ctrl_in5 => pcs_ctrl5_ch0_reg,
			         pcs_ctrl_in6 => pcs_ctrl6_ch0_reg,
			         pcs_ctrl_in7 => pcs_ctrl7_ch0_reg,
			         pcs_ctrl_in8 => pcs_ctrl8_ch0_reg,
			         pcs_ctrl_in9 => pcs_ctrl9_ch0_reg,
			         pcs_ctrl_in10 => pcs_ctrl10_ch0_reg,
			         pcs_ctrl_in11 => pcs_ctrl11_ch0_reg,
			         pcs_ctrl_in12 => pcs_ctrl12_ch0_reg,
			         pcs_ctrl_in13 => pcs_ctrl13_ch0_reg,
			         pcs_ctrl_in14 => pcs_ctrl14_ch0_reg,
			         pcs_ctrl_in15 => pcs_ctrl15_ch0_reg,
			         pcs_ctrl_in16 => prbs_bist_ctrl_ch0_reg,
			         hw_address_ctrl_in1 => PCS_CTRL1_CH0,
			         hw_address_ctrl_in2 => PCS_CTRL2_CH0,
			         hw_address_ctrl_in3 => PCS_CTRL3_CH0,
			         hw_address_ctrl_in4 => PCS_CTRL4_CH0,
			         hw_address_ctrl_in5 => PCS_CTRL5_CH0,
			         hw_address_ctrl_in6 => PCS_CTRL6_CH0,
			         hw_address_ctrl_in7 => PCS_CTRL7_CH0,
			         hw_address_ctrl_in8 => PCS_CTRL8_CH0,
			         hw_address_ctrl_in9 => PCS_CTRL9_CH0,
			         hw_address_ctrl_in10 => PCS_CTRL10_CH0,
			         hw_address_ctrl_in11 => PCS_CTRL11_CH0,
			         hw_address_ctrl_in12 => PCS_CTRL12_CH0,
			         hw_address_ctrl_in13 => PCS_CTRL13_CH0,
			         hw_address_ctrl_in14 => PCS_CTRL14_CH0,
			         hw_address_ctrl_in15 => PCS_CTRL15_CH0,
			         hw_address_ctrl_in16 => PRBS_BIST_CTRL_CH0,
			         reg_addr => reg_addr,
			         pcs_ctrl_out => pcs_ctrl_out_ch0
				);

-- PCS channel1 output
pcs_chnl_1 : stratixiigx_hssi_mdio_pcs_bus_out_mux
				PORT MAP (
			         pcs_ctrl_in1 => pcs_ctrl1_ch1_reg,
			         pcs_ctrl_in2 => pcs_ctrl2_ch1_reg,
			         pcs_ctrl_in3 => pcs_ctrl3_ch1_reg,
			         pcs_ctrl_in4 => pcs_ctrl4_ch1_reg,
			         pcs_ctrl_in5 => pcs_ctrl5_ch1_reg,
			         pcs_ctrl_in6 => pcs_ctrl6_ch1_reg,
			         pcs_ctrl_in7 => pcs_ctrl7_ch1_reg,
			         pcs_ctrl_in8 => pcs_ctrl8_ch1_reg,
			         pcs_ctrl_in9 => pcs_ctrl9_ch1_reg,
			         pcs_ctrl_in10 => pcs_ctrl10_ch1_reg,
			         pcs_ctrl_in11 => pcs_ctrl11_ch1_reg,
			         pcs_ctrl_in12 => pcs_ctrl12_ch1_reg,
			         pcs_ctrl_in13 => pcs_ctrl13_ch1_reg,
			         pcs_ctrl_in14 => pcs_ctrl14_ch1_reg,
			         pcs_ctrl_in15 => pcs_ctrl15_ch1_reg,
			         pcs_ctrl_in16 => prbs_bist_ctrl_ch1_reg,
			         hw_address_ctrl_in1 => PCS_CTRL1_CH1,
			         hw_address_ctrl_in2 => PCS_CTRL2_CH1,
			         hw_address_ctrl_in3 => PCS_CTRL3_CH1,
			         hw_address_ctrl_in4 => PCS_CTRL4_CH1,
			         hw_address_ctrl_in5 => PCS_CTRL5_CH1,
			         hw_address_ctrl_in6 => PCS_CTRL6_CH1,
			         hw_address_ctrl_in7 => PCS_CTRL7_CH1,
			         hw_address_ctrl_in8 => PCS_CTRL8_CH1,
			         hw_address_ctrl_in9 => PCS_CTRL9_CH1,
			         hw_address_ctrl_in10 => PCS_CTRL10_CH1,
			         hw_address_ctrl_in11 => PCS_CTRL11_CH1,
			         hw_address_ctrl_in12 => PCS_CTRL12_CH1,
			         hw_address_ctrl_in13 => PCS_CTRL13_CH1,
			         hw_address_ctrl_in14 => PCS_CTRL14_CH1,
			         hw_address_ctrl_in15 => PCS_CTRL15_CH1,
			         hw_address_ctrl_in16 => PRBS_BIST_CTRL_CH1,
			         reg_addr => reg_addr,
			         pcs_ctrl_out => pcs_ctrl_out_ch1
				);

-- PCS channel2 output
pcs_chnl_2 : stratixiigx_hssi_mdio_pcs_bus_out_mux
				PORT MAP ( 
			         pcs_ctrl_in1 => pcs_ctrl1_ch2_reg,
			         pcs_ctrl_in2 => pcs_ctrl2_ch2_reg,
			         pcs_ctrl_in3 => pcs_ctrl3_ch2_reg,
			         pcs_ctrl_in4 => pcs_ctrl4_ch2_reg,
			         pcs_ctrl_in5 => pcs_ctrl5_ch2_reg,
			         pcs_ctrl_in6 => pcs_ctrl6_ch2_reg,
			         pcs_ctrl_in7 => pcs_ctrl7_ch2_reg,
			         pcs_ctrl_in8 => pcs_ctrl8_ch2_reg,
			         pcs_ctrl_in9 => pcs_ctrl9_ch2_reg,
			         pcs_ctrl_in10 => pcs_ctrl10_ch2_reg,
			         pcs_ctrl_in11 => pcs_ctrl11_ch2_reg,
			         pcs_ctrl_in12 => pcs_ctrl12_ch2_reg,
			         pcs_ctrl_in13 => pcs_ctrl13_ch2_reg,
			         pcs_ctrl_in14 => pcs_ctrl14_ch2_reg,
			         pcs_ctrl_in15 => pcs_ctrl15_ch2_reg,
			         pcs_ctrl_in16 => prbs_bist_ctrl_ch2_reg,
			         hw_address_ctrl_in1 => PCS_CTRL1_CH2,
			         hw_address_ctrl_in2 => PCS_CTRL2_CH2,
			         hw_address_ctrl_in3 => PCS_CTRL3_CH2,
			         hw_address_ctrl_in4 => PCS_CTRL4_CH2,
			         hw_address_ctrl_in5 => PCS_CTRL5_CH2,
			         hw_address_ctrl_in6 => PCS_CTRL6_CH2,
			         hw_address_ctrl_in7 => PCS_CTRL7_CH2,
			         hw_address_ctrl_in8 => PCS_CTRL8_CH2,
			         hw_address_ctrl_in9 => PCS_CTRL9_CH2,
			         hw_address_ctrl_in10 => PCS_CTRL10_CH2,
			         hw_address_ctrl_in11 => PCS_CTRL11_CH2,
			         hw_address_ctrl_in12 => PCS_CTRL12_CH2,
			         hw_address_ctrl_in13 => PCS_CTRL13_CH2,
			         hw_address_ctrl_in14 => PCS_CTRL14_CH2,
			         hw_address_ctrl_in15 => PCS_CTRL15_CH2,
			         hw_address_ctrl_in16 => PRBS_BIST_CTRL_CH2,
			         reg_addr => reg_addr,
			         pcs_ctrl_out => pcs_ctrl_out_ch2
				);

-- PCS channel3 output
pcs_chnl_3 : stratixiigx_hssi_mdio_pcs_bus_out_mux
				PORT MAP ( 
			         pcs_ctrl_in1 => pcs_ctrl1_ch3_reg,
			         pcs_ctrl_in2 => pcs_ctrl2_ch3_reg,
			         pcs_ctrl_in3 => pcs_ctrl3_ch3_reg,
			         pcs_ctrl_in4 => pcs_ctrl4_ch3_reg,
			         pcs_ctrl_in5 => pcs_ctrl5_ch3_reg,
			         pcs_ctrl_in6 => pcs_ctrl6_ch3_reg,
			         pcs_ctrl_in7 => pcs_ctrl7_ch3_reg,
			         pcs_ctrl_in8 => pcs_ctrl8_ch3_reg,
			         pcs_ctrl_in9 => pcs_ctrl9_ch3_reg,
			         pcs_ctrl_in10 => pcs_ctrl10_ch3_reg,
			         pcs_ctrl_in11 => pcs_ctrl11_ch3_reg,
			         pcs_ctrl_in12 => pcs_ctrl12_ch3_reg,
			         pcs_ctrl_in13 => pcs_ctrl13_ch3_reg,
			         pcs_ctrl_in14 => pcs_ctrl14_ch3_reg,
			         pcs_ctrl_in15 => pcs_ctrl15_ch3_reg,
			         pcs_ctrl_in16 => prbs_bist_ctrl_ch3_reg,
			         hw_address_ctrl_in1 => PCS_CTRL1_CH3,
			         hw_address_ctrl_in2 => PCS_CTRL2_CH3,
			         hw_address_ctrl_in3 => PCS_CTRL3_CH3,
			         hw_address_ctrl_in4 => PCS_CTRL4_CH3,
			         hw_address_ctrl_in5 => PCS_CTRL5_CH3,
			         hw_address_ctrl_in6 => PCS_CTRL6_CH3,
			         hw_address_ctrl_in7 => PCS_CTRL7_CH3,
			         hw_address_ctrl_in8 => PCS_CTRL8_CH3,
			         hw_address_ctrl_in9 => PCS_CTRL9_CH3,
			         hw_address_ctrl_in10 => PCS_CTRL10_CH3,
			         hw_address_ctrl_in11 => PCS_CTRL11_CH3,
			         hw_address_ctrl_in12 => PCS_CTRL12_CH3,
			         hw_address_ctrl_in13 => PCS_CTRL13_CH3,
			         hw_address_ctrl_in14 => PCS_CTRL14_CH3,
			         hw_address_ctrl_in15 => PCS_CTRL15_CH3,
			         hw_address_ctrl_in16 => PRBS_BIST_CTRL_CH3,
			         reg_addr => reg_addr,
			         pcs_ctrl_out => pcs_ctrl_out_ch3
				);

mbus_out <=	xgxs_ctrl_reg         WHEN  (reg_addr = XGXS_CTRL)           ELSE
			xgxs_stat1_reg        WHEN  (reg_addr = XGXS_STATUS1)        ELSE
			xgxs_stat2_reg        WHEN  (reg_addr = XGXS_STATUS2)        ELSE
			xgxs_lane_stat_reg    WHEN  (reg_addr = XGXS_LANE_STATUS)    ELSE
			trunking_mode_reg     WHEN  (reg_addr = TRUNKING_MODE)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL1_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL1_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL1_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL1_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL2_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL2_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL2_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL2_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL3_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL3_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL3_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL3_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL4_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL4_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL4_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL4_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL5_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL5_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL5_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL5_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL6_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL6_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL6_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL6_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL7_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL7_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL7_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL7_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL8_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL8_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL8_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL8_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PRBS_BIST_CTRL_CH0)  ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PRBS_BIST_CTRL_CH1)  ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PRBS_BIST_CTRL_CH2)  ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PRBS_BIST_CTRL_CH3)  ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL9_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL9_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL9_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL9_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL10_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL10_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL10_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL10_CH3)      ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL11_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL11_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL11_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL11_CH3)      ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL12_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL12_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL12_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL12_CH3)      ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL13_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL13_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL13_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL13_CH3)      ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL14_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL14_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL14_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL14_CH3)      ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL15_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL15_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL15_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL15_CH3)      ELSE
			pcs_global_ctrl0_reg  WHEN  (reg_addr = PCS_GLOBAL_CTRL0)    ELSE
			pcs_global_ctrl1_reg  WHEN  (reg_addr = PCS_GLOBAL_CTRL1)    ELSE
			pcs_global_ctrl2_reg  WHEN  (reg_addr = PCS_GLOBAL_CTRL2)    ELSE
			pma_ctrl1_ch0_reg     WHEN  (reg_addr = PMA_CTRL1_CH0)       ELSE
			pma_ctrl1_ch1_reg     WHEN  (reg_addr = PMA_CTRL1_CH1)       ELSE
			pma_ctrl1_ch2_reg     WHEN  (reg_addr = PMA_CTRL1_CH2)       ELSE
			pma_ctrl1_ch3_reg     WHEN  (reg_addr = PMA_CTRL1_CH3)       ELSE
			pma_ctrl2_ch0_reg     WHEN  (reg_addr = PMA_CTRL2_CH0)       ELSE
			pma_ctrl2_ch1_reg     WHEN  (reg_addr = PMA_CTRL2_CH1)       ELSE
			pma_ctrl2_ch2_reg     WHEN  (reg_addr = PMA_CTRL2_CH2)       ELSE
			pma_ctrl2_ch3_reg     WHEN  (reg_addr = PMA_CTRL2_CH3)       ELSE
			pma_ctrl3_ch0_reg     WHEN  (reg_addr = PMA_CTRL3_CH0)       ELSE
			pma_ctrl3_ch1_reg     WHEN  (reg_addr = PMA_CTRL3_CH1)       ELSE
			pma_ctrl3_ch2_reg     WHEN  (reg_addr = PMA_CTRL3_CH2)       ELSE
			pma_ctrl3_ch3_reg     WHEN  (reg_addr = PMA_CTRL3_CH3)       ELSE
			pma_ctrl4_ch0_reg     WHEN  (reg_addr = PMA_CTRL4_CH0)       ELSE
			pma_ctrl4_ch1_reg     WHEN  (reg_addr = PMA_CTRL4_CH1)       ELSE
			pma_ctrl4_ch2_reg     WHEN  (reg_addr = PMA_CTRL4_CH2)       ELSE
			pma_ctrl4_ch3_reg     WHEN  (reg_addr = PMA_CTRL4_CH3)       ELSE
			pma_ctrl5_ch0_reg     WHEN  (reg_addr = PMA_CTRL5_CH0)       ELSE
			pma_ctrl5_ch1_reg     WHEN  (reg_addr = PMA_CTRL5_CH1)       ELSE
			pma_ctrl5_ch2_reg     WHEN  (reg_addr = PMA_CTRL5_CH2)       ELSE
			pma_ctrl5_ch3_reg     WHEN  (reg_addr = PMA_CTRL5_CH3)       ELSE
			pma_ctrl6_ch0_reg     WHEN  (reg_addr = PMA_CTRL6_CH0)       ELSE
			pma_ctrl6_ch1_reg     WHEN  (reg_addr = PMA_CTRL6_CH1)       ELSE
			pma_ctrl6_ch2_reg     WHEN  (reg_addr = PMA_CTRL6_CH2)       ELSE
			pma_ctrl6_ch3_reg     WHEN  (reg_addr = PMA_CTRL6_CH3)       ELSE
			pma_ctrl7_ch0_reg     WHEN  (reg_addr = PMA_CTRL7_CH0)       ELSE
			pma_ctrl7_ch1_reg     WHEN  (reg_addr = PMA_CTRL7_CH1)       ELSE
			pma_ctrl7_ch2_reg     WHEN  (reg_addr = PMA_CTRL7_CH2)       ELSE
			pma_ctrl7_ch3_reg     WHEN  (reg_addr = PMA_CTRL7_CH3)       ELSE
			pma_ctrl8_ch0_reg     WHEN  (reg_addr = PMA_CTRL8_CH0)       ELSE
			pma_ctrl8_ch1_reg     WHEN  (reg_addr = PMA_CTRL8_CH1)       ELSE
			pma_ctrl8_ch2_reg     WHEN  (reg_addr = PMA_CTRL8_CH2)       ELSE
			pma_ctrl8_ch3_reg     WHEN  (reg_addr = PMA_CTRL8_CH3)       ELSE
			pma_ctrl9_ch0_reg     WHEN  (reg_addr = PMA_CTRL9_CH0)       ELSE
			pma_ctrl9_ch1_reg     WHEN  (reg_addr = PMA_CTRL9_CH1)       ELSE
			pma_ctrl9_ch2_reg     WHEN  (reg_addr = PMA_CTRL9_CH2)       ELSE
			pma_ctrl9_ch3_reg     WHEN  (reg_addr = PMA_CTRL9_CH3)       ELSE
			pma_ctrl10_ch0_reg    WHEN  (reg_addr = PMA_CTRL10_CH0)      ELSE
			pma_ctrl10_ch1_reg    WHEN  (reg_addr = PMA_CTRL10_CH1)      ELSE
			pma_ctrl10_ch2_reg    WHEN  (reg_addr = PMA_CTRL10_CH2)      ELSE
			pma_ctrl10_ch3_reg    WHEN  (reg_addr = PMA_CTRL10_CH3)      ELSE
			pma_ctrl11_ch0_reg    WHEN  (reg_addr = PMA_CTRL11_CH0)      ELSE
			pma_ctrl11_ch1_reg    WHEN  (reg_addr = PMA_CTRL11_CH1)      ELSE
			pma_ctrl11_ch2_reg    WHEN  (reg_addr = PMA_CTRL11_CH2)      ELSE
			pma_ctrl11_ch3_reg    WHEN  (reg_addr = PMA_CTRL11_CH3)      ELSE
			pma_global_ctrl0_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL0)    ELSE
			pma_global_ctrl1_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL1)    ELSE
			pma_global_ctrl2_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL2)    ELSE
			pma_global_ctrl3_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL3)    ELSE
			pma_global_ctrl4_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL4)    ELSE
			pma_global_ctrl5_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL5)    ELSE
			pma_global_ctrl6_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL6)    ELSE
			pma_global_ctrl7_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL7)    ELSE
			pma_global_ctrl8_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL8)    ELSE
			pma_global_ctrl9_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL9)    ELSE
			"0000000000000000";


-- EXTERNAL INPUTS FOR CONTROL REGISTERS

xgxs_ctrl_ext <= '0' & rs_lpbk_all & "00" & rpowerdown & "00000000000";

--************************************************************************************
-- Status registers
local_fault        <= '1' WHEN (tx_local_fault <= '1' OR rx_local_fault <= '1') ELSE '0';
xgxs_stat1_reg     <= "00000000" & local_fault & "0000" & xs_link_status & "10";
xs_tx_local_fault  <= tx_local_fault WHEN (dev_addr_0 <= '1') ELSE rx_local_fault ;
xs_rx_local_fault  <= rx_local_fault WHEN (dev_addr_0 <= '1') ELSE tx_local_fault ;
xgxs_stat2_reg     <= "1000" & xs_rx_local_fault & xs_tx_local_fault & "0000000000";
xgxs_lane_stat_reg <= "000" & align_status & "11000000" & sync_status;
-- ***********************************************************************************

-- PCS CRAMs
trunking_mode_ext <= '0' & rphfifo_master_sel_tx & rphfifo_master_sel_rx & 
                             rendec_data_sel_tx & rendec_data_sel_rx & rnenbpin & rpllurst & 
                             rreset & rrsvd_cmu & rdeskewen & rindv_tx & rindv_rx;

pcs_ctrl1_ch0_ext <= rtx_pipe_enable(0) & rrx_pipe_enable(0) & rpowdnr(0) & rpowdnt(0) &
                             rendec_tx(0) & rendec_rx(0) & r8b10b_enc_ibm_en(0) & rmatchen(0) &
                             r8b10b_dec_ibm_en_ch0 & rforce_kchar(0) & rforce_echar(0) &
                             rlp20ben(0) & rgenericfifo(0) & rcascaded_8b10b_en_tx(0) &
                             rcascaded_8b10b_en_rx(0);
pcs_ctrl1_ch1_ext <= rtx_pipe_enable(1) & rrx_pipe_enable(1) & rpowdnr(1) & rpowdnt(1) &
                             rendec_tx(1) & rendec_rx(1) & r8b10b_enc_ibm_en(1) & rmatchen(1) &
                             r8b10b_dec_ibm_en_ch1 & rforce_kchar(1) & rforce_echar(1) &
                             rlp20ben(1) & rgenericfifo(1) & rcascaded_8b10b_en_tx(1) &
                             rcascaded_8b10b_en_rx(1);
pcs_ctrl1_ch2_ext <= rtx_pipe_enable(2) & rrx_pipe_enable(2) & rpowdnr(2) & rpowdnt(2) &
                             rendec_tx(2) & rendec_rx(2) & r8b10b_enc_ibm_en(2) & rmatchen(2) &
                             r8b10b_dec_ibm_en_ch2 & rforce_kchar(2) & rforce_echar(2) &
                             rlp20ben(2) & rgenericfifo(2) & rcascaded_8b10b_en_tx(2) &
                             rcascaded_8b10b_en_rx(2);
pcs_ctrl1_ch3_ext <= rtx_pipe_enable(3) & rrx_pipe_enable(3) & rpowdnr(3) & rpowdnt(3) &
                             rendec_tx(3) & rendec_rx(3) & r8b10b_enc_ibm_en(3) & rmatchen(3) &
                             r8b10b_dec_ibm_en_ch3 & rforce_kchar(3) & rforce_echar(3) &
                             rlp20ben(3) & rgenericfifo(3) & rcascaded_8b10b_en_tx(3) &
                             rcascaded_8b10b_en_rx(3);

pcs_ctrl2_ch0_ext <= resync_badcg_en_ch0 & rencdt_rising(0) & rdis_rx_disp(0) &
                             rcomp_pat_porn(0) & rcomp_size_ch0 & rcomp_pat_ch0(39 DOWNTO 32);
pcs_ctrl2_ch1_ext <= resync_badcg_en_ch1 & rencdt_rising(1) & rdis_rx_disp(1) &
                             rcomp_pat_porn(1) & rcomp_size_ch1 & rcomp_pat_ch1(39 DOWNTO 32);                             
pcs_ctrl2_ch2_ext <= resync_badcg_en_ch2 & rencdt_rising(2) & rdis_rx_disp(2) &
                             rcomp_pat_porn(2) & rcomp_size_ch2 & rcomp_pat_ch2(39 DOWNTO 32);
pcs_ctrl2_ch3_ext <= resync_badcg_en_ch3 & rencdt_rising(3) & rdis_rx_disp(3) &
                             rcomp_pat_porn(3) & rcomp_size_ch3 & rcomp_pat_ch3(39 DOWNTO 32);

pcs_ctrl3_ch0_ext <= rcomp_pat_ch0(31 DOWNTO 16);
pcs_ctrl3_ch1_ext <= rcomp_pat_ch1(31 DOWNTO 16);
pcs_ctrl3_ch2_ext <= rcomp_pat_ch2(31 DOWNTO 16);
pcs_ctrl3_ch3_ext <= rcomp_pat_ch3(31 DOWNTO 16);

pcs_ctrl4_ch0_ext <= rcomp_pat_ch0(15 DOWNTO 0);
pcs_ctrl4_ch1_ext <= rcomp_pat_ch1(15 DOWNTO 0);
pcs_ctrl4_ch2_ext <= rcomp_pat_ch2(15 DOWNTO 0);
pcs_ctrl4_ch3_ext <= rcomp_pat_ch3(15 DOWNTO 0);

pcs_ctrl5_ch0_ext <= rrxfifo_dis(0) & rtxfifo_dis(0) & rib_force_disp(0) &
                            rrundisp_ch0 & rtxfifo_lowlatency_en(0) & rrlv_en(0) & rautobtalg_dis(0) &
                             rsync_sm_dis(0) & rib_inv_cd_ch0 & rrxfifo_lowlatency_en(0);
pcs_ctrl5_ch1_ext <= rrxfifo_dis(1) & rtxfifo_dis(1) & rib_force_disp(1) &
                             rrundisp_ch1 & rtxfifo_lowlatency_en(1) & rrlv_en(1) & rautobtalg_dis(1) &
                             rsync_sm_dis(1) & rib_inv_cd_ch1 & rrxfifo_lowlatency_en(1);
pcs_ctrl5_ch2_ext <= rrxfifo_dis(2) & rtxfifo_dis(2) & rib_force_disp(2) &
                             rrundisp_ch2 & rtxfifo_lowlatency_en(2) & rrlv_en(2) & rautobtalg_dis(2) &
                             rsync_sm_dis(2) & rib_inv_cd_ch2 & rrxfifo_lowlatency_en(2);
pcs_ctrl5_ch3_ext <= rrxfifo_dis(3) & rtxfifo_dis(3) & rib_force_disp(3) &
                             rrundisp_ch3 & rtxfifo_lowlatency_en(3) & rrlv_en(3) & rautobtalg_dis(3) &
                             rsync_sm_dis(3) & rib_inv_cd_ch3 & rrxfifo_lowlatency_en(3);

pcs_ctrl6_ch0_ext <= rdwidth_tx(0) & rdwidth_rx(0) & rge_xaui_tx(0) &
                             rrx_detect_bypass(0) & rtxurstpcs(0) & rrxurstpcs(0) &
                             rrsvd_tx_ch0 & rskpsetbased(0) & rtruebac2bac(0) &rrsvd_rx_ch0;
pcs_ctrl6_ch1_ext <= rdwidth_tx(1) & rdwidth_rx(1) & rge_xaui_tx(1) &
                             rrx_detect_bypass(1) & rtxurstpcs(1) & rrxurstpcs(1) &
                             rrsvd_tx_ch1 & rskpsetbased(1) & rtruebac2bac(1) &rrsvd_rx_ch1;
pcs_ctrl6_ch2_ext <= rdwidth_tx(2) & rdwidth_rx(2) & rge_xaui_tx(2) &
                             rrx_detect_bypass(2) & rtxurstpcs(2) & rrxurstpcs(2) &
                             rrsvd_tx_ch2 & rskpsetbased(2) & rtruebac2bac(2) &rrsvd_rx_ch2;
pcs_ctrl6_ch3_ext <= rdwidth_tx(3) & rdwidth_rx(3) & rge_xaui_tx(3) &
                             rrx_detect_bypass(3) & rtxurstpcs(3) & rrxurstpcs(3) &
                             rrsvd_tx_ch3 & rskpsetbased(3) & rtruebac2bac(3) &rrsvd_rx_ch3;

pcs_ctrl7_ch0_ext <= rgnumber_ch0 & rknumber_ch0;
pcs_ctrl7_ch1_ext <= rgnumber_ch1 & rknumber_ch1;
pcs_ctrl7_ch2_ext <= rgnumber_ch2 & rknumber_ch2;
pcs_ctrl7_ch3_ext <= rgnumber_ch3 & rknumber_ch3;

pcs_ctrl8_ch0_ext <= rfreerun_tx(0) & rtxwrclksel(0) & rtxrdclksel(0) &
                             rfreerun_rx(0) & rrcvd_clk_sel_ch0 & 
                             rclk_1_sel_ch0 & rclk_2_sel_ch0 & rrx_rd_clk_sel(0) & 
                             renumber_ch0 & renpolinv_rx(0) & rclkcmpinsertpad(0);
pcs_ctrl8_ch1_ext <= rfreerun_tx(1) & rtxwrclksel(1) & rtxrdclksel(1) &
                             rfreerun_rx(1) & rrcvd_clk_sel_ch1 & 
                             rclk_1_sel_ch1 & rclk_2_sel_ch1 & rrx_rd_clk_sel(1) & 
                             renumber_ch1 & renpolinv_rx(1) & rclkcmpinsertpad(1);
pcs_ctrl8_ch2_ext <= rfreerun_tx(2) & rtxwrclksel(2) & rtxrdclksel(2) &
                             rfreerun_rx(2) & rrcvd_clk_sel_ch2 & 
                             rclk_1_sel_ch2 & rclk_2_sel_ch2 & rrx_rd_clk_sel(2) & 
                             renumber_ch2 & renpolinv_rx(2) & rclkcmpinsertpad(2);
pcs_ctrl8_ch3_ext <= rfreerun_tx(3) & rtxwrclksel(3) & rtxrdclksel(3) &
                             rfreerun_rx(3) & rrcvd_clk_sel_ch3 & 
                             rclk_1_sel_ch3 & rclk_2_sel_ch3 & rrx_rd_clk_sel(3) & 
                             renumber_ch3 & renpolinv_rx(3) & rclkcmpinsertpad(3);

prbs_bist_ctrl_ch0_ext <= rprbsen_tx(0) & rprbsen_rx(0) & rprbs_clr_rslt_rx(0) &
                                  rprbs_sel_ch0 & rbisten_tx(0) & rbisten_rx(0) &
                                  rbist_clr_rx(0) & rbist_sel_ch0 &
                                  rcxpat_chnl_en_ch0 & rall_one_dect_only(0) & "00";
prbs_bist_ctrl_ch1_ext <= rprbsen_tx(1) & rprbsen_rx(1) & rprbs_clr_rslt_rx(1) &
                                  rprbs_sel_ch1 & rbisten_tx(1) & rbisten_rx(1) &
                                  rbist_clr_rx(1) & rbist_sel_ch1 &
                                  rcxpat_chnl_en_ch1 & rall_one_dect_only(1) & "00";
prbs_bist_ctrl_ch2_ext <= rprbsen_tx(2) & rprbsen_rx(2) & rprbs_clr_rslt_rx(2) &
                                  rprbs_sel_ch2 & rbisten_tx(2) & rbisten_rx(2) &
                                  rbist_clr_rx(2) & rbist_sel_ch2 &
                                  rcxpat_chnl_en_ch2 & rall_one_dect_only(2) & "00";
prbs_bist_ctrl_ch3_ext <= rprbsen_tx(3) & rprbsen_rx(3) & rprbs_clr_rslt_rx(3) &
                                  rprbs_sel_ch3 & rbisten_tx(3) & rbisten_rx(3) &
                                  rbist_clr_rx(3) & rbist_sel_ch3 &
                                  rcxpat_chnl_en_ch3 & rall_one_dect_only(3) & "00";

pcs_ctrl9_ch0_ext <= rppm_cnt_reset(0) & rphfifourstrx(0) & rcmpfifourst(0) & rtx_idle_delay_ch0 & 
                             rclkcmpsqmd(0) & rclkcmpsq1p_ch0(9 DOWNTO 0);
pcs_ctrl9_ch1_ext <= rppm_cnt_reset(1) & rphfifourstrx(1) & rcmpfifourst(1) & rtx_idle_delay_ch1 & 
                             rclkcmpsqmd(1) & rclkcmpsq1p_ch1(9 DOWNTO 0);
pcs_ctrl9_ch2_ext <= rppm_cnt_reset(2) & rphfifourstrx(2) & rcmpfifourst(2) & rtx_idle_delay_ch2 & 
                             rclkcmpsqmd(2) & rclkcmpsq1p_ch2(9 DOWNTO 0);
pcs_ctrl9_ch3_ext <= rppm_cnt_reset(3) & rphfifourstrx(3) & rcmpfifourst(3) & rtx_idle_delay_ch3 & 
                             rclkcmpsqmd(3) & rclkcmpsq1p_ch3(9 DOWNTO 0);

pcs_ctrl10_ch0_ext <= rclkcmpsq1n_ch0(19 DOWNTO 15) & rclkcmppos(0) & rclkcmpsq1p_ch0(19 DOWNTO 10);
pcs_ctrl10_ch1_ext <= rclkcmpsq1n_ch1(19 DOWNTO 15) & rclkcmppos(1) & rclkcmpsq1p_ch1(19 DOWNTO 10);
pcs_ctrl10_ch2_ext <= rclkcmpsq1n_ch2(19 DOWNTO 15) & rclkcmppos(2) & rclkcmpsq1p_ch2(19 DOWNTO 10);
pcs_ctrl10_ch3_ext <= rclkcmpsq1n_ch3(19 DOWNTO 15) & rclkcmppos(3) & rclkcmpsq1p_ch3(19 DOWNTO 10);

pcs_ctrl11_ch0_ext <= rclkcmpsq1n_ch0(14 DOWNTO 10) & '0' & rclkcmpsq1n_ch0(9 DOWNTO 0);
pcs_ctrl11_ch1_ext <= rclkcmpsq1n_ch1(14 DOWNTO 10) & '0' & rclkcmpsq1n_ch1(9 DOWNTO 0);
pcs_ctrl11_ch2_ext <= rclkcmpsq1n_ch2(14 DOWNTO 10) & '0' & rclkcmpsq1n_ch2(9 DOWNTO 0);
pcs_ctrl11_ch3_ext <= rclkcmpsq1n_ch3(14 DOWNTO 10) & '0' & rclkcmpsq1n_ch3(9 DOWNTO 0);

pcs_ctrl12_ch0_ext <= rrev_loopbk(0) & ralempty_ch0 & ralfull_ch0 & rforce_disp(0) & 
                              rkchar(0) & rosbased(0) & rensymswap_tx(0) & '0' & rosnumber_ch0;
pcs_ctrl12_ch1_ext <= rrev_loopbk(1) & ralempty_ch1 & ralfull_ch1 & rforce_disp(1) &
                              rkchar(1) & rosbased(1) & rensymswap_tx(1) & '0' & rosnumber_ch1;
pcs_ctrl12_ch2_ext <= rrev_loopbk(2) & ralempty_ch2 & ralfull_ch2 & rforce_disp(2) &
                              rkchar(2) & rosbased(2) & rensymswap_tx(2) & '0' & rosnumber_ch2;
pcs_ctrl12_ch3_ext <= rrev_loopbk(3) & ralempty_ch3 & ralfull_ch3 & rforce_disp(3) &
                              rkchar(3) & rosbased(3) & rensymswap_tx(3) & '0' & rosnumber_ch3;

pcs_ctrl13_ch0_ext <= rwa_6g_en(0) & renpolinv_tx(0) & rbitslip_size_ch0 & rbytord_2sym_en(0) &
                              rbysync_polinv_en(0) & rbitloc_rev_en(0) & rbyte_rev_en(0) & renbitrev_tx(0) &
                              rbyteorden_ch0 & rbytordplden(0) & rphfifopldentx(0) & rphfifoursttx(0) &
                              rphfifopldenrx(0) & rautoinsdis(0);
pcs_ctrl13_ch1_ext <= rwa_6g_en(1) & renpolinv_tx(1) & rbitslip_size_ch1 & rbytord_2sym_en(1) &
                              rbysync_polinv_en(1) & rbitloc_rev_en(1) & rbyte_rev_en(1) & renbitrev_tx(1) &
                              rbyteorden_ch1 & rbytordplden(1) & rphfifopldentx(1) & rphfifoursttx(1) &
                              rphfifopldenrx(1) & rautoinsdis(1);
pcs_ctrl13_ch2_ext <= rwa_6g_en(2) & renpolinv_tx(2) & rbitslip_size_ch2 & rbytord_2sym_en(2) &
                              rbysync_polinv_en(2) & rbitloc_rev_en(2) & rbyte_rev_en(2) & renbitrev_tx(2) &
                              rbyteorden_ch2 & rbytordplden(2) & rphfifopldentx(2) & rphfifoursttx(2) &
                              rphfifopldenrx(2) & rautoinsdis(2);
pcs_ctrl13_ch3_ext <= rwa_6g_en(3) & renpolinv_tx(3) & rbitslip_size_ch3 & rbytord_2sym_en(3) &
                              rbysync_polinv_en(3) & rbitloc_rev_en(3) & rbyte_rev_en(3) & renbitrev_tx(3) &
                              rbyteorden_ch3 & rbytordplden(3) & rphfifopldentx(3) & rphfifoursttx(3) &
                              rphfifopldenrx(3) & rautoinsdis(3);

pcs_ctrl14_ch0_ext <= rppmsel_ch0 & rbytordpat_ch0;
pcs_ctrl14_ch1_ext <= rppmsel_ch1 & rbytordpat_ch1;
pcs_ctrl14_ch2_ext <= rppmsel_ch2 & rbytordpat_ch2;
pcs_ctrl14_ch3_ext <= rppmsel_ch3 & rbytordpat_ch3;

pcs_ctrl15_ch0_ext <= rtest_bus_sel_ch0 & rforce_sig_det_pcs(0) & rforce0_freqdet(0) & 
                              rforce1_freqdet(0) & rbytordpad_ch0;
pcs_ctrl15_ch1_ext <= rtest_bus_sel_ch1 & rforce_sig_det_pcs(1) & rforce0_freqdet(1) & 
                              rforce1_freqdet(1) & rbytordpad_ch1;
pcs_ctrl15_ch2_ext <= rtest_bus_sel_ch2 & rforce_sig_det_pcs(2) & rforce0_freqdet(2) & 
                              rforce1_freqdet(2) & rbytordpad_ch2;
pcs_ctrl15_ch3_ext <= rtest_bus_sel_ch3 & rforce_sig_det_pcs(3) & rforce0_freqdet(3) & 
                              rforce1_freqdet(3) & rbytordpad_ch3;

pcs_global_ctrl0_ext <= "000000000" & ralgnect & ralgngct & ralgnact;
pcs_global_ctrl1_ext <= rfreerun_centrl & rcentrl_clk_sel & "00" & rrefclk_out_div2 & rdskposdisp & rdskchrp;
pcs_global_ctrl2_ext <= "00" & ralgnopt & rtest_bus_centrl_sel & "0000000000";

-- Analog CRAMs
pma_ctrl1_ch0_ext <= rtx_vod_sel_ch0 & rtx_slewrate(0) & rpmphs_2tap_ch0 &
                             rpmphs_1tap_ch0 & rtx_vtt_ch0 & rpmphs_ptap_ch0;
pma_ctrl1_ch1_ext <= rtx_vod_sel_ch1 & rtx_slewrate(1) & rpmphs_2tap_ch1 &
                             rpmphs_1tap_ch1 & rtx_vtt_ch1 & rpmphs_ptap_ch1;
pma_ctrl1_ch2_ext <= rtx_vod_sel_ch2 & rtx_slewrate(2) & rpmphs_2tap_ch2 &
                            rpmphs_1tap_ch2 & rtx_vtt_ch2 & rpmphs_ptap_ch2;
pma_ctrl1_ch3_ext <= rtx_vod_sel_ch3 & rtx_slewrate(3) & rpmphs_2tap_ch3 &
                             rpmphs_1tap_ch3 & rtx_vtt_ch3 & rpmphs_ptap_ch3;

pma_ctrl2_ch0_ext <= rtx_term_ch0 & r_tx_det_rx_ch0 & rrx_term_ch0 & rforce_sigdet(0) &
                             rrx_dc_couple(0) & rrx_eq_dc_ch0 & rrx_vtt_ch0 & rrx_sloslv_ch0;
pma_ctrl2_ch1_ext <= rtx_term_ch1 & r_tx_det_rx_ch1 & rrx_term_ch1 & rforce_sigdet(1) &
                             rrx_dc_couple(1) & rrx_eq_dc_ch1 & rrx_vtt_ch1 & rrx_sloslv_ch1;
pma_ctrl2_ch2_ext <= rtx_term_ch2 & r_tx_det_rx_ch2 & rrx_term_ch2 & rforce_sigdet(2) &
                             rrx_dc_couple(2) & rrx_eq_dc_ch2 & rrx_vtt_ch2 & rrx_sloslv_ch2;
pma_ctrl2_ch3_ext <= rtx_term_ch3 & r_tx_det_rx_ch3 & rrx_term_ch3 & rforce_sigdet(3) &
                             rrx_dc_couple(3) & rrx_eq_dc_ch3 & rrx_vtt_ch3 & rrx_sloslv_ch3;
                             
 pma_ctrl3_ch0_ext <= reqa_ct_ch0 & reqb_ct_ch0 & reqc_ct_ch0 & reqd_ct_ch0 & req_ctv_ch0 & '0';
 pma_ctrl3_ch1_ext <= reqa_ct_ch1 & reqb_ct_ch1 & reqc_ct_ch1 & reqd_ct_ch1 & req_ctv_ch1 & '0';
 pma_ctrl3_ch2_ext <= reqa_ct_ch2 & reqb_ct_ch2 & reqc_ct_ch2 & reqd_ct_ch2 & req_ctv_ch2 & '0';
 pma_ctrl3_ch3_ext <= reqa_ct_ch3 & reqb_ct_ch3 & reqc_ct_ch3 & reqd_ct_ch3 & req_ctv_ch3 & '0';

 pma_ctrl4_ch0_ext <= rpmadwidth_tx(0) & rpma_doublewidth_tx(0) & rtx_cmu_sel(0) &
                             rtx_m_sel_ch0 & rtxvcobypass(0) & rtx_cgb_1x_en(0) & rtx_cgb_4x_en(0) &
                             rtx_4x_sw(0) & rpmadwidth_rx(0) & rpma_doublewidth_rx(0) &
                             rrxvcobypass(0) &rrect_adj_ch0 & rrx_piso_bypass_ch0;
 pma_ctrl4_ch1_ext <= rpmadwidth_tx(1) & rpma_doublewidth_tx(1) & rtx_cmu_sel(1) &
                             rtx_m_sel_ch1 & rtxvcobypass(1) & rtx_cgb_1x_en(1) & rtx_cgb_4x_en(1) &
                             rtx_4x_sw(1) & rpmadwidth_rx(1) & rpma_doublewidth_rx(1) &
                             rrxvcobypass(1) &rrect_adj_ch1 & rrx_piso_bypass_ch1;
 pma_ctrl4_ch2_ext <= rpmadwidth_tx(2) & rpma_doublewidth_tx(2) & rtx_cmu_sel(2) &
                             rtx_m_sel_ch2 & rtxvcobypass(2) & rtx_cgb_1x_en(2) & rtx_cgb_4x_en(2) &
                             rtx_4x_sw(2) & rpmadwidth_rx(2) & rpma_doublewidth_rx(2) &
                             rrxvcobypass(2) &rrect_adj_ch2 & rrx_piso_bypass_ch2;
 pma_ctrl4_ch3_ext <= rpmadwidth_tx(3) & rpma_doublewidth_tx(3) & rtx_cmu_sel(3) &
                             rtx_m_sel_ch3 & rtxvcobypass(3) & rtx_cgb_1x_en(3) & rtx_cgb_4x_en(3) &
                             rtx_4x_sw(3) & rpmadwidth_rx(3) & rpma_doublewidth_rx(3) &
                             rrxvcobypass(3) &rrect_adj_ch3 & rrx_piso_bypass_ch3;

 pma_ctrl5_ch0_ext <= rlst_tx_ch0 & rlst_rx_ch0 & rlst_rxpll_ch0 & rrx_ignore_phslck(0) &
                             rdc_freq_ch0 & rrx_osc_en(0);
 pma_ctrl5_ch1_ext <= rlst_tx_ch1 & rlst_rx_ch1 & rlst_rxpll_ch1 & rrx_ignore_phslck(1) &
                             rdc_freq_ch1 & rrx_osc_en(1);
 pma_ctrl5_ch2_ext <= rlst_tx_ch2 & rlst_rx_ch2 & rlst_rxpll_ch2 & rrx_ignore_phslck(2) &
                             rdc_freq_ch2 & rrx_osc_en(2);
 pma_ctrl5_ch3_ext <= rlst_tx_ch3 & rlst_rx_ch3 & rlst_rxpll_ch3 & rrx_ignore_phslck(3) &
                             rdc_freq_ch3 & rrx_osc_en(3);

 pma_ctrl6_ch0_ext <= rrefclk_sel_ch0 & rbwctral_rx_ch0 & rrx_cru_m_sel_ch0 & 
                             rrx_cru_div2(0) & rrx_cru_ctl_ch0 & rltr(0) & rltd(0);
 pma_ctrl6_ch1_ext <= rrefclk_sel_ch1 & rbwctral_rx_ch1 & rrx_cru_m_sel_ch1 & 
                             rrx_cru_div2(1) & rrx_cru_ctl_ch1 & rltr(1) & rltd(1);
 pma_ctrl6_ch2_ext <= rrefclk_sel_ch2 & rbwctral_rx_ch2 & rrx_cru_m_sel_ch2 & 
                             rrx_cru_div2(2) & rrx_cru_ctl_ch2 & rltr(2) & rltd(2);
 pma_ctrl6_ch3_ext <= rrefclk_sel_ch3 & rbwctral_rx_ch3 & rrx_cru_m_sel_ch3 & 
                             rrx_cru_div2(3) & rrx_cru_ctl_ch3 & rltr(3) & rltd(3);

 pma_ctrl7_ch0_ext <= risel_rx_ch0 & riupsel_rx_ch0 & ridnsel_rx_ch0 &
                             rtesten_cp_rx(0) & rtristate_cp_rx(0) & rtestupen_cp_rx(0) &
                             rtestdnen_cp_rx(0) & rrx_cru_m_ch0 & rrx_cru_l_ch0;
 pma_ctrl7_ch1_ext <= risel_rx_ch1 & riupsel_rx_ch1 & ridnsel_rx_ch1 &
                             rtesten_cp_rx(1) & rtristate_cp_rx(1) & rtestupen_cp_rx(1) &
                             rtestdnen_cp_rx(1) & rrx_cru_m_ch1 & rrx_cru_l_ch1;
 pma_ctrl7_ch2_ext <= risel_rx_ch2 & riupsel_rx_ch2 & ridnsel_rx_ch2 &
                             rtesten_cp_rx(2) & rtristate_cp_rx(2) & rtestupen_cp_rx(2) &
                             rtestdnen_cp_rx(2) & rrx_cru_m_ch2 & rrx_cru_l_ch2;
 pma_ctrl7_ch3_ext <= risel_rx_ch3 & riupsel_rx_ch3 & ridnsel_rx_ch3 &
                             rtesten_cp_rx(3) & rtristate_cp_rx(3) & rtestupen_cp_rx(3) &
                             rtestdnen_cp_rx(3) & rrx_cru_m_ch3 & rrx_cru_l_ch3;
                             
 pma_ctrl8_ch0_ext <= rs_lpbk(0) & r_rlpbk(0) & rs_rdlpbk(0) & rrx_revlb_sw(0) &
                             rurx_pdb(0) & rtx_cgb_pdb(0) & rtx_ob_pdb(0) & rrx_cru_pdb(0) &
                             rrx_cru_rst(0) & rrx_ib_pdb(0) & rrxurstpma(0) & radce_adapt(0) &
                             radce_pdb(0) & radce_rst(0) & rsig_inv_2tap(0) & rsig_inv_pre(0);
 pma_ctrl8_ch1_ext <= rs_lpbk(1) & r_rlpbk(1) & rs_rdlpbk(1) & rrx_revlb_sw(1) &
                             rurx_pdb(1) & rtx_cgb_pdb(1) & rtx_ob_pdb(1) & rrx_cru_pdb(1) &
                             rrx_cru_rst(1) & rrx_ib_pdb(1) & rrxurstpma(1) & radce_adapt(1) &
                             radce_pdb(1) & radce_rst(1) & rsig_inv_2tap(1) & rsig_inv_pre(1);
 pma_ctrl8_ch2_ext <= rs_lpbk(2) & r_rlpbk(2) & rs_rdlpbk(2) & rrx_revlb_sw(2) &
                             rurx_pdb(2) & rtx_cgb_pdb(2) & rtx_ob_pdb(2) & rrx_cru_pdb(2) &
                             rrx_cru_rst(2) & rrx_ib_pdb(2) & rrxurstpma(2) & radce_adapt(2) &
                             radce_pdb(2) & radce_rst(2) & rsig_inv_2tap(2) & rsig_inv_pre(2);
 pma_ctrl8_ch3_ext <= rs_lpbk(3) & r_rlpbk(3) & rs_rdlpbk(3) & rrx_revlb_sw(3) &
                             rurx_pdb(3) & rtx_cgb_pdb(3) & rtx_ob_pdb(3) & rrx_cru_pdb(3) &
                             rrx_cru_rst(3) & rrx_ib_pdb(3) & rrxurstpma(3) & radce_adapt(3) &
                             radce_pdb(3) & radce_rst(3) & rsig_inv_2tap(3) & rsig_inv_pre(3);

 pma_ctrl9_ch0_ext <= rseq_sel_ch0 & rrgen_set_ch0 & rclkdiv_ch0 & rf_lpf_ch0 & 
                             rf_hpf_ch0 & rrgen_bw_ch0 & '0';
 pma_ctrl9_ch1_ext <= rseq_sel_ch1 & rrgen_set_ch1 & rclkdiv_ch1 & rf_lpf_ch1 & 
                             rf_hpf_ch1 & rrgen_bw_ch1 & '0';
 pma_ctrl9_ch2_ext <= rseq_sel_ch2 & rrgen_set_ch2 & rclkdiv_ch2 & rf_lpf_ch2 & 
                             rf_hpf_ch2 & rrgen_bw_ch2 & '0';
 pma_ctrl9_ch3_ext <= rseq_sel_ch3 & rrgen_set_ch3 & rclkdiv_ch3 & rf_lpf_ch3 & 
                             rf_hpf_ch3 & rrgen_bw_ch3 & '0';

 pma_ctrl10_ch0_ext<= rhyst_ch0 & rd2a_res_ch0 & rrgen_vod_ch0 &
                             rlf_os_ch0 & rhf_os_ch0;
 pma_ctrl10_ch1_ext<= rhyst_ch1 & rd2a_res_ch1 & rrgen_vod_ch1 &
                             rlf_os_ch1 & rhf_os_ch1;
 pma_ctrl10_ch2_ext<= rhyst_ch2 & rd2a_res_ch2 & rrgen_vod_ch2 &
                             rlf_os_ch2 & rhf_os_ch2;
 pma_ctrl10_ch3_ext<= rhyst_ch3 & rd2a_res_ch3 & rrgen_vod_ch3 &
                             rlf_os_ch3 & rhf_os_ch3;

 pma_ctrl11_ch0_ext<= r_iqclk_ch0 & r_dfe_ch0 & r_cp_mode(0) & rreg_cp_rx(0) & r_impctrl_ch0 & rpd_ien(0) & '0';
 pma_ctrl11_ch1_ext<= r_iqclk_ch1 & r_dfe_ch1 & r_cp_mode(1) & rreg_cp_rx(1) & r_impctrl_ch1 & rpd_ien(1) & '0';
 pma_ctrl11_ch2_ext<= r_iqclk_ch2 & r_dfe_ch2 & r_cp_mode(2) & rreg_cp_rx(2) & r_impctrl_ch2 & rpd_ien(2) & '0';
 pma_ctrl11_ch3_ext<= r_iqclk_ch3 & r_dfe_ch3 & r_cp_mode(3) & rreg_cp_rx(3) & r_impctrl_ch3 & rpd_ien(3) & '0';

 pma_global_ctrl0_ext <= rbgbypass & '0' & rlst_bg & rcmu_rst & "000" &
                                rcmu2_isel & rcmu0_isel & rcmu1_isel;
 pma_global_ctrl1_ext <= rcmu0_iupsel & rcmu1_iupsel & rcmu2_iupsel & rcmu0_idnsel & rcmu1_idnsel & rcmu2_idnsel &
                                rcmu0_testen_cp & rcmu1_testen_cp & rcmu0_tristate_cp & rcmu1_tristate_cp;
 pma_global_ctrl2_ext <= "00" & rcmu0_lst & rcmu1_lst &
                                rcmu0_div2 & rcmu1_div2 & rcmu0_ref_sel & rcmu1_ref_sel;
 pma_global_ctrl3_ext <= rcmu0_ctl & rcmu1_ctl;
 pma_global_ctrl4_ext <= rcmu0_m & rcmu1_m & rcmu0_l & rcmu1_l & rcmu0_pdb & rcmu1_pdb &
                                rcmu0_txpll_rst & rcmu1_txpll_rst;
 pma_global_ctrl5_ext <= rpma_testbus_sel & rcmu_peclrx0_cm & rcmu_peclrx1_cm &
                                rcmu0_testupen_cp & rcmu1_testupen_cp & rcmu0_testdnen_cp & rcmu1_testdnen_cp;                                
 pma_global_ctrl6_ext <= rcmu_peclrx0_lst & rcmu_peclrx1_lst & '0' & rcmu_iqclkout_sel &
                                rcmu_txpll0_iqclkin_sel & rcmu_txpll1_iqclkin_sel;
 pma_global_ctrl7_ext <= rcmu_cgb_cmusel & rcmu_cgb_ndiv & rcmu_cgb_div5 & rcmu_cgb_div2 &
                                rcmu_cgb_vcobypass & rcmu_txpll0_1x_en & rcmu_txpll1_1x_en & 
                                rcmu_cgb_4x_en & rcmu_cgb_8x_en & rcmu_cgb_pclksel & "0000";
 pma_global_ctrl8_ext <= rcmu2_testen_cp & rcmu2_tristate_cp & rcmu2_testupen_cp &
                                rcmu2_testdnen_cp & rcmu2_lst & rcmu2_ctl;
 pma_global_ctrl9_ext <= rcmu2_refsel & rcmu2_m & rcmu2_l & rcmu2_pdb & rcmu2_txpll_rst & 
                                rcmu0_rcp_mode & rcmu1_rcp_mode & "00000";                              

-- OUTPUT CRAMS FROM CONTROL REGISTERS
-- PCS CRAMs
-- Outputs from DTE XG Control register (4.0h)
rs_lpbk_all_md <= xgxs_ctrl_reg(14);
rpowerdown_md  <= xgxs_ctrl_reg(11);

-- Outputs from Trunking mode Control register (4.8000h)
rphfifo_master_sel_tx_int <= trunking_mode_reg(14);
rphfifo_master_sel_rx_int <= trunking_mode_reg(13);
rendec_data_sel_tx_int    <= trunking_mode_reg(12);
rendec_data_sel_rx_int    <= trunking_mode_reg(11);
rnenbpin_md               <= trunking_mode_reg(10);
rpllurst_md               <= trunking_mode_reg(9);
rreset_md                 <= trunking_mode_reg(8);
rrsvd_cmu_int             <= trunking_mode_reg(7 DOWNTO 3);
rdeskewen_int             <= trunking_mode_reg(2);
rindv_tx_int              <= trunking_mode_reg(1);
rindv_rx_int              <= trunking_mode_reg(0);

-- Outputs from PCS Per channel control register 1 for channel0 (4.8001h)
rtx_pipe_enable_int(0)   <= pcs_ctrl1_ch0_reg(15);
rrx_pipe_enable_int(0)   <= pcs_ctrl1_ch0_reg(14);
rpowdnr_md(0)            <= pcs_ctrl1_ch0_reg(13);
rpowdnt_md(0)            <= pcs_ctrl1_ch0_reg(12);
rendec_tx_int(0)         <= pcs_ctrl1_ch0_reg(11);
rendec_rx_int(0)         <= pcs_ctrl1_ch0_reg(10);
r8b10b_enc_ibm_en_int(0) <= pcs_ctrl1_ch0_reg(9);
rmatchen_int(0)          <= pcs_ctrl1_ch0_reg(8);
r8b10b_dec_ibm_en_ch0_int<= pcs_ctrl1_ch0_reg(7 DOWNTO 6);
rforce_kchar_int(0)      <= pcs_ctrl1_ch0_reg(5);
rforce_echar_int(0)      <= pcs_ctrl1_ch0_reg(4);
rlp20ben_int(0)          <= pcs_ctrl1_ch0_reg(3);
rgenericfifo_int(0)      <= pcs_ctrl1_ch0_reg(2);
rcascaded_8b10b_en_tx_int(0) <= pcs_ctrl1_ch0_reg(1);
rcascaded_8b10b_en_rx_int(0) <= pcs_ctrl1_ch0_reg(0);

-- Outputs from PCS Per channel control register 1 for channel1 (4.8002h)
rtx_pipe_enable_int(1)   <= pcs_ctrl1_ch1_reg(15);
rrx_pipe_enable_int(1)   <= pcs_ctrl1_ch1_reg(14);
rpowdnr_md(1)            <= pcs_ctrl1_ch1_reg(13);
rpowdnt_md(1)            <= pcs_ctrl1_ch1_reg(12);
rendec_tx_int(1)         <= pcs_ctrl1_ch1_reg(11);
rendec_rx_int(1)         <= pcs_ctrl1_ch1_reg(10);
r8b10b_enc_ibm_en_int(1) <= pcs_ctrl1_ch1_reg(9);
rmatchen_int(1)          <= pcs_ctrl1_ch1_reg(8);
r8b10b_dec_ibm_en_ch1_int<= pcs_ctrl1_ch1_reg(7 DOWNTO 6);
rforce_kchar_int(1)      <= pcs_ctrl1_ch1_reg(5);
rforce_echar_int(1)      <= pcs_ctrl1_ch1_reg(4);
rlp20ben_int(1)          <= pcs_ctrl1_ch1_reg(3);
rgenericfifo_int(1)      <= pcs_ctrl1_ch1_reg(2);
rcascaded_8b10b_en_tx_int(1) <= pcs_ctrl1_ch1_reg(1);
rcascaded_8b10b_en_rx_int(1) <= pcs_ctrl1_ch1_reg(0);

-- Outputs from PCS Per channel control register 1 for channel2 (4.8003h)
rtx_pipe_enable_int(2)   <= pcs_ctrl1_ch2_reg(15);
rrx_pipe_enable_int(2)   <= pcs_ctrl1_ch2_reg(14);
rpowdnr_md(2)            <= pcs_ctrl1_ch2_reg(13);
rpowdnt_md(2)            <= pcs_ctrl1_ch2_reg(12);
rendec_tx_int(2)         <= pcs_ctrl1_ch2_reg(11);
rendec_rx_int(2)         <= pcs_ctrl1_ch2_reg(10);
r8b10b_enc_ibm_en_int(2) <= pcs_ctrl1_ch2_reg(9);
rmatchen_int(2)          <= pcs_ctrl1_ch2_reg(8);
r8b10b_dec_ibm_en_ch2_int<= pcs_ctrl1_ch2_reg(7 DOWNTO 6);
rforce_kchar_int(2)      <= pcs_ctrl1_ch2_reg(5);
rforce_echar_int(2)      <= pcs_ctrl1_ch2_reg(4);
rlp20ben_int(2)          <= pcs_ctrl1_ch2_reg(3);
rgenericfifo_int(2)      <= pcs_ctrl1_ch2_reg(2);
rcascaded_8b10b_en_tx_int(2) <= pcs_ctrl1_ch2_reg(1);
rcascaded_8b10b_en_rx_int(2) <= pcs_ctrl1_ch2_reg(0);

-- Outputs from PCS Per channel control register 1 for channel3 (4.8004h)
rtx_pipe_enable_int(3)   <= pcs_ctrl1_ch3_reg(15);
rrx_pipe_enable_int(3)   <= pcs_ctrl1_ch3_reg(14);
rpowdnr_md(3)            <= pcs_ctrl1_ch3_reg(13);
rpowdnt_md(3)            <= pcs_ctrl1_ch3_reg(12);
rendec_tx_int(3)         <= pcs_ctrl1_ch3_reg(11);
rendec_rx_int(3)         <= pcs_ctrl1_ch3_reg(10);
r8b10b_enc_ibm_en_int(3) <= pcs_ctrl1_ch3_reg(9);
rmatchen_int(3)          <= pcs_ctrl1_ch3_reg(8);
r8b10b_dec_ibm_en_ch3_int<= pcs_ctrl1_ch3_reg(7 DOWNTO 6);
rforce_kchar_int(3)      <= pcs_ctrl1_ch3_reg(5);
rforce_echar_int(3)      <= pcs_ctrl1_ch3_reg(4);
rlp20ben_int(3)          <= pcs_ctrl1_ch3_reg(3);
rgenericfifo_int(3)      <= pcs_ctrl1_ch3_reg(2);
rcascaded_8b10b_en_tx_int(3) <= pcs_ctrl1_ch3_reg(1);
rcascaded_8b10b_en_rx_int(3) <= pcs_ctrl1_ch3_reg(0);

-- Outputs from PCS Per channel control register 2 for channel0 (4.8005h)
resync_badcg_en_ch0_int  <= pcs_ctrl2_ch0_reg(15 DOWNTO 14);
rencdt_rising_int(0)     <= pcs_ctrl2_ch0_reg(13);
rdis_rx_disp_int(0)      <= pcs_ctrl2_ch0_reg(12);
rcomp_pat_porn_int(0)    <= pcs_ctrl2_ch0_reg(11);
rcomp_size_ch0_int       <= pcs_ctrl2_ch0_reg(10 DOWNTO 8);
rcomp_pat_ch0_int(39 DOWNTO 32) <= pcs_ctrl2_ch0_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 2 for channel1 (4.8006h)
resync_badcg_en_ch1_int  <= pcs_ctrl2_ch1_reg(15 DOWNTO 14);
rencdt_rising_int(1)     <= pcs_ctrl2_ch1_reg(13);
rdis_rx_disp_int(1)      <= pcs_ctrl2_ch1_reg(12);
rcomp_pat_porn_int(1)    <= pcs_ctrl2_ch1_reg(11);
rcomp_size_ch1_int       <= pcs_ctrl2_ch1_reg(10 DOWNTO 8);
rcomp_pat_ch1_int(39 DOWNTO 32) <= pcs_ctrl2_ch1_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 2 for channel2 (4.8007h)
resync_badcg_en_ch2_int  <= pcs_ctrl2_ch2_reg(15 DOWNTO 14);
rencdt_rising_int(2)     <= pcs_ctrl2_ch2_reg(13);
rdis_rx_disp_int(2)      <= pcs_ctrl2_ch2_reg(12);
rcomp_pat_porn_int(2)    <= pcs_ctrl2_ch2_reg(11);
rcomp_size_ch2_int       <= pcs_ctrl2_ch2_reg(10 DOWNTO 8);
rcomp_pat_ch2_int(39 DOWNTO 32) <= pcs_ctrl2_ch2_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 2 for channel3 (4.8008h)
resync_badcg_en_ch3_int  <= pcs_ctrl2_ch3_reg(15 DOWNTO 14);
rencdt_rising_int(3)     <= pcs_ctrl2_ch3_reg(13);
rdis_rx_disp_int(3)      <= pcs_ctrl2_ch3_reg(12);
rcomp_pat_porn_int(3)    <= pcs_ctrl2_ch3_reg(11);
rcomp_size_ch3_int       <= pcs_ctrl2_ch3_reg(10 DOWNTO 8);
rcomp_pat_ch3_int(39 DOWNTO 32) <= pcs_ctrl2_ch3_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 3 for channel0 &1 &2 &3 (4.8009h-800Ch)
rcomp_pat_ch0_int(31 DOWNTO 16) <= pcs_ctrl3_ch0_reg;
rcomp_pat_ch1_int(31 DOWNTO 16) <= pcs_ctrl3_ch1_reg;
rcomp_pat_ch2_int(31 DOWNTO 16) <= pcs_ctrl3_ch2_reg;
rcomp_pat_ch3_int(31 DOWNTO 16) <= pcs_ctrl3_ch3_reg;

-- Outputs from PCS Per channel control register 4 for channel0 &1 &2 &3 (4.800Dh-8010h)
rcomp_pat_ch0_int(15 DOWNTO 0) <= pcs_ctrl4_ch0_reg;
rcomp_pat_ch1_int(15 DOWNTO 0) <= pcs_ctrl4_ch1_reg;
rcomp_pat_ch2_int(15 DOWNTO 0) <= pcs_ctrl4_ch2_reg;
rcomp_pat_ch3_int(15 DOWNTO 0) <= pcs_ctrl4_ch3_reg;

-- Outputs from PCS Per channel control register 5 for channel0 (4.8011h)
rrxfifo_dis_int(0)          <= pcs_ctrl5_ch0_reg(15);
rtxfifo_dis_int(0)          <= pcs_ctrl5_ch0_reg(14);
rib_force_disp_int(0)       <= pcs_ctrl5_ch0_reg(13);
rrundisp_ch0_int            <= pcs_ctrl5_ch0_reg(12 DOWNTO 7);
rtxfifo_lowlatency_en_int(0)<= pcs_ctrl5_ch0_reg(6);
rrlv_en_int(0)              <= pcs_ctrl5_ch0_reg(5);
rautobtalg_dis_int(0)       <= pcs_ctrl5_ch0_reg(4);
rsync_sm_dis_int(0)         <= pcs_ctrl5_ch0_reg(3);
rib_inv_cd_ch0_int          <= pcs_ctrl5_ch0_reg(2 DOWNTO 1);
rrxfifo_lowlatency_en_int(0)<= pcs_ctrl5_ch0_reg(0);

-- Outputs from PCS Per channel control register 5 for channel1 (4.8012h)
rrxfifo_dis_int(1)          <= pcs_ctrl5_ch1_reg(15);
rtxfifo_dis_int(1)          <= pcs_ctrl5_ch1_reg(14);
rib_force_disp_int(1)       <= pcs_ctrl5_ch1_reg(13);
rrundisp_ch1_int            <= pcs_ctrl5_ch1_reg(12 DOWNTO 7);
rtxfifo_lowlatency_en_int(1)<= pcs_ctrl5_ch1_reg(6);
rrlv_en_int(1)              <= pcs_ctrl5_ch1_reg(5);
rautobtalg_dis_int(1)       <= pcs_ctrl5_ch1_reg(4);
rsync_sm_dis_int(1)         <= pcs_ctrl5_ch1_reg(3);
rib_inv_cd_ch1_int          <= pcs_ctrl5_ch1_reg(2 DOWNTO 1);
rrxfifo_lowlatency_en_int(1)<= pcs_ctrl5_ch1_reg(0);

-- Outputs from PCS Per channel control register 5 for channel2 (4.8013h)
rrxfifo_dis_int(2)          <= pcs_ctrl5_ch2_reg(15);
rtxfifo_dis_int(2)          <= pcs_ctrl5_ch2_reg(14);
rib_force_disp_int(2)       <= pcs_ctrl5_ch2_reg(13);
rrundisp_ch2_int            <= pcs_ctrl5_ch2_reg(12 DOWNTO 7);
rtxfifo_lowlatency_en_int(2)<= pcs_ctrl5_ch2_reg(6);
rrlv_en_int(2)              <= pcs_ctrl5_ch2_reg(5);
rautobtalg_dis_int(2)       <= pcs_ctrl5_ch2_reg(4);
rsync_sm_dis_int(2)         <= pcs_ctrl5_ch2_reg(3);
rib_inv_cd_ch2_int          <= pcs_ctrl5_ch2_reg(2 DOWNTO 1);
rrxfifo_lowlatency_en_int(2)<= pcs_ctrl5_ch2_reg(0);

-- Outputs from PCS Per channel control register 5 for channel3 (4.8014h)
rrxfifo_dis_int(3)          <= pcs_ctrl5_ch3_reg(15);
rtxfifo_dis_int(3)          <= pcs_ctrl5_ch3_reg(14);
rib_force_disp_int(3)       <= pcs_ctrl5_ch3_reg(13);
rrundisp_ch3_int            <= pcs_ctrl5_ch3_reg(12 DOWNTO 7);
rtxfifo_lowlatency_en_int(3)<= pcs_ctrl5_ch3_reg(6);
rrlv_en_int(3)              <= pcs_ctrl5_ch3_reg(5);
rautobtalg_dis_int(3)       <= pcs_ctrl5_ch3_reg(4);
rsync_sm_dis_int(3)         <= pcs_ctrl5_ch3_reg(3);
rib_inv_cd_ch3_int          <= pcs_ctrl5_ch3_reg(2 DOWNTO 1);
rrxfifo_lowlatency_en_int(3)<= pcs_ctrl5_ch3_reg(0);

-- Outputs from PCS Per channel control register 6 for channel0 (4.8015h)
rdwidth_tx_int(0)       <= pcs_ctrl6_ch0_reg(15);
rdwidth_rx_int(0)       <= pcs_ctrl6_ch0_reg(14);
rge_xaui_tx_int(0)      <= pcs_ctrl6_ch0_reg(13);
rrx_detect_bypass_int(0)<= pcs_ctrl6_ch0_reg(12);
rtxurstpcs_md(0)        <= pcs_ctrl6_ch0_reg(11);
rrxurstpcs_md(0)        <= pcs_ctrl6_ch0_reg(10);
rrsvd_tx_ch0_int        <= pcs_ctrl6_ch0_reg(9 DOWNTO 5);
rskpsetbased_int(0)     <= pcs_ctrl6_ch0_reg(4);
rtruebac2bac_int(0)     <= pcs_ctrl6_ch0_reg(3);
rrsvd_rx_ch0_int        <= pcs_ctrl6_ch0_reg(2 DOWNTO 0);

-- Outputs from PCS Per channel control register 6 for channel1 (4.8016h)
rdwidth_tx_int(1)       <= pcs_ctrl6_ch1_reg(15);
rdwidth_rx_int(1)       <= pcs_ctrl6_ch1_reg(14);
rge_xaui_tx_int(1)      <= pcs_ctrl6_ch1_reg(13);
rrx_detect_bypass_int(1)<= pcs_ctrl6_ch1_reg(12);
rtxurstpcs_md(1)        <= pcs_ctrl6_ch1_reg(11);
rrxurstpcs_md(1)        <= pcs_ctrl6_ch1_reg(10);
rrsvd_tx_ch1_int        <= pcs_ctrl6_ch1_reg(9 DOWNTO 5);
rskpsetbased_int(1)     <= pcs_ctrl6_ch1_reg(4);
rtruebac2bac_int(1)     <= pcs_ctrl6_ch1_reg(3);
rrsvd_rx_ch1_int        <= pcs_ctrl6_ch1_reg(2 DOWNTO 0);

-- Outputs from PCS Per channel control register 6 for channel2 (4.8017h)
rdwidth_tx_int(2)       <= pcs_ctrl6_ch2_reg(15);
rdwidth_rx_int(2)       <= pcs_ctrl6_ch2_reg(14);
rge_xaui_tx_int(2)      <= pcs_ctrl6_ch2_reg(13);
rrx_detect_bypass_int(2)<= pcs_ctrl6_ch2_reg(12);
rtxurstpcs_md(2)        <= pcs_ctrl6_ch2_reg(11);
rrxurstpcs_md(2)        <= pcs_ctrl6_ch2_reg(10);
rrsvd_tx_ch2_int        <= pcs_ctrl6_ch2_reg(9 DOWNTO 5);
rskpsetbased_int(2)     <= pcs_ctrl6_ch2_reg(4);
rtruebac2bac_int(2)     <= pcs_ctrl6_ch2_reg(3);
rrsvd_rx_ch2_int        <= pcs_ctrl6_ch2_reg(2 DOWNTO 0);

-- Outputs from PCS Per channel control register 6 for channel3 (4.8018h)
rdwidth_tx_int(3)       <= pcs_ctrl6_ch3_reg(15);
rdwidth_rx_int(3)       <= pcs_ctrl6_ch3_reg(14);
rge_xaui_tx_int(3)      <= pcs_ctrl6_ch3_reg(13);
rrx_detect_bypass_int(3)<= pcs_ctrl6_ch3_reg(12);
rtxurstpcs_md(3)        <= pcs_ctrl6_ch3_reg(11);
rrxurstpcs_md(3)        <= pcs_ctrl6_ch3_reg(10);
rrsvd_tx_ch3_int        <= pcs_ctrl6_ch3_reg(9 DOWNTO 5);
rskpsetbased_int(3)     <= pcs_ctrl6_ch3_reg(4);
rtruebac2bac_int(3)     <= pcs_ctrl6_ch3_reg(3);
rrsvd_rx_ch3_int        <= pcs_ctrl6_ch3_reg(2 DOWNTO 0);

-- Outputs from PCS Per channel control register 7 for channel0 (4.8019h)
rgnumber_ch0_int      <= pcs_ctrl7_ch0_reg(15 DOWNTO 8);
rknumber_ch0_int      <= pcs_ctrl7_ch0_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 7 for channel1 (4.801Ah)
rgnumber_ch1_int      <= pcs_ctrl7_ch1_reg(15 DOWNTO 8);
rknumber_ch1_int      <= pcs_ctrl7_ch1_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 7 for channel2 (4.801Bh)
rgnumber_ch2_int      <= pcs_ctrl7_ch2_reg(15 DOWNTO 8);
rknumber_ch2_int      <= pcs_ctrl7_ch2_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 7 for channel3 (4.801Ch)
rgnumber_ch3_int      <= pcs_ctrl7_ch3_reg(15 DOWNTO 8);
rknumber_ch3_int      <= pcs_ctrl7_ch3_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 8 for channel0 (4.801Dh)
rfreerun_tx_int(0)      <= pcs_ctrl8_ch0_reg(15);
rtxwrclksel_int(0)      <= pcs_ctrl8_ch0_reg(14);
rtxrdclksel_int(0)      <= pcs_ctrl8_ch0_reg(13);
rfreerun_rx_int(0)      <= pcs_ctrl8_ch0_reg(12);
rrcvd_clk_sel_ch0_int   <= pcs_ctrl8_ch0_reg(11 DOWNTO 10);
rclk_1_sel_ch0_int      <= pcs_ctrl8_ch0_reg(9 DOWNTO 8);
rclk_2_sel_ch0_int      <= pcs_ctrl8_ch0_reg(7 DOWNTO 6);
rrx_rd_clk_sel_int(0)   <= pcs_ctrl8_ch0_reg(5);
renumber_ch0_int        <= pcs_ctrl8_ch0_reg(4 DOWNTO 2);
renpolinv_rx_int(0)     <= pcs_ctrl8_ch0_reg(1);
rclkcmpinsertpad_int(0) <= pcs_ctrl8_ch0_reg(0);

-- Outputs from PCS Per channel control register 8 for channel1 (4.801Eh)
rfreerun_tx_int(1)      <= pcs_ctrl8_ch1_reg(15);
rtxwrclksel_int(1)      <= pcs_ctrl8_ch1_reg(14);
rtxrdclksel_int(1)      <= pcs_ctrl8_ch1_reg(13);
rfreerun_rx_int(1)      <= pcs_ctrl8_ch1_reg(12);
rrcvd_clk_sel_ch1_int   <= pcs_ctrl8_ch1_reg(11 DOWNTO 10);
rclk_1_sel_ch1_int      <= pcs_ctrl8_ch1_reg(9 DOWNTO 8);
rclk_2_sel_ch1_int      <= pcs_ctrl8_ch1_reg(7 DOWNTO 6);
rrx_rd_clk_sel_int(1)   <= pcs_ctrl8_ch1_reg(5);
renumber_ch1_int        <= pcs_ctrl8_ch1_reg(4 DOWNTO 2);
renpolinv_rx_int(1)     <= pcs_ctrl8_ch1_reg(1);
rclkcmpinsertpad_int(1) <= pcs_ctrl8_ch1_reg(0);

-- Outputs from PCS Per channel control register 8 for channel2 (4.801Fh)
rfreerun_tx_int(2)      <= pcs_ctrl8_ch2_reg(15);
rtxwrclksel_int(2)      <= pcs_ctrl8_ch2_reg(14);
rtxrdclksel_int(2)      <= pcs_ctrl8_ch2_reg(13);
rfreerun_rx_int(2)      <= pcs_ctrl8_ch2_reg(12);
rrcvd_clk_sel_ch2_int   <= pcs_ctrl8_ch2_reg(11 DOWNTO 10);
rclk_1_sel_ch2_int      <= pcs_ctrl8_ch2_reg(9 DOWNTO 8);
rclk_2_sel_ch2_int      <= pcs_ctrl8_ch2_reg(7 DOWNTO 6);
rrx_rd_clk_sel_int(2)   <= pcs_ctrl8_ch2_reg(5);
renumber_ch2_int        <= pcs_ctrl8_ch2_reg(4 DOWNTO 2);
renpolinv_rx_int(2)     <= pcs_ctrl8_ch2_reg(1);
rclkcmpinsertpad_int(2) <= pcs_ctrl8_ch2_reg(0);

-- Outputs from PCS Per channel control register 8 for channel3 (4.8020h)
rfreerun_tx_int(3)      <= pcs_ctrl8_ch3_reg(15);
rtxwrclksel_int(3)      <= pcs_ctrl8_ch3_reg(14);
rtxrdclksel_int(3)      <= pcs_ctrl8_ch3_reg(13);
rfreerun_rx_int(3)      <= pcs_ctrl8_ch3_reg(12);
rrcvd_clk_sel_ch3_int   <= pcs_ctrl8_ch3_reg(11 DOWNTO 10);
rclk_1_sel_ch3_int      <= pcs_ctrl8_ch3_reg(9 DOWNTO 8);
rclk_2_sel_ch3_int      <= pcs_ctrl8_ch3_reg(7 DOWNTO 6);
rrx_rd_clk_sel_int(3)   <= pcs_ctrl8_ch3_reg(5);
renumber_ch3_int        <= pcs_ctrl8_ch3_reg(4 DOWNTO 2);
renpolinv_rx_int(3)     <= pcs_ctrl8_ch3_reg(1);
rclkcmpinsertpad_int(3) <= pcs_ctrl8_ch3_reg(0);

-- Outputs from BIST/PRBS test control register for channel0 (4.8021h)
rprbsen_tx_int(0)        <= prbs_bist_ctrl_ch0_reg(15);
rprbsen_rx_int(0)        <= prbs_bist_ctrl_ch0_reg(14);
rprbs_clr_rslt_rx_int(0) <= prbs_bist_ctrl_ch0_reg(13);
rprbs_sel_ch0_int        <= prbs_bist_ctrl_ch0_reg(12 DOWNTO 10);
rbisten_tx_int(0)        <= prbs_bist_ctrl_ch0_reg(9);
rbisten_rx_int(0)        <= prbs_bist_ctrl_ch0_reg(8);
rbist_clr_rx_int(0)      <= prbs_bist_ctrl_ch0_reg(7);
rbist_sel_ch0_int        <= prbs_bist_ctrl_ch0_reg(6 DOWNTO 5);
rcxpat_chnl_en_ch0_int   <= prbs_bist_ctrl_ch0_reg(4 DOWNTO 3);
rall_one_dect_only_int(0)<= prbs_bist_ctrl_ch0_reg(2);

-- Outputs from BIST/PRBS test control register for channel1 (4.8022h)
rprbsen_tx_int(1)        <= prbs_bist_ctrl_ch1_reg(15);
rprbsen_rx_int(1)        <= prbs_bist_ctrl_ch1_reg(14);
rprbs_clr_rslt_rx_int(1) <= prbs_bist_ctrl_ch1_reg(13);
rprbs_sel_ch1_int        <= prbs_bist_ctrl_ch1_reg(12 DOWNTO 10);
rbisten_tx_int(1)        <= prbs_bist_ctrl_ch1_reg(9);
rbisten_rx_int(1)        <= prbs_bist_ctrl_ch1_reg(8);
rbist_clr_rx_int(1)      <= prbs_bist_ctrl_ch1_reg(7);
rbist_sel_ch1_int        <= prbs_bist_ctrl_ch1_reg(6 DOWNTO 5);
rcxpat_chnl_en_ch1_int   <= prbs_bist_ctrl_ch1_reg(4 DOWNTO 3);
rall_one_dect_only_int(1)<= prbs_bist_ctrl_ch1_reg(2);

-- Outputs from BIST/PRBS test control register for channel2 (4.8023h)
rprbsen_tx_int(2)        <= prbs_bist_ctrl_ch2_reg(15);
rprbsen_rx_int(2)        <= prbs_bist_ctrl_ch2_reg(14);
rprbs_clr_rslt_rx_int(2) <= prbs_bist_ctrl_ch2_reg(13);
rprbs_sel_ch2_int        <= prbs_bist_ctrl_ch2_reg(12 DOWNTO 10);
rbisten_tx_int(2)        <= prbs_bist_ctrl_ch2_reg(9);
rbisten_rx_int(2)        <= prbs_bist_ctrl_ch2_reg(8);
rbist_clr_rx_int(2)      <= prbs_bist_ctrl_ch2_reg(7);
rbist_sel_ch2_int        <= prbs_bist_ctrl_ch2_reg(6 DOWNTO 5);
rcxpat_chnl_en_ch2_int   <= prbs_bist_ctrl_ch2_reg(4 DOWNTO 3);
rall_one_dect_only_int(2)<= prbs_bist_ctrl_ch2_reg(2);

-- Outputs from BIST/PRBS test control register for channel3 (4.8024h)
rprbsen_tx_int(3)        <= prbs_bist_ctrl_ch3_reg(15);
rprbsen_rx_int(3)        <= prbs_bist_ctrl_ch3_reg(14);
rprbs_clr_rslt_rx_int(3) <= prbs_bist_ctrl_ch3_reg(13);
rprbs_sel_ch3_int        <= prbs_bist_ctrl_ch3_reg(12 DOWNTO 10);
rbisten_tx_int(3)        <= prbs_bist_ctrl_ch3_reg(9);
rbisten_rx_int(3)        <= prbs_bist_ctrl_ch3_reg(8);
rbist_clr_rx_int(3)      <= prbs_bist_ctrl_ch3_reg(7);
rbist_sel_ch3_int        <= prbs_bist_ctrl_ch3_reg(6 DOWNTO 5);
rcxpat_chnl_en_ch3_int   <= prbs_bist_ctrl_ch3_reg(4 DOWNTO 3);
rall_one_dect_only_int(3)<= prbs_bist_ctrl_ch3_reg(2);

-- Outputs from PCS Per channel control register 9 for channel0 (4.8025h)
rppm_cnt_reset_int(0)     <= pcs_ctrl9_ch0_reg(15);
rphfifourstrx_int(0)      <= pcs_ctrl9_ch0_reg(14);
rcmpfifourst_int(0)       <= pcs_ctrl9_ch0_reg(13);
rtx_idle_delay_ch0_int    <= pcs_ctrl9_ch0_reg(12 DOWNTO 11);
rclkcmpsqmd_int(0)        <= pcs_ctrl9_ch0_reg(10);
rclkcmpsq1p_ch0_int(9 DOWNTO 0)  <= pcs_ctrl9_ch0_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 9 for channel1 (4.8026h)
rppm_cnt_reset_int(1)     <= pcs_ctrl9_ch1_reg(15);
rphfifourstrx_int(1)      <= pcs_ctrl9_ch1_reg(14);
rcmpfifourst_int(1)       <= pcs_ctrl9_ch1_reg(13);
rtx_idle_delay_ch1_int    <= pcs_ctrl9_ch1_reg(12 DOWNTO 11);
rclkcmpsqmd_int(1)        <= pcs_ctrl9_ch1_reg(10);
rclkcmpsq1p_ch1_int(9 DOWNTO 0)  <= pcs_ctrl9_ch1_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 9 for channel2 (4.8027h)
rppm_cnt_reset_int(2)     <= pcs_ctrl9_ch2_reg(15);
rphfifourstrx_int(2)      <= pcs_ctrl9_ch2_reg(14);
rcmpfifourst_int(2)       <= pcs_ctrl9_ch2_reg(13);
rtx_idle_delay_ch2_int    <= pcs_ctrl9_ch2_reg(12 DOWNTO 11);
rclkcmpsqmd_int(2)        <= pcs_ctrl9_ch2_reg(10);
rclkcmpsq1p_ch2_int(9 DOWNTO 0)  <= pcs_ctrl9_ch2_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 9 for channel3 (4.8028h)
rppm_cnt_reset_int(3)     <= pcs_ctrl9_ch3_reg(15);
rphfifourstrx_int(3)      <= pcs_ctrl9_ch3_reg(14);
rcmpfifourst_int(3)       <= pcs_ctrl9_ch3_reg(13);
rtx_idle_delay_ch3_int    <= pcs_ctrl9_ch3_reg(12 DOWNTO 11);
rclkcmpsqmd_int(3)        <= pcs_ctrl9_ch3_reg(10);
rclkcmpsq1p_ch3_int(9 DOWNTO 0)  <= pcs_ctrl9_ch3_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 10 for channel0 (4.8029h)
rclkcmpsq1n_ch0_int(19 DOWNTO 15)  <= pcs_ctrl10_ch0_reg(15 DOWNTO 11);
rclkcmppos_int(0)           <= pcs_ctrl10_ch0_reg(10);
rclkcmpsq1p_ch0_int(19 DOWNTO 10)  <= pcs_ctrl10_ch0_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 10 for channel1 (4.802Ah)
rclkcmpsq1n_ch1_int(19 DOWNTO 15)  <= pcs_ctrl10_ch1_reg(15 DOWNTO 11);
rclkcmppos_int(1)           <= pcs_ctrl10_ch1_reg(10);
rclkcmpsq1p_ch1_int(19 DOWNTO 10)  <= pcs_ctrl10_ch1_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 10 for channel2 (4.802Bh)
rclkcmpsq1n_ch2_int(19 DOWNTO 15)  <= pcs_ctrl10_ch2_reg(15 DOWNTO 11);
rclkcmppos_int(2)           <= pcs_ctrl10_ch2_reg(10);
rclkcmpsq1p_ch2_int(19 DOWNTO 10)  <= pcs_ctrl10_ch2_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 10 for channel3 (4.802Ch)
rclkcmpsq1n_ch3_int(19 DOWNTO 15)  <= pcs_ctrl10_ch3_reg(15 DOWNTO 11);
rclkcmppos_int(3)           <= pcs_ctrl10_ch3_reg(10);
rclkcmpsq1p_ch3_int(19 DOWNTO 10)  <= pcs_ctrl10_ch3_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 11 for channel0 (4.802Dh)
rclkcmpsq1n_ch0_int(14 DOWNTO 10)  <= pcs_ctrl11_ch0_reg(15 DOWNTO 11);
rclkcmpsq1n_ch0_int(9 DOWNTO 0)    <= pcs_ctrl11_ch0_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 11 for channel1 (4.802Eh)
rclkcmpsq1n_ch1_int(14 DOWNTO 10)  <= pcs_ctrl11_ch1_reg(15 DOWNTO 11);
rclkcmpsq1n_ch1_int(9 DOWNTO 0)    <= pcs_ctrl11_ch1_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 11 for channel2 (4.802Fh)
rclkcmpsq1n_ch2_int(14 DOWNTO 10)  <= pcs_ctrl11_ch2_reg(15 DOWNTO 11);
rclkcmpsq1n_ch2_int(9 DOWNTO 0)    <= pcs_ctrl11_ch2_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 11 for channel3 (4.8030h)
rclkcmpsq1n_ch3_int(14 DOWNTO 10)  <= pcs_ctrl11_ch3_reg(15 DOWNTO 11);
rclkcmpsq1n_ch3_int(9 DOWNTO 0)    <= pcs_ctrl11_ch3_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 12 for channel0 (4.8031h)
rrev_loopbk_int(0)          <= pcs_ctrl12_ch0_reg(15);
ralempty_ch0_int            <= pcs_ctrl12_ch0_reg(14 DOWNTO 11);
ralfull_ch0_int             <= pcs_ctrl12_ch0_reg(10 DOWNTO 7);
rforce_disp_int(0)          <= pcs_ctrl12_ch0_reg(6);
rkchar_int(0)               <= pcs_ctrl12_ch0_reg(5);
rosbased_int(0)             <= pcs_ctrl12_ch0_reg(4);
rensymswap_tx_int(0)        <= pcs_ctrl12_ch0_reg(3);
rosnumber_ch0_int           <= pcs_ctrl12_ch0_reg(1 DOWNTO 0);

-- Outputs from PCS Per channel control register 12 for channel1 (4.8032h)
rrev_loopbk_int(1)          <= pcs_ctrl12_ch1_reg(15);
ralempty_ch1_int            <= pcs_ctrl12_ch1_reg(14 DOWNTO 11);
ralfull_ch1_int             <= pcs_ctrl12_ch1_reg(10 DOWNTO 7);
rforce_disp_int(1)          <= pcs_ctrl12_ch1_reg(6);
rkchar_int(1)               <= pcs_ctrl12_ch1_reg(5);
rosbased_int(1)             <= pcs_ctrl12_ch1_reg(4);
rensymswap_tx_int(1)        <= pcs_ctrl12_ch1_reg(3);
rosnumber_ch1_int           <= pcs_ctrl12_ch1_reg(1 DOWNTO 0);

-- Outputs from PCS Per channel control register 12 for channel2 (4.8033h)
rrev_loopbk_int(2)          <= pcs_ctrl12_ch2_reg(15);
ralempty_ch2_int            <= pcs_ctrl12_ch2_reg(14 DOWNTO 11);
ralfull_ch2_int             <= pcs_ctrl12_ch2_reg(10 DOWNTO 7);
rforce_disp_int(2)          <= pcs_ctrl12_ch2_reg(6);
rkchar_int(2)               <= pcs_ctrl12_ch2_reg(5);
rosbased_int(2)             <= pcs_ctrl12_ch2_reg(4);
rensymswap_tx_int(2)        <= pcs_ctrl12_ch2_reg(3);
rosnumber_ch2_int           <= pcs_ctrl12_ch2_reg(1 DOWNTO 0);

-- Outputs from PCS Per channel control register 12 for channel3 (4.8034h)
rrev_loopbk_int(3)          <= pcs_ctrl12_ch3_reg(15);
ralempty_ch3_int            <= pcs_ctrl12_ch3_reg(14 DOWNTO 11);
ralfull_ch3_int             <= pcs_ctrl12_ch3_reg(10 DOWNTO 7);
rforce_disp_int(3)          <= pcs_ctrl12_ch3_reg(6);
rkchar_int(3)               <= pcs_ctrl12_ch3_reg(5);
rosbased_int(3)             <= pcs_ctrl12_ch3_reg(4);
rensymswap_tx_int(3)        <= pcs_ctrl12_ch3_reg(3);
rosnumber_ch3_int           <= pcs_ctrl12_ch3_reg(1 DOWNTO 0);

-- Outputs from PCS Per channel control register 13 for channel0 (4.8035h)
rwa_6g_en_int(0)            <= pcs_ctrl13_ch0_reg(15);
renpolinv_tx_int(0)         <= pcs_ctrl13_ch0_reg(14);
rbitslip_size_ch0_int       <= pcs_ctrl13_ch0_reg(13 DOWNTO 12);
rbytord_2sym_en_int(0)      <= pcs_ctrl13_ch0_reg(11);
rbysync_polinv_en_int(0)    <= pcs_ctrl13_ch0_reg(10);
rbitloc_rev_en_int(0)       <= pcs_ctrl13_ch0_reg(9);
rbyte_rev_en_int(0)         <= pcs_ctrl13_ch0_reg(8);
renbitrev_tx_int(0)         <= pcs_ctrl13_ch0_reg(7);
rbyteorden_ch0_int          <= pcs_ctrl13_ch0_reg(6 DOWNTO 5);
rbytordplden_int(0)         <= pcs_ctrl13_ch0_reg(4);
rphfifopldentx_int(0)       <= pcs_ctrl13_ch0_reg(3);
rphfifoursttx_int(0)        <= pcs_ctrl13_ch0_reg(2);
rphfifopldenrx_int(0)       <= pcs_ctrl13_ch0_reg(1);
rautoinsdis_int(0)          <= pcs_ctrl13_ch0_reg(0);

-- Outputs from PCS Per channel control register 13 for channel1 (4.8036h)
rwa_6g_en_int(1)            <= pcs_ctrl13_ch1_reg(15);
renpolinv_tx_int(1)         <= pcs_ctrl13_ch1_reg(14);
rbitslip_size_ch1_int       <= pcs_ctrl13_ch1_reg(13 DOWNTO 12);
rbytord_2sym_en_int(1)      <= pcs_ctrl13_ch1_reg(11);
rbysync_polinv_en_int(1)    <= pcs_ctrl13_ch1_reg(10);
rbitloc_rev_en_int(1)       <= pcs_ctrl13_ch1_reg(9);
rbyte_rev_en_int(1)         <= pcs_ctrl13_ch1_reg(8);
renbitrev_tx_int(1)         <= pcs_ctrl13_ch1_reg(7);
rbyteorden_ch1_int          <= pcs_ctrl13_ch1_reg(6 DOWNTO 5);
rbytordplden_int(1)         <= pcs_ctrl13_ch1_reg(4);
rphfifopldentx_int(1)       <= pcs_ctrl13_ch1_reg(3);
rphfifoursttx_int(1)        <= pcs_ctrl13_ch1_reg(2);
rphfifopldenrx_int(1)       <= pcs_ctrl13_ch1_reg(1);
rautoinsdis_int(1)          <= pcs_ctrl13_ch1_reg(0);

-- Outputs from PCS Per channel control register 13 for channel2 (4.8037h)
rwa_6g_en_int(2)            <= pcs_ctrl13_ch2_reg(15);
renpolinv_tx_int(2)         <= pcs_ctrl13_ch2_reg(14);
rbitslip_size_ch2_int       <= pcs_ctrl13_ch2_reg(13 DOWNTO 12);
rbytord_2sym_en_int(2)      <= pcs_ctrl13_ch2_reg(11);
rbysync_polinv_en_int(2)    <= pcs_ctrl13_ch2_reg(10);
rbitloc_rev_en_int(2)       <= pcs_ctrl13_ch2_reg(9);
rbyte_rev_en_int(2)         <= pcs_ctrl13_ch2_reg(8);
renbitrev_tx_int(2)         <= pcs_ctrl13_ch2_reg(7);
rbyteorden_ch2_int          <= pcs_ctrl13_ch2_reg(6 DOWNTO 5);
rbytordplden_int(2)         <= pcs_ctrl13_ch2_reg(4);
rphfifopldentx_int(2)       <= pcs_ctrl13_ch2_reg(3);
rphfifoursttx_int(2)        <= pcs_ctrl13_ch2_reg(2);
rphfifopldenrx_int(2)       <= pcs_ctrl13_ch2_reg(1);
rautoinsdis_int(2)          <= pcs_ctrl13_ch2_reg(0);

-- Outputs from PCS Per channel control register 13 for channel3 (4.8038h)
rwa_6g_en_int(3)            <= pcs_ctrl13_ch3_reg(15);
renpolinv_tx_int(3)         <= pcs_ctrl13_ch3_reg(14);
rbitslip_size_ch3_int       <= pcs_ctrl13_ch3_reg(13 DOWNTO 12);
rbytord_2sym_en_int(3)      <= pcs_ctrl13_ch3_reg(11);
rbysync_polinv_en_int(3)    <= pcs_ctrl13_ch3_reg(10);
rbitloc_rev_en_int(3)       <= pcs_ctrl13_ch3_reg(9);
rbyte_rev_en_int(3)         <= pcs_ctrl13_ch3_reg(8);
renbitrev_tx_int(3)         <= pcs_ctrl13_ch3_reg(7);
rbyteorden_ch3_int          <= pcs_ctrl13_ch3_reg(6 DOWNTO 5);
rbytordplden_int(3)         <= pcs_ctrl13_ch3_reg(4);
rphfifopldentx_int(3)       <= pcs_ctrl13_ch3_reg(3);
rphfifoursttx_int(3)        <= pcs_ctrl13_ch3_reg(2);
rphfifopldenrx_int(3)       <= pcs_ctrl13_ch3_reg(1);
rautoinsdis_int(3)          <= pcs_ctrl13_ch3_reg(0);

-- Outputs from PCS Per channel control register 14 for channel0 (4.8039h)
rppmsel_ch0_int       <= pcs_ctrl14_ch0_reg(15 DOWNTO 10);
rbytordpat_ch0_int    <= pcs_ctrl14_ch0_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 14 for channel1 (4.803Ah)
rppmsel_ch1_int       <= pcs_ctrl14_ch1_reg(15 DOWNTO 10);
rbytordpat_ch1_int    <= pcs_ctrl14_ch1_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 14 for channel2 (4.803Bh)
rppmsel_ch2_int       <= pcs_ctrl14_ch2_reg(15 DOWNTO 10);
rbytordpat_ch2_int    <= pcs_ctrl14_ch2_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 14 for channel3 (4.803Ch)
rppmsel_ch3_int       <= pcs_ctrl14_ch3_reg(15 DOWNTO 10);
rbytordpat_ch3_int    <= pcs_ctrl14_ch3_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 15 for channel0 (4.803Dh)
rtest_bus_sel_ch0_int        <= pcs_ctrl15_ch0_reg(15 DOWNTO 13);
rforce_sig_det_pcs_int(0)    <= pcs_ctrl15_ch0_reg(12);
rforce0_freqdet_int(0)       <= pcs_ctrl15_ch0_reg(11);
rforce1_freqdet_int(0)       <= pcs_ctrl15_ch0_reg(10);
rbytordpad_ch0_int           <= pcs_ctrl15_ch0_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 15 for channel1 (4.803Eh)
rtest_bus_sel_ch1_int        <= pcs_ctrl15_ch1_reg(15 DOWNTO 13);
rforce_sig_det_pcs_int(1)    <= pcs_ctrl15_ch1_reg(12);
rforce0_freqdet_int(1)       <= pcs_ctrl15_ch1_reg(11);
rforce1_freqdet_int(1)       <= pcs_ctrl15_ch1_reg(10);
rbytordpad_ch1_int           <= pcs_ctrl15_ch1_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 15 for channel2 (4.803Fh)
rtest_bus_sel_ch2_int        <= pcs_ctrl15_ch2_reg(15 DOWNTO 13);
rforce_sig_det_pcs_int(2)    <= pcs_ctrl15_ch2_reg(12);
rforce0_freqdet_int(2)       <= pcs_ctrl15_ch2_reg(11);
rforce1_freqdet_int(2)       <= pcs_ctrl15_ch2_reg(10);
rbytordpad_ch2_int           <= pcs_ctrl15_ch2_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 15 for channel3 (4.8040h)
rtest_bus_sel_ch3_int        <= pcs_ctrl15_ch3_reg(15 DOWNTO 13);
rforce_sig_det_pcs_int(3)    <= pcs_ctrl15_ch3_reg(12);
rforce0_freqdet_int(3)       <= pcs_ctrl15_ch3_reg(11);
rforce1_freqdet_int(3)       <= pcs_ctrl15_ch3_reg(10);
rbytordpad_ch3_int           <= pcs_ctrl15_ch3_reg(9 DOWNTO 0);

-- Outputs from PCS Global control register 0 (4.8050h)
ralgnect_int     <= pcs_global_ctrl0_reg(6 DOWNTO 5);
ralgngct_int     <= pcs_global_ctrl0_reg(4 DOWNTO 3);
ralgnact_int     <= pcs_global_ctrl0_reg(2 DOWNTO 0);

-- Outputs from PCS Global control register 1 (4.8051h)
rfreerun_centrl_int <= pcs_global_ctrl1_reg(15);
rcentrl_clk_sel_int <= pcs_global_ctrl1_reg(14);
rrefclk_out_div2_int<= pcs_global_ctrl1_reg(11);
rdskposdisp_int     <= pcs_global_ctrl1_reg(10);
rdskchrp_int        <= pcs_global_ctrl1_reg(9 DOWNTO 0);

-- Outputs from PCS Global control register 2 (4.8052h)
rtest_bus_centrl_sel_int <= pcs_global_ctrl2_reg(12 DOWNTO 10);
ralgnopt_int             <= pcs_global_ctrl2_reg(13);

-- PMA CRAMs
-- Outputs from PMA Per channel control register 1 for channel0 (4.8060h)
 rtx_vod_sel_ch0_int          <= pma_ctrl1_ch0_reg(15 DOWNTO 13);
 rtx_slewrate_int(0)          <= pma_ctrl1_ch0_reg(12);
 rpmphs_2tap_ch0_int          <= pma_ctrl1_ch0_reg(11 DOWNTO 9);
 rpmphs_1tap_ch0_int          <= pma_ctrl1_ch0_reg(8 DOWNTO 5);
 rtx_vtt_ch0_int              <= pma_ctrl1_ch0_reg(4 DOWNTO 3);
 rpmphs_ptap_ch0_int          <= pma_ctrl1_ch0_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 1 for channel1 (4.8061h)
 rtx_vod_sel_ch1_int          <= pma_ctrl1_ch1_reg(15 DOWNTO 13);
 rtx_slewrate_int(1)          <= pma_ctrl1_ch1_reg(12);
 rpmphs_2tap_ch1_int          <= pma_ctrl1_ch1_reg(11 DOWNTO 9);
 rpmphs_1tap_ch1_int          <= pma_ctrl1_ch1_reg(8 DOWNTO 5);
 rtx_vtt_ch1_int              <= pma_ctrl1_ch1_reg(4 DOWNTO 3);
 rpmphs_ptap_ch1_int          <= pma_ctrl1_ch1_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 1 for channel2 (4.8062h)
 rtx_vod_sel_ch2_int          <= pma_ctrl1_ch2_reg(15 DOWNTO 13);
 rtx_slewrate_int(2)          <= pma_ctrl1_ch2_reg(12);
 rpmphs_2tap_ch2_int          <= pma_ctrl1_ch2_reg(11 DOWNTO 9);
 rpmphs_1tap_ch2_int          <= pma_ctrl1_ch2_reg(8 DOWNTO 5);
 rtx_vtt_ch2_int              <= pma_ctrl1_ch2_reg(4 DOWNTO 3);
 rpmphs_ptap_ch2_int          <= pma_ctrl1_ch2_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 1 for channel3 (4.8063h)
 rtx_vod_sel_ch3_int          <= pma_ctrl1_ch3_reg(15 DOWNTO 13);
 rtx_slewrate_int(3)          <= pma_ctrl1_ch3_reg(12);
 rpmphs_2tap_ch3_int          <= pma_ctrl1_ch3_reg(11 DOWNTO 9);
 rpmphs_1tap_ch3_int          <= pma_ctrl1_ch3_reg(8 DOWNTO 5);
 rtx_vtt_ch3_int              <= pma_ctrl1_ch3_reg(4 DOWNTO 3);
 rpmphs_ptap_ch3_int          <= pma_ctrl1_ch3_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 2 for channel0 (4.8064h)
 rtx_term_ch0_int             <= pma_ctrl2_ch0_reg(15 DOWNTO 14);
 r_tx_det_rx_ch0_int          <= pma_ctrl2_ch0_reg(13 DOWNTO 12);
 rrx_term_ch0_int             <= pma_ctrl2_ch0_reg(11 DOWNTO 10);
 rforce_sigdet_int(0)         <= pma_ctrl2_ch0_reg(9);
 rrx_dc_couple_int(0)         <= pma_ctrl2_ch0_reg(8);
 rrx_eq_dc_ch0_int            <= pma_ctrl2_ch0_reg(7 DOWNTO 6);
 rrx_vtt_ch0_int              <= pma_ctrl2_ch0_reg(5 DOWNTO 3);
 rrx_sloslv_ch0_int           <= pma_ctrl2_ch0_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 2 for channel1 (4.8065h)
 rtx_term_ch1_int             <= pma_ctrl2_ch1_reg(15 DOWNTO 14);
 r_tx_det_rx_ch1_int          <= pma_ctrl2_ch1_reg(13 DOWNTO 12);
 rrx_term_ch1_int             <= pma_ctrl2_ch1_reg(11 DOWNTO 10);
 rforce_sigdet_int(1)         <= pma_ctrl2_ch1_reg(9);
 rrx_dc_couple_int(1)         <= pma_ctrl2_ch1_reg(8);
 rrx_eq_dc_ch1_int            <= pma_ctrl2_ch1_reg(7 DOWNTO 6);
 rrx_vtt_ch1_int              <= pma_ctrl2_ch1_reg(5 DOWNTO 3);
 rrx_sloslv_ch1_int           <= pma_ctrl2_ch1_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 2 for channel2 (4.8066h)
 rtx_term_ch2_int             <= pma_ctrl2_ch2_reg(15 DOWNTO 14);
 r_tx_det_rx_ch2_int          <= pma_ctrl2_ch2_reg(13 DOWNTO 12);
 rrx_term_ch2_int             <= pma_ctrl2_ch2_reg(11 DOWNTO 10);
 rforce_sigdet_int(2)         <= pma_ctrl2_ch2_reg(9);
 rrx_dc_couple_int(2)         <= pma_ctrl2_ch2_reg(8);
 rrx_eq_dc_ch2_int            <= pma_ctrl2_ch2_reg(7 DOWNTO 6);
 rrx_vtt_ch2_int              <= pma_ctrl2_ch2_reg(5 DOWNTO 3);
 rrx_sloslv_ch2_int           <= pma_ctrl2_ch2_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 2 for channel3 (4.8067h)
 rtx_term_ch3_int             <= pma_ctrl2_ch3_reg(15 DOWNTO 14);
 r_tx_det_rx_ch3_int          <= pma_ctrl2_ch3_reg(13 DOWNTO 12);
 rrx_term_ch3_int             <= pma_ctrl2_ch3_reg(11 DOWNTO 10);
 rforce_sigdet_int(3)         <= pma_ctrl2_ch3_reg(9);
 rrx_dc_couple_int(3)         <= pma_ctrl2_ch3_reg(8);
 rrx_eq_dc_ch3_int            <= pma_ctrl2_ch3_reg(7 DOWNTO 6);
 rrx_vtt_ch3_int              <= pma_ctrl2_ch3_reg(5 DOWNTO 3);
 rrx_sloslv_ch3_int           <= pma_ctrl2_ch3_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 3 for channel0 (4.8068h)
	reqa_ct_ch0_int	             <= pma_ctrl3_ch0_reg(15 DOWNTO 13);
	reqb_ct_ch0_int	             <= pma_ctrl3_ch0_reg(12 DOWNTO 10);
	reqc_ct_ch0_int	             <= pma_ctrl3_ch0_reg(9 DOWNTO 7);
	reqd_ct_ch0_int	             <= pma_ctrl3_ch0_reg(6 DOWNTO 4);
	req_ctv_ch0_int	             <= pma_ctrl3_ch0_reg(3 DOWNTO 1);

-- Outputs from PMA Per channel control register 3 for channel1 (4.8069h)
	reqa_ct_ch1_int	             <= pma_ctrl3_ch1_reg(15 DOWNTO 13);
	reqb_ct_ch1_int	             <= pma_ctrl3_ch1_reg(12 DOWNTO 10);
	reqc_ct_ch1_int	             <= pma_ctrl3_ch1_reg(9 DOWNTO 7);
	reqd_ct_ch1_int	             <= pma_ctrl3_ch1_reg(6 DOWNTO 4);
	req_ctv_ch1_int	             <= pma_ctrl3_ch1_reg(3 DOWNTO 1);

-- Outputs from PMA Per channel control register 3 for channel2 (4.806Ah)
	reqa_ct_ch2_int	             <= pma_ctrl3_ch2_reg(15 DOWNTO 13);
	reqb_ct_ch2_int	             <= pma_ctrl3_ch2_reg(12 DOWNTO 10);
	reqc_ct_ch2_int	             <= pma_ctrl3_ch2_reg(9 DOWNTO 7);
	reqd_ct_ch2_int	             <= pma_ctrl3_ch2_reg(6 DOWNTO 4);
	req_ctv_ch2_int	             <= pma_ctrl3_ch2_reg(3 DOWNTO 1);

-- Outputs from PMA Per channel control register 3 for channel3 (4.806Bh)
	reqa_ct_ch3_int	             <= pma_ctrl3_ch3_reg(15 DOWNTO 13);
	reqb_ct_ch3_int	             <= pma_ctrl3_ch3_reg(12 DOWNTO 10);
	reqc_ct_ch3_int	             <= pma_ctrl3_ch3_reg(9 DOWNTO 7);
	reqd_ct_ch3_int	             <= pma_ctrl3_ch3_reg(6 DOWNTO 4);
	req_ctv_ch3_int	             <= pma_ctrl3_ch3_reg(3 DOWNTO 1);

-- Outputs from PMA Per channel control register 4 for channel0 (4.806Ch)
 rpmadwidth_tx_int(0)         <= pma_ctrl4_ch0_reg(15);
 rpma_doublewidth_tx_int(0)   <= pma_ctrl4_ch0_reg(14);
 rtx_cmu_sel_int(0)           <= pma_ctrl4_ch0_reg(13);
 rtx_m_sel_ch0_int            <= pma_ctrl4_ch0_reg(12 DOWNTO 11);
 rtxvcobypass_int(0)          <= pma_ctrl4_ch0_reg(10);
 rtx_cgb_1x_en_int(0)         <= pma_ctrl4_ch0_reg(9);
 rtx_cgb_4x_en_int(0)         <= pma_ctrl4_ch0_reg(8);
 rtx_4x_sw_int(0)             <= pma_ctrl4_ch0_reg(7);
 rpmadwidth_rx_int(0)         <= pma_ctrl4_ch0_reg(6);
 rpma_doublewidth_rx_int(0)   <= pma_ctrl4_ch0_reg(5);
 rrxvcobypass_int(0)          <= pma_ctrl4_ch0_reg(4);
 rrect_adj_ch0_int            <= pma_ctrl4_ch0_reg(3 DOWNTO 2);
 rrx_piso_bypass_ch0_int      <= pma_ctrl4_ch0_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 4 for channel1 (4.806Dh)
 rpmadwidth_tx_int(1)         <= pma_ctrl4_ch1_reg(15);
 rpma_doublewidth_tx_int(1)   <= pma_ctrl4_ch1_reg(14);
 rtx_cmu_sel_int(1)           <= pma_ctrl4_ch1_reg(13);
 rtx_m_sel_ch1_int            <= pma_ctrl4_ch1_reg(12 DOWNTO 11);
 rtxvcobypass_int(1)          <= pma_ctrl4_ch1_reg(10);
 rtx_cgb_1x_en_int(1)         <= pma_ctrl4_ch1_reg(9);
 rtx_cgb_4x_en_int(1)         <= pma_ctrl4_ch1_reg(8);
 rtx_4x_sw_int(1)             <= pma_ctrl4_ch1_reg(7);
 rpmadwidth_rx_int(1)         <= pma_ctrl4_ch1_reg(6);
 rpma_doublewidth_rx_int(1)   <= pma_ctrl4_ch1_reg(5);
 rrxvcobypass_int(1)          <= pma_ctrl4_ch1_reg(4);
 rrect_adj_ch1_int            <= pma_ctrl4_ch1_reg(3 DOWNTO 2);
 rrx_piso_bypass_ch1_int      <= pma_ctrl4_ch1_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 4 for channel2 (4.806Eh)
 rpmadwidth_tx_int(2)         <= pma_ctrl4_ch2_reg(15);
 rpma_doublewidth_tx_int(2)   <= pma_ctrl4_ch2_reg(14);
 rtx_cmu_sel_int(2)           <= pma_ctrl4_ch2_reg(13);
 rtx_m_sel_ch2_int            <= pma_ctrl4_ch2_reg(12 DOWNTO 11);
 rtxvcobypass_int(2)          <= pma_ctrl4_ch2_reg(10);
 rtx_cgb_1x_en_int(2)         <= pma_ctrl4_ch2_reg(9);
 rtx_cgb_4x_en_int(2)         <= pma_ctrl4_ch2_reg(8);
 rtx_4x_sw_int(2)             <= pma_ctrl4_ch2_reg(7);
 rpmadwidth_rx_int(2)         <= pma_ctrl4_ch2_reg(6);
 rpma_doublewidth_rx_int(2)   <= pma_ctrl4_ch2_reg(5);
 rrxvcobypass_int(2)          <= pma_ctrl4_ch2_reg(4);
 rrect_adj_ch2_int            <= pma_ctrl4_ch2_reg(3 DOWNTO 2);
 rrx_piso_bypass_ch2_int      <= pma_ctrl4_ch2_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 4 for channel3 (4.806Fh)
 rpmadwidth_tx_int(3)         <= pma_ctrl4_ch3_reg(15);
 rpma_doublewidth_tx_int(3)   <= pma_ctrl4_ch3_reg(14);
 rtx_cmu_sel_int(3)           <= pma_ctrl4_ch3_reg(13);
 rtx_m_sel_ch3_int            <= pma_ctrl4_ch3_reg(12 DOWNTO 11);
 rtxvcobypass_int(3)          <= pma_ctrl4_ch3_reg(10);
 rtx_cgb_1x_en_int(3)         <= pma_ctrl4_ch3_reg(9);
 rtx_cgb_4x_en_int(3)         <= pma_ctrl4_ch3_reg(8);
 rtx_4x_sw_int(3)             <= pma_ctrl4_ch3_reg(7);
 rpmadwidth_rx_int(3)         <= pma_ctrl4_ch3_reg(6);
 rpma_doublewidth_rx_int(3)   <= pma_ctrl4_ch3_reg(5);
 rrxvcobypass_int(3)          <= pma_ctrl4_ch3_reg(4);
 rrect_adj_ch3_int            <= pma_ctrl4_ch3_reg(3 DOWNTO 2);
 rrx_piso_bypass_ch3_int      <= pma_ctrl4_ch3_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 5 for channel0 (4.8070h)
	rlst_tx_ch0_int              <= pma_ctrl5_ch0_reg(15 DOWNTO 12);
	rlst_rx_ch0_int              <= pma_ctrl5_ch0_reg(11 DOWNTO 8);
	rlst_rxpll_ch0_int           <= pma_ctrl5_ch0_reg(7 DOWNTO 4);
	rrx_ignore_phslck_int(0)     <= pma_ctrl5_ch0_reg(3);
	rdc_freq_ch0_int             <= pma_ctrl5_ch0_reg(2 DOWNTO 1);
	rrx_osc_en_int(0)            <= pma_ctrl5_ch0_reg(0);

-- Outputs from PMA Per channel control register 5 for channel1 (4.8071h)
	rlst_tx_ch1_int              <= pma_ctrl5_ch1_reg(15 DOWNTO 12);
	rlst_rx_ch1_int              <= pma_ctrl5_ch1_reg(11 DOWNTO 8);
	rlst_rxpll_ch1_int           <= pma_ctrl5_ch1_reg(7 DOWNTO 4);
	rrx_ignore_phslck_int(1)     <= pma_ctrl5_ch1_reg(3);
	rdc_freq_ch1_int             <= pma_ctrl5_ch1_reg(2 DOWNTO 1);
	rrx_osc_en_int(1)            <= pma_ctrl5_ch1_reg(0);

-- Outputs from PMA Per channel control register 5 for channel2 (4.8072h)
	rlst_tx_ch2_int              <= pma_ctrl5_ch2_reg(15 DOWNTO 12);
	rlst_rx_ch2_int              <= pma_ctrl5_ch2_reg(11 DOWNTO 8);
	rlst_rxpll_ch2_int           <= pma_ctrl5_ch2_reg(7 DOWNTO 4);
	rrx_ignore_phslck_int(2)     <= pma_ctrl5_ch2_reg(3);
	rdc_freq_ch2_int             <= pma_ctrl5_ch2_reg(2 DOWNTO 1);
	rrx_osc_en_int(2)            <= pma_ctrl5_ch2_reg(0);

-- Outputs from PMA Per channel control register 5 for channel3 (4.8073h)
	rlst_tx_ch3_int              <= pma_ctrl5_ch3_reg(15 DOWNTO 12);
	rlst_rx_ch3_int              <= pma_ctrl5_ch3_reg(11 DOWNTO 8);
	rlst_rxpll_ch3_int           <= pma_ctrl5_ch3_reg(7 DOWNTO 4);
	rrx_ignore_phslck_int(3)     <= pma_ctrl5_ch3_reg(3);
	rdc_freq_ch3_int             <= pma_ctrl5_ch3_reg(2 DOWNTO 1);
	rrx_osc_en_int(3)            <= pma_ctrl5_ch3_reg(0);

-- Outputs from PMA Per channel control register 6 for channel0 (4.8074h)
	rrefclk_sel_ch0_int          <= pma_ctrl6_ch0_reg(15 DOWNTO 13);
	rbwctral_rx_ch0_int          <= pma_ctrl6_ch0_reg(12 DOWNTO 11);
	rrx_cru_m_sel_ch0_int        <= pma_ctrl6_ch0_reg(10 DOWNTO 9);
	rrx_cru_div2_int(0)          <= pma_ctrl6_ch0_reg(8);
	rrx_cru_ctl_ch0_int          <= pma_ctrl6_ch0_reg(7 DOWNTO 2);
	rltr_int(0)		             <= pma_ctrl6_ch0_reg(1);
	rltd_int(0)		             <= pma_ctrl6_ch0_reg(0);

-- Outputs from PMA Per channel control register 6 for channel1 (4.8075h)
	rrefclk_sel_ch1_int          <= pma_ctrl6_ch1_reg(15 DOWNTO 13);
	rbwctral_rx_ch1_int          <= pma_ctrl6_ch1_reg(12 DOWNTO 11);
	rrx_cru_m_sel_ch1_int        <= pma_ctrl6_ch1_reg(10 DOWNTO 9);
	rrx_cru_div2_int(1)          <= pma_ctrl6_ch1_reg(8);
	rrx_cru_ctl_ch1_int          <= pma_ctrl6_ch1_reg(7 DOWNTO 2);
	rltr_int(1)		             <= pma_ctrl6_ch1_reg(1);
	rltd_int(1)		             <= pma_ctrl6_ch1_reg(0);

-- Outputs from PMA Per channel control register 6 for channel2 (4.8076h)
	rrefclk_sel_ch2_int          <= pma_ctrl6_ch2_reg(15 DOWNTO 13);
	rbwctral_rx_ch2_int          <= pma_ctrl6_ch2_reg(12 DOWNTO 11);
	rrx_cru_m_sel_ch2_int        <= pma_ctrl6_ch2_reg(10 DOWNTO 9);
	rrx_cru_div2_int(2)          <= pma_ctrl6_ch2_reg(8);
	rrx_cru_ctl_ch2_int          <= pma_ctrl6_ch2_reg(7 DOWNTO 2);
	rltr_int(2)		             <= pma_ctrl6_ch2_reg(1);
	rltd_int(2)		             <= pma_ctrl6_ch2_reg(0);

-- Outputs from PMA Per channel control register 6 for channel3 (4.8077h)
	rrefclk_sel_ch3_int          <= pma_ctrl6_ch3_reg(15 DOWNTO 13);
	rbwctral_rx_ch3_int          <= pma_ctrl6_ch3_reg(12 DOWNTO 11);
	rrx_cru_m_sel_ch3_int        <= pma_ctrl6_ch3_reg(10 DOWNTO 9);
	rrx_cru_div2_int(3)          <= pma_ctrl6_ch3_reg(8);
	rrx_cru_ctl_ch3_int          <= pma_ctrl6_ch3_reg(7 DOWNTO 2);
	rltr_int(3)		             <= pma_ctrl6_ch3_reg(1);
	rltd_int(3)		             <= pma_ctrl6_ch3_reg(0);

-- Outputs from PMA Per channel control register 7 for channel0 (4.8078h)
	risel_rx_ch0_int             <= pma_ctrl7_ch0_reg(15 DOWNTO 14);
	riupsel_rx_ch0_int           <= pma_ctrl7_ch0_reg(13 DOWNTO 12);
	ridnsel_rx_ch0_int           <= pma_ctrl7_ch0_reg(11 DOWNTO 10);
	rtesten_cp_rx_int(0)         <= pma_ctrl7_ch0_reg(9);
	rtristate_cp_rx_int(0)       <= pma_ctrl7_ch0_reg(8);
	rtestupen_cp_rx_int(0)       <= pma_ctrl7_ch0_reg(7);
	rtestdnen_cp_rx_int(0)       <= pma_ctrl7_ch0_reg(6);
	rrx_cru_m_ch0_int            <= pma_ctrl7_ch0_reg(5 DOWNTO 2);
	rrx_cru_l_ch0_int            <= pma_ctrl7_ch0_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 7 for channel1 (4.8079h)
	risel_rx_ch1_int             <= pma_ctrl7_ch1_reg(15 DOWNTO 14);
	riupsel_rx_ch1_int           <= pma_ctrl7_ch1_reg(13 DOWNTO 12);
	ridnsel_rx_ch1_int           <= pma_ctrl7_ch1_reg(11 DOWNTO 10);
	rtesten_cp_rx_int(1)         <= pma_ctrl7_ch1_reg(9);
	rtristate_cp_rx_int(1)       <= pma_ctrl7_ch1_reg(8);
	rtestupen_cp_rx_int(1)       <= pma_ctrl7_ch1_reg(7);
	rtestdnen_cp_rx_int(1)       <= pma_ctrl7_ch1_reg(6);
	rrx_cru_m_ch1_int            <= pma_ctrl7_ch1_reg(5 DOWNTO 2);
	rrx_cru_l_ch1_int            <= pma_ctrl7_ch1_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 7 for channel2 (4.807Ah)
	risel_rx_ch2_int             <= pma_ctrl7_ch2_reg(15 DOWNTO 14);
	riupsel_rx_ch2_int           <= pma_ctrl7_ch2_reg(13 DOWNTO 12);
	ridnsel_rx_ch2_int           <= pma_ctrl7_ch2_reg(11 DOWNTO 10);
	rtesten_cp_rx_int(2)         <= pma_ctrl7_ch2_reg(9);
	rtristate_cp_rx_int(2)       <= pma_ctrl7_ch2_reg(8);
	rtestupen_cp_rx_int(2)       <= pma_ctrl7_ch2_reg(7);
	rtestdnen_cp_rx_int(2)       <= pma_ctrl7_ch2_reg(6);
	rrx_cru_m_ch2_int            <= pma_ctrl7_ch2_reg(5 DOWNTO 2);
	rrx_cru_l_ch2_int            <= pma_ctrl7_ch2_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 7 for channel3 (4.807Bh)
	risel_rx_ch3_int             <= pma_ctrl7_ch3_reg(15 DOWNTO 14);
	riupsel_rx_ch3_int           <= pma_ctrl7_ch3_reg(13 DOWNTO 12);
	ridnsel_rx_ch3_int           <= pma_ctrl7_ch3_reg(11 DOWNTO 10);
	rtesten_cp_rx_int(3)         <= pma_ctrl7_ch3_reg(9);
	rtristate_cp_rx_int(3)       <= pma_ctrl7_ch3_reg(8);
	rtestupen_cp_rx_int(3)       <= pma_ctrl7_ch3_reg(7);
	rtestdnen_cp_rx_int(3)       <= pma_ctrl7_ch3_reg(6);
	rrx_cru_m_ch3_int            <= pma_ctrl7_ch3_reg(5 DOWNTO 2);
	rrx_cru_l_ch3_int            <= pma_ctrl7_ch3_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 8 for channel0 (4.807Ch)
	rs_lpbk_int(0)        	     <= pma_ctrl8_ch0_reg(15);
	r_rlpbk_int(0)        	     <= pma_ctrl8_ch0_reg(14);
	rs_rdlpbk_int(0)             <= pma_ctrl8_ch0_reg(13);
	rrx_revlb_sw_int(0)          <= pma_ctrl8_ch0_reg(12);
	rurx_pdb_int(0)        	     <= pma_ctrl8_ch0_reg(11);
	rtx_cgb_pdb_int(0)           <= pma_ctrl8_ch0_reg(10);
	rtx_ob_pdb_int(0)            <= pma_ctrl8_ch0_reg(9);
	rrx_cru_pdb_int(0)           <= pma_ctrl8_ch0_reg(8);
	rrx_cru_rst_int(0)           <= pma_ctrl8_ch0_reg(7);
	rrx_ib_pdb_int(0)            <= pma_ctrl8_ch0_reg(6);
	rrxurstpma_md(0)             <= pma_ctrl8_ch0_reg(5);
	radce_adapt_int(0)           <= pma_ctrl8_ch0_reg(4);
	radce_pdb_int(0)             <= pma_ctrl8_ch0_reg(3);
	radce_rst_int(0)             <= pma_ctrl8_ch0_reg(2);
	rsig_inv_2tap_int(0)         <= pma_ctrl8_ch0_reg(1);
	rsig_inv_pre_int(0)          <= pma_ctrl8_ch0_reg(0);

-- Outputs from PMA Per channel control register 8 for channel1 (4.807Dh)
	rs_lpbk_int(1)        	     <= pma_ctrl8_ch1_reg(15);
	r_rlpbk_int(1)        	     <= pma_ctrl8_ch1_reg(14);
	rs_rdlpbk_int(1)             <= pma_ctrl8_ch1_reg(13);
	rrx_revlb_sw_int(1)          <= pma_ctrl8_ch1_reg(12);
	rurx_pdb_int(1)        	     <= pma_ctrl8_ch1_reg(11);
	rtx_cgb_pdb_int(1)           <= pma_ctrl8_ch1_reg(10);
	rtx_ob_pdb_int(1)            <= pma_ctrl8_ch1_reg(9);
	rrx_cru_pdb_int(1)           <= pma_ctrl8_ch1_reg(8);
	rrx_cru_rst_int(1)           <= pma_ctrl8_ch1_reg(7);
	rrx_ib_pdb_int(1)            <= pma_ctrl8_ch1_reg(6);
	rrxurstpma_md(1)             <= pma_ctrl8_ch1_reg(5);
	radce_adapt_int(1)           <= pma_ctrl8_ch1_reg(4);
	radce_pdb_int(1)             <= pma_ctrl8_ch1_reg(3);
	radce_rst_int(1)             <= pma_ctrl8_ch1_reg(2);
	rsig_inv_2tap_int(1)         <= pma_ctrl8_ch1_reg(1);
	rsig_inv_pre_int(1)          <= pma_ctrl8_ch1_reg(0);

-- Outputs from PMA Per channel control register 8 for channel2 (4.807Eh)
	rs_lpbk_int(2)        	     <= pma_ctrl8_ch2_reg(15);
	r_rlpbk_int(2)        	     <= pma_ctrl8_ch2_reg(14);
	rs_rdlpbk_int(2)             <= pma_ctrl8_ch2_reg(13);
	rrx_revlb_sw_int(2)          <= pma_ctrl8_ch2_reg(12);
	rurx_pdb_int(2)        	     <= pma_ctrl8_ch2_reg(11);
	rtx_cgb_pdb_int(2)           <= pma_ctrl8_ch2_reg(10);
	rtx_ob_pdb_int(2)            <= pma_ctrl8_ch2_reg(9);
	rrx_cru_pdb_int(2)           <= pma_ctrl8_ch2_reg(8);
	rrx_cru_rst_int(2)           <= pma_ctrl8_ch2_reg(7);
	rrx_ib_pdb_int(2)            <= pma_ctrl8_ch2_reg(6);
	rrxurstpma_md(2)             <= pma_ctrl8_ch2_reg(5);
	radce_adapt_int(2)           <= pma_ctrl8_ch2_reg(4);
	radce_pdb_int(2)             <= pma_ctrl8_ch2_reg(3);
	radce_rst_int(2)             <= pma_ctrl8_ch2_reg(2);
	rsig_inv_2tap_int(2)         <= pma_ctrl8_ch2_reg(1);
	rsig_inv_pre_int(2)          <= pma_ctrl8_ch2_reg(0);

-- Outputs from PMA Per channel control register 8 for channel3 (4.807Fh)
	rs_lpbk_int(3)        	     <= pma_ctrl8_ch3_reg(15);
	r_rlpbk_int(3)        	     <= pma_ctrl8_ch3_reg(14);
	rs_rdlpbk_int(3)             <= pma_ctrl8_ch3_reg(13);
	rrx_revlb_sw_int(3)          <= pma_ctrl8_ch3_reg(12);
	rurx_pdb_int(3)        	     <= pma_ctrl8_ch3_reg(11);
	rtx_cgb_pdb_int(3)           <= pma_ctrl8_ch3_reg(10);
	rtx_ob_pdb_int(3)            <= pma_ctrl8_ch3_reg(9);
	rrx_cru_pdb_int(3)           <= pma_ctrl8_ch3_reg(8);
	rrx_cru_rst_int(3)           <= pma_ctrl8_ch3_reg(7);
	rrx_ib_pdb_int(3)            <= pma_ctrl8_ch3_reg(6);
	rrxurstpma_md(3)             <= pma_ctrl8_ch3_reg(5);
	radce_adapt_int(3)           <= pma_ctrl8_ch3_reg(4);
	radce_pdb_int(3)             <= pma_ctrl8_ch3_reg(3);
	radce_rst_int(3)             <= pma_ctrl8_ch3_reg(2);
	rsig_inv_2tap_int(3)         <= pma_ctrl8_ch3_reg(1);
	rsig_inv_pre_int(3)          <= pma_ctrl8_ch3_reg(0);

-- Outputs from PMA Per channel control register 9 for channel0 (4.8080h)
	rseq_sel_ch0_int	     <= pma_ctrl9_ch0_reg(15 DOWNTO 14);
	rrgen_set_ch0_int	     <= pma_ctrl9_ch0_reg(13 DOWNTO 11);
	rclkdiv_ch0_int 	     <= pma_ctrl9_ch0_reg(10 DOWNTO 7);
	rf_lpf_ch0_int  	     <= pma_ctrl9_ch0_reg(6 DOWNTO 5);
	rf_hpf_ch0_int  	     <= pma_ctrl9_ch0_reg(4 DOWNTO 3);
	rrgen_bw_ch0_int  	     <= pma_ctrl9_ch0_reg(2 DOWNTO 1);

-- Outputs from PMA Per channel control register 9 for channel1 (4.8081h)
	rseq_sel_ch1_int	     <= pma_ctrl9_ch1_reg(15 DOWNTO 14);
	rrgen_set_ch1_int	     <= pma_ctrl9_ch1_reg(13 DOWNTO 11);
	rclkdiv_ch1_int 	     <= pma_ctrl9_ch1_reg(10 DOWNTO 7);
	rf_lpf_ch1_int  	     <= pma_ctrl9_ch1_reg(6 DOWNTO 5);
	rf_hpf_ch1_int  	     <= pma_ctrl9_ch1_reg(4 DOWNTO 3);
	rrgen_bw_ch1_int  	     <= pma_ctrl9_ch1_reg(2 DOWNTO 1);

-- Outputs from PMA Per channel control register 9 for channel2 (4.8082h)
	rseq_sel_ch2_int	     <= pma_ctrl9_ch2_reg(15 DOWNTO 14);
	rrgen_set_ch2_int	     <= pma_ctrl9_ch2_reg(13 DOWNTO 11);
	rclkdiv_ch2_int 	     <= pma_ctrl9_ch2_reg(10 DOWNTO 7);
	rf_lpf_ch2_int  	     <= pma_ctrl9_ch2_reg(6 DOWNTO 5);
	rf_hpf_ch2_int  	     <= pma_ctrl9_ch2_reg(4 DOWNTO 3);
	rrgen_bw_ch2_int  	     <= pma_ctrl9_ch2_reg(2 DOWNTO 1);

-- Outputs from PMA Per channel control register 9 for channel3 (4.8083h)
	rseq_sel_ch3_int	     <= pma_ctrl9_ch3_reg(15 DOWNTO 14);
	rrgen_set_ch3_int	     <= pma_ctrl9_ch3_reg(13 DOWNTO 11);
	rclkdiv_ch3_int 	     <= pma_ctrl9_ch3_reg(10 DOWNTO 7);
	rf_lpf_ch3_int  	     <= pma_ctrl9_ch3_reg(6 DOWNTO 5);
	rf_hpf_ch3_int  	     <= pma_ctrl9_ch3_reg(4 DOWNTO 3);
	rrgen_bw_ch3_int  	     <= pma_ctrl9_ch3_reg(2 DOWNTO 1);

-- Outputs from PMA Per channel control register 10 for channel0 (4.8084h)
	rhyst_ch0_int	         <= pma_ctrl10_ch0_reg(15 DOWNTO 13);
	rd2a_res_ch0_int	     <= pma_ctrl10_ch0_reg(12 DOWNTO 11);
	rrgen_vod_ch0_int	     <= pma_ctrl10_ch0_reg(10 DOWNTO 8);
	rlf_os_ch0_int	         <= pma_ctrl10_ch0_reg(7 DOWNTO 4);
	rhf_os_ch0_int	         <= pma_ctrl10_ch0_reg(3 DOWNTO 0);

-- Outputs from PMA Per channel control register 10 for channel1 (4.8085h)
	rhyst_ch1_int	         <= pma_ctrl10_ch1_reg(15 DOWNTO 13);
	rd2a_res_ch1_int	     <= pma_ctrl10_ch1_reg(12 DOWNTO 11);
	rrgen_vod_ch1_int	     <= pma_ctrl10_ch1_reg(10 DOWNTO 8);
	rlf_os_ch1_int	         <= pma_ctrl10_ch1_reg(7 DOWNTO 4);
	rhf_os_ch1_int	         <= pma_ctrl10_ch1_reg(3 DOWNTO 0);

-- Outputs from PMA Per channel control register 10 for channel2 (4.8086h)
	rhyst_ch2_int	         <= pma_ctrl10_ch2_reg(15 DOWNTO 13);
	rd2a_res_ch2_int	     <= pma_ctrl10_ch2_reg(12 DOWNTO 11);
	rrgen_vod_ch2_int	     <= pma_ctrl10_ch2_reg(10 DOWNTO 8);
	rlf_os_ch2_int	         <= pma_ctrl10_ch2_reg(7 DOWNTO 4);
	rhf_os_ch2_int	         <= pma_ctrl10_ch2_reg(3 DOWNTO 0);

-- Outputs from PMA Per channel control register 10 for channel3 (4.8087h)
	rhyst_ch3_int	         <= pma_ctrl10_ch3_reg(15 DOWNTO 13);
	rd2a_res_ch3_int	     <= pma_ctrl10_ch3_reg(12 DOWNTO 11);
	rrgen_vod_ch3_int	     <= pma_ctrl10_ch3_reg(10 DOWNTO 8);
	rlf_os_ch3_int	         <= pma_ctrl10_ch3_reg(7 DOWNTO 4);
	rhf_os_ch3_int	         <= pma_ctrl10_ch3_reg(3 DOWNTO 0);

-- Outputs from PMA Per channel control register 11 for channel0 (4.8088h)
	r_iqclk_ch0_int    	     <= pma_ctrl11_ch0_reg(15 DOWNTO 12);
	r_dfe_ch0_int     	     <= pma_ctrl11_ch0_reg(11 DOWNTO 6);
	r_cp_mode_int(0)    	 <= pma_ctrl11_ch0_reg(5);
	rreg_cp_rx_int(0)    	 <= pma_ctrl11_ch0_reg(4);
	r_impctrl_ch0_int    	 <= pma_ctrl11_ch0_reg(3 DOWNTO 2);
	rpd_ien_int(0)    	     <= pma_ctrl11_ch0_reg(1);

-- Outputs from PMA Per channel control register 11 for channel1 (4.8089h)
	r_iqclk_ch1_int    	     <= pma_ctrl11_ch1_reg(15 DOWNTO 12);
	r_dfe_ch1_int     	     <= pma_ctrl11_ch1_reg(11 DOWNTO 6);
	r_cp_mode_int(1)    	 <= pma_ctrl11_ch1_reg(5);
	rreg_cp_rx_int(1)    	 <= pma_ctrl11_ch1_reg(4);
	r_impctrl_ch1_int    	 <= pma_ctrl11_ch1_reg(3 DOWNTO 2);
	rpd_ien_int(1)    	     <= pma_ctrl11_ch1_reg(1);

-- Outputs from PMA Per channel control register 11 for channel2 (4.808Ah)
	r_iqclk_ch2_int    	     <= pma_ctrl11_ch2_reg(15 DOWNTO 12);
	r_dfe_ch2_int     	     <= pma_ctrl11_ch2_reg(11 DOWNTO 6);
	r_cp_mode_int(2)    	 <= pma_ctrl11_ch2_reg(5);
	rreg_cp_rx_int(2)    	 <= pma_ctrl11_ch2_reg(4);
	r_impctrl_ch2_int    	 <= pma_ctrl11_ch2_reg(3 DOWNTO 2);
	rpd_ien_int(2)    	     <= pma_ctrl11_ch2_reg(1);

-- Outputs from PMA Per channel control register 11 for channel3 (4.808Bh)
	r_iqclk_ch3_int    	     <= pma_ctrl11_ch3_reg(15 DOWNTO 12);
	r_dfe_ch3_int     	     <= pma_ctrl11_ch3_reg(11 DOWNTO 6);
	r_cp_mode_int(3)    	 <= pma_ctrl11_ch3_reg(5);
	rreg_cp_rx_int(3)    	 <= pma_ctrl11_ch3_reg(4);
	r_impctrl_ch3_int    	 <= pma_ctrl11_ch3_reg(3 DOWNTO 2);
	rpd_ien_int(3)    	     <= pma_ctrl11_ch3_reg(1);


-- Outputs from PMA Global control register 0 (4.8090h)
	rbgbypass_int	          <= pma_global_ctrl0_reg(15);
	rlst_bg_int	              <= pma_global_ctrl0_reg(13 DOWNTO 10);
	rcmu_rst_int	          <= pma_global_ctrl0_reg(9);
    rcmu2_isel_int            <= pma_global_ctrl0_reg(5 DOWNTO 4); 
	rcmu0_isel_int	          <= pma_global_ctrl0_reg(3 DOWNTO 2);
	rcmu1_isel_int	          <= pma_global_ctrl0_reg(1 DOWNTO 0);

-- Outputs from PMA Global control register 1 (4.8091h)
	rcmu0_iupsel_int        <= pma_global_ctrl1_reg(15 DOWNTO 14);
	rcmu1_iupsel_int        <= pma_global_ctrl1_reg(13 DOWNTO 12);
	rcmu2_iupsel_int        <= pma_global_ctrl1_reg(11 DOWNTO 10);
	rcmu0_idnsel_int        <= pma_global_ctrl1_reg(9 DOWNTO 8);
	rcmu1_idnsel_int        <= pma_global_ctrl1_reg(7 DOWNTO 6);
	rcmu2_idnsel_int        <= pma_global_ctrl1_reg(5 DOWNTO 4);
	rcmu0_testen_cp_int     <= pma_global_ctrl1_reg(3);
	rcmu1_testen_cp_int     <= pma_global_ctrl1_reg(2);
	rcmu0_tristate_cp_int   <= pma_global_ctrl1_reg(1);
	rcmu1_tristate_cp_int   <= pma_global_ctrl1_reg(0);

-- Outputs from PMA Global control register 2 (4.8092h)
	rcmu0_lst_int		<= pma_global_ctrl2_reg(13 DOWNTO 10);
	rcmu1_lst_int		<= pma_global_ctrl2_reg(9 DOWNTO 6);
	rcmu0_div2_int		<= pma_global_ctrl2_reg(5);
	rcmu1_div2_int		<= pma_global_ctrl2_reg(4);
	rcmu0_ref_sel_int	<= pma_global_ctrl2_reg(3 DOWNTO 2);
	rcmu1_ref_sel_int	<= pma_global_ctrl2_reg(1 DOWNTO 0);

-- Outputs from PMA Global control register 3 (4.8093h)
	rcmu0_ctl_int	        <= pma_global_ctrl3_reg(15 DOWNTO 8);
	rcmu1_ctl_int	        <= pma_global_ctrl3_reg(7 DOWNTO 0);

-- Outputs from PMA Global control register 4 (4.8094h)
	rcmu0_m_int		<= pma_global_ctrl4_reg(15 DOWNTO 12);
	rcmu1_m_int		<= pma_global_ctrl4_reg(11 DOWNTO 8);
	rcmu0_l_int		<= pma_global_ctrl4_reg(7 DOWNTO 6);
	rcmu1_l_int		<= pma_global_ctrl4_reg(5 DOWNTO 4);
	rcmu0_pdb_int		<= pma_global_ctrl4_reg(3);
	rcmu1_pdb_int		<= pma_global_ctrl4_reg(2);
	rcmu0_txpll_rst_int	<= pma_global_ctrl4_reg(1);
	rcmu1_txpll_rst_int	<= pma_global_ctrl4_reg(0);

-- Outputs from PMA Global control register 5 (4.8095h)
 rpma_testbus_sel_int    <= pma_global_ctrl5_reg(15 DOWNTO 12);
	rcmu_peclrx0_cm_int	<= pma_global_ctrl5_reg(11 DOWNTO 8);
	rcmu_peclrx1_cm_int	<= pma_global_ctrl5_reg(7 DOWNTO 4);
	rcmu0_testupen_cp_int	<= pma_global_ctrl5_reg(3);
	rcmu1_testupen_cp_int	<= pma_global_ctrl5_reg(2);
	rcmu0_testdnen_cp_int	<= pma_global_ctrl5_reg(1);
	rcmu1_testdnen_cp_int	<= pma_global_ctrl5_reg(0);

-- Outputs from PMA Global control register 6 (4.8096h)
	rcmu_peclrx0_lst_int	    <= pma_global_ctrl6_reg(15 DOWNTO 12);
	rcmu_peclrx1_lst_int	    <= pma_global_ctrl6_reg(11 DOWNTO 8);
    rcmu_iqclkout_sel_int       <= pma_global_ctrl6_reg(6);
    rcmu_txpll0_iqclkin_sel_int <= pma_global_ctrl6_reg(5 DOWNTO 3);
    rcmu_txpll1_iqclkin_sel_int <= pma_global_ctrl6_reg(2 DOWNTO 0);

-- Outputs from PMA Global control register 7 (4.8097h)
    rcmu_cgb_cmusel_int     <= pma_global_ctrl7_reg(15 DOWNTO 14);
    rcmu_cgb_ndiv_int       <= pma_global_ctrl7_reg(13 DOWNTO 12);
    rcmu_cgb_div5_int       <= pma_global_ctrl7_reg(11);
    rcmu_cgb_div2_int       <= pma_global_ctrl7_reg(10);
    rcmu_cgb_vcobypass_int  <= pma_global_ctrl7_reg(9);
	rcmu_txpll0_1x_en_int	<= pma_global_ctrl7_reg(8);
	rcmu_txpll1_1x_en_int	<= pma_global_ctrl7_reg(7);
    rcmu_cgb_4x_en_int      <= pma_global_ctrl7_reg(6);
    rcmu_cgb_8x_en_int      <= pma_global_ctrl7_reg(5);
    rcmu_cgb_pclksel_int    <= pma_global_ctrl7_reg(4);

-- Outputs from PMA Global control register 8 (4.8098h)
 rcmu2_testen_cp_int     <= pma_global_ctrl8_reg(15);
 rcmu2_tristate_cp_int   <= pma_global_ctrl8_reg(14);
 rcmu2_testupen_cp_int   <= pma_global_ctrl8_reg(13);
 rcmu2_testdnen_cp_int   <= pma_global_ctrl8_reg(12);
 rcmu2_lst_int           <= pma_global_ctrl8_reg(11 DOWNTO 8);
 rcmu2_ctl_int           <= pma_global_ctrl8_reg(7 DOWNTO 0);

-- Outputs from PMA Global control register 9 (4.8099h)
 rcmu2_refsel_int        <= pma_global_ctrl9_reg(15);
 rcmu2_m_int             <= pma_global_ctrl9_reg(14 DOWNTO 11);
 rcmu2_l_int             <= pma_global_ctrl9_reg(10 DOWNTO 9);
 rcmu2_pdb_int           <= pma_global_ctrl9_reg(8);
 rcmu2_txpll_rst_int     <= pma_global_ctrl9_reg(7);
 rcmu0_rcp_mode_int      <= pma_global_ctrl9_reg(6);
 rcmu1_rcp_mode_int      <= pma_global_ctrl9_reg(5);

--Control and Status Registers instantiation

-- Status Register
local_fault_0  : stratixiigx_hssi_bsc_out PORT MAP (reset => mdio_rst,
                        clk => mdc,
                        sig_in => local_fault,
                        jtag_mode => jtag_mode,
                        si => chain(126),
                        shift_load => jtag_shift_load,
                        sig_out => local_fault_ext,
                        so => chain(127));

xs_link_status_0 : stratixiigx_hssi_bsc_out PORT MAP (reset => mdio_rst,
                        clk => mdc,
                        sig_in => xs_link_status,
                        jtag_mode => jtag_mode,
                        si => chain(125),
                        shift_load => jtag_shift_load,
                        sig_out => xs_link_status_ext,
                        so => chain(126));

rx_local_fault_0 : stratixiigx_hssi_bsc_out PORT MAP (reset => mdio_rst,
                        clk => mdc,
                        sig_in => rx_local_fault,
                        jtag_mode => jtag_mode,
                        si => chain(124),
                        shift_load => jtag_shift_load,
                        sig_out => rx_local_fault_ext,
                        so => chain(125));

tx_local_fault_0 : stratixiigx_hssi_bsc_out PORT MAP (reset => mdio_rst,
                        clk => mdc,
                        sig_in => tx_local_fault,
                        jtag_mode => jtag_mode,
                        si => chain(123),
                        shift_load => jtag_shift_load,
                        sig_out => tx_local_fault_ext,
                        so => chain(124));

-- Single control bits
xs_link_status_set : stratixiigx_hssi_bsc_in_r PORT MAP (reset => mdio_rst, 
                             clk => mdc, 
                             sig_in => xs_link_status_rd, 
                             ext_in => rxs_link_status_set, 
                             jtag_mode => jtag_mode, 
                             si => chain(122), 
                             shift => jtag_shift_load, 
                             mdio_dis => mdio_dis,
                             sig_out => rxs_link_status_set_int, 
                             so => chain(123));

tx_rx_local_fault_clr : stratixiigx_hssi_bsc_in_r PORT MAP (reset => mdio_rst, 
                                clk => mdc, 
                                sig_in => tx_rx_local_fault_status_rd, 
                                ext_in => rtx_rx_local_fault_clr, 
                                jtag_mode => jtag_mode, 
                                si => my_gnd, 
                                shift => jtag_shift_load, 
                                mdio_dis => mdio_dis,
                                sig_out => rtx_rx_local_fault_clr_int, 
                                so => chain(122));
                        

-- Main control registers instantiation
xgxs_ctrl_0    : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                         mdio_wr => mdio_wr,
                         reg_addr => reg_addr,
                         target_addr => XGXS_CTRL,
                         clk => mdc,
                         sig_in => mbus_in,
                         ext_in => xgxs_ctrl_ext,
                         jtag_mode => jtag_mode,
                         si => chain(121),
                         shift => jtag_shift_load,
                         mdio_dis => mdio_dis,
                         sig_out => xgxs_ctrl_reg,
                         so => jtag_so);

trunking_mode_0 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => TRUNKING_MODE,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => trunking_mode_ext,
                        jtag_mode => jtag_mode,
                        si => chain(120),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => trunking_mode_reg,
                        so => chain(121));

pcs_ctrl1_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL1_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl1_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(119),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl1_ch0_reg,
                        so => chain(120));

pcs_ctrl1_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL1_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl1_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(118),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl1_ch1_reg,
                        so => chain(119));

pcs_ctrl1_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL1_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl1_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(117),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl1_ch2_reg,
                        so => chain(118));

pcs_ctrl1_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL1_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl1_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(116),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl1_ch3_reg,
                        so => chain(117));

pcs_ctrl2_0    : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL2_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl2_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(115),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl2_ch0_reg,
                        so => chain(116));

pcs_ctrl2_1    : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL2_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl2_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(114),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl2_ch1_reg,
                        so => chain(115));

pcs_ctrl2_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL2_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl2_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(113),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl2_ch2_reg,
                        so => chain(114));

pcs_ctrl2_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL2_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl2_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(112),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl2_ch3_reg,
                        so => chain(113));

pcs_ctrl3_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL3_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl3_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(111),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl3_ch0_reg,
                        so => chain(112));

pcs_ctrl3_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL3_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl3_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(110),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl3_ch1_reg,
                        so => chain(111));

pcs_ctrl3_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL3_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl3_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(109),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl3_ch2_reg,
                        so => chain(110));

pcs_ctrl3_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL3_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl3_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(108),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl3_ch3_reg,
                        so => chain(109));

pcs_ctrl4_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL4_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl4_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(107),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl4_ch0_reg,
                        so => chain(108));

pcs_ctrl4_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL4_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl4_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(106),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl4_ch1_reg,
                        so => chain(107));

pcs_ctrl4_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL4_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl4_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(105),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl4_ch2_reg,
                        so => chain(106));

pcs_ctrl4_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL4_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl4_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(104),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl4_ch3_reg,
                        so => chain(105));

pcs_ctrl5_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL5_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl5_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(103),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl5_ch0_reg,
                        so => chain(104));

pcs_ctrl5_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL5_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl5_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(102),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl5_ch1_reg,
                        so => chain(103));

pcs_ctrl5_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL5_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl5_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(101),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl5_ch2_reg,
                        so => chain(102));

pcs_ctrl5_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL5_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl5_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(100),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl5_ch3_reg,
                        so => chain(101));

pcs_ctrl6_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL6_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl6_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(99),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl6_ch0_reg,
                        so => chain(100));

pcs_ctrl6_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL6_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl6_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(98),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl6_ch1_reg,
                        so => chain(99));

pcs_ctrl6_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL6_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl6_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(97),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl6_ch2_reg,
                        so => chain(98));

pcs_ctrl6_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL6_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl6_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(96),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl6_ch3_reg,
                        so => chain(97));
                        
pcs_ctrl7_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL7_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl7_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(95),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl7_ch0_reg,
                        so => chain(96));

pcs_ctrl7_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL7_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl7_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(94),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl7_ch1_reg,
                        so => chain(95));

pcs_ctrl7_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL7_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl7_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(93),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl7_ch2_reg,
                        so => chain(94));

pcs_ctrl7_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL7_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl7_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(92),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl7_ch3_reg,
                        so => chain(93));

pcs_ctrl8_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL8_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl8_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(91),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl8_ch0_reg,
                        so => chain(92));

pcs_ctrl8_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL8_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl8_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(90),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl8_ch1_reg,
                        so => chain(91));

pcs_ctrl8_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL8_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl8_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(89),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl8_ch2_reg,
                        so => chain(90));

pcs_ctrl8_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL8_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl8_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(88),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl8_ch3_reg,
                        so => chain(89));

bist_prbs_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PRBS_BIST_CTRL_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => prbs_bist_ctrl_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(87),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => prbs_bist_ctrl_ch0_reg,
                        so => chain(88));

bist_prbs_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PRBS_BIST_CTRL_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => prbs_bist_ctrl_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(86),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => prbs_bist_ctrl_ch1_reg,
                        so => chain(87));

bist_prbs_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PRBS_BIST_CTRL_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => prbs_bist_ctrl_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(85),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => prbs_bist_ctrl_ch2_reg,
                        so => chain(86));

bist_prbs_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PRBS_BIST_CTRL_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => prbs_bist_ctrl_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(84),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => prbs_bist_ctrl_ch3_reg,
                        so => chain(85));


pcs_ctrl9_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL9_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl9_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(83),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl9_ch0_reg,
                        so => chain(84));

pcs_ctrl9_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL9_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl9_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(82),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl9_ch1_reg,
                        so => chain(83));

pcs_ctrl9_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL9_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl9_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(81),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl9_ch2_reg,
                        so => chain(82));

pcs_ctrl9_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL9_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl9_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(80),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl9_ch3_reg,
                        so => chain(81));                        

pcs_ctrl10_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL10_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl10_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(79),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl10_ch0_reg,
                        so => chain(80));

pcs_ctrl10_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL10_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl10_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(78),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl10_ch1_reg,
                        so => chain(79));

pcs_ctrl10_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL10_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl10_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(77),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl10_ch2_reg,
                        so => chain(78));

pcs_ctrl10_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL10_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl10_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(76),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl10_ch3_reg,
                        so => chain(77));

pcs_ctrl11_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL11_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl11_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(75),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl11_ch0_reg,
                        so => chain(76));

pcs_ctrl11_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL11_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl11_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(74),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl11_ch1_reg,
                        so => chain(75));

pcs_ctrl11_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL11_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl11_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(73),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl11_ch2_reg,
                        so => chain(74));

pcs_ctrl11_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL11_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl11_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(72),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl11_ch3_reg,
                        so => chain(73));

pcs_ctrl12_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL12_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl12_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(71),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl12_ch0_reg,
                        so => chain(72));

pcs_ctrl12_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL12_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl12_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(70),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl12_ch1_reg,
                        so => chain(71));

pcs_ctrl12_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL12_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl12_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(69),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl12_ch2_reg,
                        so => chain(70));

pcs_ctrl12_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL12_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl12_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(68),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl12_ch3_reg,
                        so => chain(69));

pcs_ctrl13_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL13_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl13_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(67),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl13_ch0_reg,
                        so => chain(68));

pcs_ctrl13_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL13_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl13_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(66),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl13_ch1_reg,
                        so => chain(67));

pcs_ctrl13_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL13_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl13_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(65),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl13_ch2_reg,
                        so => chain(66));

pcs_ctrl13_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL13_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl13_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(64),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl13_ch3_reg,
                        so => chain(65));
                        
pcs_ctrl14_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL14_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl14_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(63),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl14_ch0_reg,
                        so => chain(64));

pcs_ctrl14_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL14_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl14_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(62),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl14_ch1_reg,
                        so => chain(63));

pcs_ctrl14_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL14_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl14_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(61),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl14_ch2_reg,
                        so => chain(62));

pcs_ctrl14_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL14_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl14_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(60),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl14_ch3_reg,
                        so => chain(61));                        

pcs_ctrl15_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL15_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl15_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(59),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl15_ch0_reg,
                        so => chain(60));

pcs_ctrl15_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL15_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl15_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(58),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl15_ch1_reg,
                        so => chain(59));

pcs_ctrl15_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL15_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl15_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(57),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl15_ch2_reg,
                        so => chain(58));

pcs_ctrl15_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL15_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl15_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(56),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl15_ch3_reg,
                        so => chain(57));
                        
mpcs_global_ctrl0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                             mdio_wr => mdio_wr,
                             reg_addr => reg_addr,
                             target_addr => PCS_GLOBAL_CTRL0,
                             clk => mdc,
                             sig_in => mbus_in,
                             ext_in => pcs_global_ctrl0_ext,
                             jtag_mode => jtag_mode,
                             si => chain(55),
                             shift => jtag_shift_load,
                             mdio_dis => mdio_dis,
                             sig_out => pcs_global_ctrl0_reg,
                             so => chain(56));
                        
mpcs_global_ctrl1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                             mdio_wr => mdio_wr,
                             reg_addr => reg_addr,
                             target_addr => PCS_GLOBAL_CTRL1,
                             clk => mdc,
                             sig_in => mbus_in,
                             ext_in => pcs_global_ctrl1_ext,
                             jtag_mode => jtag_mode,
                             si => chain(54),
                             shift => jtag_shift_load,
                             mdio_dis => mdio_dis,
                             sig_out => pcs_global_ctrl1_reg,
                             so => chain(55));

mpcs_global_ctrl2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                             mdio_wr => mdio_wr,
                             reg_addr => reg_addr,
                             target_addr => PCS_GLOBAL_CTRL2,
                             clk => mdc,
                             sig_in => mbus_in,
                             ext_in => pcs_global_ctrl2_ext,
                             jtag_mode => jtag_mode,
                             si => chain(53),
                             shift => jtag_shift_load,
                             mdio_dis => mdio_dis,
                             sig_out => pcs_global_ctrl2_reg,
                             so => chain(54));

mpma_ctrl1_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL1_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl1_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(52),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl1_ch0_reg,
                        so => chain(53));

pma_ctrl1_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL1_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl1_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(51),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl1_ch1_reg,
                        so => chain(52));

pma_ctrl1_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL1_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl1_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(50),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl1_ch2_reg,
                        so => chain(51));

pma_ctrl1_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL1_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl1_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(49),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl1_ch3_reg,
                        so => chain(50));

pma_ctrl2_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL2_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl2_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(48),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl2_ch0_reg,
                        so => chain(49));

pma_ctrl2_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL2_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl2_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(47),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl2_ch1_reg,
                        so => chain(48));

pma_ctrl2_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL2_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl2_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(46),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl2_ch2_reg,
                        so => chain(47));

pma_ctrl2_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL2_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl2_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(45),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl2_ch3_reg,
                        so => chain(46));

pma_ctrl3_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL3_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl3_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(44),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl3_ch0_reg,
                        so => chain(45));

pma_ctrl3_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL3_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl3_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(43),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl3_ch1_reg,
                        so => chain(44));

pma_ctrl3_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL3_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl3_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(42),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl3_ch2_reg,
                        so => chain(43));

pma_ctrl3_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL3_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl3_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(41),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl3_ch3_reg,
                        so => chain(42));

pma_ctrl4_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL4_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl4_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(40),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl4_ch0_reg,
                        so => chain(41));

pma_ctrl4_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL4_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl4_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(39),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl4_ch1_reg,
                        so => chain(40));

pma_ctrl4_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL4_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl4_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(38),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl4_ch2_reg,
                        so => chain(39));

pma_ctrl4_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL4_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl4_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(37),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl4_ch3_reg,
                        so => chain(38));

pma_ctrl5_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL5_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl5_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(36),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl5_ch0_reg,
                        so => chain(37));

pma_ctrl5_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL5_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl5_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(35),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl5_ch1_reg,
                        so => chain(36));

pma_ctrl5_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL5_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl5_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(34),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl5_ch2_reg,
                        so => chain(35));

pma_ctrl5_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL5_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl5_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(33),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl5_ch3_reg,
                        so => chain(34));

pma_ctrl6_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL6_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl6_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(32),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl6_ch0_reg,
                        so => chain(33));

pma_ctrl6_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL6_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl6_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(31),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl6_ch1_reg,
                        so => chain(32));

pma_ctrl6_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL6_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl6_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(30),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl6_ch2_reg,
                        so => chain(31));

pma_ctrl6_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL6_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl6_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(29),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl6_ch3_reg,
                        so => chain(30));

pma_ctrl7_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL7_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl7_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(28),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl7_ch0_reg,
                        so => chain(29));

pma_ctrl7_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL7_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl7_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(27),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl7_ch1_reg,
                        so => chain(28));

pma_ctrl7_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL7_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl7_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(26),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl7_ch2_reg,
                        so => chain(27));

pma_ctrl7_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL7_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl7_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(25),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl7_ch3_reg,
                        so => chain(26));

pma_ctrl8_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL8_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl8_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(24),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl8_ch0_reg,
                        so => chain(25));

pma_ctrl8_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL8_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl8_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(23),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl8_ch1_reg,
                        so => chain(24));
                        
pma_ctrl8_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL8_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl8_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(22),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl8_ch2_reg,
                        so => chain(23));
                        
pma_ctrl8_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL8_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl8_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(21),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl8_ch3_reg,
                        so => chain(22));

pma_ctrl9_0   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL9_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl9_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(20),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl9_ch0_reg,
                        so => chain(21));

pma_ctrl9_1   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL9_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl9_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(19),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl9_ch1_reg,
                        so => chain(20));

pma_ctrl9_2   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL9_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl9_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(18),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl9_ch2_reg,
                        so => chain(19));

pma_ctrl9_3   : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL9_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl9_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(17),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl9_ch3_reg,
                        so => chain(18));

pma_ctrl10_0  : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL10_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl10_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(16),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl10_ch0_reg,
                        so => chain(17));

pma_ctrl10_1  : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL10_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl10_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(15),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl10_ch1_reg,
                        so => chain(16));

pma_ctrl10_2  : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL10_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl10_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(14),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl10_ch2_reg,
                        so => chain(15));

pma_ctrl10_3  : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL10_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl10_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(13),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl10_ch3_reg,
                        so => chain(14));

pma_ctrl11_0  : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL11_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl11_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(12),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl11_ch0_reg,
                        so => chain(13));

pma_ctrl11_1  : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL11_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl11_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(11),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl11_ch1_reg,
                        so => chain(12));

pma_ctrl11_2  : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL11_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl11_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(10),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl11_ch2_reg,
                        so => chain(11));
                        
pma_ctrl11_3  : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL11_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl11_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(9),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl11_ch3_reg,
                        so => chain(10));                        

mpma_global_ctrl0 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL0,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl0_ext,
                          jtag_mode => jtag_mode,
                          si => chain(8),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl0_reg,
                          so => chain(9));
                        
mpma_global_ctrl1 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL1,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl1_ext,
                          jtag_mode => jtag_mode,
                          si => chain(7),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl1_reg,
                          so => chain(8));

mpma_global_ctrl2 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL2,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl2_ext,
                          jtag_mode => jtag_mode,
                          si => chain(6),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl2_reg,
                          so => chain(7));
                        
mpma_global_ctrl3 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL3,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl3_ext,
                          jtag_mode => jtag_mode,
                          si => chain(5),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl3_reg,
                          so => chain(6));

mpma_global_ctrl4 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL4,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl4_ext,
                          jtag_mode => jtag_mode,
                          si => chain(4),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl4_reg,
                          so => chain(5));

mpma_global_ctrl5 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL5,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl5_ext,
                          jtag_mode => jtag_mode,
                          si => chain(3),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl5_reg,
                          so => chain(4));
                        
mpma_global_ctrl6 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL6,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl6_ext,
                          jtag_mode => jtag_mode,
                          si => chain(2),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl6_reg,
                          so => chain(3));
                        
mpma_global_ctrl7 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL7,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl7_ext,
                          jtag_mode => jtag_mode,
                          si => chain(1),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl7_reg,
                          so => chain(2));

mpma_global_ctrl8 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL8,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl8_ext,
                          jtag_mode => jtag_mode,
                          si => chain(0),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl8_reg,
                          so => chain(1));

mpma_global_ctrl9 : stratixiigx_hssi_ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL9,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl9_ext,
                          jtag_mode => jtag_mode,
                          si => jtag_si,
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl9_reg,
                          so => chain(0));

END dprio_reg_arch;


LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_mdio_addr;
USE WORK.stratixiigx_hssi_mdio_cnt;
USE WORK.stratixiigx_hssi_mdio_sm;
USE WORK.stratixiigx_hssi_mdio_ctl_data;
USE WORK.stratixiigx_hssi_cmu_dprio_reg;


ENTITY stratixiigx_hssi_cmu_dprio_top IS
  GENERIC (
       rx0_phy : INTEGER := 0;
       rx1_phy : INTEGER := 1;
       rx2_phy : INTEGER := 2;
       rx3_phy : INTEGER := 3;
       tx0_phy : INTEGER := 0;
       tx1_phy : INTEGER := 1;
       tx2_phy : INTEGER := 2;
       tx3_phy : INTEGER := 3;
       
       rx_dprio_width   :  INTEGER := 800;               -- 6.1
       tx_dprio_width   :  INTEGER := 400;               -- 6.1        
        
       rx0_cru_clock0_physical_mapping:  string := "refclk0";    
       rx0_cru_clock1_physical_mapping:  string := "refclk1";    
       rx0_cru_clock2_physical_mapping:  string := "iq0";    
       rx0_cru_clock3_physical_mapping:  string := "iq1";    
       rx0_cru_clock4_physical_mapping:  string := "iq2";    
       rx0_cru_clock5_physical_mapping:  string := "iq3";    
       rx0_cru_clock6_physical_mapping:  string := "iq4";    
       rx0_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx0_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
       rx1_cru_clock0_physical_mapping:  string := "refclk0";    
       rx1_cru_clock1_physical_mapping:  string := "refclk1";    
       rx1_cru_clock2_physical_mapping:  string := "iq0";    
       rx1_cru_clock3_physical_mapping:  string := "iq1";    
       rx1_cru_clock4_physical_mapping:  string := "iq2";    
       rx1_cru_clock5_physical_mapping:  string := "iq3";    
       rx1_cru_clock6_physical_mapping:  string := "iq4";    
       rx1_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx1_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
       rx2_cru_clock0_physical_mapping:  string := "refclk0";    
       rx2_cru_clock1_physical_mapping:  string := "refclk1";    
       rx2_cru_clock2_physical_mapping:  string := "iq0";    
       rx2_cru_clock3_physical_mapping:  string := "iq1";    
       rx2_cru_clock4_physical_mapping:  string := "iq2";    
       rx2_cru_clock5_physical_mapping:  string := "iq3";    
       rx2_cru_clock6_physical_mapping:  string := "iq4";    
       rx2_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx2_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
       rx3_cru_clock0_physical_mapping:  string := "refclk0";    
       rx3_cru_clock1_physical_mapping:  string := "refclk1";    
       rx3_cru_clock2_physical_mapping:  string := "iq0";    
       rx3_cru_clock3_physical_mapping:  string := "iq1";    
       rx3_cru_clock4_physical_mapping:  string := "iq2";    
       rx3_cru_clock5_physical_mapping:  string := "iq3";    
       rx3_cru_clock6_physical_mapping:  string := "iq4";    
       rx3_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx3_cru_clock8_physical_mapping:  string := "cmu_div_clk";  
          
       pll0_phy: integer := 0;    
       pll1_phy: integer := 1;    
       pll2_phy: integer := 2;   
       
       pll0_inclk0_logical_to_physical_mapping: string := "iq0";
       pll0_inclk1_logical_to_physical_mapping: string := "iq1";
       pll0_inclk2_logical_to_physical_mapping: string := "iq2";
       pll0_inclk3_logical_to_physical_mapping: string := "iq3";
       pll0_inclk4_logical_to_physical_mapping: string := "iq4";
       pll0_inclk5_logical_to_physical_mapping: string := "pld_clk";
       pll0_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
       pll0_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
       pll1_inclk0_logical_to_physical_mapping: string := "iq0";
       pll1_inclk1_logical_to_physical_mapping: string := "iq1";
       pll1_inclk2_logical_to_physical_mapping: string := "iq2";
       pll1_inclk3_logical_to_physical_mapping: string := "iq3";
       pll1_inclk4_logical_to_physical_mapping: string := "iq4";
       pll1_inclk5_logical_to_physical_mapping: string := "pld_clk";
       pll1_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
       pll1_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
       pll2_inclk0_logical_to_physical_mapping: string := "iq0";
       pll2_inclk1_logical_to_physical_mapping: string := "iq1";
       pll2_inclk2_logical_to_physical_mapping: string := "iq2";
       pll2_inclk3_logical_to_physical_mapping: string := "iq3";
       pll2_inclk4_logical_to_physical_mapping: string := "iq4";
       pll2_inclk5_logical_to_physical_mapping: string := "pld_clk";
       pll2_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
       pll2_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
        
       tx0_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx0_pll_fast_clk1_physical_mapping: string := "pll1";    
       tx1_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx1_pll_fast_clk1_physical_mapping: string := "pll1";    
       tx2_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx2_pll_fast_clk1_physical_mapping: string := "pll1";    
       tx3_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx3_pll_fast_clk1_physical_mapping: string := "pll1";
       sim_dump_dprio_internal_reg_at_time : integer   := 0;
       sim_dump_filename                   : string := "sim_dprio_dump.txt"
	   
             
  );
    PORT (
        sync_status             : IN std_logic_vector(3 DOWNTO 0);   
        align_status            : IN std_logic;   
        mdio_in                 : IN std_logic;   
        mdc                     : IN std_logic;   
        port_addr               : IN std_logic_vector(4 DOWNTO 0);   
        dev_addr                : IN std_logic_vector(4 DOWNTO 0);   
        mdio_dis                : IN std_logic;   
        dprioload               : IN std_logic;   
        mdio_rst                : IN std_logic;   
        cmudividerdprioin       : IN std_logic_vector(29 DOWNTO 0);   
        cmuplldprioin           : IN std_logic_vector(119 DOWNTO 0);   
        cmudprioin              : IN std_logic_vector(29 DOWNTO 0);   
        refclkdividerdprioin    : IN std_logic_vector(1 DOWNTO 0);   
        rxdprioin               : IN std_logic_vector(rx_dprio_width - 1 DOWNTO 0);   
        txdprioin               : IN std_logic_vector(tx_dprio_width - 1 DOWNTO 0);   

        cmudividerdprioout      : OUT std_logic_vector(29 DOWNTO 0);   
        cmuplldprioout          : OUT std_logic_vector(119 DOWNTO 0);   
        cmudprioout             : OUT std_logic_vector(29 DOWNTO 0);   
        refclkdividerdprioout   : OUT std_logic_vector(1 DOWNTO 0);   
        rxdprioout              : OUT std_logic_vector(rx_dprio_width - 1 DOWNTO 0);   
        txdprioout              : OUT std_logic_vector(tx_dprio_width - 1 DOWNTO 0);   
        mdio_out                : OUT std_logic;   
        data_enable_n           : OUT std_logic;   
        mdio_curr_st            : OUT std_logic_vector(2 DOWNTO 0));   
END stratixiigx_hssi_cmu_dprio_top;

ARCHITECTURE cmu_dprio_top_arc OF stratixiigx_hssi_cmu_dprio_top IS

-- COMPONENTS begin  ---------------------------------------------------
 COMPONENT  stratixiigx_hssi_mdio_addr
	 PORT 
	 ( 
		 incr_addr	:	IN  STD_LOGIC;
		 mdc	    :	IN  STD_LOGIC;
		 mdio_in	:	IN  STD_LOGIC;
		 reg_addr	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 reset	    :	IN  STD_LOGIC;
		 shift_addr	:	IN  STD_LOGIC
	 ); 
 END COMPONENT;

  COMPONENT  stratixiigx_hssi_mdio_cnt 
	 PORT 
	 ( 
		 cnt_eq_0	:	OUT  STD_LOGIC;
		 cnt_val	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 ld_cnt	    :	IN  STD_LOGIC;
		 mdc	    :	IN  STD_LOGIC;
		 reset	    :	IN  STD_LOGIC
	 ); 
 END COMPONENT;

 COMPONENT stratixiigx_hssi_mdio_sm
    PORT (
        mdc                     : IN std_logic;   --  Clock for MDIO interface
        mdio_in                 : IN std_logic;   --  Signal bit data
        reset                   : IN std_logic;   --  Active high Hard Reset
        opcode                  : IN std_logic_vector(1 DOWNTO 0);   --  2 bit opcode from mdio_ctl_data module

        valid_addr              : IN std_logic;   --  When set the Port and Dev Address
                                                  -- corresponds to this module

        cnt_eq_0                : IN std_logic;   --  From mdio_cnt module, down counter is 0
        shift_in                : OUT std_logic;   --  Shift in enable for either data or control
        shift_out               : OUT std_logic;   --  Shift out enable for mdio_ctl_data
        latch_ctl               : OUT std_logic;   --  Latch the Opcode, to mdio_ctl_data
        incr_addr               : OUT std_logic;   --  Increment signal for mdio_addr
        mdio_wr                 : OUT std_logic;   --  This is used for writing the mdio registers
        mdio_rd                 : OUT std_logic;   --  This is used for clearing the mdio status registers
        shift_addr              : OUT std_logic;   --  Shift in Enable for mdio_addr
        ld_data                 : OUT std_logic;   --  When set, the shift register is mdio_ctl_data is parallely
                                                   -- loaded with the data from mdio_reg module

        ld_cnt                  : OUT std_logic;   --  Load Down counter
        cnt_val                 : OUT std_logic_vector(4 DOWNTO 0);   --  Value to load the down counter
        valid_addr_lt           : OUT std_logic;   
        curr_state              : OUT std_logic_vector(2 DOWNTO 0));   
 END COMPONENT;

 COMPONENT  stratixiigx_hssi_mdio_ctl_data 
	 PORT 
	 ( 
		 data_enable_n	:	OUT  STD_LOGIC;
		 dev_addr	    :	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 latch_ctl	    :	IN  STD_LOGIC;
		 ld_data	    :	IN  STD_LOGIC;
		 mbus_in	    :	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 mbus_out	    :	IN  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 mdc	        :	IN  STD_LOGIC;
		 mdio_in	    :	IN  STD_LOGIC;
		 mdio_out	    :	OUT  STD_LOGIC;
		 opcode	        :	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 port_addr	    :	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 reset	        :	IN  STD_LOGIC;
		 shift_in	    :	IN  STD_LOGIC;
		 shift_out	    :	IN  STD_LOGIC;
		 valid_addr	    :	OUT  STD_LOGIC;
		 valid_addr_lt	:	IN  STD_LOGIC
	 ); 
 END COMPONENT;

 COMPONENT stratixiigx_hssi_cmu_dprio_reg
  GENERIC (
    rx0_phy : INTEGER := 0;
    rx1_phy : INTEGER := 1;
    rx2_phy : INTEGER := 2;
    rx3_phy : INTEGER := 3;
    tx0_phy : INTEGER := 0;
    tx1_phy : INTEGER := 1;
    tx2_phy : INTEGER := 2;
    tx3_phy : INTEGER := 3;
    
       rx_dprio_width   :  INTEGER := 800;               -- 6.1
       tx_dprio_width   :  INTEGER := 400;               -- 6.1        
        
       rx0_cru_clock0_physical_mapping:  string := "refclk0";    
       rx0_cru_clock1_physical_mapping:  string := "refclk1";    
       rx0_cru_clock2_physical_mapping:  string := "iq0";    
       rx0_cru_clock3_physical_mapping:  string := "iq1";    
       rx0_cru_clock4_physical_mapping:  string := "iq2";    
       rx0_cru_clock5_physical_mapping:  string := "iq3";    
       rx0_cru_clock6_physical_mapping:  string := "iq4";    
       rx0_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx0_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
       rx1_cru_clock0_physical_mapping:  string := "refclk0";    
       rx1_cru_clock1_physical_mapping:  string := "refclk1";    
       rx1_cru_clock2_physical_mapping:  string := "iq0";    
       rx1_cru_clock3_physical_mapping:  string := "iq1";    
       rx1_cru_clock4_physical_mapping:  string := "iq2";    
       rx1_cru_clock5_physical_mapping:  string := "iq3";    
       rx1_cru_clock6_physical_mapping:  string := "iq4";    
       rx1_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx1_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
       rx2_cru_clock0_physical_mapping:  string := "refclk0";    
       rx2_cru_clock1_physical_mapping:  string := "refclk1";    
       rx2_cru_clock2_physical_mapping:  string := "iq0";    
       rx2_cru_clock3_physical_mapping:  string := "iq1";    
       rx2_cru_clock4_physical_mapping:  string := "iq2";    
       rx2_cru_clock5_physical_mapping:  string := "iq3";    
       rx2_cru_clock6_physical_mapping:  string := "iq4";    
       rx2_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx2_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
       rx3_cru_clock0_physical_mapping:  string := "refclk0";    
       rx3_cru_clock1_physical_mapping:  string := "refclk1";    
       rx3_cru_clock2_physical_mapping:  string := "iq0";    
       rx3_cru_clock3_physical_mapping:  string := "iq1";    
       rx3_cru_clock4_physical_mapping:  string := "iq2";    
       rx3_cru_clock5_physical_mapping:  string := "iq3";    
       rx3_cru_clock6_physical_mapping:  string := "iq4";    
       rx3_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx3_cru_clock8_physical_mapping:  string := "cmu_div_clk";  
          
       pll0_phy: integer := 0;    
       pll1_phy: integer := 1;    
       pll2_phy: integer := 2;   
       
       pll0_inclk0_logical_to_physical_mapping: string := "iq0";
       pll0_inclk1_logical_to_physical_mapping: string := "iq1";
       pll0_inclk2_logical_to_physical_mapping: string := "iq2";
       pll0_inclk3_logical_to_physical_mapping: string := "iq3";
       pll0_inclk4_logical_to_physical_mapping: string := "iq4";
       pll0_inclk5_logical_to_physical_mapping: string := "pld_clk";
       pll0_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
       pll0_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
       pll1_inclk0_logical_to_physical_mapping: string := "iq0";
       pll1_inclk1_logical_to_physical_mapping: string := "iq1";
       pll1_inclk2_logical_to_physical_mapping: string := "iq2";
       pll1_inclk3_logical_to_physical_mapping: string := "iq3";
       pll1_inclk4_logical_to_physical_mapping: string := "iq4";
       pll1_inclk5_logical_to_physical_mapping: string := "pld_clk";
       pll1_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
       pll1_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
       pll2_inclk0_logical_to_physical_mapping: string := "iq0";
       pll2_inclk1_logical_to_physical_mapping: string := "iq1";
       pll2_inclk2_logical_to_physical_mapping: string := "iq2";
       pll2_inclk3_logical_to_physical_mapping: string := "iq3";
       pll2_inclk4_logical_to_physical_mapping: string := "iq4";
       pll2_inclk5_logical_to_physical_mapping: string := "pld_clk";
       pll2_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
       pll2_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
       
       tx0_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx0_pll_fast_clk1_physical_mapping: string := "pll1";    
       tx1_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx1_pll_fast_clk1_physical_mapping: string := "pll1";    
       tx2_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx2_pll_fast_clk1_physical_mapping: string := "pll1";    
       tx3_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx3_pll_fast_clk1_physical_mapping: string := "pll1";
       sim_dump_dprio_internal_reg_at_time : integer   := 0;
       sim_dump_filename                   : string := "sim_dprio_dump.txt"

                 
  );
  PORT (
    mdc          : IN std_logic := '0';       
    mdio_rst     : IN std_logic := '0';
    mdio_dis     : IN std_logic := '1';
    dprioload    : IN std_logic := '0';
    align_status : IN std_logic := '0';
    sync_status  : IN std_logic_vector (3 DOWNTO 0) := (OTHERS => '0');
    reg_addr     : IN std_logic_vector (15 DOWNTO 0) := (OTHERS => '0');
    mdio_wr      : IN std_logic := '0';      
    mdio_rd      : IN std_logic := '0';
    dev_addr_0   : IN std_logic := '0';
    mbus_in      : IN std_logic_vector (15 DOWNTO 0) := (OTHERS => '0');
                        
    cmudividerdprioin : IN std_logic_vector (29 DOWNTO 0)   := (OTHERS => '0');
    cmuplldprioin     : IN std_logic_vector (119 DOWNTO 0)  := (OTHERS => '0');
    cmudprioin        : IN std_logic_vector (29 DOWNTO 0)   := (OTHERS => '0');
    refclkdividerdprioin : IN std_logic_vector (1 DOWNTO 0) := (OTHERS => '0');
    rxdprioin         : IN std_logic_vector(rx_dprio_width - 1 DOWNTO 0) := (OTHERS => '0');   
    txdprioin         : IN std_logic_vector(tx_dprio_width - 1 DOWNTO 0) := (OTHERS => '0');   
           
    cmudividerdprioout : OUT std_logic_vector (29 DOWNTO 0);
    cmuplldprioout     : OUT std_logic_vector (119 DOWNTO 0);
    cmudprioout        : OUT std_logic_vector (29 DOWNTO 0);
    refclkdividerdprioout : OUT std_logic_vector (1 DOWNTO 0);
    rxdprioout         : OUT std_logic_vector(rx_dprio_width - 1 DOWNTO 0);   
    txdprioout         : OUT std_logic_vector(tx_dprio_width - 1 DOWNTO 0);   
            		            
    mbus_out           : OUT std_logic_vector (15 DOWNTO 0));
 END COMPONENT;

-- COMPONENTS end  ---------------------------------------------------

-- unused ports to be moved into reg
SIGNAL          jtag_mode       : STD_LOGIC;
SIGNAL          jtag_shift_load : STD_LOGIC;
SIGNAL          jtag_si         : STD_LOGIC;
SIGNAL          jtag_so         : STD_LOGIC;   -- wire

-- status signals generated by PCS
SIGNAL          tx_local_fault : STD_LOGIC;        -- from tx_sm
SIGNAL          rx_local_fault : STD_LOGIC;        -- from rcv_sm
SIGNAL          xs_link_status : STD_LOGIC;        -- from rcv_sm

SIGNAL         local_fault_ext    : STD_LOGIC;       -- Status signal wire
SIGNAL         xs_link_status_ext : STD_LOGIC;    -- Status signal wire
SIGNAL         rx_local_fault_ext : STD_LOGIC;    -- Status signal wire
SIGNAL         tx_local_fault_ext : STD_LOGIC;    -- Status signal wire

-- interconnect wires --------------------------------------------------

-- wires from addr
SIGNAL        reg_addr : STD_LOGIC_VECTOR(15 DOWNTO 0);    -- addr --> reg

-- wires from sm
SIGNAL         shift_addr : STD_LOGIC;          -- sm --> addr
SIGNAL         incr_addr : STD_LOGIC;           -- sm --> addr

SIGNAL         ld_cnt  : STD_LOGIC;              -- sm --> cnt
SIGNAL         cnt_val : STD_LOGIC_VECTOR(4 DOWNTO 0);  -- sm --> cnt
SIGNAL         ld_data : STD_LOGIC;             -- sm --> cnt

SIGNAL         shift_in      : STD_LOGIC;             -- sm --> ctl_data
SIGNAL         shift_out     : STD_LOGIC;            -- sm --> ctl_data
SIGNAL         latch_ctl     : STD_LOGIC;            -- sm --> ctl_data
SIGNAL         valid_addr_lt : STD_LOGIC;        -- sm --> ctl_data

SIGNAL         mdio_wr : STD_LOGIC;              -- sm --> reg         
SIGNAL         mdio_rd : STD_LOGIC;              -- sm --> reg         

SIGNAL         curr_state : STD_LOGIC_VECTOR(2 DOWNTO 0); -- sm --> top (../../pcs_central_testbus in central_chnnl)

-- wires from cnt
SIGNAL         cnt_eq_0 : STD_LOGIC;            -- cnt --> sm

-- wires from ctl_data
SIGNAL         mbus_in    : STD_LOGIC_VECTOR(15 DOWNTO 0);   -- ctl_data --> reg
SIGNAL         valid_addr : STD_LOGIC;          -- ctl_data --> sm
SIGNAL         opcode     : STD_LOGIC_VECTOR(1 DOWNTO 0);     -- ctl_data --> sm

--SIGNAL         mdio_out      : STD_LOGIC;       -- ctl_data --> top
--SIGNAL         data_enable_n : STD_LOGIC;       -- ctl_data --> top

-- wires from reg
SIGNAL         mbus_out : STD_LOGIC_VECTOR(15 DOWNTO 0);  -- reg --> ctl_data

--wires to reg
SIGNAL dev_addr_0 : STD_LOGIC;

BEGIN

-- outputs
mdio_curr_st <= curr_state;  -- from SM

-- module instantiatations ------------------------------------------------

mdio_addr_1 : stratixiigx_hssi_mdio_addr
              PORT MAP (  
                        reset  => mdio_rst,               -- from top
                        mdc  => mdc,                      -- from top
                        mdio_in  => mdio_in,              -- from top
                        shift_addr  => shift_addr,        -- from sm
                        incr_addr  => incr_addr,          -- from sm
                        reg_addr  => reg_addr             -- To  => 16-bit reg addr) reg 
              );
                      
mdio_cnt_1 : stratixiigx_hssi_mdio_cnt
              PORT MAP (  
                      reset  => mdio_rst,
                      mdc  => mdc,
                      ld_cnt  => ld_cnt,                  -- from sm
                      cnt_val  => cnt_val,                -- from sm
                      cnt_eq_0  => cnt_eq_0               -- to sm
              );


mdio_sm_1 : stratixiigx_hssi_mdio_sm
              PORT MAP (  
                    reset  => mdio_rst,
                    mdio_in  => mdio_in,                 -- from top                 
                    mdc  => mdc,
                    opcode  => opcode,                   -- from ctl_data
                    valid_addr  => valid_addr,           -- from ctl_data
                    cnt_eq_0  => cnt_eq_0,               -- from cnt
                    shift_addr  => shift_addr,           -- to addr
                    incr_addr  => incr_addr,             -- to addr
                    mdio_wr  => mdio_wr,                 -- to reg
                    mdio_rd  => mdio_rd,                 -- to reg
                    shift_in  => shift_in,               -- to ctl_data
                    shift_out  => shift_out,             -- to ctl_data
                    latch_ctl  => latch_ctl,             -- to ctl_data
                    ld_data  => ld_data,                 -- to ctl_data
                    valid_addr_lt => valid_addr_lt,      -- to cnt_data
                    ld_cnt  => ld_cnt,                   -- to cnt
                    cnt_val  => cnt_val,                 -- to cnt  => 5-bit)
                    curr_state  => curr_state            -- to top
                  );

mdio_ctl_data_1 : stratixiigx_hssi_mdio_ctl_data 
              PORT MAP (  
                    reset  => mdio_rst,
                    mdc  => mdc,
                    mdio_in  => mdio_in,
                    shift_in  => shift_in,        -- from sm
                    shift_out  => shift_out,      -- frm sm
                    ld_data  => ld_data,          -- from sm
                    latch_ctl  => latch_ctl,      -- from sm
                    port_addr  => port_addr,
                    dev_addr  => dev_addr,
                    valid_addr_lt => valid_addr_lt, -- from sm
                    mbus_out  => mbus_out,          -- from reg
                    mdio_out  => mdio_out,          -- to top
                    mbus_in  => mbus_in,            -- to reg 
                    opcode  => opcode,              -- to sm
                    valid_addr  => valid_addr,      -- to sm
                    data_enable_n  => data_enable_n -- to top
               );
                              
dev_addr_0 <= dev_addr(0);
                              
mdio_reg_1 : stratixiigx_hssi_cmu_dprio_reg 
              GENERIC MAP ( 
                    rx0_phy => rx0_phy,
                    rx1_phy => rx1_phy,
                    rx2_phy => rx2_phy,
                    rx3_phy => rx3_phy,

                    tx0_phy => tx0_phy,
                    tx1_phy => tx1_phy,
                    tx2_phy => tx2_phy,
                    tx3_phy => tx3_phy,

                    rx_dprio_width => rx_dprio_width,
                    tx_dprio_width => tx_dprio_width,
		            
                    rx0_cru_clock0_physical_mapping => rx0_cru_clock0_physical_mapping, 
                    rx0_cru_clock1_physical_mapping => rx0_cru_clock1_physical_mapping, 
                    rx0_cru_clock2_physical_mapping => rx0_cru_clock2_physical_mapping, 
                    rx0_cru_clock3_physical_mapping => rx0_cru_clock3_physical_mapping, 
                    rx0_cru_clock4_physical_mapping => rx0_cru_clock4_physical_mapping, 
                    rx0_cru_clock5_physical_mapping => rx0_cru_clock5_physical_mapping, 
                    rx0_cru_clock6_physical_mapping => rx0_cru_clock6_physical_mapping, 
                    rx0_cru_clock7_physical_mapping => rx0_cru_clock7_physical_mapping, 
                    rx0_cru_clock8_physical_mapping => rx0_cru_clock8_physical_mapping, 
                    rx1_cru_clock0_physical_mapping => rx1_cru_clock0_physical_mapping, 
                    rx1_cru_clock1_physical_mapping => rx1_cru_clock1_physical_mapping, 
                    rx1_cru_clock2_physical_mapping => rx1_cru_clock2_physical_mapping, 
                    rx1_cru_clock3_physical_mapping => rx1_cru_clock3_physical_mapping, 
                    rx1_cru_clock4_physical_mapping => rx1_cru_clock4_physical_mapping, 
                    rx1_cru_clock5_physical_mapping => rx1_cru_clock5_physical_mapping, 
                    rx1_cru_clock6_physical_mapping => rx1_cru_clock6_physical_mapping, 
                    rx1_cru_clock7_physical_mapping => rx1_cru_clock7_physical_mapping, 
                    rx1_cru_clock8_physical_mapping => rx1_cru_clock8_physical_mapping, 
                    rx2_cru_clock0_physical_mapping => rx2_cru_clock0_physical_mapping, 
                    rx2_cru_clock1_physical_mapping => rx2_cru_clock1_physical_mapping, 
                    rx2_cru_clock2_physical_mapping => rx2_cru_clock2_physical_mapping, 
                    rx2_cru_clock3_physical_mapping => rx2_cru_clock3_physical_mapping, 
                    rx2_cru_clock4_physical_mapping => rx2_cru_clock4_physical_mapping, 
                    rx2_cru_clock5_physical_mapping => rx2_cru_clock5_physical_mapping, 
                    rx2_cru_clock6_physical_mapping => rx2_cru_clock6_physical_mapping, 
                    rx2_cru_clock7_physical_mapping => rx2_cru_clock7_physical_mapping, 
                    rx2_cru_clock8_physical_mapping => rx2_cru_clock8_physical_mapping, 
                    rx3_cru_clock0_physical_mapping => rx3_cru_clock0_physical_mapping, 
                    rx3_cru_clock1_physical_mapping => rx3_cru_clock1_physical_mapping, 
                    rx3_cru_clock2_physical_mapping => rx3_cru_clock2_physical_mapping, 
                    rx3_cru_clock3_physical_mapping => rx3_cru_clock3_physical_mapping, 
                    rx3_cru_clock4_physical_mapping => rx3_cru_clock4_physical_mapping, 
                    rx3_cru_clock5_physical_mapping => rx3_cru_clock5_physical_mapping, 
                    rx3_cru_clock6_physical_mapping => rx3_cru_clock6_physical_mapping, 
                    rx3_cru_clock7_physical_mapping => rx3_cru_clock7_physical_mapping, 
                    rx3_cru_clock8_physical_mapping => rx3_cru_clock8_physical_mapping, 

                    -- CMU_PLL reconfiguration
                    pll0_phy => pll0_phy,
                    pll1_phy => pll1_phy,
                    pll2_phy => pll2_phy, 

                    pll0_inclk0_logical_to_physical_mapping => pll0_inclk0_logical_to_physical_mapping,
                    pll0_inclk1_logical_to_physical_mapping => pll0_inclk1_logical_to_physical_mapping,
                    pll0_inclk2_logical_to_physical_mapping => pll0_inclk2_logical_to_physical_mapping,
                    pll0_inclk3_logical_to_physical_mapping => pll0_inclk3_logical_to_physical_mapping,
                    pll0_inclk4_logical_to_physical_mapping => pll0_inclk4_logical_to_physical_mapping,
                    pll0_inclk5_logical_to_physical_mapping => pll0_inclk5_logical_to_physical_mapping,
                    pll0_inclk6_logical_to_physical_mapping => pll0_inclk6_logical_to_physical_mapping,
                    pll0_inclk7_logical_to_physical_mapping => pll0_inclk7_logical_to_physical_mapping,
                    pll1_inclk0_logical_to_physical_mapping => pll1_inclk0_logical_to_physical_mapping,
                    pll1_inclk1_logical_to_physical_mapping => pll1_inclk1_logical_to_physical_mapping,
                    pll1_inclk2_logical_to_physical_mapping => pll1_inclk2_logical_to_physical_mapping,
                    pll1_inclk3_logical_to_physical_mapping => pll1_inclk3_logical_to_physical_mapping,
                    pll1_inclk4_logical_to_physical_mapping => pll1_inclk4_logical_to_physical_mapping,
                    pll1_inclk5_logical_to_physical_mapping => pll1_inclk5_logical_to_physical_mapping,
                    pll1_inclk6_logical_to_physical_mapping => pll1_inclk6_logical_to_physical_mapping,
                    pll1_inclk7_logical_to_physical_mapping => pll1_inclk7_logical_to_physical_mapping,
                    pll2_inclk0_logical_to_physical_mapping => pll2_inclk0_logical_to_physical_mapping,
                    pll2_inclk1_logical_to_physical_mapping => pll2_inclk1_logical_to_physical_mapping,
                    pll2_inclk2_logical_to_physical_mapping => pll2_inclk2_logical_to_physical_mapping,
                    pll2_inclk3_logical_to_physical_mapping => pll2_inclk3_logical_to_physical_mapping,
                    pll2_inclk4_logical_to_physical_mapping => pll2_inclk4_logical_to_physical_mapping,
                    pll2_inclk5_logical_to_physical_mapping => pll2_inclk5_logical_to_physical_mapping,
                    pll2_inclk6_logical_to_physical_mapping => pll2_inclk6_logical_to_physical_mapping,
                    pll2_inclk7_logical_to_physical_mapping => pll2_inclk7_logical_to_physical_mapping,

                    tx0_pll_fast_clk0_physical_mapping => tx0_pll_fast_clk0_physical_mapping, 
                    tx0_pll_fast_clk1_physical_mapping => tx0_pll_fast_clk1_physical_mapping, 
                    tx1_pll_fast_clk0_physical_mapping => tx1_pll_fast_clk0_physical_mapping, 
                    tx1_pll_fast_clk1_physical_mapping => tx1_pll_fast_clk1_physical_mapping, 
                    tx2_pll_fast_clk0_physical_mapping => tx2_pll_fast_clk0_physical_mapping, 
                    tx2_pll_fast_clk1_physical_mapping => tx2_pll_fast_clk1_physical_mapping, 
                    tx3_pll_fast_clk0_physical_mapping => tx3_pll_fast_clk0_physical_mapping, 
                    tx3_pll_fast_clk1_physical_mapping => tx3_pll_fast_clk1_physical_mapping,                
                    sim_dump_dprio_internal_reg_at_time => sim_dump_dprio_internal_reg_at_time,
                    sim_dump_filename => sim_dump_filename
              )  
              PORT MAP( 
                    mdc => mdc,       -- from top        
                    mdio_rst => mdio_rst,                  -- from top
                    mdio_dis  => mdio_dis,                 -- from top
                    dprioload => dprioload,                -- from top     
                    align_status  => align_status,         -- from top   
                    sync_status  => sync_status,           -- from top
                    reg_addr => reg_addr,                  -- from addr
                    mdio_wr => mdio_wr,                    -- from sm        
                    mdio_rd => mdio_rd,                    -- from sm
                    dev_addr_0  => dev_addr_0,             -- from top
                    mbus_in => mbus_in,                    -- from ctrl_data
                        
                    cmudividerdprioin => cmudividerdprioin,  -- CRAM in from para
                    cmuplldprioin => cmuplldprioin,
                    cmudprioin => cmudprioin,
                    refclkdividerdprioin => refclkdividerdprioin,
                    rxdprioin => rxdprioin,
                    txdprioin => txdprioin,
                    cmudividerdprioout => cmudividerdprioout,-- CRAM out to channels
                    cmuplldprioout => cmuplldprioout,
                    cmudprioout => cmudprioout,
                    refclkdividerdprioout => refclkdividerdprioout,
                    rxdprioout => rxdprioout,
                    txdprioout => txdprioout,
 			            
 			        mbus_out => mbus_out                  -- to ctrl_data
 			  ); 
           
END cmu_dprio_top_arc;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

USE WORK.stratixiigx_hssi_dskw_sm;
USE WORK.stratixiigx_hssi_tx_sm;
USE WORK.stratixiigx_hssi_rcv_sm;
USE WORK.stratixiigx_hssi_cmu_dprio_top;
USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;

ENTITY stratixiigx_hssi_central_management_unit IS
    GENERIC (
        in_xaui_mode          :  string := "false";    
        portaddr              :  integer := 1;        -- 1-based
        devaddr               :  integer := 1;        -- 1-based
        bonded_quad_mode      :  string := "none";    
        use_deskew_fifo       :  string := "false";    
        num_con_errors_for_align_loss  :  integer := 2;    
        num_con_good_data_for_align_approach: integer := 3;    
        num_con_align_chars_for_align  :  integer := 4;    
        offset_all_errors_align        :  string := "false";    
        dprio_config_mode              :  INTEGER := 0;                 -- 6.1
        rx_dprio_width                 :  INTEGER := 800;               -- 6.1
        tx_dprio_width                 :  INTEGER := 400;               -- 6.1        
        lpm_type                       :  string := "stratixiigx_hssi_central_management_unit";
        
        rx0_cru_clock0_physical_mapping:  string := "refclk0";    
        rx0_cru_clock1_physical_mapping:  string := "refclk1";    
        rx0_cru_clock2_physical_mapping:  string := "iq0";    
        rx0_cru_clock3_physical_mapping:  string := "iq1";    
        rx0_cru_clock4_physical_mapping:  string := "iq2";    
        rx0_cru_clock5_physical_mapping:  string := "iq3";    
        rx0_cru_clock6_physical_mapping:  string := "iq4";    
        rx0_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
        rx0_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
        rx1_cru_clock0_physical_mapping:  string := "refclk0";    
        rx1_cru_clock1_physical_mapping:  string := "refclk1";    
        rx1_cru_clock2_physical_mapping:  string := "iq0";    
        rx1_cru_clock3_physical_mapping:  string := "iq1";    
        rx1_cru_clock4_physical_mapping:  string := "iq2";    
        rx1_cru_clock5_physical_mapping:  string := "iq3";    
        rx1_cru_clock6_physical_mapping:  string := "iq4";    
        rx1_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
        rx1_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
        rx2_cru_clock0_physical_mapping:  string := "refclk0";    
        rx2_cru_clock1_physical_mapping:  string := "refclk1";    
        rx2_cru_clock2_physical_mapping:  string := "iq0";    
        rx2_cru_clock3_physical_mapping:  string := "iq1";    
        rx2_cru_clock4_physical_mapping:  string := "iq2";    
        rx2_cru_clock5_physical_mapping:  string := "iq3";    
        rx2_cru_clock6_physical_mapping:  string := "iq4";    
        rx2_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
        rx2_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
        rx3_cru_clock0_physical_mapping:  string := "refclk0";    
        rx3_cru_clock1_physical_mapping:  string := "refclk1";    
        rx3_cru_clock2_physical_mapping:  string := "iq0";    
        rx3_cru_clock3_physical_mapping:  string := "iq1";    
        rx3_cru_clock4_physical_mapping:  string := "iq2";    
        rx3_cru_clock5_physical_mapping:  string := "iq3";    
        rx3_cru_clock6_physical_mapping:  string := "iq4";    
        rx3_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
        rx3_cru_clock8_physical_mapping:  string := "cmu_div_clk";  
          
        tx0_pll_fast_clk0_physical_mapping: string := "pll0";    
        tx0_pll_fast_clk1_physical_mapping: string := "pll1";    
        tx1_pll_fast_clk0_physical_mapping: string := "pll0";    
        tx1_pll_fast_clk1_physical_mapping: string := "pll1";    
        tx2_pll_fast_clk0_physical_mapping: string := "pll0";    
        tx2_pll_fast_clk1_physical_mapping: string := "pll1";    
        tx3_pll_fast_clk0_physical_mapping: string := "pll0";    
        tx3_pll_fast_clk1_physical_mapping: string := "pll1";   
         
        pll0_inclk0_logical_to_physical_mapping: string := "iq0";
        pll0_inclk1_logical_to_physical_mapping: string := "iq1";
        pll0_inclk2_logical_to_physical_mapping: string := "iq2";
        pll0_inclk3_logical_to_physical_mapping: string := "iq3";
        pll0_inclk4_logical_to_physical_mapping: string := "iq4";
        pll0_inclk5_logical_to_physical_mapping: string := "pld_clk";
        pll0_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
        pll0_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
        pll1_inclk0_logical_to_physical_mapping: string := "iq0";
        pll1_inclk1_logical_to_physical_mapping: string := "iq1";
        pll1_inclk2_logical_to_physical_mapping: string := "iq2";
        pll1_inclk3_logical_to_physical_mapping: string := "iq3";
        pll1_inclk4_logical_to_physical_mapping: string := "iq4";
        pll1_inclk5_logical_to_physical_mapping: string := "pld_clk";
        pll1_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
        pll1_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
        pll2_inclk0_logical_to_physical_mapping: string := "iq0";
        pll2_inclk1_logical_to_physical_mapping: string := "iq1";
        pll2_inclk2_logical_to_physical_mapping: string := "iq2";
        pll2_inclk3_logical_to_physical_mapping: string := "iq3";
        pll2_inclk4_logical_to_physical_mapping: string := "iq4";
        pll2_inclk5_logical_to_physical_mapping: string := "pld_clk";
        pll2_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
        pll2_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
          
        cmu_divider_inclk0_physical_mapping: string := "pll0";    
        cmu_divider_inclk1_physical_mapping: string := "pll1";    
        cmu_divider_inclk2_physical_mapping: string := "pll2";  
          
        rx0_logical_to_physical_mapping:  integer := 0;    
        rx1_logical_to_physical_mapping:  integer := 1;    
        rx2_logical_to_physical_mapping:  integer := 2;    
        rx3_logical_to_physical_mapping:  integer := 3;    
        tx0_logical_to_physical_mapping:  integer := 0;    
        tx1_logical_to_physical_mapping:  integer := 1;    
        tx2_logical_to_physical_mapping:  integer := 2;    
        tx3_logical_to_physical_mapping:  integer := 3;    
        
        pll0_logical_to_physical_mapping: integer := 0;    
        pll1_logical_to_physical_mapping: integer := 1;    
        pll2_logical_to_physical_mapping: integer := 2;   
         
        refclk_divider0_logical_to_physical_mapping: integer := 0;    
        refclk_divider1_logical_to_physical_mapping: integer := 1;    
        
        -- DEBUG dump
        sim_dump_dprio_internal_reg_at_time: integer := 0;
        sim_dump_filename: string := "sim_dprio_dump.txt";
        
        analog_test_bus_enable:  string := "false";    
        bypass_bandgap:  string := "true";    
        central_test_bus_select:  integer := 5;
        TimingChecksOn: Boolean := True;
        MsgOn: Boolean := DefGlitchMsgOn;
        XOn: Boolean := DefGlitchXOn;
        MsgOnChecks: Boolean := DefMsgOnChecks;
        XOnChecks: Boolean := DefXOnChecks;
        InstancePath: String  := "*";
		-- input port delay section
        tipd_dpclk: VitalDelayType01 := DefpropDelay01;
        tipd_dpriodisable: VitalDelayType01 := DefpropDelay01;
        tipd_dprioin: VitalDelayType01 := DefpropDelay01;
        tipd_dprioload: VitalDelayType01 := DefpropDelay01;
        tipd_fixedclk: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
        tipd_quadenable: VitalDelayType01 := DefpropDelay01;
        tipd_quadreset: VitalDelayType01 := DefpropDelay01;
        tipd_rxanalogreset: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
        tipd_rxclk: VitalDelayType01 := DefpropDelay01;
        tipd_rxdigitalreset: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
        tipd_rxpowerdown: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
        tipd_txclk: VitalDelayType01 := DefpropDelay01;
        tipd_txdigitalreset: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
        -- TSU/TH section
		tsetup_dprioin_dpclk_noedge_posedge: VitalDelayType := DefSetupHoldCnst;
        thold_dprioin_dpclk_noedge_posedge: VitalDelayType := DefSetupHoldCnst;
		-- TCO section
        tpd_dpclk_dprioout_posedge: VitalDelayType01 := DefPropDelay01;
        tpd_dpclk_dpriooe_posedge: VitalDelayType01 := DefPropDelay01
    );
    PORT (
        adet                    : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        cmudividerdprioin       : IN std_logic_vector(29 DOWNTO 0)  := (OTHERS => '0');   
        cmuplldprioin           : IN std_logic_vector(119 DOWNTO 0)  := (OTHERS => '0');   
        dpclk                   : IN std_logic := '0';   
        dpriodisable            : IN std_logic := '1';   
        dprioin                 : IN std_logic := '0';   
        dprioload               : IN std_logic := '0';   
        fixedclk                : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        quadenable              : IN std_logic := '1';   
        quadreset               : IN std_logic := '0';   
        rdalign                 : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rdenablesync            : IN std_logic := '1';   
        recovclk                : IN std_logic := '0';   
        refclkdividerdprioin    : IN std_logic_vector(1 DOWNTO 0)  := (OTHERS => '0');   
        rxanalogreset           : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rxclk                   : IN std_logic := '0';   
        rxctrl                  : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rxdatain                : IN std_logic_vector(31 DOWNTO 0)  := (OTHERS => '0');   
        rxdatavalid             : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rxdigitalreset          : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rxdprioin               : IN std_logic_vector(rx_dprio_width - 1 DOWNTO 0)  := (OTHERS => '0');   
        rxpowerdown             : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rxrunningdisp           : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        syncstatus              : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        txclk                   : IN std_logic := '0';   
        txctrl                  : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        txdatain                : IN std_logic_vector(31 DOWNTO 0)  := (OTHERS => '0');   
        txdigitalreset          : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        txdprioin               : IN std_logic_vector(tx_dprio_width - 1 DOWNTO 0)  := (OTHERS => '0');   
        alignstatus             : OUT std_logic;   
        clkdivpowerdn           : OUT std_logic;   
        cmudividerdprioout      : OUT std_logic_vector(29 DOWNTO 0);   
        cmuplldprioout          : OUT std_logic_vector(119 DOWNTO 0);   
        dpriodisableout         : OUT std_logic;   
        dpriooe                 : OUT std_logic;   
        dprioout                : OUT std_logic;   
        enabledeskew            : OUT std_logic;   
        fiforesetrd             : OUT std_logic;   
        pllresetout             : OUT std_logic_vector(2 DOWNTO 0);   
        pllpowerdn              : OUT std_logic_vector(2 DOWNTO 0);   
        quadresetout            : OUT std_logic;   
        refclkdividerdprioout   : OUT std_logic_vector(1 DOWNTO 0);   
        rxadcepowerdn           : OUT std_logic_vector(3 DOWNTO 0);   
        rxadceresetout          : OUT std_logic_vector(3 DOWNTO 0);   
        rxanalogresetout        : OUT std_logic_vector(3 DOWNTO 0);   
        rxcruresetout           : OUT std_logic_vector(3 DOWNTO 0);   
        rxcrupowerdn            : OUT std_logic_vector(3 DOWNTO 0);   
        rxctrlout               : OUT std_logic_vector(3 DOWNTO 0);   
        rxdataout               : OUT std_logic_vector(31 DOWNTO 0);   
        rxdigitalresetout       : OUT std_logic_vector(3 DOWNTO 0);   
        rxdprioout              : OUT std_logic_vector(rx_dprio_width - 1 DOWNTO 0);   
        rxibpowerdn             : OUT std_logic_vector(3 DOWNTO 0);   
        txctrlout               : OUT std_logic_vector(3 DOWNTO 0);   
        txdataout               : OUT std_logic_vector(31 DOWNTO 0);   
        txdigitalresetout       : OUT std_logic_vector(3 DOWNTO 0);   
        txanalogresetout        : OUT std_logic_vector(3 DOWNTO 0);   
        txdetectrxpowerdn       : OUT std_logic_vector(3 DOWNTO 0);   
        txdividerpowerdn        : OUT std_logic_vector(3 DOWNTO 0);   
        txobpowerdn             : OUT std_logic_vector(3 DOWNTO 0);   
        txdprioout              : OUT std_logic_vector(tx_dprio_width - 1 DOWNTO 0);   
        digitaltestout          : OUT std_logic_vector(9 DOWNTO 0)
        );   
END stratixiigx_hssi_central_management_unit;

ARCHITECTURE vital_cmu_top_arch OF stratixiigx_hssi_central_management_unit IS

    COMPONENT  stratixiigx_hssi_dskw_sm  
	PORT( 
        align_det_sync	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0) := (OTHERS => '0');
        clk_1	        :	IN  STD_LOGIC := '0';
        octal_mode	    :	IN  STD_LOGIC := '0';
        rd_align	    :	IN  STD_LOGIC_VECTOR (7 DOWNTO 0) := (OTHERS => '0');
        soft_reset	    :	IN  STD_LOGIC := '0';
        sync_status	    :	IN  STD_LOGIC_VECTOR (7 DOWNTO 0) := (OTHERS => '0');
        align_status	:	OUT  STD_LOGIC;
        curr_state	    :	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
        enable_deskew	:	OUT  STD_LOGIC;
        fifo_reset_rd	:	OUT  STD_LOGIC
	); 
    END COMPONENT;

    COMPONENT  stratixiigx_hssi_rcv_sm  
    PORT ( 
        clk_2	            :	IN  STD_LOGIC := '0';
        dec_ctl	            :	IN  STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0');
        dec_data	        :	IN  STD_LOGIC_VECTOR (31 DOWNTO 0) := (OTHERS => '0');
        dec_data_valid	    :	IN  STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0');
        indv	            :	IN  STD_LOGIC := '0';
        running_disp	    :	IN  STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0');
        rx_local_fault_clr	:	IN  STD_LOGIC := '0';
        soft_reset	        :	IN  STD_LOGIC := '0';
        tx_local_fault_det	:	IN  STD_LOGIC := '0';
        xs_link_status_set	:	IN  STD_LOGIC := '0';
        curr_state	        :	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
        rx_ctl_rs	        :	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
        rx_data_rs	        :	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
        rx_local_fault	    :	OUT  STD_LOGIC;
        xs_link_status	    :	OUT  STD_LOGIC
	); 
    END COMPONENT;

    COMPONENT  stratixiigx_hssi_tx_sm  
    PORT ( 
        indv	            :	IN  STD_LOGIC := '0';
        rd_enable_sync	    :	IN  STD_LOGIC := '0';
        soft_reset	        :	IN  STD_LOGIC := '0';
        tx_clk	            :	IN  STD_LOGIC := '0';
        tx_ctl	            :	IN  STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0');
        tx_data	            :	IN  STD_LOGIC_VECTOR (31 DOWNTO 0) := (OTHERS => '0');
        tx_local_fault_clr	:	IN  STD_LOGIC := '0';
        curr_state	        :	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
        sm_ctl	            :	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
        sm_data	            :	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
        tx_local_fault	    :	OUT  STD_LOGIC;
		tx_local_fault_det	:	OUT  STD_LOGIC
    ); 
    END COMPONENT;

 COMPONENT stratixiigx_hssi_cmu_dprio_top 
    GENERIC (
       rx0_phy : INTEGER := 0;
       rx1_phy : INTEGER := 1;
       rx2_phy : INTEGER := 2;
       rx3_phy : INTEGER := 3;
       tx0_phy : INTEGER := 0;
       tx1_phy : INTEGER := 1;
       tx2_phy : INTEGER := 2;
       tx3_phy : INTEGER := 3;
       
       rx_dprio_width   :  INTEGER := 800;               -- 6.1
       tx_dprio_width   :  INTEGER := 400;               -- 6.1        
        
       rx0_cru_clock0_physical_mapping:  string := "refclk0";    
       rx0_cru_clock1_physical_mapping:  string := "refclk1";    
       rx0_cru_clock2_physical_mapping:  string := "iq0";    
       rx0_cru_clock3_physical_mapping:  string := "iq1";    
       rx0_cru_clock4_physical_mapping:  string := "iq2";    
       rx0_cru_clock5_physical_mapping:  string := "iq3";    
       rx0_cru_clock6_physical_mapping:  string := "iq4";    
       rx0_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx0_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
       rx1_cru_clock0_physical_mapping:  string := "refclk0";    
       rx1_cru_clock1_physical_mapping:  string := "refclk1";    
       rx1_cru_clock2_physical_mapping:  string := "iq0";    
       rx1_cru_clock3_physical_mapping:  string := "iq1";    
       rx1_cru_clock4_physical_mapping:  string := "iq2";    
       rx1_cru_clock5_physical_mapping:  string := "iq3";    
       rx1_cru_clock6_physical_mapping:  string := "iq4";    
       rx1_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx1_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
       rx2_cru_clock0_physical_mapping:  string := "refclk0";    
       rx2_cru_clock1_physical_mapping:  string := "refclk1";    
       rx2_cru_clock2_physical_mapping:  string := "iq0";    
       rx2_cru_clock3_physical_mapping:  string := "iq1";    
       rx2_cru_clock4_physical_mapping:  string := "iq2";    
       rx2_cru_clock5_physical_mapping:  string := "iq3";    
       rx2_cru_clock6_physical_mapping:  string := "iq4";    
       rx2_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx2_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
       rx3_cru_clock0_physical_mapping:  string := "refclk0";    
       rx3_cru_clock1_physical_mapping:  string := "refclk1";    
       rx3_cru_clock2_physical_mapping:  string := "iq0";    
       rx3_cru_clock3_physical_mapping:  string := "iq1";    
       rx3_cru_clock4_physical_mapping:  string := "iq2";    
       rx3_cru_clock5_physical_mapping:  string := "iq3";    
       rx3_cru_clock6_physical_mapping:  string := "iq4";    
       rx3_cru_clock7_physical_mapping:  string := "pld_cru_clk";    
       rx3_cru_clock8_physical_mapping:  string := "cmu_div_clk";  
          
       pll0_phy: integer := 0;    
       pll1_phy: integer := 1;    
       pll2_phy: integer := 2;   
       
       pll0_inclk0_logical_to_physical_mapping: string := "iq0";
       pll0_inclk1_logical_to_physical_mapping: string := "iq1";
       pll0_inclk2_logical_to_physical_mapping: string := "iq2";
       pll0_inclk3_logical_to_physical_mapping: string := "iq3";
       pll0_inclk4_logical_to_physical_mapping: string := "iq4";
       pll0_inclk5_logical_to_physical_mapping: string := "pld_clk";
       pll0_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
       pll0_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
       pll1_inclk0_logical_to_physical_mapping: string := "iq0";
       pll1_inclk1_logical_to_physical_mapping: string := "iq1";
       pll1_inclk2_logical_to_physical_mapping: string := "iq2";
       pll1_inclk3_logical_to_physical_mapping: string := "iq3";
       pll1_inclk4_logical_to_physical_mapping: string := "iq4";
       pll1_inclk5_logical_to_physical_mapping: string := "pld_clk";
       pll1_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
       pll1_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
       pll2_inclk0_logical_to_physical_mapping: string := "iq0";
       pll2_inclk1_logical_to_physical_mapping: string := "iq1";
       pll2_inclk2_logical_to_physical_mapping: string := "iq2";
       pll2_inclk3_logical_to_physical_mapping: string := "iq3";
       pll2_inclk4_logical_to_physical_mapping: string := "iq4";
       pll2_inclk5_logical_to_physical_mapping: string := "pld_clk";
       pll2_inclk6_logical_to_physical_mapping: string := "clkrefclk0";
       pll2_inclk7_logical_to_physical_mapping: string := "clkrefclk1";
        
       tx0_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx0_pll_fast_clk1_physical_mapping: string := "pll1";    
       tx1_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx1_pll_fast_clk1_physical_mapping: string := "pll1";    
       tx2_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx2_pll_fast_clk1_physical_mapping: string := "pll1";    
       tx3_pll_fast_clk0_physical_mapping: string := "pll0";    
       tx3_pll_fast_clk1_physical_mapping: string := "pll1";
       sim_dump_dprio_internal_reg_at_time: integer := 0;
       sim_dump_filename: string := "sim_dprio_dump.txt"

             

    );
    PORT (
        sync_status             : IN std_logic_vector(3 DOWNTO 0) := (OTHERS => '0');   
        align_status            : IN std_logic := '0';   
        mdio_in                 : IN std_logic := '0';   
        mdc                     : IN std_logic := '0';   
        port_addr               : IN std_logic_vector(4 DOWNTO 0) := (OTHERS => '0');   
        dev_addr                : IN std_logic_vector(4 DOWNTO 0) := (OTHERS => '0');   
        mdio_dis                : IN std_logic := '0';   
        dprioload               : IN std_logic := '0';   
        mdio_rst                : IN std_logic := '0';   
        cmudividerdprioin       : IN std_logic_vector(29 DOWNTO 0)  := (OTHERS => '0');   
        cmuplldprioin           : IN std_logic_vector(119 DOWNTO 0) := (OTHERS => '0');   
        cmudprioin              : IN std_logic_vector(29 DOWNTO 0)  := (OTHERS => '0');   
        refclkdividerdprioin    : IN std_logic_vector(1 DOWNTO 0)   := (OTHERS => '0');   
        rxdprioin               : IN std_logic_vector(rx_dprio_width - 1 DOWNTO 0) := (OTHERS => '0');   
        txdprioin               : IN std_logic_vector(tx_dprio_width - 1 DOWNTO 0) := (OTHERS => '0');   

        cmudividerdprioout      : OUT std_logic_vector(29 DOWNTO 0);   
        cmuplldprioout          : OUT std_logic_vector(119 DOWNTO 0);   
        cmudprioout             : OUT std_logic_vector(29 DOWNTO 0);   
        refclkdividerdprioout   : OUT std_logic_vector(1 DOWNTO 0);   
        rxdprioout              : OUT std_logic_vector(rx_dprio_width - 1 DOWNTO 0);   
        txdprioout              : OUT std_logic_vector(tx_dprio_width - 1 DOWNTO 0);   
        mdio_out                : OUT std_logic;   
        data_enable_n           : OUT std_logic;   
        mdio_curr_st            : OUT std_logic_vector(2 DOWNTO 0)
	);   
    END COMPONENT;
    
	SIGNAL my_gnd                   :  std_logic := '0';

    SIGNAL enpll                    :  std_logic;   
    SIGNAL pllurst                  :  std_logic;   
    SIGNAL rxurstpcs                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txurstpcs                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rxurstpma                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL urx_pdb                  :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL hard_reset               :  std_logic;   
    SIGNAL rxpma_rstb               :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txpma_rstb               :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rxpcs_rst                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txpcs_rst                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL cru_rstb                 :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL adce_rstb                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL cmu_txpll_rstb           :  std_logic_vector(2 DOWNTO 0);   
    SIGNAL tx_pdb                   :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rx_pdb                   :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL cru_pdb                  :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL adce_pdb                 :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL cgb_pdb                  :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL cmu_txpll_pdb            :  std_logic_vector(2 DOWNTO 0);   
    SIGNAL rx_det_pdb               :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rxpcsrst_hssi            :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txpcsrst_hssi            :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rxpmarst_hssi            :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL pipe_rst_hssi            :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rx_pd_hssi               :  std_logic_vector(3 DOWNTO 0);   

    SIGNAL refclk_pma_out           :  std_logic;   
    SIGNAL mdc_b                    :  std_logic;   
    SIGNAL refclk_b                 :  std_logic;   
    SIGNAL clk_1_b                  :  std_logic;   
    SIGNAL clk_2_b                  :  std_logic;   
    SIGNAL rxrst_int                :  std_logic := '0';   
    SIGNAL txrst_int                :  std_logic := '0';   
    SIGNAL txrst_sync1              :  std_logic := '0';   
    SIGNAL txrst_sync2              :  std_logic := '0';   
    SIGNAL rxrst_sync1              :  std_logic := '0';   
    SIGNAL rxrst_sync2              :  std_logic := '0';   
    SIGNAL dskw_curr_st             :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL alignstatus_int          :  std_logic := '0';   
    SIGNAL align_det_sync_sig       :  std_logic_vector(7 DOWNTO 0) := (OTHERS => '0');   
    SIGNAL rd_align_sig             :  std_logic_vector(7 DOWNTO 0) := (OTHERS => '0');   
    SIGNAL sync_status_sig          :  std_logic_vector(7 DOWNTO 0) := (OTHERS => '0');   
    SIGNAL rtx_rx_local_fault_clr_int      :  std_logic;   
    SIGNAL rindv_tx_int             :  std_logic;   
    SIGNAL tx_curr_st               :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL tx_local_fault_det       :  std_logic;   
    SIGNAL tx_local_fault_int       :  std_logic;   
    SIGNAL rindv_rx_int             :  std_logic;   
    SIGNAL rxs_link_status_set_int  :  std_logic;   
    SIGNAL rx_local_fault_int       :  std_logic;   
    SIGNAL xlink_status_int         :  std_logic;   
    SIGNAL rcv_curr_st              :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL port_addr                :  std_logic_vector(4 DOWNTO 0);   
    SIGNAL dev_addr                 :  std_logic_vector(4 DOWNTO 0);   
    SIGNAL mdio_rst                 :  std_logic;
    SIGNAL mdio_rst_reg             :  std_logic := '1';      
    SIGNAL cmudprioin               :  std_logic_vector(29 DOWNTO 0);   
    SIGNAL cmudprioout              :  std_logic_vector(29 DOWNTO 0);   
    SIGNAL mdio_curr_st             :  std_logic_vector(2 DOWNTO 0);   
    SIGNAL cmudividerdprioout_sig :  std_logic_vector(29 DOWNTO 0);   
    SIGNAL cmuplldprioout_sig     :  std_logic_vector(119 DOWNTO 0);   
    SIGNAL dpriooe_tim              :  std_logic;   
    SIGNAL dprioout_tim             :  std_logic;   
    SIGNAL enabledeskew_sig       :  std_logic;   
    SIGNAL fiforesetrd_sig        :  std_logic;   
    SIGNAL refclkdividerdprioout_xhdl13    :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL rxctrlout_xhdl19         :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rxdataout_xhdl20         :  std_logic_vector(31 DOWNTO 0);   
    SIGNAL rxdprioout_xhdl22        :  std_logic_vector(rx_dprio_width-1 DOWNTO 0);   
    SIGNAL txctrlout_xhdl25         :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txdataout_xhdl26         :  std_logic_vector(31 DOWNTO 0);   
    SIGNAL txdprioout_xhdl30        :  std_logic_vector(tx_dprio_width-1 DOWNTO 0);   
    SIGNAL xs_link_status_int       :  std_logic;   

    -- Signals for input buffers
    SIGNAL dpclk_in : std_logic;
    SIGNAL dpriodisable_in : std_logic;
    SIGNAL dprioin_in : std_logic;
    SIGNAL dprioload_in : std_logic;
    SIGNAL fixedclk_in : std_logic_vector(3 DOWNTO 0);
    SIGNAL quadenable_in : std_logic;
    SIGNAL quadreset_in : std_logic;
    SIGNAL rxanalogreset_in : std_logic_vector(3 DOWNTO 0);
    SIGNAL rxclk_in : std_logic;
    SIGNAL rxdigitalreset_in : std_logic_vector(3 DOWNTO 0);
    SIGNAL rxpowerdown_in : std_logic_vector(3 DOWNTO 0);
    SIGNAL txclk_in : std_logic;
    SIGNAL txdigitalreset_in : std_logic_vector(3 DOWNTO 0);

    -- Signals for internal delays
    SIGNAL mdio_in : std_logic;

    -- Opt 
    -- generic
    SIGNAL init_in_xaui_mode : std_logic := '0';
    
    -- clocks
    SIGNAL dskw_sm_clk : std_logic := '0';
    SIGNAL rcv_sm_clk  : std_logic := '0';
    SIGNAL tx_sm_clk   : std_logic := '0';
    
    -- data paths
    SIGNAL tx_sm_datain         : std_logic_vector(31 DOWNTO 0) := (OTHERS => '0'); 
    SIGNAL tx_sm_ctrlin         : std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0'); 
    SIGNAL tx_sm_rdenablesyncin : std_logic                     := '0';

    SIGNAL rcv_sm_decdatavalid  : std_logic_vector(3 DOWNTO 0)  := (OTHERS => '1');
    SIGNAL rcv_sm_decdata       : std_logic_vector(31 DOWNTO 0) := (OTHERS => '0');
    SIGNAL rcv_sm_decctl        : std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');
    SIGNAL rcv_sm_rxrunningdisp : std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');
        
BEGIN

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------
    WireDelay : block
    begin
        VitalWireDelay (dpclk_in, dpclk, tipd_dpclk);
        VitalWireDelay (dpriodisable_in, dpriodisable, tipd_dpriodisable);
        VitalWireDelay (dprioin_in, dprioin, tipd_dprioin);
        VitalWireDelay (dprioload_in, dprioload, tipd_dprioload);

        VitalWireDelay (fixedclk_in(0), fixedclk(0), tipd_fixedclk(0));
        VitalWireDelay (fixedclk_in(1), fixedclk(1), tipd_fixedclk(1));
        VitalWireDelay (fixedclk_in(2), fixedclk(2), tipd_fixedclk(2));
        VitalWireDelay (fixedclk_in(3), fixedclk(3), tipd_fixedclk(3));

        VitalWireDelay (quadenable_in, quadenable, tipd_quadenable);
        VitalWireDelay (quadreset_in, quadreset, tipd_quadreset);

        VitalWireDelay (rxanalogreset_in(0), rxanalogreset(0), tipd_rxanalogreset(0));
        VitalWireDelay (rxanalogreset_in(1), rxanalogreset(1), tipd_rxanalogreset(1));
        VitalWireDelay (rxanalogreset_in(2), rxanalogreset(2), tipd_rxanalogreset(2));
        VitalWireDelay (rxanalogreset_in(3), rxanalogreset(3), tipd_rxanalogreset(3));

        VitalWireDelay (rxclk_in, rxclk, tipd_rxclk);

        VitalWireDelay (rxdigitalreset_in(0), rxdigitalreset(0), tipd_rxdigitalreset(0));
        VitalWireDelay (rxdigitalreset_in(1), rxdigitalreset(1), tipd_rxdigitalreset(1));
        VitalWireDelay (rxdigitalreset_in(2), rxdigitalreset(2), tipd_rxdigitalreset(2));
        VitalWireDelay (rxdigitalreset_in(3), rxdigitalreset(3), tipd_rxdigitalreset(3));

        VitalWireDelay (rxpowerdown_in(0), rxpowerdown(0), tipd_rxpowerdown(0));
        VitalWireDelay (rxpowerdown_in(1), rxpowerdown(1), tipd_rxpowerdown(1));
        VitalWireDelay (rxpowerdown_in(2), rxpowerdown(2), tipd_rxpowerdown(2));
        VitalWireDelay (rxpowerdown_in(3), rxpowerdown(3), tipd_rxpowerdown(3));

        VitalWireDelay (txclk_in, txclk, tipd_txclk);

        VitalWireDelay (txdigitalreset_in(0), txdigitalreset(0), tipd_txdigitalreset(0));
        VitalWireDelay (txdigitalreset_in(1), txdigitalreset(1), tipd_txdigitalreset(1));
        VitalWireDelay (txdigitalreset_in(2), txdigitalreset(2), tipd_txdigitalreset(2));
        VitalWireDelay (txdigitalreset_in(3), txdigitalreset(3), tipd_txdigitalreset(3));

    end block;

    alignstatus <= alignstatus_int;
    clkdivpowerdn <= '0';
    cmudividerdprioout <= cmudividerdprioout_sig;
    cmuplldprioout <= cmuplldprioout_sig;
    dpriodisableout <= dpriodisable_in;
    dpriooe <= dpriooe_tim;
    dprioout <= dprioout_tim;
    enabledeskew <= enabledeskew_sig;
    fiforesetrd <= fiforesetrd_sig;
    pllpowerdn <= cmu_txpll_pdb;
    pllresetout <= NOT (cmu_txpll_rstb);
    quadresetout <= hard_reset;
    refclkdividerdprioout <= refclkdividerdprioout_xhdl13;
    rxadcepowerdn <= adce_pdb;
    rxadceresetout <= NOT (adce_rstb);
    rxanalogresetout <= NOT(rxpma_rstb);
    rxcrupowerdn <= cru_pdb;
    rxcruresetout <= NOT cru_rstb;
    rxctrlout <= rxctrlout_xhdl19;
    rxdataout <= rxdataout_xhdl20;
    rxdigitalresetout <= rxpcs_rst;
    rxdprioout <= rxdprioout_xhdl22;
    rxibpowerdn <= rx_pdb;
    txanalogresetout <= NOT txpma_rstb;
    txctrlout <= txctrlout_xhdl25;
    txdataout <= txdataout_xhdl26;
    txdetectrxpowerdn <= rx_det_pdb;
    txdigitalresetout <= txpcs_rst;
    txdividerpowerdn <= cgb_pdb;
    txdprioout <= txdprioout_xhdl30;
    txobpowerdn <= tx_pdb;
    digitaltestout <= "XXXXXXXXXX";

    enpll <= '0' WHEN (quadenable_in = '0') ELSE '1';
    pllurst <= '1' WHEN (quadreset_in = '1') ELSE '0';
    rxurstpcs <= rxdigitalreset_in;
    txurstpcs <= txdigitalreset_in;
    rxurstpma <= rxanalogreset_in;
    urx_pdb <= rxpowerdown_in;
    hard_reset <= '1' WHEN (enpll = '0' OR pllurst = '1') ELSE '0' ;
    rxpcsrst_hssi(0) <= '1' WHEN rxurstpcs(0) = '1' ELSE '0' ;
    rxpcsrst_hssi(1) <= '1' WHEN rxurstpcs(1) = '1' ELSE '0' ;
    rxpcsrst_hssi(2) <= '1' WHEN rxurstpcs(2) = '1' ELSE '0' ;
    rxpcsrst_hssi(3) <= '1' WHEN rxurstpcs(3) = '1' ELSE '0' ;
    txpcsrst_hssi(0) <= '1' WHEN txurstpcs(0) = '1' ELSE '0' ;
    txpcsrst_hssi(1) <= '1' WHEN txurstpcs(1) = '1' ELSE '0' ;
    txpcsrst_hssi(2) <= '1' WHEN txurstpcs(2) = '1' ELSE '0' ;
    txpcsrst_hssi(3) <= '1' WHEN txurstpcs(3) = '1' ELSE '0' ;
    rxpcs_rst <= rxpcsrst_hssi OR hard_reset & hard_reset & hard_reset & hard_reset ;
    txpcs_rst <= txpcsrst_hssi OR hard_reset & hard_reset & hard_reset & hard_reset ;
    rxpmarst_hssi(0) <= '1' WHEN rxurstpma(0) = '1' ELSE '0' ;
    rxpmarst_hssi(1) <= '1' WHEN rxurstpma(1) = '1' ELSE '0' ;
    rxpmarst_hssi(2) <= '1' WHEN rxurstpma(2) = '1' ELSE '0' ;
    rxpmarst_hssi(3) <= '1' WHEN rxurstpma(3) = '1' ELSE '0' ;
    rxpma_rstb <= NOT (rxpmarst_hssi OR hard_reset & hard_reset & hard_reset & hard_reset) ;
    txpma_rstb <= NOT (hard_reset & hard_reset & hard_reset & hard_reset) ;
    cru_rstb <= rxpma_rstb ;
    adce_rstb <= rxpma_rstb ;
    cmu_txpll_rstb <= NOT (hard_reset & hard_reset & hard_reset) ;
    rx_pd_hssi(0) <= '1' WHEN (urx_pdb(0) = '1') ELSE '0' ;
    rx_pd_hssi(1) <= '1' WHEN (urx_pdb(1) = '1') ELSE '0' ;
    rx_pd_hssi(2) <= '1' WHEN (urx_pdb(2) = '1') ELSE '0' ;
    rx_pd_hssi(3) <= '1' WHEN (urx_pdb(3) = '1') ELSE '0' ;
    rx_pdb <= rx_pd_hssi OR hard_reset & hard_reset & hard_reset & hard_reset ;
    tx_pdb <= hard_reset & hard_reset & hard_reset & hard_reset ;
    cru_pdb <= hard_reset & hard_reset & hard_reset & hard_reset ;
    adce_pdb <= hard_reset & hard_reset & hard_reset & hard_reset ;
    cgb_pdb <= hard_reset & hard_reset & hard_reset & hard_reset ;
    rx_det_pdb <= hard_reset & hard_reset & hard_reset & hard_reset ;
    cmu_txpll_pdb <= hard_reset & hard_reset & hard_reset ;
    refclk_pma_out <= txclk_in;
    mdc_b <= dpclk_in;
    refclk_b <= refclk_pma_out ;
    clk_1_b <= recovclk ;
    clk_2_b <= rxclk_in;

    PROCESS
    BEGIN
        WAIT UNTIL (hard_reset'EVENT AND hard_reset = '1') OR (clk_2_b'EVENT AND clk_2_b = '1');
        IF (hard_reset = '1') THEN
            rxrst_sync2 <= '1';    
            rxrst_sync1 <= '1';    
        ELSE
            rxrst_sync2 <= rxrst_sync1 AFTER 1 ps;    
            rxrst_sync1 <= rxpcs_rst(0);    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (hard_reset'EVENT AND hard_reset = '1') OR (refclk_b'EVENT AND refclk_b = '1');
        IF (hard_reset = '1') THEN
            txrst_sync2 <= '1';    
            txrst_sync1 <= '1';    
        ELSE
            txrst_sync2 <= txrst_sync1 AFTER 1 ps;    
            txrst_sync1 <= txpcs_rst(0);    
        END IF;
    END PROCESS;

    VITAL: PROCESS (dpclk_in, dprioin_in, dprioout_tim, dpriooe_tim)
    variable Tviol_dprioin_dpclk : std_ulogic := '0';
    variable TimingData_dprioin_dpclk : VitalTimingDataType := VitalTimingDataInit;
    variable dprioout_VitalGlitchData: VitalGlitchDataType;
    variable dpriooe_VitalGlitchData: VitalGlitchDataType;
    
    BEGIN
    
    	------------------------
    	--  Timing Check Section
    	------------------------
    
    	if (TimingChecksOn) then
    
    		VitalSetupHoldCheck (
    			Violation       => Tviol_dprioin_dpclk,
    			TimingData      => TimingData_dprioin_dpclk,
    			TestSignal      => dprioin_in,
    			TestSignalName  => "DPRIOIN",
    			RefSignal       => dpclk_in,
    			RefSignalName   => "DPCLK",
    			SetupHigh       => tsetup_dprioin_dpclk_noedge_posedge,
                SetupLow        => tsetup_dprioin_dpclk_noedge_posedge,
    			HoldHigh        => thold_dprioin_dpclk_noedge_posedge,
    			HoldLow         => thold_dprioin_dpclk_noedge_posedge,
    			RefTransition   => '/',
    			HeaderMsg       => InstancePath & "/STRATIXIIGX_HSSI_CENTRAL_MANAGEMENT_UNIT",
    			XOn             => XOnChecks,
    			MsgOn           => MsgOnChecks );
       end if;

        ----------------------
        --  Path Delay Section
        ----------------------
 
        VitalPathDelay01 (
            OutSignal => dprioout,
            OutSignalName => "DPRIOOUT",
            OutTemp => dprioout_tim,
            Paths => (1 => (dpclk_in'last_event, tpd_dpclk_dprioout_posedge, TRUE)),
            GlitchData => dprioout_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn  => XOn,
            MsgOn  => MsgOn );

        VitalPathDelay01 (
            OutSignal => dpriooe,
            OutSignalName => "DPRIOOE",
            OutTemp => dpriooe_tim,
            Paths => (1 => (dpclk_in'last_event, tpd_dpclk_dpriooe_posedge, TRUE)),
            GlitchData => dpriooe_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn  => XOn,
            MsgOn  => MsgOn );

    END PROCESS;

    txrst_int <= txrst_sync2 ;
    rxrst_int <= rxrst_sync2 ;

    -- OPT generic
    init_in_xaui_mode <= '1' WHEN (in_xaui_mode = "true" OR use_deskew_fifo = "true") ELSE '0';
    
    align_det_sync_sig <= ("1111" & adet);
    sync_status_sig <= ("1111" & syncstatus);
    rd_align_sig <= ("1111" & rdalign);
    
    dskw_sm_clk <= clk_1_b WHEN (init_in_xaui_mode = '1') ELSE '0';

    dskw_sm_1 : stratixiigx_hssi_dskw_sm 
        PORT MAP (
            soft_reset => rxrst_int,
            clk_1 => dskw_sm_clk,
            --clk_1 => clk_1_b,
            octal_mode => my_gnd,
            align_det_sync => align_det_sync_sig,
            rd_align => rd_align_sig,
            sync_status => sync_status_sig,
            align_status => alignstatus_int,
            enable_deskew => enabledeskew_sig,
            fifo_reset_rd => fiforesetrd_sig,
            curr_state => dskw_curr_st);   
    
    rtx_rx_local_fault_clr_int <= '0' ;
    rindv_tx_int <= '0' ;
    
    tx_sm_clk            <= refclk_b     WHEN (init_in_xaui_mode = '1') ELSE '0';
    tx_sm_datain         <= txdatain     WHEN (init_in_xaui_mode = '1') ELSE "00000000000000000000000000000000";
    tx_sm_ctrlin         <= txctrl       WHEN (init_in_xaui_mode = '1') ELSE "0000";
    tx_sm_rdenablesyncin <= rdenablesync WHEN (init_in_xaui_mode = '1') ELSE '0';
    
    tx_sm_1 : stratixiigx_hssi_tx_sm 
        PORT MAP (
            tx_clk => tx_sm_clk,
            -- tx_clk => refclk_b,
            soft_reset => txrst_int,
            indv => rindv_tx_int,
            tx_data => tx_sm_datain,
            --tx_data => txdatain,
            tx_ctl => tx_sm_ctrlin,
            --tx_ctl => txctrl,
            rd_enable_sync => tx_sm_rdenablesyncin,
            --rd_enable_sync => rdenablesync,
            tx_local_fault_clr => rtx_rx_local_fault_clr_int,
            sm_data => txdataout_xhdl26,
            sm_ctl => txctrlout_xhdl25,
            tx_local_fault_det => tx_local_fault_det,
            tx_local_fault => tx_local_fault_int,
            curr_state => tx_curr_st);   
    
    rindv_rx_int <= '0' ;
    rxs_link_status_set_int <= '0' ;
    
    rcv_sm_clk           <= clk_2_b       WHEN (init_in_xaui_mode = '1') ELSE '0';
    rcv_sm_decdatavalid  <= rxdatavalid   WHEN (init_in_xaui_mode = '1') ELSE "1111";
    rcv_sm_decdata       <= rxdatain      WHEN (init_in_xaui_mode = '1') ELSE "00000000000000000000000000000000";
    rcv_sm_decctl        <= rxctrl        WHEN (init_in_xaui_mode = '1') ELSE "0000";
    rcv_sm_rxrunningdisp <= rxrunningdisp WHEN (init_in_xaui_mode = '1') ELSE "0000";
    
    rcv_sm_1 : stratixiigx_hssi_rcv_sm 
        PORT MAP (
            clk_2 => rcv_sm_clk,
            --clk_2 => clk_2_b,
            soft_reset => rxrst_int,
            indv => rindv_rx_int,
            dec_data_valid => rcv_sm_decdatavalid,
            --dec_data_valid => rxdatavalid,
            dec_data => rcv_sm_decdata,
            --dec_data => rxdatain,
            dec_ctl => rcv_sm_decctl,
            --dec_ctl => rxctrl,
            running_disp => rcv_sm_rxrunningdisp,
            --running_disp => rxrunningdisp,
            rx_local_fault_clr => rtx_rx_local_fault_clr_int,
            xs_link_status_set => rxs_link_status_set_int,
            tx_local_fault_det => tx_local_fault_det,
            rx_data_rs => rxdataout_xhdl20,
            rx_ctl_rs => rxctrlout_xhdl19,
            rx_local_fault => rx_local_fault_int,
            xs_link_status => xs_link_status_int,
            curr_state => rcv_curr_st);   
    
    port_addr <= int2bin((portaddr - 1), 5);        -- 1-based in Quartus
    dev_addr  <= int2bin((devaddr - 1), 5);         -- 1-based in Quartus
        
    mdio_in  <= dprioin_in AFTER 1 ps;
    
    mdio_rst_reg <= '0' AFTER 1000 ps;    
    mdio_rst <= mdio_rst_reg ;
    cmudprioin <= "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ;
    
    control_top_0 : stratixiigx_hssi_cmu_dprio_top 
        GENERIC MAP ( 
            rx0_phy => rx0_logical_to_physical_mapping,
            rx1_phy => rx1_logical_to_physical_mapping,
            rx2_phy => rx2_logical_to_physical_mapping,
            rx3_phy => rx3_logical_to_physical_mapping,

            tx0_phy => tx0_logical_to_physical_mapping,
            tx1_phy => tx1_logical_to_physical_mapping,
            tx2_phy => tx2_logical_to_physical_mapping,
            tx3_phy => tx3_logical_to_physical_mapping,

            rx_dprio_width => rx_dprio_width,
            tx_dprio_width => tx_dprio_width,

            rx0_cru_clock0_physical_mapping => rx0_cru_clock0_physical_mapping, 
            rx0_cru_clock1_physical_mapping => rx0_cru_clock1_physical_mapping, 
            rx0_cru_clock2_physical_mapping => rx0_cru_clock2_physical_mapping, 
            rx0_cru_clock3_physical_mapping => rx0_cru_clock3_physical_mapping, 
            rx0_cru_clock4_physical_mapping => rx0_cru_clock4_physical_mapping, 
            rx0_cru_clock5_physical_mapping => rx0_cru_clock5_physical_mapping, 
            rx0_cru_clock6_physical_mapping => rx0_cru_clock6_physical_mapping, 
            rx0_cru_clock7_physical_mapping => rx0_cru_clock7_physical_mapping, 
            rx0_cru_clock8_physical_mapping => rx0_cru_clock8_physical_mapping, 
            rx1_cru_clock0_physical_mapping => rx1_cru_clock0_physical_mapping, 
            rx1_cru_clock1_physical_mapping => rx1_cru_clock1_physical_mapping, 
            rx1_cru_clock2_physical_mapping => rx1_cru_clock2_physical_mapping, 
            rx1_cru_clock3_physical_mapping => rx1_cru_clock3_physical_mapping, 
            rx1_cru_clock4_physical_mapping => rx1_cru_clock4_physical_mapping, 
            rx1_cru_clock5_physical_mapping => rx1_cru_clock5_physical_mapping, 
            rx1_cru_clock6_physical_mapping => rx1_cru_clock6_physical_mapping, 
            rx1_cru_clock7_physical_mapping => rx1_cru_clock7_physical_mapping, 
            rx1_cru_clock8_physical_mapping => rx1_cru_clock8_physical_mapping, 
            rx2_cru_clock0_physical_mapping => rx2_cru_clock0_physical_mapping, 
            rx2_cru_clock1_physical_mapping => rx2_cru_clock1_physical_mapping, 
            rx2_cru_clock2_physical_mapping => rx2_cru_clock2_physical_mapping, 
            rx2_cru_clock3_physical_mapping => rx2_cru_clock3_physical_mapping, 
            rx2_cru_clock4_physical_mapping => rx2_cru_clock4_physical_mapping, 
            rx2_cru_clock5_physical_mapping => rx2_cru_clock5_physical_mapping, 
            rx2_cru_clock6_physical_mapping => rx2_cru_clock6_physical_mapping, 
            rx2_cru_clock7_physical_mapping => rx2_cru_clock7_physical_mapping, 
            rx2_cru_clock8_physical_mapping => rx2_cru_clock8_physical_mapping, 
            rx3_cru_clock0_physical_mapping => rx3_cru_clock0_physical_mapping, 
            rx3_cru_clock1_physical_mapping => rx3_cru_clock1_physical_mapping, 
            rx3_cru_clock2_physical_mapping => rx3_cru_clock2_physical_mapping, 
            rx3_cru_clock3_physical_mapping => rx3_cru_clock3_physical_mapping, 
            rx3_cru_clock4_physical_mapping => rx3_cru_clock4_physical_mapping, 
            rx3_cru_clock5_physical_mapping => rx3_cru_clock5_physical_mapping, 
            rx3_cru_clock6_physical_mapping => rx3_cru_clock6_physical_mapping, 
            rx3_cru_clock7_physical_mapping => rx3_cru_clock7_physical_mapping, 
            rx3_cru_clock8_physical_mapping => rx3_cru_clock8_physical_mapping, 

            -- CMU_PLL reconfiguration
            pll0_phy => pll0_logical_to_physical_mapping,
            pll1_phy => pll1_logical_to_physical_mapping,
            pll2_phy => pll2_logical_to_physical_mapping, 

            pll0_inclk0_logical_to_physical_mapping => pll0_inclk0_logical_to_physical_mapping,
            pll0_inclk1_logical_to_physical_mapping => pll0_inclk1_logical_to_physical_mapping,
            pll0_inclk2_logical_to_physical_mapping => pll0_inclk2_logical_to_physical_mapping,
            pll0_inclk3_logical_to_physical_mapping => pll0_inclk3_logical_to_physical_mapping,
            pll0_inclk4_logical_to_physical_mapping => pll0_inclk4_logical_to_physical_mapping,
            pll0_inclk5_logical_to_physical_mapping => pll0_inclk5_logical_to_physical_mapping,
            pll0_inclk6_logical_to_physical_mapping => pll0_inclk6_logical_to_physical_mapping,
            pll0_inclk7_logical_to_physical_mapping => pll0_inclk7_logical_to_physical_mapping,
            pll1_inclk0_logical_to_physical_mapping => pll1_inclk0_logical_to_physical_mapping,
            pll1_inclk1_logical_to_physical_mapping => pll1_inclk1_logical_to_physical_mapping,
            pll1_inclk2_logical_to_physical_mapping => pll1_inclk2_logical_to_physical_mapping,
            pll1_inclk3_logical_to_physical_mapping => pll1_inclk3_logical_to_physical_mapping,
            pll1_inclk4_logical_to_physical_mapping => pll1_inclk4_logical_to_physical_mapping,
            pll1_inclk5_logical_to_physical_mapping => pll1_inclk5_logical_to_physical_mapping,
            pll1_inclk6_logical_to_physical_mapping => pll1_inclk6_logical_to_physical_mapping,
            pll1_inclk7_logical_to_physical_mapping => pll1_inclk7_logical_to_physical_mapping,
            pll2_inclk0_logical_to_physical_mapping => pll2_inclk0_logical_to_physical_mapping,
            pll2_inclk1_logical_to_physical_mapping => pll2_inclk1_logical_to_physical_mapping,
            pll2_inclk2_logical_to_physical_mapping => pll2_inclk2_logical_to_physical_mapping,
            pll2_inclk3_logical_to_physical_mapping => pll2_inclk3_logical_to_physical_mapping,
            pll2_inclk4_logical_to_physical_mapping => pll2_inclk4_logical_to_physical_mapping,
            pll2_inclk5_logical_to_physical_mapping => pll2_inclk5_logical_to_physical_mapping,
            pll2_inclk6_logical_to_physical_mapping => pll2_inclk6_logical_to_physical_mapping,
            pll2_inclk7_logical_to_physical_mapping => pll2_inclk7_logical_to_physical_mapping,

            tx0_pll_fast_clk0_physical_mapping => tx0_pll_fast_clk0_physical_mapping, 
            tx0_pll_fast_clk1_physical_mapping => tx0_pll_fast_clk1_physical_mapping, 
            tx1_pll_fast_clk0_physical_mapping => tx1_pll_fast_clk0_physical_mapping, 
            tx1_pll_fast_clk1_physical_mapping => tx1_pll_fast_clk1_physical_mapping, 
            tx2_pll_fast_clk0_physical_mapping => tx2_pll_fast_clk0_physical_mapping, 
            tx2_pll_fast_clk1_physical_mapping => tx2_pll_fast_clk1_physical_mapping, 
            tx3_pll_fast_clk0_physical_mapping => tx3_pll_fast_clk0_physical_mapping, 
            tx3_pll_fast_clk1_physical_mapping => tx3_pll_fast_clk1_physical_mapping,
            sim_dump_dprio_internal_reg_at_time => sim_dump_dprio_internal_reg_at_time,
            sim_dump_filename => sim_dump_filename
        )  
        PORT MAP (
            cmudividerdprioin => cmudividerdprioin,
            cmuplldprioin => cmuplldprioin,
            cmudprioin => cmudprioin,
            refclkdividerdprioin => refclkdividerdprioin,
            rxdprioin => rxdprioin,
            txdprioin => txdprioin,
            cmudividerdprioout => cmudividerdprioout_sig,
            cmuplldprioout => cmuplldprioout_sig,
            cmudprioout => cmudprioout,
            refclkdividerdprioout => refclkdividerdprioout_xhdl13,
            rxdprioout => rxdprioout_xhdl22,
            txdprioout => txdprioout_xhdl30,
            sync_status => syncstatus,
            align_status => alignstatus_int,
            dprioload => dprioload_in,
            mdio_in => mdio_in,
            mdc => dpclk_in,
            port_addr => port_addr,
            dev_addr => dev_addr,
            mdio_dis => dpriodisable_in,
            mdio_rst => mdio_rst,
            mdio_out => dprioout_tim,
            data_enable_n => dpriooe_tim,
            mdio_curr_st => mdio_curr_st);   
    

END vital_cmu_top_arch;
--****************************************************************************
-- Description:
--    This is a flip-flop based implementation
--    Bit 15,14 are the underflow/overflow/insertion/deletion status bits
--    Bit 13 is the running Disparity polarity bits 
--    Bit 12 is the Disparity Error bit
--    Bit 11 is the Resync/Sync_status bit
--    Bit 10 is the Invalid Code bit
--    Bit 9 to 0 -- Encoded 10-bit data
--****************************************************************************

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_ram20x16_syn IS
    GENERIC (
        read_access_time      :  NATURAL := 0;    
        write_access_time     :  NATURAL := 0;    
        ram_width             :  NATURAL := 16
	);  
    PORT (
        data_in                 : IN std_logic_vector(15 DOWNTO 0);   
        clk                     : IN std_logic;   
        fifo_wr                 : IN std_logic_vector(19 DOWNTO 0);   
        rst_l                   : IN std_logic;   
        fifo_re1                : IN std_logic_vector(19 DOWNTO 0);   
        fifo_re2                : IN std_logic_vector(19 DOWNTO 0);   
        data_out1               : OUT std_logic_vector(15 DOWNTO 0);   
        data_out2               : OUT std_logic_vector(15 DOWNTO 0));   
END stratixiigx_hssi_ram20x16_syn;

ARCHITECTURE ram20x16_syn_arch OF stratixiigx_hssi_ram20x16_syn IS


    SIGNAL data_out1_i              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_out2_i              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_8            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_9            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_10           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_11           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_12           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_13           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_14           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_15           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_16           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_17           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_18           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_19           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_8            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_9            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_10           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_11           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_12           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_13           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_14           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_15           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_16           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_17           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_18           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_19           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_0               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_1               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_2               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_3               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_4               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_5               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_6               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_7               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_8               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_9               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_10              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_11              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_12              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_13              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_14              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_15              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_16              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_17              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_18              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_19              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL we                       :  std_logic;   
    SIGNAL re_l                     :  std_logic;   
    --assignment
    -- Assuming address trigerred operation only 
    -- Modelling the read port 
    SIGNAL temp_xhdl3               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl4               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl5               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl6               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl7               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl8               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl9               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl10              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl11              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl12              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl13              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl14              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl15              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl16              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl17              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl18              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl19              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl20              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl21              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl22              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl23              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL temp_xhdl24              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_out1_xhdl1          :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL data_out2_xhdl2          :  std_logic_vector(15 DOWNTO 0);   

BEGIN
    data_out1 <= data_out1_xhdl1;
    data_out2 <= data_out2_xhdl2;
    we <= '1' ;
    re_l <= '0' ;
    temp_xhdl3 <= data_in WHEN (fifo_wr(0) = '1') ELSE ram_array_q_0;
    temp_xhdl4 <= data_in WHEN (fifo_wr(1) = '1') ELSE ram_array_q_1;
    temp_xhdl5 <= data_in WHEN (fifo_wr(2) = '1') ELSE ram_array_q_2;
    temp_xhdl6 <= data_in WHEN (fifo_wr(3) = '1') ELSE ram_array_q_3;
    temp_xhdl7 <= data_in WHEN (fifo_wr(4) = '1') ELSE ram_array_q_4;
    temp_xhdl8 <= data_in WHEN (fifo_wr(5) = '1') ELSE ram_array_q_5;
    temp_xhdl9 <= data_in WHEN (fifo_wr(6) = '1') ELSE ram_array_q_6;
    temp_xhdl10 <= data_in WHEN (fifo_wr(7) = '1') ELSE ram_array_q_7;
    temp_xhdl11 <= data_in WHEN (fifo_wr(8) = '1') ELSE ram_array_q_8;
    temp_xhdl12 <= data_in WHEN (fifo_wr(9) = '1') ELSE ram_array_q_9;
    temp_xhdl13 <= data_in WHEN (fifo_wr(10) = '1') ELSE ram_array_q_10;
    temp_xhdl14 <= data_in WHEN (fifo_wr(11) = '1') ELSE ram_array_q_11;
    temp_xhdl15 <= data_in WHEN (fifo_wr(12) = '1') ELSE ram_array_q_12;
    temp_xhdl16 <= data_in WHEN (fifo_wr(13) = '1') ELSE ram_array_q_13;
    temp_xhdl17 <= data_in WHEN (fifo_wr(14) = '1') ELSE ram_array_q_14;
    temp_xhdl18 <= data_in WHEN (fifo_wr(15) = '1') ELSE ram_array_q_15;
    temp_xhdl19 <= data_in WHEN (fifo_wr(16) = '1') ELSE ram_array_q_16;
    temp_xhdl20 <= data_in WHEN (fifo_wr(17) = '1') ELSE ram_array_q_17;
    temp_xhdl21 <= data_in WHEN (fifo_wr(18) = '1') ELSE ram_array_q_18;
    temp_xhdl22 <= data_in WHEN (fifo_wr(19) = '1') ELSE ram_array_q_19;
    data_reg_0 <= temp_xhdl3 ;
    data_reg_1 <= temp_xhdl4 ;
    data_reg_2 <= temp_xhdl5 ;
    data_reg_3 <= temp_xhdl6 ;
    data_reg_4 <= temp_xhdl7 ;
    data_reg_5 <= temp_xhdl8 ;
    data_reg_6 <= temp_xhdl9 ;
    data_reg_7 <= temp_xhdl10 ;
    data_reg_8 <= temp_xhdl11 ;
    data_reg_9 <= temp_xhdl12 ;
    data_reg_10 <= temp_xhdl13 ;
    data_reg_11 <= temp_xhdl14 ;
    data_reg_12 <= temp_xhdl15 ;
    data_reg_13 <= temp_xhdl16 ;
    data_reg_14 <= temp_xhdl17 ;
    data_reg_15 <= temp_xhdl18 ;
    data_reg_16 <= temp_xhdl19 ;
    data_reg_17 <= temp_xhdl20 ;
    data_reg_18 <= temp_xhdl21 ;
    data_reg_19 <= temp_xhdl22 ;
    temp_xhdl23 <= "0000000000000000" WHEN re_l = '1' ELSE data_out1_i;
    data_out1_xhdl1 <= temp_xhdl23  AFTER (read_access_time * 1 ps);
    temp_xhdl24 <= "0000000000000000" WHEN re_l = '1' ELSE data_out2_i;
    data_out2_xhdl2 <= temp_xhdl24  AFTER (read_access_time * 1 ps);

    PROCESS
    BEGIN
        WAIT UNTIL ram_array_q_0'EVENT OR ram_array_q_1'EVENT OR ram_array_q_2'EVENT OR ram_array_q_3'EVENT OR ram_array_q_4'EVENT OR ram_array_q_5'EVENT OR ram_array_q_6'EVENT OR ram_array_q_7'EVENT OR ram_array_q_8'EVENT OR ram_array_q_9'EVENT OR ram_array_q_10'EVENT OR ram_array_q_11'EVENT OR ram_array_q_12'EVENT OR ram_array_q_13'EVENT OR ram_array_q_14'EVENT OR ram_array_q_15'EVENT OR ram_array_q_16'EVENT OR ram_array_q_17'EVENT OR ram_array_q_18'EVENT OR ram_array_q_19'EVENT OR fifo_re1'EVENT OR fifo_re2'EVENT;
        CASE fifo_re1 IS
            -- synopsys parallel_case full_case
            
            WHEN "00000000000000000001" =>
                        data_out1_i <= ram_array_q_0;    
            WHEN "00000000000000000010" =>
                        data_out1_i <= ram_array_q_1;    
            WHEN "00000000000000000100" =>
                        data_out1_i <= ram_array_q_2;    
            WHEN "00000000000000001000" =>
                        data_out1_i <= ram_array_q_3;    
            WHEN "00000000000000010000" =>
                        data_out1_i <= ram_array_q_4;    
            WHEN "00000000000000100000" =>
                        data_out1_i <= ram_array_q_5;    
            WHEN "00000000000001000000" =>
                        data_out1_i <= ram_array_q_6;    
            WHEN "00000000000010000000" =>
                        data_out1_i <= ram_array_q_7;    
            WHEN "00000000000100000000" =>
                        data_out1_i <= ram_array_q_8;    
            WHEN "00000000001000000000" =>
                        data_out1_i <= ram_array_q_9;    
            WHEN "00000000010000000000" =>
                        data_out1_i <= ram_array_q_10;    
            WHEN "00000000100000000000" =>
                        data_out1_i <= ram_array_q_11;    
            WHEN "00000001000000000000" =>
                        data_out1_i <= ram_array_q_12;    
            WHEN "00000010000000000000" =>
                        data_out1_i <= ram_array_q_13;    
            WHEN "00000100000000000000" =>
                        data_out1_i <= ram_array_q_14;    
            WHEN "00001000000000000000" =>
                        data_out1_i <= ram_array_q_15;    
            WHEN "00010000000000000000" =>
                        data_out1_i <= ram_array_q_16;    
            WHEN "00100000000000000000" =>
                        data_out1_i <= ram_array_q_17;    
            WHEN "01000000000000000000" =>
                        data_out1_i <= ram_array_q_18;    
            WHEN "10000000000000000000" =>
                        data_out1_i <= ram_array_q_19;    
            WHEN OTHERS =>
                        NULL;
            
        END CASE;
        CASE fifo_re2 IS
            -- synopsys parallel_case full_case
            
            WHEN "00000000000000000001" =>
                        data_out2_i <= ram_array_q_0;    
            WHEN "00000000000000000010" =>
                        data_out2_i <= ram_array_q_1;    
            WHEN "00000000000000000100" =>
                        data_out2_i <= ram_array_q_2;    
            WHEN "00000000000000001000" =>
                        data_out2_i <= ram_array_q_3;    
            WHEN "00000000000000010000" =>
                        data_out2_i <= ram_array_q_4;    
            WHEN "00000000000000100000" =>
                        data_out2_i <= ram_array_q_5;    
            WHEN "00000000000001000000" =>
                        data_out2_i <= ram_array_q_6;    
            WHEN "00000000000010000000" =>
                        data_out2_i <= ram_array_q_7;    
            WHEN "00000000000100000000" =>
                        data_out2_i <= ram_array_q_8;    
            WHEN "00000000001000000000" =>
                        data_out2_i <= ram_array_q_9;    
            WHEN "00000000010000000000" =>
                        data_out2_i <= ram_array_q_10;    
            WHEN "00000000100000000000" =>
                        data_out2_i <= ram_array_q_11;    
            WHEN "00000001000000000000" =>
                        data_out2_i <= ram_array_q_12;    
            WHEN "00000010000000000000" =>
                        data_out2_i <= ram_array_q_13;    
            WHEN "00000100000000000000" =>
                        data_out2_i <= ram_array_q_14;    
            WHEN "00001000000000000000" =>
                        data_out2_i <= ram_array_q_15;    
            WHEN "00010000000000000000" =>
                        data_out2_i <= ram_array_q_16;    
            WHEN "00100000000000000000" =>
                        data_out2_i <= ram_array_q_17;    
            WHEN "01000000000000000000" =>
                        data_out2_i <= ram_array_q_18;    
            WHEN "10000000000000000000" =>
                        data_out2_i <= ram_array_q_19;    
            WHEN OTHERS =>
                        NULL;
            
        END CASE;
    END PROCESS;

    -- Modelling the write port 
    PROCESS
    BEGIN
        WAIT UNTIL (clk'EVENT AND clk = '1') OR (rst_l'EVENT AND rst_l = '0');
        IF (NOT rst_l = '1') THEN
            ram_array_q_0 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_1 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_2 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_3 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_4 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_5 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_6 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_7 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_8 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_9 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_10 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_11 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_12 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_13 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_14 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_15 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_16 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_17 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_18 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_19 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
        ELSE
            ram_array_q_0 <= ram_array_d_0 AFTER (write_access_time * 1 ps);    
            ram_array_q_1 <= ram_array_d_1 AFTER (write_access_time * 1 ps);    
            ram_array_q_2 <= ram_array_d_2 AFTER (write_access_time * 1 ps);    
            ram_array_q_3 <= ram_array_d_3 AFTER (write_access_time * 1 ps);    
            ram_array_q_4 <= ram_array_d_4 AFTER (write_access_time * 1 ps);    
            ram_array_q_5 <= ram_array_d_5 AFTER (write_access_time * 1 ps);    
            ram_array_q_6 <= ram_array_d_6 AFTER (write_access_time * 1 ps);    
            ram_array_q_7 <= ram_array_d_7 AFTER (write_access_time * 1 ps);    
            ram_array_q_8 <= ram_array_d_8 AFTER (write_access_time * 1 ps);    
            ram_array_q_9 <= ram_array_d_9 AFTER (write_access_time * 1 ps);    
            ram_array_q_10 <= ram_array_d_10 AFTER (write_access_time * 1 ps);    
            ram_array_q_11 <= ram_array_d_11 AFTER (write_access_time * 1 ps);    
            ram_array_q_12 <= ram_array_d_12 AFTER (write_access_time * 1 ps);    
            ram_array_q_13 <= ram_array_d_13 AFTER (write_access_time * 1 ps);    
            ram_array_q_14 <= ram_array_d_14 AFTER (write_access_time * 1 ps);    
            ram_array_q_15 <= ram_array_d_15 AFTER (write_access_time * 1 ps);    
            ram_array_q_16 <= ram_array_d_16 AFTER (write_access_time * 1 ps);    
            ram_array_q_17 <= ram_array_d_17 AFTER (write_access_time * 1 ps);    
            ram_array_q_18 <= ram_array_d_18 AFTER (write_access_time * 1 ps);    
            ram_array_q_19 <= ram_array_d_19 AFTER (write_access_time * 1 ps);    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL we'EVENT OR data_reg_0'EVENT OR data_reg_1'EVENT OR data_reg_2'EVENT OR data_reg_3'EVENT OR data_reg_4'EVENT OR data_reg_5'EVENT OR data_reg_6'EVENT OR data_reg_7'EVENT OR data_reg_8'EVENT OR data_reg_9'EVENT OR data_reg_10'EVENT OR data_reg_11'EVENT OR data_reg_12'EVENT OR data_reg_13'EVENT OR data_reg_14'EVENT OR data_reg_15'EVENT OR data_reg_16'EVENT OR data_reg_17'EVENT OR data_reg_18'EVENT OR data_reg_19'EVENT OR ram_array_q_0'EVENT OR ram_array_q_1'EVENT OR ram_array_q_2'EVENT OR ram_array_q_3'EVENT OR ram_array_q_4'EVENT OR ram_array_q_5'EVENT OR ram_array_q_6'EVENT OR ram_array_q_7'EVENT OR ram_array_q_8'EVENT OR ram_array_q_9'EVENT OR ram_array_q_10'EVENT OR ram_array_q_11'EVENT OR ram_array_q_12'EVENT OR ram_array_q_13'EVENT OR ram_array_q_14'EVENT OR ram_array_q_15'EVENT OR ram_array_q_16'EVENT OR ram_array_q_17'EVENT OR ram_array_q_18'EVENT OR ram_array_q_19'EVENT;
        IF (we = '1') THEN
            ram_array_d_0 <= data_reg_0 AFTER (write_access_time * 1 ps);    
            ram_array_d_1 <= data_reg_1 AFTER (write_access_time * 1 ps);    
            ram_array_d_2 <= data_reg_2 AFTER (write_access_time * 1 ps);    
            ram_array_d_3 <= data_reg_3 AFTER (write_access_time * 1 ps);    
            ram_array_d_4 <= data_reg_4 AFTER (write_access_time * 1 ps);    
            ram_array_d_5 <= data_reg_5 AFTER (write_access_time * 1 ps);    
            ram_array_d_6 <= data_reg_6 AFTER (write_access_time * 1 ps);    
            ram_array_d_7 <= data_reg_7 AFTER (write_access_time * 1 ps);    
            ram_array_d_8 <= data_reg_8 AFTER (write_access_time * 1 ps);    
            ram_array_d_9 <= data_reg_9 AFTER (write_access_time * 1 ps);    
            ram_array_d_10 <= data_reg_10 AFTER (write_access_time * 1 ps);    
            ram_array_d_11 <= data_reg_11 AFTER (write_access_time * 1 ps);    
            ram_array_d_12 <= data_reg_12 AFTER (write_access_time * 1 ps);    
            ram_array_d_13 <= data_reg_13 AFTER (write_access_time * 1 ps);    
            ram_array_d_14 <= data_reg_14 AFTER (write_access_time * 1 ps);    
            ram_array_d_15 <= data_reg_15 AFTER (write_access_time * 1 ps);    
            ram_array_d_16 <= data_reg_16 AFTER (write_access_time * 1 ps);    
            ram_array_d_17 <= data_reg_17 AFTER (write_access_time * 1 ps);    
            ram_array_d_18 <= data_reg_18 AFTER (write_access_time * 1 ps);    
            ram_array_d_19 <= data_reg_19 AFTER (write_access_time * 1 ps);    
        ELSE
            ram_array_d_0 <= ram_array_q_0 AFTER (write_access_time * 1 ps);    
            ram_array_d_1 <= ram_array_q_1 AFTER (write_access_time * 1 ps);    
            ram_array_d_2 <= ram_array_q_2 AFTER (write_access_time * 1 ps);    
            ram_array_d_3 <= ram_array_q_3 AFTER (write_access_time * 1 ps);    
            ram_array_d_4 <= ram_array_q_4 AFTER (write_access_time * 1 ps);    
            ram_array_d_5 <= ram_array_q_5 AFTER (write_access_time * 1 ps);    
            ram_array_d_6 <= ram_array_q_6 AFTER (write_access_time * 1 ps);    
            ram_array_d_7 <= ram_array_q_7 AFTER (write_access_time * 1 ps);    
            ram_array_d_8 <= ram_array_q_8 AFTER (write_access_time * 1 ps);    
            ram_array_d_9 <= ram_array_q_9 AFTER (write_access_time * 1 ps);    
            ram_array_d_10 <= ram_array_q_10 AFTER (write_access_time * 1 ps);    
            ram_array_d_11 <= ram_array_q_11 AFTER (write_access_time * 1 ps);    
            ram_array_d_12 <= ram_array_q_12 AFTER (write_access_time * 1 ps);    
            ram_array_d_13 <= ram_array_q_13 AFTER (write_access_time * 1 ps);    
            ram_array_d_14 <= ram_array_q_14 AFTER (write_access_time * 1 ps);    
            ram_array_d_15 <= ram_array_q_15 AFTER (write_access_time * 1 ps);    
            ram_array_d_16 <= ram_array_q_16 AFTER (write_access_time * 1 ps);    
            ram_array_d_17 <= ram_array_q_17 AFTER (write_access_time * 1 ps);    
            ram_array_d_18 <= ram_array_q_18 AFTER (write_access_time * 1 ps);    
            ram_array_d_19 <= ram_array_q_19 AFTER (write_access_time * 1 ps);    
        END IF;
    END PROCESS;

END ram20x16_syn_arch;
--************************************************************
-- Description:
--
--    Started from ram16x13_syn.v and modified to have 
--    width of 14
--
--    Bit 13 is the running Disparity polarity bits 
--    Bit 12 is the Disparity Error bit
--    Bit 11 is the Resync/Sync_status bit
--    Bit 10 is the Invalid Code bit
--    Bit 9 to 0 -- Encoded 10-bit data
-- **********************************************************


LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_ram16x14_syn IS
    GENERIC (
        read_access_time      :  NATURAL := 0;    
        write_access_time     :  NATURAL := 0;    
        ram_width             :  NATURAL := 14
	);  
    PORT (
        clk                     : IN std_logic;   
        rst_l                   : IN std_logic;   
        addr_wr                 : IN std_logic_vector(15 DOWNTO 0);   
        addr_rd1                : IN std_logic_vector(15 DOWNTO 0);   
        addr_rd2                : IN std_logic_vector(15 DOWNTO 0);   
        data_in                 : IN std_logic_vector(13 DOWNTO 0);   
        we                      : IN std_logic;   
        re_l                    : IN std_logic;   
        data_out1               : OUT std_logic_vector(13 DOWNTO 0);   
        data_out2               : OUT std_logic_vector(13 DOWNTO 0));   
END stratixiigx_hssi_ram16x14_syn;

ARCHITECTURE ram16x14_syn_arch OF stratixiigx_hssi_ram16x14_syn IS


    SIGNAL data_out1_i              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_out2_i              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_8            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_9            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_10           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_11           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_12           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_13           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_14           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_15           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_8            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_9            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_10           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_11           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_12           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_13           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_14           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_15           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_0               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_1               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_2               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_3               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_4               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_5               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_6               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_7               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_8               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_9               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_10              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_11              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_12              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_13              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_14              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_15              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    --assignment
    -- Assuming address trigerred operation only 
    -- Modelling the read port 
    SIGNAL temp_xhdl3               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl4               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl5               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl6               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl7               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl8               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl9               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl10              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl11              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl12              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl13              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl14              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl15              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl16              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl17              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl18              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl19              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL temp_xhdl20              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_out1_xhdl1          :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL data_out2_xhdl2          :  std_logic_vector(13 DOWNTO 0);   

BEGIN
    data_out1 <= data_out1_xhdl1;
    data_out2 <= data_out2_xhdl2;
    temp_xhdl3 <= data_in WHEN (addr_wr(0) = '1') ELSE ram_array_q_0;
    temp_xhdl4 <= data_in WHEN (addr_wr(1) = '1') ELSE ram_array_q_1;
    temp_xhdl5 <= data_in WHEN (addr_wr(2) = '1') ELSE ram_array_q_2;
    temp_xhdl6 <= data_in WHEN (addr_wr(3) = '1') ELSE ram_array_q_3;
    temp_xhdl7 <= data_in WHEN (addr_wr(4) = '1') ELSE ram_array_q_4;
    temp_xhdl8 <= data_in WHEN (addr_wr(5) = '1') ELSE ram_array_q_5;
    temp_xhdl9 <= data_in WHEN (addr_wr(6) = '1') ELSE ram_array_q_6;
    temp_xhdl10 <= data_in WHEN (addr_wr(7) = '1') ELSE ram_array_q_7;
    temp_xhdl11 <= data_in WHEN (addr_wr(8) = '1') ELSE ram_array_q_8;
    temp_xhdl12 <= data_in WHEN (addr_wr(9) = '1') ELSE ram_array_q_9;
    temp_xhdl13 <= data_in WHEN (addr_wr(10) = '1') ELSE ram_array_q_10;
    temp_xhdl14 <= data_in WHEN (addr_wr(11) = '1') ELSE ram_array_q_11;
    temp_xhdl15 <= data_in WHEN (addr_wr(12) = '1') ELSE ram_array_q_12;
    temp_xhdl16 <= data_in WHEN (addr_wr(13) = '1') ELSE ram_array_q_13;
    temp_xhdl17 <= data_in WHEN (addr_wr(14) = '1') ELSE ram_array_q_14;
    temp_xhdl18 <= data_in WHEN (addr_wr(15) = '1') ELSE ram_array_q_15;
    data_reg_0 <= temp_xhdl3 ;
    data_reg_1 <= temp_xhdl4 ;
    data_reg_2 <= temp_xhdl5 ;
    data_reg_3 <= temp_xhdl6 ;
    data_reg_4 <= temp_xhdl7 ;
    data_reg_5 <= temp_xhdl8 ;
    data_reg_6 <= temp_xhdl9 ;
    data_reg_7 <= temp_xhdl10 ;
    data_reg_8 <= temp_xhdl11 ;
    data_reg_9 <= temp_xhdl12 ;
    data_reg_10 <= temp_xhdl13 ;
    data_reg_11 <= temp_xhdl14 ;
    data_reg_12 <= temp_xhdl15 ;
    data_reg_13 <= temp_xhdl16 ;
    data_reg_14 <= temp_xhdl17 ;
    data_reg_15 <= temp_xhdl18 ;
    temp_xhdl19 <= "00000000000000" WHEN re_l = '1' ELSE data_out1_i;
    data_out1_xhdl1 <= temp_xhdl19  AFTER (read_access_time * 1 ps);
    temp_xhdl20 <= "00000000000000" WHEN re_l = '1' ELSE data_out2_i;
    data_out2_xhdl2 <= temp_xhdl20  AFTER (read_access_time * 1 ps);

    PROCESS
    BEGIN
        WAIT UNTIL ram_array_q_0'EVENT OR ram_array_q_1'EVENT OR ram_array_q_2'EVENT OR ram_array_q_3'EVENT OR ram_array_q_4'EVENT OR ram_array_q_5'EVENT OR ram_array_q_6'EVENT OR ram_array_q_7'EVENT OR ram_array_q_8'EVENT OR ram_array_q_9'EVENT OR ram_array_q_10'EVENT OR ram_array_q_11'EVENT OR ram_array_q_12'EVENT OR ram_array_q_13'EVENT OR ram_array_q_14'EVENT OR ram_array_q_15'EVENT OR addr_rd1'EVENT OR addr_rd2'EVENT;
        CASE addr_rd1 IS
            -- synopsys parallel_case full_case
            
            WHEN "0000000000000001" =>
                        data_out1_i <= ram_array_q_0;    
            WHEN "0000000000000010" =>
                        data_out1_i <= ram_array_q_1;    
            WHEN "0000000000000100" =>
                        data_out1_i <= ram_array_q_2;    
            WHEN "0000000000001000" =>
                        data_out1_i <= ram_array_q_3;    
            WHEN "0000000000010000" =>
                        data_out1_i <= ram_array_q_4;    
            WHEN "0000000000100000" =>
                        data_out1_i <= ram_array_q_5;    
            WHEN "0000000001000000" =>
                        data_out1_i <= ram_array_q_6;    
            WHEN "0000000010000000" =>
                        data_out1_i <= ram_array_q_7;    
            WHEN "0000000100000000" =>
                        data_out1_i <= ram_array_q_8;    
            WHEN "0000001000000000" =>
                        data_out1_i <= ram_array_q_9;    
            WHEN "0000010000000000" =>
                        data_out1_i <= ram_array_q_10;    
            WHEN "0000100000000000" =>
                        data_out1_i <= ram_array_q_11;    
            WHEN "0001000000000000" =>
                        data_out1_i <= ram_array_q_12;    
            WHEN "0010000000000000" =>
                        data_out1_i <= ram_array_q_13;    
            WHEN "0100000000000000" =>
                        data_out1_i <= ram_array_q_14;    
            WHEN "1000000000000000" =>
                        data_out1_i <= ram_array_q_15;    
            WHEN OTHERS =>
                        NULL;
            
        END CASE;
        CASE addr_rd2 IS
            -- synopsys parallel_case full_case
            
            WHEN "0000000000000001" =>
                        data_out2_i <= ram_array_q_0;    
            WHEN "0000000000000010" =>
                        data_out2_i <= ram_array_q_1;    
            WHEN "0000000000000100" =>
                        data_out2_i <= ram_array_q_2;    
            WHEN "0000000000001000" =>
                        data_out2_i <= ram_array_q_3;    
            WHEN "0000000000010000" =>
                        data_out2_i <= ram_array_q_4;    
            WHEN "0000000000100000" =>
                        data_out2_i <= ram_array_q_5;    
            WHEN "0000000001000000" =>
                        data_out2_i <= ram_array_q_6;    
            WHEN "0000000010000000" =>
                        data_out2_i <= ram_array_q_7;    
            WHEN "0000000100000000" =>
                        data_out2_i <= ram_array_q_8;    
            WHEN "0000001000000000" =>
                        data_out2_i <= ram_array_q_9;    
            WHEN "0000010000000000" =>
                        data_out2_i <= ram_array_q_10;    
            WHEN "0000100000000000" =>
                        data_out2_i <= ram_array_q_11;    
            WHEN "0001000000000000" =>
                        data_out2_i <= ram_array_q_12;    
            WHEN "0010000000000000" =>
                        data_out2_i <= ram_array_q_13;    
            WHEN "0100000000000000" =>
                        data_out2_i <= ram_array_q_14;    
            WHEN "1000000000000000" =>
                        data_out2_i <= ram_array_q_15;    
            WHEN OTHERS =>
                        NULL;
            
        END CASE;
    END PROCESS;

    -- Modelling the write port 
    PROCESS
    BEGIN
        WAIT UNTIL (clk'EVENT AND clk = '1') OR (rst_l'EVENT AND rst_l = '0');
        IF (NOT rst_l = '1') THEN
            ram_array_q_0 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_1 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_2 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_3 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_4 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_5 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_6 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_7 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_8 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_9 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_10 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_11 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_12 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_13 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_14 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_15 <= "00000000000000" AFTER (write_access_time * 1 ps);    
        ELSE
            ram_array_q_0 <= ram_array_d_0 AFTER (write_access_time * 1 ps);    
            ram_array_q_1 <= ram_array_d_1 AFTER (write_access_time * 1 ps);    
            ram_array_q_2 <= ram_array_d_2 AFTER (write_access_time * 1 ps);    
            ram_array_q_3 <= ram_array_d_3 AFTER (write_access_time * 1 ps);    
            ram_array_q_4 <= ram_array_d_4 AFTER (write_access_time * 1 ps);    
            ram_array_q_5 <= ram_array_d_5 AFTER (write_access_time * 1 ps);    
            ram_array_q_6 <= ram_array_d_6 AFTER (write_access_time * 1 ps);    
            ram_array_q_7 <= ram_array_d_7 AFTER (write_access_time * 1 ps);    
            ram_array_q_8 <= ram_array_d_8 AFTER (write_access_time * 1 ps);    
            ram_array_q_9 <= ram_array_d_9 AFTER (write_access_time * 1 ps);    
            ram_array_q_10 <= ram_array_d_10 AFTER (write_access_time * 1 ps);    
            ram_array_q_11 <= ram_array_d_11 AFTER (write_access_time * 1 ps);    
            ram_array_q_12 <= ram_array_d_12 AFTER (write_access_time * 1 ps);    
            ram_array_q_13 <= ram_array_d_13 AFTER (write_access_time * 1 ps);    
            ram_array_q_14 <= ram_array_d_14 AFTER (write_access_time * 1 ps);    
            ram_array_q_15 <= ram_array_d_15 AFTER (write_access_time * 1 ps);    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL we'EVENT OR data_reg_0'EVENT OR data_reg_1'EVENT OR data_reg_2'EVENT OR data_reg_3'EVENT OR data_reg_4'EVENT OR data_reg_5'EVENT OR data_reg_6'EVENT OR data_reg_7'EVENT OR data_reg_8'EVENT OR data_reg_9'EVENT OR data_reg_10'EVENT OR data_reg_11'EVENT OR data_reg_12'EVENT OR data_reg_13'EVENT OR data_reg_14'EVENT OR data_reg_15'EVENT OR ram_array_q_0'EVENT OR ram_array_q_1'EVENT OR ram_array_q_2'EVENT OR ram_array_q_3'EVENT OR ram_array_q_4'EVENT OR ram_array_q_5'EVENT OR ram_array_q_6'EVENT OR ram_array_q_7'EVENT OR ram_array_q_8'EVENT OR ram_array_q_9'EVENT OR ram_array_q_10'EVENT OR ram_array_q_11'EVENT OR ram_array_q_12'EVENT OR ram_array_q_13'EVENT OR ram_array_q_14'EVENT OR ram_array_q_15'EVENT;
        IF (we = '1') THEN
            ram_array_d_0 <= data_reg_0 AFTER (write_access_time * 1 ps);    
            ram_array_d_1 <= data_reg_1 AFTER (write_access_time * 1 ps);    
            ram_array_d_2 <= data_reg_2 AFTER (write_access_time * 1 ps);    
            ram_array_d_3 <= data_reg_3 AFTER (write_access_time * 1 ps);    
            ram_array_d_4 <= data_reg_4 AFTER (write_access_time * 1 ps);    
            ram_array_d_5 <= data_reg_5 AFTER (write_access_time * 1 ps);    
            ram_array_d_6 <= data_reg_6 AFTER (write_access_time * 1 ps);    
            ram_array_d_7 <= data_reg_7 AFTER (write_access_time * 1 ps);    
            ram_array_d_8 <= data_reg_8 AFTER (write_access_time * 1 ps);    
            ram_array_d_9 <= data_reg_9 AFTER (write_access_time * 1 ps);    
            ram_array_d_10 <= data_reg_10 AFTER (write_access_time * 1 ps);    
            ram_array_d_11 <= data_reg_11 AFTER (write_access_time * 1 ps);    
            ram_array_d_12 <= data_reg_12 AFTER (write_access_time * 1 ps);    
            ram_array_d_13 <= data_reg_13 AFTER (write_access_time * 1 ps);    
            ram_array_d_14 <= data_reg_14 AFTER (write_access_time * 1 ps);    
            ram_array_d_15 <= data_reg_15 AFTER (write_access_time * 1 ps);    
        ELSE
            ram_array_d_0 <= ram_array_q_0 AFTER (write_access_time * 1 ps);    
            ram_array_d_1 <= ram_array_q_1 AFTER (write_access_time * 1 ps);    
            ram_array_d_2 <= ram_array_q_2 AFTER (write_access_time * 1 ps);    
            ram_array_d_3 <= ram_array_q_3 AFTER (write_access_time * 1 ps);    
            ram_array_d_4 <= ram_array_q_4 AFTER (write_access_time * 1 ps);    
            ram_array_d_5 <= ram_array_q_5 AFTER (write_access_time * 1 ps);    
            ram_array_d_6 <= ram_array_q_6 AFTER (write_access_time * 1 ps);    
            ram_array_d_7 <= ram_array_q_7 AFTER (write_access_time * 1 ps);    
            ram_array_d_8 <= ram_array_q_8 AFTER (write_access_time * 1 ps);    
            ram_array_d_9 <= ram_array_q_9 AFTER (write_access_time * 1 ps);    
            ram_array_d_10 <= ram_array_q_10 AFTER (write_access_time * 1 ps);    
            ram_array_d_11 <= ram_array_q_11 AFTER (write_access_time * 1 ps);    
            ram_array_d_12 <= ram_array_q_12 AFTER (write_access_time * 1 ps);    
            ram_array_d_13 <= ram_array_q_13 AFTER (write_access_time * 1 ps);    
            ram_array_d_14 <= ram_array_q_14 AFTER (write_access_time * 1 ps);    
            ram_array_d_15 <= ram_array_q_15 AFTER (write_access_time * 1 ps);    
        END IF;
    END PROCESS;

END ram16x14_syn_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_ram8x65_syn IS
    GENERIC (
        read_access_time      :  NATURAL := 0;    
        write_access_time     :  NATURAL := 0;    
        ram_width             :  NATURAL := 65
	);  
    PORT (
        rst_l                   : IN std_logic;   
        clk                     : IN std_logic;   
        fifo_wr                 : IN std_logic_vector(7 DOWNTO 0);   
        data_in                 : IN std_logic_vector(64 DOWNTO 0);   
        fifo_re                 : IN std_logic_vector(7 DOWNTO 0);   
        data_out                : OUT std_logic_vector(64 DOWNTO 0));   
END stratixiigx_hssi_ram8x65_syn;

ARCHITECTURE ram8x65_syn_arch OF stratixiigx_hssi_ram8x65_syn IS


    SIGNAL data_out_i               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);  